#ifdef OASIS_IOW_ESM
MODULE oas_cos_vardef

!**** *oas_cos_vardef * - Controls, definitions and variables
!                   for OASIS communications
!
!     AUTHOR.
!     -------
!     2007-1-30 Kristian Mogensen
!
!     MODIFICATIONS.
!     --------------
!     2010-3  Eric Maisonnave: OASIS4
!     2010-11 Eric Maisonnave: COSMO-CLM coupling
!       A. Dobler: adapted to OASIS3
!     2012-08: unified interface for OASIS - COSMO/CLM, Will/Davin/Brauch 
!****

USE data_parameters,     ONLY: &
  ireals,             &
  iintegers

USE mpi
USE mod_prism


IMPLICIT NONE

SAVE

! Debug level of OASIS
!     0 : Minimum debugging
!     1 : Debugging
!     2 : Perfs measurement
!     3 : OASIS restart production

INTEGER(KIND=iintegers) :: &
  debug_oasis,             & ! Debug level of OASIS
  kl_comm, nerror,            & ! Local communicator
  nldi,nlei,nldj,nlej,     & ! halo limits on a local subdomain
  jih,jjh,                 & ! subdomain limit
  iboundstart,jboundstart,  & ! boundline limits limit
  ncomp_id                 ! id returned by prism_init_comp   

INTEGER(KIND=iintegers) :: &
  OASIS_Rcv  = 1,          & ! return code if received field
  OASIS_idle = 0,          & ! return code if nothing was done by OASIS
  PRISM_Success = 0          ! return code if no error in OASIS

INTEGER(KIND=iintegers) :: &
  nulout=6                   ! unit number for joblog file

TYPE :: FLD_CPL                        ! Type for coupling field information
  LOGICAL                 :: laction   ! To be coupled or not
  CHARACTER(LEN = 16)      :: clname    ! Name of the coupling field
  CHARACTER(LEN = 1)      :: clgrid    ! Grid type
  INTEGER(KIND=iintegers) :: nid       ! Id of the field
END TYPE FLD_CPL

TYPE(FLD_CPL), ALLOCATABLE :: &
  srcv(:),                 & ! All fields to be received
  ssnd(:)                    ! All fields to be sent

REAL(KIND=ireals), ALLOCATABLE :: &
  exfld1 (:,:),             & ! Temporary buffer for receiving
  frcv  (:,:,:)                ! all fields recieved from coupled model

REAL(KIND=ireals), ALLOCATABLE :: &
  zmask_tot (:,:)  !sandra mask should be visible in complete module 12092018 

REAL(KIND=ireals), ALLOCATABLE :: &
  zmask     (:,:),        &  ! sandra mask should be visible in complete module 12092018
  zmask_u     (:,:),        &  
  zmask_v    (:,:),        &  
  fmask     (:,:),        &  ! mask with float number corresponding to coupled fraction of atmospheric grid cell (t grid)
  fmask_u     (:,:),        &  ! mask with float number corresponding to coupled fraction of atmospheric grid cell (u grid)
  fmask_v     (:,:),        &  ! mask with float number corresponding to coupled fraction of atmospheric grid cell (v grid)
  fmask_tot (:,:) 

LOGICAL :: &
  lpe_cpl = .FALSE.

CHARACTER(LEN= 5) ::       &
  ytype_lsm,               & ! type of Land Surface Model:
                             ! 'terra' (default)
                             ! 'clmXX' = Community Land Model of version XX
  ytype_oce                  ! type of Ocean Model
                             ! 'nooce' = no coupled ocean (default)
                             ! 'flxcl' = Coupling to IOW_ESM flux_calculator

INTEGER(KIND=iintegers) :: &
  nfld,                    & !
  nfld_snd_tot,            & ! total number of fields to be sent
  nfld_rcv_tot,            & ! total number of fields to be received
  nfld_snd_flc,            & ! number of fields to be sent to flux calculator
  nfld_rcv_flc,            & ! number of fields to be received from flux calculator
  nfld_rcv_flc_early,      & ! how many of these are fetched before radiation and precipitation calculation
  dt_cp,                   & ! coupling time step
  CPL_FLG                    ! coupling flag: 1.0 means coupled, 0.0 not

INTEGER(KIND=iintegers), ALLOCATABLE :: &
  nlev_snd_flc(:),         & ! number of levels per field to be sent to flux calculator
  nlev_rcv_flc(:)            ! number of levels per field to be received from flux calculator

CHARACTER(LEN=16), ALLOCATABLE :: &
  nam_snd_flc(:),          & ! names of fields to be sent to flux calculator
  nam_rcv_flc(:)             ! names of fields to be received from flux calculator

END MODULE oas_cos_vardef
#endif
