#ifdef OASIS_IOW_ESM
SUBROUTINE oas_cos_snd( kid, kstep, pdata1, kinfo)

!!---------------------------------------------------------------------
!!              ***  ROUTINE oas_cos_snd  ***
!!
!! ** Purpose : - At each coupling time-step,this routine sends fields
!!                to the coupler or remote application.
!!----------------------------------------------------------------------

USE data_parameters,  ONLY : &
  ireals,                    &
  iintegers

USE data_modelconfig, ONLY : &
  ie,                        &
  je

USE data_parallel,    ONLY : &
  my_cart_id

USE oas_cos_vardef

IMPLICIT NONE

!! * Arguments
!!
INTEGER(KIND=iintegers), INTENT(IN)    ::  &
  kid    ! variable index in the array

INTEGER(KIND=iintegers), INTENT(OUT)   ::  &
  kinfo  ! OASIS info argument

INTEGER(KIND=iintegers), INTENT(IN)    ::  &
  kstep  ! time-step in seconds

REAL(KIND=ireals), INTENT(IN)          ::  &
  pdata1(ie,je)



!!
!! * Local variables
!!
!!
!!--------------------------------------------------------------------
!
IF ( lpe_cpl ) THEN
  !
  !
  ! prepare array (only valid shape, without halos) for OASIS
  !


  exfld1(nldi:nlei, nldj:nlej) = pdata1(nldi:nlei, nldj:nlej)

 IF ( debug_oasis > 15 ) THEN
    WRITE(nulout,*) '************ in oas_cos_snd *********'
    WRITE(nulout,*) 'prism_put: Incoming ', ssnd(kid)%clname
    WRITE(nulout,*) 'prism_put: ivarid '  , ssnd(kid)%nid
    WRITE(nulout,*) 'prism_put:   kstep', kstep
    WRITE(nulout,*) '     - Minimum value is ', MINVAL(exfld1(nldi:nlei, nldj:nlej))
    WRITE(nulout,*) '     - Maximum value is ', MAXVAL(exfld1(nldi:nlei, nldj:nlej))
    WRITE(nulout,*) '     -     Sum value is ', SUM(exfld1(nldi:nlei, nldj:nlej))
    WRITE(nulout,*) '*************************************'
    CALL flush(nulout)
  ENDIF

  ! Call OASIS at each time step but field is sent to other model only at coupling time step
  ! (accumulation otherwise, if asked in the namcouple configuration file)
  !
  CALL prism_put_proto( ssnd(kid)%nid, kstep, exfld1(nldi:nlei, nldj:nlej), kinfo)

ENDIF ! lpe_cpl

END SUBROUTINE oas_cos_snd
#endif
