#ifdef OASIS_IOW_ESM
SUBROUTINE oas_cos_rcv( kid, kstep, pdata, kinfo )

!!---------------------------------------------------------------------
!!              ***  ROUTINE oas_cos_rcv  ***
!!
!! ** Purpose : - At each coupling time-step,this routine call fields
!!                from the coupler or remote application.
!!----------------------------------------------------------------------

USE data_parameters,    ONLY : & 
  ireals,                      &
  iintegers

USE data_modelconfig,   ONLY : &
  ie,                          &
  je

USE data_parallel,      ONLY : &
  my_cart_id

USE oas_cos_vardef

IMPLICIT NONE

INTEGER(kind=iintegers), INTENT(IN)   :: &
  kid    ! variable index in the array

INTEGER(kind=iintegers), INTENT(IN)   :: &
  kstep  ! time-step in seconds

REAL(kind=ireals), INTENT(OUT)        :: &
  pdata(ie,je)

INTEGER(kind=iintegers), INTENT(OUT)  :: &
  kinfo  ! OASIS info argument

!!
!! local variables
!!
LOGICAL :: &
  llaction
!!--------------------------------------------------------------------

!  Masked points are not modified by OASIS
!  = buffer set to 0 before calling OASIS
!SW 2013-10-21
!exfld(:,:) = 0.0_ireals
exfld1(:,:) = 0.0_ireals
!SW end

IF (lpe_cpl) THEN

  ! receive local data from OASIS on every process involved in the coupling
!SW 2013-10-21
!  CALL prism_get_proto ( srcv(kid)%nid, kstep, exfld(nldi:nlei, nldj:nlej), kinfo )   
#ifdef IOW_ESM_DEBUG  
  WRITE(*,*) 'BEFORE prism_get_proto'
#endif
  CALL prism_get_proto ( srcv(kid)%nid, kstep, exfld1(nldi:nlei, nldj:nlej), kinfo ) 
#ifdef IOW_ESM_DEBUG        
  WRITE(*,*) 'AFTER prism_get_proto'
#endif
!SW end
  IF ( nerror /= PRISM_Success) THEN
    CALL prism_abort_proto( srcv(kid)%nid, 'oas_cos_rcv', &
      'Failure in prism_get_proto for '//TRIM(srcv(kid)%clname) )
  ENDIF

  llaction = .false.
  IF( kinfo == PRISM_Recvd   .OR. kinfo == PRISM_FromRest .OR.   &
      kinfo == PRISM_RecvOut .OR. kinfo == PRISM_FromRestOut .OR. kinfo == PRISM_Input)   llaction = .TRUE.
       
  ! If coupling time step
  IF ( llaction ) THEN

    ! Declare to calling routine that OASIS provided coupling field
    kinfo = OASIS_Rcv

    ! Update array which contains coupling field (only on valid shape)
!SW 2013-10-21
!     pdata(nldi:nlei, nldj:nlej) = exfld(nldi:nlei, nldj:nlej)
     pdata(nldi:nlei, nldj:nlej) = exfld1(nldi:nlei, nldj:nlej)
!SW end

    IF ( debug_oasis > 15 ) THEN
      WRITE(nulout,*) '************ in oas_cos_rcv *********'
      WRITE(nulout,*) 'prism_get_proto: Incoming ', srcv(kid)%clname
      WRITE(nulout,*) 'prism_get_proto: ivarid '  , srcv(kid)%nid
      WRITE(nulout,*) 'prism_get_proto:   kstep', kstep
      WRITE(nulout,*) 'prism_get_proto:   info ', kinfo
      WRITE(nulout,*) '     - Minimum value is ', MINVAL(pdata)
      WRITE(nulout,*) '     - Maximum value is ', MAXVAL(pdata)
      WRITE(nulout,*) '     -     Sum value is ', SUM(pdata)
      WRITE(nulout,*) '*************************************'
      CALL flush(nulout)
    ENDIF
  ELSE
    ! Declare to calling routine that OASIS did not provide coupling field
    kinfo = OASIS_idle     
  ENDIF

ENDIF ! lpe_cpl

END SUBROUTINE oas_cos_rcv
#endif
