#ifdef OASIS_IOW_ESM
SUBROUTINE oas_cos_init 

!**** *INIOASIS*  - Initialize coupled mode communication
!
!     Purpose.
!     --------
!     Initialize coupler to get the MPI communicator
!
!**   Interface.
!     ----------
!       *CALL*  *oas_cos_init*
!
!     Input:
!     -----
!
!     Output:
!     ------
!       MPLUSERCOMM in MPL_MODULE is updated.
!
!     Method:
!     ------
!       OASIS usage is controlled by environment variables
!
!     Externals:
!     ---------
!       GETENV - Get enviroment variables
!       prism_init, prism_init_comp, prism_get_localcomm, prism_abort : prism library
!
!     Reference:
!     ---------
!       S. Valcke, R. Redler, 2007: OASIS4 User Guide ,
!       PRISM Support Initiative Report No 4,
!       CERFACS, Toulouse, France, 60 pp.
!
!     Author:
!     -------
!       R. Redler, NEC Laboratories Europe
!       K. Mogensen, ECMWF
!
!     Modifications.
!     --------------
!       E. Maisonnave : adapted to COSMO
!       A. Dobler: adapted to OASIS3
!

USE oas_cos_vardef

IMPLICIT NONE
   
CHARACTER(LEN=6)   :: modname = 'cosmoc'    ! Name of the model

      
!------------------------------------------------------------------
! 1) Initialize the PRISM system for the component
!------------------------------------------------------------------
CALL prism_init_comp_proto( ncomp_id, modname, nerror )
IF( nerror /= PRISM_Success ) THEN
  CALL prism_abort_proto( ncomp_id, 'oas_cos_init', 'Failure in prism_init_comp' )
ENDIF

!------------------------------------------------------------------
! 2) Get an MPI communicator for COSMO local communication
!------------------------------------------------------------------

CALL prism_get_localcomm_proto( kl_comm, nerror )
IF( nerror /= PRISM_Success ) THEN
  CALL prism_abort_proto( ncomp_id, 'oas_cos_init', 'Failure in prism_get_localcomm' )
ENDIF

END SUBROUTINE oas_cos_init
#endif
