MODULE YOERAD

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOERAD* - CONTROL OPTIONS FOR RADIATION CONFIGURATION
!     ------------------------------------------------------------------

INTEGER(KIND=JPIM) :: NAER
INTEGER(KIND=JPIM) :: NMODE
INTEGER(KIND=JPIM) :: NOZOCL
INTEGER(KIND=JPIM) :: NRADFR
INTEGER(KIND=JPIM) :: NRADPFR
INTEGER(KIND=JPIM) :: NRADPLA
INTEGER(KIND=JPIM) :: NRINT
INTEGER(KIND=JPIM) :: NRADINT
INTEGER(KIND=JPIM) :: NRADRES
INTEGER(KIND=JPIM) :: NRADNFR
INTEGER(KIND=JPIM) :: NRADSFR
INTEGER(KIND=JPIM) :: NOVLP
INTEGER(KIND=JPIM) :: NRPROMA
INTEGER(KIND=JPIM) :: NLW
INTEGER(KIND=JPIM) :: NSW
INTEGER(KIND=JPIM) :: NTSW
INTEGER(KIND=JPIM) :: NCSRADF

INTEGER(KIND=JPIM) :: NICEOPT
INTEGER(KIND=JPIM) :: NLIQOPT
INTEGER(KIND=JPIM) :: NRADIP
INTEGER(KIND=JPIM) :: NRADLP

INTEGER(KIND=JPIM) :: NLNGR1H
LOGICAL LERAD1H
LOGICAL LERADHS
LOGICAL LEPO3RA
LOGICAL LRADLB
LOGICAL LONEWSW
LOGICAL LOWASYF
LOGICAL LOWHSSS
LOGICAL LOIFUEC
LOGICAL LECSRAD
LOGICAL LECO2VAR
LOGICAL LRRTM
LOGICAL LINHOM
LOGICAL LHVOLCA
LOGICAL LNEWAER
LOGICAL LRADIP
LOGICAL LRADLP
LOGICAL LRAYL
LOGICAL LOPTRPROMA
CHARACTER*256 CRTABLEDIR
CHARACTER*32  CRTABLEFIL
LOGICAL LCCNL
LOGICAL LCCNO

REAL(KIND=JPRB) :: RAOVLP, RBOVLP
REAL(KIND=JPRB) :: RCCNLND, RCCNSEA


!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
! LERAD1H: LOGICAL : .T. TO ALLOW MORE FREQUENT RADIATION CALCULATIONS
!                  : DURING FIRST N HOURS OF FORECAST
! NLNGR1H: INTEGER : NUMBER FORECAST HOURS DURING WHICH MORE FREQUENT
!                    RADIATION CALCULATIONS ARE REQUIRED
! LERADHS: LOGICAL : .T. IF RAD.COMPUTED ON A COARSER SAMPLED GRID
! LEPO3RA: LOGICAL : .T. IF PROGNOSTIC OZONE (EC) IS PASSED TO RADIATION
! NAER   : INTEGER : CONFIGURATION INDEX FOR AEROSOLS
! NMODE  : INTEGER : CONFIGURATION FOR RADIATION CODE: FLUX VS. RADIANCE
! NOZOCL : INTEGER : CHOICE OF OZONE CLIMATOLOGY (0 old, 1 new)
! NRADFR : INTEGER : FREQUENCY OF FULL RADIATION COMPUTATIONS
!                    IF(NRADFR.GT.0): RAD EVERY 'NRADFR' TIME-STEPS
!                    IF(NRADFR.LT.0): RAD EVERY '-NRADFR' HOURS
! NRADPFR: INTEGER : PRINT FREQUENCY FOR RAD.STATISTICS (in RAD.T.STEPS)
! NRADPLA: INTEGER : PRINT RAD.STATISTICS EVERY 'NRADPLA' ROWS
! NRINT  : INTEGER : INTERPOLATION DISTANCE (in points)
! NRADINT: INTEGER : RADIATION INTERPOLATION METHOD
!                  : 0 = CURRENT RADIATION INTERPOLATION (CONTROLLED BY NRINT)
!                  : 1 = SPECTRAL TRANSFORM INTERPOLATION
!                  : 2 =  4 POINT HORIZONTAL INTERPOLATION
!                  : 3 = 12 POINT HORIZONTAL INTERPOLATION
! NRADRES: INTEGER : RADIATION GRID SPECTRAL RESOLUTION
! NRADNFR: INTEGER : NORMAL   FREQUENCY OF RADIATION STEPS
! NRADSFR: INTEGER : START-UP FREQUENCY OF RADIATION STEPS
! NOVLP  : INTEGER : CLOUD OVERLAP CONFIGURATION
! NRPROMA: INTEGER : VECTOR LENGTH FOR RADIATION CALCULATIONS
! NLW    : INTEGER : NUMBER OF LONGWAVE SPECTRAL INTERVALS    
! NSW    : INTEGER : NUMBER OF SHORTWAVE SPECTRAL INTERVALS    
! NTSW   : INTEGER : MAXIMUM POSSIBLE NUMBER OF SW SPECTRAL INTERVALS    
! LRADLB : LOGICAL : .T. IF RADIATION COURSER GRID IS TO BE LOAD BALANCED
!                  : OVER PROCESSORS (I.E. WHEN NRINT>1)
! LOPTRPROMA:LOGICAL: .T. NRPROMA will be optimised
!                   : .F. NRPROMA will not be optimised (forced
!                   :         by negative NRPROMA in namelist)
!
! LOWASYF: LOGICAL : .F. IF WATER CLOUDS AS FOUQUART (SW)
!                  : .T. IF WATER CLOUDS AS SLINGO   (SW)
! LOWHSSS: LOGICAL : .F. IF WATER CLOUDS AS SMITH-SHI (LW)
!                  : .T. IF WATER CLOUDS AS SAVIJARVI (LW)
! LOIFUEC: LOGICAL : .F. IF ICE CLOUDS AS EBERT-CURRY (LW & SW)
!                  : .T. IF ICE CLOUDS AS FU-LIOU / FU ET AL. (LW & SW)
!
! LONEWSW: LOGICAL : .T. IF NEW SW CODE IS ACTIVE
! LECSRAD: LOGICAL : .T. IF CLEAR-SKY RADIATION IS ARCHIVED AS PEXTR2
! LECO2VAR: LOGICAL: .T. IF TIME-VARYING CO2 IS USED (E.G., ERA40 OR AMIP RUNS)
! NCSRADF: INTEGER : 1 IF ACCUMULATED, 2 IF INSTANTANEOUS
! LRRTM  : LOGICAL : .T. IF RRTM140MR IS USED FOR LW RADIATION TRANSFER
! LINHOM : LOGICAL : .T. INHOMOGENEITY EFFECT, ON BOTH LW & SW RADIATION
!                    ON BOTH STRATIFORM & CONVECTIVE CLOUDS
! LHVOLCA: LOGICAL : .T. IF GISS HISTORY OF VOLCANIC AEROSOLS IS ON
! LNEWAER: LOGICAL : .T. IF AEROSOL MONTHLY DISTRIBUTIONS ARE USED
! LRADLP : LOGICAL : .T. IF CLOUD WATER EFFECTIVE RADIUS IS COMPUTED
! LRADIP : LOGICAL : .F. IF CHRIS'S 21R3 ICE EFFECTIVE RADIUS IS USED
! CRTABLEDIR: CHAR : IF NRADINT > 0 SPECIFIES DIRECTORY PATH FOR RADIATION
!                  : GRID RTABLE NAMELIST
! CRTABLEFIL: CHAR : IF NRADINT > 0 SPECIFIES FILE NAME OF RADIATION 
!                  : GRID RTABLE NAMELIST
! LRAYL  : LOGICAL : .T. NEW RAYLEIGH FOR SW-6 VERSION

! RAOVLP : REAL    : COEFFICIENTS FOR ALPHA1 FACTOR IN HOGAN & 
! RBOVLP : REAL    : ILLINGWORTH's PARAMETRIZATION

! LCCNL  : LOGICAL : .T. IF CCN CONCENTRATION OVER LAND IS DIAGNOSED
! LCCNO  : LOGICAL : .T. IF CCN CONCENTRATION OVER OCEAN IS DIAGNOSED
! RCCNLND: REAL    : NUMBER CONCENTRATION (CM-3) OF CCNs OVER LAND
! RCCNSEA: REAL    : NUMBER CONCENTRATION (CM-3) OF CCNs OVER SEA

! NICEOPT: INTEGER : INDEX FOR ICE CLOUD OPTICAL PROPERTIES
! NLIQOPT: INTEGER : INDEX FOR LIQUID WATER CLOUD OPTICAL PROPERTIES
! NRADIP : INTEGER : INDEX FOR DIAGNOSIS OF ICE CLOUD EFFECTIVE RADIUS
! NRADLP : INTEGER : INDEX FOR DIAGNOSIS OF LIQ. CLOUD EFFECTIVE RADIUS
!     ------------------------------------------------------------------
END MODULE YOERAD
