MODULE YOEPHLI

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOEPHLI* CONTAINS CONSTANTS FOR THE LINEARIZED PHYSICS
!     ------------------------------------------------------------------

LOGICAL LPHYLIN
LOGICAL LENOPERT
LOGICAL LRAISANEN

REAL(KIND=JPRB) :: RLPTRC
REAL(KIND=JPRB) :: RLPAL1
REAL(KIND=JPRB) :: RLPAL2
REAL(KIND=JPRB) :: RLPBB
REAL(KIND=JPRB) :: RLPCC
REAL(KIND=JPRB) :: RLPDD
REAL(KIND=JPRB) :: RLPMIXL
REAL(KIND=JPRB) :: RLPBETA
REAL(KIND=JPRB) :: RLPDRAG
REAL(KIND=JPRB) :: RLPEVAP
REAL(KIND=JPRB) :: RLPP00

!*     *YOEPHLI* CONTAINS CONSTANTS NEEDED BY 
!     THE LINEARIZED PHYSICS


!     J.F. MAHFOUF        E.C.M.W.F.    23/06/96


!     NAME        TYPE     DESCRIPTION
!     ----        ----     -----------

!     *RLPTRC*    REAL     CRITICAL TEMPERATURE FOR MIXED PHASE PROPERTIES
!                          OF WATER 
!     *RLPAL1*    REAL     SMOOTHING COEFFICIENT
!     *RLPAL2*    REAL     SMOOTHING COEFFICIENT
!     *RLPBB*     REAL     CONSTANT FROM THE LOUIS ET AL. FORMULATION
!     *RLPCC*     REAL     CONSTANT FROM THE LOUIS ET AL. FORMULATION
!     *RLPDD*     REAL     CONSTANT FROM THE LOUIS ET AL. FORMULATION
!     *RLPMIXL*   REAL     PSEUDO DEPTH OF THE PLANETARY BOUNDARY LAYER
!     *RLPBETA*   REAL     REDUCTION FACTOR OF THE ASYMPTOTIC MIXING LENGTH
!     *RLPDRAG*   REAL     COEFFICIENT FOR THE ESTIMATION OF SURFACE DRAG
!     *RLPEVAP*   REAL     FRACTION OF POSSIBLE RAINFALL EVAPORATION
!     *RLPP00*    REAL     PRESSURE ABOVE WHICH RADIATION IS NOT APPLIED
!     *LPHYLIN*   LOGICAL  TRUE WHEN LINEARIZED PHYSICS IS ACTIVATED 
!     *LENOPERT   LOGICAL  TRUE WHEN NO PERTURBATION IS REQUIRED
!                          FOR SURFACE ARRAYS
!     *LRAISANEN   LOGICAL  TRUE WHEN RAISANEN OVERLAP SCHEME IS
!                           ACTIVATED
!     ------------------------------------------------------------------
END MODULE YOEPHLI
