MODULE YOECUMF

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ----------------------------------------------------------------
!*    ** *YOECUMF* - PARAMETERS FOR CUMULUS MASSFLUX SCHEME
!     ----------------------------------------------------------------

REAL(KIND=JPRB) :: ENTRPEN
REAL(KIND=JPRB) :: ENTRSCV
REAL(KIND=JPRB) :: ENTRMID
REAL(KIND=JPRB) :: ENTRORG
REAL(KIND=JPRB) :: ENTRDD
REAL(KIND=JPRB) :: RMFCFL
REAL(KIND=JPRB) :: RMFLIC
REAL(KIND=JPRB) :: RMFLIA
REAL(KIND=JPRB) :: RMFSOLUV
REAL(KIND=JPRB) :: RMFSOLTQ
REAL(KIND=JPRB) :: RMFSOLCT
REAL(KIND=JPRB) :: RMFCMAX
REAL(KIND=JPRB) :: RMFCMIN
REAL(KIND=JPRB) :: RMFDEPS
REAL(KIND=JPRB) :: RDEPTHS
REAL(KIND=JPRB) :: RHCDD
REAL(KIND=JPRB) :: RPRCON
REAL(KIND=JPRB) :: RTAU
REAL(KIND=JPRB) :: RCPECONS
REAL(KIND=JPRB) :: RCUCOV
REAL(KIND=JPRB) :: RTAUMEL
REAL(KIND=JPRB) :: RHEBC
REAL(KIND=JPRB) :: RUVPER

LOGICAL :: LMFPEN
LOGICAL :: LMFSCV
LOGICAL :: LMFMID
LOGICAL :: LMFDD
LOGICAL :: LMFIT
LOGICAL :: LMFDUDV
LOGICAL :: LMFSMOOTH
LOGICAL :: LMFTRAC
LOGICAL :: LMFWSTAR
INTEGER(KIND=JPIM) :: NJKT1, NJKT2, NJKT3, NJKT4, NJKT5

!*    ** *YOECUMF* - PARAMETERS FOR CUMULUS MASSFLUX SCHEME

!     M.TIEDTKE       E. C. M. W. F.      18/1/89

!     NAME      TYPE      PURPOSE
!     ----      ----      -------

!     LMFPEN    LOGICAL  TRUE IF PENETRATIVE CONVECTION IS SWITCHED ON
!     LMFSCV    LOGICAL  TRUE IF SHALLOW     CONVECTION IS SWITCHED ON
!     LMFMID    LOGICAL  TRUE IF MIDLEVEL    CONVECTION IS SWITCHED ON
!     LMFDD     LOGICAL  TRUE IF CUMULUS DOWNDRAFT      IS SWITCHED ON
!     LMFIT     LOGICAL  TRUE IF UPDRAUGHT ITERATION
!     LMFDUDV   LOGICAL  TRUE IF CUMULUS FRICTION       IS SWITCHED ON
!     LMFSMOOTH LOGICAL  TRUE IF MASS FLUXES TOP/BOTTOM SMOOTHED FOR TRACER TRANSPORT
!     LMFTRAC   LOGICAL  TRUE IF CONVECTIVE TRACER TRANSPORT IS SWITCHED ON
!     LMFWSTAR  LOGICAL  TRUE IF GRANT W* CLOSURE USED FOR SHALLOW
!     ENTRPEN   REAL     ENTRAINMENT RATE FOR PENETRATIVE CONVECTION
!     ENTRSCV   REAL     ENTRAINMENT RATE FOR SHALLOW CONVECTION
!     ENTRMID   REAL     ENTRAINMENT RATE FOR MIDLEVEL CONVECTION
!     ENTRORG   REAL     COEFFICIENT FOR ORGANIZED ENTRAINMENT DEEP CONVECTION
!     ENTRDD    REAL     ENTRAINMENT RATE FOR CUMULUS DOWNDRAFTS
!     RMFCMAX   REAL     MAXIMUM MASSFLUX VALUE ALLOWED FOR
!     RMFCMIN   REAL     MINIMUM MASSFLUX VALUE (FOR SAFETY)
!     RMFDEPS   REAL     FRACTIONAL MASSFLUX FOR DOWNDRAFTS AT LFS
!     RDEPTHS   REAL     MAXIMUM ALLOWED CLOUD THICKNESS FOR SHALLOW
!     RHCDD     REAL     RELATIVE SATURATION IN DOWNDRAFTS
!     RPRCON    REAL     COEFFICIENTS FOR DETERMINING CONVERSION
!                        FROM CLOUD WATER TO RAIN
!     RCPECONS  REAL     COEFFICIENT FOR RAIN EVAPORATION BELOW CLOUD
!     RCUCOV    REAL     CONVECTIVE CLOUD COVER FOR RAIN EVPORATION
!     RTAUMEL   REAL     TIME CONSTANT FOR MELTING
!     RHEBC     REAL     REL. HUMIDITY BELOW CLOUD FOR WHICH EVAPORATION STARTS
!     RTAU      REAL     ADJUSTMENT TIME SCALE IN CAPE CLOSURE
!     RMFCFL    REAL     MULTIPLE OF CFL STABILITY CRITERIUM 
!     RMFLIC    REAL     USE CFL (1) OR ABSOLUT MASS FLUX LIMIT (0)
!     RMFLIA    REAL     VALUE OF ABSOLUT MASS FLUX LIMIT
!     RMFSOLCT  REAL     SOLVER FOR MASSFLUX ADVECTION EQUATION FOR TRACERS
!                        0 : EXPLICIT  0-1 : SEMI-IMPLICIT >=1 : FULLY IMPLICIT
!     RMFSOLUV  REAL     SOLVER FOR MASSFLUX ADVECTION EQUATION FOR MOMENTUM
!     RMFSOLTQ  REAL     SOLVER FOR MASSFLUX ADVECTION EQUATION FOR T AND Q
!     RUVPER    REAL     UPDRAIGHT VELOCITY PERTURBATION AT KLEV FOR IMPLICIT
!     NJKT1, NJKT2, NJKT3-5 INTEGER  LEVEL LIMITS FOR CUBASEN/CUDDR
!     ----------------------------------------------------------------
END MODULE YOECUMF
