MODULE YOECLDP

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE


!     -----------------------------------------------------------------
!     ** YOECLDP - CONTROL PARAMETERS FOR PROGNOSTIC CLOUD SCHEME
!     -----------------------------------------------------------------

!     * E.C.M.W.F. PHYSICS PACKAGE *

!     C. JAKOB        E.C.M.W.F.          94/02/07


!      NAME     TYPE      PURPOSE
!      ----     ----      -------

!     *RAMID*   REAL      BASE VALUE FOR CALCULATION OF RELATIVE 
!                         HUMIDITY THRESHOLD FOR ONSET OF STRATIFORM
!                         CONDENSATION (TIEDTKE, 1993, EQUATION 24)
!     *RCLDIFF* REAL      DIFFUSION-COEFFICIENT FOR EVAPORATION BY
!                         TURBULENT MIXING (IBID., EQU. 30)
!     *RCLCRIT* REAL      BASE VALUE OF CRITICAL CLOUD WATER CONTENT 
!                         FOR CONVERSION TO RAIN (SUNDQUIST, 1988)
!     *RKCONV*  REAL      BASE VALUE FOR CONVERSION COEFFICIENT (IBID.)
!     *RPRC1*   REAL      COALESCENCE CONSTANT (IBID.)
!     *RPRC2*   REAL      BERGERON-FINDEISEN CONSTANT (IBID.)
!     *RCLDMAX* REAL      MAXIMUM CLOUD WATER CONTENT
!     *RPECONS* REAL      EVAPORATION CONSTANT AFTER KESSLER 
!                         (TIEDTKE, 1993, EQU.35)
!     *RTAUMEL* REAL      RELAXATION TIME FOR MELTING OF SNOW
!     *RENTRTU* REAL      ENTRAINMENT PARAMETER (DEARDOFF, 1976)
!     *RENTRRA* REAL      ENTRAINMENT PARAMETER FOR RADIATION EFFECT
!     *RAMIN*   REAL      LIMIT FOR A
!     *RLMIN*   REAL      LIMIT FOR L
!     *RSATQ*   REAL      LIMIT FOR SATURATION CHECK
!     *RASMICE*   REAL    COEFFICIENT FOR "SMALL ICE" CALCULATION 
!                         (MACFARQUHAR AND HEYMSFIELD, JAS, 1997)
!     *RBSMICE*   REAL    COEFFICIENT FOR "SMALL ICE" CALCULATION 
!                         (MACFARQUHAR AND HEYMSFIELD, JAS, 1997)
REAL(KIND=JPRB) :: RAMID
REAL(KIND=JPRB) :: RCLDIFF
REAL(KIND=JPRB) :: RCLCRIT
REAL(KIND=JPRB) :: RKCONV
REAL(KIND=JPRB) :: RPRC1
REAL(KIND=JPRB) :: RPRC2
REAL(KIND=JPRB) :: RCLDMAX
REAL(KIND=JPRB) :: RPECONS
REAL(KIND=JPRB) :: RTAUMEL
REAL(KIND=JPRB) :: RENTRTU
REAL(KIND=JPRB) :: RENTRRA
REAL(KIND=JPRB) :: RAMIN
REAL(KIND=JPRB) :: RLMIN
REAL(KIND=JPRB) :: RSATQ
REAL(KIND=JPRB) :: RASMICE
REAL(KIND=JPRB) :: RBSMICE
END MODULE YOECLDP
