!OPTIONS XOPT(HSFUN)
SUBROUTINE CUFLXN &
 & (  KIDIA,    KFDIA,    KLON,     KTDIA,   KLEV,&
 & PTSPHY,&
 & PTEN,     PQEN,     PQSEN,    PTENH,    PQENH,&
 & PAPH,     PAP,      PGEOH,    LDLAND,   LDCUM,&
 & KCBOT,    KCTOP,    KDTOP,    KTOPM2,&
 & KTYPE,    LDDRAF,&
 & PMFU,     PMFD,     PMFUS,    PMFDS,&
 & PMFUQ,    PMFDQ,    PMFUL,    PLUDE,&
 & PDMFUP,   PDMFDP,   PDPMEL,   PLGLAC,&
 & PMFLXR,   PMFLXS,   PRAIN,    PMFDDE_RATE )  

!          M.TIEDTKE         E.C.M.W.F.     7/86 MODIF. 12/89

!          PURPOSE
!          -------

!          THIS ROUTINE DOES THE FINAL CALCULATION OF CONVECTIVE
!          FLUXES IN THE CLOUD LAYER AND IN THE SUBCLOUD LAYER

!          INTERFACE
!          ---------
!          THIS ROUTINE IS CALLED FROM *CUMASTR*.

!     PARAMETER     DESCRIPTION                                   UNITS
!     ---------     -----------                                   -----
!     INPUT PARAMETERS (INTEGER):

!    *KIDIA*        START POINT
!    *KFDIA*        END POINT
!    *KLON*         NUMBER OF GRID POINTS PER PACKET
!    *KTDIA*        START OF THE VERTICAL LOOP
!    *KLEV*         NUMBER OF LEVELS
!    *KCBOT*        CLOUD BASE LEVEL
!    *KCTOP*        CLOUD TOP LEVEL
!    *KDTOP*        TOP LEVEL OF DOWNDRAFTS

!    INPUT PARAMETERS (LOGICAL):

!    *LDLAND*       LAND SEA MASK (.TRUE. FOR LAND)
!    *LDCUM*        FLAG: .TRUE. FOR CONVECTIVE POINTS

!    INPUT PARAMETERS (REAL):

!    *PTSPHY*       TIME STEP FOR THE PHYSICS                       S
!    *PTEN*         PROVISIONAL ENVIRONMENT TEMPERATURE (T+1)       K
!    *PQEN*         PROVISIONAL ENVIRONMENT SPEC. HUMIDITY (T+1)  KG/KG
!    *PQSEN*        ENVIRONMENT SPEC. SATURATION HUMIDITY (T+1)   KG/KG
!    *PTENH*        ENV. TEMPERATURE (T+1) ON HALF LEVELS           K
!    *PQENH*        ENV. SPEC. HUMIDITY (T+1) ON HALF LEVELS      KG/KG
!    *PAPH*         PROVISIONAL PRESSURE ON HALF LEVELS            PA
!    *PAP*          PROVISIONAL PRESSURE ON FULL LEVELS            PA
!    *PGEOH*        GEOPOTENTIAL ON HALF LEVELS                   M2/S2

!    UPDATED PARAMETERS (INTEGER):

!    *KTYPE*        SET TO ZERO IF LDCUM=.FALSE.

!    UPDATED PARAMETERS (LOGICAL):

!    *LDDRAF*       SET TO .FALSE. IF LDCUM=.FALSE. OR KDTOP<KCTOP   

!    UPDATED PARAMETERS (REAL):

!    *PMFU*         MASSFLUX IN UPDRAFTS                          KG/(M2*S)
!    *PMFD*         MASSFLUX IN DOWNDRAFTS                        KG/(M2*S)
!    *PMFUS*        FLUX OF DRY STATIC ENERGY IN UPDRAFTS          J/(M2*S)
!    *PMFDS*        FLUX OF DRY STATIC ENERGY IN DOWNDRAFTS        J/(M2*S)
!    *PMFUQ*        FLUX OF SPEC. HUMIDITY IN UPDRAFTS            KG/(M2*S)
!    *PMFDQ*        FLUX OF SPEC. HUMIDITY IN DOWNDRAFTS          KG/(M2*S)
!    *PMFUL*        FLUX OF LIQUID WATER IN UPDRAFTS              KG/(M2*S)
!    *PLUDE*        DETRAINED LIQUID WATER                        KG/(M3*S)
!    *PDMFUP*       FLUX DIFFERENCE OF PRECIP. IN UPDRAFTS        KG/(M2*S)
!    *PDMFDP*       FLUX DIFFERENCE OF PRECIP. IN DOWNDRAFTS      KG/(M2*S)
!    *PMFDDE_RATE*  DOWNDRAFT DETRAINMENT RATE                    KG/(M2*S)

!    OUTPUT PARAMETERS (REAL):

!    *PDPMEL*       CHANGE IN PRECIP.-FLUXES DUE TO MELTING       KG/(M2*S)
!    *PLGLAC*       FLUX OF FROZEN CLOUD WATER IN UPDRAFTS        KG/(M2*S)
!    *PMFLXR*       CONVECTIVE RAIN FLUX                          KG/(M2*S)
!    *PMFLXS*       CONVECTIVE SNOW FLUX                          KG/(M2*S)
!    *PRAIN*        TOTAL PRECIP. PRODUCED IN CONV. UPDRAFTS      KG/(M2*S)
!                   (NO EVAPORATION IN DOWNDRAFTS)

!          EXTERNALS
!          ---------
!          NONE

!          MODIFICATIONS
!          -------------
!             99-06-14 : Optimisation        D.SALMOND
!             03-08-28 : Clean up LINPHYS    P.BECHTOLD
!                        Bugs in Evapor.
!             05-02-11 : Extend DDMflux to   P.BECHTOLD
!                        surface if zero
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!----------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOMCST   , ONLY : RG       ,RCPD     ,RLVTT    ,RLSTT    ,RLMLT    ,RTT
USE YOETHF   , ONLY : R2ES     ,R3LES    ,R3IES    ,R4LES    ,&
 & R4IES    ,R5LES    ,R5IES    ,R5ALVCP  ,R5ALSCP  ,&
 & RALVDCP  ,RALSDCP  ,RTWAT    ,RTICE    ,RTICECU  ,&
 & RTWAT_RTICE_R      ,RTWAT_RTICECU_R  
USE YOEPHLI  , ONLY : LPHYLIN  ,RLPTRC
USE YOECUMF  , ONLY : RCUCOV   ,RCPECONS ,RTAUMEL  ,RHEBC, RMFCFL

IMPLICIT NONE

INTEGER(KIND=JPIM),INTENT(IN)    :: KLON 
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
INTEGER(KIND=JPIM),INTENT(IN)    :: KIDIA 
INTEGER(KIND=JPIM),INTENT(IN)    :: KFDIA 
INTEGER(KIND=JPIM)               :: KTDIA ! Argument NOT used
REAL(KIND=JPRB)   ,INTENT(IN)    :: PTSPHY 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PTEN(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQEN(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PQSEN(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PTENH(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQENH(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PAPH(KLON,KLEV+1) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PAP(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PGEOH(KLON,KLEV+1) 
LOGICAL                          :: LDLAND(KLON) ! Argument NOT used
LOGICAL           ,INTENT(IN)    :: LDCUM(KLON) 
INTEGER(KIND=JPIM),INTENT(IN)    :: KCBOT(KLON) 
INTEGER(KIND=JPIM),INTENT(IN)    :: KCTOP(KLON) 
INTEGER(KIND=JPIM),INTENT(IN)    :: KDTOP(KLON) 
INTEGER(KIND=JPIM),INTENT(OUT)   :: KTOPM2 
INTEGER(KIND=JPIM),INTENT(INOUT) :: KTYPE(KLON) 
LOGICAL           ,INTENT(INOUT) :: LDDRAF(KLON) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PMFU(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PMFD(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PMFUS(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PMFDS(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PMFUQ(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PMFDQ(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PMFUL(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PLUDE(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PDMFUP(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PDMFDP(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PDPMEL(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PLGLAC(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PMFLXR(KLON,KLEV+1) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PMFLXS(KLON,KLEV+1) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PRAIN(KLON) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PMFDDE_RATE(KLON,KLEV)

REAL(KIND=JPRB) :: ZRHEBC(KLON)
INTEGER(KIND=JPIM) :: IK, IKB, JK, JL
INTEGER(KIND=JPIM) :: IDBAS(KLON)
LOGICAL :: LLDDRAF

REAL(KIND=JPRB) :: ZALFAW, ZCONS1, ZCONS1A, ZCONS2, &
 & ZDENOM, ZDRFL, ZDRFL1, ZFAC, ZFOEEWI, &
 & ZFOEEWL, ZOEALFA, ZOEEWM, ZOELHM, ZPDR, ZPDS, &
 & ZRFL, ZRFLN, ZRMIN, ZRNEW, ZSNMLT, ZTARG, &
 & ZTMST, ZZP  
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!DIR$ VFUNCTION EXPHF
#include "fcttre.h"

!--------------------------------------------------------------------
!*             SPECIFY CONSTANTS

IF (LHOOK) CALL DR_HOOK('CUFLXN',0,ZHOOK_HANDLE)
ZTMST=PTSPHY
ZCONS1A=RCPD/(RLMLT*RG*RTAUMEL)
!ZCONS2=1.0_JPRB/(RG*ZTMST)
ZCONS2=RMFCFL/(RG*ZTMST)

!*    1.0          DETERMINE FINAL CONVECTIVE FLUXES
!                  ---------------------------------

DO JL=KIDIA,KFDIA
  PRAIN(JL)=0.0_JPRB
  IF(.NOT.LDCUM(JL).OR.KDTOP(JL) < KCTOP(JL)) LDDRAF(JL)=.FALSE.
  IF(.NOT.LDCUM(JL)) KTYPE(JL)=0
  IDBAS(JL)=KLEV
  if(ldland(jl)) then
  ! zrhebc(jl)=rhebc
    zrhebc(jl)=0.7_jprb
  else
  ! zrhebc(jl)=rhebc
    zrhebc(jl)=0.9_jprb
  endif
ENDDO
! TO GET IDENTICAL RESULTS FOR DIFFERENT NPROMA FORCE KTOPM2 TO 2
KTOPM2=2
DO JK=KTOPM2,KLEV
!DIR$ IVDEP
!OCL NOVREC
  IKB=MIN(JK+1,KLEV)
  DO JL=KIDIA,KFDIA
    PMFLXR(JL,JK)=0.0_JPRB
    PMFLXS(JL,JK)=0.0_JPRB
    PDPMEL(JL,JK)=0.0_JPRB
    IF(LDCUM(JL).AND.JK >= KCTOP(JL)) THEN
      PMFUS(JL,JK)=PMFUS(JL,JK)-PMFU(JL,JK)*(RCPD*PTENH(JL,JK)+PGEOH(JL,JK))
      PMFUQ(JL,JK)=PMFUQ(JL,JK)-PMFU(JL,JK)*PQENH(JL,JK)
      PLGLAC(JL,JK)=PMFU(JL,JK)*PLGLAC(JL,JK)
      LLDDRAF=LDDRAF(JL).AND.JK >= KDTOP(JL)
      IF(LLDDRAF) THEN
        PMFDS(JL,JK)=PMFDS(JL,JK)-PMFD(JL,JK)*&
         & (RCPD*PTENH(JL,JK)+PGEOH(JL,JK))  
        PMFDQ(JL,JK)=PMFDQ(JL,JK)-PMFD(JL,JK)*PQENH(JL,JK)
      ELSE
        PMFD(JL,JK)=0.0_JPRB
        PMFDS(JL,JK)=0.0_JPRB
        PMFDQ(JL,JK)=0.0_JPRB
        PDMFDP(JL,JK-1)=0.0_JPRB
      ENDIF
      IF(LLDDRAF.AND.PMFD(JL,JK)<0._JPRB .AND. PMFD(JL,IKB)==0._JPRB) THEN
        IDBAS(JL)=JK
      ENDIF
    ELSE
      PMFU(JL,JK)=0.0_JPRB
      PMFD(JL,JK)=0.0_JPRB
      PMFUS(JL,JK)=0.0_JPRB
      PMFDS(JL,JK)=0.0_JPRB
      PMFUQ(JL,JK)=0.0_JPRB
      PMFDQ(JL,JK)=0.0_JPRB
      PMFUL(JL,JK)=0.0_JPRB
      PLGLAC(JL,JK)=0.0_JPRB
      PDMFUP(JL,JK-1)=0.0_JPRB
      PDMFDP(JL,JK-1)=0.0_JPRB
      PLUDE(JL,JK-1)=0.0_JPRB
    ENDIF
  ENDDO
ENDDO
PMFLXR(:,KLEV+1)=0.0_JPRB
PMFLXS(:,KLEV+1)=0.0_JPRB

!*    1.5          SCALE FLUXES BELOW CLOUD BASE
!                  LINEAR DCREASE
!                  -----------------------------

!DIR$ IVDEP
!OCL NOVREC
DO JL=KIDIA,KFDIA
  IF(LDCUM(JL)) THEN
    IKB=KCBOT(JL)
    IK=IKB+1
    ZZP=((PAPH(JL,KLEV+1)-PAPH(JL,IK))/(PAPH(JL,KLEV+1)-PAPH(JL,IKB)))
    IF(KTYPE(JL) == 3) ZZP=ZZP*ZZP
    PMFU(JL,IK)=PMFU(JL,IKB)*ZZP
    IF (LPHYLIN) THEN
      ZTARG=PTENH(JL,IKB)
      ZOEALFA=0.545_JPRB*(TANH(0.17_JPRB*(ZTARG-RLPTRC))+1.0_JPRB)
      ZOELHM=ZOEALFA*RLVTT+(1.0_JPRB-ZOEALFA)*RLSTT
      PMFUS(JL,IK)=(PMFUS(JL,IKB)-ZOELHM*PMFUL(JL,IKB))*ZZP
    ELSE
      PMFUS(JL,IK)=(PMFUS(JL,IKB)-FOELHMCU(PTENH(JL,IKB))*PMFUL(JL,IKB))*ZZP
    ENDIF
    PMFUQ(JL,IK)=(PMFUQ(JL,IKB)+PMFUL(JL,IKB))*ZZP
    PMFUL(JL,IK)=0.0_JPRB
  ENDIF
ENDDO
DO JK=KTOPM2,KLEV
!DIR$ IVDEP
!OCL NOVREC
  DO JL=KIDIA,KFDIA
    IF(LDCUM(JL).AND.JK > KCBOT(JL)+1) THEN
      IKB=KCBOT(JL)+1
      ZZP=((PAPH(JL,KLEV+1)-PAPH(JL,JK))/(PAPH(JL,KLEV+1)-PAPH(JL,IKB)))
      IF(KTYPE(JL) == 3) ZZP=ZZP*ZZP
      PMFU(JL,JK)=PMFU(JL,IKB)*ZZP
      PMFUS(JL,JK)=PMFUS(JL,IKB)*ZZP
      PMFUQ(JL,JK)=PMFUQ(JL,IKB)*ZZP
      PMFUL(JL,JK)=0.0_JPRB
    ENDIF
    IK=IDBAS(JL)
    LLDDRAF=LDDRAF(JL).AND.JK>IK.AND.IK<KLEV
    IF(LLDDRAF.AND.IK==KCBOT(JL)+1) THEN 
      ZZP=((PAPH(JL,KLEV+1)-PAPH(JL,JK))/(PAPH(JL,KLEV+1)-PAPH(JL,IK)))      
      IF(KTYPE(JL) == 3)  ZZP=ZZP*ZZP
      PMFD(JL,JK)=PMFD(JL,IK)*ZZP
      PMFDS(JL,JK)=PMFDS(JL,IK)*ZZP
      PMFDQ(JL,JK)=PMFDQ(JL,IK)*ZZP
      PMFDDE_RATE(JL,JK)=-(PMFD(JL,JK-1)-PMFD(JL,JK))
    ELSEIF(LLDDRAF.AND.IK/=KCBOT(JL)+1.AND.JK==IK+1) THEN
      PMFDDE_RATE(JL,JK)=-(PMFD(JL,JK-1)-PMFD(JL,JK))
    ENDIF
  ENDDO
ENDDO

!*    2.            CALCULATE RAIN/SNOW FALL RATES
!*                  CALCULATE MELTING OF SNOW
!*                  CALCULATE EVAPORATION OF PRECIP
!                   -------------------------------

DO JK=KTOPM2,KLEV
  DO JL=KIDIA,KFDIA
    IF(LDCUM(JL).AND.JK >= KCTOP(JL)-1) THEN
      PRAIN(JL)=PRAIN(JL)+PDMFUP(JL,JK)
      IF(PMFLXS(JL,JK) > 0.0_JPRB.AND.PTEN(JL,JK) > RTT) THEN
        ZCONS1=ZCONS1A*(1.0_JPRB+0.5_JPRB*(PTEN(JL,JK)-RTT))
        ZFAC=ZCONS1*(PAPH(JL,JK+1)-PAPH(JL,JK))
        ZSNMLT=MIN(PMFLXS(JL,JK),ZFAC*(PTEN(JL,JK)-RTT))
        PDPMEL(JL,JK)=ZSNMLT
        IF (LPHYLIN) THEN
          ZTARG=PTEN(JL,JK)-ZSNMLT/ZFAC
          ZOEALFA=0.545_JPRB*(TANH(0.17_JPRB*(ZTARG-RLPTRC))+1.0_JPRB)
          ZFOEEWL=R2ES*EXP(R3LES*(ZTARG-RTT)/(ZTARG-R4LES))
          ZFOEEWI=R2ES*EXP(R3IES*(ZTARG-RTT)/(ZTARG-R4IES))
          ZOEEWM=ZOEALFA*ZFOEEWL + (1.0_JPRB-ZOEALFA)*ZFOEEWI
          PQSEN(JL,JK)=ZOEEWM/PAP(JL,JK)
        ELSE
          PQSEN(JL,JK)=FOEEWMCU(PTEN(JL,JK)-ZSNMLT/ZFAC)/PAP(JL,JK)
        ENDIF
      ENDIF
      IF (LPHYLIN) THEN
        ZALFAW=0.545_JPRB*(TANH(0.17_JPRB*(PTEN(JL,JK)-RLPTRC))+1.0_JPRB)
      ELSE
        ZALFAW=FOEALFCU(PTEN(JL,JK))
      ENDIF
!no liquid precipitation above melting level
      IF(PTEN(JL,JK) < RTT .AND. ZALFAW > 0.0_JPRB) THEN
        PLGLAC(JL,JK)=PLGLAC(JL,JK)+ZALFAW*(PDMFUP(JL,JK)+PDMFDP(JL,JK))
        ZALFAW=0.0_JPRB
      ENDIF

      PMFLXR(JL,JK+1)=PMFLXR(JL,JK)+ZALFAW*&
       & (PDMFUP(JL,JK)+PDMFDP(JL,JK))+PDPMEL(JL,JK)  
      PMFLXS(JL,JK+1)=PMFLXS(JL,JK)+(1.0_JPRB-ZALFAW)*&
       & (PDMFUP(JL,JK)+PDMFDP(JL,JK))-PDPMEL(JL,JK)  
      IF(PMFLXR(JL,JK+1)+PMFLXS(JL,JK+1) < 0.0_JPRB) THEN
        PDMFDP(JL,JK)=-(PMFLXR(JL,JK)+PMFLXS(JL,JK)+PDMFUP(JL,JK))
        PMFLXR(JL,JK+1)=0.0_JPRB
        PMFLXS(JL,JK+1)=0.0_JPRB
        PDPMEL(JL,JK)  =0.0_JPRB
      ELSEIF(PMFLXR(JL,JK+1) < 0.0_JPRB ) THEN
        PMFLXS(JL,JK+1)=PMFLXS(JL,JK+1)+PMFLXR(JL,JK+1)
        PMFLXR(JL,JK+1)=0.0_JPRB
      ELSEIF(PMFLXS(JL,JK+1) < 0.0_JPRB ) THEN
        PMFLXR(JL,JK+1)=PMFLXR(JL,JK+1)+PMFLXS(JL,JK+1)
        PMFLXS(JL,JK+1)=0.0_JPRB
      ENDIF
    ENDIF
  ENDDO
ENDDO

! Reminder for conservation: 
!    pdmfup(jl,jk)+pdmfdp(jl,jk)=pmflxr(jl,jk+1)+pmflxs(jl,jk+1)-pmflxr(jl,jk)-pmflxs(jl,jk)

DO JK=KTOPM2,KLEV
  DO JL=KIDIA,KFDIA
    IF(LDCUM(JL).AND.JK >= KCBOT(JL)) then
      ZRFL=PMFLXR(JL,JK)+PMFLXS(JL,JK)
      IF(ZRFL > 1.E-20_JPRB) THEN
        ZDRFL1=RCPECONS*MAX(0.0_JPRB,PQSEN(JL,JK)-PQEN(JL,JK))*RCUCOV*&
         & (SQRT(PAPH(JL,JK)/PAPH(JL,KLEV+1))/5.09E-3_JPRB*&
         & ZRFL/RCUCOV)**0.5777_JPRB*&
         & (PAPH(JL,JK+1)-PAPH(JL,JK))  
        ZRNEW=ZRFL-ZDRFL1
        ZRMIN=ZRFL-RCUCOV*MAX(0.0_JPRB,ZRHEBC(JL)*PQSEN(JL,JK)-PQEN(JL,JK))&
         & *ZCONS2*(PAPH(JL,JK+1)-PAPH(JL,JK))  
        ZRNEW=MAX(ZRNEW,ZRMIN)
        ZRFLN=MAX(ZRNEW,0.0_JPRB)
        ZDRFL=MIN(0.0_JPRB,ZRFLN-ZRFL)
        IF (LPHYLIN) THEN
          ZALFAW=0.545_JPRB*(TANH(0.17_JPRB*(PTEN(JL,JK)-RLPTRC))+1.0_JPRB)
        ELSE
          ZALFAW=FOEALFCU(PTEN(JL,JK))
        ENDIF
        IF(PTEN(JL,JK) < RTT) ZALFAW=0.0_JPRB
        ZPDR=ZALFAW*PDMFDP(JL,JK)
        ZPDS=(1.0_JPRB-ZALFAW)*PDMFDP(JL,JK)
        ZDENOM=1.0_JPRB/MAX(1.E-20_JPRB,PMFLXR(JL,JK)+PMFLXS(JL,JK))
        PMFLXR(JL,JK+1)=PMFLXR(JL,JK)+ZPDR &
         & +PDPMEL(JL,JK)+ZDRFL*PMFLXR(JL,JK)*ZDENOM  
        PMFLXS(JL,JK+1)=PMFLXS(JL,JK)+ZPDS &
         & -PDPMEL(JL,JK)+ZDRFL*PMFLXS(JL,JK)*ZDENOM  
        PDMFUP(JL,JK)=PDMFUP(JL,JK)+ZDRFL
        IF(PMFLXR(JL,JK+1)+PMFLXS(JL,JK+1) < 0.0_JPRB) THEN
          PDMFUP(JL,JK)=PDMFUP(JL,JK)-(PMFLXR(JL,JK+1)+PMFLXS(JL,JK+1))
          PMFLXR(JL,JK+1)=0.0_JPRB
          PMFLXS(JL,JK+1)=0.0_JPRB
          PDPMEL(JL,JK)  =0.0_JPRB
        ELSEIF(PMFLXR(JL,JK+1) < 0.0_JPRB ) THEN
          PMFLXS(JL,JK+1)=PMFLXS(JL,JK+1)+PMFLXR(JL,JK+1)
          PMFLXR(JL,JK+1)=0.0_JPRB
        ELSEIF(PMFLXS(JL,JK+1) < 0.0_JPRB ) THEN
          PMFLXR(JL,JK+1)=PMFLXR(JL,JK+1)+PMFLXS(JL,JK+1)
          PMFLXS(JL,JK+1)=0.0_JPRB
        ENDIF
      ELSE
        PMFLXR(JL,JK+1)=0.0_JPRB
        PMFLXS(JL,JK+1)=0.0_JPRB
        PDMFDP(JL,JK)  =0.0_JPRB
        PDPMEL(JL,JK)  =0.0_JPRB
      ENDIF
    ENDIF
  ENDDO
ENDDO

IF (LHOOK) CALL DR_HOOK('CUFLXN',1,ZHOOK_HANDLE)
END SUBROUTINE CUFLXN
