PROGRAM cfu

  IMPLICIT NONE
  
  INTEGER :: &
    iargc

  CHARACTER (LEN=50) :: &
    function_name

  CHARACTER (LEN=50) :: &
    yprefix1, yprefix2, ysuffix

  CHARACTER (LEN=250) :: &
    yinpdir

  CHARACTER (LEN=200) :: &
    carg

  CHARACTER (LEN=10) :: &
    ystartdate, yenddate

  CHARACTER (LEN=8) :: &
    yinterval

  INTEGER :: &
    itype_calendar

  LOGICAL :: &
    lastoutput

  REAL :: &
    hours
  
  INTEGER :: &
    months, hinchours

  IF (iargc() < 1) THEN
    PRINT *, 'ERROR: invalid number of arguments'
    PRINT *, 'Usage: cfu <function> <function argument 1> <function argument 2> .. <function argument n>'
    CALL cfu_help
    STOP
  ENDIF

  CALL getarg(1,function_name) 
  
  SELECT CASE (TRIM(function_name))
  CASE ('add_hours')
  
    IF (iargc() < 3 .OR. iargc() > 4) THEN
      PRINT *, 'ERROR: Invalid number of arguments'
      PRINT *, 'Usage: cfu add_hours <yyyymmddhh> <hours> [<itype_calendar>]'
      STOP
    ENDIF
  
    CALL getarg(2,ystartdate)
    CALL getarg(3,carg)
    READ (carg,*) hours


    IF (iargc() == 3) THEN
      itype_calendar = 0
    ELSE
      CALL getarg(4,carg)
      READ (carg,*) itype_calendar
    ENDIF

    CALL add_hours (ystartdate, hours, itype_calendar)

  CASE ('add_months')
  
    IF (iargc() /= 3) THEN
      PRINT *, 'ERROR: Invalid number of arguments'
      PRINT *, 'Usage: cfu add_hours <yyyymmddhh> <months>'
      STOP
    ENDIF
  
    CALL getarg(2,ystartdate)
    CALL getarg(3,carg)
    READ (carg,*) months

    CALL add_months (ystartdate, months)

  CASE ('check_files')
  
    IF (iargc() < 9 .OR. iargc() > 10) THEN
      PRINT *, 'ERROR: Invalid number of arguments'
      PRINT *, 'Usage: cfu check_files <ystartdate> <yenddate> <hinchours> ', &
               '<prefix1> <prefix2> <suffix> <input directory> <lastoutput> [<itype_calendar>]'
    STOP
    END IF

    CALL getarg(2,ystartdate)
    CALL getarg(3,yenddate)
    CALL getarg(4,carg)
    READ (carg,*) hinchours
    CALL getarg(5,yprefix1)
    CALL getarg(6,yprefix2)
    CALL getarg(7,ysuffix)
    CALL getarg(8,yinpdir)
    CALL getarg(9,carg)
    READ (carg,*) lastoutput

    IF (iargc() < 10) THEN
      itype_calendar = 0
    ELSE
      CALL getarg(10,carg)
      READ (carg,*) itype_calendar
    ENDIF


    CALL check_files (ystartdate, yenddate, hinchours, yprefix1, yprefix2, ysuffix, yinpdir, lastoutput, itype_calendar)
 
   CASE ('get_hours')
  
    IF (iargc() < 3 .OR. iargc() > 4) THEN
      PRINT *, 'ERROR: Invalid number of arguments'
      PRINT *, 'Usage: cfu get_hours <ystartdate> <yenddate> [<itype_calendar>]'
      STOP
    ENDIF
  
    CALL getarg(2,ystartdate)
    CALL getarg(3,yenddate)


    IF (iargc() == 3) THEN
      itype_calendar = 0
    ELSE
      CALL getarg(4,carg)
      READ (carg,*) itype_calendar
    ENDIF

    CALL get_hours (ystartdate, yenddate, itype_calendar)

   CASE ('get_next_dates')
  
    IF (iargc() < 3 .OR. iargc() > 4) THEN
      PRINT *, 'ERROR: Invalid number of arguments'
      PRINT *, 'Usage: cfu get_next_dates <yyyymmddhh> <mm:dd:hh> [<itype_calendar>]'
      STOP
    ENDIF
  
    CALL getarg(2,ystartdate)
    CALL getarg(3,yinterval)


    IF (iargc() == 3) THEN
      itype_calendar = 0
    ELSE
      CALL getarg(4,carg)
      READ (carg,*) itype_calendar
    ENDIF

    CALL get_next_dates (ystartdate, yinterval, itype_calendar)

  CASE DEFAULT
  
    PRINT *, 'ERROR: illegal function'
    CALL cfu_help
  
  END SELECT

END PROGRAM cfu

SUBROUTINE cfu_help

   IMPLICIT NONE
   
   PRINT *
   PRINT *, 'Valid functions:'
   PRINT *, 'add_hours <yyyymmddhh> <hours> [<itype_calendar>]'
   PRINT *, 'add_months <yyyymmddhh> <months>'
   PRINT *, 'check_files <ystartdate> <yenddate> <hinchours> ', &
               '<prefix1> <prefix2> <suffix> <input directory> <lastoutput> [<itype_calendar>]'
   PRINT *, 'get_hours <ystartdate> <yenddate> [<itype_calendar>]'
   PRINT *, 'get_next_dates <yyyymmddhh> <mm:dd:hh> [<itype_calendar>]'
  
   RETURN

END SUBROUTINE cfu_help
