SUBROUTINE add_months (ystartdate, madd)

!-------------------------------------------------------------------------------
!
! Description:
!   This program adds a number of months to a date
!   YYYYMMDDHH(new) = YYYMMDDHH(old) + months
!
!   Usage:
!     add_hours <yyyymmddhh> <months>
!
!   The result is written to standard output in the form YYYYMMDDHH
!
!-------------------------------------------------------------------------------

  IMPLICIT NONE
!
! Input Parameter list:
! ---------------------

  CHARACTER (LEN=10)  , INTENT(IN)          ::         &
    ystartdate    ! start date of the forecast

  INTEGER, INTENT(IN) :: &
    madd       ! months to be added to ystartdate

! Parameter written to standard output
! ------------------------------------

  CHARACTER (LEN=10)          ::                           &
    yactdate1  ! actual date in the form   yyyymmddhh


! Local variables:
! ------------------------------------

  INTEGER      ::                                       &
    nmonths, rest_months, iargc, &
    year_s, month_s, day_s, hour_s, year_e, month_e, day_e, hour_e, &
    full_years


!------------ End of header ----------------------------------------------------

! Begin subroutine add_months

  READ ( ystartdate, '(I4,3I2)' ) year_s, month_s, day_s, hour_s

  nmonths = madd
  month_e = month_s + nmonths
!  WRITE(*,*) madd, nmonths, month_s, month_e
  IF (month_e <= 12) THEN
    year_e = year_s
!    WRITE(*,*) year_s, year_e
    day_e  = day_s
    hour_e = hour_s
  ELSE
    nmonths = nmonths - 12 + month_s
    full_years = nmonths / 12
    rest_months = nmonths - full_years * 12
    year_e = year_s + full_years + 1
    month_e = rest_months
    IF (month_e == 0) month_e = 12
    day_e  = day_s
    hour_e = hour_s
  ENDIF

    WRITE(yactdate1,'(I4.4,3I2.2)') year_e, month_e, day_e, hour_e
    WRITE(*,'(A10)') yactdate1
 
END SUBROUTINE add_months
