function [Weights] = return_importance(independent_variables,dependent_variable,type)
% compute importance
% Equations given in:
% Jeff W. Johnson (2000) A Heuristic Method for Estimating the
% Relative Weight of Predictor Variables in Multiple Regression, Multivariate Behavioral
% Research, 35:1, 1-19, DOI: 10.1207/S15327906MBR3501_1
X=independent_variables; % independent variable or covariates
Y=dependent_variable; % dependent variable or y
Rxx=corrcoef(X); % compute correlation matrix of covariates
Ryx=corrcoef([Y X]); % compute correlation matrix of dependent variable and covariates
[evec,ev] = eig(Rxx); % compute eigenvalues and eigenvectors
delta=sqrt(abs(ev));% sqrt of diagonal of eigenvalues
lambda=evec*delta*evec';
lambdasq=lambda.^2;
rweight1=(lambda)\Ryx(2:end,1);
R2=sum(rweight1.^2); % coefficient of determination
rawWeight=lambdasq*rweight1.^2;% raw weights
standRelWeight=(rawWeight./R2); % normalize to get the weights between 0 and 1
if strcmpi(type,'sorted')
    Weights=sortrows([[1:1:length(standRelWeight)]' standRelWeight],-2); % first column contain indices of covariates sorted by ranking
elseif strcmpi(type,'unsorted')
    Weights=[[1:1:length(standRelWeight)]' standRelWeight]; % first column contain indices of covariates sorted by ranking
end