function [jensen_shannon_distance] = jsd(x,y,base)
M = 0.5*(x+y);
if strcmpi(base,'log_e')
    KL_XM=x.*log(x./M);
    KL_YM=y.*log(y./M);
elseif strcmpi(base,'log_2')
    KL_XM=x.*log2(x./M);
    KL_YM=y.*log2(y./M);
end
KL_XM(isnan(KL_XM)) = 0;
KL_YM(isnan(KL_YM)) = 0;
KL_XM=sum(KL_XM);
KL_YM=sum(KL_YM);
jensen_shannon_distance=sqrt((KL_XM+KL_YM)/2);

