function [outvecmat,outmat,lons_out,lats_out,index_out,A,B] = upscale(data,lons,lats,index,factor,what)

%% data dimensions 
datrow=size(data,1);
datcol=size(data,2);
mindatdim= min(datrow,datcol);
maxdatdim= max(datrow,datcol);

%% data can be a 1 column matrix or a matrix more than 1 column i.e. H 
 m=length(lons);
 n=length(lats);
 mapgrid=NaN(n,m);

 
 if(mindatdim==1)   

    for i = 1:size(data,1)
     mapgrid(index(i,1),index(i,2))=data(i);
    end
  
 else  
       for i = 1:size(data,2)
         mapgrid(index(i,1),index(i,2))=data(1,i); %% assuming #columns > 1
       end
 end   

 % cells
 mout=ceil(m/factor);
 nout=ceil(n/factor);
 outmat= NaN(nout,mout);
 
 % generate averaging matrix
 B = NaN(1,maxdatdim);
 
 
 %% Calculate mean or sum of the nearby grids & weight matrix
 for j = 1:ceil(size(mapgrid,2)/factor)
   for i = 1:ceil(size(mapgrid,1)/factor)
      
     %% outmat 
     iblock =  (1:factor) + factor*(i - 1);
     jblock =  (1:factor) + factor*(j - 1);
     iblock=iblock(find(iblock<=n));
     jblock=jblock(find(jblock<=m));
     mv= mapgrid(iblock, jblock);
     mv = mv(:);
      if(what=="mean")
        outmat(i, j) = nanmean(mv);
      elseif(what=="sum")
         outmat(i, j) = nansum(mv);
      end
      
      %% weight matrix 
      [A,Bn] = meshgrid(iblock,jblock);
      c=cat(2,A',Bn');
      ijs=reshape(c,[],2);
      %ijs=combvec(iblock,jblock)';
      idx = sub2ind(size(mapgrid), ijs(:,1),  ijs(:,2));
      d=find(~isnan(mapgrid(idx)));

      if(length(d)>0)
         ijsA=ijs(d,:);
         [ind ia]=intersect(index,ijsA,'rows');
         dd = zeros(1,maxdatdim);
         dd(ia)=1;
         B = [B;dd];
      end
      
   end
 end

 
  %% make weight matrix row stochastic 
 B(1,:) = [];
 A = B./sum(B,2); 
 
 %% vectorize or aggregate for output according to input
  if(mindatdim==1)  
     outvec = outmat(:);
     outvecmat = outvec(~isnan(outvec));
  else 
     outvecmat = data *B';  
  end 

  %% make it sparse if inpout is in sparse
  if(issparse(data))
     outvecmat = sparse(outvecmat);
  end 
  
 %% lat lons of new grid 
 [row, col] = find(~isnan(outmat));
 index_out=[row col];
 lons_out=NaN(length(1:factor:length(lons)),1);
 lats_out=NaN(length(1:factor:length(lats)),1);
 k=1;

 % for lons
 for i=1:factor:length(lons)

   if(i+factor-1<length(lons)) 
      lons_out(k)= mean(lons(i:(i+factor-1))); 
   else
       lons_out(k)= mean(lons(i:end));
   end
   k=k+1; 
 end   
   % for lats
   k=1;
  for i=1:factor:length(lats)

    if(i+factor-1<length(lats)) 
       lats_out(k)= mean(lats(i:i+factor-1)); 
    else
        lats_out(k)= mean(lats(i:end));
    end
   
   k=k+1;
   
  end 



end

