# Import Julia packages
using TrackMatcher
import JLD2

# Load combinded input data
input = MeasuredSet(["webdata" => "data/flights"
  "sat" => ["data/CALIOP/05kmCPro.v4.20/2019/2019_01_26",
  "data/CALIOP/05kmCPro.v4.20/2019/2019_01_27",
  "data/CALIOP/05kmCPro.v4.20/2019/2019_01_28/"]], odelim='\t'
)
# Calculate intersections for loaded MeasuredSet
output = Intersection(input.flight, input.sat)

# Load data and calculate intersections all in one step
intersections = DataSet(["webdata" => "data/flights"
  "sat" => ["data/CALIOP/05kmCPro.v4.20/2019/2019_01_26",
  "data/CALIOP/05kmCPro.v4.20/2019/2019_01_27",
  "data/CALIOP/05kmCPro.v4.20/2019/2019_01_28/"]], odelim='\t'
)

# Save results for later analysis
@JLD2.save "data/results/Xextended.jld2" input output intersections
