# Import Julia packages
using TrackMatcher
import JLD2

# Load input data
flight = FlightSet(webdata="data/flights", odelim='\t')
sat=SatSet(
  "data/CALIOP/05kmCPro.v4.20/2019/2019_01_26",
  "data/CALIOP/05kmCPro.v4.20/2019/2019_01_27",
  "data/CALIOP/05kmCPro.v4.20/2019/2019_01_28/"
)
# Calculate intersections
Xex = Intersection(flight, sat)

# Save results for later analysis
@JLD2.save "data/results/Xex.jld2" Xex
