# Copyright @ R. Badeke (2021)

from pandas import DataFrame
from sklearn import linear_model
import pandas as pd
import numpy as np


print("multilinear regression calculator for Gaussian fit\n")

"INPUT"
# The user can enter parameters for wind speed, exit velocity, exhaust 
# temperature, wind angle (0 = frontal wind, 90 = lateral wind) and stability 
# to calculate individual mean and standard deviation values for the Gaussian
# distribution of vertical ship emissions


Input_Wind_Speed = 2     # m/s
Input_Exhaust_Speed = 10 # m/s
Input_Temperature = 200  # exhaust temperature in deg C
Input_angle = 0          # flow angle towards the ship (0 = frontal, 90 = lateral)
Input_Stability = -0.65  # K/100m

# path of the regression_data.csv
df = pd.read_csv(".../regression_data_gauss.csv", sep=";")

"end of user input"

#Multiple regression to calculate regression parameters based on the MITRAS regression data set
Case = df["#"].to_list()
vwind = df["Wind speed"].to_list()
vwind = np.log10(vwind)
vexh = df["Exhaust speed"].to_list()
temperature = df["Temperature"].to_list()
cos_angle = df["cos_Angle"].to_list()
stability = df["dT/dz"].to_list()
mean = df["Mean_Gauss_fit"].to_list()
std = df["Std_Gauss_fit"].to_list()

Model_Data = {'Case': Case,
                'Wind Speed': vwind,
                'Exhaust Speed': vexh,
                'Temperature': temperature,
                'cos_angle': cos_angle,
                'Stability' : stability,
                'Mean': mean,
                'Std': std
                }

df = DataFrame(Model_Data,columns=['Case','Wind Speed','Exhaust Speed','Temperature', 'Stability', 'cos_angle', 'Mean', 'Std']) 

X_mean = df[['Wind Speed','cos_angle','Exhaust Speed','Temperature']]
X_std = df[['Wind Speed','cos_angle','Exhaust Speed','Temperature', 'Stability']]
Y_mean = df['Mean']
Y_std = df['Std']

regr_mean = linear_model.LinearRegression()
regr_mean.fit(X_mean, Y_mean)
regr_std = linear_model.LinearRegression()
regr_std.fit(X_std, Y_std)

# these coefficients are used in Eq. (2) and Eq. (3)
print('Intersect mean: \n', regr_mean.intercept_)
print('Coefficients mean: \n', regr_mean.coef_)
print('Intersect std: \n', regr_std.intercept_)
print('Coefficients std: \n', regr_std.coef_,'\n')


Input_Wind_Speed = np.log10(Input_Wind_Speed)
Input_angle = np.cos(np.deg2rad(Input_angle))

# these values can be used in Eq. (1) to calculate individual Gaussian profiles based on the user input
print ('Predicted Mean and Std for user input values: \n', regr_mean.predict([[Input_Wind_Speed ,Input_Exhaust_Speed, Input_Temperature, Input_angle]]),
       regr_std.predict([[Input_Wind_Speed, Input_Exhaust_Speed, Input_Temperature, Input_Stability, Input_angle]]))

