!OPTION! -pvctl noloopfusion
SUBROUTINE APL_AROME ( KBL, KGPCOMP, KIDIA , KFDIA , KLON ,&
 & KTDIA  , KLEV , KSTEP ,&
 & KSGST, PDT, LDXFUMSE, PINDX, PINDY ,&
 & PGEMU,PGELAM,POROG,PGM,PMU0,PMU0LU,PMU0M,PMU0N,PCLON, PSLON,PVO3ABC,PLSM,&
 & PAESEA , PAELAN , PAESOO , PAEDES , PAESUL, PAEVOL,&
 & PGP2DSDT, &
 !---------------------------------------------------------------------
 ! - INPUT A M
 & PAPHIM,PAPHIFM,PAPRSM, PAPRSFM, PRDELPM, PDELPM, PTM, PQVM ,&
 & PCPM    , PRM     ,PALPHM , PLNPRM, &
 & PQCM    , PQIM    ,PQRM   , PQSM, PQGM, PQHM, &
 & PTKEM   , PEFB1   ,PEFB2  , PEFB3,&
 & PSIGM,PSVM,&

 & PUM    , PVM, PWM, &
 & PFORCEU,PFORCEV,PFORCET,PFORCEQ,&
 !---------------------------------------------------------------------
 !  - INOUT A S
 & PGPAR, PEMTD, PEMTU, PTRSO, &
 & PGDEOSI, PGUEOSI, PGMU0, PGMU0_MIN, PGMU0_MAX, &
 & PGDEOTI, PGDEOTI2, PGUEOTI, PGUEOTI2, PGEOLT, PGEOXT, &
 & PGRPROX, PGMIXP, PGFLUXC, PGRSURF, &
 !  - OUT A S
 & PQLRAD, PQIRAD, PCLFS, PSIGS, &
 & PTENDT, PTENDR, PTENDU, PTENDV,PTENDW, &
 & PTENDTKE, PTENDEFB1, PTENDEFB2, PTENDEFB3, &
 & PTENDEXT,PFRTH, PFRSO,PFRTHDS, PFRSODS, PFRSOPS, PFRSDNI, PFRSOPT, PFRTHC, PFRSOC, &
 !---------------------------------------------------------------------
 !  - IN FOR RADIATION IF NO SURFACE SCHEME
 & PALBIN,PEMIS, &
 !  - INOUT for easy diag
 & PEZDIAG,&
 !  - INOUT for CFU XFU
 & PCLCH,PCLCL,PCLCM,PCLCT,PFPLSL,PFPLSN,PFPLSG,PFPLSH,PSTRTU,PSTRTV,PFCS,PFCLL,&
 & PFCLN,PUCLS,PVCLS,PTCLS,PQCLS,PHUCLS,PUGST,PVGST,PFEVL,PFEVN, PPBLH,PSPSG,&
 & PSDUR, PDIAGH, PSFORC, &
! daand: radflex
 & YDPROCSET )

!**** *APL_AROME * - CALL OF PHYSICAL PARAMETERISATIONS FOR ALARO/AROME

!     Sujet.
!     ------
!     - APPEL DES SOUS-PROGRAMMES DE PARAMETRISATION

!**   Interface.
!     ----------
!        *CALL* *APL_AROME*

!-----------------------------------------------------------------------

! -   ARGUMENTS D'ENTREE.
! -   INPUT ARGUMENTS.
!     -------------------

! - NOM DES PARAMETRES DE DIMENSIONNEMENT DE LA PHYSIQUE.
! - DIMENSIONS.

! KBL  : NUMERO DE BLOC NPROMA
! KBL  : NPROMA-PACKETS NUMBER
! KGPCOMP : NOMBRE TOTAL DE POINTS DE GRILLE SUR LE DOMAINE
! KGPCOMP : TOTAL GRID POINTS NUMBER IN THE DOMAIN
! KIDIA, KFDIA : BORNES BOUCLES HORIZONTALES   (IST,IEND DANS CPG).
! KIDIA, KFDIA : START/END OF HORIZONTAL LOOP  (IST,IEND IN *CPG*).
! KLON : DIMENSION HORIZONTALE                 (NPROMA DANS CPG).
! KLON : HORIZONTAL DIMENSION                  (NPROMA IN *CPG*).
! KTDIA : DEBUT BOUCLE VERTICALE DANS LA PHYSIQUE.
! KTDIA : START OF THE VERTICAL LOOP IN THE PHYSICS (IF SOME LEVELS ARE
!                     SKIPPED AT THE TOP OF THE MODEL).
! KLEV : FIN BOUCLE VERTICE ET DIMENSION VERTICALE (NFLEVG DANS CPG).
! KLEV : END OF VERTICAL LOOP AND VERTICAL DIMENSION(NFLEVG IN *CPG*).
! KSTEP : TIME STEP NUMBER (starting with zero)
! KSGST : NUMBER OF SUBGRID SURFACE TEMPERATURES AND FLUXES (NTSSG IN *CPG*)
! Default NTSSG=0 under mf_phys, coming from sudim1 > yomdphy, thus obsolete?
! PDT : TIME STEP (in s) 
! LDXFUMSE : T if CDCONF=X in order not to increment surfex timer in that case
!-----------------------------------------------------------------------
! PGEMU      : SINE OF GEOGRAPHICAL LATITUDE
! PGELAM     :  LONGITUDE
! POROG      : g * OROGRAPHY
! PGM        : MAP FACTOR (used in ALARO convection only)
! PMU0       : COSINUS LOCAL INSTANTANE DE L'ANGLE ZENITHAL SOLAIRE.
! PMU0LU     : COSINUS LOCAL INSTANTANE DE L'ANGLE ZENITHAL LUNAIRE.
! PMU0       : LOCAL COSINE OF INSTANTANEOUS SOLAR ZENITH ANGLE.
! PMU0M      : COSINUS LOCAL MOYEN DE L'ANGLE ZENITHAL.
! PMU0M      : LOCAL COSINE OF AVERAGED SOLAR ZENITH ANGLE.
! PMU0N      : COSINUS LOCAL AU PAS DE TEMPS SUIVANT DE L'ANGLE ZENITHAL SOLAIRE.
! PMU0N      : NEXT TIME STEP COSINUS LOCAL INSTANTANE DE L'ANGLE ZENITHAL SOLAIRE.
! PCLON      : cosine of geographical longitude.
! PSLON      : sine of geographical longitude.
! PVO3ABC    : OZONE COEFFICIENTS FOR ARPEGE PROFILES
! PLSM       : -ATMOSPHERIC MODEL- LAND-SEA MASK (! MAY BE DIFFERENT FROM 
!              THE SURFACE ONE) 
! PAESEA     : AEROSOLS MARINS (SI NVCLIA >= 4)
! PAESEA     : MARINE AEROSOLS (IF NVCLIA >= 4)
! PAELAN     : AEROSOLS CONTINENTAUX (SI NVCLIA >= 4)
! PAELAN     : CONTINENTAL AEROSOLS (IF NVCLIA >= 4)
! PAESOO     : AEROSOLS CARBONES (SI NVCLIA >= 4)
! PAESOO     : SOOT AEROSOLS (IF NVCLIA >= 4)
! PAEDES     : AEROSOLS DESERTIQUES (SI NVCLIA >= 4)
! PAEDES     : DESERT AEROSOLS (IF NVCLIA >= 4)
! PAESUL     : AEROSOLS SULFATES (SI LAEROSUL=.T.)
! PAESUL     : SULFATE AEROSOLS  (IF LAEROSUL=.T.)
! PAEVOL     : AEROSOLS VOLCAN   (SI LAEROVOL=.T.)
! PAEVOL     : VOLCANO AEROSOLS  (IF LAEROVOL=.T.)
! PGP2DSDT   : STOCHASTIC PHYSICS PATTERNS

! FIELDS WITH SUBSCRIPT M FOR TIME T-DT IN 3TL OR T IN 2TL

! PAPHIM     : GEOPOTENTIAL ON HALF-LEVELS
! PAPHIFM    : GEOPOTENTIAL ON FULL-LEVELS
! PAPRSM     : PRESSURE ON HALF LEVELS
! PAPRSFM    : PRESSURE ON FULL LEVELS.
! PRDELPM    : INVERSE OF PDELP 
! PDELPM     : LAYER THICKNESS IN PRESSURE UNITS

! PTM        : TEMPERATURE.
! PQVM        : SPECIFIC HUMIDITY OF WATER VAPOR
! PCPM        : SPECIFIC HEAT AT CONSTANT PRESSURE FOR AIR
! PRM         : GAS CONSTANT FOR AIR
! PALPHM      : "alpha" on layers
! PLNPRM      : "delta" on layers

! PQCM        : SPECIFIC HUMIDITY OF CLOUD WATER
! PQIM        : SPECIFIC HUMIDITY OF ICE
! PQRM        : SPECIFIC HUMIDITY OF RAIN
! PQSM        : SPECIFIC HUMIDITY OF SNOW
! PQGM        : SPECIFIC HUMIDITY OF GRAUPEL
! PQHM        : SPECIFIC HUMIDITY OF HAIL
! PTKEM       : TURBULENT KINETIC ENERGY
! PSVM        : PASSIVE SCALARS
! PSIGM       : SIGMA FOR SUBGRIDCOND
! PUM         : ZONAL WIND
! PVM         : MERIDIAN WIND
! PWM         : VERTICAL VELOCITY (m/s)

!-----------------------------------------------------------------------
! - INOUT

! PGPAR       : BUFFER FOR 2D FIELDS - CONTAINS PRECIP, ALBEDO, EMISS, TS 
!             : SURFACE FLUXES
! PEMTD       : DOWNWARD LONGWAVE EMISSIVITY
! PEMTU       : UPWARD   LONGWAVE EMISSIVITY
! PTRSO       : SHORTWAVE TRANSMISSIVITY

! ACRANEB2 intermittency storage

! PGDEOSI   : DESCENDING INCREMENTAL OPTICAL DEPTHS, SOLAR
! PGUEOSI   : ASCENDING  INCREMENTAL OPTICAL DEPTHS, SOLAR
! PGMU0     : COSINE OF SOLAR ZENITH ANGLE, APPROXIMATE ACTUAL VALUE
! PGMU0_MIN : COSINE OF SOLAR ZENITH ANGLE, MIN VALUE
! PGMU0_MAX : COSINE OF SOLAR ZENITH ANGLE, MAX VALUE
! PGDEOTI     : DESCENDING INCREMENTAL OPTICAL DEPTHS, dB/dT(T0) WEIGHTS
! PGDEOTI2    : DESCENDING INCREMENTAL OPTICAL DEPTHS, B WEIGHTS WITH
!               LINEAR T_e CORRECTION
! PGUEOTI     : ASCENDING INCREMENTAL OPTICAL DEPTHS, dB/dT(T0) WEIGHTS
! PGUEOTI2    : ASCENDING INCREMENTAL OPTICAL DEPTHS, B WEIGHTS WITH
!               LINEAR T_e CORRECTION
! PGEOLT      : LOCAL OPTICAL DEPTHS, dB/dT(T0) WEIGHTS
! PGEOXT      : MAXIMUM OPTICAL DEPTHS FOR EBL-EAL, dB/dT(T0) WEIGHTS
! PGRPROX     : CORRECTION TERM FOR ADJACENT EXCHANGES
! PGMIXP      : NON-STATISTICAL WEIGHTS FOR BRACKETING
! PGFLUXC     : OUT OF BRACKET PART OF CLEARSKY EBL, RESP. EBL-EAL FLUX
! PGRSURF     : CORRECTIVE RATIO FOR SURFACE CTS CONTRIBUTION
!-----------------------------------------------------------------------
! - OUTPUT (SUBSCRIPT S FOR T+DT)

! PCLFS       : CLOUD FRACTION
! PQLRAD      : SPECIFIC HUMIDITY OF CLOUD WATER FOR RTTOV
! PQIRAD      : SPECIFIC HUMIDITY OF ICE FOR RTTOV
! PSIGS       : SIGMA FOR SUBGRIDCOND
! PTENDT      : TEMPERATURE TENDENCY
! PTENDR      : HYDROMETEORE TENDENCIES
! PTENDU      : ZONAL WIND TENDENCY
! PTENDV      : MERIDIAN WIND TENDENCY
! PTENDW      : VERTICAL VELOCITY TENDENCY
! PTENDTKE    : TKE TENDENCY
! PTENDEXT    : PASSIVE SCALARS TENDENCY
! PFRTH       : LONGWAVE RADIATIVE FLUX
! PFRSO       : SHORTWAVE RADIATIVE FLUX
! PFRTHDS     : LONGWAVE DOWNWARD SURFACE RADIATIVE FLUX
! PFRSOPS     : SHORTWAVE DOWNWARD SURFACE RADIATIVE FLUX DIRECT
! PFRSDNI     : SHORTWAVE DIRECT NORMAL IRRADIANCE
! PFRSODS     : SHORTWAVE DOWNWARD SURFACE RADIATIVE FLUX GLOBAL
! PFRSOPT     : SHORTWAVE DOWNWARD TOP RADIATIVE FLUX DIRECT
! - 2D (0:1)
! PFRSOC      : SHORTWAVE CLEAR SKY NET RADIATIVE FLUX
! PFRTHC      : LONGWAVE CLEAR SKY NET RADIATIVE FLUX

! variables used in input for radiation in case no surface scheme is used 

! PALBIN     : MODEL SURFACE SHORTWAVE ALBEDO.
! PEMIS      : MODEL SURFACE LONGWAVE EMISSIVITY.

! Part of GFL strcture dedicated to easy diagnostics (to be used as a print...)
! PEZDIAG    : MULPITPLE ARRAY TO BE FILLED BY THE USER BY 3D FIELDS
!              (NGFL_EZDIAG ONES)
! output for CFU XFU
! PCLCH      : HIGH CLOUD COVER (DIAGNOSTIC).
! PCLCL      : LOW CLOUD COVER (DIAGNOSTIC).
! PCLCM      : MEDIUM CLOUD COVER (DIAGNOSTIC).
! PCLCT      : TOTAL CLOUD COVER (DIAGNOSTIC).
! PFPLSL     : RESOLVED PRECIPITATION AS RAIN.
! PFPLSN     : RESOLVED PRECIPITATION AS SNOW
! PFPLSG     : RESOLVED PRECIPITATION AS GRAUPEL
! PFPLSH     : RESOLVED PRECIPITATION AS HAIL
! PSTRTU     : TURBULENT FLUX OF MOMENTUM "U".
! PSTRTV     : TURBULENT FLUX OF MOMENTUM "V".
! PFCS       : SENSIBLE HEAT FLUX AT SURFACE LEVEL.
! PFCLL      : LATENT HEAT FLUX AT SURFACE LEVEL OVER WATER.
! PFCLN      : LATENT HEAT FLUX AT SURFACE LEVEL OVER SNOW.
! PUCLS      : SORTIE DIAGNOSTIQUE DU VENT EN X A HUV METEO.
! PUCLS      : U-COMPONENT OF WIND AT 10 METERS (DIAGNOSTIC).
! PVCLS      : SORTIE DIAGNOSTIQUE DU VENT EN Y A HUV METEO.
! PVCLS      : V-COMPONENT OF WIND AT 10 METERS (DIAGNOSTIC).
! PTCLS      : SORTIE DIAGNOSTIQUE DE LA TEMPERATURE A HTQ METEO.
! PTCLS      : TEMPERATURE AT 2 METERS (DIAGNOSTIC).
! PQCLS      : SORTIE DIAGNOSTIQUE DE L'HUMIDITE SPECIFIQUE A HTQ METEO.
! PQCLS      : SPECIFIC HUMIDITY AT 2 METERS (DIAGNOSTIC).
! PHUCLS     : SORTIE DIAGNOSTIQUE DE L'HUMIDITE RELATIVE A HTQ METEO.
! PHUCLS     : RELATIVE HUMIDITY AT 2 METERS (DIAGNOSTIC).
! PUGST      : SORTIE DIAGNOSTIQUE DU VENT RAFALE EN X A HUV METEO.
! PUGST      : U-COMPONENT OF WIND GUST AT 10 METERS (DIAGNOSTIC).
! PVGST      : SORTIE DIAGNOSTIQUE DU VENT RAFALE EN Y A HUV METEO.
! PVGST      : V-COMPONENT OF WIND GUST AT 10 METERS (DIAGNOSTIC).
! PFEVL      : FLUX DE VAPEUR D'EAU SUR EAU LIQUIDE (OU SOL HUMIDE).
! PFEVL      : WATER VAPOUR FLUX OVER LIQUID WATER (OR WET SOIL)
! PFEVN      : FLUX DE VAPEUR D'EAU SUR NEIGE (OU GLACE) ET SOL GELE.
! PFEVN      : WATER VAPOUR FLUX OVER SNOW (OR ICE) AND FROZEN SOIL.
! PPBLH      : PSEUDO-HISTORICAL ARRAY FOR PBL HEIGHT
! PSPSG      : SNOW COVER
! PSDUR      : SUNSHINE DURATION [s]
! PDIAGH     : HAIL DIAGNOSTIC


!-----------------------------------------------------------------------

!     Externes.
!     ---------

!     Method
!     ------
!     - convert aladin variables into mesonh variables (level inversion 
!       and q to r, t to theta) 
!     - call mesoNH physics and ECMWF radiation scheme
!     - convert mesoNH tendencies to aladin tendencies

!     Auteur.
!     -------
!      S.Malardel et Y. Seity
!      10-03-03
!      big cleaning (18/06/04) S. Malardel and Y. Seity
!     externalisation of surface scheme call + small cleaning (20-07-04) Y.Seity
!     Modifications
!     -------------
!      G. Hello 04-02-06: Add the call of KFB-convection scheme 
!                         for future use in ALARO
!      T.Kovacic 04-05-05: Added ZCVTENDPR and ZCVTENDPRS 
!        M.Hamrud      01-Oct-2003 CY28 Cleaning
!      F.Bouyssel 04-05-05: New arguments in ACRADIN
!     Y. Seity 30-Sept-2005 Add MNH Chemistry scheme
!     R. Zaaboul 15-feb-2006 add surface scheme call
!     T.Kovacic  2006-03-23: calls to subroutines for budgets 
!                             and new arguments PFRTH and PFRSO
!     Y. Seity   2007-05-07: add CFU and XFU calculations 
!                           and call aro_ground_diag
!     S.Ivatek-S 2007-04-17: Over dimensioning of PGPAR by NGPAR+1 just 
!                            (KLON,NGPAR) is used boundary checking bf
!     T.Kovacic  2007-03-16: Fourth dim. in APFT
!     JJMorcrette, ECMWF, 20080325: dummy arguments for RADACT to allow for 
!                        using a new sulphate climatology in the ECMWF model
!     Y. Seity   2008-06-15: correct calculations of PFRTHDS, PFRSODS and PFCLL
!     Y. Seity   2008-09-29: phasing Chemistry corrections
!     O.Riviere  2008-10-01: introduction of new data flow for DDH in Arome
!     Y. Seity   2009-05-03: new version of EDKF and implementation of EDMF
!     Y. Seity   2009-10-03: add missed deallocations 
!     S. Riette  2009-03-25: Arguments modification for AROCLDIA to add HTKERAF
!     K. Yessad (Jul 2009): remove CDLOCK + some cleanings
!     A. Alias   2009-09-01: Sulfate and Volcano aerosols added (call radaer)
!     S. Riette  2010-01-19: ZZI_UM, ZZI_VM and ZDEPTH_HEIGHT are given
!                            ARO_GROUND_DIAG in 3D.                     
!     Y. Seity   2010-03-09: add PFEVN and PFEVL
!     Y. Bouteloup 2010-03-26 : Add PQLRAD et PQIRAD
!     Y. Seity : Test TKE > 0.
!     Y. Seity : Optimized version of EDKF + diag HCLS
!     Y. Seity : 2010-09 Save Ts at the end of apl_arome for ICMSH+0000
!     L. Bengtsson (2010): Introduce cloud diagnostics based on geop. 
!                               height (LWMOCLOUD), AND cloud-overlap assumptions 
!                               from C. Wittman 2009 (LACPANMX + WMXOV)
!     S. Riette: 2010-12 aro_ground_diag interface modified
!     Y. Seity: 2010-12 add hail diagnostic
!     R. El Khatib 30-Jun-2010 NEC directive noloopfusion to preserve critical regions
!     P.Marguinaud 2010-06-29 : KSURFEXCTL flag (disable SURFEX) 
!     2010-12    B. Decharme  : modify the radiative coupling with surfex (SW per band in ACRADIN and RADHEAT)
!     2011-02    A. Voldoire : add ZAERINDS to CALL RADAER and ACRADIN
!                              for sulfate indirect effect computation
!     2011-06: M. Jerczynski - some cleaning to meet norms
!     S. Riette: 2011-10 : Modifications for DUAL-MF scheme (according to Wim de Rooy's apl_arome version)
!                          Ice in EDKF
!     Y. Seity : 2012-03 : add LMNHLEV option to revert/or not arrays for MesoNH parameterisations
!     F. Bouttier: 2012-07 add SPPT stochastic physics
!
!     P. Marguinaud : 2012-09 : Add control threshold for orography
!     Y. Seity : 2013-01 Cleaning LMNHLEV and remove JPVEXT points
!     Y. Seity : 2013-02 Cleaning (add compute_neb)
!     L. Bengtsson: 2013-02: add LOLSMC and LOTOWNC options to compute (or not) cloud sedimentation
!                            using different cloud droplet number conc. depending on land/sea/town.
!     2013-11, D. Degrauwe: Introduction of radflex interface, export
!                           upper-air precipitation fluxes PFPR.
!     2013-11, J. Masek: Inclusion of ACRANEB2 radiation scheme.
!     S. Riette: 2013-11: subgrid precipitation
!     2016-04, J. Masek: LRNUEXP cloud overlap option (COMPUTE_NEB replaced
!                        by ACNPART), passing of sushine duration, fix of
!                        E. Gleeson for ACRANEB2 with SURFEX.
!     2016-12, J. Masek: Proper calculation of sunshine duration in ACRANEB2.
!     K.I Ivarsson 2018-02 : Some new variables for microphysics
! End modifications
!-------------------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK    ,DR_HOOK

! AROME SPECIFIC
USE YOMPARAR  ,ONLY : NGPAR    ,NRR      ,NSV      ,MINPRR   ,MINPRS   , &
   &        MINPRG   ,MACPRR   ,MACPRG   ,MACPRS   , &
   &        LDIAGWMAX,NDIAGWMAX,CSUBG_AUCV_RC     ,LOSIGMAS , &
   &        LOSUBG_COND        ,NSWB_MNH ,MSWDIR   ,MSWDIF   ,MALBDIR  , &
   &        MALBSCA  ,MVEMIS   ,MVTS     ,NPRINTFR ,NPTP     ,LSQUALL  , &
   &        NRRI     ,NRRL     ,LOWARM   ,LOLSMC   ,LOTOWNC  ,NSPLITR  , &
   &        NREFROI2 ,NREFROI1 , XSW_BANDS,MVQS    , &
   &        LOSEDIC  ,CMF_UPDRAFT,CMF_CLOUD,LMIXUV , &
   &        CSEDIM   ,VSIGQSAT ,LOCND2,LKOGAN,LMODICEDEP,RADSN,RADGR , LHARATU, &
   &        LTOTPREC,CSUBG_RC_RR_ACCR, CSUBG_RR_EVAP, CSUBG_RPR_PDF

USE YOMARPHY  ,ONLY : LMICRO   ,LTURB    ,LMSE     ,LKFBCONV ,LUSECHEM , &
   &        LRDUST   ,LMPA     ,CCOUPLING, LRCO2   ,LMFSHAL  ,LRDEPOS  , &
   &        LSURFEX_CRITICAL   ,LSURFEX_KFROM, NSURFEX_ITER
USE YOMMSE    ,ONLY : NSURFEXCTL, XZSEPS

! OTHERS
USE YOESW     ,ONLY : RSUN     ,RSUN2
USE YOMCST   , ONLY : RG       ,RCPD     ,RD       ,RATM     ,RTT      , &
   &        RCW      ,RCPV     ,RLVTT    ,RCS      ,RLSTT    ,RGAMW    , &
   &        RBETW    ,RALPW    ,RGAMS    ,RBETS    ,RALPS    ,RGAMD    , &
   &        RBETD    ,RALPD    ,RETV     ,RV       ,RKAPPA   ,RHOUR
USE YOERAD   , ONLY : NAER     ,NMODE    ,NRADFR   ,NSW      ,NOZOCL
USE YOERDI   , ONLY : RCARDI
USE YOMPHY   , ONLY : LRAYFM   ,LO3ABC   ,LAEROSUL, LAEROVOL ,LRSTAER  , &
   &        LRAY     ,NRAY     ,NSORAYFR ,LHLRADUPD,LRNUEXP
USE YOMPHY0  , ONLY : XMINLM   ,XMAXLM   ,AERCS1   ,AERCS3   ,AERCS5   , &
   &                  RDECRD1  ,RDECRD2  ,RDECRD3  ,RDECRD4
USE YOMPHY2  , ONLY : TSPHY
USE YOMPHY3  , ONLY : QCO2     ,RII0
USE YOMLDDH  , ONLY : LFLEXDIA
USE SURFACE_FIELDS_MIX     , ONLY : YSD_VAD
USE YOMTOPH  , ONLY : NTQSAT   ,NTRADI ,NTNEBU
USE YOMLUN   , ONLY : NULOUT
USE YOMCT0   , ONLY : LTWOTL, LSFORCS
USE YOMDYN   , ONLY : TSTEP
USE YOMGEM   , ONLY : NGPTOT
USE YOMSTA   , ONLY : STPREH
USE YOMVERT  , ONLY : YRVAB
USE YOMRIP   , ONLY : NINDAT   ,RHGMT    ,RSOVR    ,RDECLI   ,RCODEC   , &
   &                  RSIDEC   ,RSTATI
USE YOM_YGFL , ONLY : NGFL_EXT ,NGFL_EZDIAG, YIRAD, YLRAD
USE YOMNSV   , ONLY : NSV_CO2
USE YOMDIM   , ONLY : NPROMA,NDGUNG, NDGUXG, NDLUNG, NDLUXG
USE YOMXFU   , ONLY : LXXDIAGH
USE DDH_MIX, ONLY: ADD_FIELD_3D ! for new diag data flow
USE YOMPHYDS , ONLY : NSFORC
USE YOMSPSDT , ONLY : LSPSDT,YGPSDT
USE YOMLSFORC, ONLY : LMUSCLFA, IMUSCLFA, REMIS_FORC, RALB_FORC
USE STOPH_MIX, ONLY : LFORCENL, NFORCESTART, NFORCEEND, AMAGSTOPH 
! daand: radflex
USE INTFLEX_MOD, ONLY : LINTFLEX, LRADFLEX,                           &
 &                      TYPE_INTFIELD, TYPE_INTPROC, TYPE_INTPROCSET, &
 &                      NEWINTFIELD, NEWINTPROC, NEWINTPROCSET
USE MODD_CTURB , ONLY : XTKEMIN

!     --------------------------------------------------------------------------

IMPLICIT NONE

INTEGER(KIND=JPIM),INTENT(IN)    :: KLON
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV
INTEGER(KIND=JPIM),INTENT(IN)    :: KBL 
INTEGER(KIND=JPIM),INTENT(IN)    :: KGPCOMP 
INTEGER(KIND=JPIM),INTENT(IN)    :: KIDIA 
INTEGER(KIND=JPIM),INTENT(IN)    :: KFDIA 
INTEGER(KIND=JPIM),INTENT(IN)    :: KTDIA 
INTEGER(KIND=JPIM),INTENT(IN)    :: KSTEP 
INTEGER(KIND=JPIM),INTENT(IN)    :: KSGST
REAL(KIND=JPRB)   ,INTENT(IN)    :: PDT 
LOGICAL           ,INTENT(IN)    :: LDXFUMSE 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PINDX(KLON) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PINDY(KLON) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PGEMU(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PGELAM(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PGM(KLON) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: POROG(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PMU0(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PMU0LU(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PMU0M(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PMU0N(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PCLON(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PSLON(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PVO3ABC(KLON,3) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PLSM(KLON) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PAESEA(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PAELAN(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PAESOO(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PAEDES(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PAESUL(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PAEVOL(KLON)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PGP2DSDT(KLON,YGPSDT%NG2D)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PAPHIM(KLON,0:KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PAPHIFM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PAPRSM(KLON,0:KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PAPRSFM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PRDELPM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PDELPM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PTM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQVM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PCPM(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PRM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PALPHM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PLNPRM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQCM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQIM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQRM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQSM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQGM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PQHM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PTKEM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PEFB1(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PEFB2(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PEFB3(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PSVM(KLON,KLEV,NGFL_EXT)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PSIGM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PUM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PVM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PWM(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PFORCEU(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PFORCEV(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PFORCET(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PFORCEQ(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGPAR(KLON,NGPAR+1) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PEMTD(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PEMTU(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PTRSO(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGDEOSI(KLON,0:KLEV,2)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGUEOSI(KLON,0:KLEV,2)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGMU0(KLON,NSORAYFR)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGMU0_MIN(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGMU0_MAX(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGDEOTI(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGDEOTI2(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGUEOTI(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGUEOTI2(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGEOLT(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGEOXT(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGRPROX(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGMIXP(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGFLUXC(KLON,0:KLEV)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PGRSURF(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PCLFS(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PQLRAD(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PQIRAD(KLON,KLEV)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PSIGS(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PTENDT(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PTENDR(KLON,KLEV,NRR) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PTENDU(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PTENDV(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PTENDW(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PTENDTKE(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PTENDEFB1(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PTENDEFB2(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PTENDEFB3(KLON,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PTENDEXT(KLON,KLEV,NGFL_EXT)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PALBIN(KLON)

! daand: radflex; made target
REAL(KIND=JPRB)   ,INTENT(OUT), TARGET :: PFRTH(KLON,0:KLEV,KSGST+1)
REAL(KIND=JPRB)   ,INTENT(OUT), TARGET :: PFRSO(KLON,0:KLEV,KSGST+1)

REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRTHDS(KLON)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRSOPS(KLON)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRSDNI(KLON)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRSODS(KLON)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRSOPT(KLON)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRSOC(KLON,0:1)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRTHC(KLON,0:1)
REAL(KIND=JPRB)   ,INTENT(IN)    :: PEMIS(KLON) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PEZDIAG(KLON,KLEV,NGFL_EZDIAG)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PCLCH(KLON) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PCLCL(KLON) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PCLCM(KLON) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PCLCT(KLON) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFPLSL(KLON,0:KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFPLSN(KLON,0:KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFPLSG(KLON,0:KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFPLSH(KLON,0:KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PSTRTU(KLON,0:KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PSTRTV(KLON,0:KLEV) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFCS(KLON,KSGST+1) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFCLL(KLON,KSGST+1)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFCLN(KLON,KSGST+1)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFEVL(KLON,KSGST+1)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PFEVN(KLON,KSGST+1)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PUCLS(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PVCLS(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PTCLS(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PQCLS(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PHUCLS(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PUGST(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PVGST(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PPBLH(KLON)
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PSPSG(KLON) 
REAL(KIND=JPRB)   ,INTENT(INOUT) :: PSDUR(KLON)
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PDIAGH(KLON) 

REAL(KIND=JPRB)   ,INTENT(IN)    :: PSFORC(KLON,NSFORC)

! daand: radflex
TYPE(TYPE_INTPROCSET), INTENT(INOUT) :: YDPROCSET

!*
!     ------------------------------------------------------------------
!     DECLARATION DES TABLEAUX ARGUMENTS
! pour le rayonnement
!!    LOCAL VARIABLES :

!    4D arrays
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV,NRR) :: ZZI_RM, ZZI_RS, ZZI_RSAVE
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV,NRR) :: ZZI_PFPR
!    3D arrays
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZZZ,ZDZZ, ZZZF,ZDZZF,ZZI_PABSM, ZZI_THM, &
                & ZZI_THS, ZCIT, ZZI_MFM, ZZI_EXNREFM, ZZI_SIGM, ZZI_SIGS, &
                & ZZI_THSAVE, ZNEBMNH   , ZEVAP, &
! length scales for momentum and heat for mnh level definitions in case LHARATU=TRUE
                & ZZI_LENGTHM, ZZI_LENGTHH
REAL(KIND=JPRB), DIMENSION (KLON,KLEV) ::  ZQDM, ZQV, ZGEOSLC, ZQCO2

!    2D arrays
REAL(KIND=JPRB), DIMENSION (KLON,1) :: ZSEA, ZTOWN
REAL(KIND=JPRB), DIMENSION (KLON,1) :: ZINPRR, ZACPRR, ZINPRS, ZACPRS, ZINPRG
REAL(KIND=JPRB), DIMENSION (KLON,1) :: ZACPRG, ZINPRR_NOTINCR, ZINPRS_NOTINCR
REAL(KIND=JPRB), DIMENSION (KLON,1) :: ZINPRG_NOTINCR,ZINPRH_NOTINCR,ZINPRH
REAL(KIND=JPRB), DIMENSION (KLON,1) :: ZLAT, ZLON, ZZENITH, ZZS, ZALB_UV
REAL(KIND=JPRB) :: ZEMIS (KLON)
!    Integers
INTEGER(KIND=JPIM) :: JLEV, JLON, JRR, JGFL
INTEGER(KIND=JPIM) :: IJN  ! max. number of day/night slices within NRPOMA
INTEGER(KIND=JPIM) :: IKL  !ordering of vert levels 1:MNH -1:AROME
INTEGER(KIND=JPIM) :: IPOS,IOFF_MFSHAL, IEZDIAG_CHEM
INTEGER(KIND=JPIM) :: IKA,IKB,IKE,IKU,IKT,IKTE,IKTB ! vertical points as in mpa
INTEGER(KIND=JPIM) :: IMODE,JCHA,&
 & JSG, JAE ,JK, JR, JSW
INTEGER(KIND=JPIM) :: ILONMNH   ! useful size of klon arrays for mesonh physics
! Check TKE for LHARATU similar to CBR but in apl_arome
LOGICAL,DIMENSION(SIZE(PTKEM,1),SIZE(PTKEM,2)) :: GTKENEG
                   ! 3D mask .T. if TKE < XTKEMIN

!       Real
REAL(KIND=JPRB) :: ZAEO, ZAEN
REAL(KIND=JPRB) :: ZDT, ZDT2, ZINVDT, ZINVG, ZRSCP, ZINVATM, Z_WMAX, Z_WMIN
REAL(KIND=JPRB) :: ZALBD(KLON,NSW), ZALBP(KLON,NSW), ZALB(KLON)
REAL(KIND=JPRB) :: ZALBD1(KLON), ZALBP1(KLON), ZSALBCOR(KLON)
REAL(KIND=JPRB) :: ZTSURF(KLON), ZTN(KLON), ZQS(KLON), ZGZ0(KLON), ZGZ0H(KLON), ZTOWNS(KLON) 
REAL(KIND=JPRB) :: ZQSAT(KLON,KLEV)
! length scales for momentum and heat and TKE in case LHARATU=TRUE
REAL(KIND=JPRB) :: ZLENGTH_M(KLON,KLEV),ZLENGTH_H(KLON,KLEV)
REAL(KIND=JPRB) :: PTKEEDMF(KLON,KLEV)
REAL(KIND=JPRB) :: ZVETAH(0:KLEV)
REAL(KIND=JPRB) :: ZLH(KLON,KLEV), ZLSCPE(KLON,KLEV)
REAL(KIND=JPRB) :: ZQW(KLON,KLEV), ZTW(KLON,KLEV), ZRH(KLON,KLEV)
REAL(KIND=JPRB) :: ZFRSODS(KLON), ZFRSOPS(KLON)
REAL(KIND=JPRB) :: ZFRSOLU(KLON), ZFRTHDS(KLON)
REAL(KIND=JPRB) :: ZFRSOFS(KLON)
REAL(KIND=JPRB) :: ZFSDNN(KLON), ZFSDNV(KLON)
REAL(KIND=JPRB) :: ZQICE(KLON,KLEV), ZQLIQ(KLON,KLEV)
REAL(KIND=JPRB) :: ZQO3(KLON,0:KLEV), ZKAPM(KLON,KLEV)
REAL(KIND=JPRB) :: ZAER(KLON,KLEV,6), ZRAER(KLON,6,KLEV)
REAL(KIND=JPRB) :: ZAERINDS(KLON,KLEV)
REAL(KIND=JPRB) :: ZAERD(KLON,KLEV)
REAL(KIND=JPRB) :: ZAESUL(KLON), ZAEVOL(KLON)
REAL(KIND=JPRB) :: ZCARDI
REAL(KIND=JPRB) :: ZROZ(NGPTOT,KLEV)
REAL(KIND=JPRB) :: ZCHTIX(NGPTOT+2,KLEV+1), ZDUM(NGPTOT+2,KLEV)
REAL(KIND=JPRB) :: ZTENT(KLON,KLEV)
REAL(KIND=JPRB) :: ZTRSOD(KLON)
REAL(KIND=JPRB) :: ZCEMTR(KLON,KLEV+1), ZCTRSO(KLON,KLEV+1)
REAL(KIND=JPRB) :: ZSUDU(KLON), ZSDUR(KLON), ZDSRP(KLON)
REAL(KIND=JPRB) :: ZAESEA(KLON), ZAELAN(KLON), ZAESOO(KLON), ZAEDES(KLON)
REAL(KIND=JPRB) :: ZTM(KLON,KLEV), ZQVM(KLON,KLEV), ZQIM(KLON,KLEV)
REAL(KIND=JPRB) :: ZQCM(KLON,KLEV),ZQHM(KLON,KLEV), ZQHGM(KLON,KLEV)
REAL(KIND=JPRB) :: ZQRM(KLON,KLEV), ZQSM(KLON,KLEV), ZQGM(KLON,KLEV)
REAL(KIND=JPRB) :: ZCPM(KLON,KLEV), ZRHM(KLON,KLEV)
REAL(KIND=JPRB) :: ZZI_APHIM(KLON,0:KLEV), ZZI_APHIFM(KLON,KLEV)
! Stochastic physics pattern & dummy tendencies for calling sppten
REAL(KIND=JPRB) :: ZMULNOISE(KLON,KLEV)
REAL(KIND=JPRB) :: ZDUMMY(KLON,KLEV)
! POUR GROUND 
REAL(KIND=JPRB) :: ZZSFSWDIR(KLON,NSW), ZZSFSWDIF(KLON,NSW)
REAL(KIND=JPRB) :: ZTRSODIR (KLON,NSW), ZTRSODIF (KLON,NSW)
REAL(KIND=JPRB) :: ZDEPTH_HEIGHT(KLON,KLEV)
! Variables concerning updraft rain/snow for EDMF
REAL(KIND=JPRB) :: ZTENDTUP(KLON,KLEV)
REAL(KIND=JPRB) :: ZTENDQVUP(KLON,KLEV)
REAL(KIND=JPRB) :: ZSURFPREP(KLON)
REAL(KIND=JPRB) :: ZSURFSNOW(KLON)
REAL(KIND=JPRB) :: ZUPGENL(KLON,KLEV)
REAL(KIND=JPRB) :: ZUPGENN(KLON,KLEV)
REAL(KIND=JPRB) :: ZCLFR(KLON)
REAL(KIND=JPRB), DIMENSION (KLON,1) :: ZSSO_STDEV, ZTWSNOW
! AJOUT POUR TURB
!    4D arrays
REAL(KIND=JPRB),  DIMENSION(KLON,1,KLEV,NGFL_EXT):: ZZI_SVS, ZZI_SVM,&
                                                    & ZTENDSV_TURB 
REAL(KIND=JPRB),  DIMENSION (KLON,KLEV,NGFL_EZDIAG):: ZZI_PEZDIAG

!    3D arrays
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZTHVREFM  ! thetav de l etat 
  ! de reference dans mesoNH. En 1D, thetavref=thetavM, mais la question
  ! concernant la facon d initialiser cette variable dans le 3D reste ouverte. 
  ! (idem pour RHODREF)
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZZI_RHODREFM, ZZI_RHODJM, ZZI_RHO
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZZI_UM,ZZI_VM,ZZI_WM,&
                & ZZI_US, ZZI_VS, ZZI_WS, ZZI_WSAVE,&
                & ZZI_THLS, ZZI_RTS, ZZI_MFUS, ZZI_MFVS,&
                & ZTENDU_TURB,ZTENDV_TURB,&
                & ZTENDTHL_TURB,ZTENDRT_TURB

REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZZI_TKEM, ZZI_TKES, ZZI_TKESAVE
!Variables used in case LHARATU=TRUE
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZZI_PTKEEDMF
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZZI_TKEEDMFS

REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZSRCS 
REAL(KIND=JPRB), DIMENSION (KLON,KLEV) :: ZZI_CVTENDT, ZZI_CVTENDRV,&
                & ZZI_CVTENDRC, ZZI_CVTENDRI, ZZI_MFS

REAL(KIND=JPRB), DIMENSION (KLON) :: ZCVTENDPR, ZCVTENDPRS, ZZTOP

REAL(KIND=JPRB), DIMENSION(:,:,:), ALLOCATABLE :: ZEPSM ! Dissipation of TKE 
                                                     ! (eps) at time t-dt
REAL(KIND=JPRB), DIMENSION(:,:,:), ALLOCATABLE :: ZEPSS ! Dissipation  
                                                     ! of TKE at time t+dt
!    2D arrays
REAL(KIND=JPRB), DIMENSION(:,:),   ALLOCATABLE :: ZSFU  ! surface flux of x and
REAL(KIND=JPRB), DIMENSION(:,:),   ALLOCATABLE :: ZSFV  ! y component of wind
REAL(KIND=JPRB), DIMENSION(:,:),   ALLOCATABLE :: ZSFTH ! surface flux of theta
REAL(KIND=JPRB), DIMENSION(:,:),   ALLOCATABLE :: ZSFRV ! surface flux of vapor
REAL(KIND=JPRB), DIMENSION(:,:,:), ALLOCATABLE :: ZSFSV ! surf. flux of scalars
REAL(KIND=JPRB), DIMENSION(:,:),   ALLOCATABLE :: ZSFCO2 ! surface flux of CO2
REAL(KIND=JPRB) :: ZHOOK_HANDLE
LOGICAL :: LLMSE
LOGICAL :: LLMSE_PARAM
LOGICAL :: LLMSE_DIAG
INTEGER(KIND=JPIM), DIMENSION(KLON) :: ICLPH             !PBL top level
REAL(KIND=JPRB),  DIMENSION(KLON,1,KLEV,NGFL_EXT):: ZZI_SVSAVE
INTEGER (KIND=JPIM) :: IDAY,IYEAR,IMONTH
REAL(KIND=JPRB), DIMENSION(KLON,KLEV,NSWB_MNH):: ZPIZA_DST !Single scattering
                                             ! albedo of dust (points,lev,wvl)
REAL(KIND=JPRB), DIMENSION(KLON,KLEV,NSWB_MNH):: ZCGA_DST  !Assymetry factor
                                             ! for dust (points,lev,wvl)
REAL(KIND=JPRB), DIMENSION(KLON,KLEV,NSWB_MNH):: ZTAUREL_DST !tau/tau_{550} 
                                             !dust (points,lev,wvl)
 ! pas de temps pour la surface externalise
REAL(KIND=JPRB) :: ZDTMSE,ZRHGMT
REAL(KIND=JPRB), DIMENSION(:), ALLOCATABLE :: ZCFAQ, ZCFBQ, ZCFATH
REAL(KIND=JPRB), DIMENSION(:), ALLOCATABLE :: ZCFBTH, ZCFAU
REAL(KIND=JPRB), DIMENSION(:), ALLOCATABLE :: ZCFBU, ZCFBV
! Ajout pour MF scheme (Pergaud et al)
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZSIGMF, ZRC_MF, ZRI_MF, ZCF_MF, ZFLXZTHVMF
!wc for new stat cloud set up sum dry and wet updraft contribution to variance s
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV) :: ZFLXZTHVMF_SUM, ZSIGMF_SUM
! Ajout pour MF Dual Scheme (KNMI et al)
! Updraft characteristics in Arpege/IFS world
REAL(KIND=JPRB), DIMENSION(:,:,:), ALLOCATABLE :: ZMF_UP, ZTHETAL_UP, ZQT_UP, &
  &   ZQC_UP, ZQI_UP, ZU_UP, ZV_UP,ZTHTV_UP
REAL(KIND=JPRB), DIMENSION (KLON) :: ZZSFTH,ZZSFRV,ZZSFU,ZZSFV
INTEGER(KIND=JPIM) :: IDRAFT,JDRAFT,INDRAFT
! Updraft characteristics for Meso-NH world (input of ARO_SHALLOW_MF)
REAL(KIND=JPRB), DIMENSION (KLON,1,KLEV)::ZZI_MF_UP,ZZI_THETAL_UP,ZZI_RT_UP,&
          &      ZZI_RC_UP,ZZI_RI_UP,ZZI_ZU_UP,ZZI_ZV_UP,ZZI_THETAV_UP,&
          &      ZZI_ZW_UP, ZZI_ZFRAC_UP, ZZI_ZRV_UP

! specific to new data flow for diagnostics
REAL(KIND=JPRB)   :: ZTENDBKP(KLON,KLEV),ZTMPAF(KLON,KLEV)
REAL(KIND=JPRB)   :: ZBUDTH (KLON),ZBUDSO(KLON),ZFCLL(KLON)
CHARACTER(LEN=11) :: CLNAME
CHARACTER(LEN=2),DIMENSION(7):: CLVARNAME=&
&(/"QV","QL","QR","QI","QS","QG","QH"/)
INTEGER(KIND=JPIM) :: ISURFEX

! Surface forcing arrays for MUSC

REAL(KIND=JPRB) :: ZRHODREFM(KLON), ZTHETAS(KLON)
LOGICAL         :: LLAROME
! logical to choose for update cloud scheme or not
LOGICAL         :: STATNEW

! ACRANEB2 local variables
REAL(KIND=JPRB) :: ZEPSNEB
REAL(KIND=JPRB) :: ZNEB0(KLON,KLEV)
REAL(KIND=JPRB) :: ZCLCT_RAD(KLON)       ! total cloud cover for radiation
REAL(KIND=JPRB) :: ZDECRD   (KLON)       ! decorrelation depth

! daand: radflex
REAL(KIND=JPRB), POINTER :: ZFRSO(:,:), ZFRTH(:,:)
REAL(KIND=JPRB)  :: ZFPR(KLON,0:KLEV,NRR)
LOGICAL :: LLRAD
TYPE(TYPE_INTPROC), POINTER :: YLRADPROC

REAL(KIND=JPRB)   :: ZCD(KLON)
! local areas for OCND2 option:
! ZICLDFR = ice cloud fraction , ZWCLDFR = water or mixed-phase cloud fraction,
! ZSSIO = Super-saturation with respect to ice in ZICLDFR , 
! ZSSIU = Sub-saturation with respect to ice outside ZICLDFR,
! ZIFR = variable used for calulation of subgridscale ice
REAL(KIND=JPRB),  DIMENSION (KLON,1,KLEV) :: ZICLDFR,ZWCLDFR,ZSSIO,ZSSIU,ZIFR
! Corresponding 2-D areas :
REAL(KIND=JPRB),  DIMENSION (KLON,KLEV) :: ZICLDFR2,ZWCLDFR2,ZSSIO2,ZSSIU2,ZIFR2
! end 

!     --------------------------------------------------------------------------

#include "abor1.intfb.h"
#include "acradin.intfb.h"
#include "acraneb2.intfb.h"
#include "actqsat.intfb.h"
#include "acnpart.intfb.h"
#include "bri2acconv.intfb.h"
#include "gpgeo.intfb.h"
#include "gprcp.intfb.h"
#include "radheat.intfb.h"
#include "suozon.intfb.h"
#include "radaer.intfb.h"
#include "radact.intfb.h"
#include "radozc.intfb.h"
#include "arocldia.intfb.h"
#include "aro_rain_ice.h"
#include "aro_turb_mnh.h"
#include "aro_adjust.h"
#include "aro_mnhc.h"
#include "aro_mnhdust.h"
#include "aro_startbu.h"
#include "aro_convbu.h"
#include "aro_ground_param.h"
#include "aro_ground_diag.h"
#include "aro_shallow_mf.h"
#include "vdfhghthl.intfb.h"
#include "aro_rainaero.h"
#include "sppten.intfb.h"

! daand: radflex
#include "apl_arome2intflex.intfb.h"

!     ------------------------------------------------------------------
#include "surf_ideal_flux.intfb.h"
#include "fcttrm.func.h"
!     --------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('APL_AROME',0,ZHOOK_HANDLE)
!     --------------------------------------------------------------------------

!    ------------------------------------------------------------------
!     1 - Initialisations
!    - --------------------------------------------------------------------

!        1.0 numerical safety

ZEPSNEB=1.E-12

!        1.1 necessary allocations

! necessary if fourth dim = 0

ALLOCATE(ZCFAQ(KLON))
ALLOCATE(ZCFBQ(KLON))
ALLOCATE(ZCFATH(KLON))
ALLOCATE(ZCFBTH(KLON))
ALLOCATE(ZCFAU(KLON))
ALLOCATE(ZCFBU(KLON))
ALLOCATE(ZCFBV(KLON))
NSV=0
IPOS=1

! case  CTURBLEN =/ KEPS (anyway, option KEPS does not work well in MNH)
ALLOCATE(ZEPSM (0,0,0))
ALLOCATE(ZEPSS (0,0,0))

!        1.2 allocations of variables used in more than one parameterization

ALLOCATE(ZSFU  (KLON,1))         ! surface schemes + turbulence
ALLOCATE(ZSFV  (KLON,1))
ALLOCATE(ZSFTH (KLON,1))
ALLOCATE(ZSFRV (KLON,1))

ALLOCATE(ZSFSV (KLON,1,NGFL_EXT))
ALLOCATE(ZSFCO2 (KLON,1))

!wc logical for new statistical cloud set up
!STATNEW=.FALSE.
STATNEW=.TRUE.

!         1.3 time step initialisation
!             the mesoNH physics (turb and microphysics) is written 
!             for leap frog scheme
!             !!! be carefull for 2TL or 3TL 

IF (LTWOTL) THEN
  ZDT=PDT/2._JPRB
ELSE
  IF (KSTEP/=0) THEN
    ZDT=PDT/2._JPRB
  ELSE
    ZDT=PDT
  ENDIF
ENDIF

ZINVDT=1/PDT

! initialisation de ZDTMSE
IF (LDXFUMSE) THEN
  ZDTMSE=0.01_JPRB
ELSE
  ZDTMSE=PDT
ENDIF

IF(LTWOTL) THEN
  ZRHGMT=REAL(RHGMT,JPRB)-ZDTMSE/2._JPRB
ELSE
  ZRHGMT=REAL(RHGMT,JPRB)
ENDIF


LLMSE=LMSE.AND.(NSURFEXCTL >= 2)
LLMSE_PARAM=LLMSE
LLMSE_DIAG=LLMSE.AND.(NSURFEXCTL >= 3)

!  SETUP OF TENDENCIES

PTENDT=0.0_JPRB
PTENDU=0.0_JPRB
PTENDV=0.0_JPRB
PTENDW=0.0_JPRB
PTENDR=0.0_JPRB
PTENDTKE=0.0_JPRB
PTENDEXT=0.0_JPRB
!  FIELDS TO BE ADJUSTED (local arrays modified by ac_adjust)

ZQVM=PQVM
ZQIM=PQIM
ZQCM=PQCM
ZQRM=PQRM
ZQSM=PQSM
ZQGM=PQGM
IF (NRR==7) THEN
  ZQHM=PQHM
ELSE
  ZQHM=0._JPRB
ENDIF 
ZTM=PTM
ZZI_APHIM=PAPHIM
ZZI_APHIFM=PAPHIFM

!  SIZE OF ARRAY FOR TURB AND Microphysics
ILONMNH=KFDIA-KIDIA+1
!  Vertical points
IKA=KLEV
IKB=KLEV
IKE=1
IKU=1
IKT=KLEV
IKTE=KLEV
IKTB=1
IKL=-1

!  SETUP

ZQSAT=0.0_JPRB
ZFRSOFS=0.0_JPRB
ZLH=0.0_JPRB
ZLSCPE=0.0_JPRB
ZGEOSLC=0.0_JPRB
ZQW=0.0_JPRB
ZRH=0.0_JPRB
ZTW=0.0_JPRB
ZZI_UM=0.0_JPRB
ZZI_US=0.0_JPRB
ZZI_VM=0.0_JPRB
ZZI_VS=0.0_JPRB
ZZI_WM=0.0_JPRB
ZZI_THM=293._JPRB
ZZI_THS=0._JPRB
ZZI_THLS=0._JPRB
ZZI_MFUS=0._JPRB
ZZI_MFVS=0._JPRB
ZZI_RM=0.0_JPRB
ZZI_SVM=0.0_JPRB
ZZI_RHODREFM=1.0_JPRB
ZZI_RHO=1.0_JPRB
ZZI_PABSM=101325._JPRB
ZZZ=0.0_JPRB
ZSURFPREP=0.0_JPRB
ZSURFSNOW=0.0_JPRB
ZINPRR=0.0_JPRB
ZINPRS=0.0_JPRB
ZINPRG=0.0_JPRB
ZINPRH=0.0_JPRB
ZACPRR=0.0_JPRB
ZACPRS=0.0_JPRB
ZACPRG=0.0_JPRB
ZEVAP=0.0_JPRB
ZINPRR_NOTINCR=0.0_JPRB
ZINPRS_NOTINCR=0.0_JPRB
ZINPRG_NOTINCR=0.0_JPRB
ZINPRH_NOTINCR=0.0_JPRB
ZSFTH=0.0_JPRB
ZSFRV=0.0_JPRB
ZSFCO2=0.0_JPRB
ZEMIS=1.0_JPRB
ZQICE=0.0_JPRB
ZQLIQ=0.0_JPRB
ZQO3=0.0_JPRB
ZAER=0.0_JPRB
ZAERINDS=0.0_JPRB
ZAERD=0.0_JPRB
ZPIZA_DST  = 0.0_JPRB
ZCGA_DST   = 0.0_JPRB
ZTAUREL_DST = 1E-12_JPRB
ZCARDI=0.0_JPRB
ZTENT=0.0_JPRB
ZTRSOD=0.0_JPRB
ZCEMTR=0.0_JPRB
ZCTRSO=0.0_JPRB
PFRSOC=0.0_JPRB
PFRTHC=0.0_JPRB
ZSUDU=0.0_JPRB   
ZSDUR=0.0_JPRB
ZDSRP=0.0_JPRB
ZALBD=0.0_JPRB
ZALBP=0.0_JPRB
ZALBD1=0.0_JPRB
ZALBP1=0.0_JPRB
ZZSFSWDIR=0.0_JPRB
ZZSFSWDIF=0.0_JPRB
ZTRSODIF=0.0_JPRB
ZTRSODIR=0.0_JPRB      
ZQV=0.0_JPRB
ZSFU=0.0_JPRB
ZSFV=0.0_JPRB
ZSFSV=0.0_JPRB
ZNEBMNH=0.0_JPRB
ZSRCS=0.0_JPRB
ZZI_MFM=0.0_JPRB
ZZI_MFS=0.0_JPRB
ZZI_SIGM=0.0_JPRB
ZZI_SIGS=0.0_JPRB
ZSIGMF=0.0_JPRB
ZSIGMF_SUM=0.0_JPRB
ZRC_MF=0.0_JPRB
ZRI_MF=0.0_JPRB
ZCF_MF=0.0_JPRB
ZFLXZTHVMF=0.0_JPRB
ZFLXZTHVMF_SUM=0.0_JPRB
ZZI_SVS=0.0_JPRB
!
! Variables used in case LHARATU=true
ZZI_LENGTHM=0.01_JPRB
ZZI_LENGTHH=0.01_JPRB
ZLENGTH_M=0.01_JPRB
ZLENGTH_H=0.01_JPRB
ZZI_PTKEEDMF=0._JPRB
ZZI_TKEEDMFS=0._JPRB
PTKEEDMF=0._JPRB

PDIAGH=0._JPRB

!  IF LHARATU=TRUE
!  TKE at t-dt is needed as input for vdfexcuhl so fill PTKEEDMF with t-1 value
!  from PTKEM
IF (LHARATU) THEN
   DO JLON = KIDIA, KFDIA
      DO JLEV=1, KLEV
         PTKEEDMF(JLON,JLEV)=PTKEM(JLON,JLEV)
      ENDDO
   ENDDO
ENDIF


!test TKE > 0.
IF (MINVAL(PTKEM(KIDIA:KFDIA,:)) <= 0._JPRB) THEN
  CALL ABOR1('TKE < 0 under APL_AROME check YTKE_NL%NREQIN')
ENDIF

!test invalid combinations
IF (LHARATU .AND. CMF_UPDRAFT == 'EDKF') THEN
  CALL ABOR1('Combination LHARATU and EDKF not valid!')
ENDIF

!initialisation of first useful field for EZDIAG use in Chemistry/Dust
IOFF_MFSHAL=1

DO JLEV = KTDIA, KLEV
  DO JLON = KIDIA, KFDIA
    ZCPM(JLON,JLEV)=PCPM(JLON,JLEV)
  ENDDO
ENDDO
DO JCHA = 1, 6
  DO JLEV = KTDIA, KLEV
    DO JLON = KIDIA, KFDIA
      ZAER(JLON,JLEV,JCHA)=0.0_JPRB
    ENDDO
  ENDDO
ENDDO

!        1.4 decorrelation depth for cloud overlaps
IF ( LRNUEXP ) THEN
  DO JLON=KIDIA,KFDIA
    ZDECRD(JLON)=RDECRD1+RDECRD2* &
     & EXP(-((ASIN(PGEMU(JLON))-RDECRD3*RDECLI)/RDECRD4)**2)
  ENDDO
ENDIF

!    ------------------------------------------------------------------
!     2 - CHANGEMENTS DE VARIABLES ET INVERSION DES NIVEAUX 
!     --------------------------------------------------------------------
IF (LMICRO.OR.LTURB.OR.LLMSE.OR.LKFBCONV) THEN

  ZINVG=1/RG 
  !initialisation de ZZZ
  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      ZZZ(JLON,1,JLEV)=ZZI_APHIM(JLON,JLEV)*ZINVG
      ZZZF(JLON,1,JLEV)=ZZI_APHIFM(JLON,JLEV)*ZINVG
    ENDDO
  ENDDO
   
   !initialisation de qdm (utile localement pour calculer rho  
   !et convertir q en r 
  DO JLEV=1,KLEV
    DO JLON= KIDIA, KFDIA
      ZQDM(JLON,JLEV)=1._JPRB-ZQVM(JLON,JLEV)-ZQCM(JLON,JLEV)-ZQRM(JLON,JLEV) &
       & -ZQIM(JLON,JLEV)-ZQSM(JLON,JLEV)-ZQGM(JLON,JLEV)-ZQHM(JLON,JLEV)   
    ENDDO
  ENDDO
   
   !initialisation de ZZI_RHODREFM (=qd*zrho) 
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_RHO(JLON,1,JLEV)=PAPRSFM(JLON,JLEV)/&
       & (PRM(JLON,JLEV)*ZTM(JLON,JLEV))
      ZZI_RHODREFM(JLON,1,JLEV)=ZZI_RHO(JLON,1,JLEV)*ZQDM(JLON,JLEV)
      ZZI_RHODJM(JLON,1,JLEV)=PDELPM(JLON,JLEV)*ZINVG
    ENDDO
  ENDDO

  !initialisation de ZZI_EXNREFM
  ZRSCP=RD/RCPD
  ZINVATM=1/RATM
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_EXNREFM(JLON,1,JLEV)=(PAPRSFM(JLON,JLEV)*ZINVATM)**(ZRSCP)
    ENDDO
  ENDDO
   
  !initialisation de ZZI_PABSM
  DO JLON = KIDIA,KFDIA
    DO JLEV = 1, KLEV 
      ZZI_PABSM(JLON,1,JLEV)=PAPRSFM(JLON,JLEV)
    ENDDO
  ENDDO

 ! vent horizontal et TKE
  DO JLEV = 1, KLEV 
    DO JLON = KIDIA,KFDIA
      ZZI_UM(JLON,1,JLEV)= PUM(JLON,JLEV)
      ZZI_VM(JLON,1,JLEV)= PVM(JLON,JLEV)
      ZZI_WM(JLON,1,JLEV)= PWM(JLON,JLEV)
      ZZI_TKEM(JLON,1,JLEV)= PTKEM(JLON,JLEV)
    ENDDO
  ENDDO
  !initialise sigma for subgrid condensation comming
  !from previous time step turbulence scheme
  IF (LOSIGMAS) THEN
    DO JLEV = 1, KLEV 
      DO JLON = KIDIA,KFDIA
        ZZI_SIGM(JLON,1,JLEV)= PSIGM(JLON,JLEV)
      ENDDO
    ENDDO
  ENDIF
  !initialise convective mas flux for subgrid condensation comming 
  !from previous time step convection scheme
  IF ( LKFBCONV.AND.LOSUBG_COND.AND..NOT.LOSIGMAS) THEN
    DO JLEV = 1, KLEV 
      DO JLON = KIDIA,KFDIA
        ZZI_MFM(JLON,1,JLEV)=PSIGM(JLON,JLEV) 
      ENDDO
    ENDDO
  ENDIF
!!! initialisation des variables d etat MNH �t

  !initialisation de ZZI_THM
  DO JLEV = 1, KLEV 
    DO JLON = KIDIA,KFDIA
      ZZI_THM(JLON,1,JLEV)=ZTM(JLON,JLEV)/ZZI_EXNREFM(JLON,1,JLEV)
    ENDDO
  ENDDO

  !initialisation de ZZI_RM pour les hydrometeores (ri=qi/qd)
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_RM(JLON,1,JLEV,1)=ZQVM(JLON,JLEV)&
       & /ZQDM(JLON,JLEV)  
    ENDDO
  ENDDO
   
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_RM(JLON,1,JLEV,2)=ZQCM(JLON,JLEV)&
       & /ZQDM(JLON,JLEV)  
    ENDDO
  ENDDO
   
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_RM(JLON,1,JLEV,3)=ZQRM(JLON,JLEV)&
       & /ZQDM(JLON,JLEV)  
    ENDDO
  ENDDO
   
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_RM(JLON,1,JLEV,4)=ZQIM(JLON,JLEV)&
       & /ZQDM(JLON,JLEV)  
    ENDDO
  ENDDO
   
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_RM(JLON,1,JLEV,5)=ZQSM(JLON,JLEV)&
       & /ZQDM(JLON,JLEV)  
    ENDDO
  ENDDO
   
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_RM(JLON,1,JLEV,6)=ZQGM(JLON,JLEV)&
       & /ZQDM(JLON,JLEV)  
    ENDDO
  ENDDO
  
  IF (NRR==7) THEN
    DO JLEV = 1, KLEV
      DO JLON = KIDIA,KFDIA
        ZZI_RM(JLON,1,JLEV,7)=ZQHM(JLON,JLEV)&
         & /ZQDM(JLON,JLEV)  
      ENDDO
    ENDDO
  ENDIF
   
  IF (NRR==6) THEN
    !initialisation de ZTHVREFM
    DO JLEV = 1, KLEV 
      DO JLON = KIDIA,KFDIA
        ZTHVREFM(JLON,1,JLEV)=ZZI_THM(JLON,1,JLEV)*&
         & (1._JPRB+ZZI_RM(JLON,1,JLEV,1)*(RV/RD))/&
         & (1._JPRB+ZZI_RM(JLON,1,JLEV,1)+ZZI_RM(JLON,1,JLEV,2) +&
         &  ZZI_RM(JLON,1,JLEV,3)+ZZI_RM(JLON,1,JLEV,4)+   &
         &  ZZI_RM(JLON,1,JLEV,5)+ZZI_RM(JLON,1,JLEV,6))
      ENDDO
    ENDDO
  ELSEIF (NRR==7) THEN
    DO JLEV = 1, KLEV 
      DO JLON = KIDIA,KFDIA
        ZTHVREFM(JLON,1,JLEV)=ZZI_THM(JLON,1,JLEV)*&
         & (1._JPRB+ZZI_RM(JLON,1,JLEV,1)*(RV/RD))/&
         & (1._JPRB+ZZI_RM(JLON,1,JLEV,1)+ZZI_RM(JLON,1,JLEV,2) +&
         &  ZZI_RM(JLON,1,JLEV,3)+ZZI_RM(JLON,1,JLEV,4)+   &
         &  ZZI_RM(JLON,1,JLEV,5)+ZZI_RM(JLON,1,JLEV,6)+   &
         &  ZZI_RM(JLON,1,JLEV,7) )
      ENDDO
    ENDDO
  ENDIF
  !initialisation des scalaires passifs
  IF (NGFL_EXT/=0) THEN
    DO JGFL=1,NGFL_EXT
      DO JLEV = 1, KLEV
        DO JLON=KIDIA,KFDIA
          ZZI_SVM(JLON,1,JLEV,JGFL)=PSVM(JLON,JLEV,JGFL)
        ENDDO
      ENDDO
    ENDDO

  ENDIF

!!! initialisation des variables d etat MNH a t+dt
!!! division pas le pas de temps
!!!(la multiplication par rhodj est faite plus tard, si necessaire, 
!!! suivant les parametrisations)   

  ! vent horizontal
  DO JLEV = 1, KLEV 
    DO JLON=KIDIA,KFDIA
      ZZI_US(JLON,1,JLEV)= PUM(JLON,JLEV)*ZINVDT
      ZZI_VS(JLON,1,JLEV)= PVM(JLON,JLEV)*ZINVDT
      ZZI_WS(JLON,1,JLEV)= PWM(JLON,JLEV)*ZINVDT
      ZZI_TKES(JLON,1,JLEV)= PTKEM(JLON,JLEV)*ZINVDT
    ENDDO
  ENDDO

  !initialisation de ZZI_THS
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_THS(JLON,1,JLEV)=ZZI_THM(JLON,1,JLEV)*ZINVDT
    ENDDO
  ENDDO

  !initialisation de ZZI_RS pour les hydrometeores
  DO JRR=1,NRR 
    DO JLEV = 1, KLEV
      DO JLON=KIDIA,KFDIA
        ZZI_RS(JLON,1,JLEV,JRR)=ZZI_RM(JLON,1,JLEV,JRR)*ZINVDT
      ENDDO
    ENDDO
  ENDDO

!!! Initialisations temporaires d'arguments non-utilises
  !initialisation de ZCIT
  DO JLEV = 1 , IKT
    DO JLON = KIDIA,KFDIA
      ZCIT(JLON,1,JLEV)=0.0_JPRB
    ENDDO
  ENDDO
  
  !initialisation des tableaux de precipitations inst. and cumulated 
  !and surface fluxes for turbulence
  IF(LLMSE.OR.LSFORCS) THEN
    DO JLON = KIDIA,KFDIA
      ZACPRR(JLON,1)=PGPAR(JLON,MACPRR)
      ZACPRS(JLON,1)=PGPAR(JLON,MACPRS)
      ZACPRG(JLON,1)=PGPAR(JLON,MACPRG)
      ZINPRR_NOTINCR(JLON,1)=PGPAR(JLON,MINPRR)
      ZINPRS_NOTINCR(JLON,1)=PGPAR(JLON,MINPRS)
      ZINPRG_NOTINCR(JLON,1)=PGPAR(JLON,MINPRG)
    ENDDO
  ENDIF
  !initialisation des scalaires passifs
  IF (NGFL_EXT/=0) THEN
   DO JGFL=1,NGFL_EXT
    DO JLEV = 1, KLEV
      DO JLON=KIDIA,KFDIA
        ZZI_SVS(JLON,1,JLEV,JGFL)=ZZI_SVM(JLON,1,JLEV,JGFL)*ZINVDT
      ENDDO
    ENDDO
   ENDDO
  ENDIF

ENDIF

! daand: radflex
ZFRSO => PFRSO(:,:,1)
ZFRTH => PFRTH(:,:,1)

!    ------------------------------------------------------------------
!     3 - PRINTS FOR DIAGNOSTICS IF NEEDED
!    ------------------------------------------------------------------
IF (LDIAGWMAX) THEN
  IF (MOD(KSTEP+1,NDIAGWMAX)==0) THEN
  ! calcul de wmax
    DO JLEV = 1 , KLEV
      Z_WMAX=0._JPRB
      Z_WMIN=0._JPRB
      DO JLON=KIDIA,KFDIA
        IF (PWM(JLON,JLEV)>Z_WMAX) THEN
          Z_WMAX=PWM(JLON,JLEV)
        ENDIF
        IF (PWM(JLON,JLEV)<Z_WMIN) THEN
          Z_WMIN=PWM(JLON,JLEV)
        ENDIF
      ENDDO
    ENDDO
  ENDIF
ENDIF



  ZZI_THSAVE(:,:,:)=ZZI_THS(:,:,:)
  ZZI_RSAVE=ZZI_RS

!    ------------------------------------------------------------------
!     4 - ADJUSTMENT (CALLED IF THE MICROPHYSICS IS SWITCH ON) 
!    ------------------------------------------------------------------
IF (LMICRO) THEN

IF (LMFSHAL .AND. (CMF_CLOUD=='DIRE'.OR.CMF_CLOUD=='BIGA')) THEN
  IOFF_MFSHAL=IOFF_MFSHAL+3
  IF (KSTEP==0) THEN
     ZRC_MF=0.
     ZRI_MF=0.
     ZCF_MF=0.
  ELSE
  DO JLEV = 1, KLEV 
    DO JLON = KIDIA,KFDIA
      ZRC_MF(JLON,1,JLEV)=PEZDIAG(JLON,JLEV,1)
      ZRI_MF(JLON,1,JLEV)=PEZDIAG(JLON,JLEV,3)
      ZCF_MF(JLON,1,JLEV)=PEZDIAG(JLON,JLEV,2)
    ENDDO
  ENDDO
  ENDIF
PEZDIAG=0.
ENDIF

  IF (MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)'avant aro_adjust sous apl_arome'
    WRITE(NULOUT,*)'JLEV   ZZZF   RHODJM   EXNREFM   ',&
     & '    PABSM       THM      SIGM         MFM    '   
    DO JLEV=1,KLEV+1 
      WRITE(NULOUT,'(I2,x,7f10.3)')JLEV,ZZZF(NPTP,1,JLEV),ZZI_RHODJM(NPTP,1,JLEV),&
       & ZZI_EXNREFM(NPTP,1,JLEV),&
       & ZZI_PABSM(NPTP,1,JLEV), ZZI_THM(NPTP,1,JLEV), ZZI_SIGM(NPTP,1,JLEV),&
       & ZZI_MFM(NPTP,1,JLEV)  
    ENDDO 
    WRITE (NULOUT,*)'JLEV  rhoQv  rhoQc   rhoQr   rhoQi   rhoQs   rhoQg'
    DO JLEV=1,KLEV
      WRITE(NULOUT,'(I2,x,6e11.4)')JLEV,ZZI_RM(NPTP,1,JLEV,1), &
       & ZZI_RM(NPTP,1,JLEV,2),&
       & ZZI_RM(NPTP,1,JLEV,3),ZZI_RM(NPTP,1,JLEV,4),ZZI_RM(NPTP,1,JLEV,5),&
       & ZZI_RM(NPTP,1,JLEV,6)  
    ENDDO
    WRITE (NULOUT,*)'JLEV  ZRC_MF  ZRI_MF  ZCF_MF ZZI_THS  ZSRCS ZNEBMNH'
   DO JLEV=1,KLEV
      WRITE(NULOUT,'(I2,x,6e11.4)')JLEV,ZRC_MF(NPTP,1,JLEV), &
       & ZRI_MF(NPTP,1,JLEV),ZCF_MF(NPTP,1,JLEV),&
       & ZZI_THS(NPTP,1,JLEV),ZSRCS(NPTP,1,JLEV),&
       & ZNEBMNH(NPTP,1,JLEV)
   ENDDO
  ENDIF
  CALL ARO_ADJUST (KLEV,IKU,IKL,ILONMNH,KLEV,NRR,KSTEP+1,&
   & LOSUBG_COND, LOSIGMAS, LOCND2, &
   & ZDT,VSIGQSAT,ZZZF(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_RHODJM(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_EXNREFM(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_PABSM(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_THM(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_RM(KIDIA:KFDIA,:,1:KLEV,:),ZZI_SIGM(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_MFM(KIDIA:KFDIA,:,1:KLEV),ZRC_MF(KIDIA:KFDIA,:,1:KLEV),&
   & ZRI_MF(KIDIA:KFDIA,:,1:KLEV),ZCF_MF(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_THS(KIDIA:KFDIA,:,1:KLEV),ZZI_RS(KIDIA:KFDIA,:,1:KLEV,:),&
   & ZSRCS(KIDIA:KFDIA,:,1:KLEV),ZNEBMNH(KIDIA:KFDIA,:,1:KLEV),&  
   & ZICLDFR(KIDIA:KFDIA,:,1:KLEV),ZWCLDFR(KIDIA:KFDIA,:,1:KLEV),& 
   & ZSSIO(KIDIA:KFDIA,:,1:KLEV),ZSSIU(KIDIA:KFDIA,:,1:KLEV),& 
   & ZIFR(KIDIA:KFDIA,:,1:KLEV))
  
  IF (MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)'apres aro_adjust sous apl_arome'
    WRITE(NULOUT,*)'JLEV   ZZZF   RHODJM   EXNREFM   ',&
     & '    PABSM       THM      SIGM         MFM    '   
    DO JLEV=1,KLEV+1 
      WRITE(NULOUT,'(I2,x,7f10.3)')JLEV,ZZZF(NPTP,1,JLEV),ZZI_RHODJM(NPTP,1,JLEV),&
       & ZZI_EXNREFM(NPTP,1,JLEV),&
       & ZZI_PABSM(NPTP,1,JLEV), ZZI_THM(NPTP,1,JLEV), ZZI_SIGM(NPTP,1,JLEV),&
       & ZZI_MFM(NPTP,1,JLEV)  
    ENDDO 
    WRITE (NULOUT,*)'JLEV  rhoQv  rhoQc   rhoQr   rhoQi   rhoQs   rhoQg'
    DO JLEV=1,KLEV
      WRITE(NULOUT,'(I2,x,6e11.4)')JLEV,ZZI_RS(NPTP,1,JLEV,1), &
       & ZZI_RS(NPTP,1,JLEV,2),&
       & ZZI_RS(NPTP,1,JLEV,3),ZZI_RS(NPTP,1,JLEV,4),ZZI_RS(NPTP,1,JLEV,5),&
       & ZZI_RS(NPTP,1,JLEV,6)  
    ENDDO
    WRITE (NULOUT,*)'JLEV  ZRC_MF  ZRI_MF  ZCF_MF ZZI_THS ZSRCS ZNEBMNH'
   DO JLEV=1,KLEV
      WRITE(NULOUT,'(I2,x,6e11.4)')JLEV,ZRC_MF(NPTP,1,JLEV), &
       & ZRI_MF(NPTP,1,JLEV),ZCF_MF(NPTP,1,JLEV),&
       & ZZI_THS(NPTP,1,JLEV),ZSRCS(NPTP,1,JLEV),&
       & ZNEBMNH(NPTP,1,JLEV)
   ENDDO
  ENDIF
  !adjusted zthm and zrm
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZI_THM(JLON,1,JLEV)=ZZI_THS(JLON,1,JLEV)*PDT
    ENDDO
  ENDDO

  DO JRR=1,NRR
    DO JLEV = 1, KLEV
      DO JLON = KIDIA,KFDIA
        ZZI_RM(JLON,1,JLEV,JRR)=ZZI_RS(JLON,1,JLEV,JRR)*PDT
      ENDDO
    ENDDO
  ENDDO

  !initialisation de qdm utile pour 
  !convertir tendance de r en tendance de q 
  IF (NRR==6) THEN
    DO JLEV=1,KLEV
      DO JLON= KIDIA, KFDIA
        ZQDM(JLON,JLEV)=1._JPRB/(1._JPRB+ZZI_RM(JLON,1,JLEV,1)+  &
        &ZZI_RM(JLON,1,JLEV,2)+ZZI_RM(JLON,1,JLEV,3)+&
        &ZZI_RM(JLON,1,JLEV,4)+ZZI_RM(JLON,1,JLEV,5)+&
        &ZZI_RM(JLON,1,JLEV,6) )
      ENDDO
    ENDDO
  ELSEIF (NRR==7) THEN
    DO JLEV=1,KLEV
      DO JLON= KIDIA, KFDIA
        ZQDM(JLON,JLEV)=1._JPRB/(1._JPRB+ZZI_RM(JLON,1,JLEV,1)+  &
        &ZZI_RM(JLON,1,JLEV,2)+ZZI_RM(JLON,1,JLEV,3)+&
        &ZZI_RM(JLON,1,JLEV,4)+ZZI_RM(JLON,1,JLEV,5)+&
        &ZZI_RM(JLON,1,JLEV,6)+ZZI_RM(JLON,1,JLEV,7) )
      ENDDO
    ENDDO
  ENDIF 
  !reinitialisation des qi
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZQVM(JLON,JLEV)=ZZI_RM(JLON,1,JLEV,1)*ZQDM(JLON,JLEV)
      ZQCM(JLON,JLEV)=ZZI_RM(JLON,1,JLEV,2)*ZQDM(JLON,JLEV)
      ZQRM(JLON,JLEV)=ZZI_RM(JLON,1,JLEV,3)*ZQDM(JLON,JLEV)
      ZQIM(JLON,JLEV)=ZZI_RM(JLON,1,JLEV,4)*ZQDM(JLON,JLEV)
      ZQSM(JLON,JLEV)=ZZI_RM(JLON,1,JLEV,5)*ZQDM(JLON,JLEV)
      ZQGM(JLON,JLEV)=ZZI_RM(JLON,1,JLEV,6)*ZQDM(JLON,JLEV)
    ENDDO
  ENDDO

  IF (NRR==7) THEN
    DO JLEV = 1,KLEV
      DO JLON = KIDIA,KFDIA
        ZQHM(JLON,JLEV)=ZZI_RM(JLON,1,JLEV,7)*ZQDM(JLON,JLEV)
      ENDDO
    ENDDO
  ENDIF
        
  !modif de R et CP
  ZQHGM(KIDIA:KFDIA,:)=ZQHM(KIDIA:KFDIA,:)+ZQGM(KIDIA:KFDIA,:)
  CALL GPRCP(KLON,KIDIA,KFDIA,KLEV,&
   & PQ=ZQVM,PQI=ZQIM,PQL=ZQCM,&
   & PQR=ZQRM,PQS=ZQSM,PQG=ZQHGM,&
   & PCP=ZCPM,PR=ZRHM,PKAP=ZKAPM)  

  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      ZTM(JLON,JLEV)=ZZI_THM(JLON,1,JLEV)*ZZI_EXNREFM(JLON,1,JLEV)
    ENDDO
  ENDDO

  !reinitialisation de ZZI_RHODREFM (=qd*zrho)
  DO JLEV = 1, KLEV 
    DO JLON = KIDIA,KFDIA
      ZZI_RHO(JLON,1,JLEV)=PAPRSFM(JLON,JLEV)/&
       & (ZRHM(JLON,JLEV)*ZTM(JLON,JLEV))
      ZZI_RHODREFM(JLON,1,JLEV)=ZZI_RHO(JLON,1,JLEV)*ZQDM(JLON,JLEV)
    ENDDO
  ENDDO

  !geopotentiel calculation
 
  CALL GPGEO(KLON,KIDIA,KFDIA,KLEV,ZZI_APHIM,ZZI_APHIFM,ZTM,ZRHM,PLNPRM,PALPHM)
   
  !calcul de l'altitude
  DO JLEV = 1, KLEV
    DO JLON = KIDIA,KFDIA
      ZZZ(JLON,1,JLEV)=ZZI_APHIM(JLON,JLEV)*ZINVG
    ENDDO
  ENDDO
  
  !initialisation de ZZZF
  DO JLEV = 1, KLEV 
    DO JLON = KIDIA,KFDIA
      ZZZF(JLON,1,JLEV)=ZZI_APHIFM(JLON,JLEV)*ZINVG
    ENDDO
  ENDDO

  !initialisation de ZDZZ
  DO JLEV = 2, KLEV
    DO JLON = KIDIA,KFDIA
      ZDZZ(JLON,1,JLEV)=ZZZ(JLON,1,JLEV+IKL)-ZZZ(JLON,1,JLEV)
    ENDDO
  ENDDO
  DO JLEV = 1, KLEV-1
    DO JLON = KIDIA,KFDIA
      ZDZZF(JLON,1,JLEV)=ZZZF(JLON,1,JLEV)-ZZZF(JLON,1,JLEV-IKL)
    ENDDO
  ENDDO
  DO JLON = KIDIA,KFDIA
      ZDZZF(JLON,1,KLEV)=ZZZF(JLON,1,KLEV)-POROG(JLON)*ZINVG
      ZDZZ(JLON,1,1)=ZZI_APHIM(JLON,0)*ZINVG-ZZZ(JLON,1,1)
  ENDDO

  IF(LOCND2)THEN
    DO JLEV=1,KLEV
       DO JLON = KIDIA,KFDIA
         ZICLDFR2(JLON,JLEV) = ZICLDFR(JLON,1,JLEV)
         ZWCLDFR2(JLON,JLEV) = ZWCLDFR(JLON,1,JLEV)
         ZSSIO2(JLON,JLEV) = ZSSIO(JLON,1,JLEV)
         ZSSIU2(JLON,JLEV) = ZSSIU(JLON,1,JLEV)
         ZIFR2(JLON,JLEV) = ZIFR(JLON,1,JLEV)
       ENDDO
    ENDDO
  ENDIF
ENDIF
!     END ADJUTMENT LMICRO TRUE
!     --------------------------------------------------------------------

!initialisation of PCLFS outside LMICRO to be zero in case LMICRO=F
DO JLEV=1,KLEV
  DO JLON = KIDIA,KFDIA
    PCLFS(JLON,JLEV)=ZNEBMNH(JLON,1,JLEV) 
  ENDDO
ENDDO


!     ------------------------------------------------------------------
!     NEBULOSITE (CONVECTIVE+STRATIFORME) A TROIS NIVEAUX.
!     DIAGNOSTIC OF THREE LEVELS (CONVECTIVE+STRATIFORM) CLOUDINESS.

! protect cloudiness from being 0 or 1  (needed for ACRANEB2 and ACNPART)
DO JLEV=KTDIA,KLEV
  DO JLON=KIDIA,KFDIA
    ZNEB0(JLON,JLEV)=MAX(ZEPSNEB,MIN(1._JPRB-ZEPSNEB,PCLFS(JLON,JLEV)))
  ENDDO
ENDDO
 
! calculate high, medium, low and total cloud cover
CALL ACNPART(KIDIA,KFDIA,KLON,NTNEBU,KLEV,&
 & PAPHIM,PAPRSFM,ZDECRD,ZNEB0,&
 & PCLCH,PCLCM,PCLCL,PCLCT,ZCLCT_RAD)

 !compute temperature tendency due to microphysics
  IF (LFLEXDIA) ZTENDBKP(:,:)=PTENDT(:,:)
  
  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      PTENDT(JLON,JLEV)=PTENDT(JLON,JLEV)+(ZZI_THS(JLON,1,JLEV)-&
       & ZZI_THSAVE(JLON,1,JLEV))*ZZI_EXNREFM(JLON,1,JLEV)  
    ENDDO
  ENDDO
  
  IF (LFLEXDIA) THEN
    ZTMPAF(:,:)=(PTENDT(:,:)-ZTENDBKP(:,:))*PDELPM(:,:)*ZINVG*ZCPM(:,:) 
    CALL ADD_FIELD_3D(ZTMPAF(:,:),'TCTADJU','T','ARP',.TRUE.,.TRUE.)
  ENDIF
  
  !inversion niveaux tendances des ri et conversion en qi en multipliant par qd 
  DO JR=1,NRR
    IF (LFLEXDIA) ZTENDBKP(:,:)=PTENDR(:,:,JR) 
    DO JLEV=1,KLEV
      DO JLON=KIDIA,KFDIA
        PTENDR(JLON,JLEV,JR)=PTENDR(JLON,JLEV,JR)   &
         & +(ZZI_RS(JLON,1,JLEV,JR)         &
         & -ZZI_RSAVE(JLON,1,JLEV,JR))*ZQDM(JLON,JLEV)  
      ENDDO
    ENDDO
    
    IF (LFLEXDIA) THEN
      CLNAME='T'//CLVARNAME(JR)//'ADJU'
      ZTMPAF(:,:)=(PTENDR(:,:,JR)-ZTENDBKP(:,:))*PDELPM(:,:)*ZINVG
      CALL ADD_FIELD_3D(ZTMPAF(:,:),CLNAME,'T','ARP',.TRUE.,.TRUE.)
    ENDIF 
 ENDDO

 ! specific to new data flow for diagnostics

IF (LFLEXDIA) THEN
!$OMP CRITICAL (ARO_SUINTBUDGET_LOCK)
  CALL ARO_SUINTBUDGET(KLON,KLEV,KSTEP,KFDIA,ZQDM,ZZI_EXNREFM,PCPM) 
!$OMP END CRITICAL (ARO_SUINTBUDGET_LOCK)
ENDIF
!     --------------------------------------------------------------------
!     5 - COMPUTE DUST PROPERTIES FOR RADIATION IF LRDUST=T
!     --------------------------------------------------------------------
IF (LRDUST) THEN
  PEZDIAG(:,:,IOFF_MFSHAL:NGFL_EZDIAG)=0.0_JPRB
! input dust scalar concentration in ppp from
 IEZDIAG_CHEM=NGFL_EZDIAG-IOFF_MFSHAL+1

  ZZI_SVSAVE=ZZI_SVM
! input dust scalar concentration in ppp from
  CALL ARO_MNHDUST (IKL,ILONMNH,KLEV,NGFL_EXT, PDT,        &
        &          ZZI_SVM(KIDIA:KFDIA,:,:,1:NGFL_EXT),   &
        &          ZZZ(KIDIA:KFDIA,:,:),                  &
        &          ZDZZ(KIDIA:KFDIA,:,:),                 &
        &          ZZI_PABSM(KIDIA:KFDIA,:,:),            &
        &          ZZI_THM(KIDIA:KFDIA,:,:),              &
        &          ZZI_RHODREFM(KIDIA:KFDIA,:,:),         &
        &          NSWB_MNH,                              &
        &          KSTEP+1,                               &
        &          ZPIZA_DST(KIDIA:KFDIA,:,:),            &
        &          ZCGA_DST(KIDIA:KFDIA,:,:),             &
        &          ZTAUREL_DST(KIDIA:KFDIA,:,:),          &
        &          ZAERD(KIDIA:KFDIA,:),                  &
        &          IEZDIAG_CHEM,                           &
        &          ZZI_PEZDIAG(KIDIA:KFDIA,:,IOFF_MFSHAL:NGFL_EZDIAG)           )

PEZDIAG(KIDIA:KFDIA,:,IOFF_MFSHAL:NGFL_EZDIAG)=ZZI_PEZDIAG(KIDIA:KFDIA,:,IOFF_MFSHAL:NGFL_EZDIAG)

! return to tendency
     DO JGFL=1, NGFL_EXT
       DO JLEV = 1,KLEV
         DO JLON = KIDIA,KFDIA
           PTENDEXT(JLON,JLEV,JGFL)=PTENDEXT(JLON,JLEV,JGFL)+&
         & (ZZI_SVM(JLON,1,JLEV,JGFL)-&
         & ZZI_SVSAVE(JLON,1,JLEV,JGFL))*ZINVDT
         ENDDO
       ENDDO
     ENDDO
ENDIF

IF (LSFORCS) THEN   ! <== Surface forcing for MUSC
  DO JLON=KIDIA,KFDIA
    ZTSURF(JLON) = PTM(JLON,KLEV)
    ZTN(JLON)    = PTM(JLON,KLEV)
    ZQS(JLON)    = PQVM(JLON,KLEV)
    ZRHODREFM(JLON) = PAPRSFM(JLON,KLEV)/(PTM(JLON,KLEV)*PRM(JLON,KLEV))
    ZTHETAS(JLON)   = ZTSURF(JLON)*(RATM/PAPRSM(JLON,KLEV))**RKAPPA
  ENDDO

  LLAROME=.TRUE.
  CALL SURF_IDEAL_FLUX(LLAROME, KIDIA , KFDIA  , KLON, PAPHIFM(:,KLEV), ZRHODREFM, PSFORC, &
  &       ZTN,ZTSURF,PQVM(:,KLEV), PUM(:,KLEV), PVM(:,KLEV), ZTHETAS, ZSFTH(KIDIA:KFDIA,1), &
  &       ZSFRV(KIDIA:KFDIA,1), ZSFU(KIDIA:KFDIA,1), ZSFV(KIDIA:KFDIA,1))

!* Compute PBL-diagnostics
   
   CALL AROCLDIA(KIDIA,KFDIA,ILONMNH,KLEV,PUCLS(KIDIA:KFDIA), &
    & PVCLS(KIDIA:KFDIA),PTKEM(KIDIA:KFDIA,1:KLEV),&
    & PAPHIFM(KIDIA:KFDIA,1:KLEV),POROG(KIDIA:KFDIA),&
    & PUGST(KIDIA:KFDIA),PVGST(KIDIA:KFDIA),PPBLH(KIDIA:KFDIA),ICLPH)
   PPBLH(:)=MIN(XMAXLM,MAX(XMINLM,PPBLH(:))) 

ENDIF    ! <== End of surface forcing for MUSC

!     --------------------------------------------------------------------
!     6 - RADIATION (from ECMWF, but as in ARPEGE : same setup etc) 
!     --------------------------------------------------------------------
IF (LRAYFM.OR.LRAY) THEN
! prepare some input for both
   
! test de coherence sur le nombre de bandes spectrales entre ce qui sort de
! la surface et ce qu'attend le rayonnement
IF( NSWB_MNH /= NSW) THEN
  CALL ABOR1 (' NSWB_MNH must be equal to NSW !')
ENDIF


!     ------------------------------------------------------------------
!     - CALCUL de l'humidite saturante
!     ----------------------------

  ! compute saturated specific humidity  
  CALL ACTQSAT ( KIDIA,KFDIA,KLON,NTQSAT,KLEV,&
   & PAPRSFM, ZCPM, ZQVM, ZTM,&          
   & ZGEOSLC, ZLH, ZLSCPE, ZQSAT, ZQW,   ZRH, ZTW)  
                                         
  ! initialisation des humidite (dans le rayonnement, l'eau liquide nuageuse 
  ! et la glace sont donne par des hu par rapport au gaz.
  ! (qi/qa+qv pour ice par ex. C'est donc different de ri)
  DO JLEV=KTDIA,KLEV
    DO JLON=KIDIA,KFDIA 
       ZQICE(JLON,JLEV)=&
        & MAX(0.0_JPRB, &
        & (ZQIM(JLON,JLEV) + ZQSM(JLON,JLEV)*RADSN + ZQGM(JLON,JLEV)*RADGR)/ &
        & (1.0_JPRB-ZQIM(JLON,JLEV)-ZQCM(JLON,JLEV)-ZQRM(JLON,JLEV)&
        & -ZQGM(JLON,JLEV)-ZQSM(JLON,JLEV)-ZQHM(JLON,JLEV)))
       ZQLIQ(JLON,JLEV)=MAX(0.0_JPRB, ZQCM(JLON,JLEV)/&
        & (1.0_JPRB-ZQIM(JLON,JLEV)-ZQCM(JLON,JLEV)-ZQRM(JLON,JLEV)&
        & -ZQGM(JLON,JLEV)-ZQSM(JLON,JLEV)-ZQHM(JLON,JLEV)))
       ZQV(JLON,JLEV)=MAX(0.0_JPRB, ZQVM(JLON,JLEV)/ &
        & (1.0_JPRB-ZQIM(JLON,JLEV)-ZQCM(JLON,JLEV)-ZQRM(JLON,JLEV)&
        & -ZQGM(JLON,JLEV)-ZQSM(JLON,JLEV)-ZQHM(JLON,JLEV)))
    ENDDO
  ENDDO

  ! store cloud water content for RTTOV
  IF (YIRAD%LGP) PQIRAD(KIDIA:KFDIA,:) = ZQICE(KIDIA:KFDIA,:)
  IF (YLRAD%LGP) PQLRAD(KIDIA:KFDIA,:) = ZQLIQ (KIDIA:KFDIA,:)

  ! Hannu Savijarvi diffuse -> direct albedo correction from hlradia,
  ! Assuming that SURFEX does not make difference between  
  ! dir/dif albedo as surfex/SURFEX/albedo_from_nir_vis.F90 defines
  ! PSCA_ALB(:,:) = PDIR_ALB(:,:)
  IF (LHLRADUPD) THEN  
     DO JLON=KIDIA,KFDIA
        ZSALBCOR(JLON)=0.2_JPRB/(1._JPRB+PMU0(JLON))-0.12_JPRB
     ENDDO
  ELSE
     ZSALBCOR=0._JPRB
  ENDIF
  
! Albedo dans les intervalles, direct (parallel) et diffus (diffuse).
  IF (NSW==6.OR.NSW==1) THEN
     IF (LLMSE) THEN
        DO JSW=1,NSW
           DO JLON=KIDIA,KFDIA
              ZALBP(JLON,JSW)=PGPAR(JLON,MALBDIR-1+JSW)
              ZALBD(JLON,JSW)=PGPAR(JLON,MALBSCA-1+JSW)
              IF (LHLRADUPD) ZALBP(JLON,JSW)=ZALBD(JLON,JSW)+ZSALBCOR(JLON)
           ENDDO
        ENDDO
     ELSEIF (LSFORCS) THEN
        DO JSW=1,NSW
           DO JLON=KIDIA,KFDIA
              ZALBP(JLON,JSW)=RALB_FORC
              ZALBD(JLON,JSW)=RALB_FORC
!  direct>diffuse correction might be applied to RALB_FORC,too:
!              ZALBP(JLON,JSW)=RALB_FORC+ZSALBCOR(JLON) 
           ENDDO
        ENDDO
     ELSE
     !pour pouvoir tourner sans la surface
        DO JSW=1,NSW
           DO JLON=KIDIA,KFDIA
              ZALBP(JLON,JSW)=PALBIN(JLON)
              ZALBD(JLON,JSW)=PALBIN(JLON)
!              ZALBP(JLON,JSW)=PALBIN(JLON)+ZSALBCOR(JLON) 
           ENDDO
        ENDDO
     ENDIF

  ! Spectral average albedo done with RSUN2 weights, 
  ! to be applied for HLRADIA, ACRANEB2 which use a single solar spectral band
    IF (LHLRADUPD) THEN
       DO JLON=KIDIA,KFDIA
          ZALBP1(JLON)=0.
          ZALBD1(JLON)=0.
          DO JSW=1,NSW
             ZALBP1(JLON)=ZALBP1(JLON)+RSUN2(JSW)*ZALBP(JLON,JSW)
             ZALBD1(JLON)=ZALBD1(JLON)+RSUN2(JSW)*ZALBD(JLON,JSW)
          ENDDO
       ENDDO
    ELSE
       ZALBP1(JLON)=PGPAR(JLON,MALBDIR)
       ZALBD1(JLON)=PGPAR(JLON,MALBSCA)        
    ENDIF


    DO JLON=KIDIA,KFDIA
      IF (LLMSE) THEN
        ZEMIS(JLON)=PGPAR(JLON,MVEMIS)
        ZTSURF(JLON)=PGPAR(JLON,MVTS)
        ! protection for E Zone, Where surface scheme send back EMIS and T =0
        ! the protection in aro_ground_paramn is not sufficient !!! WHY ??
        IF (ZEMIS(JLON)==0._JPRB) THEN
          ZEMIS(JLON)=1.0_JPRB
          ZTSURF(JLON)=288.0_JPRB
        ENDIF
      ELSEIF (LSFORCS) THEN
        ZEMIS(JLON)=REMIS_FORC
      ELSE
        ZTSURF(JLON)=ZTM(JLON,KLEV)
        ZEMIS(JLON)=0.5_JPRB  ! LR: why 0.5, not 1.0_JPRB or 0.95_JPRB?
      ENDIF
    ENDDO  
  ELSE
    CALL ABOR1('Albedo for NSW /= 1 or 6 not defined in apl_arome!')
  ENDIF
  
    ! initialisation of aerosols
    ! as in Meteo-France (in clim files)
    IF ((NAER /= 0).AND.(YSD_VAD%NUMFLDS < 4)) THEN
        WRITE(NULOUT,*) 'YSD_VAD%NUMFLDS SHOULD BE >= 4, IT IS: ' &
       & ,YSD_VAD%NUMFLDS
        CALL ABOR1('APL_AROME: PB AEROSOLS!')
    ENDIF
    DO JLON = KIDIA,KFDIA
      ZAESEA(JLON) = 0.0_JPRB
      ZAELAN(JLON) = 0.0_JPRB
      ZAESOO(JLON) = 0.0_JPRB
      ZAEDES(JLON) = 0.0_JPRB
    ENDDO

    IF (NAER >= 1 ) THEN
      IF(YSD_VAD%NUMFLDS >= 4) THEN
        DO JLON = KIDIA,KFDIA
          ZAESEA(JLON) = PAESEA(JLON)
          ZAELAN(JLON) = PAELAN(JLON)
          ZAESOO(JLON) = PAESOO(JLON)
          ZAEDES(JLON) = PAEDES(JLON)
        ENDDO
      ELSE
        ZDUM=1._JPRB
        CALL RADACT(KIDIA, KFDIA, KLON, KLEV,&
         & 1 , NGPTOT , NGPTOT+2  ,0 , 1,&
         & PAPRSM , PGELAM, PGEMU , PCLON , PSLON, ZCHTIX,&
         & ZDUM   , ZDUM  , ZDUM  ,&
         & ZRAER , ZROZ  )
         DO JAE=1,6
            DO JK=1,KLEV
               DO JLON=KIDIA,KFDIA
                  ZAER(JLON,JK,JAE)=ZRAER(JLON,JAE,JK)
               ENDDO
            ENDDO
         ENDDO
      ENDIF
    ENDIF

    IF (LAEROSUL) THEN
      DO JLON = KIDIA,KFDIA
        ZAESUL(JLON) = PAESUL(JLON)
      ENDDO
    ELSE
      DO JLON = KIDIA,KFDIA
        ZAESUL(JLON) = 0.0_JPRB
      ENDDO
    ENDIF
    IF (LAEROVOL) THEN
      DO JLON = KIDIA,KFDIA
        ZAEVOL(JLON) = PAEVOL(JLON)
      ENDDO
    ELSE
      DO JLON = KIDIA,KFDIA
        ZAEVOL(JLON) = 0.0_JPRB
      ENDDO
    ENDIF
    IF (NAER /= 0.AND.((YSD_VAD%NUMFLDS >= 4))) THEN
      CALL RADAER ( KIDIA , KFDIA , KLON  , KLEV,&
       & PAPRSM , PAPRSFM, ZTM    , ZTSURF,&
       & ZAESEA, ZAELAN, ZAESOO, ZAEDES, ZAESUL, ZAEVOL,&
       & ZAER, ZAERINDS                                 )
    ENDIF

    IF (LRDUST) THEN
      ! We use the extinction coefficient explicitely solved by ARO_MNHDUST
      ZAER(KIDIA:KFDIA,:,3) = ZAERD(KIDIA:KFDIA,:)
    ENDIF

    ! initialisation de l'Ozone 
    ! comme dans arpege a partir de profils clim si nozocl=2
    IF (NOZOCL==2) THEN
      CALL SUOZON ( KIDIA,KFDIA,KLON,KLEV,ZQO3,.FALSE.,PAPRSM,PRDELPM,&
       & LO3ABC,PVO3ABC )  
    ENDIF

    ! comme au CEP si nozocl=1
    IF (NOZOCL==1) THEN
      CALL RADOZC ( KIDIA, KFDIA , KLON, KLEV, &
      & 1 , NGPTOT , 0,  &
      & PAPRSM , PGEMU, &
      & ZROZ   )
      DO JK=1,KLEV
         DO JLON=KIDIA,KFDIA  
            ZQO3(JLON,JK)=ZROZ(JLON,JK)/PDELPM(JLON,JK)
         ENDDO
      ENDDO
    ENDIF

    ! Appel de l'interface rayonnement
    ZCARDI=RCARDI
    IMODE=NMODE
 ENDIF
 
 IF (LRAYFM) THEN
  ! intermittent call to IFS radiation scheme 
  IF (MOD(KSTEP,NRADFR) == 0) THEN
    
    CALL ACRADIN &
     & ( KIDIA , KFDIA,&
     & KLON  , KLEV,&
     & IMODE , &
     & ZALBD , ZALBP, PAPRSM    , PAPRSFM,&
     & ZCARDI, PCLFS , ZQO3(1,1), ZAER,&
     & PDELPM , ZEMIS, PMU0M, ZQV  , ZQSAT,&
     & ZQICE , ZQLIQ , PLSM     , ZTM    , ZTSURF,&
     & PEMTD , PEMTU, PTRSO,PFRTHC,PFRTH,PFRSOC,PFRSO,&
     & ZZSFSWDIR, ZZSFSWDIF,&
     & ZFSDNN, ZFSDNV,&
     & ZCTRSO, ZCEMTR, ZTRSOD,&
     & ZTRSODIR, ZTRSODIF,&
     & ZPIZA_DST,ZCGA_DST,ZTAUREL_DST,ZAERINDS)

    ! save SW surface fluxes
    IF (LLMSE) THEN
      IF (NSW==6) THEN
         DO JSW=1,NSW
            DO JLON=KIDIA,KFDIA
               PGPAR(JLON,MSWDIR+JSW-1)=ZTRSODIR(JLON,JSW)
               PGPAR(JLON,MSWDIF+JSW-1)=ZTRSODIF(JLON,JSW)
            ENDDO
         ENDDO
      ENDIF
      IF (NSW==1) THEN
         DO JLON=KIDIA,KFDIA
            PGPAR(JLON,MSWDIR)=ZFSDNN(JLON)+ZFSDNV(JLON)
            PGPAR(JLON,MSWDIF)=0.0_JPRB
         ENDDO
      ENDIF
    ENDIF
 ENDIF
 ! end of intermittent call of IFS radiation
  
  IF (LLMSE) THEN
     DO JSW=1,NSW
        DO JLON=KIDIA,KFDIA
           ZTRSODIR(JLON,JSW)=PGPAR(JLON,MSWDIR+JSW-1)
           ZTRSODIF(JLON,JSW)=PGPAR(JLON,MSWDIF+JSW-1)
        ENDDO
     ENDDO
  ENDIF

  ! daand: radflex
  IF (LRADFLEX) THEN
    YLRADPROC => NEWINTPROC(YDPROCSET,'Radiation')
    ZFRSO => NEWINTFIELD(YLRADPROC,KLON,KLEV,'FRSO','H','F')
    ZFRTH => NEWINTFIELD(YLRADPROC,KLON,KLEV,'FRTH','H','F')
  ENDIF

  CALL RADHEAT &
   & (  KIDIA  , KFDIA  , KLON   , KLEV,&
   & PAPRSM  ,&
   & ZEMIS  , PEMTD  , PMU0,&
   & ZQVM,&
   & ZTENT  , PTRSO  , ZTRSOD , ZTSURF   , PDT,&
   & ZTRSODIR,ZTRSODIF, ZALBD , ZALBP,  &
   ! daand: radflex; replaced PFRSO and PRFTH by pointers
   & ZFRSO  , ZFRTH  , PFRSODS, PFRTHDS,&
   & ZCEMTR , ZCTRSO , PFRSOC , PFRTHC,&
   & ZSUDU  , ZSDUR  , ZDSRP  , &
   & ZZSFSWDIR , ZZSFSWDIF    , &
   & PFRSOPS, ZFRSOFS, PFRSOPT )  


  ! update sunshine duration [s]
  DO JLON=KIDIA,KFDIA
    PSDUR(JLON)=PSDUR(JLON)+ZSDUR(JLON)*TSTEP
  ENDDO

  IF (.NOT.LHLRADUPD) THEN 
! Overwrite surface radiation fluxes, now correctly calculated by radheat,
! by using old albedo approximations 

! A rajouter car flux calcules dans radheat pas corrects (cf aplpar)
  DO JLON=KIDIA,KFDIA 
    IF (LLMSE) THEN
      ZALB(JLON)=0.
      DO JSW=1,NSW
        ZALB(JLON)=ZALB(JLON)+ZALBD(JLON,JSW)+ZALBP(JLON,JSW)
      ENDDO
      ZALB(JLON)=ZALB(JLON)/FLOAT(NSW*2)
    ELSE
      ZALB(JLON)=0.5_JPRB                   !??!
      IF (LSFORCS) THEN
         ZALB(JLON)=RALB_FORC
      ENDIF
     ENDIF
     PFRSODS(JLON)=PFRSO(JLON,KLEV,1)/(1.0_JPRB-ZALB(JLON))
  ENDDO
  ENDIF ! .NOT.HLRADUPD

  ! daand: radflex
  IF (LRADFLEX) THEN
    ! store for further calculations and diagnostics
    PFRSO(:,:,1)=ZFRSO
    PFRTH(:,:,1)=ZFRTH
  ENDIF

  ! daand: if LRADFLEX, the contribution to temperature is done by
  ! cptend_flex/cputqy
  IF (.NOT.LRADFLEX) THEN
    ! update temperature tendency by radiative contribution
    PTENDT(:,:)=PTENDT(:,:)+ZTENT(:,:)
  ENDIF

  ! Estimate of the direct normal irradiance, with securities
  DO JLON = KIDIA, KFDIA
     PFRSDNI(JLON)=PFRSOPS(JLON)
     IF (PMU0(JLON).GT.3.0E-02_JPRB) THEN
        PFRSDNI(JLON)=PFRSOPS(JLON)/PMU0(JLON)
     ENDIF
     PFRSDNI(JLON)=MAX(0.0_JPRB,PFRSDNI(JLON)) 
  ENDDO 

  IF( MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)'sous apl_arome apres rayonnement ZTENT=',ZTENT(NPTP,30:41)
    IF (LLMSE) THEN
       DO JSW=1, NSW
          WRITE(NULOUT,*)'ZSFSWDIR ZSFSWDIF ZFSDNN ZFSDNV PFRSO',&
        & ZZSFSWDIR(NPTP,JSW),ZZSFSWDIF(NPTP,JSW),ZFSDNN(NPTP),&
        & ZFSDNV(NPTP),PFRSO(NPTP,KLEV,1)
          WRITE(NULOUT,*)'ZALBD ZALBP',ZALBD(NPTP,JSW),ZALBP(NPTP,JSW)
       ENDDO
    ENDIF
    WRITE(NULOUT,*)ZFSDNN(NPTP),ZFSDNV(NPTP)
    WRITE (NULOUT,*)'TSURF EMIS ZFRTH',ZTSURF(NPTP),ZEMIS(NPTP),PFRTHDS(NPTP)
  ENDIF

  IF (LFLEXDIA) THEN
    CALL ADD_FIELD_3D(PFRSO(:,:,1),'FCTRAYSO','F','ARP',.TRUE.,.TRUE.)
    CALL ADD_FIELD_3D(PFRTH(:,:,1),'FCTRAYTH','F','ARP',.TRUE.,.TRUE.)
  ENDIF

ENDIF  ! LRAYFM

IF (LRAY.AND.NRAY == 2.AND.LRADFLEX) THEN

  ! -------------------------
  ! ACRANEB2 radiation scheme
  ! -------------------------

  ! initialization of cloud ice, cloud liquid and specific humidity
  ! (with respect to moist air, i.e. excluding hydrometeors)
  DO JLEV=KTDIA,KLEV
    DO JLON=KIDIA,KFDIA
      ZQICE(JLON,JLEV)=MAX(0.0_JPRB, ZQIM(JLON,JLEV)/ &
       & (1.0_JPRB-ZQIM(JLON,JLEV)-ZQCM(JLON,JLEV)-ZQRM(JLON,JLEV)&
       & -ZQGM(JLON,JLEV)-ZQSM(JLON,JLEV)-ZQHM(JLON,JLEV)))
      ZQLIQ(JLON,JLEV)=MAX(0.0_JPRB, ZQCM(JLON,JLEV)/&
       & (1.0_JPRB-ZQIM(JLON,JLEV)-ZQCM(JLON,JLEV)-ZQRM(JLON,JLEV)&
       & -ZQGM(JLON,JLEV)-ZQSM(JLON,JLEV)-ZQHM(JLON,JLEV)))
      ZQV(JLON,JLEV)=MAX(0.0_JPRB, ZQVM(JLON,JLEV)/ &
       & (1.0_JPRB-ZQIM(JLON,JLEV)-ZQCM(JLON,JLEV)-ZQRM(JLON,JLEV)&
       & -ZQGM(JLON,JLEV)-ZQSM(JLON,JLEV)-ZQHM(JLON,JLEV)))
    ENDDO
  ENDDO

  ! store cloud water content for RTTOV
  IF (YIRAD%LGP) PQIRAD(KIDIA:KFDIA,:) = ZQICE(KIDIA:KFDIA,:)
  IF (YLRAD%LGP) PQLRAD(KIDIA:KFDIA,:) = ZQLIQ (KIDIA:KFDIA,:)

  ! initialization of CO2(+), differs from IFS radiation scheme!
  ZQCO2(:,:)=QCO2

  ! initialization of ozone
  IF (NOZOCL == 1) THEN

    ! as in IFS
    CALL RADOZC(KIDIA,KFDIA,KLON,KLEV, &
     & 1,NGPTOT,0,                     &
     & PAPRSM,PGEMU,                   &
     & ZROZ)
    DO JK=1,KLEV
       DO JLON=KIDIA,KFDIA
          ZQO3(JLON,JK)=ZROZ(JLON,JK)/PDELPM(JLON,JK)
       ENDDO
    ENDDO

  ELSEIF (NOZOCL == 2) THEN

    ! as in ARPEGE (from clim profiles)
    CALL SUOZON(KIDIA,KFDIA,KLON,KLEV,ZQO3,.FALSE.,PAPRSM,PRDELPM,&
     & LO3ABC,PVO3ABC)

  ENDIF

  ! initialization of aerosols
  IF (LRSTAER) THEN

    ! old ("standard") aerosols
    DO JLEV=KTDIA-1,KLEV
      ZVETAH(JLEV)=STPREH(JLEV)/YRVAB%VP00
    ENDDO
    ZAEO=AERCS1*ZVETAH(KTDIA-1)+AERCS3*ZVETAH(KTDIA-1)**3+ &
     &   AERCS5*ZVETAH(KTDIA-1)**5
    DO JLEV=KTDIA,KLEV
      ZAEN=AERCS1*ZVETAH(JLEV)+AERCS3*ZVETAH(JLEV)**3+ &
       &   AERCS5*ZVETAH(JLEV)**5
      DO JLON=KIDIA,KFDIA
        ZAER(JLON,JLEV,1)=ZAEN-ZAEO
        ZAER(JLON,JLEV,2:6)=0._JPRB
      ENDDO
      ZAEO=ZAEN
    ENDDO
  
  ELSE

    ! initialisation of aerosols as in ARPEGE (from clim files)
    IF ((NAER /= 0).AND.(YSD_VAD%NUMFLDS < 4)) THEN
      CALL ABOR1('APL_AROME: PB AEROSOLS!')
    ENDIF
    DO JLON = KIDIA,KFDIA
      ZAESEA(JLON) = 0.0_JPRB
      ZAELAN(JLON) = 0.0_JPRB
      ZAESOO(JLON) = 0.0_JPRB
      ZAEDES(JLON) = 0.0_JPRB
    ENDDO

    IF (NAER >= 1 ) THEN
      IF(YSD_VAD%NUMFLDS >= 4) THEN
        DO JLON = KIDIA,KFDIA
          ZAESEA(JLON) = PAESEA(JLON)
          ZAELAN(JLON) = PAELAN(JLON)
          ZAESOO(JLON) = PAESOO(JLON)
          ZAEDES(JLON) = PAEDES(JLON)
        ENDDO
      ELSE
        ZDUM=1._JPRB
        CALL RADACT(KIDIA, KFDIA, KLON, KLEV,&
         & 1 , NGPTOT , NGPTOT+2  ,0 , 1,&
         & PAPRSM , PGELAM, PGEMU , PCLON , PSLON, ZCHTIX,&
         & ZDUM   , ZDUM  , ZDUM  ,&
         & ZRAER , ZROZ  )
      	DO JAE=1,6
          DO JK=1,KLEV
            DO JLON=KIDIA,KFDIA
               ZAER(JLON,JK,JAE)=ZRAER(JLON,JAE,JK)
            ENDDO
          ENDDO
        ENDDO
      ENDIF
    ENDIF

    IF (LAEROSUL) THEN
      DO JLON = KIDIA,KFDIA
        ZAESUL(JLON) = PAESUL(JLON)
      ENDDO
    ELSE
      DO JLON = KIDIA,KFDIA
        ZAESUL(JLON) = 0.0_JPRB
      ENDDO
    ENDIF
    IF (LAEROVOL) THEN
      DO JLON = KIDIA,KFDIA
        ZAEVOL(JLON) = PAEVOL(JLON)
      ENDDO
    ELSE
      DO JLON = KIDIA,KFDIA
        ZAEVOL(JLON) = 0.0_JPRB
      ENDDO
    ENDIF
    IF (NAER /= 0.AND.((YSD_VAD%NUMFLDS >= 4))) THEN
      CALL RADAER ( KIDIA , KFDIA , KLON  , KLEV,&
       & PAPRSM , PAPRSFM, ZTM    , ZTSURF,&
       & ZAESEA, ZAELAN, ZAESOO, ZAEDES, ZAESUL, ZAEVOL,&
       & ZAER, ZAERINDS                                 )
    ENDIF

    IF (LRDUST) THEN
      ! We uses the extinction coefficient explicitely solved by ARO_MNHDUST
      ZAER(KIDIA:KFDIA,:,3) = ZAERD(KIDIA:KFDIA,:)
    ENDIF

  ENDIF

  ! get diffuse and direct surface albedo, emissivity and temperature
  DO JLON=KIDIA,KFDIA
    IF (.NOT.LHLRADUPD) THEN
       ZALBD1(JLON)=PGPAR(JLON,MALBSCA)
       ZALBP1(JLON)=PGPAR(JLON,MALBDIR)
    ENDIF
    ZEMIS  (JLON)=PGPAR(JLON,MVEMIS)
    ZTSURF (JLON)=PGPAR(JLON,MVTS)
    ! protection of E-zone (not to have zero emissivity and T_surf there)
    IF (ZEMIS(JLON) == 0._JPRB) THEN
      ZEMIS (JLON)=  1._JPRB
      ZTSURF(JLON)=288._JPRB
    ENDIF
  ENDDO

  ! daand: radflex
  YLRADPROC => NEWINTPROC(YDPROCSET,'Radiation')
  ZFRSO => NEWINTFIELD(YLRADPROC,KLON,KLEV, 'FRSO','H','F')
  ZFRTH => NEWINTFIELD(YLRADPROC,KLON,KLEV, 'FRTH','H','F')

  ! call radiation scheme
  IJN=KLON
  CALL ACRANEB2(KIDIA,KFDIA,KLON,NTRADI,KLEV,IJN,KSTEP,&
   & PAPRSM,PAPRSFM,PCPM,PRM,PDELPM,ZNEB0,&
   & ZQV,ZQCO2,ZQICE,ZQLIQ,ZQO3,PTM,ZDECRD,ZCLCT_RAD,&
   & ZALBD1,ZALBP1,ZEMIS,PGELAM,PGEMU,PMU0,PMU0LU,ZTSURF,&
   & PGDEOSI,PGUEOSI,PGMU0,PGMU0_MIN,PGMU0_MAX,&
   & PGDEOTI,PGDEOTI2,PGUEOTI,PGUEOTI2,PGEOLT,PGEOXT,&
   & PGRPROX,PGMIXP,PGFLUXC,PGRSURF,PSDUR,&
   & ZFRSO,ZFRTH,&
   & ZFRSODS,ZFRSOPS,ZFRSOLU,PFRTHDS,ZAER)

  ! daand: radflex
  ! store for further calculations and diagnostics
  PFRSO(:,:,1)=ZFRSO
  PFRTH(:,:,1)=ZFRTH

  ! extract surface fluxes
  DO JLON=KIDIA,KFDIA
     ZFRSOFS(JLON)=ZFRSODS(JLON)
     PFRSOPS(JLON)=ZFRSOPS(JLON)
     PFRSODS(JLON)=ZFRSOFS(JLON)+PFRSOPS(JLON)  ! downward surface sw flux
  ENDDO

  IF (LLMSE) THEN
     IF (LHLRADUPD) THEN
        DO JLON=KIDIA,KFDIA
           DO JSW = 1,NSW
              ZZSFSWDIR(JLON,JSW) = PFRSOPS(JLON)*RSUN2(JSW)
              ZZSFSWDIF(JLON,JSW) = ZFRSOFS(JLON)*RSUN2(JSW)
           ENDDO
        ENDDO
     ELSE
        DO JLON=KIDIA,KFDIA
           ZZSFSWDIR(JLON,1)=PFRSOPS(JLON) ! direct surface swdn flux
           ZZSFSWDIF(JLON,1)=ZFRSOFS(JLON) ! diffuse surface swdn flux
        ENDDO
     ENDIF        
  ENDIF

  ! Estimate of the direct normal irradiance, with securities
  DO JLON = KIDIA, KFDIA
     PFRSDNI(JLON)=PFRSOPS(JLON)
     IF (PMU0(JLON).GT.3.0E-02_JPRB) THEN
        PFRSDNI(JLON)=PFRSOPS(JLON)/PMU0(JLON)
     ENDIF
     PFRSDNI(JLON)=MAX(0.0_JPRB,PFRSDNI(JLON)) 
  ENDDO 

  IF (LFLEXDIA) THEN
    CALL ADD_FIELD_3D(PFRSO(:,:,1),'FCTRAYSO','F','ARP',.TRUE.,.TRUE.)
    CALL ADD_FIELD_3D(PFRTH(:,:,1),'FCTRAYTH','F','ARP',.TRUE.,.TRUE.)
  ENDIF

ENDIF

IF (LFLEXDIA) THEN
  CALL ARO_STARTBU( KIDIA, KFDIA, NRR,NGFL_EXT,ZZI_RHODJM, &
                  & ZZI_US, ZZI_VS, ZZI_WS, ZZI_THS, ZZI_RS, ZZI_TKES, ZZI_SVS)
ENDIF


!    ------------------------------------------------------------------
!     7 - CONVECTION. 
!     --------------------------------------------------------------------

IF(LKFBCONV) THEN

  ZZI_CVTENDRV(:,:)=0.0_JPRB
  ZZI_CVTENDRC(:,:)=0.0_JPRB
  ZZI_CVTENDRI(:,:)=0.0_JPRB
  ZZI_CVTENDT(:,:)=0.0_JPRB
  ZZI_RSAVE=ZZI_RS
  ZZI_THSAVE=ZZI_THS
  CALL BRI2ACCONV(KIDIA,KFDIA,ILONMNH,KLEV,PGM(KIDIA:KFDIA),&
   & ZZI_PABSM(KIDIA:KFDIA,:,:),ZZZF(KIDIA:KFDIA,:,:),&
   & ZTM(KIDIA:KFDIA,:),&
   & ZZI_RM(KIDIA:KFDIA,:,:,1),ZZI_RM(KIDIA:KFDIA,:,:,2),&
   & ZZI_RM(KIDIA:KFDIA,:,:,4),ZZI_RHODREFM(KIDIA:KFDIA,:,:),&
   & ZZI_UM(KIDIA:KFDIA,:,:),ZZI_VM(KIDIA:KFDIA,:,:),&
   & ZZI_WM(KIDIA:KFDIA,:,:),ZZI_MFS(KIDIA:KFDIA,:),&
   & ZZI_CVTENDT(KIDIA:KFDIA,:),&
   & ZZI_CVTENDRV(KIDIA:KFDIA,:),ZZI_CVTENDRC(KIDIA:KFDIA,:),&
   & ZZI_CVTENDRI(KIDIA:KFDIA,:),ZCVTENDPR(KIDIA:KFDIA),&
   & ZCVTENDPRS(KIDIA:KFDIA)&
   & )  

  IF(MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)"Pluie conv au sol", ZCVTENDPR(NPTP),MAXVAL(ZCVTENDPR(:))&
     & ,MINVAL(ZCVTENDPR(:))  
  ENDIF

  DO JLON = KIDIA, KFDIA
    DO JLEV = 1,KLEV
      PTENDT(JLON,JLEV)=PTENDT(JLON,JLEV) + ZZI_CVTENDT(JLON,JLEV)
      PTENDR(JLON,JLEV,1) = PTENDR(JLON,JLEV,1) + ZZI_CVTENDRV(JLON,JLEV)&
       & *ZQDM(JLON,JLEV)  
      PTENDR(JLON,JLEV,2) = PTENDR(JLON,JLEV,2) + ZZI_CVTENDRC(JLON,JLEV)&
       & *ZQDM(JLON,JLEV)  
      PTENDR(JLON,JLEV,4) = PTENDR(JLON,JLEV,4) + ZZI_CVTENDRI(JLON,JLEV)&
       & *ZQDM(JLON,JLEV)  
    ENDDO
  ENDDO
  DO JLON = KIDIA, KFDIA
    DO JLEV= 1, KLEV
      ZZI_RS(JLON,1,JLEV,1)=ZZI_RSAVE(JLON,1,JLEV,1)+ZZI_CVTENDRV(JLON,JLEV)
      ZZI_RS(JLON,1,JLEV,2)=ZZI_RSAVE(JLON,1,JLEV,2)+ZZI_CVTENDRC(JLON,JLEV)
      ZZI_RS(JLON,1,JLEV,4)=ZZI_RSAVE(JLON,1,JLEV,4)+ZZI_CVTENDRI(JLON,JLEV)
    ENDDO
    DO JLEV=1,KLEV
      ZZI_THS(JLON,1,JLEV)=ZZI_THSAVE(JLON,1,JLEV)+ZZI_CVTENDT(JLON,JLEV)*(RATM/&
       & PAPRSFM(JLON,JLEV))**(RD/RCPD)  
    ENDDO
  ENDDO
  DO JLON =KIDIA, KFDIA
    ZINPRR(JLON,1)=ZINPRR(JLON,1)+ZCVTENDPR(JLON)-ZCVTENDPRS(JLON)
    ZACPRR(JLON,1)=ZACPRR(JLON,1)+(ZCVTENDPR(JLON)-ZCVTENDPRS(JLON))*PDT
    ZINPRS(JLON,1)=ZINPRS(JLON,1)+ZCVTENDPRS(JLON)
    ZACPRS(JLON,1)=ZACPRS(JLON,1)+ZCVTENDPRS(JLON)*PDT
  ENDDO
  ! avance temporelle et inversion niveau pour ZZI_MFS
  ! on utilise PSIGS pour le flux de masse pour la condensation sous maille 
  ! car PSIGS n est utilise que si LOSIGMAS=T
  IF (LOSUBG_COND.AND..NOT.LOSIGMAS) THEN
    DO JLEV = 1,KLEV
      DO JLON = KIDIA,KFDIA
        PSIGS(JLON,JLEV)=ZZI_MFS(JLON,JLEV)
      ENDDO
    ENDDO
  ENDIF
  IF(MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)"aps CONV, TENRV, TENRC, TENRI"
    DO JLEV=1,KLEV
      WRITE(NULOUT,*)PTENDR(NPTP,JLEV,1),PTENDR(NPTP,JLEV,2),PTENDR(NPTP,JLEV,4)
    ENDDO
  ENDIF
  CALL ARO_CONVBU(ZZI_RHODJM,ZZI_RS,ZZI_THS)
ENDIF

!    ------------------------------------------------------------------
!     8 - SURFACE. 
!     --------------------------------------------------------------------

IF (LLMSE) THEN
! A loop around SURFEX in order to test OpenMP

  SURFEX_LOOP : DO ISURFEX = 1, NSURFEX_ITER

! Initialisations 

  DO JLON=KIDIA,KFDIA
    ZZS(JLON,1)=POROG(JLON)*ZINVG 
    ZDEPTH_HEIGHT(JLON,:)=ZZZF(JLON,1,:)-ZZS(JLON,1)  
    IF (ZDEPTH_HEIGHT(JLON,IKB) <= 0._JPRB) THEN
      WRITE (20,*)'sous apl_arome pb height en', JLON,ZZI_APHIFM(JLON,KLEV),&
      & POROG(JLON)
    ENDIF

  ENDDO


  IF (LSURFEX_CRITICAL) THEN
!$OMP CRITICAL (ARO_GROUND_PARAM_LOCK)
    IF (LLMSE_PARAM) &
     & CALL ARO_GROUND_PARAM( KBL,KGPCOMP,&
     & ILONMNH,KIDIA,KFDIA,KSTEP,   &
     & NRR,NSW,NGFL_EXT,NDGUNG, NDGUXG, NDLUNG, NDLUXG,LSURFEX_KFROM,&
     & LMPA,CCOUPLING,LDXFUMSE,&
     & NINDAT,ZRHGMT,RSTATI,RSOVR,RCODEC,RSIDEC, &
     & PINDX(KIDIA:KFDIA),PINDY(KIDIA:KFDIA), &
     & ZZI_UM(KIDIA:KFDIA,1,IKB), &
     & ZZI_VM(KIDIA:KFDIA,1,IKB), &
     & ZTM(KIDIA:KFDIA,KLEV),ZZI_RM(KIDIA:KFDIA,1,IKB,1),&
     & ZZI_SVM(KIDIA:KFDIA,1,IKB,1:NGFL_EXT), &
     & ZCARDI,ZZI_RHODREFM(KIDIA:KFDIA,1,IKB), &
     & ZZI_PABSM(KIDIA:KFDIA,1,IKB),PAPRSM(KIDIA:KFDIA,KLEV), &
     & ZDTMSE,ZDEPTH_HEIGHT(KIDIA:KFDIA,IKB),ZZS(KIDIA:KFDIA,1), XZSEPS, &
     & PMU0(KIDIA:KFDIA),PMU0N(KIDIA:KFDIA),PGELAM(KIDIA:KFDIA),&
     & PGEMU(KIDIA:KFDIA),XSW_BANDS,&
     & ZINPRR_NOTINCR(KIDIA:KFDIA,1),ZINPRS_NOTINCR(KIDIA:KFDIA,1), &
     & ZINPRG_NOTINCR(KIDIA:KFDIA,1), &
     & PFRTHDS(KIDIA:KFDIA),ZZSFSWDIF(KIDIA:KFDIA,1:NSW), &
     & ZZSFSWDIR(KIDIA:KFDIA,1:NSW),&
     & ZCFAQ(KIDIA:KFDIA), ZCFATH(KIDIA:KFDIA), ZCFAU(KIDIA:KFDIA), &
     & ZCFBQ(KIDIA:KFDIA), ZCFBTH(KIDIA:KFDIA), ZCFBU(KIDIA:KFDIA), &
     & ZCFBV(KIDIA:KFDIA), &
     & ZSFTH(KIDIA:KFDIA,1),ZSFRV(KIDIA:KFDIA,1), &
     & ZSFSV(KIDIA:KFDIA,1,1:NGFL_EXT),ZSFCO2(KIDIA:KFDIA,1), &
     & ZSFU(KIDIA:KFDIA,1),ZSFV(KIDIA:KFDIA,1), &
     & ZALBP(KIDIA:KFDIA,1:NSW),ZALBD(KIDIA:KFDIA,1:NSW), &
     & ZEMIS(KIDIA:KFDIA),ZTSURF(KIDIA:KFDIA))
     IF (LRCO2) THEN
       ZSFSV(KIDIA:KFDIA,1,NSV_CO2)= ZSFCO2(KIDIA:KFDIA,1)
!print*,' FLUX CO2 =', MINVAL(ZSFSV(KIDIA:KFDIA,1,NSV_CO2)),&
!                    & MAXVAL(ZSFSV(KIDIA:KFDIA,1,NSV_CO2))
     ENDIF

!!!!! TEST DDH ATTENTION
!ZSFRV = 0._JPRB

    IF (LLMSE_DIAG) &
     & CALL ARO_GROUND_DIAG( KBL, KGPCOMP, &
     & ILONMNH,KIDIA,KFDIA,KLEV, IKL,  &
     & NDGUNG, NDGUXG, NDLUNG, NDLUXG, LSURFEX_KFROM,& 
     & ZZS(KIDIA:KFDIA,1),ZSFRV(KIDIA:KFDIA,1), &
     & ZZI_UM(KIDIA:KFDIA,1,IKTB:IKTE), &
     & ZZI_VM(KIDIA:KFDIA,1,IKTB:IKTE), &
     & ZDEPTH_HEIGHT(KIDIA:KFDIA,IKTB:IKTE), &
     & PFRTH(KIDIA:KFDIA,KLEV,1),PFRSO(KIDIA:KFDIA,KLEV,1),&
     & PINDX(KIDIA:KFDIA),PINDY(KIDIA:KFDIA), &
     & ZQS(KIDIA:KFDIA),ZGZ0(KIDIA:KFDIA),ZGZ0H(KIDIA:KFDIA), &
     & PTCLS(KIDIA:KFDIA),PQCLS(KIDIA:KFDIA),PHUCLS(KIDIA:KFDIA), &
     & PUCLS(KIDIA:KFDIA),PVCLS(KIDIA:KFDIA), &
     & PFCLL(KIDIA:KFDIA,1),PFCLN(KIDIA:KFDIA,1), &
     & PFEVL(KIDIA:KFDIA,1),PFEVN(KIDIA:KFDIA,1), & 
     & ZSSO_STDEV(KIDIA:KFDIA,1), ZTWSNOW(KIDIA:KFDIA,1),&
     & ZBUDTH(KIDIA:KFDIA), ZBUDSO(KIDIA:KFDIA), &
     & ZFCLL(KIDIA:KFDIA), ZTOWNS(KIDIA:KFDIA), &
     & ZCD(KIDIA:KFDIA)                         )
 
!* get snow cover :   
     PSPSG(KIDIA:KFDIA)=ZTWSNOW(KIDIA:KFDIA,1)
!$OMP END CRITICAL (ARO_GROUND_PARAM_LOCK)
  ELSE

    IF (LLMSE_PARAM) &
     & CALL ARO_GROUND_PARAM( KBL,KGPCOMP,&
     & ILONMNH,KIDIA,KFDIA,KSTEP,   &
     & NRR,NSW,NGFL_EXT,NDGUNG, NDGUXG, NDLUNG, NDLUXG,LSURFEX_KFROM,&
     & LMPA,CCOUPLING,LDXFUMSE,&
     & NINDAT,ZRHGMT,RSTATI,RSOVR,RCODEC,RSIDEC, &
     & PINDX(KIDIA:KFDIA),PINDY(KIDIA:KFDIA), &
     & ZZI_UM(KIDIA:KFDIA,1,IKB), &
     & ZZI_VM(KIDIA:KFDIA,1,IKB), &
     & ZTM(KIDIA:KFDIA,KLEV),ZZI_RM(KIDIA:KFDIA,1,IKB,1),&
     & ZZI_SVM(KIDIA:KFDIA,1,IKB,1:NGFL_EXT), &
     & ZCARDI,ZZI_RHODREFM(KIDIA:KFDIA,1,IKB), &
     & ZZI_PABSM(KIDIA:KFDIA,1,IKB),PAPRSM(KIDIA:KFDIA,KLEV), &
     & ZDTMSE,ZDEPTH_HEIGHT(KIDIA:KFDIA,IKB),ZZS(KIDIA:KFDIA,1), XZSEPS, &
     & PMU0(KIDIA:KFDIA),PMU0N(KIDIA:KFDIA),PGELAM(KIDIA:KFDIA),&
     & PGEMU(KIDIA:KFDIA),XSW_BANDS,&
     & ZINPRR_NOTINCR(KIDIA:KFDIA,1),ZINPRS_NOTINCR(KIDIA:KFDIA,1), &
     & ZINPRG_NOTINCR(KIDIA:KFDIA,1), &
     & PFRTHDS(KIDIA:KFDIA),ZZSFSWDIF(KIDIA:KFDIA,1:NSW), &
     & ZZSFSWDIR(KIDIA:KFDIA,1:NSW),&
     & ZCFAQ(KIDIA:KFDIA), ZCFATH(KIDIA:KFDIA), ZCFAU(KIDIA:KFDIA), &
     & ZCFBQ(KIDIA:KFDIA), ZCFBTH(KIDIA:KFDIA), ZCFBU(KIDIA:KFDIA), &
     & ZCFBV(KIDIA:KFDIA), &
     & ZSFTH(KIDIA:KFDIA,1),ZSFRV(KIDIA:KFDIA,1), &
     & ZSFSV(KIDIA:KFDIA,1,1:NGFL_EXT),ZSFCO2(KIDIA:KFDIA,1), &
     & ZSFU(KIDIA:KFDIA,1),ZSFV(KIDIA:KFDIA,1), &
     & ZALBP(KIDIA:KFDIA,1:NSW),ZALBD(KIDIA:KFDIA,1:NSW), &
     & ZEMIS(KIDIA:KFDIA),ZTSURF(KIDIA:KFDIA))
     IF (LRCO2) THEN
       ZSFSV(KIDIA:KFDIA,1,NSV_CO2)= ZSFCO2(KIDIA:KFDIA,1)
!print*,' FLUX CO2 =', MINVAL(ZSFSV(KIDIA:KFDIA,1,NSV_CO2)),&
!                    & MAXVAL(ZSFSV(KIDIA:KFDIA,1,NSV_CO2))
     ENDIF

!!!!! TEST DDH ATTENTION
!ZSFRV = 0._JPRB

    IF (LLMSE_DIAG) &
     & CALL ARO_GROUND_DIAG( KBL, KGPCOMP, &
     & ILONMNH,KIDIA,KFDIA,KLEV, IKL,  &
     & NDGUNG, NDGUXG, NDLUNG, NDLUXG, LSURFEX_KFROM,&
     & ZZS(KIDIA:KFDIA,1),ZSFRV(KIDIA:KFDIA,1), &
     & ZZI_UM(KIDIA:KFDIA,1,IKTB:IKTE), &
     & ZZI_VM(KIDIA:KFDIA,1,IKTB:IKTE), &
     & ZDEPTH_HEIGHT(KIDIA:KFDIA,IKTB:IKTE), &
     & PFRTH(KIDIA:KFDIA,KLEV,1),PFRSO(KIDIA:KFDIA,KLEV,1),& 
     & PINDX(KIDIA:KFDIA),PINDY(KIDIA:KFDIA), &
     & ZQS(KIDIA:KFDIA),ZGZ0(KIDIA:KFDIA),ZGZ0H(KIDIA:KFDIA), &
     & PTCLS(KIDIA:KFDIA),PQCLS(KIDIA:KFDIA),PHUCLS(KIDIA:KFDIA), &
     & PUCLS(KIDIA:KFDIA),PVCLS(KIDIA:KFDIA), &
     & PFCLL(KIDIA:KFDIA,1),PFCLN(KIDIA:KFDIA,1), &
     & PFEVL(KIDIA:KFDIA,1),PFEVN(KIDIA:KFDIA,1), &
     & ZSSO_STDEV(KIDIA:KFDIA,1), ZTWSNOW(KIDIA:KFDIA,1),&
     & ZBUDTH(KIDIA:KFDIA), ZBUDSO(KIDIA:KFDIA), &
     & ZFCLL(KIDIA:KFDIA), ZTOWNS(KIDIA:KFDIA), &
     & ZCD(KIDIA:KFDIA)                         )
 
!* get snow cover :   
     PSPSG(KIDIA:KFDIA)=ZTWSNOW(KIDIA:KFDIA,1)


    ENDIF

  ENDDO SURFEX_LOOP

!* Compute PBL-diagnostics
   
   CALL AROCLDIA(KIDIA,KFDIA,ILONMNH,KLEV,PUCLS(KIDIA:KFDIA), &
    & PVCLS(KIDIA:KFDIA),PTKEM(KIDIA:KFDIA,1:KLEV),&
    & PAPHIFM(KIDIA:KFDIA,1:KLEV),POROG(KIDIA:KFDIA),&
    & PUGST(KIDIA:KFDIA),PVGST(KIDIA:KFDIA),PPBLH(KIDIA:KFDIA),ICLPH)
   PPBLH(KIDIA:KFDIA)=MIN(XMAXLM,MAX(XMINLM,PPBLH(KIDIA:KFDIA))) 

ENDIF    !  <== End block "IF (LMSE)"

!*            IDEALIZED TURBULENT SURFACE FLUXES FOR SQUALL LINE CASE
!                --------------------------------------------------------

IF (LSQUALL.AND.LTURB) THEN
  ! on n'a besoin que d'un flux sur V (U est nul). 
  DO JLON=KIDIA,KFDIA
    IF (ABS(ZZI_VM(JLON,1,IKB)) <= 1.E-12) THEN
      ZSFV(JLON,1)=0.
    ELSE
      ZSFV(JLON,1)=-(ZZI_VM(JLON,1,IKB))**2 * &
       & (0.4_JPRB  /(LOG(ZZZF(JLON,1,IKB)/0.2_JPRB) ) )**2 &
       & *ZZI_VM(JLON,1,IKB)/ABS(ZZI_VM(JLON,1,IKB))  
    ENDIF
  ENDDO
ENDIF

!    ------------------------------------------------------------------
!    9.  Shallow Mass Flux Mixing
!    ------------------------------------------------------------------
IF (LMFSHAL) THEN
    IF (CMF_UPDRAFT=='DUAL') THEN
    ! Updraft computation from EDMF/ECMWF dual proposal
    ! Version May 2007
    !
    ! The following routine  are using arrays with the vertical Arpege/IFS fashion (as in the radiation scheme)

    IDRAFT = 2 ! beginning of the loop for MF tendency equation
               ! only 2 and 3 are used for tendency computation in ARO_SHALLOW_MF
    INDRAFT=3   ! 1 for test, 2 for dry, 3 for wet
    ALLOCATE(ZMF_UP(KLON,0:KLEV,INDRAFT))
    ALLOCATE(ZTHETAL_UP(KLON,0:KLEV,INDRAFT))
    ALLOCATE(ZQT_UP(KLON,0:KLEV,INDRAFT))
    ALLOCATE(ZTHTV_UP(KLON,0:KLEV,INDRAFT))
    ALLOCATE(ZQC_UP(KLON,0:KLEV,INDRAFT))
    ALLOCATE(ZQI_UP(KLON,0:KLEV,INDRAFT))
    ALLOCATE(ZU_UP(KLON,0:KLEV,INDRAFT))
    ALLOCATE(ZV_UP(KLON,0:KLEV,INDRAFT))

    ZZSFTH(:)=-1._JPRB*ZSFTH(:,1)*(PAPRSM(:,KLEV)*ZINVATM)**(ZRSCP)
    ZZSFRV(:)=-1._JPRB*ZSFRV(:,1)
    ZZSFU(:)=ZSFU(:,1)
    ZZSFV(:)=ZSFV(:,1)

    IF(LTOTPREC)THEN
     ZZI_RSAVE=ZZI_RS
     ZZI_THSAVE=ZZI_THS
    ENDIF

    CALL VDFHGHTHL(KSTEP,KIDIA,KFDIA,KLON,KLEV,INDRAFT,&
     & PDT, PUM, PVM,  &
     & ZTM,ZQVM,ZQCM,ZQIM,ZWCLDFR2, &
     & PAPRSM, PAPRSFM, ZZI_APHIFM,ZZI_APHIM, ZZI_EXNREFM, &
     & ZZSFTH(KIDIA:KFDIA),ZZSFRV(KIDIA:KFDIA), &
     & ZZSFU(KIDIA:KFDIA),ZZSFV(KIDIA:KFDIA), &
     & ZMF_UP,ZTHETAL_UP,ZQT_UP,ZTHTV_UP,ZQC_UP,ZQI_UP, &
     & ZU_UP, ZV_UP,&
     & NGFL_EZDIAG, PEZDIAG, &
     & ZTENDQVUP,ZTENDTUP,ZSURFPREP,ZSURFSNOW, &
     & ZUPGENL,ZUPGENN, ZCLFR, &
     & ZLENGTH_M, ZLENGTH_H, PTKEEDMF)

! TKE must be greater than its minimum value
!
GTKENEG =  PTKEEDMF <= XTKEMIN 
WHERE ( GTKENEG ) 
  PTKEEDMF = XTKEMIN
END WHERE


    !  tendtup, tendqvup  tendencies for non-conserved AROME
    !  variables due to updraft precipitation/snow (and its evaporation)
    DO JLEV = 2 ,KLEV
      DO JLON = KIDIA,KFDIA
        PTENDT(JLON,JLEV)=PTENDT(JLON,JLEV) + ZTENDTUP(JLON,JLEV)
        PTENDR(JLON,JLEV,1)=PTENDR(JLON,JLEV,1) + ZTENDQVUP(JLON,JLEV)
      ENDDO
    ENDDO
    
    IF(LTOTPREC)THEN
     !Add rain and snow tendencies from the sub-grid scheme to tendencies and sources,
     !at all vertical levels, instead of diagnosing only surface precip. 
     !Scale by 2D cloud-fraction from the cloud layer.

     DO JLON = KIDIA, KFDIA
        ZSURFPREP(JLON)=0.0_JPRB
        ZSURFSNOW(JLON)=0.0_JPRB
      DO JLEV= 1, KLEV
      !Add rain and snow to sources:
       ZZI_RS(JLON,1,JLEV,3)=ZZI_RSAVE(JLON,1,JLEV,3)+ZUPGENL(JLON,JLEV)
       ZZI_RS(JLON,1,JLEV,5)=ZZI_RSAVE(JLON,1,JLEV,5)+ZUPGENN(JLON,JLEV)
       ZZI_THS(JLON,1,JLEV)=ZZI_THSAVE(JLON,1,JLEV)+ZTENDTUP(JLON,JLEV)*(RATM/&
       & PAPRSFM(JLON,JLEV))**(RD/RCPD)
      ENDDO
     ENDDO

     DO JLON = KIDIA, KFDIA
      DO JLEV= 1, KLEV 
      !Update rain/snow tendencies:
       PTENDR(JLON,JLEV,3)=PTENDR(JLON,JLEV,3)+ZUPGENL(JLON,JLEV)
       PTENDR(JLON,JLEV,5)=PTENDR(JLON,JLEV,5)+ZUPGENN(JLON,JLEV)
      ENDDO
     ENDDO 

    ENDIF


  ELSE
    INDRAFT=1
    IDRAFT=3 ! only a wet updraft
  ENDIF

  DO JDRAFT=IDRAFT,3
  !!! Call mass fluxes computations
  ! If CMF_UPDRAFT='DUAL', the updraft characteritics are already computed and will be passed as inputs of SHALLOW_MF
  ! if not, they will be computed in SHALLOW_MF itself (from Méso-NH type routines)

  ! JDRAFT=2 : dry updraft
  ! JDRAFT=3 : wet updraft

  IF (CMF_UPDRAFT=='DUAL') THEN
    ! Goes from one of the updraft from the IFS level world to the Méso-NH level world
    ! go from q to r)
    DO JLEV = 1,KLEV
      DO JLON = KIDIA,KFDIA
         ZZI_MF_UP(JLON,1,JLEV) = ZMF_UP(JLON,JLEV,JDRAFT)
         ZZI_ZU_UP(JLON,1,JLEV) = ZU_UP(JLON,JLEV,JDRAFT)
         ZZI_ZV_UP(JLON,1,JLEV) = ZV_UP(JLON,JLEV,JDRAFT)
         ZZI_THETAL_UP(JLON,1,JLEV) = ZTHETAL_UP(JLON,JLEV,JDRAFT)
         ZZI_THETAV_UP(JLON,1,JLEV) = ZTHTV_UP(JLON,JLEV,JDRAFT)
         ZZI_RT_UP(JLON,1,JLEV)  = ZQT_UP(JLON,JLEV,JDRAFT)/ &
          &                         (1.-ZQT_UP(JLON,JLEV,JDRAFT))
         ZZI_RC_UP(JLON,1,JLEV)  = ZQC_UP(JLON,JLEV,JDRAFT) / &
          &                         (1.-ZQT_UP(JLON,JLEV,JDRAFT))
         ZZI_RI_UP(JLON,1,JLEV)  = ZQI_UP(JLON,JLEV,JDRAFT)/ &
          &                         (1.-ZQT_UP(JLON,JLEV,JDRAFT))
         ZZI_LENGTHM(JLON,1,JLEV) = max(0.01_JPRB,ZLENGTH_M(JLON,JLEV))
         ZZI_LENGTHH(JLON,1,JLEV) = max(0.01_JPRB,ZLENGTH_H(JLON,JLEV))
         ZZI_PTKEEDMF(JLON,1,JLEV) = PTKEEDMF(JLON,JLEV)
         ZZI_TKEEDMFS(JLON,1,JLEV) = PTKEEDMF(JLON,JLEV)*ZINVDT
      ENDDO
    ENDDO
    ZZI_ZW_UP(KIDIA:KFDIA,1,1:IKT)=0.
    ZZI_ZFRAC_UP(KIDIA:KFDIA,1,1:IKT)=0.
  ENDIF
  IF(MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)"apres surface zsfth zsfrv",ZSFTH(NPTP,1),ZSFRV(NPTP,1)
  ENDIF


  ZRC_MF = 0.0_JPRB
  ZRI_MF = 0.0_JPRB
  ZCF_MF = 0.0_JPRB

  CALL ARO_SHALLOW_MF (KKL=IKL, KLON=ILONMNH,KLEV=KLEV,KRR=NRR,KRRL=NRRL,      &
   & KRRI=NRRI,KSV=NGFL_EXT,HMF_UPDRAFT=CMF_UPDRAFT, HMF_CLOUD=CMF_CLOUD,      &
   & HFRAC_ICE='T',                                                            &
   & OMIXUV=LMIXUV, ONOMIXLG=.FALSE.,KSV_LGBEG=0,KSV_LGEND=0,                  &
   & KTCOUNT=KSTEP+1, PTSTEP=ZDT,                                              &
   & PZZ=ZZZ(KIDIA:KFDIA,1,1:KLEV),PZZF= ZZZF(KIDIA:KFDIA,1,1:KLEV),                     &
   & PDZZF= ZDZZF(KIDIA:KFDIA,1,1:KLEV),                     &
   & PRHODJ=ZZI_RHODJM(KIDIA:KFDIA,1,1:KLEV),                                       &
   & PRHODREF=ZZI_RHODREFM(KIDIA:KFDIA,1,1:KLEV),                                   &
   & PPABSM=ZZI_PABSM(KIDIA:KFDIA,1,1:KLEV),                                        &
   & PEXNM=ZZI_EXNREFM(KIDIA:KFDIA,1,1:KLEV),                                       &
   & PSFTH=ZSFTH(KIDIA:KFDIA,1),PSFRV=ZSFRV(KIDIA:KFDIA,1),                    &
   & PTHM=ZZI_THM(KIDIA:KFDIA,1,1:KLEV),PRM=ZZI_RM(KIDIA:KFDIA,1,1:KLEV,:),              &
   & PUM=ZZI_UM(KIDIA:KFDIA,1,1:KLEV),PVM=ZZI_VM(KIDIA:KFDIA,1,1:KLEV),                  &
   & PTKEM=ZZI_TKEM(KIDIA:KFDIA,1,1:KLEV),PSVM=ZZI_SVM(KIDIA:KFDIA,1,1:KLEV,:),          &
   & PDUDT_MF=ZZI_MFUS(KIDIA:KFDIA,1,1:KLEV),PDVDT_MF=ZZI_MFVS(KIDIA:KFDIA,1,1:KLEV),    &
   & PDTHLDT_MF=ZZI_THLS(KIDIA:KFDIA,1,1:KLEV),PDRTDT_MF=ZZI_RTS(KIDIA:KFDIA,1,1:KLEV),  &
   & PDSVDT_MF=ZZI_SVSAVE(KIDIA:KFDIA,1,1:KLEV,:),                                  &
   & PSIGMF=ZSIGMF(KIDIA:KFDIA,1,1:KLEV),PRC_MF=ZRC_MF(KIDIA:KFDIA,1,1:KLEV),            &
   & PRI_MF=ZRI_MF(KIDIA:KFDIA,1,1:KLEV),                                           &
   & PCF_MF=ZCF_MF(KIDIA:KFDIA,1,1:KLEV),PFLXZTHVMF=ZFLXZTHVMF(KIDIA:KFDIA,1,1:KLEV),    &
   & PTHL_UP=ZZI_THETAL_UP(KIDIA:KFDIA,1,1:KLEV),PRT_UP= ZZI_RT_UP(KIDIA:KFDIA,1,1:KLEV),&
   & PRV_UP=ZZI_ZRV_UP(KIDIA:KFDIA,1,1:KLEV),                                       &
   & PRC_UP=ZZI_RC_UP(KIDIA:KFDIA,1,1:KLEV),PRI_UP=ZZI_RI_UP(KIDIA:KFDIA,1,1:KLEV),      &
   & PU_UP=ZZI_ZU_UP(KIDIA:KFDIA,1,1:KLEV),PV_UP=ZZI_ZV_UP(KIDIA:KFDIA,1,1:KLEV),        &
   & PTHV_UP=ZZI_THETAV_UP(KIDIA:KFDIA,1,1:KLEV),PW_UP=ZZI_ZW_UP(KIDIA:KFDIA,1,1:KLEV),  &
   & PFRAC_UP=ZZI_ZFRAC_UP(KIDIA:KFDIA,1,1:KLEV),PEMF=ZZI_MF_UP(KIDIA:KFDIA,1,1:KLEV))

!wc for new stat cloud scheme sum contributions dry and wet updraft to variance s
!   for option EDKF DIR this has no impact
!   Is it allowed not to use KIDIA etc in the calculation below????
IF (STATNEW) THEN
 IF (JDRAFT .EQ. 2) THEN
  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
   ZSIGMF(JLON,1,JLEV)=0._JPRB
!  ZSIGMF_SUM=SQRT(ZSIGMF_SUM**2._JPRB + ZSIGMF**2._JPRB)
    ENDDO
  ENDDO
 ENDIF
ENDIF
  ZFLXZTHVMF_SUM=ZFLXZTHVMF_SUM+ZFLXZTHVMF
  ! traitement des sorties pour repasser dans le monde Aladin

IF ((CMF_CLOUD=='DIRE'.OR.CMF_CLOUD=='BIGA').AND.JDRAFT==3) THEN
  ! sauvegarde pour le schema de nuage
  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      PEZDIAG(JLON,JLEV,1)=ZRC_MF(JLON,1,JLEV)
      PEZDIAG(JLON,JLEV,3)=ZRI_MF(JLON,1,JLEV)
      PEZDIAG(JLON,JLEV,2)=ZCF_MF(JLON,1,JLEV)
    ENDDO
  ENDDO
ENDIF
ZZI_US=ZZI_US+ZZI_MFUS
ZZI_VS=ZZI_VS+ZZI_MFVS
ZZI_THS=ZZI_THS+ZZI_THLS
ZZI_RS(KIDIA:KFDIA,1,:,1)=ZZI_RS(KIDIA:KFDIA,1,:,1)+ZZI_RTS(KIDIA:KFDIA,1,:)

  !calcul de tendance et inversion des niveaux pour le vent horizontal
  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      PTENDU(JLON,JLEV)=PTENDU(JLON,JLEV)+ZZI_MFUS(JLON,1,JLEV)
      PTENDV(JLON,JLEV)=PTENDV(JLON,JLEV)+ZZI_MFVS(JLON,1,JLEV)
    ENDDO
  ENDDO

  !conversion de la tendance de theta en tendance de T et inversion niveau
  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      PTENDT(JLON,JLEV)=PTENDT(JLON,JLEV)+ZZI_THLS(JLON,1,JLEV)&
       & *ZZI_EXNREFM(JLON,1,JLEV)
    ENDDO
  ENDDO

  !inversion niveaux tendances des ri et conversion en qi en multipliant par qd
  DO JLEV=1,KLEV
    DO JLON=KIDIA,KFDIA
      PTENDR(JLON,JLEV,1) = PTENDR(JLON,JLEV,1) &
       & +ZZI_RTS(JLON,1,JLEV)*ZQDM(JLON,JLEV)
    ENDDO
  ENDDO

! End loop on JDRAFT
ENDDO

IF (ALLOCATED(ZMF_UP)) THEN
  DEALLOCATE(ZMF_UP, ZTHETAL_UP, ZTHTV_UP, ZQT_UP, ZQC_UP, ZQI_UP, ZU_UP, ZV_UP)
ENDIF

! End test (IF LMFSHAL)
ENDIF


!    ------------------------------------------------------------------
!     10 - TURBULENCE.
!     --------------------------------------------------------------------
IF (LTURB) THEN

  ! 10.1 sauvegarde pour le calcul des tendances
  ZZI_WSAVE=ZZI_WS
  ZZI_THSAVE=ZZI_THS
  ZZI_RSAVE=ZZI_RS
  ZZI_TKESAVE=ZZI_TKES
  IF (NGFL_EXT/=0) THEN
    ZZI_SVSAVE=ZZI_SVS
  ENDIF

  !prints
  IF(MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)'avant d entrer dans turb sous apl_arome U'
    WRITE(NULOUT,*)MAXVAL(ZZI_UM(KIDIA:KFDIA,1,IKB)), &
     & MINVAL(ZZI_UM(KIDIA:KFDIA,1,IKB))
    WRITE(NULOUT,*)'avant d entrer dans turb sous apl_arome V'
    WRITE(NULOUT,*)MAXVAL(ZZI_VM(KIDIA:KFDIA,1,IKB)), &
     & MINVAL(ZZI_VM(KIDIA:KFDIA,1,IKB))
    WRITE(NULOUT,*)'avant d entrer dans turb sous apl_arome W'
    WRITE(NULOUT,*)MAXVAL(ZZI_WM(KIDIA:KFDIA,1,IKB)), &
     & MINVAL(ZZI_WM(KIDIA:KFDIA,1,IKB))
    WRITE(NULOUT,*)'avant d entrer dans turb sous apl_arome TKE'
    WRITE(NULOUT,*)MAXVAL(ZZI_TKEM(KIDIA:KFDIA,1,IKB)), &
     & MINVAL(ZZI_TKEM(KIDIA:KFDIA,1,IKB))
    DO JLEV=1,KLEV
      WRITE(NULOUT,*)JLEV,ZZI_UM(NPTP,1,JLEV),ZZI_VM(NPTP,1,JLEV)&
      &,ZZI_WM(NPTP,1,JLEV),ZZI_TKEM(NPTP,1,JLEV)
    ENDDO
    WRITE(NULOUT,*)'u v w tke a S'
    DO JLEV=1,KLEV
      WRITE(NULOUT,*)JLEV,ZZI_US(NPTP,1,JLEV),ZZI_VS(NPTP,1,JLEV)&
      &,ZZI_WS(NPTP,1,JLEV),ZZI_TKES(NPTP,1,JLEV)
    ENDDO
    WRITE(NULOUT,*)'ZZI_THS avant turb'
    DO JLEV=1,KLEV
      WRITE(NULOUT,*)JLEV,ZZI_THS(NPTP,1,JLEV)
    ENDDO
  ENDIF

  ! 10.2 calcul TURB
  ZZTOP(KIDIA:KFDIA)=ZZI_APHIM(KIDIA:KFDIA,0)*ZINVG

  CALL ARO_TURB_MNH(KKA=IKA,KKU=IKU,KKL=IKL,KLON=ILONMNH,KLEV=KLEV,&
   & KRR=NRR, KRRL=NRRL,KRRI= NRRI,     &
   & KSV=NGFL_EXT,KTCOUNT=KSTEP+1,PTSTEP=ZDT,                        & 
   & PZZ=ZZZ(KIDIA:KFDIA,:,1:KLEV),PZZF=ZZZF(KIDIA:KFDIA,:,1:KLEV),   &
   & PZZTOP= ZZTOP,PRHODJ=ZZI_RHODJM(KIDIA:KFDIA,:,1:KLEV),&
   & PTHVREF=ZTHVREFM(KIDIA:KFDIA,:,1:KLEV),    &
   & PRHODREF=ZZI_RHODREFM(KIDIA:KFDIA,:,1:KLEV),HINST_SFU='M', &
   & PSFTH=ZSFTH(KIDIA:KFDIA,1),PSFRV=ZSFRV(KIDIA:KFDIA,1),            &
   & PSFSV=ZSFSV(KIDIA:KFDIA,1,1:NGFL_EXT),PSFU=ZSFU(KIDIA:KFDIA,1),      &
   & PSFV=ZSFV(KIDIA:KFDIA,1),PPABSM=ZZI_PABSM(KIDIA:KFDIA,:,1:KLEV),   &
   & PUM=ZZI_UM(KIDIA:KFDIA,:,1:KLEV),&
   & PVM=ZZI_VM(KIDIA:KFDIA,:,1:KLEV),                 &
   & PWM=ZZI_WM(KIDIA:KFDIA,:,1:KLEV),&
   & PTKEM=ZZI_TKEM(KIDIA:KFDIA,:,1:KLEV),PEPSM=ZEPSM, &
   & PSVM=ZZI_SVM(KIDIA:KFDIA,:,1:KLEV,:),&
    &PSRCM=ZSRCS(KIDIA:KFDIA,:,1:KLEV),            &
   & PUT=ZZI_UM(KIDIA:KFDIA,:,1:KLEV),&
   & PVT=ZZI_VM(KIDIA:KFDIA,:,1:KLEV),                 &
   & PWT=ZZI_WM(KIDIA:KFDIA,:,1:KLEV),               &
   & PTHM=ZZI_THM(KIDIA:KFDIA,:,1:KLEV),&
   & PRM=ZZI_RM(KIDIA:KFDIA,:,1:KLEV,:),             &
   & PRUS=ZZI_US(KIDIA:KFDIA,:,1:KLEV),&
   & PRVS=ZZI_VS(KIDIA:KFDIA,:,1:KLEV),               &
   & PRWS=ZZI_WS(KIDIA:KFDIA,:,1:KLEV),  &
   & PRTHS=ZZI_THS(KIDIA:KFDIA,:,1:KLEV),&
   & PRRS=ZZI_RS(KIDIA:KFDIA,:,1:KLEV,:),           &
   & PRSVS=ZZI_SVS(KIDIA:KFDIA,:,1:KLEV,:),&
   & PRTKES=ZZI_TKES(KIDIA:KFDIA,:,1:KLEV),       &
   & PREPSS=ZEPSS,PSIGS=ZZI_SIGS(KIDIA:KFDIA,:,1:KLEV),&
   & OSUBG_COND=LOSUBG_COND,     &
   & PDRUS_TURB=ZTENDU_TURB(KIDIA:KFDIA,:,1:KLEV),                &
   & PDRVS_TURB=ZTENDV_TURB(KIDIA:KFDIA,:,1:KLEV),                &
   & PDRTHLS_TURB=ZTENDTHL_TURB(KIDIA:KFDIA,:,1:KLEV),            &
   & PDRRTS_TURB=ZTENDRT_TURB(KIDIA:KFDIA,:,1:KLEV),              &
   & PDRSVS_TURB=ZTENDSV_TURB(KIDIA:KFDIA,:,1:KLEV,:),            &
   & PFLXZTHVMF=ZFLXZTHVMF_SUM(KIDIA:KFDIA,:,1:KLEV),             &
   & PLENGTHM=ZZI_LENGTHM(KIDIA:KFDIA,:,1:KLEV),PLENGTHH=ZZI_LENGTHH(KIDIA:KFDIA,:,1:KLEV), &
   & HMF_UPDRAFT=CMF_UPDRAFT,MFMOIST=ZZI_MF_UP(KIDIA:KFDIA,:,1:KLEV) )


   
  IF(MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)'u v w a S apres turb'
    DO JLEV=1,KLEV
      WRITE(NULOUT,*)JLEV,ZZI_US(NPTP,1,JLEV),ZZI_VS(NPTP,1,JLEV)&
       &,ZZI_WS(NPTP,1,JLEV),ZZI_TKES(NPTP,1,JLEV)
    ENDDO
    WRITE(NULOUT,*)'THS TKES SIGS apres turb'
    DO JLEV=1,KLEV
      WRITE(NULOUT,*)JLEV,ZZI_THS(NPTP,1,JLEV),ZZI_TKES(NPTP,1,JLEV)&
       &,ZZI_SIGS(NPTP,1,JLEV)
    ENDDO
  ENDIF

  ! avance temporelle et inversion niveau pour ZZI_SIGS
  IF (LOSUBG_COND .AND. LOSIGMAS) THEN
    IF (CMF_CLOUD=='DIRE'.OR.CMF_CLOUD=='BIGA'.OR.CMF_CLOUD=='NONE') THEN
      DO JLEV = 1,KLEV
        DO JLON = KIDIA,KFDIA
          PSIGS(JLON,JLEV)=ZZI_SIGS(JLON,1,JLEV)
        ENDDO
      ENDDO
    ELSEIF (CMF_CLOUD=='STAT') THEN
  !wc here in case of NEW STAT option convection contribution to variance s from both updrafts
       IF (.FALSE.) THEN
         DO JLEV = 1,KLEV
            DO JLON = KIDIA,KFDIA
              PSIGS(JLON,JLEV)=SQRT(ZZI_SIGS(JLON,1,JLEV)**2+ZSIGMF_SUM(JLON,1,JLEV)**2 )
            ENDDO
         ENDDO
       ELSE
         DO JLEV = 1,KLEV
            DO JLON = KIDIA,KFDIA
              PSIGS(JLON,JLEV)=SQRT(ZZI_SIGS(JLON,1,JLEV)**2+ZSIGMF(JLON,1,JLEV)**2 )
            ENDDO
         ENDDO
       ENDIF
    ENDIF
  ENDIF


  !10.3. traitement des sorties pour repasser dans le monde Aladin
  !calcul de tendance et inversion des niveaux pour le vent horizontal et la TKE

  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      PTENDU(JLON,JLEV)=PTENDU(JLON,JLEV)+ZTENDU_TURB(JLON,1,JLEV)
      PTENDV(JLON,JLEV)=PTENDV(JLON,JLEV)+ZTENDV_TURB(JLON,1,JLEV)
      ! for the moment, turbulence do not compute w tendency:
      PTENDW(JLON,JLEV)=0.0_JPRB
      ! PTENDW(JLON,JLEV)+(ZZI_WS(JLON,1,JLEV)-&
      ! & ZZI_WSAVE(JLON,1,JLEV))
       IF (LHARATU) THEN
          PTENDTKE(JLON,JLEV)=PTENDTKE(JLON,JLEV)+(ZZI_TKEEDMFS(JLON,1,JLEV)-&
          & ZZI_TKESAVE(JLON,1,JLEV))
       ELSE
         PTENDTKE(JLON,JLEV)=PTENDTKE(JLON,JLEV)+(ZZI_TKES(JLON,1,JLEV)-&
         & ZZI_TKESAVE(JLON,1,JLEV))
       ENDIF

    ENDDO
  ENDDO

  IF(NGFL_EXT/=0) THEN
    DO JLEV = 1,KLEV
      DO JLON = KIDIA,KFDIA
        PTENDEXT(JLON,JLEV,:)=PTENDEXT(JLON,JLEV,:)+ &
         & (ZZI_SVS(JLON,1,JLEV,:)- &
         & ZZI_SVSAVE(JLON,1,JLEV,:))
      ENDDO
    ENDDO
  ENDIF


  !conversion de la tendance de theta en tendance de T et inversion niveau
  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      PTENDT(JLON,JLEV)=PTENDT(JLON,JLEV)+ZTENDTHL_TURB(JLON,1,JLEV)&
       & *ZZI_EXNREFM(JLON,1,JLEV)
    ENDDO
  ENDDO
  !inversion niveaux tendances des rv et conversion en qv en multipliant par qd
    DO JLEV=1,KLEV
      DO JLON=KIDIA,KFDIA
        PTENDR(JLON,JLEV,1)= PTENDR(JLON,JLEV,1) &
         & +ZTENDRT_TURB(JLON,1,JLEV)*ZQDM(JLON,JLEV)
      ENDDO
    ENDDO

ENDIF
!    ------------------------------------------------------------------
!     11 - MICROPHYSIQUE. 
!     --------------------------------------------------------------------
IF (LMICRO) THEN

  ZZI_THSAVE=ZZI_THS
  ZZI_RSAVE=ZZI_RS
  
  !prints
  IF (MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)'avant rain_ice sous apl_arome'
    WRITE(NULOUT,*)'JLEV   ZZZF      ZZZ      ZRHODREF',&
     & '    ZRHODJ      ZZI_PABSM        ZZI_THS       ZZI_THM      '   
    DO JLEV=1,KLEV+1 
      WRITE(NULOUT,'(I2,x,7f10.3)')JLEV,ZZZF(NPTP,1,JLEV),ZZZ(NPTP,1,JLEV),&
       & ZZI_RHODREFM(NPTP,1,JLEV),&
       & ZZI_RHODJM(NPTP,1,JLEV), ZZI_PABSM(NPTP,1,JLEV), ZZI_THS(NPTP,1,JLEV),&
       & ZZI_THM(NPTP,1,JLEV)  
    ENDDO 
    WRITE(NULOUT,*)'JLEV        PDELPM        ZZI_PABSM         ZEXNREF',&
       &'          ZZI_SIGS'
    DO JLEV=2,KLEV
      WRITE(NULOUT,'(I2,x,4f10.3)')JLEV, PDELPM(NPTP,JLEV),&
       & ZZI_PABSM(NPTP,1,JLEV),ZZI_EXNREFM(NPTP,1,JLEV),ZZI_SIGS(NPTP,1,JLEV)  
    ENDDO
    WRITE(NULOUT,*)'JLEV    PTM       PRM          PCPM'
    DO JLEV=1,KLEV
      WRITE(NULOUT,'(I2,x,3f10.3)')JLEV,ZTM(NPTP,KLEV+1-JLEV),&
       & ZRHM(NPTP,KLEV+1-JLEV)&
       & ,ZCPM(NPTP,KLEV+1-JLEV)  
    ENDDO
    WRITE (NULOUT,*)'JLEV  rhoQv  rhoQc   rhoQr   rhoQi   rhoQs   rhoQg'
    DO JLEV=1,KLEV
      WRITE(NULOUT,'(I2,x,6e11.4)')JLEV,ZZI_RM(NPTP,1,JLEV,1), &
       & ZZI_RM(NPTP,1,JLEV,2),&
       & ZZI_RM(NPTP,1,JLEV,3),ZZI_RM(NPTP,1,JLEV,4),ZZI_RM(NPTP,1,JLEV,5),&
       & ZZI_RM(NPTP,1,JLEV,6)  
    ENDDO
    WRITE (NULOUT,*)'JLEV  ZRSQv  ZRSQc   ZRSQr   ZRSQi   ZRSQs   ZRSQg'
    DO JLEV=1,KLEV
      WRITE(NULOUT,'(I2,x,6e11.4)')JLEV,ZZI_RS(NPTP,1,JLEV,1), &
       & ZZI_RS(NPTP,1,JLEV,2),&
       & ZZI_RS(NPTP,1,JLEV,3),ZZI_RS(NPTP,1,JLEV,4),ZZI_RS(NPTP,1,JLEV,5),&
       & ZZI_RS(NPTP,1,JLEV,6)  
    ENDDO
    WRITE(NULOUT,*)'ZDT=',ZDT
    WRITE(NULOUT,*)'NRR & co',NRR,KSTEP+1,NSPLITR,LOSUBG_COND,&
     & LOSIGMAS, CSUBG_AUCV_RC,LOWARM  
  ENDIF
  
  ! because of leap-frog time step supposed in mesoNH we have to divide ACPR*
  !  by two before calling AC_RAIN_ICE and multiply after 
  DO JLON=KIDIA,KFDIA
    ZACPRR(JLON,1)=0.5_JPRB*ZACPRR(JLON,1)
    ZACPRS(JLON,1)=0.5_JPRB*ZACPRS(JLON,1)
    ZACPRG(JLON,1)=0.5_JPRB*ZACPRG(JLON,1)
  ENDDO

   ZSEA(:,1)=0.0_JPRB
   ZTOWN(:,1)=0.0_JPRB

   IF (LOLSMC) THEN
    DO JLON = KIDIA, KFDIA
     IF(PLSM(JLON) < 0.5) THEN
        ZSEA(JLON,1) = 1.0_JPRB
     ENDIF
    ENDDO
   ENDIF
         
   IF (LOTOWNC) THEN
     ZTOWN(:,1) = ZTOWNS
   ENDIF  

  CALL ARO_RAIN_ICE (KLEV,IKU,IKL,ILONMNH,KLEV,NRR,KSTEP+1,NSPLITR,&
   & LOSUBG_COND, CSUBG_AUCV_RC, LOSEDIC,CSEDIM,&
   & ZDT,ZDZZ(KIDIA:KFDIA,:,1:KLEV) ,&
   & ZZI_RHODJM(KIDIA:KFDIA,:,1:KLEV),ZZI_RHODREFM(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_EXNREFM(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_PABSM(KIDIA:KFDIA,:,1:KLEV),&
   & ZZI_THM(KIDIA:KFDIA,:,1:KLEV),ZZI_RM(KIDIA:KFDIA,:,1:KLEV,:),&
   & ZZI_SIGS(KIDIA:KFDIA,:,1:KLEV),&
   & ZNEBMNH(KIDIA:KFDIA,:,1:KLEV),& 
   & ZZI_THS(KIDIA:KFDIA,:,1:KLEV),ZZI_RS(KIDIA:KFDIA,:,1:KLEV,:), &
   & ZEVAP(KIDIA:KFDIA,:,1:KLEV), &
   & ZCIT(KIDIA:KFDIA,:,1:KLEV),LOWARM,ZSEA,ZTOWN,&
   & ZICLDFR(KIDIA:KFDIA,:,1:KLEV),ZWCLDFR(KIDIA:KFDIA,:,1:KLEV),& 
   & ZSSIO(KIDIA:KFDIA,:,1:KLEV),ZSSIU(KIDIA:KFDIA,:,1:KLEV),& 
   & ZIFR(KIDIA:KFDIA,:,1:KLEV),&
   & LOCND2, LKOGAN,LMODICEDEP,&
   & ZINPRR_NOTINCR(KIDIA:KFDIA,1),ZACPRR(KIDIA:KFDIA,1),&
   & ZINPRS_NOTINCR(KIDIA:KFDIA,1),ZACPRS(KIDIA:KFDIA,1),&
   & ZINPRG_NOTINCR(KIDIA:KFDIA,1),ZACPRG(KIDIA:KFDIA,1),&
   & ZINPRH_NOTINCR(KIDIA:KFDIA,1),ZZI_PFPR(KIDIA:KFDIA,1,1:KLEV,:),&
   & CSUBG_RC_RR_ACCR, CSUBG_RR_EVAP, CSUBG_RPR_PDF )

  DO JLON=KIDIA,KFDIA
    ZINPRR(JLON,1)=ZINPRR(JLON,1)+ZINPRR_NOTINCR(JLON,1)
    ZINPRS(JLON,1)=ZINPRS(JLON,1)+ZINPRS_NOTINCR(JLON,1)
    ZINPRG(JLON,1)=ZINPRG(JLON,1)+ZINPRG_NOTINCR(JLON,1)
    ZINPRH(JLON,1)=ZINPRH(JLON,1)+ZINPRH_NOTINCR(JLON,1)
  ENDDO

  DO JLON=KIDIA,KFDIA
    ZACPRR(JLON,1)=2._JPRB*ZACPRR(JLON,1)
    ZACPRS(JLON,1)=2._JPRB*ZACPRS(JLON,1)
    ZACPRG(JLON,1)=2._JPRB*ZACPRG(JLON,1)
  ENDDO

  !conversion de la tendance de theta en tendance de T et inversion niveau
  DO JLEV = 1,KLEV
    DO JLON = KIDIA,KFDIA
      PTENDT(JLON,JLEV)= PTENDT(JLON,JLEV)+(ZZI_THS(JLON,1,JLEV)-&
       & ZZI_THSAVE(JLON,1,JLEV))*ZZI_EXNREFM(JLON,1,JLEV)  
    ENDDO
  ENDDO
  
  !inversion niveaux tendances des ri et conversion en qi en multipliant par qd
  DO JR=1,NRR
    DO JLEV=1,KLEV
      DO JLON=KIDIA,KFDIA
        PTENDR(JLON,JLEV,JR)=PTENDR(JLON,JLEV,JR)         &
         & +(ZZI_RS(JLON,1,JLEV,JR)  &
         & -ZZI_RSAVE(JLON,1,JLEV,JR))*ZQDM(JLON,JLEV)  
      ENDDO
    ENDDO
  ENDDO

  !inversion of levels of upper-air precipitation
  DO JR=2,NRR ! no precip for qv
    ZFPR(:,0,JR)=0._JPRB  ! zero precip at top of atmosphere
    DO JLEV=1,KLEV
      DO JLON=KIDIA,KFDIA
        ZFPR(JLON,JLEV,JR)=ZZI_PFPR(JLON,1,JLEV,JR)
      ENDDO
    ENDDO
  ENDDO
        
  !prints    
  IF(MOD(KSTEP+1,NPRINTFR)==0) THEN
    WRITE(NULOUT,*)'PTENDT en sortie de rain_ice'
    WRITE(NULOUT,*)'ZZI_THS en sortie de rain_ice'
    DO JLEV=1,KLEV
      WRITE(NULOUT,*)PTENDT(NPTP,JLEV),ZZI_THS(NPTP,1,JLEV)
    ENDDO
    WRITE (NULOUT,*)'JLEV  ZTENDQv  ZTZNDQc   ZTENDQr   ZTENDQi'&
     & ,'ZTENDQs   ZTENDQg'  
    DO JLEV=1,KLEV
      WRITE(NULOUT,'(I2,x,6e11.4)')JLEV,PTENDR(NPTP,JLEV,1),&
       & PTENDR(NPTP,JLEV,2),&
       & PTENDR(NPTP,JLEV,3),PTENDR(NPTP,JLEV,4),PTENDR(NPTP,JLEV,5),&
       & PTENDR(NPTP,JLEV,6)  
    ENDDO
    WRITE (NULOUT,*) 'ZSRCS et ZNEBMNH',MAXVAL(ZSRCS),MAXVAL(ZNEBMNH) 
  ENDIF
  
  IF (LRDEPOS) THEN
    ZZI_SVSAVE=ZZI_SVM
    CALL ARO_RAINAERO(ILONMNH,KLEV,NGFL_EXT,NRR, PDT,        &
        &          ZZI_SVM(KIDIA:KFDIA,:,:,1:NGFL_EXT),   &
        &          ZZZ(KIDIA:KFDIA,:,:),                  &
        &          ZZI_PABSM(KIDIA:KFDIA,:,:),            &
        &          ZZI_THM(KIDIA:KFDIA,:,:),              &
        &          ZZI_RHODREFM(KIDIA:KFDIA,:,:),         &
        &          KSTEP+1,                               &
        &          ZZI_RM(KIDIA:KFDIA,:,:,:),             &
        &          ZEVAP(KIDIA:KFDIA,:,:),                &
        &          NSPLITR               )
! return to tendency
     DO JLEV = 1,KLEV
       DO JLON = KIDIA,KFDIA
         PTENDEXT(JLON,JLEV,:)=PTENDEXT(JLON,JLEV,:)+&
         & (ZZI_SVM(JLON,1,JLEV,:)-&
         & ZZI_SVSAVE(JLON,1,JLEV,:))*ZINVDT
       ENDDO
     ENDDO
  ENDIF

ENDIF
    
!    ------------------------------------------------------------------
!     11 - SAVE FIELDS FOR EXT. SURFACE.
!     --------------------------------------------------------------------
!    Cette partie n'est plus necessaire apres branchement de la physique 
!    de surface sous apl_arome

!    ------------------------------------------------------------------
!     12 - CALL CHEMICAL SCHEME.
!     --------------------------------------------------------------------
IF (LUSECHEM) THEN
! ANNEE
IYEAR = NINDAT / 10000
! MOIS
IMONTH = (NINDAT - 10000*IYEAR ) / 100
! JOUR DU MOIS
IDAY = NINDAT - 10000*IYEAR - 100*IMONTH

DO JLON = KIDIA,KFDIA
  ZLAT(JLON,1) = 180. * ASIN(PGEMU(JLON)) / (2.*ASIN(1.))
  ZLON(JLON,1) = 180. * PGELAM(JLON) / (2.*ASIN(1.))
  ZZENITH(JLON,1) = ACOS( PMU0(JLON) )
   ZZS(JLON,1)=POROG(JLON)/RG
   ZALB_UV(JLON,1)=ZALBP(JLON,1)
ENDDO

DO JGFL=1,NGFL_EXT
  DO JLEV=2,KLEV+1
    DO JLON= KIDIA,KFDIA
     ZZI_SVS(JLON,1,JLEV, JGFL)=MAX(0.0_JPRB, ZZI_SVS(JLON,1,JLEV, JGFL))
     ZZI_SVSAVE(JLON,1,JLEV, JGFL)=ZZI_SVS(JLON,1,JLEV, JGFL)
    ENDDO
  ENDDO
ENDDO
    IEZDIAG_CHEM=NGFL_EZDIAG-IOFF_MFSHAL+1
    CALL ARO_MNHC(ZZI_SVS(KIDIA:KFDIA,1:1,1:KLEV,1:NGFL_EXT),       &
             & ZZI_RHODREFM(KIDIA:KFDIA,1:1,1:KLEV),                &
             & PDT,ZZI_THM(KIDIA:KFDIA,1:1,1:KLEV),                 &
             & ZZI_PABSM(KIDIA:KFDIA,1:1,1:KLEV),                   &
             & ZZI_RM(KIDIA:KFDIA,1:1,1:KLEV,1:NRR),                &
             & ZLAT(KIDIA:KFDIA,1:1), ZLON(KIDIA:KFDIA,1:1),          &
             & ZALB_UV(KIDIA:KFDIA,1:1), ZZS(KIDIA:KFDIA,1:1),        &
             & ZZENITH(KIDIA:KFDIA,1:1),ZZZ(KIDIA:KFDIA,1:1,1:KLEV),&
             & IYEAR,IMONTH,IDAY, REAL(RHGMT,JPRB)+PDT/2.,            &
             & ILONMNH,KLEV,NGFL_EXT, NRR, KSTEP+1,NULOUT,IEZDIAG_CHEM,&
             & ZZI_PEZDIAG(KIDIA:KFDIA,:,IOFF_MFSHAL:NGFL_EZDIAG)           )
 
    PEZDIAG(KIDIA:KFDIA,:,IOFF_MFSHAL:NGFL_EZDIAG)=&
                       &ZZI_PEZDIAG(KIDIA:KFDIA,:,IOFF_MFSHAL:NGFL_EZDIAG)


!inversion niveau de la tendance des scalaires passifs

  DO JGFL=1,NGFL_EXT
    DO JLEV = 1,KLEV
      DO JLON = KIDIA,KFDIA
        PTENDEXT(JLON,JLEV,JGFL)=PTENDEXT(JLON,JLEV,JGFL)+&
        &(ZZI_SVS(JLON,1,JLEV,JGFL)- &
        & ZZI_SVSAVE(JLON,1,JLEV,JGFL))
      ENDDO
    ENDDO
  ENDDO

ENDIF

!    ------------------------------------------------------------------
!     13 - STOCHASTIC PHYSICS : PERTURB TENDENCIES
!     -----------------------------------------------------------------

IF(LSPSDT) THEN
  DO JLEV=1,KLEV
    DO JLON=KIDIA,KFDIA
      ZMULNOISE(JLON,JLEV)=PGP2DSDT(JLON,1)  ! Use a single 2D pattern for all levels
      ZDUMMY(JLON,JLEV)=0.0_JPRB             ! Dummy nonphys tendency for compatibility with ecmwf stochphy
    ENDDO
  ENDDO

  CALL SPPTEN (KIDIA,KFDIA,KLON,KLEV,PDT,     &  ! In: block indices, physics timestep
       & PTM, PQVM, PCLFS, PAPRSFM, PAPRSM,   &  ! In: (T,Q,cloud) for supersatcheck, Pfull, Phalf
       & ZDUMMY,ZDUMMY,ZDUMMY,ZDUMMY,         &  ! In: dummy nonphys tendencies
       & ZMULNOISE,                           &  ! In: stochphy 3D random multiplicative pattern (less one)
       & PTENDU,PTENDV,PTENDT,PTENDR(:,:,1) )    ! Inout: (u,v,t,qv) tendencies to perturb
ENDIF

IF(LFORCENL.AND.(KSTEP*(TSPHY/RHOUR)>=NFORCESTART).AND.&
              & (KSTEP*(TSPHY/RHOUR)<=NFORCEEND)) THEN
  DO JLEV=1,KLEV
    DO JLON=KIDIA,KFDIA
      PTENDU(JLON,JLEV)=PTENDU(JLON,JLEV)+AMAGSTOPH*PFORCEU(JLON,JLEV)
      PTENDV(JLON,JLEV)=PTENDV(JLON,JLEV)+AMAGSTOPH*PFORCEV(JLON,JLEV)
      PTENDT(JLON,JLEV)=PTENDT(JLON,JLEV)+AMAGSTOPH*PFORCET(JLON,JLEV)
      PTENDR(JLON,JLEV,1)=PTENDR(JLON,JLEV,1)+AMAGSTOPH*PFORCEQ(JLON,JLEV)
    ENDDO
  ENDDO
ENDIF

!    ------------------------------------------------------------------
!     14 - FINAL CALCULATIONS.
!     --------------------------------------------------------------------

!forcage pour declencher la ligne de grain 
IF (LSQUALL) THEN
  IF (LTWOTL) THEN
    ZDT2=2*ZDT
  ELSE
    ZDT2=ZDT
  ENDIF
  IF((KSTEP+1)*ZDT2 < 600.) THEN
    WRITE(NULOUT, *)'refroidissement impose de',NREFROI1,' a ',NREFROI2
    DO JLON=NREFROI1,NREFROI2
      DO JLEV=KLEV,KLEV-20,-1
        PTENDT(JLON,JLEV)=-0.01_JPRB
      ENDDO
    ENDDO
  ENDIF
ENDIF

!ecriture du buffer
IF(LLMSE.OR.LSFORCS) THEN
  DO JLON = KIDIA,KFDIA
    PGPAR(JLON,MINPRR)=ZINPRR(JLON,1)+ZSURFPREP(JLON)/1000._JPRB
    PGPAR(JLON,MINPRS)=ZINPRS(JLON,1)+ZSURFSNOW(JLON)/1000._JPRB
    PGPAR(JLON,MINPRG)=ZINPRG(JLON,1)+ZINPRH(JLON,1)
    PGPAR(JLON,MACPRR)=PGPAR(JLON,MACPRR)+(ZINPRR(JLON,1)+ZSURFPREP(JLON)/1000._JPRB)*PDT
    PGPAR(JLON,MACPRS)=PGPAR(JLON,MACPRS)+(ZINPRS(JLON,1)+ZSURFSNOW(JLON)/1000._JPRB)*PDT
    PGPAR(JLON,MACPRG)=PGPAR(JLON,MACPRG)+(ZINPRG(JLON,1)+ZINPRH(JLON,1))*PDT
    PGPAR(JLON,MVTS)=ZTSURF(JLON)
    PGPAR(JLON,MVEMIS)=ZEMIS(JLON)
    PGPAR(JLON,MVQS)=ZQS(JLON)
  ENDDO
  DO JSW=1,NSW
     DO JLON = KIDIA,KFDIA
        PGPAR(JLON,MALBDIR-1+JSW)=ZALBP(JLON,JSW)
        PGPAR(JLON,MALBSCA-1+JSW)=ZALBD(JLON,JSW)
     ENDDO
  ENDDO
ENDIF

! initialisations for CFU for Rainfalls
DO JLEV = 0,KLEV
  DO JLON = KIDIA,KFDIA
    ! conversion from m/s in mm/s
    PFPLSL(JLON,JLEV)= ZINPRR(JLON,1)*1000._JPRB+ZSURFPREP(JLON)
    PFPLSN(JLON,JLEV)= ZINPRS(JLON,1)*1000._JPRB+ZSURFSNOW(JLON)
    PFPLSG(JLON,JLEV)= ZINPRG(JLON,1)*1000._JPRB
    PFPLSH(JLON,JLEV)= ZINPRH(JLON,1)*1000._JPRB
    ! conversion in correct Unit for BADP (same as ALADIN)
    PSTRTU(JLON,JLEV)= ZSFU(JLON,1)*ZZI_RHODREFM(JLON,1,IKB) 
    PSTRTV(JLON,JLEV)= ZSFV(JLON,1)*ZZI_RHODREFM(JLON,1,IKB) 
  ENDDO
ENDDO
!Hail diagnostic
IF (LXXDIAGH) THEN
  DO JLEV=1,KLEV
    DO JLON=KIDIA,KFDIA
       PDIAGH(JLON)=PDIAGH(JLON)+ZQGM(JLON,JLEV)*PDELPM(JLON,JLEV)*ZINVG
    ENDDO
  ENDDO
ENDIF
!!! modif pour LMSE non activee
IF (LLMSE) THEN
   DO JLEV=1,KSGST+1
      DO JLON = KIDIA,KFDIA
         PFCS(JLON,JLEV)=-ZSFTH(JLON,1)*ZZI_RHODREFM(JLON,1,IKB)*RCPD
      ENDDO
   ENDDO
ENDIF
IF (LSFORCS) THEN
   DO JLEV=1,KSGST+1
      DO JLON = KIDIA,KFDIA
         PFCS(JLON,JLEV)=-ZSFTH(JLON,1)*ZZI_RHODREFM(JLON,1,IKB)*RCPD
         PFCLL(JLON,JLEV)=-ZSFRV(JLON,1)*ZZI_RHODREFM(JLON,1,IKB)*FOLH (ZTSURF(JLON),0._JPRB)
      ENDDO
   ENDDO
ENDIF  

! case  CTURBLEN =/ KEPS (anyway, option KEPS does not work well in MNH)
DEALLOCATE(ZEPSM )
DEALLOCATE(ZEPSS )

!  deallocations of variables used in more than one parameterization
DEALLOCATE(ZSFU  )         ! surface schemes + turbulence
DEALLOCATE(ZSFV  )
DEALLOCATE(ZSFTH )
DEALLOCATE(ZSFRV )

DEALLOCATE(ZSFSV )
DEALLOCATE(ZSFCO2)
DEALLOCATE(ZCFAQ)
DEALLOCATE(ZCFBQ)
DEALLOCATE(ZCFATH)
DEALLOCATE(ZCFBTH)
DEALLOCATE(ZCFAU)
DEALLOCATE(ZCFBU)
DEALLOCATE(ZCFBV)

DO JSG  = 1, KSGST+1
  DO JLEV = 0, KLEV
    DO JLON = KIDIA, KFDIA
      PFRTH(JLON,JLEV,JSG)=PFRTH(JLON,JLEV,JSG)+ZBUDTH(JLON)
    ENDDO
  ENDDO
ENDDO

! daand: radflex
IF (LINTFLEX) THEN
  ! account for radiation separately
  LLRAD=.NOT.LRADFLEX
    
  CALL APL_AROME2INTFLEX(KLON,KIDIA,KFDIA,KLEV, PDT, &
   & PRDELPM, &
   & PUM, PVM, PTM, &
   & PGPAR(1,MVTS), PCPM, &
   & ZFPR, & ! precipitation fluxes
   & LLRAD, PFRTH, PFRSO, & ! radiative fluxes
   & PTENDU, PTENDV, PTENDT, & ! momentum and temperature tendencies
   & PTENDR, PTENDTKE, PTENDEXT, & ! total gfl tendencies
   & YDPROCSET)
ENDIF

!     --------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('APL_AROME',1,ZHOOK_HANDLE)
END SUBROUTINE APL_AROME
