program test
!
  use com_dfs, only : com_dfs__ini
  use prm_phconst, only : ER, PI, PI2, ER, OMG, GRAV
  use fft_y, only : fft_y__ini, fft_y__g2w, fft_y__g2w_uv, fft_y__w2g, fft_y__w2g_dy, fft_y__w2g_uv
  use fft_y, only : fft_y__g2w_cheonglike, fft_y__w2g_cheonglike
  use fft_y, only : fft_y__g2w_orszag, fft_y__w2g_orszag
  use fft_y, only : grid2sin, sin2grid, grid2cos, cos2grid
  use monit, only : monit__ini, monit__output
  use grads, only : grads__outxy
!
  implicit none
!
!  integer,parameter :: JCN_DFS = 0 !! Old method and Cheong's basis functions
!  integer,parameter :: JCN_DFS = 1 !! New method to calculate expantion coefficients
  integer,parameter :: JCN_DFS = 2 !! New method to calculate expantion coefficients and New basis functions

  integer,parameter :: JCN_GRID = 0   !! colat=PI*(j+0.5)/JMAX0, j=0,...,JMAX0-1
!  integer,parameter :: JCN_GRID = 1   !! colat=PI*j/JMAX0, j=0,...,JMAX0   (JMAX=JMAX0+1)
!  integer,parameter :: JCN_GRID = -1  !! colat=PI*j/JMAX0, j=1,...,JMAX0-1 (JMAX=JMAX0-1)
!

!  integer,parameter :: IMAX = 16
!  integer,parameter :: JMAX = 8 + JCN_GRID
!  integer,parameter :: NMAX = 7
!
  integer,parameter :: IMAX = 128            !! About 300km resolution
  integer,parameter :: JMAX = 64+JCN_GRID
!  integer,parameter :: NMAX = 63             !! Linear grid
  integer,parameter :: NMAX = 42            !! Quadric grid
!
!  integer,parameter :: IMAX = 160            !! 250km resolution
!  integer,parameter :: JMAX = 80+JCN_GRID
!  integer,parameter :: NMAX = 79             !! Linear grid
!  integer,parameter :: NMAX = 53             !! Quadric grid
!
!  integer,parameter :: IMAX = 320            !! 120km resolution
!  integer,parameter :: JMAX = 160+JCN_GRID
!  integer,parameter :: NMAX = 159            !! Linear grid
!  integer,parameter :: NMAX = 106            !! Quadric grid
!
!  integer,parameter :: IMAX = 640            !! 60km resolution
!  integer,parameter :: JMAX = 320+JCN_GRID
!  integer,parameter :: NMAX = 319            !! Linear grid
!  integer,parameter :: NMAX = 213            !! Quadric grid
!
!  integer,parameter :: IMAX = 1920           !! 20km resolution
!  integer,parameter :: JMAX = 960+JCN_GRID   !! J is from North to South
!  integer,parameter :: NMAX = 959            !! Linear grid
!  integer,parameter :: NMAX = 639            !! Quadric grid
!
!  integer,parameter :: IMAX = 3840           !! 10km resolution
!  integer,parameter :: JMAX = 1920+JCN_GRID  !! J is from North to South
!  integer,parameter :: NMAX = 1919           !! Linear grid
!  integer,parameter :: NMAX = 1279           !! Quadric grid
!  integer,parameter :: NMAX = 959            !! Cubic grid
!
!  integer,parameter :: IMAX = 7680           !! 5km resolution
!  integer,parameter :: JMAX = 3840+JCN_GRID  !! J is from North to South
!  integer,parameter :: NMAX = 3839           !! Linear grid
!  integer,parameter :: NMAX = 2559           !! Quadric grid
!  integer,parameter :: NMAX = 1919           !! Cubic grid
!
!  integer,parameter :: IMAX = 15360          !! 2.6km resolution
!  integer,parameter :: JMAX = 7680+JCN_GRID  !! J is from North to South
!  integer,parameter :: NMAX = 7679           !! Linear grid
!  integer,parameter :: NMAX = 5119           !! Quadric grid
!  integer,parameter :: NMAX = 3839           !! Cubic grid
!
!  integer,parameter :: IMAX = 20480          !! 2.0km resolution
!  integer,parameter :: JMAX = 10240+JCN_GRID !! J is from North to South
!  integer,parameter :: NMAX = 10239          !! Linear grid
!  integer,parameter :: NMAX = 6826           !! Quadric grid
!  integer,parameter :: NMAX = 5119           !! Cubic grid
!
!  integer,parameter :: IMAX = 30720          !! 1.3km resolution
!  integer,parameter :: JMAX = 15360+JCN_GRID !! J is from North to South
!  integer,parameter :: NMAX = 15359          !! Linear grid   
!  integer,parameter :: NMAX = 10239          !! Quadric grid
!  integer,parameter :: NMAX = 7679           !! Cubic grid


!  integer,parameter :: imax = 16
!  integer,parameter :: jmax = 8 + jcn_grid
!  integer,parameter :: nmax = 7
!
!  integer,parameter :: imax = 32
!  integer,parameter :: jmax = 16 + jcn_grid
!
!  integer,parameter :: imax = 64
!  integer,parameter :: jmax = 32 + jcn_grid
!
!  integer,parameter :: imax = 128
!  integer,parameter :: jmax = 64 + jcn_grid
!  integer,parameter :: nmax = 42
!
!  integer,parameter :: imax = 256
!  integer,parameter :: jmax = 128 + jcn_grid
!
!  integer,parameter :: imax = 512
!  integer,parameter :: jmax = 256 + jcn_grid
!
!  integer,parameter :: imax = 1024
!  integer,parameter :: jmax = 512 + jcn_grid
!
!  integer,parameter :: imax = 2048
!  integer,parameter :: jmax = 1024 + jcn_grid
!
!  integer,parameter :: imax = 4096
!  integer,parameter :: jmax = 2048 + jcn_grid
!
!  integer,parameter :: imax = 8192
!  integer,parameter :: jmax = 4096 + jcn_grid
!
  integer,parameter :: MMAX = NMAX
  integer,parameter :: NNUM = NMAX + 1
!
  real(8),parameter :: dlon = pi2/imax
  real(8),parameter :: dlat = pi/(jmax-jcn_grid)
  
  real(8) :: alon(imax)
  real(8) :: sinlon(imax)
  real(8) :: coslon(imax)
  real(8) :: alat(jmax)
  real(8) :: ylat(jmax)
  real(8) :: coslat(jmax)
  real(8) :: coslat_inv(jmax)
  real(8) :: sinlat(jmax)
  
  real(8) :: weight(jmax)
!
! ==================================================================
!
  call initialize
!
  call main
!
!
!******************************************************************
contains
!******************************************************************


subroutine initialize
!
  integer :: i,j
  real(8) :: work(JMAX)
!
  call com_dfs__ini( jcn_dfs, jcn_grid, imax, jmax, mmax, nmax )
  call fft_y__ini( imax, jmax, mmax, alat, weight ) !IN[3],OUT[2]
  
  coslat(:) = cos(alat(:))
  sinlat(:) = sin(alat(:))
  coslat_inv(:) = 1.0d0/coslat(:)
  ylat(:) = alat(:)*180.0d0/PI
!
  do i=1,imax
    alon(i) = dlon*(i-1)    !## 0 <= alon < 2*pi
    sinlon(i) = sin(alon(i))
    coslon(i) = cos(alon(i))
  end do
!
end subroutine initialize


!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&



subroutine main
!
  complex(8) :: qdata(nnum,0:mmax)
  real(8) :: data(imax, jmax)
  real(8) :: data_m(0:mmax, jmax)
  integer :: m,i,j
!
! =====================================================================
!
  
  
  data=0.0d0
  data(:,1:jmax/3)=1.0d0
  data_m=0.0d0
  data_m(:,1:jmax/3)=1.0d0
  call grads__outxy( "new", 1, MMAX+1, JMAX, ylat, data_m ) !IN

  call fft_y__g2w &
   &( data,       &!IN
   &  qdata   )    !INOUT

  call fft_y__w2g &
   &( qdata,      &!IN
   &  data   )     !OUT

  do j=1,jmax
    do m=0,mmax
      i=m*2+1
      data_m(m,j) = data(i,j)
    end do
  end do
  call grads__outxy( "new", 2, MMAX+1, JMAX, ylat, data_m ) !IN

! ---------------------------------------------------------------------
  
  data=0.0d0
  data(:,1:jmax/3)=1.0d0
  data_m=0.0d0
  data_m(:,1:jmax/3)=1.0d0
  call grads__outxy( "cheong", 1, MMAX+1, JMAX, ylat, data_m ) !IN

  call fft_y__g2w_cheonglike &
   &( data,       &!IN
   &  qdata   )    !INOUT

  call fft_y__w2g_cheonglike &
   &( qdata,      &!IN
   &  data   )     !OUT

  do j=1,jmax
    do m=0,mmax
      i=m*2+1
      data_m(m,j) = data(i,j)
    end do
  end do
  call grads__outxy( "cheong", 2, MMAX+1, jmax, ylat, data_m ) !IN

! ---------------------------------------------------------------------
  
  data=0.0d0
  data(:,1:jmax/3)=1.0d0
  data_m=0.0d0
  data_m(:,1:jmax/3)=1.0d0
  call grads__outxy( "orszag", 1, MMAX+1, JMAX, ylat, data_m ) !IN

  call fft_y__g2w_orszag &
   &( data,       &!IN
   &  qdata   )    !INOUT

  call fft_y__w2g_orszag &
   &( qdata,      &!IN
   &  data   )     !OUT

  do j=1,jmax
    do m=0,mmax
      i=m*2+1
      data_m(m,j) = data(i,j)
    end do
  end do
  call grads__outxy( "orszag", 2, MMAX+1, jmax, ylat, data_m ) !IN
      
end subroutine main


!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


end program test
