#\bin\bash
#
module load cdo/1.7.1
#
# Script to extract MésoNH output
#
# ###########################################
# User input section
# ###########################################
#
# The number of nests
#
nnest=5
#
# ###########################################
# Extraction of values
# ###########################################
#
# Creation of directories
#
pdia=./DIAG_LVL/
#
rm -Rf $pdia
mkdir $pdia
#
# Variables to select
#
str_sel_3D="TEMPMME,QSPECME,PABSMME,RHME,UMME,VMME,WIFFME,WIDDME"
#
# Loop over nests
#
nest=3
while [ $nest -lt $nnest ]
do
  #
  CBEG=MNHOU.$((nest+1)).SEGM0.
  #
  for TPS in 001 002 003 004 005 006 007 008 009 010 011 012 013 014 015 016 017 018 019 020 021 022 023 024
  do
    #
    for LVL in 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25
    do
      #
      # Select vertical level
      #
      fileinp=${CBEG}${TPS}.nc4
      fileout=${CBEG}${TPS}"_LVL_"${LVL}.nc4
      cdo -s sellevel,${LVL} ${fileinp} ${fileout}
      #
      # Select 3D variables
      #
      if [ $LVL -ge 1 ]; then
        #
        fileinp=${CBEG}${TPS}"_LVL_"${LVL}".nc4"
        fileout=${CBEG}${TPS}"_LVL_"${LVL}"_SEL3D.nc4"
        #
        cdo -s selname,${str_sel_3D} ${fileinp} ${fileout}
        fileinp=${CBEG}${TPS}"_LVL_"${LVL}"_SEL3D.nc4"
        fileout=${CBEG}${TPS}"_LVL_"${LVL}"_SPLIT_"
        cdo -s splitname ${fileinp} ${fileout}
        mv *_SPLIT_* $pdia
        rm *SEL3D*
        #
      fi
      #
    done
    #
  done 
  #
  nest=$((nest + 1))
  #
done
#
