#!/bin/sh
#SBATCH -J MesoNH
#SBATCH -N 12           # nodes number (=NBP)
#SBATCH -n 480          # CPUs number (on all nodes) (=NBP*TPN) = nbre de taches MPI
#SBATCH -o MesoNH.eo%j  #
#SBATCH -e MesoNH.eo%j  #
#SBATCH -t 12:00:00     # time limit
#SBATCH -p normal64
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
# Arret du job des la premiere erreur
#
export OPTLEVEL="O3"
#
# profile to be executed :
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}
#
export MPIRUN="mpirun -np 480 idrmem"  # the number must be = to the number of processors set line 5
#
set -x
#
./run_clean.sh
#
########################################
#recuperation des fichiers necessaires #
########################################
# for EXSEG1.nam :
ln -sf ../002_COUPLING/HK_PREP_8km_201805*.* .
ln -sf ../001_PGD_NEST/HK_PGD_8km.neste1.* .
# for EXSEG2.nam :
ln -sf ../004_PREAL_MOD1_MOD2/HK_PREP_2km_201805* .
ln -sf ../001_PGD_NEST/HK_PGD_2km.neste1.* .
# for EXSEG3.nam :
ln -sf ../006_PREAL_MOD2_MOD3/HK_PREP_1km_201805* .
ln -sf ../001_PGD_NEST/HK_PGD_1km.neste1.* .
# for EXSEG4.nam :
ln -sf ../008_PREAL_MOD3_MOD4/HK_PREP_250m_201805* .
ln -sf ../001_PGD_NEST/HK_PGD_250m.neste1.* .
# for EXSEG5.nam :
ln -sf ../010_PREAL_MOD4_MOD5/HK_PREP_125m_201805* .
ln -sf ../001_PGD_NEST/HK_PGD_125m.neste1.* .
#
########################################
# run MESONH DAY 1 - hours 00_24
########################################
#
cp EXSEG1.nam.template EXSEG1.nam
cp EXSEG2.nam.template EXSEG2.nam
cp EXSEG3.nam.template EXSEG3.nam
cp EXSEG4.nam.template EXSEG4.nam
cp EXSEG5.nam.template EXSEG5.nam
#
time ${MPIRUN} MESONH_${OPTLEVEL}
#
cd ../012_RUN5MOD_RESTART/
#
./IniSim_Simple.py
#
# statistiques du job
ja
#