#!/bin/sh
#SBATCH --export=NONE
#SBATCH -J spa45_HK
#SBATCH -N 1               # nodes number (=NBP)
#SBATCH -n 1               # CPUs number (on all nodes) (=NBP*TPN)
#SBATCH -o spa45_HK.eo%j   #
#SBATCH -e spa45_HK.eo%j   #
#SBATCH -t 00:30:00    # time limit
#SBATCH -p pptparty
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
#
./run_clean.sh
#
export OPTLEVEL="O3"
#
# profile to be executed :
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}

export MPIRUN="Mpirun -np 1 idrmem" # the number must be = to the number of processors set line 5

set -x

# recuperation des fichiers necessaires
ln -sf ../001_PGD_NEST/HK_PGD_250m.neste1.* .
ln -sf ../001_PGD_NEST/HK_PGD_125m.neste1.* .
ln -sf ../008_PREAL_MOD3_MOD4/HK_PREP_250m_20180515_12* .

ls -l
# run du programme
cp SPAWN1.nam_mod4_mod5 SPAWN1.nam
time ${MPIRUN} SPAWNING_${OPTLEVEL}

#wait to allow for completion of writing tasks
sleep 15

mv OUTPUT_LISTING0  OUTPUT_LISTING0_spa45_HK 
mv OUTPUT_LISTING1  OUTPUT_LISTING1_spa45_HK 
mv OUTPUT_LISTING2  OUTPUT_LISTING2_spa45_HK 

# Submit next job if current job finished correctly :
lc_listing=0
lc_listing="$(grep -i -s "COMPUTING TIME ANALYSIS in SPAWN_MODEL2" ./OUTPUT_LISTING2_spa45_HK | wc -l)"

if [ $lc_listing -gt 0 ];then
  # menage
  rm -f SPAWN1.nam
  rm -f file_for_xtransfer pipe_name 
  rm *neste1* 
  rm HK_PREP_250m_20180515_12.nc4
  rm HK_PREP_250m_20180515_12.des
  # statistiques du job
  ja
  # lancement du job suivant
  cd ../010_PREAL_MOD4_MOD5/
  sbatch run_preal45.sh
  #
fi

