#!/bin/sh
#SBATCH --export=NONE
#SBATCH -J spa12_HK
#SBATCH -N 1               # nodes number (=NBP)
#SBATCH -n 1               # CPUs number (on all nodes) (=NBP*TPN)
#SBATCH -o spa12_HK.eo%j   #
#SBATCH -e spa12_HK.eo%j   #
#SBATCH -t 00:30:00    # time limit
#SBATCH -p pptparty
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
#
./run_clean.sh
#
export OPTLEVEL="O3"
#
# profile to be executed :
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}

export MPIRUN="Mpirun -np 1 idrmem" # the number must be = to the number of processors set line 5

set -x

# recuperation des fichiers necessaires
ln -sf ../001_PGD_NEST/HK_PGD_8km.neste1.* .
ln -sf ../001_PGD_NEST/HK_PGD_2km.neste1.* .
ln -sf ../002_COUPLING/HK_PREP_8km_20180515_12.* .

ls -l
# run du programme
cp SPAWN1.nam_mod1_mod2 SPAWN1.nam
time ${MPIRUN} SPAWNING_${OPTLEVEL}

#wait to allow for completion of all writing tasks
sleep 15

mv OUTPUT_LISTING0  OUTPUT_LISTING0_spa12_HK 
mv OUTPUT_LISTING1  OUTPUT_LISTING1_spa12_HK 
mv OUTPUT_LISTING2  OUTPUT_LISTING2_spa12_HK # seul listing intéressant

# Submit next job if current job finished correctly :
lc_listing=0
lc_listing="$(grep -i -s "COMPUTING TIME ANALYSIS in SPAWN_MODEL2" ./OUTPUT_LISTING2_spa12_HK | wc -l)"

if [ $lc_listing -gt 0 ];then

        # menage
        rm -f SPAWN1.nam
        rm -f file_for_xtransfer pipe_name 
        rm *neste1*
        rm HK_PREP_8km_20180515_12.nc4
        rm HK_PREP_8km_20180515_12.des

        # statistiques du job
        ja
    
	# lancement du job suivant 
        cd ../004_PREAL_MOD1_MOD2/
        sbatch run_preal12.sh

fi
