#!/bin/sh
#SBATCH --export=NONE
#SBATCH -J cpl_HK        # job name that will appear in squeue
#SBATCH -N 1             # nodes number (= NBP du tosupcrc)
#SBATCH -n 1             # CPUs number (nbre_noeuds*nbre_processeurs/noeud = NBP*TPN)
#SBATCH -o cpl_HK.eo%j   #
#SBATCH -e cpl_HK.eo%j   #
#SBATCH -t 06:00:00      # time limit
#SBATCH -p normal64
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
#
./run_clean.sh
#
export OPTLEVEL="O3"
#
# Arret du job des la premiere erreur
# profile to be executed :
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}
#
export MPIRUN="Mpirun -np 1 idrmem" # the number must be = to the number of processors set line 5
#
set -x
#
rm -f HK_PREP* OUTPUT_LISTING*
#
########################################
#recuperation des fichiers necessaires #
########################################
####### PGD père nesté:
ln -sf ../001_PGD_NEST/HK_PGD_8km.neste1.des ./HK_PGD_8km.neste1.des
ln -sf ../001_PGD_NEST/HK_PGD_8km.neste1.nc4 ./HK_PGD_8km.neste1.nc4
####### champs ecmwf:
ln -sf ../../../EXTRACT_ECMWF/ecmwf.OD.2018* .
#
ls -lrt
#
export NTIME="12 18"
export NDAY="15"
#
for i in ${NTIME}
  do
  for day in ${NDAY}
    do
      #
      cp PRE_REAL1.nam.template PRE_REAL1.nam
      sed -i -- 's/%%%mont%%%/05/g' PRE_REAL1.nam
      sed -i -- 's/%%%lcoupling%%%/FALSE/g' PRE_REAL1.nam
      sed -i -- 's/%%%dayy%%%/'${day}'/g' PRE_REAL1.nam
      sed -i -- 's/%%%time%%%/'${i}'/g' PRE_REAL1.nam
      #
      time ${MPIRUN} PREP_REAL_CASE_${OPTLEVEL}
      mv OUTPUT_LISTING0  OUTPUT_LISTING_cpl_HK_201805${day}.${i}
      #
  done
done
#
cd ../003_SPA_MOD1_MOD2/
sbatch run_spawn12.sh
cd ../002_COUPLING
#
export NDAY="16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31"
export NTIME="00 06 12 18"
#
for i in ${NTIME}
  do
  for day in ${NDAY}
    do
      #
      cp PRE_REAL1.nam.template PRE_REAL1.nam
      sed -i -- 's/%%%mont%%%/05/g' PRE_REAL1.nam
      sed -i -- 's/%%%lcoupling%%%/TRUE/g' PRE_REAL1.nam
      sed -i -- 's/%%%dayy%%%/'${day}'/g' PRE_REAL1.nam
      sed -i -- 's/%%%time%%%/'${i}'/g' PRE_REAL1.nam
      #
      time ${MPIRUN} PREP_REAL_CASE_${OPTLEVEL}
      mv OUTPUT_LISTING0  OUTPUT_LISTING_cpl_HK_201805${day}.${i}
      #
  done
done
#
export NDAY="01 02"
#
for day in ${NDAY}
  do
  for i in ${NTIME}
    do
      #
      cp PRE_REAL1.nam.template PRE_REAL1.nam
      sed -i -- 's/%%%mont%%%/06/g' PRE_REAL1.nam
      sed -i -- 's/%%%lcoupling%%%/TRUE/g' PRE_REAL1.nam
      sed -i -- 's/%%%dayy%%%/'${day}'/g' PRE_REAL1.nam
      sed -i -- 's/%%%time%%%/'${i}'/g' PRE_REAL1.nam
      #
      time ${MPIRUN} PREP_REAL_CASE_${OPTLEVEL}
      mv OUTPUT_LISTING0  OUTPUT_LISTING_cpl_HK_201806${day}.${i}
      #
  done
done
#
# ****************
#
ls -lrt
#
rm -f PRE_REAL1.nam HK_PGD_8km.neste1.* 
rm -f file_for_xtransfer pipe_name
#
#statistiques du job
ja

