#!/bin/sh
#SBATCH --export=NONE
#SBATCH -J pgd_HK3        # jobname that will appear in squeue
#SBATCH -N 1              # nodes number (nbre_noeuds = NBP dans tosupcrc)
#SBATCH -n 1              # CPUs number (nbre_noeuds*nbre_processeurs/noeud = NBP*TPN dans tosupcrc) / TPN = 4
#SBATCH -o pgd_HK3.eo%j   #
#SBATCH -e pgd_HK3.eo%j   #
#SBATCH -t 00:30:00       # time limit (ELAPSE)
#SBATCH -p pptparty
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
#
export OPTLEVEL="DEBUG"
#
# profile to be executed :
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}
#
export MPIRUN="Mpirun -np 1 idrmem"  # the number must be = to the number of processors set line 5

set -x

###### run PGD 3 : HONK KONG REGION @ 200 m resolution

# lien sur les fichiers de surface necessaires
ln -sf /home/cnrm_other/ge/mrmh/payart/PREP_PGD_FILES_WWW/ECOCLIMAP_v2.0.* .
ln -sf /home/cnrm_other/ge/mrmh/payart/PREP_PGD_FILES_WWW/srtm_ne_250.* .
ln -sf /home/cnrm_other/ge/mrmh/payart/PREP_PGD_FILES_WWW/CLAY_HWSD_MOY.* .
ln -sf /home/cnrm_other/ge/mrmh/payart/PREP_PGD_FILES_WWW/SAND_HWSD_MOY.* .
#
ln -sf ../../../SURF_FILES/may2019_ND3/* .
ln -sf ../../../SURF_FILES/*.csv .
ln -sf ../../../SST_FILES/* .
#
rm -f HK_PGD_1km.???
cp PRE_PGD1.nam_1km PRE_PGD1.nam
time ${MPIRUN} PREP_PGD_${OPTLEVEL}

# Wait to allow for completion of all written tasks
sleep 15

mv OUTPUT_LISTING0  OUTPUT_LISTING0_HK_1km

# Submit next job if current job finished correctly :
lc_listing=0
lc_listing="$(grep -i -s "PREP_PGD ends correctly" ./OUTPUT_LISTING0_HK_1km | wc -l)"

if [ $lc_listing -gt 0 ];then
  #
  touch HK_PGD_1km.des # need to create empty .des file
  # menage du repertoire
  rm -f *.dir *.hdr *.txt *.csv
  rm -f PRE_PGD1.nam file_for_xtransfer pipe_name
  #
  # Copy name of PGD file for extract script
  #
  cp -f HK_PGD_1km.des PGD_Nest_3.des
  cp -f HK_PGD_1km.nc4 PGD_Nest_3.nc4
  #
  # Extract diagnostics
  #
  rm -Rf ./RUNDIR_DIAG
  mkdir ./RUNDIR_DIAG
  cd ./RUNDIR_DIAG
  #
  cp ../../TEMPLATES/Extract_diag_PGD_template.sh_REFER ./Extract_diag_PGD_template.sh
  sed -i -- 's/%%%nnest%%%/3/g' ./Extract_diag_PGD_template.sh
  sed -i -- 's/%%%folderout%%%/DIAG_Nest_3/g' ./Extract_diag_PGD_template.sh
  ./Extract_diag_PGD_template.sh
  #
  cd ..
  #
  mkdir ../PREP_PGD_NEST_3
  mkdir ../PREP_PGD_NEST_3/DIAG/
  cp DIAG_Nest_3/* ../PREP_PGD_NEST_3/DIAG/
  #
  #statistiques du job
  ja
  #lancement du job suivant
  sbatch run_pgd4.sh
  #
fi
