#!/bin/sh
#SBATCH --export=NONE
#SBATCH -J nest_HK        # jobname that will appear in squeue
#SBATCH -N 1              # nodes number (nbre_noeuds = NBP dans tosupcrc)
#SBATCH -n 1              # CPUs number (nbre_noeuds*nbre_processeurs/noeud = NBP*TPN dans tosupcrc) / TPN = 4
#SBATCH -o nest_HK.eo%j   #
#SBATCH -e nest_HK.eo%j   #
#SBATCH -t 01:00:00       # time limit (ELAPSE)
#SBATCH -p pptparty
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
#
export OPTLEVEL="DEBUG"
#
# profile to be executed :
#
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}

export MPIRUN="Mpirun -np 1 idrmem"  # the number must be = to the number of processors set line 5

set -x

#run NESTING

rm -f *.neste1.* OUTPUT_LISTING*nest*

#cp PRE_NEST_PGD1.nam_HK PRE_NEST_PGD1.nam
cp PRE_NEST_PGD1.nam_HK_5mod PRE_NEST_PGD1.nam # config à 4 modèles
time ${MPIRUN} PREP_NEST_PGD_${OPTLEVEL}

# Wait to allow for completion of all written tasks
sleep 15

mv OUTPUT_LISTING0 OUTPUT_LISTING0_nest_HK
mv OUTPUT_LISTING1 OUTPUT_LISTING1_nest_SEC
mv OUTPUT_LISTING2 OUTPUT_LISTING2_nest_PRD
mv OUTPUT_LISTING3 OUTPUT_LISTING3_nest_HKR
mv OUTPUT_LISTING4 OUTPUT_LISTING4_nest_HKZ
mv OUTPUT_LISTING5 OUTPUT_LISTING5_nest_NE5  

# Submit next job if current job finished correctly :
lc_listing=0
lc_listing="$(grep -i -s "PREP_NEST_PGD ends correctly" ./OUTPUT_LISTING0_nest_HK | wc -l)"

if [ $lc_listing -gt 0 ];then
  #
  touch HK_PGD_8km.neste1.des
  touch HK_PGD_2km.neste1.des
  touch HK_PGD_1km.neste1.des
  touch HK_PGD_250m.neste1.des
  touch HK_PGD_125m.neste1.des
  #
  # menage du repertoire
  #
  rm -f PRE_NEST_PGD1.nam file_for_xtransfer pipe_name
  #
  #statistiques du job
  #
  ja
  #
  #lancement du job suivant
  #
  cd ../002_COUPLING/
  sbatch run_cpl.sh
  #
fi