#
# ##########################################################################
#
# Plot vide (Julien)
#
plot0=function(xlim=c(0,1),ylim=c(0,1),xlab="",ylab="",
               axes=FALSE,frame.plot=FALSE,main="",log="") {
  #
  plot(1,type="n",frame.plot=frame.plot,axes=axes,xaxs="i",yaxs="i",
       log=log,xlim=xlim,ylim=ylim,xlab=xlab,ylab=ylab,main=main)
  #
}
#
# ###########################################################################
#
# Colorbar (Julien)
#
mycolorbar=function(cols,levels,horiz=TRUE,srt=0,cex=2,width=1,ltext=1) {
  #
  nl=length(levels)
  xlim=c(0,nl+1)
  ylim=c(0,1)
  #
  if (horiz) {
    xcb=seq(xlim[1],xlim[2],le=nl+2)
    ycb=ylim[2]-c(width,0)
    plot0(xlim=xlim,ylim=ylim)
    for (i in 1:(nl+1)) polygon(xcb[c(i,i+1,i+1,i)],ycb[c(1,1,2,2)],col=cols[i])
    if (ltext>0.5) text(xcb[-c(1,length(xcb))],ycb[1],levels,pos=1,cex=cex,srt=srt)
  }
  #
  if (!horiz) {
    xcb=seq(xlim[1],xlim[2],le=nl+2)
    ycb=ylim[1]+c(0,width)
    plot0(xlim=ylim,ylim=xlim)
    for (i in 1:(nl+1)) polygon(ycb[c(1,1,2,2)],xcb[c(i,i+1,i+1,i)],col=cols[i])
    if (ltext>0.5) text(ycb[2],xcb[-c(1,length(xcb))]-0.5,levels,pos=4,cex=cex,srt=srt)
  }
  #
}
#
############################################################################
#
# Scatterplot with regression line (Julien)
#
myscatts=function(x,y,xlim=NULL,ylim=NULL,xlab,ylab,col="black",regr=T,
                  regr.txt=T,pval=0.1,regr.ci=T,regr.ci.level=0.95,add=F,
                  frame.plot=T,pch=21,bg.def="white",jj,xinc,yinc,lwdsca,
                  lnum=0,nums=NA) {
#
# Check for consistent data
#
lx=length(x)
ly=length(y)
#
if (lx!=ly) stop("Inconsistent length of input vectors")
#
for (ii in 1:lx) {
  if (( is.na(x[ii]))&&(!is.na(y[ii]))) stop("Inconsistent missing data")
  if ((!is.na(x[ii]))&&( is.na(y[ii]))) stop("Inconsistent missing data")
}
#
if ((length(xlim)==0)||(length(ylim)==0)) stop("Axis limits not specified")
#
# Check whether the data are within the axis limits
#
axmax=max(x,na.rm=TRUE)
axmin=min(x,na.rm=TRUE)
#
aymax=max(y,na.rm=TRUE)
aymin=min(y,na.rm=TRUE)
#
if (axmax>xlim[2]) stop("Wrong x-limit")
if (axmin<xlim[1]) stop("Wrong x-limit")
#
if (aymax>ylim[2]) stop("Wrong y-limit")
if (aymin<ylim[1]) stop("Wrong y-limit")
#
# Create axis
#
if (!add) {
  #
  plot0(xlim,ylim,frame.plot=frame.plot)
  #
  abline(h=ylim[1],lty=1)
  abline(v=xlim[1],lty=1)
  #
  axis(1,at=seq(xlim[1],xlim[2],xinc),las=1,lab=seq(xlim[1],xlim[2],xinc),cex.axis=1.0)
  axis(2,at=seq(ylim[1],ylim[2],yinc),las=2,lab=seq(ylim[1],ylim[2],yinc),cex.axis=1.0)
  #
  mtext(xlab,side=1,las=0,line=2.5,cex=1.0,col="black")
  mtext(ylab,side=2,las=0,line=2.5,cex=1.0,col="black")
  #
}
#
# Draw regression line in case of significant correlation
#
if (regr && cor.test(x,y)$p.value<pval) {
  #
  lm=lm(y~x)
  #
  if (regr.ci) {
    xci=data.frame(x=seq(min(x,na.rm=T),max(x,na.rm=T),le=10))
    xci=data.frame(x=seq(xlim[1],xlim[2],le=100))
    lci=predict(lm,xci,level=regr.ci.level,interval="confidence")
    lci=as.data.frame(lci)
    #
    # lines(xci$x,lci$lwr,lty=2,col=col)
    # lines(xci$x,lci$upr,lty=2,col=col)
    # polygon(c(xci$x,rev(xci$x)),c(lci$lwr,rev(lci$upr)),border=NA,col="gray90")
    #
  }
  #
  if (regr.txt) {
    #
    st=format(round(cor(na.omit(x),na.omit(y)),digits=2),nsmall=2)
    rt=paste("r = ",st,sep="")
    #
    text(0.85*xlim[1]+0.15*xlim[2],0.1*ylim[1]+0.9*ylim[2]-0.07*(jj-1)*(ylim[2]-ylim[1]),rt,cex=0.7,col=col)
    #
  }
  #
  abline(lm,lty=2,col=col)
  #
}
#
# Draw scatterplot
#
if (lnum==0)      points(x,y,pch=pch,col=col,lwd=lwdsca,cex=0.6)
else if (lnum==1) {
  if (length(nums)!=length(x)) stop("Inconsistent lengths")
  text(x,y,label=nums,col=col,cex=0.5)
}
else stop("This value of lnum is not implemented")
#
}
#
############################################################################
#
# Boxplot (Julien)
#
mybp=function(x,at=1,col="transparent",range=0.0,quantiles=c(1/4,3/4),
              boxwex=1,pch=1,lty=1,add=F,horiz=F) {
#
x=na.omit(x)
#
if (length(x)<10) stop("Too few entries for boxplot")
#
y=boxplot(x,range=range,plot=F,horizontal=horiz)
qx=quantile(x,quantiles)
#
y$stats[c(2,4),1]=matrix(qx)
noout=which(y$out>=qx[1] & y$out<=qx[2])
#
if (length(noout)>0) {
  y$out  =y$out[-noout]
  y$group=y$group[-noout]
}
#
bxp(y,at=at,boxfill=col,add=add,boxwex=boxwex,pch=pch,frame.plot=F,
    axes=F,xlab="",ylab="",boxlty=0,whisklty=lty,staplelty=1,
    horizontal=horiz,medlwd=0.8)
  #
}
#
# ############################################################################
#
# Barplot (Julien)
#
mybarplot=function(y,at=NULL,y0=0,width=1,pch=NULL,pbg=7,col=c("red","blue"),
          border=NULL,fill=NULL,lty=1,lwd=1,plot.ci=FALSE,ci.u=NULL,ci.l=NULL,
          ci.lty=1,ci.lwd=1,xlim=NULL,yaxis=FALSE,ylab="",ylim=NULL,
          y0line=TRUE,col.levs=NULL,col.vals=y-y0,add=FALSE,frame.plot=FALSE){
#
# Gestion arguments entree
#
if (plot.ci & (length(ci.u)!=length(y) | length(ci.l)!=length(y))) {print("Error specifying CI"); stop()}
if (length(at)==0) at=1:length(y)
if (length(width)==1) width=rep(width,length(y))
if (length(pch)==1) pch=rep(pch,length(y))
#
cls=col
#
if (length(col)==1) cls=rep(col,length(y)); if (length(col)==2) {
  cls=col[1.5-0.5*sign(y-y0)]
  if (col==c("red","blue") && length(col.levs)>0) {
    lcl=length(col.levs); csq=seq(1,0,-1/lcl); myred=rgb(1,csq,csq); myblue=rgb(csq,csq,1)
    cls=c(); for (i in 1:length(y)){
    ic=which(sort(c(abs(col.vals[i]),col.levs))==abs(col.vals[i]))
    cls=c(cls,cbind(myred,myblue)[ic,1.5-0.5*sign(y[i]-y0)])
    }
  }
}
#
# Plot
#
if (is.null(xlim)) xlim=range(at)+c(-1,1)*mean(width)
if (is.null(ylim)) ylim=range(c(y0,y,ci.u,ci.l))
if (!add) plot0(xlim=xlim,ylim=ylim,ylab=ylab,frame.plot=frame.plot)
#
for (i in 1:length(y)){
  #
  xi=at[i]+c(-0.5,0.5,0.5,-0.5)*width[i]; yi=c(y0,y0,y[i],y[i])
  polygon(xi,yi,col=cls[i],border=border,density=fill[i],lty=lty,lwd=lwd)
  #
  if (plot.ci) {
    xi=at[i]+c(-0.25,0.25)*width[i]
    segments(at[i],ci.l[i],at[i],ci.u[i],lty=ci.lty,lwd=ci.lwd)
    segments(xi[1],ci.l[i],xi[2],ci.l[i],lty=ci.lty,lwd=ci.lwd)
    segments(xi[1],ci.u[i],xi[2],ci.u[i],lty=ci.lty,lwd=ci.lwd) 
  }
  #
  if (length(pch)>0) points(at[i],y[i],pch=pch[i],bg=pbg) 
  #
}
#
if (yaxis) axis(2)
if (y0line) lines(xlim,rep(y0,2),lty=1)
#
}
#
# ###########################################################################
#
# 1D-histogram
#
plot1Dhist=function(hist,bound,xname,yname,printlab) {
#
# Creation of names
#
names = array(NA,c(length(bound)-1))
for (nn in 2:length(bound)) names[nn-1]=paste(bound[nn-1],"-",bound[nn],sep="") 
#
pdf(printlab)
par(mar=c(7,5,1,1))
#
barplot(hist,width=1,space=0.1,names.arg=names,legend.text = NULL,
        beside=FALSE,horiz=FALSE,density=NULL,angle=45,col="blue",border="black",
        main=NULL,sub=NULL,xlab=NULL,las=2,xlim=c(0,length(bound)),ylim=c(0,1.5*max(hist)),
        xpd=FALSE,axes=TRUE,axisnames=TRUE,cex.axis=1.0,axis.lty=0,offset=0,add=FALSE,args.legend=NULL)
#
mtext(xname,side=1,line=5,cex=1.3,col="black")
mtext(yname,side=2,line=3,cex=1.3,col="black")
garbage <- dev.off()
}
#
############################################################################
#
# 2D-histogram (based on hist2D of Julien)
#
plot2Dhist=function(histo,colors2D,levels2D,yposmark,xposmark,xbks,ybks,xname,yname,
                    printlab,isprint,axsize,lbsize,lwd,filesav,lsav,
                    lmark,incxaxis,incyaxis,mainplot) {
#
A=dim(histo)
#
if (isprint) {
  pdf(printlab)
  par(mar=c(5,5,2,2))
}
#
plot.new()
plot.window(xlim=c(1,length(xbks)),ylim=c(1,length(ybks)),xaxs="i",yaxs="i")
#
for (j in 1:(length(ybks)-1)) {
  for (i in 1:(length(xbks)-1)) {
    xij=c(i,i+1,i+1,i)
    yij=c(j,j,j+1,j+1)
    cij=colors2D[which(sort(c(levels2D,histo[j,i]))==histo[j,i])]
    cij=cij[1]
    polygon(xij,yij,col=cij,border=NA) 
  }
}
#
abline(h=1:length(ybks),lty=2,lwd=lwd)
abline(v=1:length(xbks),lty=2,lwd=lwd)
#
if (lmark) segments(xposmark,yposmark,xposmark+1,yposmark+1,col="white")
if (lmark) segments(xposmark,yposmark+1,xposmark+1,yposmark,col="white")
#
axis(1,at=((1:(length(xbks)-1))+incxaxis),lab=xname,pos=1,lwd=1,las=2,cex.axis=axsize)
axis(2,at=((1:(length(ybks)-1))+incyaxis),lab=yname,pos=1,lwd=1,las=1,cex.axis=axsize)
#
title(main=mainplot,col.lab=rgb(0,0.0,0),cex.lab=lbsize)
#
if (isprint) garbage <- dev.off()
#
}
#
############################################################################
#
# Multibarplot (based on Juliens mymultibarplot)
#
mymultibarplot=function(y,at=NULL,width=1,col=rainbow(nrow(y)),
   border=NULL,lty=1,lwd=1,yaxis=FALSE,ylab="",
   ylim=NULL,y0line=TRUE,add=FALSE) {
#
if (length(at)==0) at=1:ncol(y)
if (length(width)==1) width=rep(width,ncol(y))
if (length(col)==1) cls=rep(col,ncol(y))
#
xlim=range(at)+c(-1,1)*mean(width)
if (length(ylim)==0) ylim=max(apply(abs(y),2,sum))*c(-1/2,1/2)
if (!add) plot0(xlim=xlim,ylim=ylim,ylab=ylab)
#
for (i in 1:ncol(y)){
   #
   xi=at[i]+c(-0.5,0.5,0.5,-0.5)*width[i]
   yt=0
   yb=0
   #
   for (j in 1:nrow(y)){
      if (y[j,i]>=0) {yij=yt+c(0,0,y[j,i],y[j,i]); yt=yt+y[j,i]}
      if (y[j,i]<0)  {yij=yb+c(0,0,y[j,i],y[j,i]); yb=yb+y[j,i]}
      polygon(xi,yij,col=col[j],border=border,lty=lty,lwd=lwd) }}
#
if (yaxis) axis(2)
if (y0line) lines(xlim,rep(0,2),lty=1)
#
}
#
# ###########################################################################
#
# Plot time series of daily averages
#
plottsdav=function(data,jday,var,uni,nam,name,legendvec,colors,ltys,mae=NA,rmse=NA,
                   titlename=NA,bias=NA,covar=NA,covarname=NA,covarunit=NA,path) {
#
if (length(which(!is.na(data)))>1) {
#
# Check input
#
DIM=dim(data)
#
if (length(DIM)>3.1) stop("Wrong number of dimensions")
if (DIM[2]!=length(jday)) {print(DIM);print(length(jday));stop("Wrong input")}
if (length(DIM)==3) {
  if (DIM[3]>length(colors)) stop("Not enough colors specified")
  nloop=DIM[3]
} else {
  nloop=1
}
#
# In the case the variable to be plotted represents the 
# internal heat release or the heating/cooling energy demand
# the annual consumption is calculated
# Caution: this is hardcoded to the CAPITOUL setup (March 2004 - March 2005)
#
if ((var=="QIN_KWH")||(var=="HVAC_HT_KWH")||(var=="HVAC_CL_KWH")) {
  #
  # Extract one year
  #
  jdaysel=jday[11:length(jday)]
  if (length(jdaysel)!=365) stop("Error in annual consumption calculation")
  #
  DIM=dim(data)
  datasel=data[1,11:DIM[2],]
  #
  DIM=dim(datasel)
  #
  # Calculate annual demand [kWh/m²a]
  #
  demand=array(NA,DIM[2])
  #
  for (tt in 1:DIM[2]) demand[tt]=mean(datasel[,tt])
  #
  # Save values in .txt file
  # 
  filesav=paste("/home/schoetterr/Bureau/SURFEX/ANALYSIS/CONSODIR/",var,"_",name,sep="")
  system(paste("rm -rf ",filesav,sep=""))
  #
  write("                                         ",file=filesav,append=TRUE,sep="")
  write("Building type     Energy demand [kWh/m²a]",file=filesav,append=TRUE,sep="")
  #
  for (tt in 1:DIM[2]) {
    write(paste(format(legendvec[tt],width=15),format(demand[tt],digits=3,width=10)),file=filesav,append=TRUE)
  }
  #
}
#
# File for output
#
printl=paste(path,var,"_",name,".pdf",sep="")
#
# Define xaxis
#
xmin=jday[1]
xmax=jday[length(jday)]
xaxis=jday
xlim=c(xmin,xmax)
#
# Hardcoded for CAPITOUL simulation
#
if ((length(jday)>200)&grepl("CAPITOUL",path)) {
  #
  xaxis=c()
  #
  for (month in 3:12) {
    daysel=myjulday(month,1,2004)
    ind=which(jday==daysel)
    if (length(ind)!=1) stop("Date not found")
    xaxis=c(xaxis,jday[ind])
  }
  #
  for (month in 1:2) {
    daysel=myjulday(month,1,2005)
    ind=which(jday==daysel)
    if (length(ind)!=1) stop("Date not found")
    xaxis=c(xaxis,jday[ind])
  }
  #
}
#
# Hardcoded for Dijon simulation
#
if ((length(jday)>200)&grepl("Dijon",path)) {
  #
  xaxis=c()
  #
  for (month in 6:12) {
    daysel=myjulday(month,1,2014)
    ind=which(jday==daysel)
    if (length(ind)!=1) stop("Date not found")
    xaxis=c(xaxis,jday[ind])
  }
  #
  for (month in 1:12) {
    daysel=myjulday(month,1,2015)
    ind=which(jday==daysel)
    if (length(ind)!=1) stop("Date not found")
    xaxis=c(xaxis,jday[ind])
  }
  #
  for (month in 1:12) {
    daysel=myjulday(month,1,2016)
    ind=which(jday==daysel)
    if (length(ind)!=1) stop("Date not found")
    xaxis=c(xaxis,jday[ind])
  }
  #
}
#
# Define the xaxis labels
#
xaxis_lab=c()
for (ii in 1:length(xaxis)) {
  LST=mycaldat(xaxis[ii])
  curmon=LST$m;curday=LST$d;curyea=LST$y
  xaxis_lab=c(xaxis_lab,paste(curmon,"-",curday,sep=""))
}
#
# Hardcoded labels
#
if ((length(jday)>200)&grepl("CAPITOUL",path)) {
  xaxis_lab=c("M","A","M","J","J","A","S","O","N","D","J","F")
} else if ((length(jday)>200)&grepl("Dijon",path)) {
  xaxis_lab=c("J","J","A","S","O","N","D","J","F","M","A","M","J","J","A","S","O","N","D","J","F","M","A","M","J","J","A","S","O","N","D")
}
#
# Define first yaxis
#
LST=sescale(data)
ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
# Define second yaxis (if applicable)
#
if (!is.na(covar[1])) {
  LST=sescale(covar)
  ymin_2=LST$amin;ymax_2=LST$amax;yinc_2=LST$inc
  yaxis_2=seq(ymin_2,ymax_2,yinc_2)
  ylim_2=c(ymin_2,ymax_2)
}
#
# Hardcoded for anthropogenic heat release in 
# order to obtain comparable plots
#
if (!grepl("Comparison",path)) {
if (grepl("SUM_INVENTORY",var)||grepl("SUM_SIMULATED",var)||
    grepl("EVAL_QA_TRAFFIC",var)||grepl("EVAL_QA_NONTRAFFIC",var)) {
  ymin=0
  ymax=4
  yinc=0.5
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
}
}
#
if (grepl("Comparison",path)) {
  ymin=0
  ymax=3.5
  yinc=0.5
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
}
#
yaxis_lab=yaxis
#
# Create plot
#
pdf(printl,width=8.32,height=7)
par(mar=c(5,6,1.0,5))
par(oma=c(0,0,0,0))
par(xaxs="i",yaxs="i")
#
cexall=1.8
cexleg=1.5
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (nn in 1:nloop) lines(jday,data[1,,nn],lty=ltys[nn],col=colors[nn],lwd=2)
#
# Write evaluation measures (hardcoded to CAPITOUL year)
#
xtext=0.70*xmin+0.30*xmax
ytext=0.05*ymin+0.95*ymax
diff=ymax-ymin
#
ndiff=0
#
if (!is.na(rmse)) {text(xtext,ytext-0.06*ndiff*diff,labels=paste("RMSE =   " ,format(round(rmse,digits=2),nsmall=2)," ",uni,sep=""),cex=cexleg,col="black");ndiff=ndiff+1}
if (!is.na(bias)) {text(xtext,ytext-0.06*ndiff*diff,labels=paste("Bias     = " ,format(round(bias,digits=2),nsmall=2)," ",uni,sep=""),cex=cexleg,col="black");ndiff=ndiff+1}
# if (!is.na(mae))  {text(xtext,ytext-0.06*ndiff*diff,labels=paste("MAE   = ",format(round(mae ,digits=2),nsmall=2)," ",uni,sep=""),cex=cexleg,col="black");ndiff=ndiff+1}
#
# Determine position for start of years
#
# Write date axis
#
axis(1,at=xaxis,lab=xaxis_lab,las=1,cex.axis=cexall)
axis(2,at=yaxis,lab=yaxis_lab,las=2,cex.axis=cexall)
#
mtext(paste(nam," [",uni,"]",sep=""),side=2,line=4.5,cex=cexall,col="black")
#
# Write years
#
if ((length(jday)>200)&grepl("CAPITOUL",path)) {
  #
  xtext_2004=as.Date(paste(2004,"/",03,"/",14,sep=""))
  xtext_2005=as.Date(paste(2005,"/",01,"/",14,sep=""))
  #
  mtext("2004",side=1,at=xtext_2004,line=3.5,las=1,cex=cexall,col="black")
  mtext("2005",side=1,at=xtext_2005,line=3.5,las=1,cex=cexall,col="black")
  #
} else if ((length(jday)>200)&grepl("Dijon",path)) {
  #
  # xtext_2014=as.Date(paste(2014,"/",06,"/",14,sep=""))
  xtext_2015=as.Date(paste(2015,"/",02,"/",14,sep=""))
  xtext_2016=as.Date(paste(2016,"/",02,"/",14,sep=""))
  #
  # mtext("2014",side=1,at=xtext_2014,line=3.5,las=1,cex=cexall,col="black")
  mtext("2015",side=1,at=xtext_2015,line=3.5,las=1,cex=cexall,col="black")
  mtext("2016",side=1,at=xtext_2016,line=3.5,las=1,cex=cexall,col="black")
  #
}
#
# If applicable: add plot with separate y-axis
#
if (!is.na(covar[1])) {
  par(new=TRUE)
  plot0(axes=FALSE,ylim=ylim_2,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
  lines(jday,covar,lty=1,col="blue",lwd=2)
  axis(4,at=yaxis_2,lab=yaxis_2,las=2,cex.axis=cexall)
  mtext(paste(covarname,"[",covarunit,"]",sep=""),side=4,line=3.5,cex=cexall,col="black")
}
#
legend("topright",legendvec,lty=ltys[1:nloop],col=colors[1:nloop],lwd=2,cex=cexleg)
#
# if (!is.na(titlename)) {
#  title("")
#  mtext(titlename,col="black",side=3,line=1.0,adj=0.5,outer=TRUE,cex=cexall)
# }
#
garbage <- dev.off()
#
}
#
}
#
# ###########################################################################
#
# Plot time series of hourly values
#
plottshour=function(data,jhour,var,uni,nam,name,legendvec,colors,ltys,mae=NA,rmse=NA,
                    titlename=NA,bias=NA,covar=NA,covarname=NA,covarunit=NA,path) {
#
if (length(which(!is.na(data)))>1) {
#
# Check input
#
DIM=dim(data)
#
if (length(DIM)>3.1) stop("Wrong number of dimensions")
if (DIM[2]!=length(jhour)) {print(DIM);print(length(jhour));stop("Wrong input")}
if (length(DIM)==3) {
  if (DIM[3]>length(colors)) stop("Not enough colors specified")
  nloop=DIM[3]
} else {
  nloop=1
}
#
# File for output
#
printl=paste(path,var,"_",name,".pdf",sep="")
#
# Define xaxis
#
xmin=jhour[1]
xmax=jhour[length(jhour)]
xaxis=jhour[which(jhour==floor(jhour))]
xlim=c(xmin,xmax)
#
# Define the xaxis labels
#
xaxis_lab=c()
for (ii in 1:length(xaxis)) {
  LST=mycaldat(xaxis[ii])
  curmon=LST$m;curday=LST$d;curyea=LST$y
  xaxis_lab=c(xaxis_lab,paste(curmon,"-",curday,sep=""))
}
#
# Define first yaxis
#
LST=sescale(data)
ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
# Define second yaxis (if applicable)
#
if (!is.na(covar[1])) {
  LST=sescale(covar)
  ymin_2=LST$amin;ymax_2=LST$amax;yinc_2=LST$inc
  yaxis_2=seq(ymin_2,ymax_2,yinc_2)
  ylim_2=c(ymin_2,ymax_2)
}
#
yaxis_lab=yaxis
#
# Create plot
#
pdf(printl,width=8.32,height=7)
par(mar=c(5,6,1.0,5))
par(oma=c(0,0,0,0))
par(xaxs="i",yaxs="i")
#
cexall=1.8
cexleg=1.5
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (nn in 1:nloop) lines(jhour,data[1,,nn],lty=ltys[nn],col=colors[nn],lwd=2)
#
# Write evaluation measures (hardcoded to CAPITOUL year)
#
xtext=0.70*xmin+0.30*xmax
ytext=0.05*ymin+0.95*ymax
diff=ymax-ymin
#
ndiff=0
#
if (!is.na(rmse)) {text(xtext,ytext-0.06*ndiff*diff,labels=paste("RMSE =   " ,format(round(rmse,digits=2),nsmall=2)," ",uni,sep=""),cex=cexleg,col="black");ndiff=ndiff+1}
if (!is.na(bias)) {text(xtext,ytext-0.06*ndiff*diff,labels=paste("Bias     = " ,format(round(bias,digits=2),nsmall=2)," ",uni,sep=""),cex=cexleg,col="black");ndiff=ndiff+1}
# if (!is.na(mae)) {text(xtext,ytext-0.06*ndiff*diff,labels=paste("MAE   = ",format(round(mae ,digits=2),nsmall=2)," ",uni,sep=""),cex=cexleg,col="black");ndiff=ndiff+1}
#
# Determine position for start of years
#
# Write date axis
#
axis(1,at=xaxis,lab=xaxis_lab,las=1,cex.axis=cexall)
axis(2,at=yaxis,lab=yaxis_lab,las=2,cex.axis=cexall)
#
mtext(paste(nam," [",uni,"]",sep=""),side=2,line=4.5,cex=cexall,col="black")
#
# If applicable: add plot with separate y-axis
#
if (!is.na(covar[1])) {
  par(new=TRUE)
  plot0(axes=FALSE,ylim=ylim_2,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
  lines(jhour,covar,lty=1,col="blue",lwd=2)
  axis(4,at=yaxis_2,lab=yaxis_2,las=2,cex.axis=cexall)
  mtext(paste(covarname,"[",covarunit,"]",sep=""),side=4,line=3.5,cex=cexall,col="black")
}
#
legend("top",legendvec,lty=ltys[1:nloop],col=colors[1:nloop],lwd=2,cex=cexleg)
#
# if (!is.na(titlename)) {
#  title("")
#  mtext(titlename,col="black",side=3,line=1.0,adj=0.5,outer=TRUE,cex=cexall)
# }
#
garbage <- dev.off()
#
}
#
}
#
# ###########################################################################
#
# Plot a vertical profile
#
vertprof=function(data,zlev,data_obs,zlev_obs,var,uni,nam,name,legendvec,colors,ltys,path) {
#
if (length(which(!is.na(data)))>1) {
  #
  # Check input
  #
  if (length(data)!=length(zlev)) {
    print(length(data));print(length(zlev));stop("Incoherent input data")
  }
  #
  if (length(data_obs)!=length(zlev_obs)) {
    print(length(data_obs));print(length(zlev_obs));stop("Incoherent input data")
  }
  #
  # File for output
  #
  printl=paste(path,var,"_",name,".pdf",sep="")
  #
  # Define xaxis
  #
  LST=sescale(na.omit(c(data,data_obs)))
  xmin=LST$amin;xmax=LST$amax;xinc=LST$inc
  xaxis=seq(xmin,xmax,xinc)
  xlim=c(xmin,xmax)
  xaxis_lab=xaxis
  #
  # Define yaxis
  #
  ymin=0
  ymax=max(na.omit(c(zlev,zlev_obs)))
  yinc=10
  yaxis=seq(0,10*floor(ymax*10),yinc)
  ylim=c(ymin,ymax)
  yaxis_lab=yaxis
  #
  # Create plot
  #
  pdf(printl,width=8.32,height=7)
  par(mar=c(5,6,1.0,5))
  par(oma=c(0,0,0,0))
  par(xaxs="i",yaxs="i")
  #
  cexall=1.8
  cexleg=1.5
  #
  plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
  #
  if (!is.na(data_obs[1])) lines(data_obs,zlev_obs,lty=ltys[1],col=colors[1],lwd=2)
  lines(data,zlev,lty=ltys[2],col=colors[2],lwd=2)
  #
  axis(1,at=xaxis,lab=xaxis_lab,las=1,cex.axis=cexall)
  axis(2,at=yaxis,lab=yaxis_lab,las=2,cex.axis=cexall)
  #
  mtext(paste(nam," [",uni,"]",sep=""),side=1,line=2.5,cex=cexall,col="black")
  mtext("Height a.g.l. [m]",side=2,line=4.5,cex=cexall,col="black")
  #
  legend("topright",legendvec,lty=ltys,col=colors,lwd=2,cex=cexleg)
  garbage <- dev.off()
  #
}
#
}
#
# ###########################################################################
#
# Evaluation of simulated and observed fluxes
#
seplotevalflx=function(taforcing,htrasim,hindsim,hqinsim,hcoosim,hheasim,hqansim,
                htrasimdaycy,hindsimdaycy,
                hqinsimdaycy,hcoosimdaycy,hheasimdaycy,hqansimdaycy,htrasimcoowd,
                hindsimcoowd,hqinsimcoowd,hcoosimcoowd,hheasimcoowd,hqansimcoowd,
                htrasimheawd,hindsimheawd,hqinsimheawd,hcoosimheawd,hheasimheawd,
                hqansimheawd,dateobs,hantobs,heleobs,htraobs,hgasobs,
                heleobsdcyc,htraobsdcyc,hgasobsdcyc,
                hantobscoolwd,heleobscoolwd,htraobscoolwd,hgasobscoolwd,
                hantobsheatwd,heleobsheatwd,htraobsheatwd,hgasobsheatwd,
                dayofweek,incdateout,case,nameplo) {
#
# Create plot directory
#
namebase=paste(pdata,case,sep="")
system(paste("rm -Rf",namebase))
system(paste("mkdir",namebase))
#
# #########################################################
# Time series of daily averages
# #########################################################
#
# Settings common to all plots
#
# Define xaxis
#
LST=mycaldat(dateobs[1])
mon=LST$m;day=LST$d;yea=LST$y
xmin=as.Date(paste(yea,"/",mon,"/",day,sep=""))
#
LST=mycaldat(dateobs[length(dateobs)])
mon=LST$m;day=LST$d;yea=LST$y
xmax=as.Date(paste(yea,"/",mon,"/",day,sep=""))
#
xlim=c(xmin,xmax)
#
# Define yaxis
#
ymin=-50
ymax=+200
yinc=+50
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
cexall=0.6
pchall=1.0
lwdall=0.6
#
# #################################################
# A: Display the components of the observed fluxes
# #################################################
#
pdf(paste(ppday,case,"/OBSFLX.pdf",sep=""))
par(mar=c(5,5,1,5))
par(xaxs="i",yaxs="i")
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
htotobs=array(NA,c(length(dateobs)))
#
for (ii in 1:length(dateobs)) {
  #
  htotobs[ii]=hgasobs[ii]+heleobs[ii]+htraobs[ii]
  #
  points(x=dateobs[ii],y=hgasobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
  points(x=dateobs[ii],y=heleobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="green")
  points(x=dateobs[ii],y=htraobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
  points(x=dateobs[ii],y=htotobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="magenta")
  points(x=dateobs[ii],y=hantobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
  #
}
#
axis.Date(1,at=seq(xmin,xmax,"month"),format="%b-%d",las=2,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Sensible heat release [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Gas inventory","Electricity inventory","Traffic inventory",
            "Total inventory","Mast observation")
#
legend("top",legendvec,lty=1,col=c("blue","green","red","magenta","black"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# #############################################
# B: Components of the simulated fluxes
# #############################################
#
pdf(paste(ppday,case,"/SIMFLX_",nameplo,".pdf",sep=""))
par(mar=c(5,5,1,5))
par(xaxs="i",yaxs="i")
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (ii in 1:length(dateobs)) {
  points(x=dateobs[ii],y=htrasim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
  points(x=dateobs[ii],y=hindsim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="gray")
  points(x=dateobs[ii],y=hqinsim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="green")
  points(x=dateobs[ii],y=hcoosim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
  points(x=dateobs[ii],y=hheasim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="magenta")
  points(x=dateobs[ii],y=hqansim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
}
#
axis.Date(1,at=seq(xmin,xmax,"month"),format="%b-%d",las=2,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Sensible heat release [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Traffic","Industry","Internal heat release","Cooling","Heating","Total")
#
legend("top",legendvec,lty=1,col=c("red","gray","green","blue","magenta","black"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# #############################################
# C: Simulated versus observed total fluxes
# #############################################
#
# Calculation of evaluation measures
#
# Days during heating season 01/02/2004 to 01/04/2004 
# and 01/11/2004 to 01/04/2005
#
date1beg=myjulday(02,01,2004)
date1end=myjulday(04,01,2004)
date2beg=myjulday(11,01,2004)
date2end=myjulday(04,01,2005)
#
INDHEAT=which( ((dateobs>=date1beg)&(dateobs<=date1end)) |
               ((dateobs>=date2beg)&(dateobs<=date2end)) )
#
# Days during the cooling season 01/06/2004 to 01/09/2005 
#
date1beg=myjulday(06,01,2004)
date1end=myjulday(09,01,2004)
#
INDCOOL=which((dateobs>=date1beg)&(dateobs<=date1end))
#
# Split dataset
# -ALL: All data
# -HEA: Days during the heating season
# -COO: Days during the cooling season
#
BIAS=array(NA,c(2,3))
MAER=array(NA,c(2,3))
RMSE=array(NA,c(2,3))
#
hqansimhea=hqansim[INDHEAT]
htotobshea=htotobs[INDHEAT]
hantobshea=hantobs[INDHEAT]
#
hqansimcoo=hqansim[INDCOOL]
htotobscoo=htotobs[INDCOOL]
hantobscoo=hantobs[INDCOOL]
#
# Error (sim-obs)
#
errorinvall=hqansim-htotobs
errormasall=hqansim-hantobs
#
errorinvcoo=hqansimcoo-htotobscoo
errormascoo=hqansimcoo-hantobscoo
#
errorinvhea=hqansimhea-htotobshea
errormashea=hqansimhea-hantobshea
#
# BIAS (mean error)
#
BIAS[1,1]=mean(errorinvall,na.rm=TRUE)
BIAS[1,2]=mean(errorinvcoo,na.rm=TRUE)
BIAS[1,3]=mean(errorinvhea,na.rm=TRUE)
BIAS[2,1]=mean(errormasall,na.rm=TRUE)
BIAS[2,2]=mean(errormascoo,na.rm=TRUE)
BIAS[2,3]=mean(errormashea,na.rm=TRUE)
#
# MAER (mean absolute error)
#
MAER[1,1]=mean(abs(errorinvall),na.rm=TRUE)
MAER[1,2]=mean(abs(errorinvcoo),na.rm=TRUE)
MAER[1,3]=mean(abs(errorinvhea),na.rm=TRUE)
MAER[2,1]=mean(abs(errormasall),na.rm=TRUE)
MAER[2,2]=mean(abs(errormascoo),na.rm=TRUE)
MAER[2,3]=mean(abs(errormashea),na.rm=TRUE)
#
# RMSE (root mean square error)
#
RMSE[1,1]=sqrt(mean(errorinvall^2,na.rm=TRUE))
RMSE[1,2]=sqrt(mean(errorinvcoo^2,na.rm=TRUE))
RMSE[1,3]=sqrt(mean(errorinvhea^2,na.rm=TRUE))
RMSE[2,1]=sqrt(mean(errormasall^2,na.rm=TRUE))
RMSE[2,2]=sqrt(mean(errormascoo^2,na.rm=TRUE))
RMSE[2,3]=sqrt(mean(errormashea^2,na.rm=TRUE))
#
# Create an output file with evaluation results
#
LST=list(BIAS=BIAS,MAER=MAER,RMSE=RMSE)
fout=paste(pdata,case,"/EVAL_",nameplo,sep="")
save(LST,file=fout)
#
# Create plot
#
pdf(paste(ppday,case,"/EVALFLX_",nameplo,".pdf",sep=""))
par(mar=c(5,5,1,5))
par(xaxs="i",yaxs="i")
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (ii in 1:length(dateobs)) {
  points(x=dateobs[ii],y=htotobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
  points(x=dateobs[ii],y=hantobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
  points(x=dateobs[ii],y=hqansim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
}
#
axis.Date(1,at=seq(xmin,xmax,"month"),format="%b-%d",las=2,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Anthropogenic heat flux [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Inventory","Mast","Simulation")
#
legend("top",legendvec,lty=1,col=c("black","blue","red"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# #########################################################
# Detail plot between 15/01 and 15/02
# including the forcing air temperature
# in order to investigate a cold spell
# #########################################################
#
# Select time interval
#
LST=mycaldat(dateobs)
mon=LST$m;day=LST$d;yea=LST$y
#
indsel=which(((mon==1)&(day>=15))|((mon==2)&(day<=15)))
#
dateobssel  =dateobs[indsel]
htotobssel  =htotobs[indsel]
hqansimsel  =hqansim[indsel]
hantobssel  =hantobs[indsel]
taforcingsel=taforcing[indsel]
#
# Define xaxis
#
LST=mycaldat(dateobssel[1])
mon=LST$m;day=LST$d;yea=LST$y
xmin=as.Date(paste(yea,"/",mon,"/",day,sep=""))
#
LST=mycaldat(dateobssel[length(dateobssel)])
mon=LST$m;day=LST$d;yea=LST$y
xmax=as.Date(paste(yea,"/",mon,"/",day,sep=""))
#
xlim=c(xmin,xmax)
#
# Define yaxis
#
ymin=-50
ymax=+200
yinc=+50
#
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
# Y-axis for temperature
#
ymin2=-5
ymax2=+20
yinc2=+5
#
yaxis2=seq(ymin2,ymax2,yinc2)
ylim2=c(ymin2,ymax2)
#
cexall=0.6
pchall=1.0
lwdall=1.0
#
pdf(paste(ppday,case,"/EVALFLX_DJF_",nameplo,".pdf",sep=""))
par(mar=c(5,5,1,5))
par(xaxs="i",yaxs="i")
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (ii in 1:length(dateobssel)) {
  if (length(!is.na(taforcingsel[ii]))>0) points(x=dateobssel[ii],y=10*taforcingsel[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
  points(x=dateobssel[ii],y=htotobssel[ii],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
  points(x=dateobssel[ii],y=hantobssel[ii],pch=pchall,cex=cexall,lwd=lwdall,col="green")
  points(x=dateobssel[ii],y=hqansimsel[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
}
#
axis.Date(1,at=seq(xmin,xmax,"day"),format="%b-%d",las=2,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
axis(4,at=10*yaxis2,lab=yaxis2,las=2,cex.axis=1.3)
#
mtext("Anthropogenic heat flux [W/m^2]",side=2,line=3,cex=1.5,col="black")
mtext("Air temperature [°C]",side=4,line=3,cex=1.5,col="black")
#
legendvec=c("Air temperature","Inventory","Mast","Simulation")
#
legend("top",legendvec,lty=1,col=c("black","blue","green","red"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# #########################################################
# Detail plot between 01/06 and 01/07
# including the forcing air temperature
# in order to investigate a warm spell
# #########################################################
#
# Select time interval
#
LST=mycaldat(dateobs)
mon=LST$m;day=LST$d;yea=LST$y
#
indsel=which(mon==6)
#
dateobssel  =dateobs[indsel]
htotobssel  =htotobs[indsel]
hqansimsel  =hqansim[indsel]
hantobssel  =hantobs[indsel]
taforcingsel=taforcing[indsel]
#
# Define xaxis
#
LST=mycaldat(dateobssel[1])
mon=LST$m;day=LST$d;yea=LST$y
xmin=as.Date(paste(yea,"/",mon,"/",day,sep=""))
#
LST=mycaldat(dateobssel[length(dateobssel)])
mon=LST$m;day=LST$d;yea=LST$y
xmax=as.Date(paste(yea,"/",mon,"/",day,sep=""))
#
xlim=c(xmin,xmax)
#
# Define yaxis
#
ymin=0
ymax=50
yinc=10
#
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
# Y-axis for temperature
#
ymin2=10
ymax2=30
yinc2=5
#
yaxis2=seq(ymin2,ymax2,yinc2)
ylim2=c(ymin2,ymax2)
#
cexall=0.6
pchall=1.0
lwdall=1.0
#
pdf(paste(ppday,case,"/EVALFLX_JJA_",nameplo,".pdf",sep=""))
par(mar=c(5,5,1,5))
par(xaxs="i",yaxs="i")
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (ii in 1:length(dateobssel)) {
  if (length(!is.na(taforcingsel[ii]))>0) points(x=dateobssel[ii],y=taforcingsel[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
  points(x=dateobssel[ii],y=htotobssel[ii],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
  points(x=dateobssel[ii],y=hantobssel[ii],pch=pchall,cex=cexall,lwd=lwdall,col="green")
  points(x=dateobssel[ii],y=hqansimsel[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
}
#
axis.Date(1,at=seq(xmin,xmax,"day"),format="%b-%d",las=2,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
axis(4,at=yaxis2,lab=yaxis2,las=2,cex.axis=1.3)
#
mtext("Anthropogenic heat flux [W/m^2]",side=2,line=3,cex=1.5,col="black")
mtext("Air temperature [°C]",side=4,line=3,cex=1.5,col="black")
#
legendvec=c("Air temperature","Inventory","Mast","Simulation")
#
legend("top",legendvec,lty=1,col=c("black","blue","green","red"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# ########################################################################
# Average weekly cycle 
# ########################################################################
#
# Settings common to all plots
#
# Define xaxis
#
xmin=1
xmax=7
xlim=c(0.5,7.5)
xaxis=seq(xmin,xmax,1)
xlabd=c("Mon","Tue","Wed","Thu","Fri","Sat","Sun")
#
# Define yaxis
#
ymin=-10
ymax=+100
yinc=+10
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
cexall=1.0
pchall=1.0
lwdall=1.0
#
vecseas=c("COOL","HEAT")
#
hgasobs=array(NA,7)
heleobs=array(NA,7)
htraobs=array(NA,7)
hantobs=array(NA,7)
htotobs=array(NA,7)
#
for (seas in 1:length(vecseas)) {
#
if (seas==1) {
  #
  hgasobs=hgasobscoolwd[1,]
  heleobs=heleobscoolwd[1,]
  htraobs=htraobscoolwd[1,]
  hantobs=hantobscoolwd[1,]
  #
  htotobs=hgasobscoolwd[1,]+heleobscoolwd[1,]+htraobscoolwd[1,]
  #
  htrasim=htrasimcoowd[1,]
  hindsim=hindsimcoowd[1,]
  hqinsim=hqinsimcoowd[1,]
  hcoosim=hcoosimcoowd[1,]
  hheasim=hheasimcoowd[1,]
  hqansim=hqansimcoowd[1,]
  #
}
else if (seas==2) {
  #
  hgasobs=hgasobsheatwd[1,]
  heleobs=heleobsheatwd[1,]
  htraobs=htraobsheatwd[1,]
  hantobs=hantobsheatwd[1,]
  #
  htotobs=hgasobsheatwd[1,]+heleobsheatwd[1,]+htraobsheatwd[1,]
  #
  htrasim=htrasimheawd[1,]
  hindsim=hindsimheawd[1,]
  hqinsim=hqinsimheawd[1,]
  hcoosim=hcoosimheawd[1,]
  hheasim=hheasimheawd[1,]
  hqansim=hqansimheawd[1,]
  #
}
#
# #################################################
# A: Display the components of the observed fluxes
# #################################################
#
# htrasimcoowd,hindsimcoowd,hqinsimcoowd,hcoosimcoowd,hheasimcoowd,hqansimcoowd,
# htrasimheawd,hindsimheawd,hqinsimheawd,hcoosimheawd,hheasimheawd,
# hqansimheawd,dateobs,hantobs,heleobs,htraobs,hgasobs,
# hantobscoolwd,heleobscoolwd,htraobscoolwd,hgasobscoolwd,
# hantobsheatwd,heleobsheatwd,htraobsheatwd,hgasobsheatwd,
# dayofweek,nameplo
#
pdf(paste(ppwee,case,"/OBSFLX_",vecseas[seas],".pdf",sep=""))
par(mar=c(5,5,1,5))
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (ii in 1:7) {
  points(x=ii,y=hgasobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
  points(x=ii,y=heleobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="green")
  points(x=ii,y=htraobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
  points(x=ii,y=htotobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="magenta")
  points(x=ii,y=hantobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
}
#
axis(1,at=xaxis,lab=xlabd,las=1,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Sensible heat release [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Gas inventory","Electricity inventory","Traffic inventory",
            "Total inventory","Mast observation")
#
legend("top",legendvec,lty=1,col=c("blue","green","red","magenta","black"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# #############################################
# B: Components of the simulated fluxes
# #############################################
#
pdf(paste(ppwee,case,"/SIMFLX_",nameplo,"_",vecseas[seas],".pdf",sep=""))
par(mar=c(5,5,1,5))
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (ii in 1:7) {
  points(x=ii,y=htrasim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
  points(x=ii,y=hindsim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="gray")
  points(x=ii,y=hqinsim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="green")
  points(x=ii,y=hcoosim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
  points(x=ii,y=hheasim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="magenta")
  points(x=ii,y=hqansim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
}
#
axis(1,at=xaxis,lab=xlabd,las=1,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Sensible heat release [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Traffic","Industry","Internal heat release","Cooling","Heating","Total")
#
legend("top",legendvec,lty=1,col=c("red","gray","green","blue","magenta","black"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# #############################################
# C: Simulated versus observed total fluxes
# #############################################
#
pdf(paste(ppwee,case,"/EVALFLX_",nameplo,"_",vecseas[seas],".pdf",sep=""))
par(mar=c(5,5,1,5))
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
for (ii in 1:7) {
  points(x=ii,y=htotobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
  points(x=ii,y=hantobs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
  points(x=ii,y=hqansim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
}
#
axis(1,at=xaxis,lab=xlabd,las=1,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Anthropogenic heat flux [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Inventory","Mast","Simulation")
#
legend("top",legendvec,lty=1,col=c("black","blue","red"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
}
#
# ########################################################################
# Average diurnal cycle
# ########################################################################
#
# Settings common to all plots
#
# Define x-axis
#
xmin=0
xmax=24
xlim=c(xmin,xmax)
xaxisout=24*seq(0,(1-incdateout),incdateout)
xaxisobs=seq(0,23.5,0.5)
xaxislab=seq(0,24,2)
#
# Define yaxis
#
ymin=-10
ymax=+100
yinc=+10
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
cexall=1.0
pchall=1.0
lwdall=1.0
#
vecseas=c("DJF","MAM","JJA","SON")
#
htotobsdcyc=hgasobsdcyc+heleobsdcyc+htraobsdcyc
#
for (seas in 1:length(vecseas)) {
#
# #################################################
# A: Display the components of the observed fluxes
# #################################################
#
pdf(paste(ppcyc,case,"/OBSFLX_",vecseas[seas],".pdf",sep=""))
par(mar=c(5,5,1,5))
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
lines(x=xaxisobs,y=hgasobsdcyc[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
lines(x=xaxisobs,y=heleobsdcyc[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="green")
lines(x=xaxisobs,y=htraobsdcyc[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="red")
lines(x=xaxisobs,y=htotobsdcyc[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="magenta")
#
axis(1,at=xaxislab,lab=xaxislab,las=1,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Sensible heat release [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Gas inventory","Electricity inventory","Traffic inventory","Total inventory")
#
legend("top",legendvec,lty=1,col=c("blue","green","red","magenta"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# #############################################
# B: Components of the simulated fluxes
# #############################################
#
pdf(paste(ppcyc,case,"/SIMFLX_",nameplo,"_",vecseas[seas],".pdf",sep=""))
par(mar=c(5,5,1,5))
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
lines(x=xaxisout,y=htrasimdaycy[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="red")
lines(x=xaxisout,y=hindsimdaycy[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="gray")
lines(x=xaxisout,y=hqinsimdaycy[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="green")
lines(x=xaxisout,y=hcoosimdaycy[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="blue")
lines(x=xaxisout,y=hheasimdaycy[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="magenta")
lines(x=xaxisout,y=hqansimdaycy[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="black")
#
axis(1,at=xaxislab,lab=xaxislab,las=1,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Sensible heat release [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Traffic","Industry","Internal heat release","Cooling","Heating","Total")
#
legend("top",legendvec,lty=1,col=c("red","gray","green","blue","magenta","black"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
# #############################################
# C: Simulated versus observed total fluxes
# #############################################
#
pdf(paste(ppcyc,case,"/EVALFLX_",nameplo,"_",vecseas[seas],".pdf",sep=""))
par(mar=c(5,5,1,5))
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
lines(x=xaxisobs,y=htotobsdcyc [seas,],pch=pchall,cex=cexall,lwd=lwdall,col="black")
lines(x=xaxisout,y=hqansimdaycy[seas,],pch=pchall,cex=cexall,lwd=lwdall,col="red")
#
axis(1,at=xaxislab,lab=xaxislab,las=1,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext("Anthropogenic heat flux [W/m^2]",side=2,line=3,cex=1.5,col="black")
#
legendvec=c("Inventory","Simulation")
#
legend("top",legendvec,lty=1,col=c("blue","red"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
}
#
}
#
# ###########################################################################
#
# Evaluation of simulated and observed fluxes at the mast
#
seplotevalmast=function(htebsimtsday,ltebsimtsday,rtebsimtsday,htebsimdaycy,
               ltebsimdaycy,rtebsimdaycy,htebsimcoowd,ltebsimcoowd,
               rtebsimcoowd,htebsimheawd,ltebsimheawd,rtebsimheawd,
               sencoolwd,latcoolwd,radcoolwd,senheatwd,latheatwd,
               radheatwd,sendayav,latdayav,raddayav,sendcyc,latdcyc,
               raddcyc,juldayav,dayofweek,case,nameplo) {
#
# #########################################################
# #########################################################
# Time series of daily averages
# #########################################################
# #########################################################
#
# Define xaxis (common to all variables)
#
LST=mycaldat(juldayav[1])
mon=LST$m;day=LST$d;yea=LST$y
xmin=as.Date(paste(yea,"/",mon,"/",day,sep=""))
#
LST=mycaldat(juldayav[length(juldayav)])
mon=LST$m;day=LST$d;yea=LST$y
xmax=as.Date(paste(yea,"/",mon,"/",day,sep=""))
#
xlim=c(xmin,xmax)
#
cexall=0.6
pchall=1.0
lwdall=0.6
#
for (var in 1:3) {
  #
  # Settings depending on variable
  #
  if (var==1) {
    #
    sim=htebsimtsday
    obs=sendayav
    nam="HTEB"
    lab="Town sensible heat fluw [W/m²]"
    #
    ymin=-50;ymax=+250;yinc=+50
    #
  }
  else if (var==2) {
    #
    sim=ltebsimtsday
    obs=latdayav
    nam="LTEB"
    lab="Town latent heat fluw [W/m²]"
    #
    ymin=-50;ymax=+100;yinc=+25
    #
  }
  else if (var==3) {
    #
    sim=rtebsimtsday
    obs=raddayav
    nam="RTEB"
    lab="Town net radiative flux [W/m²]"
    #
    ymin=-100;ymax=+200;yinc=+50
    #
  }
  else stop("This case is not implemented")
  #
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
  #
  pdf(paste(ppday,case,"/EVALMAST_",nam,"_",nameplo,".pdf",sep=""))
  par(mar=c(5,5,1,5))
  par(xaxs="i",yaxs="i")
  #
  plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
  #
  for (ii in 1:length(juldayav)) {
    points(x=juldayav[ii],y=obs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
    points(x=juldayav[ii],y=sim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
  }
  #
  axis.Date(1,at=seq(xmin,xmax,"month"),format="%b-%d",las=2,cex.axis=1.3)
  axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
  #
  mtext(lab,side=2,line=3,cex=1.5,col="black")
  #
  legendvec=c("Mast","Simulation")
  #
  legend("top",legendvec,lty=1,col=c("black","red"),lwd=2,cex=1.2)
  #
  garbage <- dev.off()
  #
}
#
# ########################################################################
# ########################################################################
# Average weekly cycle 
# ########################################################################
# ########################################################################
#
# Settings common to all plots
#
# Define xaxis
#
xmin=1
xmax=7
xlim=c(0.5,7.5)
xaxis=seq(xmin,xmax,1)
xlabd=c("Mon","Tue","Wed","Thu","Fri","Sat","Sun")
#
cexall=1.0
pchall=1.0
lwdall=1.0
#
vecseas=c("COOL","HEAT")
#
for (var in 1:3) for (seas in 1:length(vecseas)) {
  #
  # Settings depending on variable
  #
  if (var==1) {
    nam="HTEB"
    lab="Town sensible heat fluw [W/m²]"
    if (seas==1) {
      sim=htebsimcoowd
      obs=sencoolwd
      ymin=-20;ymax=+100;yinc=+20
    }
    else {
      sim=htebsimheawd
      obs=senheatwd
      ymin=-20;ymax=+100;yinc=+20
    }
  }
  else if (var==2) {
    nam="LTEB"
    lab="Town latent heat fluw [W/m²]"
    if (seas==1) {
      sim=ltebsimcoowd
      obs=latcoolwd
      ymin=-50;ymax=+100;yinc=+25
    }
    else {
      sim=ltebsimheawd
      obs=latheatwd
      ymin=-50;ymax=+100;yinc=+25
    }
  }
  else if (var==3) {
    nam="RTEB"
    lab="Town net radiative flux [W/m²]"
    if (seas==1) {
      sim=rtebsimcoowd
      obs=radcoolwd
      ymin=-100;ymax=+200;yinc=+50
    }
    else {
      sim=rtebsimheawd
      obs=radheatwd
      ymin=-100;ymax=+200;yinc=+50
    }
  }
  else stop("This case is not implemented")
  #
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
  #
  pdf(paste(ppwee,case,"/EVALMAST_",nam,"_",nameplo,"_",vecseas[seas],".pdf",sep=""))
  par(mar=c(5,5,1,5))
  #
  plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
  #
  for (ii in 1:7) {
    points(x=ii,y=obs[ii],pch=pchall,cex=cexall,lwd=lwdall,col="black")
    points(x=ii,y=sim[ii],pch=pchall,cex=cexall,lwd=lwdall,col="red")
  }
  #
  axis(1,at=xaxis,lab=xlabd,las=1,cex.axis=1.3)
  axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
  #
  mtext(lab,side=2,line=3,cex=1.5,col="black")
  #
  legendvec=c("Mast","Simulation")
  #
  legend("top",legendvec,lty=1,col=c("black","red"),lwd=2,cex=1.2)
  #
  garbage <- dev.off()
  #
}
#
# ########################################################################
# ########################################################################
# Average diurnal cycle
# Here the diurnal cycle routine is called to ensure consistancy
# ########################################################################
# ########################################################################
#
vecseas=c("DJF","MAM","JJA","SON")
#
for (seas in 1:length(vecseas)) for (var in 1:3) {
  #
  # Settings depending on variable
  #
  data=array(NA,c(1,1,(1/incdateout),2))
  #
  if (var==1) {
    nam="HTEB"
    tit="Sensible heat flux"
    data[1,1,,1]=sendcyc[seas,]
    data[1,1,,2]=htebsimdaycy[seas,]
  } else if (var==2) {
    nam="LTEB"
    tit="Latent heat flux"
    data[1,1,,1]=latdcyc[seas,]
    data[1,1,,2]=ltebsimdaycy[seas,]
  } else if (var==3) {
    nam="RTEB"
    tit="Net radiation"
    data[1,1,,1]=raddcyc[seas,]
    data[1,1,,2]=rtebsimdaycy[seas,]
  } else {
    stop("This case is not implemented")
  }
  #
  nameleg=c("Tower-Obs.","TEB")
  colors =c("black","red")
  nameplot=paste("EVALMAST_",nam,"_",nameplo,sep="")
  ltys=array(1,length(colors))
  #
  plotdaycy(data,incdateout,nameplot,"W/m²",tit,namseas[seas],"",
            ltys=ltys,nameleg,colors,path=paste(ppcyc,case,"/",sep=""))
  #
  }
#
}
#
# ###########################################################################
#
# Plot average diurnal cycle
#
plotdaycy=function(data,incdate,var,uni,nam,namsea,name,legendvec,
                   colors,ltys,titlename=NA,mae=NA,corre=NA,mabs=NA,
                   bias=NA,unieval=NA,path) {
#
if (length(which(!is.na(data)))>1) {
#
amin=min(data,na.rm=TRUE)
amax=max(data,na.rm=TRUE)
#
adiff=amax-amin
#
if (adiff>1.0e-5) {
#
# Check input
#
DIM=dim(data)
if (length(DIM)>4.1) stop("Wrong number of dimensions")
if (DIM[3]!=(1/incdate)) stop("Wrong input")
#
if (length(DIM)==4) {
  nloop=DIM[4]
  if (DIM[4]>length(colors)) stop("Not enough colors specified")
}
else {
  nloop=1
}
#
# Create x-values
#
xaxis=24*seq(incdate,1,incdate)
#
# File for output
#
printl=paste(path,var,"_",namsea,"_",name,".pdf",sep="")
#
# Define x-axis
# 
xmin=0
xmax=24
xlim=c(xmin,xmax)
xvals=seq(xmin,xmax,2)
xleg=0.45*xmax+0.55*xmin
#
# Prepare yaxis
#
LST=sescale(data)
ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
if (grepl("Toulouse_JJA_WT9",path)&grepl("WIFF",name)) {
  #
  ymin=0
  ymax=5
  yinc=1
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
  #
} else if (grepl("Toulouse_JJA_WT9",path)&grepl("FLALWD",name)) {
  #
  ymin=250
  ymax=400
  yinc=50
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
  #
}
#
yleg=0.98*ymax+0.02*ymin
#
# Create plot
#
pdf(printl,width=9,height=7)
par(mar=c(6,6,1.0,1.5))
par(oma=c(0,0,1.5,0))
par(xaxs="i",yaxs="i")
#
# Line width
#
lwd=3
cexall=2.0
cextim=1.8
#
if (grepl("EVALMAST",printl)) {
  cexleg=1.8
} else {
  cexleg=1.3
}
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
if (nloop>1.1) {
  for (nn in 1:nloop) lines(xaxis,data[1,1,,nn],col=colors[nn],lwd=lwd,lty=ltys[nn])
} else {
  lines(xaxis,data[1,1,],col=colors[1],lwd=lwd,lty=ltys[1])
}
#
axis(1,at=xvals,lab=xvals,las=1,cex.axis=cextim)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=cexall)
#
# Write evaluation measures into the plots
#
xtext=0.3*xmin+0.7*xmax
diff=ymax-ymin
adist=0.06
#
if (grepl("WIFF",name)|grepl("FLALWD",name)) {
  ytext=0.7*ymin+0.3*ymax
} else {
  ytext=0.05*ymin+0.95*ymax
}
#
if (grepl("WIFF",name)) {
  ndigits=1
} else if (grepl("LWD",name)|grepl("SWD",name)) {
  ndigits=0
} else {
  ndigits=2
}
#
# Display BIAS and mean absolute error (for model against observations)
#
if (!is.na(bias))  text(xtext,ytext-0*adist*diff,pos=4,labels=paste("BIAS = ",round(bias,digits=ndigits) ," ",unieval,sep=""),cex=1.5,col="black")
if (!is.na(mae))   text(xtext,ytext-1*adist*diff,pos=4,labels=paste("MAE = ",round(mae ,digits=ndigits) ," ",unieval,sep=""),cex=1.5,col="black")
if (!is.na(corre)) text(xtext,ytext-2*adist*diff,pos=4,labels=paste("COR = ",round(corre,digits=2),sep=""),cex=1.5,col="black")
#
# Display mean absolute error for two scenarios
# and corresponding evaluation simulation
#
if (!is.na(mabs)) {
  text(xtext,ytext,          labels=paste("MAE (eval) = ",round(mae,digits=2)," ",uni,sep=""),cex=1.0,col="black")
  text(xtext,ytext-0.05*diff,labels=paste("MAE (scen) = ",round(mae,digits=2)," ",uni,sep=""),cex=1.0,col="black")
}
#
# Write axis names
#
# mtext("Solar time",side=1,line=3.5,cex=cexall,col="black")
mtext("UTC",side=1,line=3.5,cex=cexall,col="black")
#
# Name and unit on y-axis
#
mtext(paste(nam," [",uni,"]",sep=""),side=2,line=4.5,cex=cexall,col="black")
#
# Name and unit separated
#
# mtext(uni,side=2,line=4.5,cex=cexall,col="black")
# mtext(nam,side=3,line=0.0,cex=cexall,col="black",adj=0.6,outer=TRUE)
#
if (grepl("HVAC_HT",printl)) {
  legend(xleg,yleg,legendvec,lty=ltys[1:nloop],col=colors[1:nloop],lwd=lwd,cex=cexleg,xpd=TRUE)
} else {
  legend("topleft",legendvec,lty=ltys[1:nloop],col=colors[1:nloop],lwd=lwd,cex=cexleg,xpd=TRUE)
}
#
garbage <- dev.off()
graphics.off()
#
}
#
}
}
#
# ###########################################################################
#
# Plot average weekly cycle
#
plotweekcy=function(data,var,uni,nam,namsea,name,legendvec,colors,path) {
#
if (length(which(!is.na(data)))>1) {
#
# Check input
#
DIM=dim(data)
#
if (length(DIM)>2.1) stop("Wrong number of dimensions")
if (DIM[1]!=7) stop("Wrong input")
#
if (length(DIM)==2) {
  nloop=DIM[2]
  if (DIM[2]>length(colors)) stop("Not enough colors specified")
} else {
  nloop=1
}
#
# Create x-values
#
xaxis=seq(1,7,1)
if (length(xaxis)!=7) stop("Wrong x-values")
#
# File for output
#
printl=paste(path,"/",var,"_",namsea,"_",name,".pdf",sep="")
#
# Define x-axis
# 
xmin=0.5
xmax=7.5
xlim=c(xmin,xmax)
xvals=seq(1,7,1)
#
# Define yaxis
#
LST=sescale(data)
ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
#
# Create plot
#
pdf(printl)
par(mar=c(5,5,1,5))
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
if (nloop>1) {
  for (nn in 1:nloop) for (ii in 1:7) points(x=ii,y=data[ii,nn],col=colors[nn],pch=21,lwd=2,cex=1.0)
} else {
  for (ii in 1:7) points(x=ii,y=data[ii],col=colors[1],pch=21,lwd=2,cex=1.0)
}
#
xlabd=c("Mon","Tue","Wed","Thu","Fri","Sat","Sun")
#
axis(1,at=xvals,lab=xlabd,las=1,cex.axis=1.3)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
#
mtext(paste(nam," [",uni,"]",sep=""),side=2,line=3,cex=1.5,col="black")
#
legend("bottom",legendvec,lty=1,col=colors[1:nloop],lwd=2,cex=1.2)
#
garbage <- dev.off()
#
}
#
}
#
# ###########################################################################
#
# General plot for several y-data against one set of xdata
#
plotxy=function(xdata,ydata,name,nam_xaxis,nam_yaxis,legendvec=NA,colors,ltys,
                titlename=NA,nstation=NA,regr.ci.level=0.90) {
#
cexall=2.0
#
# Eliminate NA
#
indnotNA=which(!is.na(ydata[,1,drop=FALSE]))
xdata = xdata[indnotNA]
ydata = ydata[indnotNA,,drop=FALSE]
if (!is.na(nstation[1])) nstation=nstation[indnotNA]
#
indnotNA=which(!is.na(xdata))
xdata = xdata[indnotNA]
ydata = ydata[indnotNA,,drop=FALSE]
if (!is.na(nstation[1])) nstation=nstation[indnotNA]
#
LST=NA
#
# Create a vector for the pch
#
if (!is.na(nstation[1])) {
  pch_vec=c()
  for (stat in 1:length(nstation)) pch_vec=c(pch_vec,sprintf("%2d",nstation[stat]))
}
#
if (length(xdata)>5) {
#
amin=min(ydata)
amax=max(ydata)
adiff=amax-amin
#
if (adiff>1.0e-5) {
#
# Check input
#
LENX=length(xdata)
DIMY=dim(ydata)
LENY=DIMY[1]
nloop=DIMY[2]
if (LENX!=LENY) stop("Inconsistant length of vectors")
#
if (!is.na(nstation[1])) {
  LENS=length(nstation)
  if (LENX!=LENS) {print(LENX);print(LENS);stop("Inconsistant length of station number vector")}
}
#
# Prepare xaxis
#
LST=sescale(xdata)
xmin=LST$amin;xmax=LST$amax;xinc=LST$inc
xaxis=seq(xmin,xmax,xinc)
xlim=c(xmin,xmax)
xdist=xmax-xmin
#
# Prepare yaxis
#
LST=sescale(ydata)
ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
ymax=ymax+yinc
yaxis=seq(ymin,ymax,yinc)
ylim=c(ymin,ymax)
ydist=ymax-ymin
#
# Create plot
#
pdf(name,width=7,height=7)
par(mar=c(5,6,1,1.3))
par(oma=c(0,0,0,0)) 
par(xaxs="i",yaxs="i")
#
plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
#
# if (nloop>1.1) {
#  if (is.na(nstation[1])) for (nn in 1:nloop) points(xdata,ydata[,nn],col=colors[nn],lwd=2,lty=ltys[nn])
#  else                    for (nn in 1:nloop) text(xdata,ydata[,nn],col=colors[nn],lwd=2,labels=pch_vec)
# } else {
#  if (is.na(nstation[1])) points(xdata,ydata[,1],col=colors[1],lwd=2,lty=ltys[1])
#  else                    text(xdata,ydata[,1],col=colors[1],lwd=2,labels=pch_vec)
# }
#
if (is.na(nstation[1])) {
  #
  # No stations: just plot points
  #
  for (nn in 1:nloop) points(xdata,ydata[,nn],col=colors[nn],lwd=2,pch=16)
  #
} else {
  #
  # Stations: Plot points and station identifier
  #
  for (nn in 1:nloop) points(xdata,ydata[,nn],col=colors[nn],lwd=2,pch=16)
  for (nn in 1:nloop) text  (xdata+0.0*xdist,ydata[,nn]+0.03*ydist,col=colors[nn],cex=1.3,lwd=2,labels=pch_vec)
  #
}
#
# Fit linear model and draw into plot
#
coef_obs=NA
coef_sim=NA
#
for (nn in 1:nloop) {
  #
  # Linear model
  #
  # lm=lm(ydata[,nn]~xdata)
  #
  # Robust linear model
  #
  rlm=rlm(ydata[,nn]~xdata)
  #
  intc = summary(rlm)$coefficients[1,1]
  coef = summary(rlm)$coefficients[2,1]
  #
  if (nn==1) coef_obs=coef
  if (nn==2) coef_sim=coef
  #
  st=format(round((cor(xdata,ydata[,nn]))**2,digits=2),nsmall=2)
  rt=paste("y = ",round(coef,digits=2)," x + ",round(intc,digits=1),", r² = ",st,sep="")
  #
  text(0.97*xlim[1]+0.03*xlim[2],0.05*ylim[1]+0.95*ylim[2]-0.06*(nn-1)*(ylim[2]-ylim[1]),rt,pos=4,cex=cexall,col=colors[nn])
  #
  abline(rlm,lty=2,lwd=4,col=colors[nn])
  #
}
#
axis(1,at=xaxis,lab=xaxis,las=1,cex.axis=cexall)
axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=cexall)
#
# Write axis names
#
mtext(nam_xaxis,side=1,line=3.0,cex=cexall,col="black")
mtext(nam_yaxis,side=2,line=4.5,cex=cexall,col="black")
#
if (!is.na(titlename)) {
  title("")
  mtext(titlename,col="black",side=3,line=1.0,adj=0.5,outer=TRUE,cex=cexall)
}
#
if (!is.na(legendvec[1])) legend("bottomright",legendvec,lty=2,col=colors[1:nloop],lwd=2,cex=cexall,xpd=TRUE)
#
garbage <- dev.off()
#
LST=list(coef_obs=coef_obs,coef_sim=coef_sim)
#
}
#
}
}
#
# ###########################################################################
#
# Plot evaluation measures
#
seplotmeas=function(cases,case) {
#
# Load data
#
BIASCUM=array(NA,c(2,3,length(cases)))
MAERCUM=array(NA,c(2,3,length(cases)))
RMSECUM=array(NA,c(2,3,length(cases)))
#
for (ii in 1:length(cases)) {
  #
  load(file=paste(pdata,case,"/EVAL_",cases[ii],sep=""))
  #
  BIASCUM[,,ii]=LST$BIAS
  MAERCUM[,,ii]=LST$MAER
  RMSECUM[,,ii]=LST$RMSE
  #
}
#
# Define x-axis
#
xmin=1
xmax=length(cases)
xlim=c(xmin,xmax)
xvals=seq(xmin,xmax,1)
#
# Define legend
#
leg=c("Inventory (ALL)","Inventory (COOL)","Inventory (HEAT)",
      "Mast (ALL)","Mast (COOL)","Mast (HEAT)")
#
vecmea=c("BIAS","MAER","RMSE")
cols=c("black","blue","red")
ltyvec=c(1,2)
#
for (jj in 1:length(vecmea)) {
  #
  # Select data depending on evaluation measure
  #
  if      (vecmea[jj]=="BIAS") {
    data=BIASCUM
    labl="BIAS [W/m²]"
  }
  else if (vecmea[jj]=="MAER") {
    data=MAERCUM
    labl="Mean absolute error [W/m²]"
  }
  else if (vecmea[jj]=="RMSE") {
    data=RMSECUM
    labl="RMSE [W/m²]"
  }
  else {
    stop("This variable is not implemented")
  }
  #
  # Define yaxis
  #
  aux=data[]
  if (length(which(!is.na(aux)))>0) {
  #
  LST=sescale(data)
  ymin=LST$amin
  ymax=LST$amax
  yinc=LST$inc
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
  #
  # File for output
  #
  printl=paste(ppday,case,"/EVALPLOT_",case,"_",vecmea[jj],".pdf",sep="")
  #
  pdf(printl)
  par(mar=c(5,5,1,5))
  #
  plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
  #
  for (mm in 1:3) for (nn in 1:2) {
    lines(xvals,data[nn,mm,],col=cols[mm],lwd=2,lty=ltyvec[nn])
  }
  #
  axis(1,at=xvals,lab=cases,las=2,cex.axis=1.3)
  axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
  #
  mtext(labl,side=2,line=3,cex=1.5,col="black")
  #
  legend("top",leg,lty=c(ltyvec[1],ltyvec[1],ltyvec[1],ltyvec[2],
         ltyvec[2],ltyvec[2]),col=cols,lwd=2,cex=1.2)
  #
  garbage <- dev.off()
  #
  }
}
#
}
#
# ##################################################################
#
# Scatterplot of anthropogenic heat versus air temperature
#
sescattta=function(htotobs,hantobs,taforcing,hqansimtsday,nameplo) {
#
htotobsorg=htotobs
hantobsorg=hantobs
taforcingorg=taforcing
#
yinc=50
#
amin=min(c(htotobs[],hantobs[],hqansimtsday[]),na.rm=TRUE)
amax=max(c(htotobs[],hantobs[],hqansimtsday[]),na.rm=TRUE)
#
amin=yinc*(floor(amin/yinc))
amax=yinc*(floor(amax/yinc)+1)
ylim=c(amin,amax)
#
xinc=5
#
amin=min(taforcing[],na.rm=TRUE)
amax=max(taforcing[],na.rm=TRUE)
#
amin=xinc*(floor(amin/xinc))
amax=xinc*(floor(amax/xinc)+1)
xlim=c(amin,amax)
#
xlab="Air temperature [°C]"
ylab="Antropogenic heat flux [W/m²]"
#
# Create a scatterplot between air temperature and 
# inventory/simulated anthropogenic heat flux
#
pdf(paste(ppday,"SCATTFLX_",nameplo,".pdf",sep=""),height=6,width=6)
par(mar=c(5,5,1,5))
#
htotobs[which(is.na(taforcing))]=NA
taforcing[which(is.na(htotobs))]=NA
#
myscatts(x=taforcing,y=htotobs,xlim=xlim,ylim=ylim,xlab=xlab,ylab=ylab,
         col="black",regr=F,regr.txt=F,pval=0.1,regr.ci=F,regr.ci.level=0.95,
         add=F,frame.plot=T,pch=21,bg.def="white",jj=1,xinc=xinc,
         yinc=yinc,lwdsca=1,lnum=0,nums=NA)
#
htotobs=htotobsorg
taforcing=taforcingorg
#
hantobs[which(is.na(taforcing))]=NA
taforcing[which(is.na(hantobs))]=NA
#
myscatts(x=taforcing,y=hantobs,xlim=xlim,ylim=ylim,xlab=xlab,ylab=ylab,
         col="blue",regr=F,regr.txt=F,pval=0.1,regr.ci=F,regr.ci.level=0.95,
         add=T,frame.plot=T,pch=21,bg.def="white",jj=1,xinc=xinc,
         yinc=yinc,lwdsca=1,lnum=0,nums=NA)
#
hantobs=htotobsorg
taforcing=taforcingorg
#
hqansimtsday[which(is.na(taforcing))]=NA
taforcing[which(is.na(hqansimtsday))]=NA
#
myscatts(x=taforcing,y=hqansimtsday,xlim=xlim,ylim=ylim,xlab=xlab,
         ylab=ylab,col="red",regr=F,regr.txt=F,pval=0.1,regr.ci=F,
         regr.ci.level=0.95,add=T,frame.plot=T,pch=21,bg.def="white",
         jj=2,xinc=xinc,yinc=yinc,lwdsca=1,lnum=0,nums=NA)
#
legend("topright",c("Inventory","Mast","Simulation"),lty=1,col=c("black","blue","red"),lwd=2,cex=1.2)
#
garbage <- dev.off()
#
}
#
# ######################################################################
# Georeferenced plot of raster data
# ######################################################################
#
seplotraster=function(field,raster,ncols,nrows,brks,cols,name,nameplot,
                      nametitle,unit,xaxis,yaxis,xaxis_km,yaxis_km,
                      xcor_mast_km=NA,ycor_mast_km=NA,flaglarge=0) {
  #
  if (length(which(!is.na(field)))>2) {
  #
  # Convert field into classes
  #
  nameact = c()
  colsact = c()
  brksact = c()
  #
  fieldclasses=array(NA,length(field))
  count=1
  #
  for (ii in 2:length(brks)) {
    #
    ind=which((field>=brks[ii-1])&(field<brks[ii]))
    #
    if (length(ind>0.5)) {
      fieldclasses[ind]=count
      brksact = c(brksact,-0.5+count)
      nameact = c(nameact,name[ii-1])
      colsact = c(colsact,cols[ii-1])
      count=count+1
    }
    #
  }
  #
  brksact=c(brksact,-0.5+count)
  #
  name = nameact
  cols = colsact
  brks = brksact
  #
  field=as.vector(fieldclasses)
  #
  # brks=seq(0.5,max(field,na.rm=TRUE)+0.5,1)
  #
  # Write values onto raster
  #
  if (length(brks)>1.5) {
  #
  raster=setValues(raster,field)
  #
  # Create plot
  #
  cexall=2.0
  cexleg=1.5
  #
  pdf(nameplot,width=8.15,height=6.8)
  par(mar=c(4.5,4.5,0.5,0.5))
  par(oma=c(0,0,2.0,4.5)) 
  #
  arg=list(at=seq(1,length(name),1),labels=name,line=0,cex.axis=cexleg)
  #
  plot(raster,breaks=brks,col=cols,axis.args=arg,axes=FALSE,xlab=NA,ylab=NA,
       cex.axis=cexall,cex.lab=cexall,alpha=1,colNA="white",add=FALSE,
       useRaster=TRUE,interpolate=FALSE)
  #
  if (!is.na(xcor_mast_km)) points(x=xcor_mast_km,y=ycor_mast_km,col="black",pch=4,cex=2.0,lwd=2.0)
  #
  title("")
  #
  axis(1,at=xaxis,lab=xaxis_km,las=1,cex.axis=cexall)
  axis(2,at=yaxis,lab=yaxis_km,las=2,cex.axis=cexall)
  #
  # Write above plot (e.g. the title of the plot)
  #
  if (nchar(unit)>0.5) {
    mtext(paste(nametitle," [",unit,"]",sep=""),col="black",side=3,line=0.2,adj=0.5,outer=TRUE,cex=cexall)
  } else {
    mtext(nametitle,col="black",side=3,line=0.2,adj=0.5,outer=TRUE,cex=cexall)
  }
  #
  # Write beneath legend (e.g. units)
  #
  # if (flaglarge<0.5) {
  #  mtext(unit,col="black",side=4,line=2.0,adj=0.5,outer=TRUE,cex=cexall)
  # } else {
  #   mtext(unit,col="black",side=4,line=2.5,adj=0.5,outer=TRUE,cex=cexall)
  # }
  #
  mtext("km",col="black",side=1,line=3.0,adj=0.5,outer=FALSE,cex=cexall)
  mtext("km",col="black",side=2,line=3.0,adj=0.5,outer=FALSE,cex=cexall)
  #
  garbage <- dev.off()
  #
  }
  }
#
}
#
# ######################################################################
# QQ plot
# ######################################################################
#
myqqplot=function(obs,sim,name,titlename=NA,varname=NA,uniname=NA,path=ppdf) {
#
if (length(obs)!=length(sim)) stop("Inconsistant lengths")
#
if (length(which(!is.na(obs)))>50) {
  #
  # Remove NAs
  #
  posnaobs=which(is.na(obs))
  posnasim=which(is.na(sim))
  #
  if (length(posnaobs)!=length(posnasim)) stop("Inconsistant number of NA")
  #
  if (length(posnaobs)>0.5) {
    diff=abs(posnasim-posnaobs)
    if (max(diff)>0.5) stop("Inconsistant position of NA")
  }
  #
  obs=na.omit(obs)
  sim=na.omit(sim)
  #
  # Create x and y axis (must be equal)
  #
  LST=sescale(c(obs,sim))
  ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
  #
  xmin=LST$amin;xmax=LST$amax;xinc=LST$inc
  xaxis=seq(xmin,xmax,xinc)
  xlim=c(xmin,xmax)
  #
  pdf(paste(path,name,".pdf",sep=""),height=6,width=6)
  par(mar=c(5,5,1,5))
  par(oma=c(0,0,3,0))
  par(xaxs="i",yaxs="i")
  #
  qqplot(obs,sim,plot.it=TRUE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,axes=FALSE,frame.plot=T)
  abline(0,1,col="red",lwd=2)
  #
  axis(1,at=xaxis,lab=xaxis,las=1,cex.axis=1.1)
  axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.1)
  #
  mtext(paste("Observed " ,varname,"[",uniname,"]",sep=""),side=1,line=3.0,cex=1.0,col="black")
  mtext(paste("Simulated ",varname,"[",uniname,"]",sep=""),side=2,line=3.5,cex=1.0,col="black")
  #
  if (!is.na(titlename)) {
    title("")
    mtext(titlename,col="black",side=3,line=1.0,adj=0.5,outer=TRUE,cex=1.25)
  }
  #
  garbage <- dev.off()
  #
}
#
}
#
# ######################################################################
# Plot probability density function
# ######################################################################
#
mypdfplot=function(obs,sim,name,titlename=NA,varname=NA,uniname=NA,path=ppdf) {
#
if (length(obs)!=length(sim)) stop("Inconsistant lengths")
#
if ((length(which(!is.na(obs)))>30)&&(length(which(!is.na(sim)))>30)) {
  #
  obs=obs[which(!is.na(obs))]
  sim=sim[which(!is.na(sim))]
  #
  # Determine the breaks
  #
  nbreak=1+floor((length(obs))**(1/3))
  #
  amin=min(c(obs,sim))
  amax=max(c(obs,sim))
  pot=round(-log10(amax-amin),digits=0)
  #
  amax=round(amax,digits=max(c(0,pot+1)))
  amin=round(amin,digits=max(c(0,pot+1)))
  inc=(amax-amin)/nbreak
  #
  breaks=seq(amin-inc,amax+inc,inc)
  #
  if (length(breaks)>1) {
    # 
    xvals=array(NA,length(breaks)-1)
    for (ii in 1:(length(breaks)-1)) xvals[ii]=(breaks[ii]+breaks[ii+1])/2
    #
    hist_obs=hist(obs,breaks=breaks,plot=FALSE)
    dens_obs=hist_obs$counts/sum(hist_obs$counts)
    if (length(dens_obs)!=length(xvals)) stop("Inconsistant length for histogram")
    #
    hist_sim=hist(sim,breaks=breaks,plot=FALSE)
    dens_sim=hist_sim$counts/sum(hist_sim$counts)
    if (length(dens_sim)!=length(xvals)) stop("Inconsistant length for histogram")
    #
    ymin=0.0
    ymax=0.1+floor(max(c(dens_obs,dens_sim))*10)/10
    yaxis=seq(ymin,ymax,0.1)
    #
    xmin=min(xvals)
    xmax=max(xvals)
    #
    ylim=c(ymin,ymax)
    xlim=c(xmin,xmax)
    #
    # Plot histogram
    #
    pdf(paste(path,name,".pdf",sep=""),height=6,width=6)
    par(mar=c(5,5,1,5))
    par(oma=c(0,0,3,0))
    par(xaxs="i",yaxs="i")
    #
    plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
    #
    lines(xvals,dens_obs,col="black",lwd=2,lty=1)
    lines(xvals,dens_sim,col="red"  ,lwd=2,lty=1)
    #
    axis(1,at=xvals,lab=xvals,las=1,cex.axis=1.1)
    axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.1)
    #
    # mtext(paste("Observed " ,varname,"[",uniname,"]",sep=""),side=1,line=3.0,cex=1.0,col="black")
    # mtext(paste("Simulated ",varname,"[",uniname,"]",sep=""),side=2,line=3.5,cex=1.0,col="black")
    #
    legend("topright",c("Observation","Model"),lty=1,col=c("black","red"),lwd=2,cex=1.2)
    #
    garbage <- dev.off()
    #
  }
  #
}
#
}
#
# ######################################################################
# Wind rose
# Taken from http://stackoverflow.com/questions/17266780/wind-rose-with-ggplot-r
# ######################################################################
#
windrose = function(spd,dir,nameplot,dirres=30,palette="YlGnBu",countmax=NA) {
#
# NA not allowed
#
if (length(which(is.na(spd)))>0.5) stop("NA in wind speed not allowed")
if (length(which(is.na(dir)))>0.5) stop("NA in wind direction not allowed")
#
# Check for consistent lengths
#
if (length(spd)!=length(dir)) stop("Different lengths of wind speed and direction")
#
# Convert to data frame
#
data = data.frame(spd=spd,dir=dir)
spdvals=spd
dirvals=dir
spd  = "spd"
dir  = "dir"
#
# figure out the wind speed bins ----
#
amin=min(spdvals)
amax=max(spdvals)
#
if (amin<(-1.0e-6)) {print(amin);stop("Unplausible wind speed")}
if (amax>100)       {print(amax);stop("Unplausible wind speed")}
#
spdmax = amax
#
if (amax<20) {
  spdseq=c(0,1,2,3,5,7,10,15,20)
} else if (amax<30) {
  spdseq=c(0,1,2,3,5,7,10,15,20,30)
} else {
  spdseq=c(0,1,2,3,5,7,10,15,20,30,50,100)
}
#
if (max(spdvals)>max(spdseq)) {
  print(max(spdvals))
  print(spdseq)
  stop("Wrong selection of wind speed bins")
}
#
# get some information about the number of bins, etc.
#
n.spd.seq = length(spdseq)
n.colors.in.range = n.spd.seq - 1
#
# create the color map
#
spd.colors = colorRampPalette(brewer.pal(min(max(3,n.colors.in.range),
                              min(9,n.colors.in.range)),palette))(n.colors.in.range)
#
if (max(data[[spd]],na.rm = TRUE) > spdmax) {
  #
  spd.breaks = c(spdseq,max(data[[spd]],na.rm = TRUE))
  spd.labels = c(paste(c(spdseq[1:n.spd.seq-1]),'-',c(spdseq[2:n.spd.seq])),
                 paste(spdmax,"-",max(data[[spd]],na.rm = TRUE)))
  spd.colors = c(spd.colors, "grey50")
  #
} else {
  spd.breaks = spdseq
  spd.labels = paste(c(spdseq[1:n.spd.seq-1]),'-',c(spdseq[2:n.spd.seq]))
}
#
data$spd.binned = cut(x=data[[spd]],breaks=spd.breaks,labels=spd.labels,ordered_result=TRUE)
#
# Figure out the wind direction bins
#
dir.breaks = c(-dirres/2,seq(dirres/2, 360-dirres/2, by = dirres),360+dirres/2)
dir.labels = c(paste0(360-dirres/2,"°-",dirres/2,"°"),paste0(seq(dirres/2, 360-3*dirres/2, by = dirres),"°-",
               seq(3*dirres/2, 360-dirres/2, by = dirres),"°"),paste0(360-dirres/2,"°-",dirres/2,"°"))
#
# Assign each wind direction to a bin
#
dir.binned = cut(data[[dir]],breaks=dir.breaks,ordered_result=TRUE)
levels(dir.binned) = dir.labels
data$dir.binned = dir.binned
#
count_vec=c()
for (tt in unique(dir.binned)) {
  count_vec=c(count_vec,length(which(dir.binned==tt))/length(dir.binned))
}
#
p.windrose = ggplot(data=data,aes(x = dir.binned, fill = spd.binned)) +
             geom_bar() +
             # ylab() +
             scale_x_discrete(drop = FALSE,labels=waiver()) +
             coord_polar(start = -((dirres/2)/360) * 2*pi) +
             scale_fill_manual(name = "Wind Speed [m/s]",values = spd.colors, drop = FALSE) +
             theme(axis.title.x = element_blank())
#
# adjust axes if required
#
if (!is.na(countmax)){
  p.windrose <- p.windrose +
  ylim(c(0,countmax))
}
#
# print the plot
#
pdf(nameplot)
plot(p.windrose)
return(p.windrose)
garbage <- dev.off()
#
}
#
# #################################################################
# Quiver plot (wind speed and direction)
# A quiver plot displays velocity vectors as arrows with 
# components (u,v) at the points (x,y).
# x, y : x,y-coordinates of start points of the arrows.
# u, v : x,y-coordinates of start points.
# scale : scales the length of the arrows.
# angle : angle between shaft and edge of the arrows.
# length : length of the arrow edges.
# #################################################################
#
myquiver = function(x,y,u,v,nameplot,flaginc,scale=0.05,angle=10,length=0.1) {
  #
  if (sum(is.na(x))>0.5) {print(sum(is.na(x)));stop("Wrong entry for quiver plot")}
  if (sum(is.na(y))>0.5) {print(sum(is.na(y)));stop("Wrong entry for quiver plot")}
  if (sum(is.na(u))>0.5) {print(sum(is.na(u)));stop("Wrong entry for quiver plot")}
  if (sum(is.na(v))>0.5) {print(sum(is.na(v)));stop("Wrong entry for quiver plot")}
  #
  if (length(x)!=length(y)) stop("Inconsistant lengths")
  if (length(x)!=length(u)) stop("Inconsistant lengths")
  if (length(x)!=length(y)) stop("Inconsistant lengths")
  #
  # #######################################################
  # Prepare plot of wind speed (similar to plotonline)
  # #######################################################
  #
  field=sqrt(u*u+v*v)
  #
  if (flaginc<0.5) {
    brks   = brks_windspeed
    cols   = cols_windspeed
    namebr = name_windspeed
  } else {
    brks   = brks_windspeed_diff
    cols   = cols_windspeed_diff
    namebr = name_windspeed_diff
  }
  #
  # Convert field into classes
  #
  fieldclasses=array(NA,length(field))
  for (ii in 2:length(brks)) {
    ind=which((field>=brks[ii-1])&(field<brks[ii]))
    fieldclasses[ind]=ii-1
  }
  field=as.vector(fieldclasses)
  brks=seq(0.5,max(field,na.rm=TRUE)+0.5,1)
  #
  cexall=1.2
  #
  # Write values onto raster
  #
  lons_unique=unique(x)
  lats_unique=unique(y)
  #
  dy_vec=array(NA,(length(lats_unique)-1))
  dx_vec=array(NA,(length(lons_unique)-1))
  #
  for (ii in 2:length(lons_unique)) dx_vec[ii-1] = lons_unique[ii]-lons_unique[ii-1]
  for (ii in 2:length(lats_unique)) dy_vec[ii-1] = lats_unique[ii]-lats_unique[ii-1]
  #
  dx=mean(dx_vec);dy=mean(dy_vec)
  lonmin=min(x);lonmax=max(x);latmin=min(y);latmax=max(y)
  #
  nyp=length(which(x==lonmin))
  nxp=length(which(y==latmin))
  #
  fieldrev=as.vector(length(field))
  #
  for (ii in 1:nyp) {
    indbeg=1+(ii-1)*nxp
    indend=ii*nxp
    fieldrev[indbeg:indend]=rev(field[indbeg:indend])
  }
  field=fieldrev
  #
  exte=c(lonmin-0.50*dx,lonmax+0.50*dx,latmin-0.50*dy,latmax+0.50*dy)
  #
  rast_plot=raster(extent(exte))
  projection(rast_plot) = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs +towgs84=0,0,0"
  res(rast_plot) = c(dx,dy)
  #
  vec_check=getValues(rast_plot)
  #
  if (length(vec_check)!=length(field)) {
    print(length(vec_check))
    print(length(field))
    stop("Inconsistant length of vectors")
  }
  #
  rast_plot=setValues(rast_plot,rev(field))
  #
  # #########################################################
  # Preparation for plot of arrows
  # Assuming a squared grid
  # #########################################################
  #
  # Not more than ~30x30=900 wind vectors can be displayed in a reasonable manner
  #
  xmin=min(x)
  xmax=max(x)
  xinc=(xmax-xmin)/40
  xvals=seq(xmin,xmax,xinc)
  #
  ymin=min(y)
  ymax=max(y)
  yinc=(ymax-ymin)/40
  yvals=seq(ymin,ymax,yinc)
  #
  indsel=c()
  #
  for (ii in 1:length(xvals)) for (jj in 1:length(yvals)) {
    distance=sqrt((x-xvals[ii])**2+(y-yvals[jj])**2)
    mindist=min(distance)
    ind=which(distance==mindist)
    ind=ind[1]
    indsel=c(indsel,ind)
  }
  #
  # Select grid points
  #
  x=x[indsel]
  y=y[indsel]
  u=u[indsel]
  v=v[indsel]
  #
  if (sum(is.na(x))>0.5) {print(sum(is.na(x)));stop("Wrong entry for selected variables in quiver plot")}
  if (sum(is.na(y))>0.5) {print(sum(is.na(y)));stop("Wrong entry for selected variables in quiver plot")}
  if (sum(is.na(u))>0.5) {print(sum(is.na(u)));stop("Wrong entry for selected variables in quiver plot")}
  if (sum(is.na(v))>0.5) {print(sum(is.na(v)));stop("Wrong entry for selected variables in quiver plot")}
  #
  xdiff=max(x)-min(x)
  scale=0.005*xdiff
  length=0.05
  #
  # ##########################################################
  # Plot wind speed and arrows
  # ##########################################################
  #
  pdf(nameplot,width=7,height=7)
  par(mar=c(3,3,1.0,0.5))
  par(oma=c(0,0,0,3))
  #
  # Plot wind speed
  #
  arg=list(at=seq(1,length(namebr),1),labels=namebr,line=0,cex.axis=0.9)
  #
  plot(rast_plot,breaks=brks,col=cols,axis.args=arg,xlab=NA,ylab=NA,
       cex.axis=cexall,cex.lab=cexall,alpha=1,colNA="white",add=FALSE,
       useRaster=TRUE,interpolate=FALSE)
  #
  title("")
  mtext("Wind speed and direction",col="black",side=4,line=1.0,adj=0.5,outer=TRUE,cex=cexall)
  #
  # Plot quivers
  #
  quiver(x,y,u,v,scale=scale,angle=angle,length=length)
  garbage <- dev.off()
  #
}
#
# ##################################################################
# Calculate and plot utci statisitcs
# ##################################################################
#
se_stat_utci=function(utci,name,name_seas) {
  #
  # #################################################### 
  # Hardcoded settings for the UTCI assessment scale
  # ####################################################
  #
  nams_utci=c("ExCS","VSCS","StCS","MoCS","SlCS","NoTS","MoHS","StHS","VSHS","ExHS")
  #
  cols_utci=array(NA,length(nams_utci))
  cols_utci[01]=col2hex("blueviolet")
  cols_utci[02]=col2hex("blue4")
  cols_utci[03]=col2hex("blue1")
  cols_utci[04]=col2hex("dodgerblue")
  cols_utci[05]=col2hex("cyan")
  cols_utci[06]=col2hex("green")
  cols_utci[07]=col2hex("orange")
  cols_utci[08]=col2hex("orangered")
  cols_utci[09]=col2hex("red1")
  cols_utci[10]=col2hex("red4")
  #
  brks_utci=c(-100,-40,-27,-13,0,9,26,32,38,46,100)
  #
  # #################################################### 
  # Calculate UTCI classes
  # ####################################################
  #
  DIM=dim(utci)
  nseas=DIM[1]
  #
  freqs_cum=array(0.0,c(nseas,length(cols_utci)+1))
  #
  for (seas in 1:nseas) {
    #
    utci_sel=na.omit(utci[seas,])
    #
    amax=max(utci_sel)
    amin=min(utci_sel)
    #
    if (amax>(+100)) {print(amax);stop("Unplausible value of utci")}
    if (amin<(-100)) {print(amin);stop("Unplausible value of utci")}
    #
    # Calculate frequency of classes
    #
    freqs_utci=array(NA,length(cols_utci))
    for (ii in 1:length(cols_utci)) freqs_utci[ii]=length(which((utci_sel>=brks_utci[ii])&(utci_sel<brks_utci[ii+1])))/length(utci_sel)
    #
    ctl=sum(freqs_utci)
    if (abs(ctl-1.0)>1.0e-8) stop("Wrong UTCI fractions")
    #
    for (ii in 1:(length(freqs_utci))) freqs_cum[seas,ii+1]=freqs_cum[seas,ii]+freqs_utci[ii]
    #
  }
  #
  # Create a plot displaying the UTCI fractions
  #
  marp=c(0.2,0.2,1.5,0.2)
  marc=c(2.5,0.1,0.5,0.1)
  #
  # The number of panels in one row
  #
  npanel=nseas
  #
  # The number of columns of the plot
  #
  ncol=1
  #
  pdf(name,height=2*ncol,width=0.5*npanel)
  #
  mat=array(NA,c(ncol,npanel+1))
  for (jj in 1:ncol) for (ii in 1:(npanel+1)) mat[jj,ii]=4*(jj-1)+ii
  #
  widthsvec=c(rep(1,npanel),2.8)
  #
  par(mar=c(3.0,3.0,1.0,1.0),mgp=c(2.0,0.7,0.0),las=1)
  layout(mat,widths=widthsvec,heights=1)
  #
  # Loop over cases to plot
  #
  for (ii in 1:nseas) {
    #
    par(mar=marp)
    #
    plot.new()
    plot.window(xlim=c(0,0.2),ylim=c(0,1),xaxs="i",yaxs="i")
    #
    for (j in 1:length(cols_utci)) {
      xij=c(0,0.2,0.2,0)
      yij=c(freqs_cum[ii,j],freqs_cum[ii,j],freqs_cum[ii,j+1],freqs_cum[ii,j+1])
      cij=cols_utci[j]
      polygon(xij,yij,col=cij,border=NA)
    }
    #
    abline(h=freqs_cum[ii,],lty=1,lwd=0.6)
    abline(v=0.0,lty=1,lwd=0.6)
    abline(v=0.2,lty=1,lwd=0.6)
    title(main=name_seas[ii],col.lab=rgb(0,0.0,0),cex.main=0.6)
    #
  }
  #
  par(mar=marc)
  mycolorbar(cols_utci,nams_utci,horiz=F,cex=0.8,width=0.30,ltext=1)
  text(0.9,5,labels="UTCI class",cex=0.8,srt=90)
  #
  garbage <- dev.off()
  #
}
#
# ##############################################
# Creation of 2D maps of OFFLINE results
# ##############################################
#
seplotoffline=function(name,nrows,ncols,XCELLSIZE,NBEMCOMP,xaxis,yaxis,xaxis_km,yaxis_km,pgdfield) {
#
fileprep=paste(pdata,name,"/Basic",sep="")
load(file=fileprep)
#
ndim=LST$ndim
nday=LST$nday
raster=LST$raster
datejulvecout=LST$datejulvecout
#
# Create folder for time series and diurnal cycle plots
#
filebase=paste(ppday,name,sep="")
system(paste("rm -Rf",filebase))
system(paste("mkdir",filebase))
#
filebase=paste(ppcyc,name,sep="")
system(paste("rm -Rf",filebase))
system(paste("mkdir",filebase))
#
# ##############################################################
# Load and convert data
# ##############################################################
#
# Extract fractions read from pgd and check sum 
# CAUTION: FRAC_SEA is not implemented at the moment
#
frac_wat=pgdfield[which(pgdvec=="&FULL   FRAC_WATER"),]
frac_tow=pgdfield[which(pgdvec=="&FULL   FRAC_TOWN"),]
frac_nat=pgdfield[which(pgdvec=="&FULL   FRAC_NATURE"),]
#
if (length(which(is.na(frac_wat)))>0) stop("NA in water fraction")
if (length(which(is.na(frac_tow)))>0) stop("NA in town fraction")
if (length(which(is.na(frac_nat)))>0) stop("NA in nature fraction")
#
ctl=frac_wat+frac_tow+frac_nat
if (max(abs(ctl-1.0))>1.0e-6) {print(max(abs(ctl-1.0)));stop("Wrong fractions of surface covers")}
# 
# Find position of CAPITOUL mast grid cell
#
# Get coordinates of TEB-Offline simulation (in km relative to domain boundary)
#
xcor=pgdfield[which(pgdvec=="&FULL   XX"),]
ycor=pgdfield[which(pgdvec=="&FULL   XY"),]
#
# Hardcoded position of the mast (Lambert 93)
#
xmast = 0574459.0
ymast = 6279496.0
#
# Load fluxes and calculate grid cell averages H, LE and RN
#
fileprep=paste(pdata,name,"/H_TEB",sep="")
if (file.exists(fileprep)) {load(file=fileprep);h_teb_dcyc=LST$outdaycyc;h_teb_daya=LST$outdayav}
#
DIM_dcyc=dim(h_teb_dcyc)
DIM_daya=dim(h_teb_daya)
#
fileprep=paste(pdata,name,"/LE_TEB",sep="")
if (file.exists(fileprep)) {load(file=fileprep);l_teb_dcyc=LST$outdaycyc;l_teb_daya=LST$outdayav}
#
fileprep=paste(pdata,name,"/RN_TEB",sep="")
if (file.exists(fileprep)) {load(file=fileprep);r_teb_dcyc=LST$outdaycyc;r_teb_daya=LST$outdayav}
#
fileprep=paste(pdata,name,"/H_ISBA",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  h_isb_dcyc=LST$outdaycyc
  h_isb_daya=LST$outdayav
} else {
  h_isb_week=NA
  h_isb_dcyc=array(0,DIM_dcyc)
  h_isb_daya=array(0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/LE_ISBA",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  l_isb_dcyc=LST$outdaycyc
  l_isb_daya=LST$outdayav
} else {
  l_isb_week=NA
  l_isb_dcyc=array(0,DIM_dcyc)
  l_isb_daya=array(0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/RN_ISBA",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  r_isb_dcyc=LST$outdaycyc
  r_isb_daya=LST$outdayav
} else {
  r_isb_week=NA
  r_isb_dcyc=array(0,DIM_dcyc)
  r_isb_daya=array(0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/H_WAT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  h_wat_dcyc=LST$outdaycyc
  h_wat_daya=LST$outdayav
} else {
  r_wat_week=NA
  h_wat_dcyc=array(0,DIM_dcyc)
  h_wat_daya=array(0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/LE_WAT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  l_wat_dcyc=LST$outdaycyc
  l_wat_daya=LST$outdayav
} else {
  l_wat_week=NA
  l_wat_dcyc=array(0,DIM_dcyc)
  l_wat_daya=array(0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/RN_WAT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  r_wat_dcyc=LST$outdaycyc
  r_wat_daya=LST$outdayav
} else {
  r_wat_week=NA
  r_wat_dcyc=array(0,DIM_dcyc)
  r_wat_daya=array(0,DIM_daya)
}
#
h_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
l_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
r_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
#
for (ii in 1:length(namseas)) for (jj in 1:(1/incdateout)) {
  h_dcyc_cell[ii,,jj]=h_teb_dcyc[ii,,jj]*frac_tow+h_isb_dcyc[ii,,jj]*frac_nat+h_wat_dcyc[ii,,jj]*frac_wat
  l_dcyc_cell[ii,,jj]=l_teb_dcyc[ii,,jj]*frac_tow+l_isb_dcyc[ii,,jj]*frac_nat+l_wat_dcyc[ii,,jj]*frac_wat
  r_dcyc_cell[ii,,jj]=r_teb_dcyc[ii,,jj]*frac_tow+r_isb_dcyc[ii,,jj]*frac_nat+r_wat_dcyc[ii,,jj]*frac_wat
}
#
h_daya_cell=array(NA,c(ndim,nday))
l_daya_cell=array(NA,c(ndim,nday))
r_daya_cell=array(NA,c(ndim,nday))
#
for (ii in 1:nday) {
  h_daya_cell[,ii]=h_teb_daya[,ii]*frac_tow+h_isb_daya[,ii]*frac_nat+h_wat_daya[,ii]*frac_wat
  l_daya_cell[,ii]=l_teb_daya[,ii]*frac_tow+l_isb_daya[,ii]*frac_nat+l_wat_daya[,ii]*frac_wat
  r_daya_cell[,ii]=r_teb_daya[,ii]*frac_tow+r_isb_daya[,ii]*frac_nat+r_wat_daya[,ii]*frac_wat
}
#
# Extract all variables related to CO2 emissions and multiply with the town fraction
#
fileprep=paste(pdata,name,"/SFCO2_T_BLD",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  co2_bld_week=LST$outweekcyc
  co2_bld_dcyc=LST$outdaycyc
  co2_bld_daya=LST$outdayav
} else {
  co2_bld_week=NA
  co2_bld_dcyc=array(NA,DIM_dcyc)
  co2_bld_daya=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/SFCO2_T_POP",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  co2_pop_week=LST$outweekcyc
  co2_pop_dcyc=LST$outdaycyc
  co2_pop_daya=LST$outdayav
} else {
  co2_pop_week=NA
  co2_pop_dcyc=array(NA,DIM_dcyc)
  co2_pop_daya=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/SFCO2_T_RD",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  co2_tra_week=LST$outweekcyc
  co2_tra_dcyc=LST$outdaycyc
  co2_tra_daya=LST$outdayav
} else {
  co2_tra_week=NA
  co2_tra_dcyc=array(NA,DIM_dcyc)
  co2_tra_daya=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/SFCO2_T_VEG",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  co2_veg_week=LST$outweekcyc
  co2_veg_dcyc=LST$outdaycyc
  co2_veg_daya=LST$outdayav
} else {
  co2_veg_week=NA
  co2_veg_dcyc=array(NA,DIM_dcyc)
  co2_veg_daya=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/SFCO2_T",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  co2_tot_week=LST$outweekcyc
  co2_tot_dcyc=LST$outdaycyc
  co2_tot_daya=LST$outdayav
} else {
  co2_tot_week=NA
  co2_tot_dcyc=array(NA,DIM_dcyc)
  co2_tot_daya=array(NA,DIM_daya)
}
#
# Set missing values to NA
#
co2_bld_dcyc[which(co2_bld_dcyc>1.0E+10)]=NA
co2_pop_dcyc[which(co2_pop_dcyc>1.0E+10)]=NA
co2_tra_dcyc[which(co2_tra_dcyc>1.0E+10)]=NA
co2_veg_dcyc[which(co2_veg_dcyc>1.0E+10)]=NA
co2_tot_dcyc[which(co2_tot_dcyc>1.0E+10)]=NA
#
co2_bld_daya[which(co2_bld_daya>1.0E+10)]=NA
co2_pop_daya[which(co2_pop_daya>1.0E+10)]=NA
co2_tra_daya[which(co2_tra_daya>1.0E+10)]=NA
co2_veg_daya[which(co2_veg_daya>1.0E+10)]=NA
co2_tot_daya[which(co2_tot_daya>1.0E+10)]=NA
#
co2_bld_week[which(co2_bld_week>1.0E+10)]=NA
co2_pop_week[which(co2_pop_week>1.0E+10)]=NA
co2_tra_week[which(co2_tra_week>1.0E+10)]=NA
co2_veg_week[which(co2_veg_week>1.0E+10)]=NA
co2_tot_week[which(co2_tot_week>1.0E+10)]=NA
#
# Multiply with town fraction and conversion between kg/m²/s and micromoles/m²/s
#
cof=1.0e+6*1000/(12+2*16)
#
# Daily cycles
#
co2_bld_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
co2_pop_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
co2_tra_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
co2_veg_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
co2_tot_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
#
for (ii in 1:length(namseas)) for (jj in 1:(1/incdateout)) {
  co2_bld_dcyc_cell[ii,,jj] = cof * co2_bld_dcyc[ii,,jj] * frac_tow
  co2_pop_dcyc_cell[ii,,jj] = cof * co2_pop_dcyc[ii,,jj] * frac_tow
  co2_tra_dcyc_cell[ii,,jj] = cof * co2_tra_dcyc[ii,,jj] * frac_tow
  co2_veg_dcyc_cell[ii,,jj] = cof * co2_veg_dcyc[ii,,jj] * frac_tow
  co2_tot_dcyc_cell[ii,,jj] = cof * co2_tot_dcyc[ii,,jj] * frac_tow
}
#
# Weekly cycles
#
co2_bld_week_cell=array(NA,c(2,ndim,7))
co2_pop_week_cell=array(NA,c(2,ndim,7))
co2_tra_week_cell=array(NA,c(2,ndim,7))
co2_veg_week_cell=array(NA,c(2,ndim,7))
co2_tot_week_cell=array(NA,c(2,ndim,7))
#
for (ii in 1:2) for (jj in 1:7) {
  co2_bld_week_cell[ii,,jj] = cof * co2_bld_week[ii,,jj] * frac_tow
  co2_pop_week_cell[ii,,jj] = cof * co2_pop_week[ii,,jj] * frac_tow
  co2_tra_week_cell[ii,,jj] = cof * co2_tra_week[ii,,jj] * frac_tow
  co2_veg_week_cell[ii,,jj] = cof * co2_veg_week[ii,,jj] * frac_tow
  co2_tot_week_cell[ii,,jj] = cof * co2_tot_week[ii,,jj] * frac_tow
}
#
# Daily averages
#
co2_bld_daya_cell=array(NA,c(ndim,nday))
co2_pop_daya_cell=array(NA,c(ndim,nday))
co2_tra_daya_cell=array(NA,c(ndim,nday))
co2_veg_daya_cell=array(NA,c(ndim,nday))
co2_tot_daya_cell=array(NA,c(ndim,nday))
#
for (ii in 1:nday) {
  co2_bld_daya_cell[,ii]=cof*co2_bld_daya[,ii]*frac_tow
  co2_pop_daya_cell[,ii]=cof*co2_pop_daya[,ii]*frac_tow
  co2_tra_daya_cell[,ii]=cof*co2_tra_daya[,ii]*frac_tow
  co2_veg_daya_cell[,ii]=cof*co2_veg_daya[,ii]*frac_tow
  co2_tot_daya_cell[,ii]=cof*co2_tot_daya[,ii]*frac_tow
}
#
# ################################################################
# Extract all variables related to the anthropogenic heat flux
# and multiply with the town fraction
# ################################################################
#
fileprep=paste(pdata,name,"/SENFABSTOR",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  senfab_dcyc=LST$outdaycyc
  senfab_daya=LST$outdayav
} else {
  senfab_dcyc=array(0.0,DIM_dcyc)
  senfab_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/HVAC_HT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  hvacht_week=LST$outweekcyc
  hvacht_dcyc=LST$outdaycyc
  hvacht_daya=LST$outdayav
} else {
  hvacht_week=NA
  hvacht_dcyc=array(0.0,DIM_dcyc)
  hvacht_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/HVAC_CL",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  hvaccl_week=LST$outweekcyc
  hvaccl_dcyc=LST$outdaycyc
  hvaccl_daya=LST$outdayav
} else {
  hvaccl_week=NA
  hvaccl_dcyc=array(0.0,DIM_dcyc)
  hvaccl_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/H_TRAACT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  h_traf_week=LST$outweekcyc  
  h_traf_dcyc=LST$outdaycyc
  h_traf_daya=LST$outdayav
} else {
  h_traf_week=NA
  h_traf_dcyc=array(0.0,DIM_dcyc)
  h_traf_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/LE_TRAACT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  l_traf_week=LST$outweekcyc 
  l_traf_dcyc=LST$outdaycyc
  l_traf_daya=LST$outdayav
} else {
  l_traf_week=NA
  l_traf_dcyc=array(0.0,DIM_dcyc)
  l_traf_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/H_INDACT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  h_indu_week=LST$outweekcyc 
  h_indu_dcyc=LST$outdaycyc
  h_indu_daya=LST$outdayav
} else {
  h_indu_week=NA
  h_indu_dcyc=array(0.0,DIM_dcyc)
  h_indu_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/LE_INDACT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  l_indu_week=LST$outweekcyc
  l_indu_dcyc=LST$outdaycyc
  l_indu_daya=LST$outdayav
} else {
  l_indu_week=NA
  l_indu_dcyc=array(0.0,DIM_dcyc)
  l_indu_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/QINACT",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  qinact_week=LST$outweekcyc
  qinact_dcyc=LST$outdaycyc
  qinact_daya=LST$outdayav
} else {
  qinact_week=NA
  qinact_dcyc=array(0.0,DIM_dcyc)
  qinact_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/QINHOTW",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  qinhot_week=LST$outweekcyc
  qinhot_dcyc=LST$outdaycyc
  qinhot_daya=LST$outdayav
} else {
  qinhot_week=NA
  qinhot_dcyc=array(0.0,DIM_dcyc)
  qinhot_daya=array(0.0,DIM_daya)
}
#
# TEB UTCI
#
fileprep=paste(pdata,name,"/UTCIMSU_TEB",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  utci_outsun_dcyc=LST$outdaycyc
  utci_outsun_daya=LST$outdayav
} else {
  utci_outsun_dcyc=array(0.0,DIM_dcyc)
  utci_outsun_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/UTCIMSH_TEB",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  utci_outshade_dcyc=LST$outdaycyc
  utci_outshade_daya=LST$outdayav
} else {
  utci_outshade_dcyc=array(0.0,DIM_dcyc)
  utci_outshade_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TRADMSU_TEB",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  trad_sun_dcyc=LST$outdaycyc
  trad_sun_daya=LST$outdayav
}
else {
  trad_sun_dcyc=array(0.0,DIM_dcyc)
  trad_sun_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TRADMSH_TEB",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  trad_shade_dcyc=LST$outdaycyc
  trad_shade_daya=LST$outdayav
} else {
  trad_shade_dcyc=array(0.0,DIM_dcyc)
  trad_shade_daya=array(0.0,DIM_daya)
}
#
# ISBA UTCI
#
fileprep=paste(pdata,name,"/UTCIMSU_ISBA",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  utci_isb_sun_dcyc=LST$outdaycyc
  utci_isb_sun_daya=LST$outdayav
} else {
  utci_isb_sun_dcyc=array(0.0,DIM_dcyc)
  utci_isb_sun_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/UTCIMSH_ISBA",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  utci_isb_sha_dcyc=LST$outdaycyc
  utci_isb_sha_daya=LST$outdayav
} else {
  utci_isb_sha_dcyc=array(0.0,DIM_dcyc)
  utci_isb_sha_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TRADMSU_ISBA",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  trad_isb_sun_dcyc=LST$outdaycyc
  trad_isb_sun_daya=LST$outdayav
} else {
  trad_isb_sun_dcyc=array(0.0,DIM_dcyc)
  trad_isb_sun_daya=array(0.0,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TRADMSH_ISBA",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  trad_isb_shade_dcyc=LST$outdaycyc
  trad_isb_shade_daya=LST$outdayav
} else {
  trad_isb_shade_dcyc=array(0.0,DIM_dcyc)
  trad_isb_shade_daya=array(0.0,DIM_daya)
}
#
utci_outsun_dcyc[which(utci_outsun_dcyc>1.0E+10)]=NA
utci_outshade_dcyc[which(utci_outshade_dcyc>1.0E+10)]=NA
trad_shade_dcyc[which(trad_shade_dcyc>1.0E+10)]=NA
trad_sun_dcyc[which(trad_sun_dcyc>1.0E+10)]=NA
utci_isb_sha_dcyc[which(utci_isb_sha_dcyc>1.0E+10)]=NA
utci_isb_sun_dcyc[which(utci_isb_sun_dcyc>1.0E+10)]=NA
trad_isb_sun_dcyc[which(trad_isb_sun_dcyc>1.0E+10)]=NA
trad_isb_shade_dcyc[which(trad_isb_shade_dcyc>1.0E+10)]=NA
#
utci_outsun_daya[which(utci_outsun_daya>1.0E+10)]=NA
utci_outshade_daya[which(utci_outshade_daya>1.0E+10)]=NA
trad_shade_daya[which(trad_shade_daya>1.0E+10)]=NA
trad_sun_daya[which(trad_sun_daya>1.0E+10)]=NA
utci_isb_sha_daya[which(utci_isb_sha_daya>1.0E+10)]=NA
utci_isb_sun_daya[which(utci_isb_sun_daya>1.0E+10)]=NA
trad_isb_sun_daya[which(trad_isb_sun_daya>1.0E+10)]=NA
trad_isb_shade_daya[which(trad_isb_shade_daya>1.0E+10)]=NA
#
senfab_dcyc[which(senfab_dcyc>1.0E+10)]=NA
hvacht_dcyc[which(hvacht_dcyc>1.0E+10)]=NA
hvaccl_dcyc[which(hvaccl_dcyc>1.0E+10)]=NA
h_traf_dcyc[which(h_traf_dcyc>1.0E+10)]=NA
l_traf_dcyc[which(l_traf_dcyc>1.0E+10)]=NA
h_indu_dcyc[which(h_indu_dcyc>1.0E+10)]=NA
l_indu_dcyc[which(l_indu_dcyc>1.0E+10)]=NA
qinact_dcyc[which(qinact_dcyc>1.0E+10)]=NA
qinhot_dcyc[which(qinhot_dcyc>1.0E+10)]=NA
#
senfab_daya[which(senfab_daya>1.0E+10)]=NA
hvacht_daya[which(hvacht_daya>1.0E+10)]=NA
hvaccl_daya[which(hvaccl_daya>1.0E+10)]=NA
h_traf_daya[which(h_traf_daya>1.0E+10)]=NA
l_traf_daya[which(l_traf_daya>1.0E+10)]=NA
h_indu_daya[which(h_indu_daya>1.0E+10)]=NA
l_indu_daya[which(l_indu_daya>1.0E+10)]=NA
qinact_daya[which(qinact_daya>1.0E+10)]=NA
qinhot_daya[which(qinhot_daya>1.0E+10)]=NA
#
hvacht_week[which(hvacht_week>1.0E+10)]=NA
hvaccl_week[which(hvaccl_week>1.0E+10)]=NA
h_traf_week[which(h_traf_week>1.0E+10)]=NA
l_traf_week[which(l_traf_week>1.0E+10)]=NA
h_indu_week[which(h_indu_week>1.0E+10)]=NA
l_indu_week[which(l_indu_week>1.0E+10)]=NA
qinact_week[which(qinact_week>1.0E+10)]=NA
qinhot_week[which(qinhot_week>1.0E+10)]=NA
#
hvacht_week_cell=array(NA,c(2,ndim,7))
hvaccl_week_cell=array(NA,c(2,ndim,7))
h_traf_week_cell=array(NA,c(2,ndim,7))
l_traf_week_cell=array(NA,c(2,ndim,7))
h_indu_week_cell=array(NA,c(2,ndim,7))
l_indu_week_cell=array(NA,c(2,ndim,7))
qinact_week_cell=array(NA,c(2,ndim,7))
qinhot_week_cell=array(NA,c(2,ndim,7))
#
for (ii in 1:2) for (jj in 1:7) {
  hvacht_week_cell[ii,,jj]=hvacht_week[ii,,jj]*frac_tow
  hvaccl_week_cell[ii,,jj]=hvaccl_week[ii,,jj]*frac_tow
  h_traf_week_cell[ii,,jj]=h_traf_week[ii,,jj]*frac_tow
  l_traf_week_cell[ii,,jj]=l_traf_week[ii,,jj]*frac_tow
  h_indu_week_cell[ii,,jj]=h_indu_week[ii,,jj]*frac_tow
  l_indu_week_cell[ii,,jj]=l_indu_week[ii,,jj]*frac_tow
  qinact_week_cell[ii,,jj]=qinact_week[ii,,jj]*frac_tow
  qinhot_week_cell[ii,,jj]=qinhot_week[ii,,jj]*frac_tow 
}
#
senfab_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
hvacht_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
hvaccl_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
h_traf_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
l_traf_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
h_indu_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
l_indu_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
qinact_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
qinhot_dcyc_cell=array(NA,c(length(namseas),ndim,(1/incdateout)))
#
for (ii in 1:length(namseas)) for (jj in 1:(1/incdateout)) {
  senfab_dcyc_cell[ii,,jj]=senfab_dcyc[ii,,jj]*frac_tow
  hvacht_dcyc_cell[ii,,jj]=hvacht_dcyc[ii,,jj]*frac_tow
  hvaccl_dcyc_cell[ii,,jj]=hvaccl_dcyc[ii,,jj]*frac_tow
  h_traf_dcyc_cell[ii,,jj]=h_traf_dcyc[ii,,jj]*frac_tow
  l_traf_dcyc_cell[ii,,jj]=l_traf_dcyc[ii,,jj]*frac_tow
  h_indu_dcyc_cell[ii,,jj]=h_indu_dcyc[ii,,jj]*frac_tow
  l_indu_dcyc_cell[ii,,jj]=l_indu_dcyc[ii,,jj]*frac_tow
  qinact_dcyc_cell[ii,,jj]=qinact_dcyc[ii,,jj]*frac_tow
  qinhot_dcyc_cell[ii,,jj]=qinhot_dcyc[ii,,jj]*frac_tow 
}
#
senfab_daya_cell=array(NA,c(ndim,nday))
hvacht_daya_cell=array(NA,c(ndim,nday))
hvaccl_daya_cell=array(NA,c(ndim,nday))
h_traf_daya_cell=array(NA,c(ndim,nday))
l_traf_daya_cell=array(NA,c(ndim,nday))
h_indu_daya_cell=array(NA,c(ndim,nday))
l_indu_daya_cell=array(NA,c(ndim,nday))
qinact_daya_cell=array(NA,c(ndim,nday))
qinhot_daya_cell=array(NA,c(ndim,nday))
#
for (ii in 1:nday) {
  senfab_daya_cell[,ii]=senfab_daya[,ii]*frac_tow
  hvacht_daya_cell[,ii]=hvacht_daya[,ii]*frac_tow
  hvaccl_daya_cell[,ii]=hvaccl_daya[,ii]*frac_tow
  h_traf_daya_cell[,ii]=h_traf_daya[,ii]*frac_tow
  l_traf_daya_cell[,ii]=l_traf_daya[,ii]*frac_tow
  h_indu_daya_cell[,ii]=h_indu_daya[,ii]*frac_tow
  l_indu_daya_cell[,ii]=l_indu_daya[,ii]*frac_tow
  qinact_daya_cell[,ii]=qinact_daya[,ii]*frac_tow
  qinhot_daya_cell[,ii]=qinhot_daya[,ii]*frac_tow  
}
#
# Check whether all contributions are larger than 0.0
#
if (min(h_traf_dcyc_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(l_traf_dcyc_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(h_indu_dcyc_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(l_indu_dcyc_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(hvacht_dcyc_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(hvaccl_dcyc_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(qinact_dcyc_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(qinhot_dcyc_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
#
if (min(h_traf_daya_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(l_traf_daya_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(h_indu_daya_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(l_indu_daya_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(hvacht_daya_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(hvaccl_daya_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(qinact_daya_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(qinhot_daya_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
#
if (min(h_traf_week_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(l_traf_week_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(h_indu_week_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(l_indu_week_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(hvacht_week_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(hvaccl_week_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(qinact_week_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
if (min(qinhot_week_cell,na.rm=TRUE)<0.0) stop("Negative value for anthropogenic heat release")
#
# Calculation of the total anthropogenic heat release
# CAUTION: It contains both sensible and latent part
#
qantot_dcyc_cell=h_traf_dcyc_cell + l_traf_dcyc_cell +
                 h_indu_dcyc_cell + l_indu_dcyc_cell +
                 hvacht_dcyc_cell + hvaccl_dcyc_cell +
		 qinact_dcyc_cell + qinhot_dcyc_cell
#
qantot_daya_cell=h_traf_daya_cell + l_traf_daya_cell +
                 h_indu_daya_cell + l_indu_daya_cell +
                 hvacht_daya_cell + hvaccl_daya_cell +
                 qinact_daya_cell + qinhot_daya_cell
#
qantot_week_cell=h_traf_week_cell + l_traf_week_cell +
                 h_indu_week_cell + l_indu_week_cell +
                 hvacht_week_cell + hvaccl_week_cell +
                 qinact_week_cell + qinhot_week_cell
#
# Save the values related to the anthropogenic heat release
#
LST=list(h_traf_dcyc_cell=h_traf_dcyc_cell,l_traf_dcyc_cell=l_traf_dcyc_cell,
         h_indu_dcyc_cell=h_indu_dcyc_cell,l_indu_dcyc_cell=l_indu_dcyc_cell,
         hvacht_dcyc_cell=hvacht_dcyc_cell,hvaccl_dcyc_cell=hvaccl_dcyc_cell,
         qinact_dcyc_cell=qinact_dcyc_cell,qinhot_dcyc_cell=qinhot_dcyc_cell,
	 qantot_dcyc_cell=qantot_dcyc_cell,
         h_traf_daya_cell=h_traf_daya_cell,l_traf_daya_cell=l_traf_daya_cell,
         h_indu_daya_cell=h_indu_daya_cell,l_indu_daya_cell=l_indu_daya_cell,
         hvacht_daya_cell=hvacht_daya_cell,hvaccl_daya_cell=hvaccl_daya_cell,
         qinact_daya_cell=qinact_daya_cell,qinhot_daya_cell=qinhot_daya_cell,
	 qantot_daya_cell=qantot_daya_cell,
         h_traf_week_cell=h_traf_week_cell,l_traf_week_cell=l_traf_week_cell,
         h_indu_week_cell=h_indu_week_cell,l_indu_week_cell=l_indu_week_cell,
         hvacht_week_cell=hvacht_week_cell,hvaccl_week_cell=hvaccl_week_cell,
         qinact_week_cell=qinact_week_cell,qinhot_week_cell=qinhot_week_cell,
	 qantot_week_cell=qantot_week_cell,
	 raster=raster,xaxis=xaxis,yaxis=yaxis,xaxis_km=xaxis_km,
	 yaxis_km=yaxis_km,ncols=ncols,nrows=nrows)
#
fileqantraster=paste(pdata,name,"/QANT_RASTERS",sep="")
save(LST,file=fileqantraster)
#
# Extract other values that dont need to be averaged
#
fileprep=paste(pdata,name,"/TCANYON",sep="")
if (file.exists(fileprep)) {load(file=fileprep);tcan_dcyc_cell=LST$outdaycyc;tcan_daya_cell=LST$outdayav}
#
fileprep=paste(pdata,name,"/QCANYON",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  qcan_dcyc_cell=LST$outdaycyc
  qcan_daya_cell=LST$outdayav
} else {
  qcan_dcyc_cell=array(NA,DIM_dcyc)
  qcan_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/U_LOWCAN",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  ulca_dcyc_cell=LST$outdaycyc
  ulca_daya_cell=LST$outdayav
} else {
  ulca_dcyc_cell=array(NA,DIM_dcyc)
  ulca_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/INFCALC",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  infc_dcyc_cell=LST$outdaycyc
  infc_daya_cell=LST$outdayav
} else {
  infc_dcyc_cell=array(NA,DIM_dcyc)
  infc_daya_cell=array(NA,DIM_daya)
}
#
for (tt in 1:NBEMCOMP) {
  #
  if (tt==1) {
    #
    utin_dcyc_cell=array(NA,c(DIM_dcyc,NBEMCOMP))
    utin_daya_cell=array(NA,c(DIM_daya,NBEMCOMP))
    #
    tibd_dcyc_cell=array(NA,c(DIM_dcyc,NBEMCOMP))
    tibd_daya_cell=array(NA,c(DIM_daya,NBEMCOMP))
    #
    shad_dcyc_cell=array(NA,c(DIM_dcyc,NBEMCOMP))
    shad_daya_cell=array(NA,c(DIM_daya,NBEMCOMP))
    #
    vent_dcyc_cell=array(NA,c(DIM_dcyc,NBEMCOMP))
    vent_daya_cell=array(NA,c(DIM_daya,NBEMCOMP))
    #
    vefl_dcyc_cell=array(NA,c(DIM_dcyc,NBEMCOMP))
    vefl_daya_cell=array(NA,c(DIM_daya,NBEMCOMP))
    #
    bldo_dcyc_cell=array(NA,c(DIM_dcyc,NBEMCOMP))
    bldo_daya_cell=array(NA,c(DIM_daya,NBEMCOMP))
    #
  }
  #
  fileprep=paste(pdata,name,"/UTCI_IN_",tt,sep="")
  if (file.exists(fileprep)) {
    load(file=fileprep)
    utin_dcyc_cell[,,,tt] = LST$outdaycyc
    utin_daya_cell[,,tt]  = LST$outdayav
  }
  #
  fileprep=paste(pdata,name,"/TIBLD",tt,sep="")
  if (file.exists(fileprep)) {
    load(file=fileprep)
    tibd_dcyc_cell[,,,tt] = LST$outdaycyc
    tibd_daya_cell[,,tt]  = LST$outdayav
  }
  #
  fileprep=paste(pdata,name,"/DIAGSHAD",tt,sep="")
  if (file.exists(fileprep)) {
    load(file=fileprep)
    shad_dcyc_cell[,,,tt]=LST$outdaycyc
    shad_daya_cell[,,tt]=LST$outdayav
  }
  #
  fileprep=paste(pdata,name,"/DIAGVENT",tt,sep="")
  if (file.exists(fileprep)) {
    load(file=fileprep)
    vent_dcyc_cell[,,,tt]=LST$outdaycyc
    vent_daya_cell[,,tt]=LST$outdayav
  }
  #
  fileprep=paste(pdata,name,"/DIAGVEFL",tt,sep="")
  if (file.exists(fileprep)) {
    load(file=fileprep)
    vefl_dcyc_cell[,,,tt]=LST$outdaycyc
    vefl_daya_cell[,,tt]=LST$outdayav
  }
  #
  fileprep=paste(pdata,name,"/BLDOCC",tt,sep="")
  #
  if (file.exists(fileprep)) {
    load(file=fileprep)
    bldo_dcyc_cell[,,,tt]=LST$outdaycyc
    bldo_daya_cell[,,tt]=LST$outdayav
  }
  #
}
#
fileprep=paste(pdata,name,"/TROAD1",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  rod1_dcyc_cell=LST$outdaycyc
  rod1_daya_cell=LST$outdayav
} else {
  rod1_dcyc_cell=array(NA,DIM_dcyc)
  rod1_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/ROAD_SHADE",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  rsha_dcyc_cell=LST$outdaycyc
  rsha_daya_cell=LST$outdayav
} else {
  rsha_dcyc_cell=array(NA,DIM_dcyc)
  rsha_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TROAD6",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  rod6_dcyc_cell=LST$outdaycyc
  rod6_daya_cell=LST$outdayav
} else {
  rod6_dcyc_cell=array(NA,DIM_dcyc)
  rod6_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TROOF1",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  rof1_dcyc_cell=LST$outdaycyc
  rof1_daya_cell=LST$outdayav
} else {
  rof1_dcyc_cell=array(NA,DIM_dcyc)
  rof1_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TROOF6",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  rof6_dcyc_cell=LST$outdaycyc
  rof6_daya_cell=LST$outdayav
} else {
  rof6_dcyc_cell=array(NA,DIM_dcyc)
  rof6_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TMASS1",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  mas1_dcyc_cell=LST$outdaycyc
  mas1_daya_cell=LST$outdayav
} else {
  mas1_dcyc_cell=array(NA,DIM_dcyc)
  mas1_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TMASS6",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  mas6_dcyc_cell=LST$outdaycyc
  mas6_daya_cell=LST$outdayav
} else {
  mas6_dcyc_cell=array(NA,DIM_dcyc)
  mas6_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TWALLA1",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  waa1_dcyc_cell=LST$outdaycyc
  waa1_daya_cell=LST$outdayav
} else {
  waa1_dcyc_cell=array(NA,DIM_dcyc)
  waa1_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TWALLA6",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  waa6_dcyc_cell=LST$outdaycyc
  waa6_daya_cell=LST$outdayav
} else {
  waa6_dcyc_cell=array(NA,DIM_dcyc)
  waa6_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TWALLB1",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  wab1_dcyc_cell=LST$outdaycyc
  wab1_daya_cell=LST$outdayav
} else {
  wab1_dcyc_cell=array(NA,DIM_dcyc)
  wab1_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TWALLB6",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  wab6_dcyc_cell=LST$outdaycyc
  wab6_daya_cell=LST$outdayav
} else {
  wab6_dcyc_cell=array(NA,DIM_dcyc)
  wab6_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TFLOO1",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  flo1_dcyc_cell=LST$outdaycyc
  flo1_daya_cell=LST$outdayav
} else {
  flo1_dcyc_cell=array(NA,DIM_dcyc)
  flo1_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/TFLOO6",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  flo6_dcyc_cell=LST$outdaycyc
  flo6_daya_cell=LST$outdayav
} else {
  flo6_dcyc_cell=array(NA,DIM_dcyc)
  flo6_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/ALB_ROOF",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  alrf_dcyc_cell=LST$outdaycyc
  alrf_daya_cell=LST$outdayav
} else {
  alrf_dcyc_cell=array(NA,DIM_dcyc)
  alrf_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/EMIS_ROOF",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  emrf_dcyc_cell=LST$outdaycyc
  emrf_daya_cell=LST$outdayav
} else {
  emrf_dcyc_cell=array(NA,DIM_dcyc)
  emrf_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/ALB_WALL",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  alwl_dcyc_cell=LST$outdaycyc
  alwl_daya_cell=LST$outdayav
} else {
  alwl_dcyc_cell=array(NA,DIM_dcyc)
  alwl_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/EMIS_WALL",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  emwl_dcyc_cell=LST$outdaycyc
  emwl_daya_cell=LST$outdayav
} else {
  emwl_dcyc_cell=array(NA,DIM_dcyc)
  emwl_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/ALB_ROAD",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  alrd_dcyc_cell=LST$outdaycyc
  alrd_daya_cell=LST$outdayav
} else {
  alrd_dcyc_cell=array(NA,DIM_dcyc)
  alrd_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/EMIS_ROAD",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  emrd_dcyc_cell=LST$outdaycyc
  emrd_daya_cell=LST$outdayav
} else {
  emrd_dcyc_cell=array(NA,DIM_dcyc)
  emrd_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/ROOFTK",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  rftk_dcyc_cell=LST$outdaycyc
  rftk_daya_cell=LST$outdayav
} else {
  rftk_dcyc_cell=array(NA,DIM_dcyc)
  rftk_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/WALLTK",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  wltk_dcyc_cell=LST$outdaycyc
  wltk_daya_cell=LST$outdayav
} else {
  wltk_dcyc_cell=array(NA,DIM_dcyc)
  wltk_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/MASSTK",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  matk_dcyc_cell=LST$outdaycyc
  matk_daya_cell=LST$outdayav
} else {
  matk_dcyc_cell=array(NA,DIM_dcyc)
  matk_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/H_WLA",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  hwla_dcyc_cell=LST$outdaycyc
  hwla_daya_cell=LST$outdayav
} else {
  hwla_dcyc_cell=array(NA,DIM_dcyc)
  hwla_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/H_WLB",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  hwlb_dcyc_cell=LST$outdaycyc
  hwlb_daya_cell=LST$outdayav
} else {
  hwlb_dcyc_cell=array(NA,DIM_dcyc)
  hwlb_daya_cell=array(NA,DIM_daya)
}
#
fileprep=paste(pdata,name,"/H_RF",sep="")
if (file.exists(fileprep)) {
  load(file=fileprep)
  hrof_dcyc_cell=LST$outdaycyc
  hrof_daya_cell=LST$outdayav
} else {
  hrof_dcyc_cell=array(NA,DIM_dcyc)
  hrof_daya_cell=array(NA,DIM_daya)
}
#
# For the variables defined only on the town grid,
# the missing data are set to NA
#
tcan_dcyc_cell[which(tcan_dcyc_cell>1.0E+10)]=NA
qcan_dcyc_cell[which(qcan_dcyc_cell>1.0E+10)]=NA
ulca_dcyc_cell[which(ulca_dcyc_cell>1.0E+10)]=NA
tibd_dcyc_cell[which(tibd_dcyc_cell>1.0E+10)]=NA
infc_dcyc_cell[which(infc_dcyc_cell>1.0E+10)]=NA
utin_dcyc_cell[which(utin_dcyc_cell>1.0E+10)]=NA
shad_dcyc_cell[which(shad_dcyc_cell>1.0E+10)]=NA
vent_dcyc_cell[which(vent_dcyc_cell>1.0E+10)]=NA
vefl_dcyc_cell[which(vefl_dcyc_cell>1.0E+10)]=NA
bldo_dcyc_cell[which(bldo_dcyc_cell>1.0E+10)]=NA
rsha_dcyc_cell[which(rsha_dcyc_cell>1.0E+10)]=NA
rod1_dcyc_cell[which(rod1_dcyc_cell>1.0E+10)]=NA
rod6_dcyc_cell[which(rod6_dcyc_cell>1.0E+10)]=NA
rof1_dcyc_cell[which(rof1_dcyc_cell>1.0E+10)]=NA
rof6_dcyc_cell[which(rof6_dcyc_cell>1.0E+10)]=NA
mas1_dcyc_cell[which(mas1_dcyc_cell>1.0E+10)]=NA
mas6_dcyc_cell[which(mas6_dcyc_cell>1.0E+10)]=NA
waa1_dcyc_cell[which(waa1_dcyc_cell>1.0E+10)]=NA
waa6_dcyc_cell[which(waa6_dcyc_cell>1.0E+10)]=NA
wab1_dcyc_cell[which(wab1_dcyc_cell>1.0E+10)]=NA
wab6_dcyc_cell[which(wab6_dcyc_cell>1.0E+10)]=NA
flo1_dcyc_cell[which(flo1_dcyc_cell>1.0E+10)]=NA
flo6_dcyc_cell[which(flo6_dcyc_cell>1.0E+10)]=NA
alrf_dcyc_cell[which(alrf_dcyc_cell>1.0E+10)]=NA
emrf_dcyc_cell[which(emrf_dcyc_cell>1.0E+10)]=NA
alrd_dcyc_cell[which(alrd_dcyc_cell>1.0E+10)]=NA
emrd_dcyc_cell[which(emrd_dcyc_cell>1.0E+10)]=NA
alwl_dcyc_cell[which(alwl_dcyc_cell>1.0E+10)]=NA
emwl_dcyc_cell[which(emwl_dcyc_cell>1.0E+10)]=NA
rftk_dcyc_cell[which(rftk_dcyc_cell>1.0E+10)]=NA
wltk_dcyc_cell[which(wltk_dcyc_cell>1.0E+10)]=NA
matk_dcyc_cell[which(matk_dcyc_cell>1.0E+10)]=NA
hwla_dcyc_cell[which(hwla_dcyc_cell>1.0E+10)]=NA
hwlb_dcyc_cell[which(hwlb_dcyc_cell>1.0E+10)]=NA
hrof_dcyc_cell[which(hrof_dcyc_cell>1.0E+10)]=NA
#
tcan_daya_cell[which(tcan_daya_cell>1.0E+10)]=NA
qcan_daya_cell[which(qcan_daya_cell>1.0E+10)]=NA
ulca_daya_cell[which(ulca_daya_cell>1.0E+10)]=NA
tibd_daya_cell[which(tibd_daya_cell>1.0E+10)]=NA
infc_daya_cell[which(infc_daya_cell>1.0E+10)]=NA
utin_daya_cell[which(utin_daya_cell>1.0E+10)]=NA
shad_daya_cell[which(shad_daya_cell>1.0E+10)]=NA
vent_daya_cell[which(vent_daya_cell>1.0E+10)]=NA
vefl_daya_cell[which(vefl_daya_cell>1.0E+10)]=NA
bldo_daya_cell[which(bldo_daya_cell>1.0E+10)]=NA
rsha_daya_cell[which(rsha_daya_cell>1.0E+10)]=NA
rod1_daya_cell[which(rod1_daya_cell>1.0E+10)]=NA
rod6_daya_cell[which(rod6_daya_cell>1.0E+10)]=NA
rof1_daya_cell[which(rof1_daya_cell>1.0E+10)]=NA
rof6_daya_cell[which(rof6_daya_cell>1.0E+10)]=NA
mas1_daya_cell[which(mas1_daya_cell>1.0E+10)]=NA
mas6_daya_cell[which(mas6_daya_cell>1.0E+10)]=NA
waa1_daya_cell[which(waa1_daya_cell>1.0E+10)]=NA
waa6_daya_cell[which(waa6_daya_cell>1.0E+10)]=NA
wab1_daya_cell[which(wab1_daya_cell>1.0E+10)]=NA
wab6_daya_cell[which(wab6_daya_cell>1.0E+10)]=NA
flo1_daya_cell[which(flo1_daya_cell>1.0E+10)]=NA
flo6_daya_cell[which(flo6_daya_cell>1.0E+10)]=NA
alrf_daya_cell[which(alrf_daya_cell>1.0E+10)]=NA
emrf_daya_cell[which(emrf_daya_cell>1.0E+10)]=NA
alrd_daya_cell[which(alrd_daya_cell>1.0E+10)]=NA
emrd_daya_cell[which(emrd_daya_cell>1.0E+10)]=NA
alwl_daya_cell[which(alwl_daya_cell>1.0E+10)]=NA
emwl_daya_cell[which(emwl_daya_cell>1.0E+10)]=NA
rftk_daya_cell[which(rftk_daya_cell>1.0E+10)]=NA
wltk_daya_cell[which(wltk_daya_cell>1.0E+10)]=NA
matk_daya_cell[which(matk_daya_cell>1.0E+10)]=NA
hwla_daya_cell[which(hwla_daya_cell>1.0E+10)]=NA
hwlb_daya_cell[which(hwlb_daya_cell>1.0E+10)]=NA
hrof_daya_cell[which(hrof_daya_cell>1.0E+10)]=NA
#
# ##############################################################
# A: Maps of averages over
#    - The seasons DJF, MAM, JJA, SON 
#    - The time periods
#       ALLD (00:00-24:00)
#       NOON (10:00-14:00)
#       LATE (20:00-00:00)
#       MORN (04:00-08:00)
# ##############################################################
#
# Calculation of averages
#
DIM=dim(h_dcyc_cell)
hourvec=seq(24*incdateout,24,(24*incdateout))
#
if (length(hourvec)!=DIM[3]) stop("Inconsistant dimensions")
#
namper=c("MORN","NOON","LATE","ALLD")
#
IND_MORN=which((hourvec>=04.0)&(hourvec<=08.0))
IND_NOON=which((hourvec>=10.0)&(hourvec<=14.0))
IND_LATE=which((hourvec>=20.0))
IND_ALLD=which((hourvec>=-1.0)&(hourvec<=25.0))
#
varvec=c("TCAN","H","LE","RN","SENFAB","INF","HVAC_HT","HVAC_CL",
         "QINACT","QINHOT","H_TRAFFIC","LE_TRAFFIC","H_INDUSTRY","LE_INDUSTRY",
         "QANTTOTAL","RSHADE","TROAD1","TROAD6","TFLOO1","TFLOO6","TWALLA1","TWALLA6",
         "TWALLB1","TWALLB6","TMASS1","TMASS6","TROOF1","TROOF6",
         "ALB_ROOF","EMIS_ROOF","ALB_ROAD","EMIS_ROAD","ALB_WALL",
         "EMIS_WALL","ROOF_TK","WALL_TK","MASS_TK","QCAN",
         "ULCAN","H_WALLA","H_WALLB","H_ROOF",
         "TEB_UTCI_SUN","TEB_UTCI_SHA","ISBA_UTCI_SUN","ISBA_UTCI_SHA",
         "TEB_TRAD_SUN","TEB_TRAD_SHA","ISBA_TRAD_SUN","ISBA_TRAD_SHA",
	 "CO2_BLD","CO2_POP","CO2_TRA","CO2_VEG","CO2_TOT")
#
titlevec=c("Air temperature in street canyon",
 "Sensible heat flux","Latent heat flux",
 "Net radiative flux","Storage heat flux",
 "Infiltration rate","Heating energy demand",
 "Cooling energy demand","Internal heat release","Energy consumed for hot water",
 "Traffic sensible heat release","Traffic latent heat release",
 "Industry sensible heat release","Industry latent heat release",
 "Building energy consumption, TEB",
# "Flux anthropique dû aux bâti. (TEB)",
 "Fraction of road shaded",
 "Road surface temperature","Road deep temperature",
 "Floor surface temperature","Floor deep temperature",
 "Wall A surface temperature","Wall A deep temperature",
 "Wall B surface temperature","Wall B deep temperature",
 "Mass surface temperature","Mass deep temperature",
 "Roof surface temperature","Roof deep temperature",
 "Roof albedo","Roof emissivity",
 "Road albedo","Road emissivity",
 "Wall albedo","Wall emissivity",
 "Roof thickness","Wall thickness","Mass thickness",
 "Specific humidity in street canyon",
 "Wind speed in street canyon","Wall A sensible heat flux",
 "Wall B sensible heat flux","Roof sensible heat flux",
 "TEB UTCI, sun","TEB UTCI, shade","IBSA UTCI, sun","ISBA UTCI, shade",
 "TEB TRAD, sun","TEB TRAD, shade","IBSA TRAD, sun","ISBA TRAD, shade",
 "CO2 emission by buildings","CO2 emission by human metabolism",
 "CO2 emission by traffic","CO2 emission by urban vegetation",
 "Total CO2 emission")
#
unitvec=c("°C","W/m²","W/m²","W/m²","W/m²","vol./h","W/m²","W/m²","W/m²",
          "W/m²","W/m²","W/m²","W/m²","W/m²","W/m²","","°C","°C",
	  "°C","°C", "°C","°C", "°C","°C","°C","°C", "°C","°C","",
	  "","","","","","m","m","m","g/kg","m/s","W/m²","W/m²",
	  "W/m²","°C","°C", "°C","°C","°C","°C", "°C","°C",
	  "umol/m²/s","umol/m²/s","umol/m²/s","umol/m²/s","umol/m²/s")
#
if (length(unitvec)!=length(titlevec)) {print(length(unitvec));print(length(titlevec));stop("Inconsistant lengths")}
if (length(unitvec)!=length(varvec  )) {print(length(unitvec));print(length(varvec))  ;stop("Inconsistant lengths")}
#
# Loop for variables depending on compartiments
#
for (tt in 1:NBEMCOMP) {
   #
   varvec=c(varvec,paste("TI_BLD",tt,sep=""))
   titlevec=c(titlevec,"Indoor air temperature")
   unitvec=c(unitvec,"°C")
   #
   varvec=c(varvec,paste("UTCI_IN_",tt,sep=""))
   titlevec=c(titlevec,"Indoor UTCI")
   unitvec=c(unitvec,"°C")
   #
   varvec=c(varvec,paste("DIAGSHAD",tt,sep=""))
   titlevec=c(titlevec,"Fraction of shading elements closed")
   unitvec=c(unitvec,"")
   #
   varvec=c(varvec,paste("DIAGVENT",tt,sep=""))
   titlevec=c(titlevec,"Fraction of windows open")
   unitvec=c(unitvec,"")
   #
   varvec=c(varvec,paste("DIAGVEFL",tt,sep=""))
   titlevec=c(titlevec,"Ventilation air exchange rate")
   unitvec=c(unitvec,"1/h")
   #
   varvec=c(varvec,paste("BLDOCC",tt,sep=""))
   titlevec=c(titlevec,"Building occupation fraction")
   unitvec=c(unitvec,"")
   #
}
#
varpermean=array(NA,c(length(varvec),4,4,ndim))
#
for (jj in 1:4) {
  if (jj==1) IND=IND_MORN
  if (jj==2) IND=IND_NOON
  if (jj==3) IND=IND_LATE
  if (jj==4) IND=IND_ALLD
  for (ii in 1:4) {
    for (dim in 1:ndim) {
      index=1
      varpermean[index,ii,jj,dim]=mean(tcan_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(h_dcyc_cell     [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(l_dcyc_cell     [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(r_dcyc_cell     [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(senfab_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(infc_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(hvacht_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(hvaccl_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(qinact_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(qinhot_dcyc_cell[ii,dim,IND]);index=index+1      
      varpermean[index,ii,jj,dim]=mean(h_traf_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(l_traf_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(h_indu_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(l_indu_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(qantot_dcyc_cell[ii,dim,IND]);indqant=index;index=index+1
      varpermean[index,ii,jj,dim]=mean(rsha_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(rod1_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(rod6_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(flo1_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(flo6_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(waa1_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(waa6_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(wab1_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(wab6_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(mas1_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(mas6_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(rof1_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(rof6_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(alrf_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(emrf_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(alrd_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(emrd_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(alwl_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(emwl_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(rftk_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(wltk_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(matk_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(1000.0*qcan_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(ulca_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(hwla_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(hwlb_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(hrof_dcyc_cell  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(utci_outsun_dcyc   [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(utci_outshade_dcyc [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(utci_isb_sun_dcyc  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(utci_isb_sha_dcyc  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(trad_sun_dcyc      [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(trad_shade_dcyc    [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(trad_isb_sun_dcyc  [ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(trad_isb_shade_dcyc[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(co2_bld_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(co2_pop_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(co2_tra_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(co2_veg_dcyc_cell[ii,dim,IND]);index=index+1
      varpermean[index,ii,jj,dim]=mean(co2_tot_dcyc_cell[ii,dim,IND]);index=index+1
      #
      for (tt in 1:NBEMCOMP) {
        varpermean[index,ii,jj,dim]=mean(tibd_dcyc_cell[ii,dim,IND,tt]);index=index+1
        varpermean[index,ii,jj,dim]=mean(utin_dcyc_cell[ii,dim,IND,tt]);index=index+1
        varpermean[index,ii,jj,dim]=mean(shad_dcyc_cell[ii,dim,IND,tt]);index=index+1
        varpermean[index,ii,jj,dim]=mean(vent_dcyc_cell[ii,dim,IND,tt]);index=index+1
        varpermean[index,ii,jj,dim]=mean(vefl_dcyc_cell[ii,dim,IND,tt]);index=index+1
        varpermean[index,ii,jj,dim]=mean(bldo_dcyc_cell[ii,dim,IND,tt]);index=index+1
      }
      #
      index=index-1
      #
      if (index!=length(varvec)) stop("Wrong number of entries in vector")
      #
    }
    #
    # Write the vales for the total anthropogenic
    # heat flux on rasters
    #
    if (ii==1) raster_qanttot_DJF=setValues(raster,varpermean[indqant,ii,4,])
    if (ii==2) raster_qanttot_MAM=setValues(raster,varpermean[indqant,ii,4,])
    if (ii==3) raster_qanttot_JJA=setValues(raster,varpermean[indqant,ii,4,])
    if (ii==4) raster_qanttot_SON=setValues(raster,varpermean[indqant,ii,4,])
    #
  }
}
#
for (tt in 1:length(varvec)) for (jj in 1:4) for (ii in 1:4) {
  #
  field=varpermean[tt,ii,jj,]
  #
  if (length(which(!is.na(field)))>0) {
     amax=max(field,na.rm=TRUE)
     amin=min(field,na.rm=TRUE)
     diff=amax-amin+1.0e-6
  } else {
    diff=0.0
  }
  #
  if (diff>1.0e-10) {
    #
    # Settings depending on variable
    #
    if ( (varvec[tt]=="TCAN")||(varvec[tt]=="TROAD1")||(varvec[tt]=="TROAD6")||(varvec[tt]=="TROOF1")||
         (varvec[tt]=="TROOF6") ||(varvec[tt]=="TFLOO1") ||(varvec[tt]=="TFLOO6")||
         (varvec[tt]=="TWALLA1")||(varvec[tt]=="TWALLA6")||(varvec[tt]=="TWALLB1")||
         (varvec[tt]=="TWALLB6")||(varvec[tt]=="TMASS1") ||(varvec[tt]=="TMASS6") ||
         (varvec[tt]=="QCAN")||(varvec[tt]=="ULCAN")||(varvec[tt]=="RN")||(grepl("CO2",varvec[tt]))||
         (grepl("TI_BLD",varvec[tt]))||(grepl("UTCI",varvec[tt]))||(grepl("TRAD",varvec[tt])) ) {
      #
      if      (diff<04.0) inc=0.25
      else if (diff<10.0) inc=0.50
      else if (diff<20.0) inc=1.00
      else if (diff<40.0) inc=2.00
      else inc=4.0
      #
      nflag="OFFLINE"
      #
      amin=inc*floor(amin/inc)
      amax=inc*floor(amax/inc)+inc
      #
      brks=seq(amin-inc/2,amax+inc/2,inc)
      #
      cols=rev(rainbow(length(brks)-1))
      namebr=array(NA,length(brks)-1)
      for (ll in 1:(length(brks)-1)) namebr[ll]=brks[ll]+inc/2
      #
    } else if ((varvec[tt]=="H")||(varvec[tt]=="LE_WAT")||(varvec[tt]=="LE")||
             (varvec[tt]=="SENFAB")||
             (varvec[tt]=="H_WALLA")||(varvec[tt]=="H_WALLB")||
             (varvec[tt]=="H_ROOF") ) {
      #
      # Determination of scaling factor for breaks
      #
      absmax=max(abs(field),na.rm=TRUE)
      #
      if      (absmax<00100) nscal=1
      else if (absmax<00200) nscal=2
      else if (absmax<00500) nscal=5
      else if (absmax<01000) nscal=10
      else stop("Wrong input for plotting")
      #
      nflag="OFFLINE"
      #
      brks=nscal*brks_flux
      cols=cols_flux
      #
      namebr=array(NA,length(brks)-1)
      for (ll in 1:(length(brks)-1)) namebr[ll]=paste(brks[ll]," - ",brks[ll+1],sep="")
      #
    } else if ((grepl("DIAGSHAD",varvec[tt]))||(grepl("DIAGVENT",varvec[tt]))||(grepl("BLDOCC",varvec[tt]))) {
      #
      brks=brks_frac
      cols=cols_water
      namebr=name_frac
      #
    } else if ((varvec[tt]=="INF")||(grepl("DIAGVEFL",varvec[tt]))) {
      #
      nflag="OFFLINE"
      #
      amin=0
      diff=amax-amin
      #
      if      (diff<000.1) inc=00.01
      else if (diff<001.0) inc=00.10
      else if (diff<002.0) inc=00.2
      else if (diff<004.0) inc=00.4
      else if (diff<020.0) inc=01.0
      else if (diff<040.0) inc=02.0
      else if (diff<100.0) inc=05.0
      else if (diff<200.0) inc=10.0
      else if (diff<400.0) inc=20.0
      else if (diff<800.0) inc=40.0
      else inc=50
      #
      amax=inc*floor(amax/inc)+inc
      #
      brks=seq(0,amax,inc)
      #
      cols=rev(heat.colors(length(brks)-1))
      namebr=array(NA,length(brks)-1)
      for (ll in 1:(length(brks)-1)) namebr[ll]=brks[ll]+inc/2
      #
    } else if ((varvec[tt]=="H_TRAFFIC" )||(varvec[tt]=="LE_TRAFFIC" )||
               (varvec[tt]=="H_INDUSTRY")||(varvec[tt]=="LE_INDUSTRY")||
               (varvec[tt]=="HVAC_HT")   ||(varvec[tt]=="HVAC_CL")    ||
               (varvec[tt]=="QINACT")    ||(varvec[tt]=="QANTTOTAL") ) {
      #
      nflag="OFFLINE"
      brks=brks_qant
      cols=cols_qant
      namebr=name_qant
      #
    } else if (varvec[tt]=="QINHOT") {
      #
      nflag="OFFLINE"
      brks=brks_qant/10
      cols=cols_qant
      namebr=name_qant
      #
    } else if ((varvec[tt]=="ALB_ROOF")||(varvec[tt]=="ALB_ROAD")||(varvec[tt]=="ALB_WALL") ) {
      #
      nflag="OFFLINE"
      brks=brks_albedo
      cols=cols_albedo
      namebr=name_albedo
      #
    } else if ((varvec[tt]=="RSHADE")||(varvec[tt]=="ALB_ROOF")||(varvec[tt]=="EMIS_ROOF")||
             (varvec[tt]=="ALB_ROAD")||(varvec[tt]=="EMIS_ROAD")||
             (varvec[tt]=="ALB_WALL")||(varvec[tt]=="EMIS_WALL")||
             (varvec[tt]=="ROOF_TK")||(varvec[tt]=="WALL_TK")||
             (varvec[tt]=="MASS_TK") ) {
      #
      nflag="OFFLINE"
      #
      amin=0
      amax=1
      inc=0.1
      #
      brks=seq(0,amax,inc)
      #
      cols=rev(rainbow(length(brks)-1))
      namebr=array(NA,length(brks)-1)
      for (ll in 1:(length(brks)-1)) namebr[ll]=brks[ll]+inc/2
      #
    } else {
      print(varvec[tt])
      stop("No rule implemented for plotting this variable")
    }
    #
    namebase=paste(pmaps,nflag,"/",name,sep="")
    system(paste("mkdir -p",namebase))
    #
    nameplot=paste(pmaps,nflag,"/",name,"/",varvec[tt],"_",namseas[ii],"_",namper[jj],".pdf",sep="")
    #
    seplotraster(field,raster,ncols,nrows,brks,cols,namebr,nameplot,
                 titlevec[tt],unitvec[tt],xaxis,yaxis,xaxis_km,yaxis_km,xmast,ymast)
    #
  }
}
#
# ###################################################################
# B: Analysis of the domain sum of anthropogenic heat-related variables (MJ)
# ###################################################################
#
# Conversion from daily average W/m2(cell) to GW (domain)
#
cfl=1.0e-9*XCELLSIZE*XCELLSIZE
#
hvacht_daya_sum=cfl*apply(hvacht_daya_cell,c(2),sum,na.rm=TRUE)
hvaccl_daya_sum=cfl*apply(hvaccl_daya_cell,c(2),sum,na.rm=TRUE)
h_traf_daya_sum=cfl*apply(h_traf_daya_cell,c(2),sum,na.rm=TRUE)
l_traf_daya_sum=cfl*apply(l_traf_daya_cell,c(2),sum,na.rm=TRUE)
h_indu_daya_sum=cfl*apply(h_indu_daya_cell,c(2),sum,na.rm=TRUE)
l_indu_daya_sum=cfl*apply(l_indu_daya_cell,c(2),sum,na.rm=TRUE)
qinact_daya_sum=cfl*apply(qinact_daya_cell,c(2),sum,na.rm=TRUE)
qinhot_daya_sum=cfl*apply(qinhot_daya_cell,c(2),sum,na.rm=TRUE)
qantot_daya_sum=cfl*apply(qantot_daya_cell,c(2),sum,na.rm=TRUE)
#
hvacht_dcyc_sum=cfl*apply(hvacht_dcyc_cell,c(1,3),sum,na.rm=TRUE)
hvaccl_dcyc_sum=cfl*apply(hvaccl_dcyc_cell,c(1,3),sum,na.rm=TRUE)
h_traf_dcyc_sum=cfl*apply(h_traf_dcyc_cell,c(1,3),sum,na.rm=TRUE)
l_traf_dcyc_sum=cfl*apply(l_traf_dcyc_cell,c(1,3),sum,na.rm=TRUE)
h_indu_dcyc_sum=cfl*apply(h_indu_dcyc_cell,c(1,3),sum,na.rm=TRUE)
l_indu_dcyc_sum=cfl*apply(l_indu_dcyc_cell,c(1,3),sum,na.rm=TRUE)
qinact_dcyc_sum=cfl*apply(qinact_dcyc_cell,c(1,3),sum,na.rm=TRUE)
qinhot_dcyc_sum=cfl*apply(qinhot_dcyc_cell,c(1,3),sum,na.rm=TRUE)
qantot_dcyc_sum=cfl*apply(qantot_dcyc_cell,c(1,3),sum,na.rm=TRUE)
#
hvacht_week_sum=cfl*apply(hvacht_week_cell,c(1,3),sum,na.rm=TRUE)
hvaccl_week_sum=cfl*apply(hvaccl_week_cell,c(1,3),sum,na.rm=TRUE)
h_traf_week_sum=cfl*apply(h_traf_week_cell,c(1,3),sum,na.rm=TRUE)
l_traf_week_sum=cfl*apply(l_traf_week_cell,c(1,3),sum,na.rm=TRUE)
h_indu_week_sum=cfl*apply(h_indu_week_cell,c(1,3),sum,na.rm=TRUE)
l_indu_week_sum=cfl*apply(l_indu_week_cell,c(1,3),sum,na.rm=TRUE)
qinact_week_sum=cfl*apply(qinact_week_cell,c(1,3),sum,na.rm=TRUE)
qinhot_week_sum=cfl*apply(qinhot_week_cell,c(1,3),sum,na.rm=TRUE)
qantot_week_sum=cfl*apply(qantot_week_cell,c(1,3),sum,na.rm=TRUE)
#
# The first 10 days of the CAPITOUL model results need to be omitted
#
hvacht_daya_sum=hvacht_daya_sum[11:nday]
hvaccl_daya_sum=hvaccl_daya_sum[11:nday]
h_traf_daya_sum=h_traf_daya_sum[11:nday]
l_traf_daya_sum=l_traf_daya_sum[11:nday]
h_indu_daya_sum=h_indu_daya_sum[11:nday]
l_indu_daya_sum=l_indu_daya_sum[11:nday]
qinact_daya_sum=qinact_daya_sum[11:nday]
qinhot_daya_sum=qinhot_daya_sum[11:nday]
qantot_daya_sum=qantot_daya_sum[11:nday]
#
# Load observation based data of anthropogenic heat
#
load(file="/home/schoetterr/Bureau/SURFEX/CAPITOUL_OBS/qf/Processed_data/City/RSAVE/ALL_2D_CAPITOUL")
#
julobs=LST$datejults;tra_daya_obs=LST$traconday;gas_daya_obs=LST$gasconday
ele_daya_obs=LST$eleconday;otr_daya_obs=LST$otrconday;tot_daya_obs=LST$totconday
gas_dcyc_obs=LST$gas_dcyc;ele_dcyc_obs=LST$ele_dcyc;tra_dcyc_obs=LST$tra_dcyc
heat_dcyc_obs=LST$heat_dcyc;qinh_dcyc_obs=LST$qinh_dcyc
gascondayseas=LST$gascondayseas;elecondayseas=LST$elecondayseas
#
# Calculate the average weekly cycle during heating and cooling season
#
weekdobs=weekdays(julobs)
#
datebeg_heat=myjulday(10,01,2004);dateend_heat=myjulday(02,28,2005)
datebeg_cool=myjulday(06,01,2004);dateend_cool=myjulday(08,31,2004)
#
INDHEATOUT=which((julobs>=datebeg_heat)&(julobs<=dateend_heat))
INDCOOLOUT=which((julobs>=datebeg_cool)&(julobs<=dateend_cool))
#
# Select days of week
#
ind_weekcyc_cool=array(0,c(7,25))
ind_weekcyc_heat=array(0,c(7,25))
#
for (wd in 1:7) {
  #
  if      (wd==1) named="Mon"
  else if (wd==2) named="Tue"
  else if (wd==3) named="Wed"
  else if (wd==4) named="Thu"
  else if (wd==5) named="Fri"
  else if (wd==6) named="Sat"
  else if (wd==7) named="Sun"
  else stop("This option is not implemented")
  #
  ind_cool=which((weekdobs==named)&(julobs>=datebeg_cool)&(julobs<=dateend_cool))
  ind_heat=which((weekdobs==named)&(julobs>=datebeg_heat)&(julobs<=dateend_heat))
  #
  if ((length(ind_cool)<12)|(length(ind_cool)>25)) stop("Unplausible length of index vector")
  if ((length(ind_heat)<12)|(length(ind_heat)>25)) stop("Unplausible length of index vector")
  #
  ind_weekcyc_cool[wd,1:length(ind_cool)]=ind_cool
  ind_weekcyc_heat[wd,1:length(ind_heat)]=ind_heat
  #
}
#
tra_week_obs=array(0,c(2,7))
gas_week_obs=array(0,c(2,7))
ele_week_obs=array(0,c(2,7))
otr_week_obs=array(0,c(2,7))
tot_week_obs=array(0,c(2,7))
#
for (seas in 1:2) for (wd in 1:7) {
  #
  if      (seas==1) ind_act=ind_weekcyc_cool[wd,]
  else if (seas==2) ind_act=ind_weekcyc_heat[wd,]
  else stop("No rule implemented for this season")
  #
  count=0
  for (ii in 1:length(ind_act)) {
    if (ind_act[ii]>0.5) {
      tra_week_obs[seas,wd]=tra_week_obs[seas,wd]+tra_daya_obs[ind_act[ii]]
      gas_week_obs[seas,wd]=gas_week_obs[seas,wd]+gas_daya_obs[ind_act[ii]]
      ele_week_obs[seas,wd]=ele_week_obs[seas,wd]+ele_daya_obs[ind_act[ii]]
      otr_week_obs[seas,wd]=otr_week_obs[seas,wd]+otr_daya_obs[ind_act[ii]]
      tot_week_obs[seas,wd]=tot_week_obs[seas,wd]+tot_daya_obs[ind_act[ii]]
      count=count+1
    }
  }
  #
  tra_week_obs[seas,wd]=tra_week_obs[seas,wd]/count
  gas_week_obs[seas,wd]=gas_week_obs[seas,wd]/count
  ele_week_obs[seas,wd]=ele_week_obs[seas,wd]/count
  otr_week_obs[seas,wd]=otr_week_obs[seas,wd]/count
  tot_week_obs[seas,wd]=tot_week_obs[seas,wd]/count
}
#
# ##############################################################################
# Create scatterplots between the observed and simulated daily values
# of heating energy demand and the daily averages of the forcing
# meteorological conditions
# - air temperature
# - wind speed
# - shortwave radiation
# ##############################################################################
#
# Load the forcing data
#
fileprep=paste(pdata,name,"/Basic",sep="")
load(file=fileprep);fordayav=LST$fordayav
#
# The first 10 days are excluded (hardcoded to CAPITOUL setup)
#
fordayav=fordayav[,11:375]
#
ind=which(forva=="TA")
if (length(ind)!=1) stop("Forcing temperature not found")
temp_for=fordayav[ind,]
#
ind=which(forva=="WIND")
if (length(ind)!=1) stop("Forcing wind not found")
wind_for=fordayav[ind,]
#
ind=which(forva=="DIR_SW")
if (length(ind)!=1) stop("Forcing direct shortwave radiation not found")
dirs_for=fordayav[ind,]
#
ind=which(forva=="SCA_SW")
if (length(ind)!=1) stop("Forcing scattered shortwave radiation not found")
scas_for=fordayav[ind,]
#
solt_for=dirs_for+scas_for
#
# Estimate the daily values of the heating energy 
# demand from the inventory. For this purpose, the 
# summer average is substracted from the daily data.
# This can lead to slighly negative values, which are set to 0.0
# 
heat_gas_daya=gas_daya_obs-gascondayseas[3]
heat_ele_daya=ele_daya_obs-elecondayseas[3]
heat_otr_daya=otr_daya_obs
#
heat_gas_daya[which(heat_gas_daya<0.0)]=0.0
heat_ele_daya[which(heat_ele_daya<0.0)]=0.0
#
heat_tot_daya=heat_gas_daya+heat_ele_daya+heat_otr_daya
#
for (metvar in 1:3) {
  #
  if      (metvar==1) {
    meteo=temp_for
    xinc=5
    xlab="Air temperature [°C]"
    varn="TEMP"
  } else if (metvar==2) {
    meteo=wind_for
    xinc=1
    xlab="Wind speed [m/s]"
    varn="WIND"
  } else if (metvar==3) {
    meteo=solt_for
    xinc=20
    xlab="Shortwave radiation [W/m²]"
    varn="SOLA"
  } else {
    stop("No rule ipmlemented for this variable")
  }
  #
  # Create y-axis
  #
  yinc=0.5
  ylab="Energy consumption [GWd]"
  #
  amin=min(c(heat_tot_daya,hvacht_daya_sum,hvaccl_daya_sum))
  amax=max(c(heat_tot_daya,hvacht_daya_sum,hvaccl_daya_sum))
  #
  amin=0
  amax=yinc*(floor(amax/yinc)+1)
  #
  ylim=c(amin,amax)
  # ylim=c(0,3.5)
  #
  # Create x-axis
  #
  amin=min(meteo)
  amax=max(meteo)
  #
  amin=xinc*(floor(amin/xinc))
  amax=xinc*(floor(amax/xinc)+1)
  xlim=c(amin,amax)
  #
  pdf(paste(ppday,name,"/SCATT_ENERGY_",varn,".pdf",sep=""),height=6,width=6)
  par(mar=c(5,5,1,5))
  #
  myscatts(x=meteo,y=hvacht_daya_sum,xlim=xlim,ylim=ylim,xlab=xlab,ylab=ylab,
         col="red",regr=F,regr.txt=F,pval=0.1,regr.ci=F,regr.ci.level=0.95,
         add=F,frame.plot=T,pch=21,bg.def="white",jj=1,xinc=xinc,
         yinc=yinc,lwdsca=1,lnum=0,nums=NA)
  #
  myscatts(x=meteo,y=hvaccl_daya_sum,xlim=xlim,ylim=ylim,xlab=xlab,ylab=ylab,
           col="blue",regr=F,regr.txt=F,pval=0.1,regr.ci=F,regr.ci.level=0.95,
           add=T,frame.plot=T,pch=21,bg.def="white",jj=1,xinc=xinc,
           yinc=yinc,lwdsca=1,lnum=0,nums=NA)
  #
  myscatts(x=meteo,y=heat_gas_daya,xlim=xlim,ylim=ylim,xlab=xlab,
           ylab=ylab,col="green",regr=F,regr.txt=F,pval=0.1,regr.ci=F,
           regr.ci.level=0.95,add=T,frame.plot=T,pch=21,bg.def="white",
           jj=2,xinc=xinc,yinc=yinc,lwdsca=1,lnum=0,nums=NA)
  #
  myscatts(x=meteo,y=heat_ele_daya,xlim=xlim,ylim=ylim,xlab=xlab,
           ylab=ylab,col="magenta",regr=F,regr.txt=F,pval=0.1,regr.ci=F,
           regr.ci.level=0.95,add=T,frame.plot=T,pch=21,bg.def="white",
           jj=2,xinc=xinc,yinc=yinc,lwdsca=1,lnum=0,nums=NA)
  #
  myscatts(x=meteo,y=heat_tot_daya,xlim=xlim,ylim=ylim,xlab=xlab,
           ylab=ylab,col="black",regr=F,regr.txt=F,pval=0.1,regr.ci=F,
           regr.ci.level=0.95,add=T,frame.plot=T,pch=21,bg.def="white",
           jj=2,xinc=xinc,yinc=yinc,lwdsca=1,lnum=0,nums=NA)
  #
  legend("topright",c("Heating (sim)","Cooling (sim)","Gas (inv)","Ele (inv)","Tot (Inv)"),lty=1,col=c("red","blue","green","magenta","black"),lwd=2,cex=1.2)
  #
  garbage <- dev.off()
  #
}
#
# ##################################
# Plot time series of daily values
# ##################################
#
# A: Contributions to the inventory
#
nameleg=c("Traffic","Gas","Electricity","Other","Total")
colors =c("green","blue","red","magenta","black")
ltys   =c(1,1,1,1,1)
data   =array(NA,c(1,365,5))
data[1,,1]=tra_daya_obs
data[1,,2]=gas_daya_obs
data[1,,3]=ele_daya_obs
data[1,,4]=otr_daya_obs
data[1,,5]=tot_daya_obs
#
plottsdav(data,julobs,"SUM_INVENTORY","GWd","Energy consumption","",nameleg,colors,ltys,path=paste(ppday,name,"/",sep=""))
#
# B: Contributions to the simulated anthropogenic heat consumption
#
nameleg=c("Traffic","Internal","Heating","Cooling","Total")
colors =c("green","magenta","red","blue","black")
ltys   =c(1,1,1,1,1)
data   =array(NA,c(1,365,5))
data[1,,1]=h_traf_daya_sum+l_traf_daya_sum
data[1,,2]=qinact_daya_sum+qinhot_daya_sum
data[1,,3]=hvacht_daya_sum
data[1,,4]=hvaccl_daya_sum
data[1,,5]=qantot_daya_sum
#
plottsdav(data,julobs,"SUM_SIMULATED","GWd","Energy consumption","",nameleg,colors,ltys,path=paste(ppday,name,"/",sep=""))
#
# Save the values related to the anthropogenic heat release                                                              
#
nontra_daya_obs=tot_daya_obs-tra_daya_obs
#
LST=list(julobs=julobs,h_traf_daya_sum=h_traf_daya_sum,l_traf_daya_sum=l_traf_daya_sum,
         qinact_daya_sum=qinact_daya_sum,qinhot_daya_sum=qinhot_daya_sum,
	 hvacht_daya_sum=hvacht_daya_sum,hvaccl_daya_sum=hvaccl_daya_sum,
	 qantot_daya_sum=qantot_daya_sum,nontra_daya_obs=nontra_daya_obs)
#
fileqantts=paste(pdata,name,"/QANT_TS",sep="")
save(LST,file=fileqantts)
#
# C: Evaluation of traffic energy consumptions
#
nameleg=c("Simulated","Inventory")
colors =c("red","black")
ltys   =c(1,1)
data   =array(NA,c(1,365,2))
data[1,,1]=h_traf_daya_sum+l_traf_daya_sum
data[1,,2]=tra_daya_obs
#
plottsdav(data,julobs,"EVAL_QA_TRAFFIC","GWd","Energy consumption","",nameleg,colors,ltys,path=paste(ppday,name,"/",sep=""))
#
# D: Evaluation of non-traffic energy consumption
#
# nameleg=c("TEB-BEM","Inventory")
nameleg=c("TEB","Inventaire")
colors =c("red","black")
ltys   =c(1,1)
data   =array(NA,c(1,365,2))
data[1,,1]=qantot_daya_sum-h_traf_daya_sum-l_traf_daya_sum
data[1,,2]=tot_daya_obs-tra_daya_obs
#
# Calculation of evaluation measures for display
#
obs=data[1,,1]
sim=data[1,,2]
#
err=sim-obs
#
mae_qbld = mean(abs(err))
rmse_qbld = sqrt(mean(err*err))
#
plottsdav(data,julobs,"EVAL_QA_NONTRAFFIC","GWd","Consommation énergétique",  # "Energy consumption",
          "",nameleg,colors,ltys,# mae=mae_qbld,rmse=rmse_qbld,
          path=paste(ppday,name,"/",sep=""))
#
# With plot of air temperature (but omitted since it deteriorates plot visibility)
#
# plottsdav(data,julobs,"EVAL_QA_NONTRAFFIC","GWd","Energy consumption",
#          "",nameleg,colors,ltys,mae=mae_qbld,rmse=rmse_qbld,
#          covar=temp_for,covarname="Air temperature",covarunit="°C",
#          path=paste(ppday,name,"/",sep=""))
#
# #############################################################################
# Plot average diurnal cycle per season
# CAUTION: for the inventory a diurnal cycle is only available for electricity
# #############################################################################
#
# A: Contributions to the inventory (per source)
#
nameleg=c("Traffic","Gas","Electricity","Total")
colors =c("green","blue","red","black")
ltys   =c(1,1,1,1)
data   =array(NA,c(1,1,(1/incdateout),4))
#
for (seas in 1:4) {
  #
  data[1,1,,1]=tra_dcyc_obs[seas,]
  data[1,1,,2]=gas_dcyc_obs[seas,]
  data[1,1,,3]=ele_dcyc_obs[seas,]
  data[1,1,,4]=tra_dcyc_obs[seas,]+gas_dcyc_obs[seas,]+ele_dcyc_obs[seas,]
  #
  plotdaycy(data,incdateout,"CONTRIB_INVENTORY","GWd","Energy consumption",
            namseas[seas],"",nameleg,colors,ltys,path=paste(ppcyc,name,"/",sep=""))
  #
}
#
# B: Contributions to the inventory (estimated TEB-output)
#
nameleg=c("Traffic","Heating","Internal","Total")
colors =c("green","blue","red","black")
ltys   =c(1,1,1,1)
data   =array(NA,c(1,1,(1/incdateout),4))
#
for (seas in 1:4) {
  #
  data[1,1,,1]=tra_dcyc_obs[seas,]
  data[1,1,,2]=heat_dcyc_obs[seas,]
  data[1,1,,3]=qinh_dcyc_obs[seas,]
  data[1,1,,4]=tra_dcyc_obs[seas,]+heat_dcyc_obs[seas,]+qinh_dcyc_obs[seas,]
  #
  plotdaycy(data,incdateout,"CONTRIB_INVENTORY_TEB","GWd","Energy consumption",namseas[seas],"",nameleg,colors,ltys,path=paste(ppcyc,name,"/",sep=""))
  #
}
#
# C: Contributions to the simulated anthropogenic heat consumption
#
nameleg=c("Traffic","Internal","Heating","Cooling","Total")
colors =c("green","magenta","red","blue","black")
ltys   =c(1,1,1,1,1)
data   =array(NA,c(1,1,(1/incdateout),5))
#
for (seas in 1:4) {
  #
  data[1,1,,1]=h_traf_dcyc_sum[seas,]+l_traf_dcyc_sum[seas,]
  data[1,1,,2]=qinact_dcyc_sum[seas,]+qinhot_dcyc_sum[seas,]
  data[1,1,,3]=hvacht_dcyc_sum[seas,]
  data[1,1,,4]=hvaccl_dcyc_sum[seas,]
  data[1,1,,5]=qantot_dcyc_sum[seas,]
  #
  plotdaycy(data,incdateout,"SUM_SIMULATED","GWd","Energy consumption",namseas[seas],"",nameleg,colors,ltys,path=paste(ppcyc,name,"/",sep=""))
  #
}
#
# D: Evaluation of traffic energy consumption
#
nameleg=c("Simulated","Inventory")
colors =c("red","black")
ltys   =c(1,1)
data   =array(NA,c(1,1,(1/incdateout),2))
#
for (seas in 1:4) {
  #
  data[1,1,,1]=h_traf_dcyc_sum[seas,]+l_traf_dcyc_sum[seas,]
  data[1,1,,2]=tra_dcyc_obs[seas,]
  #
  plotdaycy(data,incdateout,"EVAL_QA_TRAFFIC","GWd","Energy consumption",namseas[seas],"",nameleg,colors,ltys,path=paste(ppcyc,name,"/",sep=""))
  #
}
#
# E: Evaluation of non-traffic consumption
#
nameleg=c("Simulated, non traffic","Inventory, non traffic")
colors =c("red","black")
ltys   =c(1,1)
data   =array(NA,c(1,1,(1/incdateout),2))
#
for (seas in 1:4) {
  #
  data[1,1,,1]=qantot_dcyc_sum[seas,]-h_traf_dcyc_sum[seas,]-l_traf_dcyc_sum[seas,]
  data[1,1,,2]=gas_dcyc_obs[seas,]+ele_dcyc_obs[seas,]
  #
  plotdaycy(data,incdateout,"EVAL_QA_NONTRAFFIC","GWd","Energy consumption",namseas[seas],"",nameleg,colors,ltys,path=paste(ppcyc,name,"/",sep=""))
  #
}
#
# ################################################################
# Evaluate the weekly cycle of energy consumption
# ################################################################
#
# Non-traffic energy consumption
#
pathweek=paste(ppwee,name,"/",sep="")
system(paste("mkdir -p",pathweek))
#
nameleg=c("Inventory","TEB-BEM")
colors =c("black","red")
#
vec_weekc=c("COOL","HEAT")
#
for (ii in 1:length(vec_weekc)) {
  #
  data=array(NA,c(7,2))
  data[,1]=tot_week_obs[ii,]-tra_week_obs[ii,]
  data[,2]=qantot_week_sum[ii,]-h_traf_week_sum[ii,]-l_traf_week_sum[ii,]
  #
  plotweekcy(data,"EVAL_QA_NONTRAFFIC","GWd","Energy consumption",vec_weekc[ii],name,nameleg,colors,path=pathweek)
  #
}
#
# ###############################################################################
# Compare the 2D fields of total anthropogenic heat release
# ###############################################################################
#
load(file="/home/schoetterr/Bureau/SURFEX/CAPITOUL_OBS/qf/Processed_data/City/RSAVE/ALL_2D_CAPITOUL")
#
raster_all_DJF=LST$raster_all_DJF
raster_all_MAM=LST$raster_all_MAM
raster_all_JJA=LST$raster_all_JJA
raster_all_SON=LST$raster_all_SON
raster_all_ALL=LST$raster_all_ALL
ele_day_weig=LST$ele_day_weig
gas_day_weig=LST$gas_day_weig
otr_day_weig=LST$otr_day_weig
#
# Interpolate the seasonal mean fiels to simulated rasters
#
raster_all_DJF_res = resample(raster_all_DJF,raster_qanttot_DJF,method="bilinear",background=0.0)
raster_all_MAM_res = resample(raster_all_MAM,raster_qanttot_MAM,method="bilinear",background=0.0)
raster_all_JJA_res = resample(raster_all_JJA,raster_qanttot_JJA,method="bilinear",background=0.0)
raster_all_SON_res = resample(raster_all_SON,raster_qanttot_SON,method="bilinear",background=0.0)
#
# The diurnal energy consumption values need to be interpolated day
# per day onto the simulated rasters
#
DIM=dim(gas_day_weig)
#
vals_int_ele=array(NA,c(ndim,DIM[2]))
vals_int_gas=array(NA,c(ndim,DIM[2]))
vals_int_otr=array(NA,c(ndim,DIM[2]))
#
for (tt in 1:DIM[2]) {
  #
  raster_wrk_ele = setValues(raster_all_DJF,as.vector(ele_day_weig[,tt]))
  raster_wrk_gas = setValues(raster_all_DJF,as.vector(gas_day_weig[,tt]))
  raster_wrk_otr = setValues(raster_all_DJF,as.vector(otr_day_weig[,tt]))
  #
  raster_int_ele = resample(raster_wrk_ele,raster_qanttot_DJF,method="bilinear",background=0.0)
  raster_int_gas = resample(raster_wrk_gas,raster_qanttot_DJF,method="bilinear",background=0.0)
  raster_int_otr = resample(raster_wrk_otr,raster_qanttot_DJF,method="bilinear",background=0.0)
  #
  vals_int_ele[,tt] = getValues(raster_int_ele)
  vals_int_gas[,tt] = getValues(raster_int_gas)
  vals_int_otr[,tt] = getValues(raster_int_otr)
  #
}
#
# Extract the simulated and observed values for each season
#
vals=getValues(raster_all_DJF_res)
vals_obs_qanttotal=array(NA,c(length(vals),4))
vals_sim_qanttotal=array(NA,c(length(vals),4))
#
vals_obs_qanttotal[,1]=getValues(raster_all_DJF_res)
vals_obs_qanttotal[,2]=getValues(raster_all_MAM_res)
vals_obs_qanttotal[,3]=getValues(raster_all_JJA_res)
vals_obs_qanttotal[,4]=getValues(raster_all_SON_res)
#
vals_sim_qanttotal[,1]=getValues(raster_qanttot_DJF)
vals_sim_qanttotal[,2]=getValues(raster_qanttot_MAM)
vals_sim_qanttotal[,3]=getValues(raster_qanttot_JJA)
vals_sim_qanttotal[,4]=getValues(raster_qanttot_SON)
#
# Calculate and plot the seasonal BIAS
#
bias_seas=vals_sim_qanttotal-vals_obs_qanttotal
#
# Plot the BIAS of the daily consumptions
#
seasvec=c("DJF","MAM","JJA","SON")
#
for (ii in 1:4) {
  #
  nflag  = "OFFLINE"
  brks   = brks_qant_bias
  cols   = cols_qant_bias
  namebr = name_qant_bias
  titlep = "Bias of building energy cons."
  unitp  = "W/m²"
  #
  field=bias_seas[,ii]
  #
  nameplot=paste(pmaps,nflag,"/",name,"/QANT_BIAS_",seasvec[ii],".pdf",sep="")
  seplotraster(field,raster_all_DJF_res,ncols,nrows,brks,cols,namebr,nameplot,
               titlep,unitp,xaxis,yaxis,xaxis_km,yaxis_km,flaglarge=1)
  #
}
#
# Calculate the seasonal RMSE
#
seasbeg=array(NA,4)
seasend=array(NA,4)
seasbeg[1]=myjulday(12,01,2004)
seasend[1]=myjulday(02,28,2005)
seasbeg[2]=myjulday(03,01,2004)
seasend[2]=myjulday(05,31,2004)
seasbeg[3]=myjulday(06,01,2004)
seasend[3]=myjulday(08,31,2004)
seasbeg[4]=myjulday(09,01,2004)
seasend[4]=myjulday(11,30,2004)
#
qant_inv=vals_int_ele+vals_int_gas+vals_int_otr
qant_sim=qantot_daya_cell[,11:375]
#
DIM1=dim(qant_inv)
DIM2=dim(qant_sim)
#
if (length(DIM1)!=length(DIM2)) stop("Inconsistant dimensions")
for (ii in 1:length(DIM1)) {
  if (DIM1[ii]!=DIM2[ii]) stop("Inconsistant dimensions")
}
#
# RMSE
#
RMSE_qant = array(NA,c(ndim,4))
for (seas in 1:4) {
  indseas=which((julobs>=seasbeg[seas])&(julobs<=seasend[seas]))
  for (ii in 1:ndim) RMSE_qant[ii,seas] = sqrt(mean((qant_sim[ii,indseas]-qant_inv[ii,indseas])**2))
}
#
for (ii in 1:4) {
  #
  nflag  = "OFFLINE"
  brks   = brks_qant_rmse
  cols   = cols_qant_rmse
  namebr = name_qant_rmse
  titlep = "RMSE of building energy cons."
  unitp  = "W/m²"
  #
  field=RMSE_qant[,ii]
  #
  nameplot=paste(pmaps,nflag,"/",name,"/QANT_RMSE_",seasvec[ii],".pdf",sep="")
  seplotraster(field,raster_all_DJF_res,ncols,nrows,brks,cols,namebr,nameplot,
               titlep,unitp,xaxis,yaxis,xaxis_km,yaxis_km)
  #
}
#
# Plot the resampled inventory rasters with the same colour scale
# then the simulated fields
#
for (ii in 1:4) {
  #
  nflag  = "OFFLINE"
  brks   = brks_qant
  cols   = cols_qant
  namebr = name_qant
  #
  if (ii==1) field=getValues(raster_all_DJF_res)
  if (ii==2) field=getValues(raster_all_MAM_res)
  if (ii==3) field=getValues(raster_all_JJA_res)
  if (ii==4) field=getValues(raster_all_SON_res)
  #
  # plottitle="Building energy cons. (Inventory)"
  #
  plottitle = "Flux anthropique dû aux bâti. (inventaire)"
  #
  plotunit ="W/m²"
  #
  nameplot=paste(pmaps,nflag,"/",name,"/QANT_INV_",namseas[ii],"_ALLD.pdf",sep="")
  seplotraster(field,raster_all_DJF_res,ncols,nrows,brks,cols,namebr,nameplot,
               plottitle,plotunit,xaxis,yaxis,xaxis_km,yaxis_km,xmast,ymast)
  #
}
#
# ##################################################################
#
# Evaluation of the surface energy budget in a 500 m radius
# of the mast location
#
# Get coordinates of output raster
#
vals=getValues(raster)
ncell=length(vals)
cell=seq(1,ncell,1)
coordinates=xyFromCell(raster,cell=cell)
#
# Calculate distance to mast
#
distmast=pointDistance(p1=coordinates,p2=c(xmast,ymast),lonlat=FALSE,allpairs=FALSE)
#
# Find points in less than 500 m distance
#
indmast=which(distmast<500.0)
if (length(indmast)<0.5) stop("No grid point in 500 m of mast found")
print(paste("A total of",length(indmast),"grid cells are found in 500 m distance of mast"))
#
# Extract fluxes at grid points of interest
#
# H, LE, RN
#
DIM=dim(h_dcyc_cell)
#
h_dcyc_mod = array(NA,c(DIM[1],DIM[3]))
l_dcyc_mod = array(NA,c(DIM[1],DIM[3]))
r_dcyc_mod = array(NA,c(DIM[1],DIM[3]))
#
co2_tot_dcyc_mod = array(NA,c(DIM[1],DIM[3]))
co2_veg_dcyc_mod = array(NA,c(DIM[1],DIM[3]))
co2_tra_dcyc_mod = array(NA,c(DIM[1],DIM[3]))
co2_pop_dcyc_mod = array(NA,c(DIM[1],DIM[3]))
co2_bld_dcyc_mod = array(NA,c(DIM[1],DIM[3]))
#
for (ii in 1:DIM[1]) for (jj in 1:DIM[3]) {
  h_dcyc_mod       [ii,jj] = mean(h_dcyc_cell      [ii,indmast,jj])
  l_dcyc_mod       [ii,jj] = mean(l_dcyc_cell      [ii,indmast,jj])
  r_dcyc_mod       [ii,jj] = mean(r_dcyc_cell      [ii,indmast,jj])
  co2_tot_dcyc_mod [ii,jj] = mean(co2_tot_dcyc_cell[ii,indmast,jj])
  co2_veg_dcyc_mod [ii,jj] = mean(co2_veg_dcyc_cell[ii,indmast,jj])
  co2_tra_dcyc_mod [ii,jj] = mean(co2_tra_dcyc_cell[ii,indmast,jj])
  co2_pop_dcyc_mod [ii,jj] = mean(co2_pop_dcyc_cell[ii,indmast,jj])
  co2_bld_dcyc_mod [ii,jj] = mean(co2_bld_dcyc_cell[ii,indmast,jj])
}
#
# Average the weekly cycles of CO2 fluxes around the CAPITOUL mast
#
co2_tot_week_mod = array(NA,c(2,7))
co2_veg_week_mod = array(NA,c(2,7))
co2_tra_week_mod = array(NA,c(2,7))
co2_pop_week_mod = array(NA,c(2,7))
co2_bld_week_mod = array(NA,c(2,7))
#
for (ii in 1:2) for (jj in 1:7) {
  co2_tot_week_mod [ii,jj] = mean(co2_tot_week_cell[ii,indmast,jj])
  co2_veg_week_mod [ii,jj] = mean(co2_veg_week_cell[ii,indmast,jj])
  co2_tra_week_mod [ii,jj] = mean(co2_tra_week_cell[ii,indmast,jj])
  co2_pop_week_mod [ii,jj] = mean(co2_pop_week_cell[ii,indmast,jj])
  co2_bld_week_mod [ii,jj] = mean(co2_bld_week_cell[ii,indmast,jj])
}
#
# Load the mast data
#
fobs=paste(pdata,"/MASTDAT",sep="")
if (!file.exists(fobs)) seprepmast(fobs)
load(file=fobs)
#
h_dcyc_obs       = LST$sendcyc
l_dcyc_obs       = LST$latdcyc
r_dcyc_obs       = LST$raddcyc
co2_concdcyc_obs = LST$co2_concdcyc
co2_fluxdcyc_obs = LST$co2_fluxdcyc
co2_fluxcool_obs = LST$co2_fluxcoolwd
co2_fluxheat_obs = LST$co2_fluxheatwd
#
DIM1=dim(h_dcyc_mod)
DIM2=dim(h_dcyc_obs)
#
if (DIM1[2]==DIM2[2]) {
  # No action required
} else if (DIM1[2]==(DIM2[2]/2)) {
  ind=seq(1,DIM2[2],2)
  h_dcyc_obs       = h_dcyc_obs[,ind]
  l_dcyc_obs       = l_dcyc_obs[,ind]
  r_dcyc_obs       = r_dcyc_obs[,ind]
  co2_concdcyc_obs = co2_concdcyc_obs[,ind]
  co2_fluxdcyc_obs = co2_fluxdcyc_obs[,ind]
} else {
  stop("Inconsistant length of simulated and observed data")
}
#
# ############################################################
# Create plot to evaluate total fluxes against observations
# #############################################################
#
# Define x-axis
# 
xlim=c(0,24)
xaxisout=24*seq(0,(1-incdateout),incdateout)
xaxislab=seq(0,24,2)
#
cexall=1.0;pchall=1.0;lwdall=1.0
#
for (seas in 1:length(namseas)) for (var in 1:5) {
  #
  # Settings depending on variable
  #
  if (var==1) {
    nam="SENFLX"
    lab="Sensible heat flux [W/m²]"
    sim=h_dcyc_mod
    obs=h_dcyc_obs
    ymin=-100;ymax=+350;yinc=+50
  } else if (var==2) {
    nam="LATFLX"
    lab="Latent heat fluw [W/m²]"
    sim=l_dcyc_mod
    obs=l_dcyc_obs
    ymin=-100;ymax=+350;yinc=+50
  } else if (var==3) {
    nam="RNET"
    lab="Net radiative flux [W/m²]"
    sim=r_dcyc_mod
    obs=r_dcyc_obs
    ymin=-100;ymax=+550;yinc=+50
  } else if (var==4) {
    nam="CO2_FLUX"
    lab="CO2 flux [umol/m²/s]"
    sim=co2_tot_dcyc_mod
    obs=co2_fluxdcyc_obs
    ymin=-10;ymax=80;yinc=10
  } else if (var==5) {
    nam="CO2_CONC"
    lab="CO2 concentration [???]"
    obs=co2_concdcyc_obs
    sim=array(NA,dim(obs))
    ymin=0;ymax=0.0001;yinc=0.00001
  } else {
    stop("This case is not implemented")
  }
  #
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
  #
  pdf(paste(ppcyc,name,"/EVALMAST_",nam,"_",namseas[seas],".pdf",sep=""))
  par(mar=c(5,5,1,5))
  #
  plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
  #
  lines(x=xaxisout,y=obs[seas,],pch=pchall,cex=cexall,lwd=2,col="black")
  lines(x=xaxisout,y=sim[seas,],pch=pchall,cex=cexall,lwd=2,col="red")
  #
  axis(1,at=xaxislab,lab=xaxislab,las=1,cex.axis=1.3)
  axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
  #
  mtext(lab,side=2,line=3,cex=1.5,col="black")
  #
  legendvec=c("Mast","Simulation")
  #
  legend("top",legendvec,lty=1,col=c("black","red"),lwd=2,cex=1.2)
  #
  garbage <- dev.off()
  #
}
#
# ############################################################
# Create plot to evaluate contributions to CO2 fluxes
# #############################################################
#
# Define x-axis
#
xlim=c(0,24)
xaxisout=24*seq(0,(1-incdateout),incdateout)
xaxislab=seq(0,24,2)
#
cexall=1.0
pchall=1.0
lwdall=1.0
#
for (seas in 1:length(namseas)) {
  #
  nam="Contrib_CO2_FLUX"
  lab="CO2 flux [umol/m²/s]"
  #
  data=array(NA,c(5,dim(co2_tot_dcyc_mod)))
  data[1,,]=co2_tot_dcyc_mod;data[2,,]=co2_veg_dcyc_mod
  data[3,,]=co2_tra_dcyc_mod;data[4,,]=co2_pop_dcyc_mod
  data[5,,]=co2_bld_dcyc_mod
  #
  ymin=-10
  ymax=80
  yinc=10
  #
  yaxis=seq(ymin,ymax,yinc)
  ylim=c(ymin,ymax)
  #
  pdf(paste(ppcyc,name,"/EVALMAST_",nam,"_",namseas[seas],".pdf",sep=""))
  par(mar=c(5,5,1,5))
  #
  plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
  #
  lines(x=xaxisout,y=data[1,seas,],pch=pchall,cex=cexall,lwd=2,col="black")
  lines(x=xaxisout,y=data[2,seas,],pch=pchall,cex=cexall,lwd=2,col="green")
  lines(x=xaxisout,y=data[3,seas,],pch=pchall,cex=cexall,lwd=2,col="blue")
  lines(x=xaxisout,y=data[4,seas,],pch=pchall,cex=cexall,lwd=2,col="magenta")
  lines(x=xaxisout,y=data[5,seas,],pch=pchall,cex=cexall,lwd=2,col="red")
  #
  axis(1,at=xaxislab,lab=xaxislab,las=1,cex.axis=1.3)
  axis(2,at=yaxis,lab=yaxis,las=2,cex.axis=1.3)
  #
  mtext(lab,side=2,line=3,cex=1.5,col="black")
  #
  legendvec=c("Total","Vegetation","Traffic","Metabolism","Heating")
  #
  legend("top",legendvec,lty=1,col=c("black","green","blue","magenta","red"),lwd=2,cex=1.2)
  #
  garbage <- dev.off()
  #
}
#
# ############################################################
# Plot weekly cycle of CO2 fluxes
# #############################################################
#
nameleg=c("Mast","TEB, Total","TEB, veg","TEB, Traffic","TEB, meta","TEB, bld")
colors=c("black","red","green","blue","cyan","magenta")
pathweek=paste(ppwee,name,"/",sep="")
system(paste("mkdir -p",pathweek))
#
vec_weekc=c("COOL","HEAT")
#
for (ii in 1:length(vec_weekc)) {
  #
  data=array(NA,c(7,6))
  if      (ii==1) data[,1]=co2_fluxcool_obs[1,]
  else if (ii==2) data[,1]=co2_fluxheat_obs[1,]
  else stop("No rule implemented for this plot")
  #
  data[,2]=co2_tot_week_mod[ii,]
  data[,3]=co2_veg_week_mod[ii,]
  data[,4]=co2_tra_week_mod[ii,]
  data[,5]=co2_pop_week_mod[ii,]
  data[,6]=co2_bld_week_mod[ii,]
  #
  plotweekcy(data,"EVALMAST_CO2","umol/m²/s","CO2 flux",vec_weekc[ii],name,nameleg,colors,path=pathweek)
  #
}
#
print("                                           ")
print("Results of 2D simulation have been plotted ")
print("                                           ")
#
}
#
# ##############################################
# Georeferenced plot of Meso-NH output
# ##############################################
#
seplotonline=function(lons,lats,fieldplot,nameplot,varname,nametitle,flaginc,
                      lplotstation=0,lplotshape=0,namesim=NA,seas=NA,perio=NA,variable=NA,
                      limdom=0,latmin=NA,latmax=NA,lonmin=NA,lonmax=NA,
		      lquiver=0,ut=NA,vt=NA,fzoom=NA,
                      lats_stat_1=NA,lons_stat_1=NA,numb_stat_1=NA,
	              lats_stat_2=NA,lons_stat_2=NA,numb_stat_2=NA,
	              lats_stat_3=NA,lons_stat_3=NA,numb_stat_3=NA) {
  #
  # ###################################
  # Extract subdomain if specified
  # ###################################
  #
  if (!is.na(fzoom)) {
    #
    amax=max(lats)
    amin=min(lats)
    adiff=(amax-amin)/2
    #
    latmax=amax+(1/fzoom-1)*adiff
    latmin=amin-(1/fzoom-1)*adiff
    #
    amax=max(lons)
    amin=min(lons)
    adiff=(amax-amin)/2
    #
    lonmax=amax+(1/fzoom-1)*adiff
    lonmin=amin-(1/fzoom-1)*adiff
    #
    ind_sel=which((lats>=latmin)&(lats<=latmax)&(lons>=lonmin)&(lons<=lonmax))
    #
    lats=lats[ind_sel]
    lons=lons[ind_sel]
    fieldplot=fieldplot[ind_sel]
    #
  }
  #
  # ###################################
  # Check entries
  # ###################################
  #
  if ((max(lats)>090.01)||(min(lats)<(-90.01)) ) stop("Error in latitude")
  if ((max(lons)>180.01)||(min(lons)<(-180.01))) stop("Error in longitude")
  #
  if (length(lats)!=length(lons))      stop("Inconsistant length of vectors")
  if (length(lats)!=length(fieldplot)) stop("Inconsistant length of vectors")
  #
  # Set missing data to NA
  #
  fieldplot[which(fieldplot==999)]=NA
  #
  # ###############################################################
  # Settings depending on variable
  # ###############################################################
  #
  if (length(which(!is.na(fieldplot)))>0) {
    amax=max(fieldplot,na.rm=TRUE)
    amin=min(fieldplot,na.rm=TRUE)
    diff=amax-amin
  } else {
    diff=0.0
  }
  #
  if ((diff>0.0001)&&(diff<1.0e+10)) {
    #
    # A: Temperature-related variables
    #
    if ( (varname=="TCANYON")||(grepl("T2M",varname))||(grepl("TWALL",varname))||(grepl("UHIMAX",varname))||
         (grepl("TMASS",varname))||(grepl("TRAD",varname))||(grepl("TROOF",varname))||
         (grepl("TROAD",varname))||(grepl("TFLOO",varname))||(grepl("TREAL",varname))||
         (grepl("TI_BLD",varname))||(grepl("TIBLD",varname))||(grepl("UTCI",varname))||(grepl("TEMPMME",varname)) ) {
      #
      if (flaginc<0.5) {
        #
        if      (diff<010.0) inc=0.50
        else if (diff<020.0) inc=1.00
        else if (diff<040.0) inc=2.00
        else if (diff<080.0) inc=4.00
        else if (diff<100.0) inc=5
        else if (diff<200.0) inc=10
        else if (diff<400.0) inc=20
        else if (diff<800.0) inc=40
        else inc=50
        #
        amin=inc*floor(amin/inc)
        amax=inc*floor(amax/inc)+inc
        #
        brks=seq(amin-inc/2,amax+inc/2,inc)
        #
        cols=rev(rainbow(length(brks)-1))
        #
        namebr=c()
        for (ll in 1:(length(brks)-1)) namebr=c(namebr,paste(brks[ll]+inc/2,""))
        #
      } else if (flaginc<1.5) {
        #
        if ((grepl("TRAD",varname))||(grepl("UTCI",varname))) {
          brks   = brks_utci_diff
          cols   = cols_temp_diff
          namebr = name_utci_diff
        } else {
          brks   = brks_temp_diff
          cols   = cols_temp_diff
          namebr = name_temp_diff
	}
      } else {
        #
	# Very fine differences
	#
        namebr=c("<-3","-2.8","-2.4","-2.0","-1.6","-1.2","-0.8","-0.4","0","0.4","0.8",
                   "1.2","1.6","2.0","2.4","2.8","> 3")
        #
        brks=c(-100,-3.0,-2.6,-2.2,-1.8,-1.4,-1.0,-0.6,-0.2,0.2,0.6,1.0,1.4,1.8,2.2,2.6,3.0,100)
        #
        cols = cols_temp_diff
        #
      }
    #
    # Relative humidity
    #
    } else if (grepl("RHME",varname)||grepl("RELHU",varname)||grepl("HU2M",varname)) {
      #
      if (flaginc<0.5) {
        #
        if      (diff<004.0) inc=0.25
        else if (diff<010.0) inc=0.50
        else if (diff<020.0) inc=1.00
        else if (diff<040.0) inc=2.00
        else if (diff<080.0) inc=4.00
        else if (diff<100.0) inc=5
        else if (diff<200.0) inc=10
        else if (diff<400.0) inc=20
        else if (diff<800.0) inc=40
        else inc=50
        #
        amin=inc*floor(amin/inc)
        amax=inc*floor(amax/inc)+inc
        #
        brks=seq(amin-inc/2,amax+inc/2,inc)
        cols=rev(rainbow(length(brks)-1))
        #
        namebr=array(NA,length(brks)-1)
        for (ll in 1:(length(brks)-1)) namebr[ll]=brks[ll]+inc/2
      #
      } else {
        brks   = brks_relh_diff
        cols   = cols_relh_diff
        namebr = name_relh_diff
      }
   #
   # Specific humidity
   #
   } else if ( (varname=="QCANYON")||(grepl("Q2M",varname))||(grepl("QSPEC",varname))) {
      #
      if (flaginc<0.5) {
        #
        if      (diff<004.0) inc=0.25
        else if (diff<010.0) inc=0.50
        else if (diff<020.0) inc=1.00
        else if (diff<040.0) inc=2.00
        else if (diff<080.0) inc=4.00
        else if (diff<100.0) inc=5
        else if (diff<200.0) inc=10
        else if (diff<400.0) inc=20
        else if (diff<800.0) inc=40
        else inc=50
        #
        amin=inc*floor(amin/inc)
        amax=inc*floor(amax/inc)+inc
        #
        brks=seq(amin-inc/2,amax+inc/2,inc)
        cols=rev(rainbow(length(brks)-1))
        namebr=array(NA,length(brks)-1)
        for (ll in 1:(length(brks)-1)) namebr[ll]=brks[ll]+inc/2
        #
      } else {
        brks   = brks_qspe_diff
        cols   = cols_qspe_diff
        namebr = name_qspe_diff
      }
   #
   # Remaining variables
   #
   } else if ( grepl("UMME",varname)||grepl("VMME",varname)||(varname=="INPRT")||
              (varname=="U_LOWCAN")||(varname=="RN")||grepl("FF_",varname)||
              (varname=="RAGG")||(varname=="PREC_HOURCUM")) {
      #
      if      (diff<004.0) inc=0.25
      else if (diff<010.0) inc=0.50
      else if (diff<020.0) inc=1.00
      else if (diff<040.0) inc=2.00
      else if (diff<080.0) inc=4.00
      else if (diff<100.0) inc=5
      else if (diff<200.0) inc=10
      else if (diff<400.0) inc=20
      else if (diff<800.0) inc=40
      else inc=50
      #
      amin=inc*floor(amin/inc)
      amax=inc*floor(amax/inc)+inc
      #
      brks=seq(amin-inc/2,amax+inc/2,inc)
      #
      cols=rev(rainbow(length(brks)-1))
      #
      namebr=array(NA,length(brks)-1)
      for (ll in 1:(length(brks)-1)) namebr[ll]=brks[ll]+inc/2
      #
    } else if ((varname=="H")||(varname=="LE")||(varname=="HAGG")||(varname=="LAGG")||
             (varname=="SENFABSTOR_MUL")||
             (varname=="H_WALLA")||(varname=="H_WALLB")||
             (varname=="H_ROOF") ) {
      #
      # Determination of scaling factor for breaks
      #
      absmax=max(abs(fieldplot),na.rm=TRUE)
      #
      if      (absmax<00100) {
        nscal=1
      } else if (absmax<00200) { 
        nscal=2
      } else if (absmax<00500) {
        nscal=5
      } else if (absmax<01000) {
        nscal=10
      } else if (absmax<02000) {
        nscal=20
      } else if (absmax<04000) {
        nscal=40
      } else {
         print(absmax)
	 print(varname)
         stop("Wrong input for plotting")
      }
      #
      brks=nscal*brks_flux
      cols=cols_flux
      #
      namebr=array(NA,length(brks)-1)
      for (ll in 1:(length(brks)-1)) namebr[ll]=paste(brks[ll]," - ",brks[ll+1],sep="")
      #
    } else if ((grepl("DIAGSHAD",varname))||(grepl("DIAGVENT",varname))||
             (grepl("BLDOCC",varname))||(grepl("VRAT",varname)) ) {
      brks=brks_frac
      cols=cols_water
      namebr=name_frac
    } else if ( (varname=="INFCALC")||grepl("SWD",varname)||
              (varname=="ROAD_SHADE")||grepl("LWD",varname)||(grepl("DIAGVEFL",varname))||
              (grepl("WIFF",varname))||(grepl("WFF",varname))||(grepl("WG",varname)) ) {
      #
      if (flaginc<0.5) {
        amin=0
        diff=amax-amin
      }
      #
      if      (diff<000.1) inc=00.01
      else if (diff<001.0) inc=00.10
      else if (diff<002.0) inc=00.2
      else if (diff<004.0) inc=00.4
      else if (diff<020.0) inc=01.0
      else if (diff<040.0) inc=02.0
      else if (diff<100.0) inc=05.0
      else if (diff<200.0) inc=10.0
      else if (diff<400.0) inc=20.0
      else if (diff<800.0) inc=40.0
      else inc=50
      #
      amin=inc*floor(amin/inc)
      amax=inc*floor(amax/inc)+inc
      #
      brks=seq(amin,amax,inc)
      #
      if (flaginc<0.5) {
        cols=rev(heat.colors(length(brks)-1))
      } else {
        cols=rev(rainbow(length(brks)-1))
      }
      #
      namebr=array(NA,length(brks)-1)
      for (ll in 1:(length(brks)-1)) namebr[ll]=brks[ll]+inc/2
      #
    } else if ((varname=="H_TRAFFIC_MUL" )||(varname=="LE_TRAFFIC_MUL" )||
             (varname=="H_INDUSTRY_MUL")||(varname=="LE_INDUSTRY_MUL")||
             (varname=="HVAC_HT_MUL")||(varname=="HVAC_CL_MUL")||
             (varname=="QINACT_MUL")||(varname=="QANT_TOTAL")||
	     (varname=="QANT_BUILDINGS")||(varname=="QINHOTW_MUL")) {
      #
      cols=cols_qant
      #
      if ( (grepl("Hong",nameplot)||grepl("HK",nameplot)) ) {
        brks=brks_qant_hk
        namebr=name_qant_hk
      } else {
        brks=brks_qant
        namebr=name_qant
      }
      #
    } else if ((varname=="ALB_ROOF")||(varname=="EMIS_ROOF")||
               (varname=="ALB_ROAD")||(varname=="EMIS_ROAD")||
               (varname=="ALB_WALL")||(varname=="EMIS_WALL")||
               (varname=="ROOF_TK") ||(varname=="WALL_TK")||
               (varname=="MASS_TK") ) {
      #
      amin=0
      amax=1
      inc=0.1
      #
      brks=seq(0,amax,inc)
      #
      cols=rev(rainbow(length(brks)-1))
      namebr=array(NA,length(brks)-1)
      for (ll in 1:(length(brks)-1)) namebr[ll]=brks[ll]+inc/2
      #
    } else if (varname=="D_BLDTYPE") {
      cols=cols_bldtype
      brks=brks_bldtype
      namebr=name_bldtype
    } else if ((varname=="D_IBLDAGE")||(varname=="D_CBLDAGE")) {
      cols=cols_bldage
      brks=brks_bldage
      namebr=name_bldage
    } else if (varname=="D_P1TERR") {
      fieldplot[which(fieldplot==1)]=NA
      cols=cols_territo[4:nter]
      brks=brks_territo[4:(nter+1)]
      namebr=name_territo[4:nter]
    } else if (varname=="D_PXTERR") {
      cols=cols_territo
      brks=brks_territo
      namebr=name_territo
    } else if (varname=="D_USETYPE") {
      cols=cols_blduse
      brks=brks_blduse
      namebr=name_blduse
    } else if (varname=="ZS") {
      #
      cols=cols_terrain
      #
      if (grepl("Toulouse",nameplot)) {
        brks   = brks_terrain_toulouse
        namebr = name_terrain_toulouse
      } else if (grepl("Dijon",nameplot)) {
        brks   = brks_terrain_dijon
        namebr = name_terrain_dijon
      } else if ( (grepl("Hong",nameplot))||(grepl("HK",nameplot)) ) {
        brks   = brks_terrain_hk
        namebr = name_terrain_hk
      } else {
        brks   = brks_terrain
        namebr = name_terrain
      }
      #
    } else if ((varname=="FRAC_WATER")||(varname=="FRAC_SEA")  ||grepl("FRAC_",varname)||
               (varname=="D_FRACIHS") ||(varname=="D_FRACCHS") ||
               (varname=="D_FRACCOM") ||(varname=="D_FRACTER") ||(varname=="D_FRACNHE")||
               (varname=="D_FRACIND") ||(varname=="D_FRACPAV") ||
               (varname=="D_FRACMRI") ||(varname=="D_FRACHRI") ||
               (varname=="D_FRACATB") )  {
      cols=cols_water
      brks=brks_frac
      namebr=name_frac
    } else if ((varname=="D_FOEQI_MAIS") ||(varname=="D_FOEQI_APPT")||
               (varname=="D_FAEQI_MAIS") ||(varname=="D_FAEQI_APPT")||
               (varname=="D_CRE_MAIS")   ||(varname=="D_CRE_APPT") )  {
      cols=cols_town
      brks=brks_frac
      namebr=name_frac
    } else if ((varname=="FRAC_TOWN")) {
      cols=cols_town
      brks=brks_frac
      namebr=name_frac
    } else if ((varname=="D_BLDFRA")) {
      cols=cols_blda
      brks=brks_frac
      namebr=name_frac
    } else if ((varname=="FRAC_NATURE")||(varname=="D_GARDEN")||(grepl("COVER",var))||
               (varname=="D_FRAC_HVEG")||(varname=="D_FRAC_LVEG")||
               (varname=="D_FRAC_NVEG")||(varname=="CLAY")||(varname=="SAND") ) {
      cols=cols_nature
      brks=brks_frac
      namebr=name_frac
    } else if (varname=="D_BLD_HEIG") {
      #
      cols=cols_heig
      #
      if ( (grepl("Hong",nameplot)||grepl("HK",nameplot)) ) {
        brks=brks_heig_hk
        namebr=name_heig_hk
      } else {
        brks=brks_heig
        namebr=name_heig
      }
      #
    } else if (varname=="D_WALL_O_H") {
      cols=cols_woho
      #
      if ( (grepl("Hong",nameplot)||grepl("HK",nameplot)) ) {
        brks=brks_woho_hk
        namebr=name_woho_hk
      } else {
        brks=brks_woho
        namebr=name_woho
      }
      #
    } else if ((varname=="D_H_IND")||(varname=="D_LE_IND")||(varname=="D_LE_TRAF")||(varname=="D_H_TRAF")) {
      #
      cols=cols_qant
      #
      if ( (grepl("Hong",nameplot)||grepl("HK",nameplot)) ) {
        brks=brks_qant_hk
        namebr=name_qant_hk
      } else {
        brks=brks_qant
        namebr=name_qant
      }
      #
    } else if (varname=="D_NB_POP") {
      cols=cols_nbpop
      brks=brks_nbpop
      namebr=name_nbpop
    } else if (varname=="ZS") {
      cols=cols_terrain
      brks=brks_terrain
      namebr=name_terrain
    } else {
      print(varname)
      stop("No rule implemented for plotting this variable")
    }
    #
    # Convert fieldplot into classes
    #
    fieldplotclasses=array(NA,length(fieldplot))
    for (ii in 2:length(brks)) {
      ind=which((fieldplot>=brks[ii-1])&(fieldplot<brks[ii]))
      fieldplotclasses[ind]=ii-1
    }
    fieldplot=as.vector(fieldplotclasses)
    #
    # Remove unused part of colorscale
    #
    brks_old=seq(0.5,max(fieldplot,na.rm=TRUE)+0.5,1)
    brks    =seq((min(fieldplot,na.rm=TRUE)-0.5),(max(fieldplot,na.rm=TRUE)+0.5),1)
    #
    nremove=min(fieldplot,na.rm=TRUE)-1.0
    #
    cols_old=cols
    cols=cols[(nremove+1):length(cols)]
    #
    # Write values onto raster
    #
    lons_unique=unique(lons)
    lats_unique=unique(lats)
    #
    dy_vec=array(NA,(length(lats_unique)-1))
    dx_vec=array(NA,(length(lons_unique)-1))
    #
    for (ii in 2:length(lons_unique)) dx_vec[ii-1] = lons_unique[ii]-lons_unique[ii-1]
    for (ii in 2:length(lats_unique)) dy_vec[ii-1] = lats_unique[ii]-lats_unique[ii-1]
    #
    dx=mean(dx_vec)
    dy=mean(dy_vec)
    #
    lonmin=min(lons);lonmax=max(lons)
    latmin=min(lats);latmax=max(lats)
    #
    nyp=length(which(lons==lonmin))
    nxp=length(which(lats==latmin))
    #
    fieldplotrev=as.vector(length(fieldplot))
    #
    for (ii in 1:nyp) {
      indbeg=1+(ii-1)*nxp
      indend=ii*nxp
      fieldplotrev[indbeg:indend]=rev(fieldplot[indbeg:indend])
    }
    fieldplot=fieldplotrev
    #
    exte=c(lonmin-0.50*dx,lonmax+0.50*dx,latmin-0.50*dy,latmax+0.50*dy)
    #
    rast_plot=raster(extent(exte))
    projection(rast_plot) = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs +towgs84=0,0,0"
    res(rast_plot) = c(dx,dy)
    #
    vec_check=getValues(rast_plot)
    #
    if (length(vec_check)!=length(fieldplot)) {
      print(length(vec_check))
      print(length(fieldplot))
      stop("Inconsistant length of vectors")
    } 
    #
    rast_plot=setValues(rast_plot,rev(fieldplot))
    #
    # Create plot
    #
    heigplot=5.32
    widtplot=6.50
    cexall=1.4
    #
    pdf(nameplot,width=widtplot,height=heigplot)
    par(mar=c(4.0,5.5,2.0,0.5))
    par(oma=c(0,0,0,2))
    #
    if (grepl("ZS",nameplot)) {
      arg=list(at=seq(1,length(namebr),1),labels=namebr,line=0,cex.axis=1.0)
    } else {
      arg=list(at=seq(1,length(namebr),1),labels=namebr,line=0,cex.axis=0.95*cexall)
    }
    #
    plot(rast_plot,breaks=brks,col=cols,axis.args=arg,xlab=NA,ylab=NA,axes=FALSE,
         cex.axis=cexall,cex.lab=cexall,alpha=1,colNA="white",add=FALSE,
         useRaster=TRUE,interpolate=FALSE)
    #
    # Create axes
    #
    LST=sescale(lats)
    ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
    yaxis=seq(ymin,ymax-yinc,yinc)
    ylim=c(ymin,ymax)
    #
    LST=sescale(lons)
    xmin=LST$amin;xmax=LST$amax;xinc=LST$inc
    xaxis=seq(xmin,xmax-xinc,xinc)
    xlim=c(xmin,xmax)
    #
    # Option to include ° symbol
    #
    xname=c()
    for (ii in 1:length(xaxis)) xname=c(xname,paste(xaxis[ii],"",sep=""))
    #
    yname=c()
    for (ii in 1:length(yaxis)) yname=c(yname,paste(yaxis[ii],"",sep=""))
    #
    # Write title and axis names
    #
    title("")
    mtext(nametitle,col="black",side=3,line=0.3,adj=0.5,outer=FALSE,cex=1.2*cexall)
    #
    axis(1,at=xaxis,lab=xname,lwd=1,las=1,cex.axis=cexall)
    axis(2,at=yaxis,lab=yname,lwd=1,las=1,cex.axis=cexall)
    #
    mtext("Geographical longitude [°E]",col="black",side=1,line=2.3,adj=0.5,outer=FALSE,cex=cexall)
    mtext("Geographical latitude [°N]" ,col="black",side=2,line=3.7,adj=0.5,outer=FALSE,cex=cexall)
    #
    # Draw scalebar
    #
    xscale = 0.70*min(lons) + 0.30*max(lons)
    yscale = 0.98*min(lats) + 0.02*max(lats)
    #
    adiff=111.0*(max(lons)-min(lons))*cos(3.14*mean(lats)/180)
    #
    if (adiff<10) {
      lenscale=4
    } else if (adiff<40) {
      lenscale=10
    } else if (adiff<100) {
      lenscale=20
    } else if (adiff<200) {
      lenscale=80      
    } else if (adiff<1000) {
      lenscale=400
    } else if (adiff<10000) {
      lenscale=4000
    } else {
      stop("No rule implemented for this plot size")
    }
    #
    if ( grepl("ZS",nameplot) || grepl("D_BLDFRA",nameplot) || grepl("TREAL_2M",nameplot) || grepl("TEMPMME",nameplot) ) {
      col_bar="black"
    } else {
      col_bar="white"
    }
    #
    scalebar(lenscale,xy=c(xscale,yscale),type="bar",divs=4,label=c(paste(0,"km"),paste(lenscale/2,"km"),paste(lenscale,"km")),lonlat=TRUE,col=col_bar)
    #
    # Case where wind vectors shall be plotted
    #
    if (lquiver>0.5) {
      #
      wiff=sqrt(ut*ut+vt*vt)
      #
      npoints=length(lats)
      nsel=floor(npoints/(24*24))
      indsel=seq(1,npoints,nsel)
      #
      x        = lons[indsel]
      y        = lats[indsel]
      ut_sel   = ut[indsel]
      vt_sel   = vt[indsel]
      wiff_sel = wiff[indsel]
      #
      scale=(1/5/max(wiff_sel))*(1/40)*max(c(heigplot,widtplot))
      length=0.1
      quiver(x,y,ut_sel,vt_sel,scale=scale,length=length)
      #
      title("")
      par(xpd=TRUE)
      #
      # Write indication of arrow length
      #
      min_x=min(lons);max_x=max(lons)
      min_y=min(lats);max_y=max(lats)
      #
      if (max(wiff_sel)>1.0) {
        wiff_display=floor(max(wiff_sel))
      } else {
        wiff_display=0.1*floor(max(wiff_sel*10))
      }
      #
      leng_display=scale*wiff_display
      leng_arrow  = leng_display/3
      #
      xseg0=-0.07*min_x+1.07*max_x
      yseg0=+0.95*min_y+0.05*max_y
      #
      xseg1=xseg0+leng_display
      yseg1=yseg0
      #
      ydiff=max_y-min_y
      # 
      segments(x0=xseg0,y0=yseg0,x1=xseg1,y1=yseg1,col="black",lty=1,lwd=1.5)
      segments(x0=xseg1-leng_arrow,y0=yseg0+0.7*leng_arrow,x1=xseg1,y1=yseg1,col="black",lty=1,lwd=1.5)
      segments(x0=xseg1-leng_arrow,y0=yseg0-0.7*leng_arrow,x1=xseg1,y1=yseg1,col="black",lty=1,lwd=1.5)
      #
      string_text=paste(wiff_display,"m/s")
      #
      text(x=0.5*(xseg0+xseg1),y=yseg0+3*leng_arrow,labels=string_text,cex=cexall,col="black")
      #
    }
    #
    # Plot shapefile on top of raster
    #
    if (lplotshape>0.5) {
      #
      shaperead=readOGR(dsn="/home/schoetterr/Bureau/PROJETS/PAENDORA/TISSU_URBAIN/DonneesSpatialisees/DONNEES_SIG_JULIA/",layer="TLSE_METROPOLE",verbose=FALSE)
      #
      shaperead_WGS = spTransform(shaperead,CRS("+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"))
      #
      plot(shaperead_WGS,col=NA,border="white",lwd=2,add=TRUE)
      #
    }
    #
    # Case where stations shall be plotted (up to 3 station networks)
    #
    if (lplotstation>0.5) {
      #
      if (grepl("Toulouse",nameplot)) {
        cex_stations=0.9
      } else if (grepl("Dijon",nameplot)) {
        cex_stations=0.6
      } else {
        cex_stations=1.0
      }
      #
      for (network in c(1,2,3)) {
        #
	if        (network==1) {
          lons_netw=lons_stat_1
          lats_netw=lats_stat_1
	  numb_netw=numb_stat_1
	  if (grepl("ZS",nameplot)) {
            colr_netw="black"
	  } else {
            # colr_netw="blue1"
            colr_netw="black"
          }
        } else if (network==2) {
          lons_netw=lons_stat_2
          lats_netw=lats_stat_2
	  numb_netw=numb_stat_2
	  if (grepl("ZS",nameplot)) {
            colr_netw="white"
	  } else {
            colr_netw="black"
          }
        } else if (network==3) {
          lons_netw=lons_stat_3
          lats_netw=lats_stat_3
	  numb_netw=numb_stat_3
	  if (grepl("ZS",nameplot)) {
	    colr_netw="white"
	  } else {
	    colr_netw="yellow"
	  }
        } else {
          stop("No rule implemented for this station network")
        }
        #
        if (!is.na(lons_netw[1])) {
          #
          points(lons_netw,lats_netw,pch=19,cex=0.8*cex_stations,col=colr_netw)
          #
          pch_vec=c()
          # for (stat in 1:length(numb_netw)) pch_vec=c(pch_vec,sprintf("%2d",numb_netw[stat]))
          for (stat in 1:length(numb_netw)) pch_vec=c(pch_vec,numb_netw[stat])
          #
          lons_inc=array(NA ,length(lons_netw))
          lats_inc=array(0.0,length(lats_netw))
          #
          cfl=cex_stations*3.7
          #
          lons_inc[which(numb_netw< 10)]=cfl*0.004
          lons_inc[which(numb_netw> 10)]=cfl*0.007
          #
          lons_inc[which(numb_netw==10)]=cfl*0.005
          lats_inc[which(numb_netw==10)]=cfl*(-0.004)
          #
	  if (!is.na(fzoom)) {
            lons_inc=lons_inc/fzoom
            lats_inc=lats_inc/fzoom	    
          }
	  #
          text(lons_netw+lons_inc,lats_netw+lats_inc,col=colr_netw,cex=cex_stations,lwd=2,labels=pch_vec)
          #
        }
      }
    }
    #
    garbage <- dev.off()
    #
  }
  #
}
#
# ##################################################
# Create plots for sensitivity study
# ##################################################
#
seplotsens=function(case,cases,lplotfor=1,leval=1,colors=cols,ltys=ltys,nameleg) {
#
# Create directories for this plot
#
filebase=paste(ppday,case,sep="")
system(paste("rm -Rf",filebase))
system(paste("mkdir",filebase))
#
filebase=paste(ppcyc,case,sep="")
system(paste("rm -Rf",filebase))
system(paste("mkdir",filebase))
#
filebase=paste(ppwee,case,sep="")
system(paste("rm -Rf",filebase))
system(paste("mkdir",filebase))
#
ncase=length(cases)
#
# Load model output
#
# Date
#
load(file=paste(pdata,"/",cases[1],"/Basic",sep=""))
#
nday=LST$nday
datejulsimout=LST$datejulvecout;datejulsimfor=LST$datejulvecfor
#
timedayout=datejulsimout[which(datejulsimout==floor(datejulsimout))]
timedayfor=datejulsimfor[which(datejulsimfor==floor(datejulsimfor))]
#
# Get field dimensions
#
load(file=paste(pdata,"/",cases[1],"/",outva[1],sep=""))
#
dimdayav=dim(LST$outdayav)
dimdaycy=dim(LST$outdaycyc)
#
# Allocate fields
#
outdayavall=array(NA,c(lout,nday,ncase))
outdaycyall=array(NA,c(lout,4,(1/incdateout),ncase))
outcoolwd=array(NA,c(lout,2,7,ncase))
outheatwd=array(NA,c(lout,2,7,ncase))
#
if (lplotfor>0.5) {
  fordayavall=array(NA,c(lfor,nday,ncase))
  fordaycyall=array(NA,c(lfor,4,(1/incdatefor),ncase))
  forcoolwd=array(NA,c(lfor,2,7,ncase))
  forheatwd=array(NA,c(lfor,2,7,ncase))
}
#
# Load simulated data
#
for (cas in 1:ncase) {
  #
  # Forcing data in basic file (except weekly cycles)
  #
  if (lplotfor>0.5) {
    #
    load(file=paste(pdata,"/",cases[cas],"/Basic",sep=""))
    fordayavall[,,cas]=LST$fordayav
    fordaycyall[,,,cas]=LST$fordaycyc
    #
    load(file=paste(pdata,"/",cases[cas],"/",outva[1],sep=""))
    forcoolwd[,,,cas]=LST$fordayavcoolwd
    forheatwd[,,,cas]=LST$fordayavheatwd
    #
  }
  #
  # Model output in separate files for each variable
  #
  for (var in 1:lout) {
    #
    fload=paste(pdata,"/",cases[cas],"/",outva[var],sep="")
    #
    if (file.exists(fload)) {
      #
      load(file=fload)
      #
      outdayavall[var,,cas] =LST$outdayav
      outdaycyall[var,,,cas]=LST$outdaycyc
      #
      outcoolwd  [var,,,cas]=LST$outdayavcoolwd
      outheatwd  [var,,,cas]=LST$outdayavheatwd
      #
    }
  }
  #
}
#
# Load observation based data
#
if (leval>0.5) {
  #
  # CAPITOUL inventory
  #
  fobs=paste(pdata,"OBSDAT",sep="")
  if (!file.exists(fobs)) seprepobs(fobs,timedayout,timedayfor)
  #
  load(file=fobs)
  #
  dateobs=LST$dateobs;hantobs=LST$hantobs;heleobs=LST$heleobs
  htraobs=LST$htraobs;hgasobs=LST$hgasobs;dateobshalf=LST$dateobshalf
  heleobshalf=LST$heleobshalf;htraobshalf=LST$htraobshalf
  hgasobshalf=LST$hgasobshalf;dayofweek=LST$dayofweek
  hantobscoolwd=LST$hantobscoolwd;heleobscoolwd=LST$heleobscoolwd
  htraobscoolwd=LST$htraobscoolwd;hgasobscoolwd=LST$hgasobscoolwd
  hantobsheatwd=LST$hantobsheatwd;heleobsheatwd=LST$heleobsheatwd
  htraobsheatwd=LST$htraobsheatwd;hgasobsheatwd=LST$hgasobsheatwd
  hantobscoolwd=LST$hantobscoolwd;heleobscoolwd=LST$heleobscoolwd
  htraobscoolwd=LST$htraobscoolwd;hgasobscoolwd=LST$hgasobscoolwd
  hantobsheatwd=LST$hantobsheatwd;heleobsheatwd=LST$heleobsheatwd
  htraobsheatwd=LST$htraobsheatwd;hgasobsheatwd=LST$hgasobsheatwd
  #
  heleobsdcyc=LST$heleobsdcyc;htraobsdcyc=LST$htraobsdcyc
  hgasobsdcyc=LST$hgasobsdcyc;hantobsdcyc=LST$hantobsdcyc
  #
  # CAPITOUL mast observations
  #
  fobs=paste(pdata,"MASTDAT",sep="")
  if (!file.exists(fobs)) seprepmast(fobs)
  load(file=fobs)
  #
  sencoolwd=LST$sencoolwd;latcoolwd=LST$latcoolwd;radcoolwd=LST$radcoolwd
  senheatwd=LST$senheatwd;latheatwd=LST$latheatwd;radheatwd=LST$radheatwd
  datdayav=LST$datdayav;juldayav=LST$juldayav;sendayav=LST$sendayav
  latdayav=LST$latdayav;raddayav=LST$raddayav;sendcyc=LST$sendcyc
  latdcyc=LST$latdcyc;raddcyc=LST$raddcyc
  #
}
#
# Create plots
#
if (leval>0.5) {
#
# A: Evaluation of the anthropogenic heat flux by comparison of
# - QANT derived from mast observations
# - QANT derived from inventory 
# - QANT simulated (traffic+industry+HVAC_CL+HVAC_HT+QINACT)
#
poshtrasim=which(outva=="H_TRAACT")
poshindsim=which(outva=="H_INDACT")
poshqinsim=which(outva=="QINACT")
poshcoosim=which(outva=="HVAC_CL")
poshheasim=which(outva=="HVAC_HT")
#
for (ii in 1:length(cases)) {
  #
  nameplo=cases[ii]
  #
  posta=which(forva=="TA")
  if (lplotfor>0.5) taforcing=fordayavall[posta,,ii]
  #
  htrasimtsday=outdayavall[poshtrasim,,ii]
  hindsimtsday=outdayavall[poshindsim,,ii]
  hqinsimtsday=outdayavall[poshqinsim,,ii]
  hcoosimtsday=outdayavall[poshcoosim,,ii]
  hheasimtsday=outdayavall[poshheasim,,ii]
  #
  htrasimdaycy=outdaycyall[poshtrasim,,,ii]
  hindsimdaycy=outdaycyall[poshindsim,,,ii]
  hqinsimdaycy=outdaycyall[poshqinsim,,,ii]
  hcoosimdaycy=outdaycyall[poshcoosim,,,ii]
  hheasimdaycy=outdaycyall[poshheasim,,,ii]
  #
  htrasimcoowd=outcoolwd[poshtrasim,,,ii]
  hindsimcoowd=outcoolwd[poshindsim,,,ii]
  hqinsimcoowd=outcoolwd[poshqinsim,,,ii]
  hcoosimcoowd=outcoolwd[poshcoosim,,,ii]
  hheasimcoowd=outcoolwd[poshheasim,,,ii]
  #
  htrasimheawd=outheatwd[poshtrasim,,,ii]
  hindsimheawd=outheatwd[poshindsim,,,ii]
  hqinsimheawd=outheatwd[poshqinsim,,,ii]
  hcoosimheawd=outheatwd[poshcoosim,,,ii]
  hheasimheawd=outheatwd[poshheasim,,,ii]
  #
  # Calculate the total anthropogenic heat
  # CAUTION: one part might be latent heat (e.g. in zqin)
  #
  hqansimtsday=hqinsimtsday+hcoosimtsday+hheasimtsday+htrasimtsday+hindsimtsday
  hqansimdaycy=hqinsimdaycy+hcoosimdaycy+hheasimdaycy+htrasimdaycy+hindsimdaycy
  hqansimcoowd=hqinsimcoowd+hcoosimcoowd+hheasimcoowd+htrasimcoowd+hindsimcoowd
  hqansimheawd=hqinsimheawd+hcoosimheawd+hheasimheawd+htrasimheawd+hindsimheawd
  #
  if (lplotfor<0.5) taforcing=array(NA,length(htrasimtsday))
  #
  seplotevalflx(taforcing,htrasimtsday,hindsimtsday,hqinsimtsday,hcoosimtsday,hheasimtsday,hqansimtsday,
                htrasimdaycy,hindsimdaycy,hqinsimdaycy,hcoosimdaycy,hheasimdaycy,hqansimdaycy,
                htrasimcoowd,hindsimcoowd,hqinsimcoowd,hcoosimcoowd,hheasimcoowd,hqansimcoowd,
                htrasimheawd,hindsimheawd,hqinsimheawd,hcoosimheawd,hheasimheawd,hqansimheawd,
                dateobs,hantobs,heleobs,htraobs,hgasobs,heleobsdcyc,htraobsdcyc,hgasobsdcyc,
                hantobscoolwd,heleobscoolwd,htraobscoolwd,hgasobscoolwd,hantobsheatwd,
                heleobsheatwd,htraobsheatwd,hgasobsheatwd,dayofweek,incdateout,case,nameplo)
  #
  htotobs=hgasobs+heleobs+htraobs
  #
  # Create scatterplot (anthropogenic heat vs. air temperature)
  #
  if (length(which(!is.na(taforcing)))>0) sescattta(htotobs,hantobs,taforcing,hqansimtsday,case,nameplo)
  #
}
#
# Create a plot with the evaluation measures
#
# seplotmeas(cases,case)
#
# B: Evaluation against mast observations
# - town sensible heat flux
# - town latent heat flux 
# - town radiation budget
#
poshtebsim=which(outva=="H_TEB")
posltebsim=which(outva=="LE_TEB")
posrtebsim=which(outva=="RN_TEB")
#
for (ii in 1:length(cases)) {
  #
  nameplo=cases[ii]
  #
  htebsimtsday=outdayavall[poshtebsim,,ii]
  ltebsimtsday=outdayavall[posltebsim,,ii]
  rtebsimtsday=outdayavall[posrtebsim,,ii]
  #
  htebsimdaycy=outdaycyall[poshtebsim,,,ii]
  ltebsimdaycy=outdaycyall[posltebsim,,,ii]
  rtebsimdaycy=outdaycyall[posrtebsim,,,ii]
  #
  htebsimcoowd=outcoolwd[poshtebsim,,,ii]
  ltebsimcoowd=outcoolwd[posltebsim,,,ii]
  rtebsimcoowd=outcoolwd[posrtebsim,,,ii]
  #
  htebsimheawd=outheatwd[poshtebsim,,,ii]
  ltebsimheawd=outheatwd[posltebsim,,,ii]
  rtebsimheawd=outheatwd[posrtebsim,,,ii]
  #
  seplotevalmast(htebsimtsday,ltebsimtsday,rtebsimtsday,htebsimdaycy,ltebsimdaycy,rtebsimdaycy,
                 htebsimcoowd,ltebsimcoowd,rtebsimcoowd,htebsimheawd,ltebsimheawd,rtebsimheawd,
                 sencoolwd,latcoolwd,radcoolwd,senheatwd,latheatwd,radheatwd,sendayav,latdayav,
                 raddayav,sendcyc,latdcyc,raddcyc,juldayav,dayofweek,case,nameplo)
  #
}
}
#
# C: Plot time series of daily averages
#
if (lplotfor>0.5) for (inp in 1:lfor) plottsdav(fordayavall[inp,,,drop=FALSE],timedayfor,forva[inp],unifor[inp],namfor[inp],case,nameleg,colors,ltys,path=paste(ppday,case,"/",sep=""))
for (inp in 1:lout) plottsdav(outdayavall[inp,,,drop=FALSE],timedayout,outva[inp],uniout[inp],namout[inp],case,nameleg,colors,ltys,path=paste(ppday,case,"/",sep=""))
#
# D: Plot average diurnal cycle for each season
#
for (seas in 1:4) {
  if (lplotfor>0.5) for (inp in 1:lfor) plotdaycy(fordaycyall[inp,seas,,,drop=FALSE],incdatefor,forva[inp],unifor[inp],namfor[inp],namseas[seas],case,nameleg,colors,ltys,path=paste(ppcyc,case,"/",sep=""))
  for (inp in 1:lout) plotdaycy(outdaycyall[inp,seas,,,drop=FALSE],incdateout,outva[inp],uniout[inp],namout[inp],namseas[seas],case,nameleg,colors,ltys,path=paste(ppcyc,case,"/",sep=""))
}
#
# E: Plot average weekly cycle (Heating and cooling season)
#
if (lplotfor>0.5) for (inp in 1:lfor) plotweekcy(forcoolwd[inp,1,,,drop=FALSE],forva[inp],unifor[inp],namfor[inp],"COOL",case,nameleg,colors,path=paste(ppwee,case,"/",sep=""))
for (inp in 1:lout) plotweekcy(outcoolwd[inp,1,,,drop=FALSE],outva[inp],uniout[inp],namout[inp],"COOL",case,nameleg,colors,path=paste(ppwee,case,sep=""))
#
if (lplotfor>0.5) for (inp in 1:lfor) plotweekcy(forheatwd[inp,1,,,drop=FALSE],forva[inp],unifor[inp],namfor[inp],"HEAT",case,nameleg,colors,path=paste(ppwee,case,"/",sep=""))
for (inp in 1:lout) plotweekcy(outheatwd[inp,1,,,drop=FALSE],outva[inp],uniout[inp],namout[inp],"HEAT",case,nameleg,colors,path=paste(ppwee,case,"/",sep=""))
#
}#

# ####################################################
# Plot the different nests of a Meso-NH simulation
# ####################################################
#
se_plot_domains=function(namesim,nnest,scen,supcmp) {
#
print(" ")
print(paste("Create domain plots for",namesim))
#
# Download PGD data from supercomputer
#
# pout=paste(pdsup,namesim,"/",sep="")
# dir.create(pout,showWarnings=FALSE)
#
# for (sce in 1:length(scen)) {
#   #
#   pout=paste(pdsup,namesim,"/",scen[sce],sep="")
#   dir.create(pout,showWarnings=FALSE)
# #
#  pout=paste(pdsup,namesim,"/",scen[sce],"/PGD",sep="")
#  dir.create(pout,showWarnings=FALSE)
#  #
#  for (nest in 1:nnest) {
#    #
#    pout=paste(pdsup,namesim,"/",scen[sce],"/PGD/PREP_PGD_NEST_",nest,sep="")
#    dir.create(pout,showWarnings=FALSE)
#    #
#    pathin=paste(pscra,namesim,"/",scen[sce],"/PREP_PGD_NEST_",nest,"/DIAG/*",sep="")
#    system(paste("scp schoetterr@",supcmp,":",pathin," ",pout," >> OUTBIN 2>> OUTBIN",sep=""))
#    system("rm -f ./OUTBIN")
#    #
#  }
#  #
# }
#
# Create domain plot
#
# Load fractions of SURFEX tiles
#
latmin_nests=array(NA,nnest)
latmax_nests=array(NA,nnest)
lonmin_nests=array(NA,nnest)
lonmax_nests=array(NA,nnest)
#
for (nest in 1:nnest) {
  #
  LST=myno_map(paste0(pdsup,namesim,"/REFER/PGD/PREP_PGD_NEST_",nest,"/PGD_Nest_",nest,"_FRAC_TOWN.nc4"))
  FRAC_TOWN=LST$data_map
  #
  LST=myno_map(paste0(pdsup,namesim,"/REFER/PGD/PREP_PGD_NEST_",nest,"/PGD_Nest_",nest,"_FRAC_SEA.nc4"))
  FRAC_SEA=LST$data_map
  #
  LST=myno_map(paste0(pdsup,namesim,"/REFER/PGD/PREP_PGD_NEST_",nest,"/PGD_Nest_",nest,"_FRAC_WATER.nc4"))
  FRAC_WATER=LST$data_map
  #
  LST=myno_map(paste0(pdsup,namesim,"/REFER/PGD/PREP_PGD_NEST_",nest,"/PGD_Nest_",nest,"_FRAC_NATURE.nc4"))
  FRAC_NATURE=LST$data_map
  #
  LST=myno_map(paste0(pdsup,namesim,"/REFER/PGD/PREP_PGD_NEST_",nest,"/PGD_Nest_",nest,"_LAT.nc4"))
  lats=LST$data_map
  #
  LST=myno_map(paste0(pdsup,namesim,"/REFER/PGD/PREP_PGD_NEST_",nest,"/PGD_Nest_",nest,"_LON.nc4"))
  lons=LST$data_map
  #
  LST=myno_map(paste0(pdsup,namesim,"/REFER/PGD/PREP_PGD_NEST_",nest,"/PGD_Nest_",nest,"_ZS.nc4"))
  heig=LST$data_map
  #
  latmin_nests[nest]=min(lats)
  latmax_nests[nest]=max(lats)
  lonmin_nests[nest]=min(lons)
  lonmax_nests[nest]=max(lons)
  #
  ctl=FRAC_TOWN+FRAC_SEA+FRAC_WATER+FRAC_NATURE
  if (max(abs(ctl-1.0)) > 1.0e-6) stop("Wrong tile fractions")
  #
  if (nest==1) {
    lats_plot        = lats
    lons_plot        = lons
    heig_plot        = heig
    FRAC_TOWN_plot   = FRAC_TOWN
    FRAC_NATURE_plot = FRAC_NATURE
    FRAC_WATER_plot  = FRAC_WATER
    FRAC_SEA_plot    = FRAC_SEA  
  }
  #
}
#
# 2 plots:
# - Main COVER
# - Elevation
#
for (lplot in 1:2) {
  #
  if (lplot==1) {
    #
    printl="Landuse"
    #
    titleplot="Surface cover and model domains"
    #
    # Convert field into classes
    #
    fieldclasses=array(NA,length(heig_plot))
    #
    name=c("Sea","Lakes","Rural","Urbanised","Elev. > 1500 m")
    #
    ind=which((FRAC_SEA_plot>=FRAC_WATER_plot)&(FRAC_SEA_plot>=FRAC_NATURE_plot)&(FRAC_SEA_plot>=FRAC_TOWN_plot))
    fieldclasses[ind]=1
    #
    ind=which((FRAC_WATER_plot>=FRAC_SEA_plot)&(FRAC_WATER_plot>=FRAC_NATURE_plot)&(FRAC_WATER_plot>=FRAC_TOWN_plot))
    fieldclasses[ind]=2
    #
    ind=which((FRAC_NATURE_plot>=FRAC_SEA_plot)&(FRAC_NATURE_plot>=FRAC_WATER_plot)&(FRAC_NATURE_plot>=FRAC_TOWN_plot))
    fieldclasses[ind]=3
    #
    ind=which((FRAC_TOWN_plot>=FRAC_SEA_plot)&(FRAC_TOWN_plot>=FRAC_WATER_plot)&(FRAC_TOWN_plot>=FRAC_NATURE_plot))
    fieldclasses[ind]=4
    #
    cols=array(NA,length(name))
    cols[01]=col2hex("navy")
    cols[02]=col2hex("deepskyblue")
    cols[03]=col2hex("darkgreen")
    cols[04]=col2hex("black")
    #
  } else if (lplot==2) {
    #
    printl="Elevation"
    #
    titleplot="Surface elevation and model domains"
    #
    # Convert field into classes
    #
    brks = c(-100,20,50,100,200,500,1000,2000,10000)
    #
    fieldclasses=array(-9999,length(heig_plot))
    #
    ind=which(FRAC_SEA_plot>=0.5)
    fieldclasses[ind]=1
    #
    for (ii in 2:length(brks)) {
      ind=which((fieldclasses!=1)&(heig_plot>=brks[ii-1])&(heig_plot<brks[ii]))
      fieldclasses[ind]=ii
    }
    #
    name=c("Sea and ocean","0-20 m","20-50 m","50-100 m","100-200 m","200-500 m","500-1000 m","1000-2000 m","> 2000 m")
    #
    cols=array(NA,length(name))
    cols[01]=col2hex("darkblue")
    cols[02]=col2hex("darkgreen")
    cols[03]=col2hex("green4")
    cols[04]=col2hex("green2")
    cols[05]=col2hex("limegreen")
    cols[06]=col2hex("burlywood")
    cols[07]=col2hex("darkgoldenrod")
    cols[08]=col2hex("saddlebrown")
    cols[09]=col2hex("white") 
    #
  } else {
    stop("No rule implemented for this type of plot")
  }
  #
  field=as.vector(fieldclasses)
  brks=seq(0.5,max(field,na.rm=TRUE)+0.5,1)
  #
  cexall=1.2
  #
  # Write values onto raster
  #
  lons_unique=unique(lons_plot)
  lats_unique=unique(lats_plot)
  #
  dy_vec=array(NA,(length(lats_unique)-1))
  dx_vec=array(NA,(length(lons_unique)-1))
  #
  for (ii in 2:length(lons_unique)) dx_vec[ii-1] = lons_unique[ii]-lons_unique[ii-1]
  for (ii in 2:length(lats_unique)) dy_vec[ii-1] = lats_unique[ii]-lats_unique[ii-1]
  #
  dx=mean(dx_vec)
  dy=mean(dy_vec)
  #
  lonmin=min(lons_plot);lonmax=max(lons_plot)
  latmin=min(lats_plot);latmax=max(lats_plot)
  #
  nyp=length(which(lons_plot==lonmin))
  nxp=length(which(lats_plot==latmin))
  #
  fieldrev=as.vector(length(field))
  for (ii in 1:nyp) {
    indbeg=1+(ii-1)*nxp
    indend=ii*nxp
    fieldrev[indbeg:indend]=rev(field[indbeg:indend])
  }
  field=fieldrev
  #
  # Modify latmin and latmax to be consistant with grid specificites
  #
  nmean=floor(length(dy_vec)/2)
  dy_int=sum(dy_vec[nmean:length(dy_vec)]-dy)
  #
  exte=c(lonmin-0.5*dx,lonmax+0.5*dx,latmin-0.5*dy-dy_int,latmax+0.5*dy-dy_int)
  #
  rast_plot=raster(extent(exte))
  projection(rast_plot) = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs +towgs84=0,0,0"
  res(rast_plot) = c(dx,dy)
  #
  vec_check=getValues(rast_plot)
  if (length(vec_check)!=length(field)) print("CAUTION: imprecision in maps plotting")
  #
  rast_plot=setValues(rast_plot,rev(field))
  #
  # Create plot
  #
  pdf(paste("../PLOTDIR/MAPS/DomainPlots/",namesim,"_",printl,".pdf",sep=""),width=7,height=5.7)
  par(xaxs="i",yaxs="i")
  par(mar=c(4,4,2.0,0.5))
  par(oma=c(0,0,0,4.3))
  #
  arg=list(at=seq(1,length(name),1),labels=name,line=0,cex.axis=cexall)
  #
  plot(rast_plot,breaks=brks,col=cols,axis.args=arg,xlab=NA,ylab=NA,axes=FALSE,
       cex.axis=cexall,cex.lab=cexall,alpha=1,colNA="white",add=FALSE,useRaster=TRUE,interpolate=FALSE)
  #
  xscale = 0.60*lonmin_nests[1] + 0.40*lonmax_nests[1]
  yscale = 0.95*latmin_nests[1] + 0.05*latmax_nests[1]
  #
  scalebar(200,xy=c(xscale,yscale),type="bar",divs=4,label=c(paste(0,"km"),paste(100,"km"),paste(200,"km")),lonlat=TRUE,col="white")
  #
  # Draw the nest boundaries
  #
  cols_nest=rep("black",nnest-1)
  #
  for (nest in 2:nnest) {
    #
    segments(lonmin_nests[nest],latmin_nests[nest],lonmax_nests[nest],latmin_nests[nest],col=cols_nest[nest-1],lty=1,lwd=3)
    segments(lonmin_nests[nest],latmax_nests[nest],lonmax_nests[nest],latmax_nests[nest],col=cols_nest[nest-1],lty=1,lwd=3)
    segments(lonmin_nests[nest],latmin_nests[nest],lonmin_nests[nest],latmax_nests[nest],col=cols_nest[nest-1],lty=1,lwd=3)
    segments(lonmax_nests[nest],latmin_nests[nest],lonmax_nests[nest],latmax_nests[nest],col=cols_nest[nest-1],lty=1,lwd=3)
    #
    print("CAUTION: for Hong Kong the label for domain 5 has been removed")
    #
    if (nest<=(nnest-2)) {
      text(x=0.5*(lonmin_nests[nest]+lonmax_nests[nest]),y=(latmax_nests[nest]+0.12),labels=paste("D",nest,sep=""),cex=1.0,lwd=4,col=cols_nest[nest-1])
    } else if (nest<=(nnest-1)) {
      text(x=1.5*lonmin_nests[nest]-0.5*lonmax_nests[nest],y=0.5*latmax_nests[nest]+0.5*latmin_nests[nest],labels=paste("D",nest,sep=""),cex=1.0,lwd=4,col="white")
    }
    #
  }
  #
  # title("")
  # mtext(titleplot,col="black",side=3,line=0.3,adj=0.5,outer=FALSE,cex=1.5*cexall)
  #
  # Create axes
  #
  LST=sescale(lats_plot)
  ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
  yaxis=seq(ymin,ymax-yinc,yinc)
  ylim=c(ymin,ymax)
  #
  LST=sescale(lons_plot)
  xmin=LST$amin;xmax=LST$amax;xinc=LST$inc
  xaxis=seq(xmin,xmax-xinc,xinc)
  xlim=c(xmin,xmax)
  #
  # Option to include ° symbol
  #
  xname=c()
  for (ii in 1:length(xaxis)) xname=c(xname,paste(xaxis[ii],"",sep=""))
  #
  yname=c()
  for (ii in 1:length(yaxis)) yname=c(yname,paste(yaxis[ii],"",sep=""))
  #
  axis(1,at=xaxis,lab=xname,lwd=1,las=1,cex.axis=cexall)
  axis(2,at=yaxis,lab=yname,lwd=1,las=1,cex.axis=cexall)
  #
  mtext("Geographical longitude [°E]",col="black",side=1,line=2.3,adj=0.5,outer=FALSE,cex=cexall)
  mtext("Geographical latitude [°N]" ,col="black",side=2,line=2.3,adj=0.5,outer=FALSE,cex=cexall)
  #
  garbage <- dev.off()
  #
}
#
}
