#!/usr/bin/Rscript
#
# Script to create synthesis plots for vertical profiles
#
library(sp)
library(RNetCDF)
library(MASS)
library(rgdal)
library(gplots)
library(raster)
library(pracma)
library(foreign)
library(ggplot2)
library(methods)
library(circular)
library(geosphere)
library(RColorBrewer)
#
source("sub.R")
source("input.R")
source("subplot.R")
source("sereadpgd.R")
source("subloadobs.R")
#
options(warn=1)
#
# ####################################################
# User input section
# ####################################################
#
# The name of the simulation
#
name="HK_HWMay2018"
# name="HK_HWSep2009"
#
# The date of initialisation
#
yearini=2018
montini=5
dayyini=17
#
# yearini=2009
# montini=9
# dayyini=1
#
# The number of simulation days to investigate
#
nrunday=15
# nrunday=8
#
# The name of the scenarios to analyse
#
name_vec=c("CLASSICAL","SURFFLUX","Final")
colors=c("red1","darkgreen","blue1")
#
# Nest to treat
#
nest_vec=c(4)
#
# The name of the scenario
#
scen=c("REFER")
#
# The vertical levels in MNH
#
zlvl_w=c(0.0,2.0,4.3,6.94,9.98,13.48,17.50,22.13,27.45,33.57,40.60,48.69,58.00,68.70,81.0,95.16,111.43,130.15,151.67,176.4272,
204.89)
#
# zlvl_w=c(0.0,2.0,4.3,6.94,9.98,13.48,17.50,22.13,27.45,33.57,40.60,48.69,58.00,68.70,81.0,95.16,111.43,130.15,151.67,176.4272,
# 204.89,237.62,275.26,318.55,368.34,425.59,491.42,567.14,654.21,754.34,869.49,1001.91,1154.20,1329.33,1530.73,1762.34,
# 2028.69,2334.995,2687.244)
#
# Interpolation to scalar levels
#
zlvl=0.5*(zlvl_w[1:(length(zlvl_w)-1)]+zlvl_w[2:(length(zlvl_w))])
#
# ####################################################
# Adaptation to Hong Kong
# ####################################################
#
if (grepl("HK",name)) {
  print("  ")
  print("Change names of variables to be evaluated for Hong Kong")
  print("  ")
  varieval_capitoul_cnrmstat = varieval_hkostat
  nameeval_capitoul_cnrmstat = nameeval_hkostat
  uniteval_capitoul_cnrmstat = uniteval_hkostat
}
#
# ####################################################
# Load information on Hong Kong station network
# ####################################################
#
print("                      ")
print("Model results will be evaluated against the Hong Kong Obervatory stations")
print("                      ")
#
filesave="../../../PROJETS/PROCORE/MetStations/RSAVE_HKO_Stations"
if (!file.exists(filesave)) {
  seload_hko_stations("../../../PROJETS/PROCORE/MetStations/Raw_upto_20181231/",filesave)
}
#
load(file=filesave)
numb_cnrmstat=LST$numb_hko;lats_cnrmstat=LST$lats_hko;lons_cnrmstat=LST$lons_hko
name_cnrmstat=LST$name_hko;heig_cnrmstat=LST$heig_hko
#
# ####################################################
# Plot profiles for single days
# ####################################################
#
juldaybeg=myjulday(montini,dayyini,yearini)
#
for (day in 1:nrunday) {
  #
  juldayact=juldaybeg+(day-1)
  LST=mycaldat(juldayact)
  montact=LST$m;dayyact=LST$d;yearact=LST$y
  #
  juldaybef=juldaybeg+(day-2)
  LST=mycaldat(juldaybef)
  montbef=LST$m;dayybef=LST$d;yearbef=LST$y
  #
  namemont=sprintf("%02d",montact)
  namedayy=sprintf("%02d",dayyact)
  nameday=paste(yearact,namemont,namedayy,sep="")
  #
  namemontbef=sprintf("%02d",montbef)
  namedayybef=sprintf("%02d",dayybef)
  namedaybef=paste(yearbef,namemontbef,namedayybef,sep="")
  #
  print(paste0("Treating ",nameday))
  #
  for (nest in nest_vec) for (sce in 1:length(scen)) {
    #
    # Load the vertical profiles for all sensitivity tests
    #
    for (scenario in 1:length(name_vec)) {
      #
      # Current day
      #
      prsv=paste0(pdsup,name,"_",name_vec[scenario],"/",scen[sce],"/ONLINE/",nameday,"_Nest_",nest,"/RDATA/")
      load(file=paste0(prsv,"CNRM_STATION_EXTRACT"))
      prof_cnrmstat=LST$prof_cnrmstat
      #
      # The day before the current day
      #
      prsv=paste0(pdsup,name,"_",name_vec[scenario],"/",scen[sce],"/ONLINE/",namedaybef,"_Nest_",nest,"/RDATA/")
      load(file=paste0(prsv,"CNRM_STATION_EXTRACT"))
      prof_cnrmstat_bef=LST$prof_cnrmstat      
      #
      if (name_vec[scenario]=="CLASSICAL") {
        zlvl_comb=LST$zlvl_mnh_teb
        if (length(zlvl_comb)>1) zlvl_mnh_teb=zlvl_comb
      }
      #
      # Only station 17
      #
      stat=17
      ind17 = which(numb_cnrmstat==stat)
      sim = prof_cnrmstat[,,ind17,]
      sim_bef = prof_cnrmstat_bef[,,ind17,]      
      #
      DIM=dim(sim)
      #
      if (scenario==1) {
        sim_all=array(NA,c(DIM[1],DIM[2]+6+10,DIM[3],length(name_vec)))
        sim_all_bef=array(NA,c(DIM[1],DIM[2]+6+10,DIM[3],length(name_vec)))	
      }
      #
      sim_all[1:DIM[1],1:DIM[2],1:DIM[3],scenario]=sim
      sim_all_bef[1:DIM[1],1:DIM[2],1:DIM[3],scenario]=sim_bef  
      #
    }
    #
    # Enlarge to potential temperature
    #
    if (varieval_capitoul_cnrmstat[length(varieval_capitoul_cnrmstat)]!="TPOT") {
      varieval_capitoul_cnrmstat=c(varieval_capitoul_cnrmstat,"TPOT")
      nameeval_capitoul_cnrmstat=c(nameeval_capitoul_cnrmstat,"Potential temperature")
      uniteval_capitoul_cnrmstat=c(uniteval_capitoul_cnrmstat,"K")
    }
    #
    for (metvar in 1:length(varieval_capitoul_cnrmstat)) {
      #
      if ((varieval_capitoul_cnrmstat[metvar]!="TOTFLASWD_SUM")&(varieval_capitoul_cnrmstat[metvar]!="PREC_HOURCUM")) {
      #
      if (yearini==2018) {
        hourvec=c(0,6,12,18)
      } else if (yearini==2009) {
        hourvec=c(0,12)        
      }
      #
      for (hour in 1:length(hourvec)) {
        #
        # Load the vertical profiles observed by the HKO
        #
        psound="/home/robert/Bureau/PROJETS/PROCORE/HKO_Soundings/"
        yearmon=substr(nameday,1,6)
        filesound=paste0(psound,yearmon,"/",nameday,sprintf("%02d",hourvec[hour]),".2s")
	#
        data=read.table(filesound)
        #
        minu_sound=data[,1]
        seco_sound=data[,2]
  	ascr_sound=data[,3]
 	heig_sound=data[,4]-data[1,4]
	pabs_sound=100.0*data[,5]
        temp_sound=data[,6]
	relh_sound=data[,7]	    
	dewp_sound=data[,8]
	widd_sound=data[,9]
	wiff_sound=data[,10]
        #
        amax=max(zlvl)
    	adiff=heig_sound-amax
 	indneg=which(adiff<0)
	indlim=max(indneg)+1
	#
        zlev_obs=heig_sound[1:indlim]
        #
        if (varieval_capitoul_cnrmstat[metvar]=="TEMPMME") {
          data_obs=temp_sound[1:indlim]
	  #
	  if (max(data_obs)>40.0)    {print(max(data_obs));stop("Unplausible value for air temperature")}
	  if (min(data_obs)<(-30.0)) {print(min(data_obs));stop("Unplausible value for air temperature")}
        } else if (varieval_capitoul_cnrmstat[metvar]=="RHME") {
          data_obs=relh_sound[1:indlim]
	  if (max(data_obs)>100.0) {print(max(data_obs));stop("Unplausible value for relative humidity")}
	  if (min(data_obs)<0.0)   {print(min(data_obs));stop("Unplausible value for relative humidity")}	  
        } else if (varieval_capitoul_cnrmstat[metvar]=="QSPECME") {
          data_obs=array(NA,indlim)
	} else if (varieval_capitoul_cnrmstat[metvar]=="PABSME") {
          data_obs=pabs_sound[1:indlim]
	  if (max(data_obs)>1050.0) {print(max(data_obs));stop("Unplausible value for pressure")}
	  if (min(data_obs)<900.0)  {print(min(data_obs));stop("Unplausible value for pressure")}	  
        } else if (varieval_capitoul_cnrmstat[metvar]=="TOTFLASWD_SUM") {
          data_obs=array(NA,indlim)
        } else if (varieval_capitoul_cnrmstat[metvar]=="PREC_HOURCUM") {
          data_obs=array(NA,indlim)
        } else if (varieval_capitoul_cnrmstat[metvar]=="WIDDME") {
          data_obs=widd_sound[1:indlim]
	  if (max(data_obs)>360.0) {print(max(data_obs));stop("Unplausible value for wind direction")}
	  if (min(data_obs)<0.0)   {print(min(data_obs));stop("Unplausible value for wind direction")}	  
        } else if (varieval_capitoul_cnrmstat[metvar]=="WIFFME") {
          data_obs=wiff_sound[1:indlim]
	  if (max(data_obs)>40.0) {print(max(data_obs));stop("Unplausible value for wind speed")}
	  if (min(data_obs)<0.0) {print(min(data_obs));stop("Unplausible value for wind speed")}	  
        } else if (varieval_capitoul_cnrmstat[metvar]=="TPOT") {
	  data_obs=(273.16+temp_sound[1:indlim])*((1.0e+5/pabs_sound[1:indlim]))^(287.04/1005.0)
	  if (max(data_obs)>350.0) {print(max(data_obs));stop("Unplausible value for potential temperature")}
	  if (min(data_obs)<250.0) {print(min(data_obs));stop("Unplausible value for air temperature")}	  
        } else {
          stop("No rule implemented for this variable")
        }
        #
        # Plot the profiles
        #
        addname=c("ALL","REF")
        #
        for (add in addname) {
          #
          printl=paste0(pplot,"PROFILES/",name,"_",name_vec[scenario],"/",scen[sce],"/",nameday,"/",
          "Nest_",nest,"/","PROFILE_",add,"_UTC_",hourvec[hour],"_",varieval_capitoul_cnrmstat[metvar],"_Station_",stat,".pdf")
          #
          # print(printl)
	  #
	  if (hourvec[hour]!=0) {
            data=sim_all[metvar,,hourvec[hour],]
	  } else {
            data=sim_all_bef[metvar,,24,]
          }
	  #
          # Initialise average profiles
          #
          if ((juldayact==juldaybeg)&(add=="ALL")&(hour==1)&(metvar==1)&(sce==1)) {
	    #
	    DIM_data=dim(data)
	    #
	    data_mean       = array(0,c(length(hourvec),length(varieval_capitoul_cnrmstat),DIM_data[1],DIM_data[2]))
	    count_data_mean = array(0,c(length(hourvec),length(varieval_capitoul_cnrmstat),DIM_data[1],DIM_data[2]))
	    #
	    data_obs_mean       = array(0,c(length(hourvec),length(varieval_capitoul_cnrmstat),length(data_obs)+100))
	    count_data_obs_mean = array(0,c(length(hourvec),length(varieval_capitoul_cnrmstat),length(data_obs)+100))
            #
	    zlev_obs_mean       = array(0,c(length(hourvec),length(varieval_capitoul_cnrmstat),length(zlev_obs)+100))
	    count_zlev_obs_mean = array(0,c(length(hourvec),length(varieval_capitoul_cnrmstat),length(zlev_obs)+100))
            #
          }
	  #
	  # Increment to the averages for the selected days
	  #
          if (name=="HK_HWMay2018") {
	    #
	    # For HW2018: take the days May 19 and May 27-31
       	    #
            if ( (namedayy=="19")||(namedayy=="27")||(namedayy=="28")||(namedayy=="29")||(namedayy=="30")||(namedayy=="31") ) {
              #
	      if (add=="ALL") {
	        #
	        DIM_data=dim(data)
		#
                data_mean      [hour,metvar,1:DIM_data[1],1:DIM_data[2]] = data_mean[hour,metvar,1:DIM_data[1],1:DIM_data[2]] + data
                count_data_mean[hour,metvar,1:DIM_data[1],1:DIM_data[2]] = count_data_mean[hour,metvar,1:DIM_data[1],1:DIM_data[2]] + 1
		#
	        data_obs_mean[hour,metvar,1:length(data_obs)] = data_obs_mean[hour,metvar,1:length(data_obs)] + data_obs
	        count_data_obs_mean[hour,metvar,1:length(data_obs)] = count_data_obs_mean[hour,metvar,1:length(data_obs)] + 1		
		#
	        zlev_obs_mean[hour,metvar,1:length(zlev_obs)] = zlev_obs_mean[hour,metvar,1:length(zlev_obs)] + zlev_obs
                count_zlev_obs_mean[hour,metvar,1:length(zlev_obs)] = count_zlev_obs_mean[hour,metvar,1:length(zlev_obs)] + 1
		#
              }
              #
            }
            #
          } else if (name=="HK_HWSep2009") {
	    #
	    # For HW2009: take the days Sep 1 to 3 and Sep 5 to 8
       	    #
            if ( (namedayy=="01")||(namedayy=="02")||(namedayy=="03")||(namedayy=="05")||
	         (namedayy=="06")||(namedayy=="07")||(namedayy=="08") ) {
              #
	      if (add=="ALL") {
	        #
	        DIM_data=dim(data)
		#
                data_mean      [hour,metvar,1:DIM_data[1],1:DIM_data[2]] = data_mean[hour,metvar,1:DIM_data[1],1:DIM_data[2]] + data
                count_data_mean[hour,metvar,1:DIM_data[1],1:DIM_data[2]] = count_data_mean[hour,metvar,1:DIM_data[1],1:DIM_data[2]] + 1
		#
	        data_obs_mean[hour,metvar,1:length(data_obs)] = data_obs_mean[hour,metvar,1:length(data_obs)] + data_obs
	        count_data_obs_mean[hour,metvar,1:length(data_obs)] = count_data_obs_mean[hour,metvar,1:length(data_obs)] + 1		
		#
	        zlev_obs_mean[hour,metvar,1:length(zlev_obs)] = zlev_obs_mean[hour,metvar,1:length(zlev_obs)] + zlev_obs
                count_zlev_obs_mean[hour,metvar,1:length(zlev_obs)] = count_zlev_obs_mean[hour,metvar,1:length(zlev_obs)] + 1
		#
              }
              #
            }
            #
          } else {
	    print(name)
            stop("No rule implemented for this simulation")
          }
          #
	  if (add=="REF") {
            indfinal=which(name_vec=="Final")
	    if (length(indfinal)!=1) stop("Reference scenario not found")
	    data=data[,indfinal,drop=FALSE]
          }
	  #
          # Define xaxis
          #
          ind_sel=which(zlvl_mnh_teb<=max(zlvl))
          LST=sescale(na.omit(c(c(data[ind_sel,]),data_obs)))
          xmin=LST$amin;xmax=LST$amax;xinc=LST$inc
          xaxis=seq(xmin,xmax,xinc)
          xlim=c(xmin,xmax)
          xaxis_lab=xaxis
          #
          # Define yaxis
          #
          ymin=0
          ymax=max(na.omit(c(zlvl,zlev_obs)))
          yinc=20
          yaxis=seq(0,10*floor(ymax*10),yinc)
          ylim=c(ymin,ymax)
          yaxis_lab=yaxis
          #
          # Create plot
          #
          pdf(printl,width=8.32,height=7)
          par(mar=c(5,6,1.0,5))
          par(oma=c(0,0,0,0))
          par(xaxs="i",yaxs="i")
          #
          cexall=1.8
          cexleg=1.5
          #
          plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
	  #
          name_leg=c()
	  colors_leg=c()	
          #
	  if (add=="ALL") {
	    for (scenario in 1:length(name_vec)) {
	      if (name_vec[scenario]=="CLASSICAL") {
                zlev_scenario=zlvl_mnh_teb
		abline(h=zlev_scenario[6],lty=1,col=colors[scenario],lwd=2)
		text("H-SBL",x=0.9*xmin+0.1*xmax,y=zlev_scenario[6]+0.03*(ymax-ymin),cex=cexall)
	      } else {
                zlev_scenario=zlvl
              }
              #
	      aux     = na.omit(data[,scenario])
	      aux_lev = zlev_scenario[1:length(aux)]
              #
              lines(aux,aux_lev,lty=1,col=colors[scenario],lwd=2)
	      #
	      if (name_vec[scenario]!="Final") {
                name_leg=c(name_leg,name_vec[scenario])
	      } else {
                name_leg=c(name_leg,"NEW")
	      }
	      #
	      colors_leg=c(colors_leg,colors[scenario])
              #
	    }
	  } else if (add=="REF") {
	    #
	    ind_final=which(name_vec=="Final")
            zlev_scenario=zlvl
            #
	    aux     = na.omit(data[,1])
	    aux_lev = zlev_scenario[1:length(aux)]
            #
            lines(aux,aux_lev,lty=1,col=colors[ind_final],lwd=2)
	    name_leg=c(name_leg,"NEW")
	    colors_leg=c(colors_leg,colors[ind_final])
	    #
	  }
          #
	  points(data_obs,zlev_obs,lty=1,col="black",pch=16)
          #
          axis(1,at=xaxis,lab=xaxis_lab,las=1,cex.axis=cexall)
          axis(2,at=yaxis,lab=yaxis_lab,las=2,cex.axis=cexall)
          #
          mtext(paste(nameeval_capitoul_cnrmstat[metvar]," [",uniteval_capitoul_cnrmstat[metvar],"]",sep=""),side=1,line=2.5,cex=cexall,col="black")
          mtext("Height a.g.l. [m]",side=2,line=4.5,cex=cexall,col="black")
          #
          if (varieval_capitoul_cnrmstat[metvar]=="WIFFME") {
            if (hourvec[hour]!=12) legend("topleft",c(name_leg,"Observation"),lty=ltys[1],col=c(colors_leg,"black"),bty="n",lwd=2,cex=cexleg)
          } else {
            legend("topright",c(name_leg,"Observation"),lty=ltys[1],col=c(colors_leg,"black"),bty="n",lwd=2,cex=cexleg)
          }
          #
          garbage <- dev.off()
      	  #
        }
      }
      }
    }
  }
}
#
# ####################################################
# Plot average profiles
# ####################################################
#
# Only those grid points with sufficient count
#
DIM=dim(data_mean)
for (ii in 1:DIM[1]) for (jj in 1:DIM[2]) for (kk in 1:DIM[3]) for (tt in 1:DIM[4]) {
  if (count_data_mean[ii,jj,kk,tt]>0.8*max(count_data_mean)) {
    data_mean[ii,jj,kk,tt] = data_mean[ii,jj,kk,tt]/count_data_mean[ii,jj,kk,tt]
  } else {
    data_mean[ii,jj,kk,tt] = NA
  }
}
#
adiff=abs(count_zlev_obs_mean-count_data_obs_mean)
if (max(adiff)>1.0e-4) stop("Incoherent number of observations")
#
DIM=dim(data_obs_mean)
for (ii in 1:DIM[1]) for (jj in 1:DIM[2]) for (kk in 1:DIM[3]) {
  if (count_data_obs_mean[ii,jj,kk]>0.8*max(count_data_obs_mean)) {
    data_obs_mean[ii,jj,kk] = data_obs_mean[ii,jj,kk]/count_data_obs_mean[ii,jj,kk]
    zlev_obs_mean[ii,jj,kk] = zlev_obs_mean[ii,jj,kk]/count_data_obs_mean[ii,jj,kk]    
  } else {
    data_obs_mean[ii,jj,kk] = NA
    zlev_obs_mean[ii,jj,kk] = NA
  }
}
#
for (nest in nest_vec) {
  for (sce in 1:length(scen)) {
    for (metvar in 1:length(varieval_capitoul_cnrmstat)) {
      #
      if ((varieval_capitoul_cnrmstat[metvar]!="TOTFLASWD_SUM")&(varieval_capitoul_cnrmstat[metvar]!="PREC_HOURCUM")) {
      #
      if (yearini==2018) {
        hourvec=c(0,6,12,18)
      } else if (yearini==2009) {
        hourvec=c(0,12)        
      }
      #
      for (hour in 1:length(hourvec)) {
        #
        # Plot the profiles
        #
        addname=c("ALL")
        #
        for (add in addname) {
          #
          printl=paste0(pplot,"PROFILES/",name,"_",name_vec[scenario],"/",scen[sce],"/",nameday,"/",
          "Nest_",nest,"/","PROFILE_MEAN_",add,"_UTC_",hourvec[hour],"_",varieval_capitoul_cnrmstat[metvar],"_Station_",stat,".pdf")
          #
          print(printl)
	  #
          data     = data_mean[hour,metvar,,]
	  data_obs = data_obs_mean[hour,metvar,]
	  zlev_obs = zlev_obs_mean[hour,metvar,]
	  #
          # Define xaxis
          #
          ind_sel=which(zlvl_mnh_teb<=max(zlvl))
          LST=sescale(na.omit(c(c(data[ind_sel,]),data_obs)))
          xmin=LST$amin;xmax=LST$amax;xinc=LST$inc
          xaxis=seq(xmin,xmax,xinc)
          xlim=c(xmin,xmax)
          xaxis_lab=xaxis
          #
          # Define yaxis
          #
          ymin=0
          ymax=max(na.omit(c(zlvl,zlev_obs)))
          yinc=20
          yaxis=seq(0,10*floor(ymax*10),yinc)
          ylim=c(ymin,ymax)
          yaxis_lab=yaxis
          #
          # Create plot
          #
          pdf(printl,width=8.32,height=7)
          par(mar=c(5,6,1.0,5))
          par(oma=c(0,0,0,0))
          par(xaxs="i",yaxs="i")
          #
          cexall=1.8
          cexleg=1.5
          #
          plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
	  #
          name_leg=c()
	  colors_leg=c()	
          #
	  if (add=="ALL") {
	    for (scenario in 1:length(name_vec)) {
	      if (name_vec[scenario]=="CLASSICAL") {
                zlev_scenario=zlvl_mnh_teb
		abline(h=zlev_scenario[6],lty=1,col=colors[scenario],lwd=2)
		text("H-SBL",x=0.9*xmin+0.1*xmax,y=zlev_scenario[6]+0.03*(ymax-ymin),cex=cexall)
	      } else {
                zlev_scenario=zlvl
              }
              #
	      aux     = na.omit(data[,scenario])
	      aux_lev = zlev_scenario[1:length(aux)]
              #
              lines(aux,aux_lev,lty=1,col=colors[scenario],lwd=2)
	      #
	      if (name_vec[scenario]!="Final") {
                name_leg=c(name_leg,name_vec[scenario])
	      } else {
                name_leg=c(name_leg,"NEW")
	      }
	      #
	      colors_leg=c(colors_leg,colors[scenario])
              #
	    }
	  } else if (add=="REF") {
	    #
	    ind_final=which(name_vec=="Final")
            zlev_scenario=zlvl
            #
	    aux     = na.omit(data[,1])
	    aux_lev = zlev_scenario[1:length(aux)]
            #
            lines(aux,aux_lev,lty=1,col=colors[ind_final],lwd=2)
	    name_leg=c(name_leg,"NEW")
	    colors_leg=c(colors_leg,colors[ind_final])
	    #
	  }
	  #
	  points(data_obs,zlev_obs,lty=1,col="black",pch=16)
          #
          axis(1,at=xaxis,lab=xaxis_lab,las=1,cex.axis=cexall)
          axis(2,at=yaxis,lab=yaxis_lab,las=2,cex.axis=cexall)
          #
          mtext(paste(nameeval_capitoul_cnrmstat[metvar]," [",uniteval_capitoul_cnrmstat[metvar],"]",sep=""),side=1,line=2.5,cex=cexall,col="black")
          mtext("Height a.g.l. [m]",side=2,line=4.5,cex=cexall,col="black")
          #
          if (varieval_capitoul_cnrmstat[metvar]=="WIFFME") {
            if (hourvec[hour]!=12) legend("topleft",c(name_leg,"Observation"),lty=ltys[1],col=c(colors_leg,"black"),bty="n",lwd=2,cex=cexleg)
          } else {
            legend("topright",c(name_leg,"Observation"),lty=ltys[1],col=c(colors_leg,"black"),bty="n",lwd=2,cex=cexleg)
          }
          #
          garbage <- dev.off()
      	  #
        }
      }
      }
    }
  }
}
#
print("                                       ")
print("Vertical profiles plotted with success ")
print("                                       ")
#
