#!/usr/bin/Rscript
#
library(sp)
library(MASS)
library(gplots)
library(raster)
library(pracma)
library(ggplot2)
library(methods)
library(RNetCDF)
library(geosphere)
library(RColorBrewer)
#
source("sub.R")
source("input.R")
source("subplot.R")
#
# ####################################################
# User input section
# ####################################################
#
# The name of the simulation
#
name = "HK_HWSep2009"
# name = "HK_HWMay2018"
#
# The scenarios to investigate
#
scen_vec=c("CLASSICAL","SURFFLUX","Final")
#
# The nest to investigate
#
nest_vec=c(4,5)
#
# Plot in black and white
#
lbw=0
#
# ####################################################
# Load evaluation measures
# ####################################################
#
for (nest in 1:length(nest_vec)) for (scen in 1:length(scen_vec)) {
  #
  filesav=paste(pevalm,name,"_",scen_vec[scen],"/REFER/Nest_",nest_vec[1],"/RSAVE_EVAL_",name,"_",scen_vec[scen],"_REFER",sep="")
  #
  load(file=filesav)
  #
  if ((scen==1)&&(nest==1)) {
    #
    numb_cnrmstat=LST$numb_cnrmstat
    name_cnrmstat=LST$name_cnrmstat
    varieval_capitoul_cnrmstat=LST$varieval_capitoul_cnrmstat 
    seasvec=LST$seasvec
    #
    bias_cnrm=LST$bias_cnrm
    DIM=dim(bias_cnrm)
    #
    all_bias_cnrm=array(NA,c(length(scen_vec),DIM))
    all_rmse_cnrm=array(NA,c(length(scen_vec),DIM))
    all_hitr_cnrm=array(NA,c(length(scen_vec),DIM))
    all_mae_cnrm=array(NA,c(length(scen_vec),DIM))
    all_skvar_cnrm=array(NA,c(length(scen_vec),DIM))    
    #
  }
  #
  all_bias_cnrm [scen,,,,]=LST$bias_cnrm
  all_rmse_cnrm [scen,,,,]=LST$rmse_cnrm
  all_hitr_cnrm [scen,,,,]=LST$hitr_cnrm
  all_mae_cnrm  [scen,,,,]=LST$mae_cnrm
  all_skvar_cnrm[scen,,,,]=LST$skvar_cnrm
  #
}
#
# ####################################################
# Define urban morphology parameters for the stations
# ####################################################
#
stat_name_table=c("BHD","CCH","CP1","CPH","GI","HKO","HKP","HKS","HPV","JKB","KFB","KLT","KP","KSC",
"KTG","LAM","PEN","SE","SE1","SEK","SHA","SKG","SKW","SSP","STY","TC","TMS","TW","TWN","TY1","TYW","VP1","WGL","WTS")
#
bldfra_125m_table=c(0.0,0.0,0.14,0.17,0.03,0.26,0.12,0.00,0.01,0.00,0.00,0.01,0.05,0.00,0.05,0.11,
0.00,0.03,0.01,0.00,0.0,0.0,0.02,0.21,0.0,0.02,0.0,0.0,0.0,0.14,0.0,0.21,0.0,0.07)
#
bldhei_125m_table=c(0.0,0.0,12.3,61.1,7.2,29.3,10.2,3.8,3.0,0.0,0.0,3.6,4.0,0.0,3.2,7.5,0.0,6.2,5.0,0.0,0.0,
0.0,8.1,51.6,0.0,7.6,0.0,0.0,0.0,76.1,0.0,8.2,0.0,5.9)
#
bldfra_250m_table=c(0.00,0.02,0.10,0.09,0.01,0.39,0.16,0.17,0.07,0.11,0.01,0.03,0.04,0.0,0.07,0.03,0.02,
0.01,0.00,0.16,0.13,0.09,0.02,0.20,0.18,0.01,0.03,0.11,0.04,0.26,0.01,0.30,0.02,0.09)
#
bldhei_250m_table=c(4.5,13.2,10.0,54.3,7.4,40.6,93.4,16.8,32.7,
13.5,4.5,15.3,16.8,0.0,35.3,7.5,4.2,6.2,5.0,7.3,10.8,8.32,5.9,48.9,11.9,
6.6,10.4,15.7,16.0,59.7,7.3,17.0,6.8,11.1)
#
if (length(bldhei_250m_table)!=length(stat_name_table)) stop("Wrong length of vector")
if (length(bldhei_125m_table)!=length(stat_name_table)) stop("Wrong length of vector")
if (length(bldfra_250m_table)!=length(stat_name_table)) stop("Wrong length of vector")
if (length(bldfra_125m_table)!=length(stat_name_table)) stop("Wrong length of vector")
#
# Simple definition of stations as being urban or rural
# bld>0.1 or height>20
#
flag_urban=array(NA,length(bldhei_250m_table))
flag_rural=array(NA,length(bldhei_250m_table))
flag_peaks=array(0,length(bldhei_250m_table))
#
for (stat in 1:length(bldhei_250m_table)) {
  #
  if ( (bldfra_250m_table[stat]>=0.1)||(bldhei_250m_table[stat]>=15) ) {
    flag_urban[stat]=1
    flag_rural[stat]=0
  } else {
    flag_urban[stat]=0
    flag_rural[stat]=1
  }
  #
  if ((stat_name_table[stat]=="VP1")||(stat_name_table[stat]=="TMS")||(stat_name_table[stat]=="TC")) {
    flag_peaks[stat]=1
  }
  #
}
#
# At the moment the stations need to be either urban or rural
#
ctl = flag_urban + flag_rural
if (max(abs(ctl-1))>1.0e-4) stop("Wrong labelling of stations")
#
# ####################################################
# Plot evaluation measures for each season and variable
# ####################################################
#
pevalplot="../PLOTDIR/EVALMEASURES/"
system(paste0("rm -f ",pevalplot,name,"*"))
#
for (nest in 1:length(nest_vec)) {
#
if (nest_vec[nest]==4) {
  # pgdvarvec = c("STAT","BLDFRA_250m","BLDHEI_250m")
  pgdvarvec = c("STAT")
} else if (nest_vec[nest]==5) {
  # pgdvarvec = c("STAT","BLDFRA_250m","BLDHEI_250m")
  pgdvarvec = c("STAT")  
} else {
  print(nest_vec[vec])
  stop("No rule implemented for this nest")
}
#
evalvec = c("BIAS","RMSE","HITR","MAE")
col_vec = c("red1","darkgreen","blue1","black","magenta","orange","yellow")
pch_vec = c(3,6,8,16,17,18,19)
#
if (length(col_vec)<length(scen_vec)) stop("Color vector must be expanded for these scenarions")
#
seas=1
#
for (pgdvar in pgdvarvec) for (vari in 1:length(varieval_capitoul_cnrmstat)) {
  #
  pstaplot=paste(pevalplot,name,"_Nest_",nest_vec[nest],"_",varieval_capitoul_cnrmstat[vari],"_",seasvec[seas],sep="")
  #
  for (eval in 1:length(evalvec)) {
    #
    if        (eval==1) {
      dataplot = all_bias_cnrm [,seas,vari,nest,]
      evalname = "bias"
      unit = unitbias_capitoul_cnrmstat[vari]
    } else if (eval==2) {
      dataplot = all_rmse_cnrm [,seas,vari,nest,]
      unit = unitbias_capitoul_cnrmstat[vari]
      evalname = "rmse"
    } else if (eval==3) {
      dataplot = all_hitr_cnrm [,seas,vari,nest,]
      unit = "1"
      evalname = "hit-rate"
    } else if (eval==4) {
      dataplot = all_mae_cnrm  [,seas,vari,nest,]
      unit = unitbias_capitoul_cnrmstat[vari]
      evalname = "mae"
    } else if (eval==5) {
      dataplot = all_skvar_cnrm[,seas,vari,nest,]
      unit = "1"
      evalname = "skill variance"
    } else {
      stop("No rule implemented for this evaluation measure")
    }
    #
    if (length(which(!is.na(dataplot)))) {
      #
      nameplot=paste(pstaplot,"_",evalvec[eval],"_",pgdvar,".pdf",sep="")
      # print(nameplot)
      cexall=1.8
      #
      if (pgdvar=="STAT") {
        xaxis_text=""
        xvar=numb_cnrmstat
	lasx=2
	cexx=1.5
      } else if (pgdvar=="BLDFRA_125m") {
        #
        xaxis_text="Plane area building density [m²/m²]"
	lasx=1
	cexx=cexall
        #
	xvar=c()
        for (ttt in 1:length(numb_cnrmstat)) {
	  ind=which(stat_name_table==name_cnrmstat[ttt])
	  if (length(ind)>1) stop("More than one station in list")
	  if (length(ind)==1) xvar=c(xvar,bldfra_125m_table[ind])
	  if (length(ind)==0) xvar=c(xvar,0.0)
        }	
	#
      } else if (pgdvar=="BLDFRA_250m") {
        #
        xaxis_text="Plane area building density [m²/m²]"
        lasx=1
        cexx=cexall
        #
	xvar=c()
        for (ttt in 1:length(numb_cnrmstat)) {
	  ind=which(stat_name_table==name_cnrmstat[ttt])
	  if (length(ind)>1) stop("More than one station in list")
	  if (length(ind)==1) xvar=c(xvar,bldfra_250m_table[ind])
	  if (length(ind)==0) xvar=c(xvar,0.0)
        }
        #
      } else if (pgdvar=="BLDHEI_125m") {
        #
        xaxis_text="Building height [m]"
        lasx=1
	cexx=cexall
        #
	xvar=c()
        for (ttt in 1:length(numb_cnrmstat)) {
	  ind=which(stat_name_table==name_cnrmstat[ttt])
	  if (length(ind)>1) stop("More than one station in list")
	  if (length(ind)==1) xvar=c(xvar,bldhei_125m_table[ind])
	  if (length(ind)==0) xvar=c(xvar,0.0)
        }
        #
      } else if (pgdvar=="BLDHEI_250m") {
        #
        xaxis_text="Building height [m]"
	lasx=1
	cexx=cexall
        #
	xvar=c()
        for (ttt in 1:length(numb_cnrmstat)) {
	  ind=which(stat_name_table==name_cnrmstat[ttt])
	  if (length(ind)>1) stop("More than one station in list")
	  if (length(ind)==1) xvar=c(xvar,bldhei_250m_table[ind])
	  if (length(ind)==0) xvar=c(xvar,0.0)
        }
        #
      } else {
        stop("No rule implemented for this PGD variable")
      }
      #
      # Remove the stations which did not measure
      #
      xvar_new=c()
      name_new=c()
      dataplot_new=c()
      for (stat in 1:length(xvar)) {
        if (!is.na(dataplot[1,stat])) {
          xvar_new=c(xvar_new,xvar[stat])
       	  name_new=c(name_new,name_cnrmstat[stat])
          dataplot_new=cbind(dataplot_new,dataplot[,stat])
        }
      }
      #
      xvar = xvar_new
      dataplot = dataplot_new
      #
      if (pgdvar=="STAT") {
        #
	xmin=0.5
	xmax=length(xvar_new)+0.5
        xaxis=seq(xmin+0.5,xmax-0.5,1)
        xlim=c(xmin,xmax)
        xaxis_lab=name_new
	xvar=xaxis
        #
	# Assign urban/rural/peaks flag
	#
	flag_urban_vec=c()
        flag_rural_vec=c()
        flag_peaks_vec=c()
        #
        for (stat in 1:length(name_new)) {
	  #
          ind = which(name_new[stat]==stat_name_table)
	  if (length(ind)!=1) stop("Index not found")
          #
          flag_urban_vec=c(flag_urban_vec,flag_urban[ind])
          flag_rural_vec=c(flag_rural_vec,flag_rural[ind])
          flag_peaks_vec=c(flag_peaks_vec,flag_peaks[ind])
          #
        }
	#
	if (length(xaxis)!=length(xaxis_lab)) stop("Incoherent lengths")
        #
      } else {
        LST=sescale(xvar)
        xmin=LST$amin;xmax=LST$amax;xinc=LST$inc
        xaxis=seq(xmin,xmax,xinc)
        xlim=c(xmin,xmax)
        xaxis_lab=xaxis
      }
      #
      # Define yaxis
      #
      LST=sescale(dataplot)
      ymin=LST$amin;ymax=LST$amax;yinc=LST$inc
      ymax=ymax+yinc
      yaxis=seq(ymin,ymax,yinc)
      ylim=c(ymin,ymax)
      yaxis_lab=yaxis
      #
      # Create plot
      # 
      pdf(nameplot,width=8.32,height=7)
      par(mar=c(5,6,1.0,2))
      par(oma=c(0,0,0,0))
      par(xaxs="i",yaxs="i")
      #
      # Change labels for peak stations
      #
      xaxis_lab_new=c()
      for (stat in 1:length(flag_urban_vec)) {
        if (flag_peaks_vec[stat]>0.5) {
          xaxis_lab_new=c(xaxis_lab_new,paste0(xaxis_lab[stat],"*"))
        } else {
          xaxis_lab_new=c(xaxis_lab_new,xaxis_lab[stat])
        }
      }
      xaxis_lab=xaxis_lab_new
      #
      # Sort all urban stations to the left
      #
      dataplot_sort=c()
      xaxis_lab_sort=c()
      flag_urban_vec_sort=c()
      #
      ctl_hkp=dataplot[,which(xaxis_lab=="HKP")]
      #
      for (ttt in 1:length(flag_urban_vec)) {
        if (flag_urban_vec[ttt]>=0.5) {
          dataplot_sort=cbind(dataplot_sort,dataplot[,ttt])
          xaxis_lab_sort=c(xaxis_lab_sort,xaxis_lab[ttt])
          flag_urban_vec_sort=c(flag_urban_vec_sort,flag_urban_vec[ttt])
        }
      }
      #
      for (ttt in 1:length(flag_urban_vec)) {
        if (flag_urban_vec[ttt]<0.5) {
          dataplot_sort=cbind(dataplot_sort,dataplot[,ttt])
          xaxis_lab_sort=c(xaxis_lab_sort,xaxis_lab[ttt])
          flag_urban_vec_sort=c(flag_urban_vec_sort,flag_urban_vec[ttt])
        }
      }
      #
      dataplot=dataplot_sort
      xaxis_lab=xaxis_lab_sort
      flag_urban_vec=flag_urban_vec_sort
      #
      scen_vec_leg=c()
      for (ttt in 1:length(scen_vec)) {
        if (scen_vec[ttt]!="Final") {
          scen_vec_leg=c(scen_vec_leg,scen_vec[ttt])
        } else {
          scen_vec_leg=c(scen_vec_leg,"NEW")
        }
      }
      #
      print(" ")
      print(paste0(varieval_capitoul_cnrmstat[vari],"-",evalvec[eval],"-Nest",nest_vec[nest]))
      for (scen in 1:length(scen_vec_leg)) {
        print(scen_vec_leg[scen])
	print("Urban rural all")
        print(paste(mean(dataplot[scen,which(flag_urban_vec>=0.5)],na.rm=TRUE),mean(dataplot[scen,which(flag_urban_vec<0.5)],na.rm=TRUE),mean(dataplot[scen,],na.rm=TRUE)))
      }
      #
      plot0(axes=FALSE,ylim=ylim,xlim=xlim,xlab=NA,ylab=NA,frame.plot=T)
      #
      for (scen in 1:length(scen_vec)) {
        #
        if (lbw<0.5) {
          points(xvar,dataplot[scen,],lty=1,pch=16,col=col_vec[scen],cex=1.3)
        } else {
          points(xvar,dataplot[scen,],lty=1,pch=pch_vec[scen],col="black",cex=1.3)
        }
	#
      }
      #
      # Write axes
      #
      axis(1,at=xaxis[which(flag_urban_vec>0.5)],lab=xaxis_lab[which(flag_urban_vec>0.5)],las=lasx,cex.axis=cexx,font=2)
      axis(1,at=xaxis[which(flag_urban_vec<0.5)],lab=xaxis_lab[which(flag_urban_vec<0.5)],las=lasx,cex.axis=cexx)
      axis(2,at=yaxis,lab=yaxis_lab,las=2,cex.axis=cexall)
      #
      mtext(paste(evalname," [",unit,"]",sep=""),side=2,line=4,cex=cexall,col="black")
      mtext(xaxis_text,side=1,line=3.0,cex=cexall,col="black")    
      #
      if (lbw<0.5) {
        legend("top",scen_vec_leg,col=col_vec,cex=1.3,pch=16,bty="n")
      } else {
        legend("top",scen_vec,pch=pch_vec,col="black",cex=1.3,bty="n")
      }
      #
      garbage <- dev.off()
      graphics.off()
      #
    }
  }
}
}
#
print("                            ")
print("All plots made successfully ")
print("                            ")
#
