#!/usr/bin/Rscript
#
library(sp)
library(RNetCDF)
library(MASS)
library(rgdal)
library(gplots)
library(raster)
library(pracma)
library(foreign)
library(ggplot2)
library(methods)
library(circular)
library(geosphere)
library(RColorBrewer)
#
source("sub.R")
source("input.R")
source("subplot.R")
source("sereadpgd.R")
source("subloadobs.R")
#
options(warn=1)
#
# ####################################################
# User input section
# ####################################################
#
# The name of the simulation
#
# name="HK_HWMay2018_CLASSICAL"
# name="HK_HWMay2018_SURFFLUX"
# name="HK_HWMay2018_Final"
name="HK_HWSep2009_CLASSICAL"
# name="HK_HWSep2009_SURFFLUX"
# name="HK_HWSep2009_Final"
#
# Nest to treat
#
nest_vec=c(4,5)
#
# The name of the scenario
#
scen=c("REFER")
#
yearini=2009
montini=9
dayyini=1
#
# The number of simulation days to investigate
#
nrunday=8
#
# The output time steps (hours in day)
#
nout_time=seq(1,24,1)
#
# ####################################################
# Adaptation for Hong Kong
# ####################################################
#
if (grepl("HK",name)) {
  print("  ")
  print("Change names of variables to be evaluated for Hong Kong")
  print("  ")
  varieval_capitoul_cnrmstat = varieval_hkostat
  nameeval_capitoul_cnrmstat = nameeval_hkostat
  uniteval_capitoul_cnrmstat = uniteval_hkostat
}
#
# ####################################################
# Load station data and corresponding model results
# ####################################################
#
juldaybeg=myjulday(montini,dayyini,yearini)
#
dayy_vec = array(NA,24*nrunday)
mont_vec = array(NA,24*nrunday)
year_vec = array(NA,24*nrunday)
#
lsurf=1
#
for (day in 1:nrunday) {
  #
  juldayact=juldaybeg+(day-1)
  LST=mycaldat(juldayact)
  montact=LST$m;dayyact=LST$d;yearact=LST$y
  #
  namemont = sprintf("%02d",montact)
  namedayy = sprintf("%02d",dayyact)
  nameday  = paste(yearact,namemont,namedayy,sep="")
  #
  dayy_vec[(1+24*(day-1)):(24*day)] = dayyact
  mont_vec[(1+24*(day-1)):(24*day)] = montact
  year_vec[(1+24*(day-1)):(24*day)] = yearact
  #
  # Loop over scenarios and nests
  #
  for (nest in 1:length(nest_vec)) {
    #
    prsv=paste(pdsup,name,"/",scen,"/ONLINE/",nameday,"_Nest_",nest_vec[nest],"/RDATA/",sep="")
    #
    # CNRM stations
    #
    load(file=paste(prsv,"CNRM_EVAL_MEASURES",sep=""))
    obs_data_day  = LST$obs_data_day
    sim_data_day  = LST$vals_cnrmstat
    #
    if ((day==1)&&(nest==1)) {
      #
      lats_cnrmstat = LST$lats_cnrmstat
      lons_cnrmstat = LST$lons_cnrmstat
      heig_cnrmstat = LST$heig_cnrmstat
      name_cnrmstat = LST$name_cnrmstat
      numb_cnrmstat = LST$numb_cnrmstat
      #
      nstat_cnrm=length(numb_cnrmstat)
      #
      obs_datacnrm_ts=array(NA,c(length(varieval_capitoul_cnrmstat),nstat_cnrm,24*nrunday,length(nest_vec)))
      sim_datacnrm_ts=array(NA,c(length(varieval_capitoul_cnrmstat),nstat_cnrm,24*nrunday,length(nest_vec)))
      #
    }
    #
    obs_datacnrm_ts[,,(1+24*(day-1)):(24*day),nest] = obs_data_day[,,]
    sim_datacnrm_ts[,,(1+24*(day-1)):(24*day),nest] = sim_data_day[,,]
    #
    # SURF stations
    #
    filetest=paste(prsv,"SURF_EVAL_MEASURES",sep="")
    #
    if (file.exists(filetest)) {
      #
      load(file=paste(prsv,"SURF_EVAL_MEASURES",sep=""))
      obs_data_day  = LST$obs_data_day
      sim_data_day  = LST$vals_surfstat
      #
      if (day==1) {
        #
        lats_surfstat = LST$lats_surfstat
        lons_surfstat = LST$lons_surfstat
        heig_surfstat = LST$heig_surfstat
        name_surfstat = LST$name_surfstat
        numb_surfstat = LST$numb_surfstat
        #
        nstat_surf=length(numb_surfstat)
        #
        obs_datasurf_ts=array(NA,c(length(varieval_capitoul_surfstat),nstat_surf,24*nrunday),length(nest_vec))
        sim_datasurf_ts=array(NA,c(length(varieval_capitoul_surfstat),nstat_surf,24*nrunday),length(nest_vec))
        #
      }
      #
      obs_datasurf_ts[,,(1+24*(day-1)):(24*day),nest] = obs_data_day[,,]
      sim_datasurf_ts[,,(1+24*(day-1)):(24*day),nest] = sim_data_day[,,]
      #
    } else {
      #
      lsurf=0
      #
    }
    #
  }
}
#
# ####################################################
# Calculate standard model evaluation measures
# A. For T2M, RH2M, Q2M, WIFF, SWD
#    - Bias
#    - MAE
#    - RMSE
#    - SKVAR
#    - Hit Rate (from Cox paper)
# B. For WIDD:
#    - Cyclic MAE
#    - Cyclic RMSE
#    - Hit Rate
# ####################################################
#
nseas=5
seasvec=c("ALL","DJF","MAM","JJA","SON")
#
bias_cnrm  = array(NA,c(nseas,length(varieval_capitoul_cnrmstat),length(nest_vec),nstat_cnrm))
mae_cnrm   = array(NA,c(nseas,length(varieval_capitoul_cnrmstat),length(nest_vec),nstat_cnrm))
rmse_cnrm  = array(NA,c(nseas,length(varieval_capitoul_cnrmstat),length(nest_vec),nstat_cnrm))
skvar_cnrm = array(NA,c(nseas,length(varieval_capitoul_cnrmstat),length(nest_vec),nstat_cnrm))
hitr_cnrm  = array(NA,c(nseas,length(varieval_capitoul_cnrmstat),length(nest_vec),nstat_cnrm))
#
if (lsurf>0.5) {
  bias_surf  = array(NA,c(nseas,length(varieval_capitoul_surfstat),length(nest_vec),nstat_surf))
  mae_surf   = array(NA,c(nseas,length(varieval_capitoul_surfstat),length(nest_vec),nstat_surf))
  rmse_surf  = array(NA,c(nseas,length(varieval_capitoul_surfstat),length(nest_vec),nstat_surf))
  skvar_surf = array(NA,c(nseas,length(varieval_capitoul_surfstat),length(nest_vec),nstat_surf))
  hitr_surf  = array(NA,c(nseas,length(varieval_capitoul_surfstat),length(nest_vec),nstat_surf))
}
#
for (netw in 1:2) {
  #
  if (netw==1) {
    #
    varlist     = varieval_capitoul_cnrmstat
    nstat       = nstat_cnrm
    obs_data_ts = obs_datacnrm_ts
    sim_data_ts = sim_datacnrm_ts
    name_stat   = name_cnrmstat
    #
  } else if (netw==2) {
    #
    if (lsurf>0.5) {
      varlist     = varieval_capitoul_surfstat
      nstat       = nstat_surf
      obs_data_ts = obs_datasurf_ts
      sim_data_ts = sim_datasurf_ts
      name_stat   = name_surfstat
    }
    #
  } else {
    stop("No rule for this network")
  }
  #
  for (vari in 1:length(varlist)) {
    #
    if ((varlist[vari]=="TREAL_2M")||(varlist[vari]=="TEMPMME")) {
      des_acc=2.0
    } else if ((varlist[vari]=="RELHU_2M")||(varlist[vari]=="RELHU")||(varlist[vari]=="RHME")) {
      des_acc=10.0
    } else if (varlist[vari]=="TREAL") {
      des_acc=2.0
    } else if ((varlist[vari]=="QSPEC_2M")||(varlist[vari]=="QSPEC")||(varlist[vari]=="QSPECME")) {
      des_acc_rel=0.14
    } else if (varlist[vari]=="PREC_HOURCUM") {
      des_acc=1.0
    } else if (varlist[vari]=="TOTFLASWD_SUM") {
      des_acc_rel=0.2
    } else if (varlist[vari]=="WIFFME") {
      des_acc_va1 = 1.0
      des_acc_va2 = 2.5
      des_acc_lim = 10.0
    } else if (varlist[vari]=="WIDDME") {
      des_acc=30.0
    } else if (varlist[vari]=="FLALWD") {
      des_acc=50.0
    } else {
      print(varlist[vari])
      stop("No rule for this variable")
    }
    #
    for (stat in 1:nstat) for (nest in 1:length(nest_vec)) {
      #
      obs_full=obs_data_ts[vari,stat,,nest]
      sim_full=sim_data_ts[vari,stat,,nest]
      #
      for (seas in 1:5) {
        #
        if (seasvec[seas]=="ALL")  {
          ind_seas = seq(1,length(mont_vec))
        } else if (seasvec[seas]=="DJF") {
          ind_seas = which((mont_vec==01)|(mont_vec==02)|(mont_vec==12))
        } else if (seasvec[seas]=="MAM") {
          ind_seas = which((mont_vec==03)|(mont_vec==04)|(mont_vec==05))
        } else if (seasvec[seas]=="JJA") {
          ind_seas = which((mont_vec==06)|(mont_vec==07)|(mont_vec==08))
        } else if (seasvec[seas]=="SON") {
          ind_seas = which((mont_vec==09)|(mont_vec==10)|(mont_vec==11))
        } else {
          stop("No rule for this season")
        }
        #
        obs=obs_full[ind_seas]
        sim=sim_full[ind_seas]      
        #
        # Remove mutual NA
        #
        obs[which(is.na(sim))]=NA
        sim[which(is.na(obs))]=NA
        #
        ind_na_obs=which(is.na(obs))
        ind_na_sim=which(is.na(sim))
        #
        if (length(ind_na_obs)!=length(ind_na_sim)) stop("Inconsistant NA")
        diff=ind_na_obs-ind_na_sim
	if (length(diff)>0) {
          if (max(abs(diff))>0.001) stop("Inconsistant NA")
	}
        #
        if (varlist[vari]=="WIDDME") {
          #
          err=sim-obs
          #
	  ind_1      = which((sim<=90)&(obs>=270))
          err[ind_1] = sim[ind_1]+(360-obs[ind_1])
          #
	  ind_2      = which((sim>=270)&(obs<=90))
          err[ind_2] = obs[ind_2]+(360-sim[ind_2])
          #
        } else {
          err=sim-obs
        }
        #
        if ( varlist[vari]=="TOTFLASWD_SUM" ) {
	  #
	  ind_gt_10=which(obs>=10)
	  #
	  obs_sel = obs[ind_gt_10]
	  sim_sel = sim[ind_gt_10]
	  #
	  err_rel = sim_sel/obs_sel - 1
	  #
          hitr = length(which(abs(na.omit(err_rel))<=des_acc_rel))/length(na.omit(err_rel))
          #
        } else if (grepl("QSPEC",varlist[vari])) {
          #
          err_rel = sim/obs - 1
	  #
          hitr = length(which(abs(na.omit(err_rel))<=des_acc_rel))/length(na.omit(err_rel))
          #
        } else if (varlist[vari]=="WIFFME") {
          #
          des_acc_vec=as.vector(array(des_acc_va1,c(length(obs))))
	  des_acc_vec[which(obs>des_acc_lim)]=des_acc_va2
	  des_acc_vec[which(is.na(obs))]=NA
          #
	  hitr = length(which(abs(na.omit(err))<=na.omit(des_acc_vec)))/length(na.omit(err))
          #
        } else {
          hitr = length(which(abs(na.omit(err))<=des_acc))/length(na.omit(err))
        }
        #
	if (netw==1) {
          bias_cnrm  [seas,vari,nest,stat] = mean(err,na.rm=TRUE)
          mae_cnrm   [seas,vari,nest,stat] = mean(abs(err),na.rm=TRUE)
          rmse_cnrm  [seas,vari,nest,stat] = sqrt(mean(err*err,na.rm=TRUE))
          skvar_cnrm [seas,vari,nest,stat] = var(sim,na.rm=TRUE)/var(obs,na.rm=TRUE)
          hitr_cnrm  [seas,vari,nest,stat] = hitr
        } else if (netw==2) {
	  #
	  if (lsurf>0.5) {
            bias_surf  [seas,vari,nest,stat] = mean(err,na.rm=TRUE)
            mae_surf   [seas,vari,nest,stat] = mean(abs(err),na.rm=TRUE)
            rmse_surf  [seas,vari,nest,stat] = sqrt(mean(err*err,na.rm=TRUE))
            skvar_surf [seas,vari,nest,stat] = var(sim,na.rm=TRUE)/var(obs,na.rm=TRUE)
            hitr_surf  [seas,vari,nest,stat] = hitr
	  }
	  #
        } else {
	  print(netw)
          stop("No rule for this network")
        }
        #
    }
    #
  }
  #
}
#
}
#
# ##############################################
# Write results 
# ##############################################
#
pbase=paste(pevalm,"/",name,sep="")
dir.create(pbase,showWarnings=FALSE)
#
pbase=paste(pevalm,"/",name,"/",scen,sep="")
dir.create(pbase,showWarnings=FALSE)
#
for (nest in 1:length(nest_vec)) {
  #
  pbase=paste(pevalm,"/",name,"/",scen,"/Nest_",nest_vec[nest],sep="")
  dir.create(pbase,showWarnings=FALSE)
  #
  for (stat in 1:length(name_cnrmstat)) {
    #
    filesav=paste(pbase,"/",name_cnrmstat[stat],"_Nest_",nest_vec[nest],".txt",sep="")
    #
    write("     ",file=filesav,append=FALSE,sep="")
    #
    for (vari in 1:length(varieval_capitoul_cnrmstat)) {
      #
      write("     ",file=filesav,append=TRUE,sep="")
      write(varieval_capitoul_cnrmstat[vari],file=filesav,append=TRUE,sep="")
      #
      for (seas in 1:length(seasvec)) {
        #
        write(paste(seasvec[seas],"BIAS","MAE","RMSE","SKVAR","HITR"),file=filesav,append=TRUE,sep="")
        write(paste(format(bias_cnrm[seas,vari,nest,stat],digits=3,width=10),format(mae_cnrm  [seas,vari,nest,stat],digits=3,width=10),
                    format(rmse_cnrm[seas,vari,nest,stat],digits=3,width=10),format(skvar_cnrm[seas,vari,nest,stat],digits=3,width=10),
                    format(hitr_cnrm[seas,vari,nest,stat],digits=3,width=10),sep=""),file=filesav,append=TRUE)
        #
      }
      #
    }
  }
  #
  if (lsurf>0.5) {
  for (stat in 1:length(name_surfstat)) {
    #
    filesav=paste(pbase,"/",name_surfstat[stat],".txt",sep="")
    #
    write("     ",file=filesav,append=FALSE,sep="")
    #
    for (vari in 1:length(varieval_capitoul_surfstat)) {
      #
      write("     ",file=filesav,append=TRUE,sep="")
      write(varieval_capitoul_surfstat[vari],file=filesav,append=TRUE,sep="")
      #
      for (seas in 1:length(seasvec)) {
        #
        write(paste(seasvec[seas],"BIAS","MAE","RMSE","SKVAR","HITR"),file=filesav,append=TRUE,sep="")
        write(paste(format(bias_surf[seas,vari,nest,stat],digits=3,width=10),format(mae_surf  [seas,vari,nest,stat],digits=3,width=10),
                    format(rmse_surf[seas,vari,nest,stat],digits=3,width=10),format(skvar_surf[seas,vari,nest,stat],digits=3,width=10),
                    format(hitr_surf[seas,vari,nest,stat],digits=3,width=10),sep=""),file=filesav,append=TRUE)
        #
      }
      #
    }
  }
  }
  #
  # ##############################################
  # Save data in R format
  # ##############################################
  #
  filesav=paste(pbase,"/RSAVE_EVAL_",name,"_",scen,sep="")
  #
  if (lsurf>0.5) {
    #
    LST=list(numb_cnrmstat=numb_cnrmstat,name_cnrmstat=name_cnrmstat,varieval_capitoul_cnrmstat=varieval_capitoul_cnrmstat,
             seasvec=seasvec,bias_cnrm=bias_cnrm,rmse_cnrm=rmse_cnrm,hitr_cnrm=hitr_cnrm,mae_cnrm=mae_cnrm,skvar_cnrm=skvar_cnrm,
             numb_surfstat=numb_surfstat,name_surfstat=name_surfstat,varieval_capitoul_surfstat=varieval_capitoul_surfstat,
             seasvec=seasvec,bias_surf=bias_surf,rmse_surf=rmse_surf,hitr_surf=hitr_surf,
	     mae_surf=mae_surf,skvar_surf=skvar_surf)
    #
  } else {
    #
    LST=list(numb_cnrmstat=numb_cnrmstat,name_cnrmstat=name_cnrmstat,varieval_capitoul_cnrmstat=varieval_capitoul_cnrmstat,
             seasvec=seasvec,bias_cnrm=bias_cnrm,rmse_cnrm=rmse_cnrm,hitr_cnrm=hitr_cnrm,mae_cnrm=mae_cnrm,skvar_cnrm=skvar_cnrm)
    #
  }
  #
  save(LST,file=filesav)
  #
}
#
print("                                                   ")
print("Hourly evaluation measures calculated with success ")
print("                                                   ")
#
