#!/usr/bin/env python
#
import os
import time
import datetime
import csv
#
import matplotlib
import numpy as np
from netCDF4 import Dataset
#
# ###############################################
# User input section
# ###############################################
#
# The name of the simulation to investigate
#
# name="HK_HWMay2018_Final"
# name="HK_HWMay2018_SURFFLUX"
# name="HK_HWSep2009_Final"
name="HK_HWSep2009_SURFFLUX"
#
# The vertical level heights
#
zlvl_w=np.array([0.0,2.0,4.3,6.94,9.98,13.48,17.50,22.13,27.45,33.57,40.60,48.69,58.00,68.70,81.0,95.16,111.43,130.15,151.67])
#
# The level heights
#
zlvlh = zlvl_w[1:len(zlvl_w)]-zlvl_w[0:(len(zlvl_w)-1)]
#
# The year, month, and day of the simulation start
#
yearini=2018
montini=5
dayyini=17
yearini=2009
montini=9
dayyini=1
#
# The year, month, and day of the simulation end
#
yearend=2018
montend=5
dayyend=31
yearend=2009
montend=9
dayyend=8
#
# The nest to investigate
#
nest=5
#
# The number of regions for budgets
#
nreg=7
#
# The number of vertical levels for budgets
#
nlev=8
#
# The vertical levels for the averaging
#
nlev_low=3
nlev_hig=8
#
# The list of variables for budgets
#
varlist=["UHOR","WW","TH","TK","RV"]
#
# The names of the regions
#
name_reg=["KLT","KP","HKO","HKP","KOWLOON","HKIW","HKIE"]
#
# The number of outputs per day
#
nout=24
#
# The path for saving the budgets 
#
psave="/home/robert/Bureau/SURFEX/ANALYSIS/BUDGETS/"
#
# ###############################################
# End user input section
# ###############################################
#
sta_date = datetime.date(yearini,montini,dayyini)
end_date = datetime.date(yearend,montend,dayyend)
#
ndays=(end_date-sta_date).days + 1
#
d = sta_date
delta = datetime.timedelta(days=1)
#
daycount=0
#
while d <= end_date:
  #
  year = d.year
  m    = d.month
  j    = d.day
  #
  print "Treating " + str(year).zfill(4) + str(m).zfill(2) + str(j).zfill(2)
  #
  pathcnrm = "/media/robert/TOSHIBA EXT/Budgets/" + name + "/RUNDAY_" + str(year).zfill(4) + \
             str(m).zfill(2) + str(j).zfill(2) + "/MNHOU." + str(nest) + ".SEGM0.000.nc4"
  #
  ncfile1 = Dataset(pathcnrm,'r')
  #
  for VAR in varlist:
    #
    if VAR=="UHOR":
      nproc=12
      proc_name=["INIF_BU_RU","ENDF_BU_RU","AVEF_BU_RU","NEST_BU_RU","CURV_BU_RU","COR_BU_RU",
                 "DRVG_BU_RU","DRBD_BU_RU","VTURB_BU_RU","HTURB_BU_RU","ADV_BU_RU","PRES_BU_RU"]
      UHOR_budget = np.zeros((nreg,nlev,nproc,nout))
      UHOR_budget_weig = np.zeros((nreg,nproc,nout))
    elif VAR=="WW":
      nproc=11
      proc_name=["INIF_BU_RW","ENDF_BU_RW","AVEF_BU_RW","NEST_BU_RW","CURV_BU_RW","COR_BU_RW",
                 "VTURB_BU_RW","HTURB_BU_RW","GRAV_BU_RW","ADV_BU_RW","PRES_BU_RW"]
      WW_budget = np.zeros((nreg,nlev,nproc,nout))
      WW_budget_weig = np.zeros((nreg,nproc,nout))
    elif VAR=="TH":
      nproc=26
      proc_name=["INIF_BU_RTH","ENDF_BU_RTH","AVEF_BU_RTH","NEST_BU_RTH","RAD_BU_RTH","DRBD_BU_RTH",
                 "VTURB_BU_RW","HTURB_BU_RW","DISSH_BU_RTH","ADV_BU_RTH","NEGA_BU_RTH","HENU_BU_RTH",
                 "HON_BU_RTH","SFR_BU_RTH","DEPS_BU_RTH","DEPG_BU_RTH","REVA_BU_RTH","RIM_BU_RTH",
                 "ACC_BU_RTH","CFRZ_BU_RTH","WETG_BU_RTH","DRYG_BU_RTH","GMLT_BU_RTH","IMLT_BU_RTH",
                 "BERFI_BU_RTH","CDEPI_BU_RTH"]
      TH_budget = np.zeros((nreg,nlev,nproc,nout))
      TH_budget_weig = np.zeros((nreg,nproc,nout))
    elif VAR=="TK":
      nproc=10
      proc_name=["INIF_BU_RTKE","ENDF_BU_RTKE","AVEF_BU_RTKE","DRVG_BU_RTKE","DRBD_BU_RTKE","DP_BU_RTKE",
                 "TP_BU_RTKE","DISS_BU_RTKE","TR_BU_RTKE","ADV_BU_RTKE"]
      TK_budget = np.zeros((nreg,nlev,nproc,nout))
      TK_budget_weig = np.zeros((nreg,nproc,nout))
    elif VAR=="RV":
      nproc=14
      proc_name=["INIF_BU_RRV","ENDF_BU_RRV","AVEF_BU_RRV","NEST_BU_RRV","DRBD_BU_RRV","VTURB_BU_RRV",
                 "HTURB_BU_RRV","ADV_BU_RRV","NEGA_BU_RRV","HENU_BU_RRV","DEPS_BU_RRV","DEPG_BU_RRV",
                 "REVA_BU_RRV","CDEPI_BU_RRV"]
      RV_budget = np.zeros((nreg,nlev,nproc,nout))
      RV_budget_weig = np.zeros((nreg,nproc,nout))
    else:
      print VAR
      print "No rule implemented for this variable"
      exit
    #
    for hour in range(nout):
      for proc in range(nproc):
        #
        if VAR=="UHOR":
          #
          data_UU = ncfile1.variables["UU___00" + str(hour+1).zfill(2) + "--PROC" + str(proc+1)]
          data_VV = ncfile1.variables["VV___00" + str(hour+1).zfill(2) + "--PROC" + str(proc+1)]
          #
          if (proc==2):
            UU_vals=data_UU
            VV_vals=data_VV
          #
          for reg in range(nreg):
            for lev in range(nlev):
               #
               if proc>2:
                 #
                 if UU_vals[reg,0,lev,0,0]>=0:
                   UHOR_budget[reg,lev,proc,hour] = UHOR_budget[reg,lev,proc,hour] + data_UU[reg,0,lev,0,0]
                 else:
                   UHOR_budget[reg,lev,proc,hour] = UHOR_budget[reg,lev,proc,hour] - data_UU[reg,0,lev,0,0]
                 #
                 if VV_vals[reg,0,lev,0,0]>=0:
                   UHOR_budget[reg,lev,proc,hour] = UHOR_budget[reg,lev,proc,hour] + data_VV[reg,0,lev,0,0]
                 else:
                   UHOR_budget[reg,lev,proc,hour] = UHOR_budget[reg,lev,proc,hour] - data_VV[reg,0,lev,0,0]
                 #
               
          #
        elif VAR=="WW":
          data = ncfile1.variables[VAR + "___00" + str(hour+1).zfill(2) + "--PROC" + str(proc+1)]
          WW_budget[:,:,proc,hour] = WW_budget[:,:,proc,hour] + data[:,0,:,0,0]
        elif VAR=="TH":
          data = ncfile1.variables[VAR + "___00" + str(hour+1).zfill(2) + "--PROC" + str(proc+1)]
          TH_budget[:,:,proc,hour] = TH_budget[:,:,proc,hour] + data[:,0,:,0,0]
        elif VAR=="TK":
          data = ncfile1.variables[VAR + "___00" + str(hour+1).zfill(2) + "--PROC" + str(proc+1)]
          TK_budget[:,:,proc,hour] = TK_budget[:,:,proc,hour] + data[:,0,:,0,0]
        elif VAR=="RV":
          data = ncfile1.variables[VAR + "___00" + str(hour+1).zfill(2) + "--PROC" + str(proc+1)]
          RV_budget[:,:,proc,hour] = RV_budget[:,:,proc,hour] + data[:,0,:,0,0]
        else:
          print VAR
          print "No rule implemented for this variable"
          exit  
        #
  #
  daycount = daycount + 1
  d = d + delta
  #
#
UHOR_budget = UHOR_budget/daycount
WW_budget = WW_budget/daycount
TH_budget = TH_budget/daycount
TK_budget = TK_budget/daycount
RV_budget = RV_budget/daycount
#
# Calculate the weighted sum over the vertical levels
#
count_lev=0.0
#
for lev in range(nlev_low,nlev_hig):
  #
  count_lev=count_lev+zlvlh[lev]
  #
  UHOR_budget_weig = UHOR_budget_weig + UHOR_budget[:,lev,:,:]*zlvlh[lev]
  WW_budget_weig = WW_budget_weig + WW_budget[:,lev,:,:]*zlvlh[lev]
  TH_budget_weig = TH_budget_weig + TH_budget[:,lev,:,:]*zlvlh[lev]
  TK_budget_weig = TK_budget_weig + TK_budget[:,lev,:,:]*zlvlh[lev]
  RV_budget_weig = RV_budget_weig + RV_budget[:,lev,:,:]*zlvlh[lev]
#
UHOR_budget_weig = UHOR_budget_weig/count_lev
WW_budget_weig = WW_budget_weig/count_lev
TH_budget_weig = TH_budget_weig/count_lev
TK_budget_weig = TK_budget_weig/count_lev
RV_budget_weig = RV_budget_weig/count_lev
#
# Write budget by region
#
for reg in range(nreg):
  #
  namesave = psave + name + "Budget_UHOR_" + name_reg[reg] + ".csv"
  with open(namesave,'w') as f:
    writer = csv.writer(f)
    writer.writerows(UHOR_budget_weig[reg,:,:])
    #
  namesave = psave + name + "Budget_WW_" + name_reg[reg] + ".csv"
  with open(namesave,'w') as f:
    writer = csv.writer(f)
    writer.writerows(WW_budget_weig[reg,:,:])
  #
  namesave = psave + name + "Budget_TH_" + name_reg[reg] + ".csv"
  with open(namesave,'w') as f:
    writer = csv.writer(f)
    writer.writerows(TH_budget_weig[reg,:,:])
  #
  namesave = psave + name + "Budget_TK_" + name_reg[reg] + ".csv"
  with open(namesave,'w') as f:
    writer = csv.writer(f)
    writer.writerows(TK_budget_weig[reg,:,:])
  #
  namesave = psave + name + "Budget_RV_" + name_reg[reg] + ".csv"
  with open(namesave,'w') as f:
    writer = csv.writer(f)
    writer.writerows(RV_budget_weig[reg,:,:])
  #
#
print "All budgets calculated successfully"
#
