!     #########
      SUBROUTINE WRITESURF_TEB_n (DGU, U, TM, GDM, GRM, HM, &
                                  HPROGRAM,KPATCH,HWRITE    )
!     ####################################
!
!!****  *WRITE_TEB_n* - writes TEB fields
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!
!
!
!
!
!
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n,      ONLY : SURF_ATM_t
USE MODD_SURFEX_n,        ONLY : TEB_MODEL_t
USE MODD_SURFEX_n,        ONLY : TEB_GARDEN_MODEL_t
USE MODD_SURFEX_n,        ONLY : TEB_GREENROOF_MODEL_t
USE MODD_SURFEX_n,        ONLY : TEB_HYDRO_MODEL_t
!
USE MODI_WRITE_SURF
USE MODI_WRITESURF_GR_SNOW
USE MODI_WRITESURF_TEB_GARDEN_n
USE MODI_WRITESURF_TEB_GREENROOF_n
USE MODI_WRITESURF_TEB_HYDRO_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!RJ #ifdef SFX_MPI
!RJ INCLUDE "mpif.h"
!RJ #endif
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
TYPE(DIAG_SURF_ATM_t),       INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t),            INTENT(INOUT) :: U
TYPE(TEB_MODEL_t),           INTENT(INOUT) :: TM
TYPE(TEB_GARDEN_MODEL_t),    INTENT(INOUT) :: GDM
TYPE(TEB_GREENROOF_MODEL_t), INTENT(INOUT) :: GRM
TYPE(TEB_HYDRO_MODEL_t),     INTENT(INOUT) :: HM
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
INTEGER,           INTENT(IN)  :: KPATCH   ! current TEB patch
 CHARACTER(LEN=3),    INTENT(IN)  :: HWRITE    ! 'PREP' : does not write SBL XUNDEF fields
!                                             ! 'ALL' : all fields are written
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP           ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=LEN_HREC) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
 CHARACTER(LEN=3)  :: YPATCH         ! Patch identificator
 CHARACTER(LEN=7)  :: YDIR           ! Direction identificator
 CHARACTER(LEN=100):: YSTRING        ! Comment string
!
INTEGER :: JLAYER ! loop on surface layers
INTEGER :: JCOMP  ! loop on compartments
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_TEB_N',0,ZHOOK_HANDLE)
!
YPATCH='   '
IF (TM%TOP%NTEB_PATCH>1) WRITE(YPATCH,FMT='(A1,I1,A1)') 'T',KPATCH,'_'
!
!
!*       2.     Option for road orientation:
!               ---------------------------
!
YCOMMENT='Option for Road orientation in TEB scheme'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'ROAD_DIR',TM%TOP%CROAD_DIR,IRESP,YCOMMENT)
YCOMMENT='Option for Wall representation in TEB scheme'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'WALL_OPT',TM%TOP%CWALL_OPT,IRESP,YCOMMENT)
!
!*       3.     Prognostic fields:
!               -----------------
!
!* roof temperatures
!
DO JLAYER=1,TM%TOP%NROOF_LAYER
   WRITE(YRECFM,'(A3,A5,I1.1,A1)') YPATCH,'TROOF',JLAYER,' '
   WRITE(YCOMMENT,'(A9,I1.1,A4)') 'X_Y_TROOF',JLAYER,' (K)'
   YRECFM=ADJUSTL(YRECFM)
   !
   CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,TM%T%CUR%XT_ROOF(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
   !
ENDDO
!
!* roof water content
!
YRECFM=YPATCH//'WS_ROOF'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='WS_ROOF (kg/m2)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XWS_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
!* road temperatures
!
DO JLAYER=1,TM%T%CUR%NTEB_SOIL
  IF (JLAYER.LT.10) THEN
    WRITE(YRECFM,'(A3,A5,I1.1,A1)') YPATCH,'TROAD',JLAYER,' '
  ELSE
    WRITE(YRECFM,'(A3,A5,I2.1,A1)') YPATCH,'TROAD',JLAYER,' '
  ENDIF
  YRECFM=ADJUSTL(YRECFM)
  IF (TM%TOP%CROAD_DIR=='UNIF' .OR. TM%DTT%LDATA_ROAD_DIR) THEN
    YSTRING = 'X_Y_TROAD'
  ELSEIF (SIZE(TM%T%CUR%XROAD_DIR)>0) THEN
    !* road direction is uniform spatially, one can then indicate it in the comment
    CALL ROAD_DIR(TM%T%CUR%XROAD_DIR(1),YDIR)
    YSTRING=TRIM(YDIR)//' ROAD TEMP. LAYER '
  ELSE
    YSTRING='? ROAD TEMP. LAYER '
  ENDIF
  IF (JLAYER.LT.10) THEN
    WRITE(YCOMMENT,'(A,I1.1,A4)') TRIM(YSTRING), JLAYER,' (K)'
  ELSE
    WRITE(YCOMMENT,'(A,I2.1,A4)') TRIM(YSTRING), JLAYER,' (K)'
  ENDIF
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XT_ROAD(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
END DO
!
!* road water content
!
YRECFM=YPATCH//'WS_ROAD'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='WS_ROAD (kg/m2)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XWS_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
!* floor deep temperatures (same number of layers than for road)
!
IF (SIZE(TM%T%CUR%XT_BLD,2).NE.SIZE(TM%T%CUR%XT_ROAD,2)) THEN
   CALL ABOR1_SFX("Road and deep floor layer number must be equal")
ENDIF
!
DO JLAYER=1,TM%T%CUR%NTEB_SOIL
   DO JCOMP=1,SIZE(TM%T%CUR%XT_BLD,3)
      !
      IF (JLAYER.LT.10) THEN
         WRITE(YRECFM,'(A3,A4,I1.1,A1,I1.1)') YPATCH,'TBLD',JLAYER,'_',JCOMP
      ELSE
         WRITE(YRECFM,'(A3,A4,I2.1,A1,I1.1)') YPATCH,'TBLD',JLAYER,'_',JCOMP
      ENDIF
      YRECFM=ADJUSTL(YRECFM)
      !
      YSTRING='Floor deep temperature layer '
      !
      IF (JLAYER.LT.10) THEN
         WRITE(YCOMMENT,'(A,I1.1,A1,I1.1,A4)') TRIM(YSTRING), JLAYER,'_',JCOMP,' (K)'
      ELSE
         WRITE(YCOMMENT,'(A,I2.1,A1,I1.1,A4)') TRIM(YSTRING), JLAYER,'_',JCOMP,' (K)'
      ENDIF
      !
      CALL WRITE_SURF(DGU, U, HPROGRAM, YRECFM, TM%T%CUR%XT_BLD(:,JLAYER,JCOMP), &
                      IRESP,HCOMMENT=YCOMMENT)
      !
   ENDDO
ENDDO
!
!* wall temperatures
!
DO JLAYER=1,TM%TOP%NWALL_LAYER
 IF (TM%TOP%CWALL_OPT=='UNIF') THEN
  WRITE(YRECFM,'(A3,A5,I1.1,A1)') YPATCH,'TWALL',JLAYER,' '
  YRECFM=ADJUSTL(YRECFM)
  WRITE(YCOMMENT,'(A9,I1.1,A4)') 'X_Y_TWALL',JLAYER,' (K)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XT_WALL_A(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
 ELSE
  !* Wall A
  WRITE(YRECFM,'(A3,A6,I1.1)') YPATCH,'TWALLA',JLAYER
  YRECFM=ADJUSTL(YRECFM)
  IF (TM%DTT%LDATA_ROAD_DIR) THEN
    YSTRING = 'X_Y_TWALL_A'
  ELSEIF (SIZE(TM%T%CUR%XROAD_DIR)>0) THEN
    !* wall direction is uniform spatially, one can then indicate it in the comment
    CALL WALLA_DIR(TM%T%CUR%XROAD_DIR(1),YDIR)
    YSTRING=TRIM(YDIR)//'-FACING WALL TEMP. LAYER '
  ELSE
    YSTRING='?-FACING WALL TEMP. LAYER '
  ENDIF
  WRITE(YCOMMENT,'(A,I1.1,A4)') TRIM(YSTRING), JLAYER,' (K)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XT_WALL_A(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  !
  !* Wall B
  WRITE(YRECFM,'(A3,A6,I1.1)') YPATCH,'TWALLB',JLAYER
  YRECFM=ADJUSTL(YRECFM)
  IF (TM%DTT%LDATA_ROAD_DIR) THEN
    YSTRING = 'X_Y_TWALL_B'
  ELSEIF (SIZE(TM%T%CUR%XROAD_DIR)>0) THEN
    !* wall direction is uniform spatially, one can then indicate it in the comment
    CALL WALLB_DIR(TM%T%CUR%XROAD_DIR(1),YDIR)
    YSTRING=TRIM(YDIR)//'-FACING WALL TEMP. LAYER '
  ELSE
    YSTRING='?-FACING WALL TEMP. LAYER '
  ENDIF
  WRITE(YCOMMENT,'(A,I1.1,A4)') TRIM(YSTRING), JLAYER,' (K)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XT_WALL_B(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
 END IF
END DO
!
!* internal building temperature
!
DO JCOMP=1,SIZE(TM%B%CUR%XTI_BLD,2)
   IF (SIZE(TM%B%CUR%XTI_BLD,2)==1) THEN
     YRECFM='TI_BLD'
     YCOMMENT='X_Y_TI_BLD (K)'
   ELSE
     WRITE(YRECFM,'(A3,A5,I1.1)') YPATCH,'TIBLD',JCOMP
     WRITE(YCOMMENT,'(A9,I1.1,A4)') 'X_Y_TIBLD',JCOMP,' (K)'
   END IF
   YRECFM=ADJUSTL(YRECFM)
   CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%B%CUR%XTI_BLD(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
ENDDO
!
!* outdoor window temperature
!
YRECFM=YPATCH//'T_WIN1'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='T_WIN1 (K)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%B%CUR%XT_WIN1(:),IRESP,HCOMMENT=YCOMMENT)
!
IF (TM%TOP%CBEM=='BEM') THEN
  !
  !* internal building specific humidity
  !
  DO JCOMP=1,SIZE(TM%B%CUR%XQI_BLD,2)
   IF (SIZE(TM%B%CUR%XQI_BLD,2)==1) THEN
     YRECFM='QI_BLD'
     YCOMMENT='X_Y_QI_BLD (K)'
   ELSE
     WRITE(YRECFM,'(A3,A5,I1.1)') YPATCH,'QIBLD',JCOMP
     WRITE(YCOMMENT,'(A9,I1.1,A4)') 'X_Y_QIBLD',JCOMP,' (kg/kg)'
   END IF
     YRECFM=ADJUSTL(YRECFM)
     CALL WRITE_SURF(DGU, U, &
                   HPROGRAM,YRECFM,TM%B%CUR%XQI_BLD(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
  ENDDO
  !
  !* indoor window temperature
  !
  YRECFM=YPATCH//'T_WIN2'
  YRECFM=ADJUSTL(YRECFM)
  YCOMMENT='T_WIN2 (K)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%B%CUR%XT_WIN2(:),IRESP,HCOMMENT=YCOMMENT)
  !
  !* floor temperatures
  !
  DO JLAYER=1,TM%BOP%NFLOOR_LAYER
     DO JCOMP=1,SIZE(TM%B%CUR%XT_FLOOR,3)
        WRITE(YRECFM,'(A3,A5,I1.1,A1,I1.1)') YPATCH,'TFLOO',JLAYER,'_',JCOMP
        WRITE(YCOMMENT,'(A9,I1.1,A1,I1.1,A4)') 'X_Y_TFLOO',JLAYER,'_',JCOMP,' (K)'
        YRECFM=ADJUSTL(YRECFM)
        CALL WRITE_SURF(DGU, U, &
             HPROGRAM,YRECFM,TM%B%CUR%XT_FLOOR(:,JLAYER,JCOMP),IRESP,HCOMMENT=YCOMMENT)
     END DO
  END DO
  !
  !* internal th. mass temperature
  !
  DO JLAYER=1,TM%BOP%NMASS_LAYER
     DO JCOMP=1,SIZE(TM%B%CUR%XT_MASS,3)
        WRITE(YRECFM,'(A3,A5,I1.1,A1,I1.1)') YPATCH,'TMASS',JLAYER,'_',JCOMP
        WRITE(YCOMMENT,'(A9,I1.1,A1,I1.1,A4)') 'X_Y_TMASS',JLAYER,'_',JCOMP,' (K)'
        YRECFM=ADJUSTL(YRECFM)
        CALL WRITE_SURF(DGU, U, &
              HPROGRAM,YRECFM,TM%B%CUR%XT_MASS(:,JLAYER,JCOMP),IRESP,HCOMMENT=YCOMMENT)
     END DO
  END DO        
  !
  !* Pressure at previous time step
  !
  YRECFM=YPATCH//'PSOLD'
  YRECFM=ADJUSTL(YRECFM)
  YCOMMENT='PSOLD (Pa)'
  CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,TM%B%CUR%XPSOLD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  !* Status of nocturnal ventilation
  !
  DO JCOMP=1,SIZE(TM%B%CUR%XVENTNIGSW,2)
     WRITE(YRECFM,'(A3,A7,I1.1)') YPATCH,'VENTNIG',JCOMP
     YRECFM=ADJUSTL(YRECFM)
     YCOMMENT='Fraction ()'
     CALL WRITE_SURF(DGU, U, &
                     HPROGRAM,YRECFM,TM%B%CUR%XVENTNIGSW(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
  ENDDO
  !
  !* Status of shading when vacant
  !
  DO JCOMP=1,SIZE(TM%B%CUR%XSHADVACSW,2)
     WRITE(YRECFM,'(A3,A7,I1.1)') YPATCH,'SHADVAC',JCOMP
     YRECFM=ADJUSTL(YRECFM)
     YCOMMENT='Fraction ()'
     CALL WRITE_SURF(DGU, U, &
                     HPROGRAM,YRECFM,TM%B%CUR%XSHADVACSW(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
  ENDDO
  !
ENDIF
!
!* deep road temperature
!
YRECFM=YPATCH//'TI_ROAD'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='TI_ROAD (K)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XTI_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
!* snow mantel
!
YRECFM='RF'
 CALL WRITESURF_GR_SNOW(DGU, U, &
                        HPROGRAM,YRECFM,YPATCH,TM%T%CUR%TSNOW_ROOF  )
!
YRECFM='RD'
 CALL WRITESURF_GR_SNOW(DGU, U, &
                        HPROGRAM,YRECFM,YPATCH,TM%T%CUR%TSNOW_ROAD  )
!
!-------------------------------------------------------------------------------
!
!*       4.     Semi-prognostic fields:
!               ----------------------
!
!* temperature of canyon air
!
YRECFM=YPATCH//'TCANYON'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='T_CANYON (K)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XT_CANYON(:),IRESP,HCOMMENT=YCOMMENT)
!
!* humidity of canyon air
!
YRECFM=YPATCH//'QCANYON'
YRECFM=ADJUSTL(YRECFM)
YCOMMENT='Q_CANYON (kg/kg)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%T%CUR%XQ_CANYON(:),IRESP,HCOMMENT=YCOMMENT)
!
!
!* Thermal solar panels present day production
!
IF (TM%TOP%LSOLAR_PANEL) THEN
  YRECFM=YPATCH//'THER_PDAY'
  YRECFM=ADJUSTL(YRECFM)
  YCOMMENT='Thermal Solar Panels present day production (J/m2)'
  IF (.NOT. ASSOCIATED(TM%TPN%XTHER_PRODC_DAY)) THEN
    ! for PREP cases
    ALLOCATE(TM%TPN%XTHER_PRODC_DAY(SIZE(TM%B%CUR%XTI_BLD,1)))
    TM%TPN%XTHER_PRODC_DAY=0.
  END IF
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%TPN%XTHER_PRODC_DAY(:),IRESP,HCOMMENT=YCOMMENT)
END IF
!-------------------------------------------------------------------------------
!
!*       5.  Time
!            ----
!
IF (KPATCH==1) THEN
  YRECFM='DTCUR'
  YCOMMENT='s'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TM%TOP%TTIME,IRESP,HCOMMENT=YCOMMENT)
END IF
!
!
!-------------------------------------------------------------------------------
!
!*       6.  Urban green areas
!            ------------------
!
! Gardens
IF (TM%TOP%LGARDEN) CALL WRITESURF_TEB_GARDEN_n(DGU, U, GDM,    &
                                                HPROGRAM,YPATCH )
!
! Green roofs
IF (TM%TOP%LGREENROOF) CALL WRITESURF_TEB_GREENROOF_n(DGU, U, GDM%TVG, GRM, &
                                                      HPROGRAM,YPATCH       )
!
! Urban hydrology
IF (TM%TOP%LGARDEN.AND.TM%TOP%LURBHYDRO) CALL WRITESURF_TEB_HYDRO_n(DGU, U, HM,      &
                                                  HPROGRAM,YPATCH, TM%T%CUR%NTEB_SOIL)
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_TEB_N',1,ZHOOK_HANDLE)
!
!
!-------------------------------------------------------------------------------
CONTAINS
SUBROUTINE ROAD_DIR(PDIR,HDIR)
REAL,             INTENT(IN)  :: PDIR
 CHARACTER(LEN=7), INTENT(OUT) :: HDIR
REAL :: ZDIR
ZDIR=PDIR
IF (PDIR<0) ZDIR = PDIR +360.
IF (ZDIR>=  0.   .AND. ZDIR< 11.25) HDIR='N-S    '
IF (ZDIR>= 11.25 .AND. ZDIR< 33.75) HDIR='NNE-SSW'
IF (ZDIR>= 33.75 .AND. ZDIR< 56.25) HDIR='NE-SW'
IF (ZDIR>= 56.25 .AND. ZDIR< 78.75) HDIR='ENE-WSW'
IF (ZDIR>= 78.75 .AND. ZDIR<101.25) HDIR='E-W    '
IF (ZDIR>=101.25 .AND. ZDIR<123.75) HDIR='ESE-WNW'
IF (ZDIR>=123.75 .AND. ZDIR<146.25) HDIR='SE-NW  '
IF (ZDIR>=146.25 .AND. ZDIR<168.75) HDIR='SSE-NNW'
IF (ZDIR>=168.75 .AND. ZDIR<180.00) HDIR='N-S    '
END SUBROUTINE ROAD_DIR
SUBROUTINE WALLA_DIR(PDIR,HDIR)
REAL,             INTENT(IN)  :: PDIR
 CHARACTER(LEN=7), INTENT(OUT) :: HDIR
REAL :: ZDIR
ZDIR=PDIR
IF (PDIR<0) ZDIR = PDIR +360.
IF (ZDIR>=  0.   .AND. ZDIR< 11.25) HDIR='E      '
IF (ZDIR>= 11.25 .AND. ZDIR< 33.75) HDIR='ESE    '
IF (ZDIR>= 33.75 .AND. ZDIR< 56.25) HDIR='SE     ' 
IF (ZDIR>= 56.25 .AND. ZDIR< 78.75) HDIR='SSE    '
IF (ZDIR>= 78.75 .AND. ZDIR<101.25) HDIR='S      '
IF (ZDIR>=101.25 .AND. ZDIR<123.75) HDIR='SSW    '
IF (ZDIR>=123.75 .AND. ZDIR<146.25) HDIR='SW     '
IF (ZDIR>=146.25 .AND. ZDIR<168.75) HDIR='WSW    '
IF (ZDIR>=168.75 .AND. ZDIR<180.00) HDIR='W      '
END SUBROUTINE WALLA_DIR
SUBROUTINE WALLB_DIR(PDIR,HDIR)
REAL,             INTENT(IN)  :: PDIR
 CHARACTER(LEN=7), INTENT(OUT) :: HDIR
REAL :: ZDIR
ZDIR=PDIR
IF (PDIR<0) ZDIR = PDIR +360.
IF (ZDIR>=  0.   .AND. ZDIR< 11.25) HDIR='W      '
IF (ZDIR>= 11.25 .AND. ZDIR< 33.75) HDIR='WNW    '
IF (ZDIR>= 33.75 .AND. ZDIR< 56.25) HDIR='NW     ' 
IF (ZDIR>= 56.25 .AND. ZDIR< 78.75) HDIR='NNW    '
IF (ZDIR>= 78.75 .AND. ZDIR<101.25) HDIR='N      '
IF (ZDIR>=101.25 .AND. ZDIR<123.75) HDIR='NNE    '
IF (ZDIR>=123.75 .AND. ZDIR<146.25) HDIR='NE     '
IF (ZDIR>=146.25 .AND. ZDIR<168.75) HDIR='ENE    '
IF (ZDIR>=168.75 .AND. ZDIR<180.00) HDIR='E      '
END SUBROUTINE WALLB_DIR
!-------------------------------------------------------------------------------
!
END SUBROUTINE WRITESURF_TEB_n
