!     #########
      SUBROUTINE WRITESURF_PGD_BEM_PAR_n (DTB, DGU, U, BOP, HPROGRAM)
!     ################################################
!
!!****  *WRITESURF_PGD_BEM_PAR_n* - write BEM physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      M. Goret   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2017 move BEM related variables from WRITESURF_PGD_TEB_PAR_n
!!
!!      M. Goret    02/2017 add heating fractions
!!      M. Goret    10/2017 add hot water
!!
!!
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_BEM_OPTION_n, ONLY : BEM_OPTIONS_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODI_WRITE_SURF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(BEM_OPTIONS_t), INTENT(INOUT) :: BOP
!
CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=LEN_HREC) :: YRECFM  ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT      ! Comment string
INTEGER           :: JLAYER         ! loop index
INTEGER           :: JCOMP          ! loop index
INTEGER           :: JSCHED         ! loop index
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_BEM_PAR_N',0,ZHOOK_HANDLE)
!
!
 !
  IF (DTB%LDATA_HC_FLOOR) THEN
    YCOMMENT='Number of specified Floor thermal layers'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'PAR_FL_LAYER',DTB%NPAR_FLOOR_LAYER,IRESP,YCOMMENT)
  END IF
  !
  YRECFM='L_HC_FLOOR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_HC_FLOOR,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_HC_FLOOR) THEN
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A10,I1.1)') 'D_HC_FLOOR',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_HC_FLOOR(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  YRECFM='L_TC_FLOOR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_TC_FLOOR,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TC_FLOOR) THEN
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A10,I1.1)') 'D_TC_FLOOR',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_TC_FLOOR(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  YRECFM='L_D_FLOOR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_D_FLOOR,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_D_FLOOR) THEN
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A9,I1.1)') 'D_D_FLOOR',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (m)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_D_FLOOR(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_HC_MASS) THEN
    YCOMMENT='Number of specified Mass thermal layers'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'PAR_MA_LAYER',DTB%NPAR_MASS_LAYER,IRESP,YCOMMENT)
  END IF
  !
  YRECFM='L_HC_MASS'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_HC_MASS,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_HC_MASS) THEN
    DO JLAYER=1,DTB%NPAR_MASS_LAYER
      WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_MASS',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_HC_MASS(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  YRECFM='L_TC_MASS'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_TC_MASS,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TC_MASS) THEN
    DO JLAYER=1,DTB%NPAR_MASS_LAYER
      WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_MASS',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_TC_MASS(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  YRECFM='L_D_MASS'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_D_MASS,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_D_MASS) THEN
    DO JLAYER=1,DTB%NPAR_MASS_LAYER
      WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_MASS',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (m)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_D_MASS(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  YRECFM='L_F_WAST_CAN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_F_WASTE_CAN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_F_WASTE_CAN) THEN
    YRECFM='D_F_WAST_CAN'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_F_WASTE_CAN,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_QIN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_QIN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_QIN) THEN
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    DO JCOMP=1,BOP%NBEMCOMP
       WRITE(YRECFM,FMT='(A5,I1.1)') 'D_QIN',JCOMP
       CALL WRITE_SURF(DGU, U, &
          HPROGRAM,YRECFM,DTB%XPAR_QIN(:,JCOMP),IRESP,YCOMMENT)
    ENDDO
  ENDIF
  !
  YRECFM='L_QIN_FRAD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_QIN_FRAD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_QIN_FRAD) THEN
    YRECFM='D_QIN_FRAD'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_QIN_FRAD,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_SHGC'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_SHGC,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_SHGC) THEN
    YRECFM='D_SHGC'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_SHGC,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_U_WIN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_U_WIN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_U_WIN) THEN
    YRECFM='D_U_WIN'
    YCOMMENT='X_Y_'//YRECFM//' (W m-2 K-1)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_U_WIN,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_GR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_GR,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_GR) THEN
    YRECFM='D_GR'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_GR,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_SHGC_SH'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_SHGC_SH,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_SHGC_SH) THEN
    YRECFM='D_SHGC_SH'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_SHGC_SH,IRESP,YCOMMENT)
  ENDIF  
  !
  YRECFM='L_FLOOR_HEIG'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_FLOOR_HEIGHT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FLOOR_HEIGHT) THEN
    YRECFM='D_FLOOR_HEIG'
    YCOMMENT='X_Y_'//YRECFM//' (m)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_FLOOR_HEIGHT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_N50'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_N50,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_N50) THEN
    YRECFM='D_N50'
    YCOMMENT='X_Y_'//YRECFM//' (ACH)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_N50,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_QIN_FLAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_QIN_FLAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_QIN_FLAT) THEN
    YRECFM='D_QIN_FLAT'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_QIN_FLAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_HR_TARGET'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_HR_TARGET,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_HR_TARGET) THEN
    YRECFM='D_HR_TARGET'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_HR_TARGET,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_CAP_SYS_HE'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_CAP_SYS_HEAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_CAP_SYS_HEAT) THEN
    YRECFM='D_CAP_SYS_HE'
    YCOMMENT='X_Y_'//YRECFM//' (W m-2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_CAP_SYS_HEAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_CAP_SYS_RA'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_CAP_SYS_RAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_CAP_SYS_RAT) THEN
    YRECFM='D_CAP_SYS_RA'
    YCOMMENT='X_Y_'//YRECFM//' (W m-2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_CAP_SYS_RAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_T_ADP'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_T_ADP,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_T_ADP) THEN
    YRECFM='D_T_ADP'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_T_ADP,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_M_SYS_RAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_M_SYS_RAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_M_SYS_RAT) THEN
    YRECFM='D_M_SYS_RAT'
    YCOMMENT='X_Y_'//YRECFM//' (kg s-1 m-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_M_SYS_RAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_COP_RAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_COP_RAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_COP_RAT) THEN
    YRECFM='D_COP_RAT'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_COP_RAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_T_SIZE_MAX'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_T_SIZE_MAX,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_T_SIZE_MAX) THEN
    YRECFM='D_T_SIZE_MAX'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_T_SIZE_MAX,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_T_SIZE_MIN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_T_SIZE_MIN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_T_SIZE_MIN) THEN
    YRECFM='D_T_SIZE_MIN'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_T_SIZE_MIN,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FWAT_COND'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_F_WATER_COND,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_F_WATER_COND) THEN
    YRECFM='D_FWAT_COND'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_F_WATER_COND,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_SHADEARCHI'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_SHADEARCHI,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_SHADEARCHI) THEN
    YRECFM='D_SHADEARCHI'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_SHADEARCHI,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_NATVENT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_NATVENT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_NATVENT) THEN
    DO JCOMP=1,BOP%NBEMCOMP
       WRITE(YRECFM,FMT='(A9,I1.1)') 'D_NATVENT',JCOMP
       YCOMMENT='X_Y_'//YRECFM//' (-)'
       CALL WRITE_SURF(DGU, U, &
                       HPROGRAM,YRECFM,DTB%XPAR_NATVENT(:,JCOMP),IRESP,YCOMMENT)
    ENDDO
  ENDIF
  !
  YRECFM='L_ISMECH'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DTB%LDATA_ISMECH,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_ISMECH) THEN
     YRECFM='D_ISMECH'
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_ISMECH,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_MECHRATE'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_MECHRATE,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_MECHRATE) THEN
     YRECFM='D_MECHRATE'
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_MECHRATE,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FSNIG'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_FSNIG,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FSNIG) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FSNIG',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_FSNIG(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_FVNIG'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_FVNIG,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FVNIG) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FVNIG',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_FVNIG(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_MODQ_VCD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_MODQIN_VCD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_MODQIN_VCD) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A10,I1.1)') 'D_MODQ_VCD',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_MODQIN_VCD(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_MODQ_VLD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_MODQIN_VLD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_MODQIN_VLD) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A10,I1.1)') 'D_MODQ_VLD',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_MODQIN_VLD(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_MODQ_NIG'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_MODQIN_NIG,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_MODQIN_NIG) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A10,I1.1)') 'D_MODQ_NIG',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_MODQIN_NIG(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TDESV'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_TDESV,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TDESV) THEN
     YRECFM='D_TDESV'
     YCOMMENT='X_Y_'//YRECFM//' (K)'
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_TDESV,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_WIN_SW_MAX'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_WIN_SW_MAX,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_WIN_SW_MAX) THEN
     YRECFM='D_WIN_SW_MAX'
     YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
     CALL WRITE_SURF(DGU, U, &
         HPROGRAM,YRECFM,DTB%XPAR_WIN_SW_MAX,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FOPEN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_FOPEN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FOPEN) THEN
     YRECFM='D_FOPEN'
     YCOMMENT='X_Y_'//YRECFM//' (1)'
     CALL WRITE_SURF(DGU, U, &
       HPROGRAM,YRECFM,DTB%XPAR_FOPEN,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FVSUM'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_FVSUM,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FVSUM) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FVSUM',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_FVSUM(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_FVVAC'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_FVVAC,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FVVAC) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_FVVAC'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FVVAC',JCOMP
     CALL WRITE_SURF(DGU, U, &
       HPROGRAM,YRECFM,DTB%XPAR_FVVAC(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_FSSUM'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_FSSUM,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FSSUM) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_FSSUM'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FSSUM',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_FSSUM(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_FSVAC'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_FSVAC,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FSVAC) THEN
    DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_FSVAC'//YRECFM//' (1)'
     WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FSVAC',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_FSVAC(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TC_OCCD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_TCOOL_OCCD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TCOOL_OCCD) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_OCCD',JCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_TCOOL_OCCD(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TC_OCCN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_TCOOL_OCCN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TCOOL_OCCN) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_OCCN',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_TCOOL_OCCN(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TC_VCDD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_TCOOL_VCDD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TCOOL_VCDD) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_VCDD',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_TCOOL_VCDD(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TC_VCDN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_TCOOL_VCDN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TCOOL_VCDN) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_VCDN',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_TCOOL_VCDN(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TC_VCLD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_TCOOL_VCLD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TCOOL_VCLD) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_VCLD',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_TCOOL_VCLD(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TH_OCCD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_THEAT_OCCD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_THEAT_OCCD) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_OCCD',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_THEAT_OCCD(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TH_OCCN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_THEAT_OCCN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_THEAT_OCCN) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_OCCN',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_THEAT_OCCN(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TH_VCDD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_THEAT_VCDD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_THEAT_VCDD) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_VCDD',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_THEAT_VCDD(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TH_VCDN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_THEAT_VCDN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_THEAT_VCDN) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_VCDN',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_THEAT_VCDN(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_TH_VCLD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
      HPROGRAM,YRECFM,DTB%LDATA_THEAT_VCLD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_THEAT_VCLD) THEN
     DO JCOMP=1,BOP%NBEMCOMP
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_VCLD',JCOMP
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_THEAT_VCLD(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YCOMMENT='Number of days distinguished in schedules'
  CALL WRITE_SURF(DGU, U, &
    HPROGRAM,'PAR_DAY_SCHED',DTB%NPAR_DAY_SCHED,IRESP,YCOMMENT)
  !
  YCOMMENT='Number of hours distinguished in schedules'
  CALL WRITE_SURF(DGU, U, &
    HPROGRAM,'PAR_CRE_SCHED',DTB%NPAR_CRE_SCHED,IRESP,YCOMMENT)
  !
  YCOMMENT='Number of holidays'
  CALL WRITE_SURF(DGU, U, &
    HPROGRAM,'PAR_NHOLIDAY',DTB%NPAR_HOLIDAY,IRESP,YCOMMENT)
  !
  YRECFM='L_FRACOMP'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_FRACOMP,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FRACOMP) THEN
     YCOMMENT='X_Y_'//YRECFM//' (h)'
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_FRACOMP',JCOMP
        CALL WRITE_SURF(DGU, U, &
           HPROGRAM,YRECFM,DTB%XPAR_FRACOMP(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_RESIDENTIAL'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_RESIDENTIAL,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_RESIDENTIAL) THEN
     YRECFM='D_RESIDENTIAL'
     YCOMMENT='X_Y_'//YRECFM//' (1)'
     CALL WRITE_SURF(DGU, U, &
        HPROGRAM,YRECFM,DTB%XPAR_RESIDENTIAL(:),IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_DAYBEGS'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_DAYWBEG_SCHED,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_DAYWBEG_SCHED) THEN
     YCOMMENT='X_Y_'//YRECFM//' (h)'
     DO JSCHED=1,DTB%NPAR_DAY_SCHED
        DO JCOMP=1,BOP%NBEMCOMP
          WRITE(YRECFM,FMT='(A9,I2.2,I1.1)') 'D_DAYBEGS',JSCHED,JCOMP
          CALL WRITE_SURF(DGU, U, &
             HPROGRAM,YRECFM,DTB%XPAR_DAYWBEG_SCHED(:,JSCHED,JCOMP),IRESP,YCOMMENT)
        ENDDO
     ENDDO
  ENDIF
  !
  YRECFM='L_HOUBEGS'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_HOURBEG_SCHED,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_HOURBEG_SCHED) THEN
     YCOMMENT='X_Y_'//YRECFM//' (h)'
     DO JSCHED=1,(DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED)
        DO JCOMP=1,BOP%NBEMCOMP
           WRITE(YRECFM,FMT='(A9,I2.2,I1.1)') 'D_HOUBEGS',JSCHED,JCOMP
           CALL WRITE_SURF(DGU, U, &
             HPROGRAM,YRECFM,DTB%XPAR_HOURBEG_SCHED(:,JSCHED,JCOMP),IRESP,YCOMMENT)
        ENDDO
     ENDDO
  ENDIF
  !
  YRECFM='L_PROBOCC'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_PROBOCC,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_PROBOCC) THEN
     YCOMMENT='X_Y_'//YRECFM//' (h)'
     DO JSCHED=1,(DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED)
        DO JCOMP=1,BOP%NBEMCOMP
           WRITE(YRECFM,FMT='(A9,I2.2,I1.1)') 'D_PROBOCC',JSCHED,JCOMP
           CALL WRITE_SURF(DGU, U, &
              HPROGRAM,YRECFM,DTB%XPAR_PROBOCC(:,JSCHED,JCOMP),IRESP,YCOMMENT)
        ENDDO
     ENDDO
  ENDIF
  !
  YRECFM='L_BEG_HOLIDAY'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_BEG_HOLIDAY,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_BEG_HOLIDAY) THEN
     YCOMMENT='X_Y_'//YRECFM//' (day)'
     DO JSCHED=1,DTB%NPAR_HOLIDAY
        DO JCOMP=1,BOP%NBEMCOMP
           WRITE(YRECFM,FMT='(A8,I1.1,I1.1)') 'D_BEGHOL',JSCHED,JCOMP
           CALL WRITE_SURF(DGU, U, &
              HPROGRAM,YRECFM,DTB%XPAR_BEG_HOLIDAY(:,JSCHED,JCOMP),IRESP,YCOMMENT)
        ENDDO
     ENDDO
  ENDIF
  !
  YRECFM='L_END_HOLIDAY'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
     HPROGRAM,YRECFM,DTB%LDATA_END_HOLIDAY,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_END_HOLIDAY) THEN
     YCOMMENT='X_Y_'//YRECFM//' (day)'
     DO JSCHED=1,DTB%NPAR_HOLIDAY
        DO JCOMP=1,BOP%NBEMCOMP
           WRITE(YRECFM,FMT='(A8,I1.1,I1.1)') 'D_ENDHOL',JSCHED,JCOMP
           CALL WRITE_SURF(DGU, U, &
              HPROGRAM,YRECFM,DTB%XPAR_END_HOLIDAY(:,JSCHED,JCOMP),IRESP,YCOMMENT)
        ENDDO
     ENDDO
  ENDIF
  !
  YRECFM='L_MOD_HOLIDAY'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
      HPROGRAM,YRECFM,DTB%LDATA_MOD_HOLIDAY,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_MOD_HOLIDAY) THEN
     YCOMMENT='X_Y_'//YRECFM//' (-)'
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A8,I1.1)') 'D_MODHOL',JCOMP
        CALL WRITE_SURF(DGU, U, &
          HPROGRAM,YRECFM,DTB%XPAR_MOD_HOLIDAY(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
  YRECFM='L_FRAC_HELEC'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT_ELEC,IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DTB%LDATA_FRAC_HEAT_ELEC) THEN
    YRECFM='D_FRAC_HELEC'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DTB%XPAR_FRAC_HEAT_ELEC,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FRAC_HGAS'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT_GAS,IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DTB%LDATA_FRAC_HEAT_GAS) THEN
    YRECFM='D_FRAC_HGAS'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DTB%XPAR_FRAC_HEAT_GAS,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FRAC_HFUEL'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT_FUEL,IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DTB%LDATA_FRAC_HEAT_FUEL) THEN
    YRECFM='D_FRAC_HFUEL'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DTB%XPAR_FRAC_HEAT_FUEL,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FRAC_HOTHR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT_OTHER,IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DTB%LDATA_FRAC_HEAT_OTHER) THEN
    YRECFM='D_FRAC_HOTHR'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DTB%XPAR_FRAC_HEAT_OTHER,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FRAC_HEAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
      HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT,IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='L_F_HW_GAS'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DTB%LDATA_F_HW_GAS,IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DTB%LDATA_F_HW_GAS) THEN
    YRECFM='D_F_HW_GAS'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DTB%XPAR_F_HW_GAS,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_HOTWAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
      HPROGRAM,YRECFM,DTB%LDATA_HOTWAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_HOTWAT) THEN
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A8,I1.1)') 'D_HOTWAT',JCOMP
        YCOMMENT='X_Y_'//YRECFM//' (-)'
        CALL WRITE_SURF(DGU, U, &
          HPROGRAM,YRECFM,DTB%XPAR_HOTWAT(:,JCOMP),IRESP,YCOMMENT)
     ENDDO
  ENDIF
  !
 !
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_BEM_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE WRITESURF_PGD_BEM_PAR_n
