!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITE_DIAG_TEB_GARDEN_n (DTCO, DGU, U, DGTGD, TVG, HPROGRAM)
!     #################################
!
!!****  *WRITE_DIAG_TEB_GARDE_n* - writes TEB_GARDEN diagnostics
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!          
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      M.Goret   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    08/2017
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_DIAG_TEB_GARDEN_n, ONLY : DIAG_TEB_GARDEN_t
USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t         
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODI_END_IO_SURF_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(DIAG_TEB_GARDEN_t), INTENT(INOUT) :: DGTGD
TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=LEN_HREC) :: YRECFM   ! Name of the article to be read
CHARACTER(LEN=100):: YCOMMENT       ! Comment string
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!         Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_TEB_GARDEN_N',0,ZHOOK_HANDLE)
!
 CALL INIT_IO_SURF_n(DTCO, DGU, U, &
                    HPROGRAM,'TOWN  ','TEB   ','WRITE')
!
IF (DGTGD%LDIAG_GD) THEN
!

  IF(TVG%CPHOTO/='NON')THEN
    !
    YRECFM='GPP_GD'
    YCOMMENT='X_Y_'//YRECFM//' (kgCO2/m2/s)'
    CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DGTGD%XGPP(:),IRESP,HCOMMENT=YCOMMENT)
    !
   ! YRECFM='R_AUTO_GD'
   ! YCOMMENT='X_Y_'//YRECFM//' (kgCO2/m2/s)'
   ! CALL WRITE_SURF(DGU, U, &
   !               HPROGRAM,YRECFM,DGTGD%XRESP_AUTO(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='R_ECO_GD'
    YCOMMENT='X_Y_'//YRECFM//' (kgCO2/m2/s)'
    CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DGTGD%XRESP_ECO(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
!
ENDIF
!         End of IO
!
 CALL END_IO_SURF_n(HPROGRAM)
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_TEB_GARDEN_N',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE WRITE_DIAG_TEB_GARDEN_n
