  !     ##########################################################################################
  !SUBROUTINE WINDOW_SHADING_AVAILABILITY(PSHADEARCHI,PTI_BLD,PT_CANYON, &
  !     PTDESV,PSHADE_POSSIBLE)
  !   ##########################################################################################
  !
  !!****  *WINDOW_SHADING_AVAILABILITY* 
  !!
  !!    PURPOSE
  !!    -------
  !!* checks if one encouters the conditions for closing the windows at day
  !  (needs to be equiped of solar protections and not to be confortable inside)
  !!
  !!**  METHOD
  !!    ------
  !!
  !!    EXTERNAL
  !!    --------
  !!
  !!    IMPLICIT ARGUMENTS
  !!    ------------------
  !!
  !!    REFERENCE
  !!    ---------
  !!
  !!    AUTHOR
  !!    ------
  !!	G. Pigeon   *Meteo France*	
  !!
  !!    MODIFICATIONS
  !!    -------------
  !!      Original    10/2011
  !-------------------------------------------------------------------------------
  !
  !*       0.    DECLARATIONS
  !              ------------
  !
  !  IMPLICIT NONE
  !
  !*       0.1   Declarations of arguments
  !              -------------------------
  !
  !  REAL, DIMENSION(:), INTENT(IN) :: PSHADEARCHI  ! Are shading elements present (architectural characteristic)
  !  REAL, DIMENSION(:), INTENT(IN) :: PSHAD_BEHAV  ! Shading based on behavioural
  !  REAL, DIMENSION(:), INTENT(IN) :: PTSUNTIME  ! solar time   (s from midnight)
  !   REAL, DIMENSION(:), INTENT(IN) :: PTI_BLD    ! Indoor air temperature
  !   REAL, DIMENSION(:), INTENT(IN) :: PT_CANYON  ! Street-Canyon air temperature
  !   REAL, DIMENSION(:), INTENT(IN) :: PTDESV     ! Threshold temperature for manual ventilation
  !   REAL, INTENT(IN)               :: PTSTEP
  !  
  !   CHARACTER(LEN=4), DIMENSION(:), INTENT(IN) :: HNATVENT
  !
  !    REAL, DIMENSION(:), INTENT(OUT) :: PSHADE_POSSIBLE ! Indicator for potential shading usage
  !
  !*       0.2   Declarations of local variables
  !
  !    INTEGER :: JJ  ! Loop index
  !
  !-------------------------------------------------------------------------------
  !
  ! Robert: Shading now depending on ventilation options
  !
  !    DO JJ=1,SIZE(PTI_BLD)
  !
  !       IF (PSHADEARCHI(JJ).LT.0.5) THEN
  !
  ! In the case where no shading elements are present, no shading is possible
  !
  !         PSHADE_POSSIBLE(JJ) = 0.0
  !
  !      ELSE
  !
  ! Shading only possible when the building is occupied
  !
  !         IF (PTI_BLD(JJ).GT.PTDESV(JJ)) THEN
  !          PSHADE_POSSIBLE(JJ)=1.0
  !         ELSE 
  !            PSHADE_POSSIBLE(JJ)=0.0
  !          ENDIF
  !       ENDIF
  !    ENDDO
  !
  !  END SUBROUTINE WINDOW_SHADING_AVAILABILITY
  
