!   ##########################################################################
    SUBROUTINE URBAN_LW_COEF(PGR, PBLD, PLW_RAD,                                  &
                             PEMIS_R, PSVF_RS, PEMIS_W, PSVF_WS,                  &
                             PEMIS_WIN,                                           &
                             PSVF_SR, PSVF_SW, PSVF_ST,                           &
                             PSVF_RW, PSVF_WW, PSVF_WR,                           &
                             PEMIS_G, PROAD, PGARDEN,                             &
                             PEMIS_HV, PFRAC_HVEG,                                &
                             PSVF_TS, PSVF_RT, PSVF_WT,                           &
                             PESNOW_R, PTS_SR, PTS_W_A, PTS_W_B,                  &
                             PTS_R, PTS_G, PTS_WIN,                               & 
                             PTS_HV,                                              &
                             PTAU_SW, PTAU_SR, PTAU_WW, PTAU_WR,                  &  
                             PLW_WA_TO_WB, PLW_WA_TO_R, PLW_WB_TO_R,              &
                             PLW_WA_TO_NR,PLW_WB_TO_NR,                           &
                             PLW_WA_TO_G, PLW_WB_TO_G,                            &
                             PLW_WA_TO_WIN, PLW_WB_TO_WIN,                        &
                             PLW_WA_TO_HV, PLW_WB_TO_HV,                          &
                             PLW_WA_TO_S, PLW_WB_TO_S,                            &
                             PLW_R_TO_WA, PLW_R_TO_WB, PLW_R_TO_WIN, PLW_R_TO_HV, &
                             PLW_R_TO_S,                                          &
                             PLW_G_TO_WA, PLW_G_TO_WB, PLW_G_TO_WIN, PLW_G_TO_HV, &
                             PLW_G_TO_S,                                          &
                             PLW_S_TO_WA, PLW_S_TO_WB, PLW_S_TO_R, PLW_S_TO_NR,   &
                             PLW_S_TO_G, PLW_S_TO_WIN, PLW_S_TO_HV,               &
                             PLW_WIN_TO_WA, PLW_WIN_TO_WB,                        &
                             PLW_WIN_TO_R, PLW_WIN_TO_NR,                         &
                             PLW_WIN_TO_G, PLW_WIN_TO_HV, PLW_WIN_TO_S,           &
                             PLW_NR_TO_WA, PLW_NR_TO_WB, PLW_NR_TO_WIN,           &
                             PLW_NR_TO_HV, PLW_NR_TO_S,                           &
                             PLW_HV_TO_WA, PLW_HV_TO_WB, PLW_HV_TO_R,             &
                             PLW_HV_TO_NR,PLW_HV_TO_G, PLW_HV_TO_WIN, PLW_HV_TO_S )
!   ##########################################################################
!
!!****  *URBAN_LW_COEF*  
!!
!!    PURPOSE
!!    -------
!
!     Computes the coefficients before each of the temperatures in the
!     radiative budgets
!         
!     
!!**  METHOD
!     ------
!
!
!
!
!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    MODD_CST
!!
!!      
!!    REFERENCE
!!    ---------
!!
!!      
!!    AUTHOR
!!    ------
!!
!!	V. Masson           * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    08/09/98 
!!      Modifs      01/16 (E.Redon/A.Lemonsu) Add high vegetation radiative interactions
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
USE MODD_CSTS         ,ONLY : XSTEFAN
USE MODD_SURF_PAR     ,ONLY : XUNDEF
USE MODD_TEB_PAR      ,ONLY : XEMIS_WIN_CST
!
USE YOMHOOK           ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1          ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!
REAL, DIMENSION(:), INTENT(IN)  :: PGR          ! glazing ratio
REAL, DIMENSION(:), INTENT(IN)  :: PBLD         ! building density
REAL, DIMENSION(:), INTENT(IN)  :: PLW_RAD      ! incoming LW radiation
REAL, DIMENSION(:), INTENT(IN)  :: PEMIS_R      ! road emissivity
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_RS      ! road sky view factor
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_RW      ! view factor of walls from road
REAL, DIMENSION(:), INTENT(IN)  :: PEMIS_W      ! wall emissivity
REAL, DIMENSION(:), INTENT(OUT) :: PEMIS_WIN    ! windows emissivity
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_WS      ! wall sky view factor
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_WW      ! view factor of one wall from the other wall
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_WR      ! view factor of road from all
REAL, DIMENSION(:), INTENT(IN)  :: PEMIS_G      ! garden area emissivity
REAL, DIMENSION(:), INTENT(IN)  :: PROAD        ! road fraction
REAL, DIMENSION(:), INTENT(IN)  :: PGARDEN      ! garden area fraction
REAL, DIMENSION(:), INTENT(IN)  :: PEMIS_HV     ! high vegetation emissivity
REAL, DIMENSION(:), INTENT(IN)  :: PFRAC_HVEG   ! high vegetation fraction
!
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_SR      ! view factor of road from sky
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_SW      ! view factor of walls from sky
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_ST      ! view factor of high vegetation from sky
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_TS      ! sky view factor of high vegetation
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_RT      ! view factor of high veg from road
REAL, DIMENSION(:), INTENT(IN)  :: PSVF_WT      ! view factor of high veg from walls
REAL, DIMENSION(:), INTENT(IN)  :: PESNOW_R     ! road snow emissivity
!
REAL, DIMENSION(:), INTENT(IN)  :: PTS_W_A  ! wall A surface temperature
REAL, DIMENSION(:), INTENT(IN)  :: PTS_W_B  ! wall B surface temperature
REAL, DIMENSION(:), INTENT(IN)  :: PTS_R    ! road surface tempeature
REAL, DIMENSION(:), INTENT(IN)  :: PTS_G    ! garden surface temperature
REAL, DIMENSION(:), INTENT(IN)  :: PTS_WIN  ! window surface temperature
REAL, DIMENSION(:), INTENT(IN)  :: PTS_SR   ! snow surface temperature
REAL, DIMENSION(:), INTENT(IN)  :: PTS_HV   ! high vegetation foliage temperature
!
REAL, DIMENSION(:), INTENT(IN)  :: PTAU_WW     ! Transmissivity wall to wall/window to window
REAL, DIMENSION(:), INTENT(IN)  :: PTAU_SW     ! Transmissivity wall or window to sky/sky to wall or window
REAL, DIMENSION(:), INTENT(IN)  :: PTAU_WR     ! Transmissivity wall or window to road/road to wall or window
REAL, DIMENSION(:), INTENT(IN)  :: PTAU_SR     ! Transmissivity road to sky/sky to road
!
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WA_TO_WB  ! L.W. interactions wall->opposite wall
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WA_TO_R   ! L.W. interactions wall->road for road balance 
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WB_TO_R   ! L.W. interactions wall->road for road balance 
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WA_TO_NR  ! L.W. interactions wall->snow for snow balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WB_TO_NR  ! L.W. interactions wall->snow for snow balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WA_TO_G   ! L.W. interactions wall->GARDEN areas for garden balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WB_TO_G   ! L.W. interactions wall->GARDEN areas for garden balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WA_TO_WIN ! L.W. interactions wall->win for window balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WB_TO_WIN ! L.W. interactions wall->win for window balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WA_TO_HV  ! L.W. interactions wall->high vegetation areas for high veg balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WB_TO_HV  ! L.W. interactions wall->high vegetation areas for high veg balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WA_TO_S   ! L.W. interactions wall->sky for sky balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WB_TO_S   ! L.W. interactions wall->sky for sky balance
!
REAL, DIMENSION(:), INTENT(OUT) :: PLW_R_TO_WA   ! L.W. interactions road->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_R_TO_WB   ! L.W. interactions road->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_R_TO_WIN  ! L.W. interactions road->win for win balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_R_TO_HV   ! L.W. interactions road->high vegetation for high veg balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_R_TO_S    ! L.W. interactions road->sky for sky balance
!
REAL, DIMENSION(:), INTENT(OUT) :: PLW_G_TO_WA   ! L.W. interactions GARDEN areas->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_G_TO_WB   ! L.W. interactions GARDEN areas->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_G_TO_WIN  ! L.W. interactions GARDEN areas->window for window balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_G_TO_HV   ! L.W. interactions GARDEN areas->high vegetation for high veg balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_G_TO_S    ! L.W. interactions GARDEN areas->sky for sky balance
!
REAL, DIMENSION(:), INTENT(OUT) :: PLW_S_TO_WA  ! L.W. interactions sky->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_S_TO_WB  ! L.W. interactions sky->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_S_TO_R   ! L.W. interactions sky->road for raod balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_S_TO_NR  ! L.W. interactions sky->snow for snow balance 
REAL, DIMENSION(:), INTENT(OUT) :: PLW_S_TO_G   ! L.W. interactions sky->GARDEN areas for garden balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_S_TO_WIN ! L.W. interactions sky->win for window balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_S_TO_HV  ! L.W. interactions sky->high vegetation areas for high veg balance
!
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WIN_TO_WA ! L.W. interactions win->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WIN_TO_WB ! L.W. interactions win->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WIN_TO_R  ! L.W. interactions win->road for road balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WIN_TO_NR ! L.W. interactions win->snow areas for snow balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WIN_TO_G  ! L.W. interactions win->GARDEN areas for garden balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WIN_TO_HV ! L.W. interactions win->high vegetation areas for high veg balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WIN_TO_S  ! L.W. interactions win->sky for sky balance
!
REAL, DIMENSION(:), INTENT(OUT) :: PLW_NR_TO_WA  ! L.W. interactions snow(road)->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_NR_TO_WB  ! L.W. interactions snow(road)->wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_NR_TO_WIN ! L.W. interactions snow(road)->WIN areas for window balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_NR_TO_HV  ! L.W. interactions snow(road)->high vegetation for high veg balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_NR_TO_S   ! L.W. interactions snow(road)->sky for sky balance
!
REAL, DIMENSION(:), INTENT(OUT) :: PLW_HV_TO_WA  ! L.W. interaction high veg -> wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_HV_TO_WB  ! L.W. interaction high veg -> wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_HV_TO_WIN ! L.W. interaction high veg -> wall for wall balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_HV_TO_G   ! L.W. interaction high veg -> garden for garden balance
REAL, DIMENSION(:), INTENT(OUT) :: PLW_HV_TO_R   ! L.W. interaction high veg -> road for road balance 
REAL, DIMENSION(:), INTENT(OUT) :: PLW_HV_TO_NR  ! L.W. interaction high veg -> snow for road balance 
REAL, DIMENSION(:), INTENT(OUT) :: PLW_HV_TO_S   ! L.W. interaction high veg -> sky for sky balance 
!
!*      0.2    declarations of local variables
!
REAL, DIMENSION(SIZE(PBLD))  :: ZROAD       ! road fraction in the canyon
REAL, DIMENSION(SIZE(PBLD))  :: ZGARDEN     ! garden fraction in the canyon
!
REAL, DIMENSION(SIZE(PBLD))  :: ZT_S        ! sky temperature
!
REAL, DIMENSION(SIZE(PBLD))  :: ZF_W_W
REAL, DIMENSION(SIZE(PBLD))  :: ZF_W_WIN
REAL, DIMENSION(SIZE(PBLD))  :: ZF_W_R
REAL, DIMENSION(SIZE(PBLD))  :: ZF_W_G
REAL, DIMENSION(SIZE(PBLD))  :: ZF_W_NR
REAL, DIMENSION(SIZE(PBLD))  :: ZF_W_HV
REAL, DIMENSION(SIZE(PBLD))  :: ZF_WIN_W
REAL, DIMENSION(SIZE(PBLD))  :: ZF_WIN_R
REAL, DIMENSION(SIZE(PBLD))  :: ZF_WIN_G
REAL, DIMENSION(SIZE(PBLD))  :: ZF_WIN_NR
REAL, DIMENSION(SIZE(PBLD))  :: ZF_WIN_HV
REAL, DIMENSION(SIZE(PBLD))  :: ZF_R_W
REAL, DIMENSION(SIZE(PBLD))  :: ZF_R_WIN
REAL, DIMENSION(SIZE(PBLD))  :: ZF_R_HV
REAL, DIMENSION(SIZE(PBLD))  :: ZF_G_W
REAL, DIMENSION(SIZE(PBLD))  :: ZF_G_WIN
REAL, DIMENSION(SIZE(PBLD))  :: ZF_G_HV
REAL, DIMENSION(SIZE(PBLD))  :: ZF_HV_W
REAL, DIMENSION(SIZE(PBLD))  :: ZF_HV_WIN
REAL, DIMENSION(SIZE(PBLD))  :: ZF_HV_R
REAL, DIMENSION(SIZE(PBLD))  :: ZF_HV_G
REAL, DIMENSION(SIZE(PBLD))  :: ZF_S_W
REAL, DIMENSION(SIZE(PBLD))  :: ZF_S_R
REAL, DIMENSION(SIZE(PBLD))  :: ZF_S_G
REAL, DIMENSION(SIZE(PBLD))  :: ZF_S_NR
REAL, DIMENSION(SIZE(PBLD))  :: ZF_S_WIN
REAL, DIMENSION(SIZE(PBLD))  :: ZF_S_HV
!
REAL :: ZE1, ZE2, ZF, ZT1, ZT2, ZLW, ZTAU
ZLW(ZE1,ZE2,ZF,ZT1,ZT2,ZTAU) = 4.*XSTEFAN*ZE1*ZE2*ZF*ZTAU*((ZT1+ZT2)/2.)**3
!
INTEGER :: JJ
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('URBAN_LW_COEF',0,ZHOOK_HANDLE)
!
ZT_S(:) = (PLW_RAD(:)/XSTEFAN)**0.25
!
DO JJ=1,SIZE(PROAD)
  !
  PEMIS_WIN(JJ) = XEMIS_WIN_CST
  !
  ZF_W_R(JJ)     = PSVF_WR(JJ) * (PROAD(JJ)   / (1.-PBLD(JJ) )) ! without considering snow cover at this stage (done in wall_layer_e_budget) 
  ZF_W_G(JJ)     = PSVF_WR(JJ) * (PGARDEN(JJ) / (1.-PBLD(JJ) ))
  ZF_W_NR(JJ)    = ZF_W_R (JJ)                                  ! without considering snow cover at this stage (done in wall_layer_e_budget)   
  ZF_W_W(JJ)     = PSVF_WW(JJ) * (1.-PGR(JJ))
  ZF_W_WIN(JJ)   = PSVF_WW(JJ) *     PGR(JJ)
  ! 
  ZF_WIN_R(JJ)   = ZF_W_R (JJ)
  ZF_WIN_G(JJ)   = ZF_W_G (JJ)
  ZF_WIN_NR(JJ)  = ZF_W_NR(JJ)
  ZF_WIN_W(JJ)   = ZF_W_W (JJ)
  !
  ZF_R_W(JJ)     = PSVF_RW(JJ) * (1.-PGR(JJ)) * 0.5 ! one wall can emit towards the road - idem for garden
  ZF_R_WIN(JJ)   = PSVF_RW(JJ) *     PGR(JJ)
  !
  ZF_G_W(JJ)     = ZF_R_W(JJ) 
  ZF_G_WIN(JJ)   = ZF_R_WIN(JJ)
  !
  ZF_S_R(JJ)     = PSVF_SR(JJ) * (PROAD(JJ)   / (1.-PBLD(JJ) )) ! without considering snow cover at this stage (done in wall_layer_e_budget) 
  ZF_S_G(JJ)     = PSVF_SR(JJ) * (PGARDEN(JJ) / (1.-PBLD(JJ) ))
  ZF_S_NR(JJ)    = ZF_S_R(JJ)                                  ! without considering snow cover at this stage (done in wall_layer_e_budget)   
  ZF_S_W  (JJ)   = PSVF_SW(JJ) * (1.-PGR(JJ)) * 0.5
  ZF_S_WIN(JJ)   = PSVF_SW(JJ) *     PGR(JJ)
!
  ZF_W_HV(JJ)    = PSVF_WT(JJ) * 0.5 * PFRAC_HVEG(JJ) ! we corrected the hveg contribution by 0.5 because svf_wt is defined on 360° or 2pi
  ZF_WIN_HV(JJ)  = ZF_W_HV(JJ)
  ZF_R_HV(JJ)    = PSVF_RT(JJ) * PFRAC_HVEG(JJ)
  ZF_G_HV(JJ)    = ZF_R_HV(JJ)
  ZF_S_HV(JJ)    = PSVF_ST(JJ) * PFRAC_HVEG(JJ)
!
  IF (PFRAC_HVEG(JJ) .GT. 0.) THEN ! we apply the same geometrical factors as in the solar radiative scheme
!
    ZROAD(JJ)   = PROAD(JJ)   / (1.-PBLD(JJ) )
    ZGARDEN(JJ) = PGARDEN(JJ) / (1.-PBLD(JJ) )
!
!   sum of what has been intercepted (not transmitted) by high veg on the ray way
    ZF_HV_W(JJ)   =  ( PSVF_SW(JJ) * (1.- PTAU_SW(JJ) )   &
                      +PSVF_RW(JJ) * (1.- PTAU_WR(JJ) )   &
                      +PSVF_WW(JJ) * (1.- PTAU_WW(JJ) ) ) &
                    * (         1. /  PFRAC_HVEG(JJ)    ) &
                    * (1.-PGR(JJ)) * 0.5
!
    ZF_HV_WIN(JJ) =  ( PSVF_SW(JJ) * (1.- PTAU_SW(JJ) )   &
                      +PSVF_RW(JJ) * (1.- PTAU_WR(JJ) )   &
                      +PSVF_WW(JJ) * (1.- PTAU_WW(JJ) ) ) &
                    * (         1. /  PFRAC_HVEG(JJ)    ) &
                    * PGR(JJ)
!
    ZF_HV_R(JJ)   =  ( PSVF_SR(JJ) * (1.- PTAU_SR(JJ) )   &
                      +PSVF_WR(JJ) * (1.- PTAU_WR(JJ) ) ) & 
                    *( ZROAD(JJ)   /  PFRAC_HVEG(JJ)    )
!
    ZF_HV_G(JJ)   =  ( PSVF_SR(JJ) * (1.- PTAU_SR(JJ) )   &
                      +PSVF_WR(JJ) * (1.- PTAU_WR(JJ) ) ) & 
                    *( ZGARDEN(JJ) /  PFRAC_HVEG(JJ)    )
!
  ELSE 
    ZF_HV_W(JJ)   = XUNDEF 
    ZF_HV_WIN(JJ) = XUNDEF 
    ZF_HV_R(JJ)   = XUNDEF 
    ZF_HV_G(JJ)   = XUNDEF 
  ENDIF
!
! considering middle of foliage layer in tau terms
  !
  PLW_WA_TO_WB(JJ)  = ZLW(PEMIS_W(JJ),PEMIS_W(JJ),  ZF_W_W(JJ),  PTS_W_A(JJ),PTS_W_B(JJ),PTAU_WW(JJ))
  PLW_WA_TO_R(JJ)   = ZLW(PEMIS_W(JJ),PEMIS_R(JJ),  ZF_R_W(JJ),  PTS_W_A(JJ),PTS_R(JJ),  PTAU_WR(JJ))
  PLW_WA_TO_G(JJ)   = ZLW(PEMIS_W(JJ),PEMIS_G(JJ),  ZF_G_W(JJ),  PTS_W_A(JJ),PTS_G(JJ),  PTAU_WR(JJ))
  PLW_WA_TO_WIN(JJ) = ZLW(PEMIS_W(JJ),PEMIS_WIN(JJ),ZF_WIN_W(JJ),PTS_W_A(JJ),PTS_WIN(JJ),PTAU_WW(JJ))
  PLW_WA_TO_S(JJ)   = ZLW(PEMIS_W(JJ),1.,           ZF_S_W(JJ),  PTS_W_A(JJ),ZT_S(JJ),   PTAU_SW(JJ))
  !
  PLW_WB_TO_R(JJ)   = ZLW(PEMIS_W(JJ),PEMIS_R(JJ),  ZF_R_W(JJ),  PTS_W_B(JJ),PTS_R(JJ),  PTAU_WR(JJ))
  PLW_WB_TO_G(JJ)   = ZLW(PEMIS_W(JJ),PEMIS_G(JJ),  ZF_G_W(JJ),  PTS_W_B(JJ),PTS_G(JJ),  PTAU_WR(JJ))
  PLW_WB_TO_WIN(JJ) = ZLW(PEMIS_W(JJ),PEMIS_WIN(JJ),ZF_WIN_W(JJ),PTS_W_B(JJ),PTS_WIN(JJ),PTAU_WW(JJ))
  PLW_WB_TO_S(JJ)   = ZLW(PEMIS_W(JJ),1.,           ZF_S_W(JJ),  PTS_W_B(JJ),ZT_S(JJ),   PTAU_SW(JJ))
  !
  PLW_R_TO_WA(JJ) = ZLW(PEMIS_R(JJ),PEMIS_W(JJ),  ZF_W_R(JJ),  PTS_R(JJ),PTS_W_A(JJ),PTAU_WR(JJ))
  PLW_R_TO_WB(JJ) = ZLW(PEMIS_R(JJ),PEMIS_W(JJ),  ZF_W_R(JJ),  PTS_R(JJ),PTS_W_B(JJ),PTAU_WR(JJ))
  PLW_R_TO_WIN(JJ)= ZLW(PEMIS_R(JJ),PEMIS_WIN(JJ),ZF_WIN_R(JJ),PTS_R(JJ),PTS_WIN(JJ),PTAU_WR(JJ))
  PLW_R_TO_S(JJ)  = ZLW(PEMIS_R(JJ),1.,           ZF_S_R(JJ),  PTS_R(JJ),ZT_S(JJ),   PTAU_SR(JJ))
  !
  PLW_G_TO_WA(JJ) = ZLW(PEMIS_G(JJ),PEMIS_W(JJ),  ZF_W_G(JJ),  PTS_G(JJ),PTS_W_A(JJ),PTAU_WR(JJ))
  PLW_G_TO_WB(JJ) = ZLW(PEMIS_G(JJ),PEMIS_W(JJ),  ZF_W_G(JJ),  PTS_G(JJ),PTS_W_B(JJ),PTAU_WR(JJ))
  PLW_G_TO_WIN(JJ)= ZLW(PEMIS_G(JJ),PEMIS_WIN(JJ),ZF_WIN_G(JJ),PTS_G(JJ),PTS_WIN(JJ),PTAU_WR(JJ))
  PLW_G_TO_S(JJ)  = ZLW(PEMIS_G(JJ),1.,           ZF_S_G(JJ),  PTS_G(JJ),ZT_S(JJ),   PTAU_SR(JJ))
  !  
  PLW_WIN_TO_WA(JJ) = ZLW(PEMIS_WIN(JJ),PEMIS_W(JJ), ZF_W_WIN(JJ), PTS_WIN(JJ),PTS_W_A(JJ),PTAU_WW(JJ))
  PLW_WIN_TO_WB(JJ) = ZLW(PEMIS_WIN(JJ),PEMIS_W(JJ), ZF_W_WIN(JJ), PTS_WIN(JJ),PTS_W_B(JJ),PTAU_WW(JJ))
  PLW_WIN_TO_R(JJ)  = ZLW(PEMIS_WIN(JJ),PEMIS_R(JJ), ZF_R_WIN(JJ), PTS_WIN(JJ),PTS_R(JJ)  ,PTAU_WR(JJ))
  PLW_WIN_TO_G(JJ)  = ZLW(PEMIS_WIN(JJ),PEMIS_G(JJ), ZF_G_WIN(JJ), PTS_WIN(JJ),PTS_G(JJ)  ,PTAU_WR(JJ))
  PLW_WIN_TO_S(JJ)  = ZLW(PEMIS_WIN(JJ),1.,          ZF_S_WIN(JJ), PTS_WIN(JJ),ZT_S(JJ),   PTAU_WR(JJ))
  !
  PLW_S_TO_WA(JJ)  = ZLW(1.,PEMIS_W(JJ),  PSVF_WS(JJ),ZT_S(JJ),PTS_W_A(JJ),PTAU_SW(JJ))
  PLW_S_TO_WB(JJ)  = ZLW(1.,PEMIS_W(JJ),  PSVF_WS(JJ),ZT_S(JJ),PTS_W_B(JJ),PTAU_SW(JJ))
  PLW_S_TO_R(JJ)   = ZLW(1.,PEMIS_R(JJ),  PSVF_RS(JJ),ZT_S(JJ),PTS_R(JJ),  PTAU_SR(JJ))  
  PLW_S_TO_G(JJ)   = ZLW(1.,PEMIS_G(JJ),  PSVF_RS(JJ),ZT_S(JJ),PTS_G(JJ),  PTAU_SR(JJ))
  PLW_S_TO_WIN(JJ) = ZLW(1.,PEMIS_WIN(JJ),PSVF_WS(JJ),ZT_S(JJ),PTS_WIN(JJ),PTAU_SW(JJ))
  !
  IF (PFRAC_HVEG(JJ) .GT. 0.) THEN
  PLW_WA_TO_HV(JJ)  = ZLW(PEMIS_W(JJ),  PEMIS_HV(JJ), ZF_HV_W(JJ),  PTS_W_A(JJ),PTS_HV(JJ), 1.)
  PLW_WB_TO_HV(JJ)  = ZLW(PEMIS_W(JJ),  PEMIS_HV(JJ), ZF_HV_W(JJ),  PTS_W_B(JJ),PTS_HV(JJ), 1.)
  PLW_R_TO_HV(JJ)   = ZLW(PEMIS_R(JJ),  PEMIS_HV(JJ), ZF_HV_R(JJ),  PTS_R(JJ),  PTS_HV(JJ), 1.)
  PLW_G_TO_HV(JJ)   = ZLW(PEMIS_G(JJ),  PEMIS_HV(JJ), ZF_HV_G(JJ),  PTS_G(JJ),  PTS_HV(JJ), 1.)
  PLW_WIN_TO_HV(JJ) = ZLW(PEMIS_WIN(JJ),PEMIS_HV(JJ), ZF_HV_WIN(JJ),PTS_WIN(JJ),PTS_HV(JJ), 1.)
  PLW_S_TO_HV(JJ)   = ZLW(1.,           PEMIS_HV(JJ), PSVF_TS(JJ),  ZT_S(JJ),   PTS_HV(JJ), 1.)
  PLW_HV_TO_WA(JJ)  = ZLW(PEMIS_HV(JJ), PEMIS_W(JJ),  ZF_W_HV(JJ),  PTS_HV(JJ), PTS_W_A(JJ),1.)
  PLW_HV_TO_WB(JJ)  = ZLW(PEMIS_HV(JJ), PEMIS_W(JJ),  ZF_W_HV(JJ),  PTS_HV(JJ), PTS_W_B(JJ),1.) 
  PLW_HV_TO_R(JJ)   = ZLW(PEMIS_HV(JJ), PEMIS_R(JJ),  ZF_R_HV(JJ),  PTS_HV(JJ), PTS_R(JJ),  1.)
  PLW_HV_TO_G(JJ)   = ZLW(PEMIS_HV(JJ), PEMIS_G(JJ),  ZF_G_HV(JJ),  PTS_HV(JJ), PTS_G(JJ),  1.)
  PLW_HV_TO_WIN(JJ) = ZLW(PEMIS_HV(JJ), PEMIS_WIN(JJ),ZF_WIN_HV(JJ),PTS_HV(JJ), PTS_WIN(JJ),1.)
  PLW_HV_TO_S(JJ) =   ZLW(PEMIS_HV(JJ), 1.,           ZF_S_HV(JJ),  PTS_HV(JJ), ZT_S(JJ),   1.)
  ELSE
  PLW_WA_TO_HV(JJ)  = 0.
  PLW_WB_TO_HV(JJ)  = 0.
  PLW_R_TO_HV(JJ)   = 0.
  PLW_G_TO_HV(JJ)   = 0.
  PLW_WIN_TO_HV(JJ) = 0.
  PLW_S_TO_HV(JJ)   = 0.
  PLW_HV_TO_WA(JJ)  = 0.
  PLW_HV_TO_WB(JJ)  = 0.
  PLW_HV_TO_R(JJ)   = 0.
  PLW_HV_TO_G(JJ)   = 0.
  PLW_HV_TO_WIN(JJ) = 0.
  PLW_HV_TO_S(JJ)   = 0.
  ENDIF
  !
  IF (PTS_SR(JJ) .EQ. XUNDEF) THEN
    PLW_WA_TO_NR (JJ) = 0.
    PLW_WB_TO_NR (JJ) = 0.
    PLW_HV_TO_NR(JJ)  = 0.
    PLW_WIN_TO_NR(JJ) = 0.
    PLW_S_TO_NR  (JJ) = 0.
!
    PLW_NR_TO_WA (JJ) = 0.
    PLW_NR_TO_WB (JJ) = 0.
    PLW_NR_TO_HV(JJ)  = 0.
    PLW_NR_TO_WIN(JJ) = 0.
    PLW_NR_TO_S(JJ)   = 0.
!
  ELSE
!
    PLW_WA_TO_NR(JJ) = ZLW(PEMIS_W(JJ),  PESNOW_R(JJ),ZF_R_W(JJ),  PTS_W_A(JJ),PTS_SR(JJ),PTAU_WR(JJ))
    PLW_WB_TO_NR(JJ) = ZLW(PEMIS_W(JJ),  PESNOW_R(JJ),ZF_R_W(JJ),  PTS_W_B(JJ),PTS_SR(JJ),PTAU_WR(JJ))
    PLW_WIN_TO_NR(JJ)= ZLW(PEMIS_WIN(JJ),PESNOW_R(JJ),ZF_R_WIN(JJ),PTS_WIN(JJ),PTS_SR(JJ),PTAU_WR(JJ))
    PLW_S_TO_NR(JJ)  = ZLW(1.,           PESNOW_R(JJ),PSVF_RS(JJ), ZT_S(JJ),   PTS_SR(JJ),PTAU_SR(JJ))

    PLW_NR_TO_WA(JJ) = ZLW(PESNOW_R(JJ),PEMIS_W(JJ),  ZF_W_NR(JJ),  PTS_SR(JJ),PTS_W_A(JJ),PTAU_WR(JJ))    
    PLW_NR_TO_WB(JJ) = ZLW(PESNOW_R(JJ),PEMIS_W(JJ),  ZF_W_NR(JJ),  PTS_SR(JJ),PTS_W_B(JJ),PTAU_WR(JJ))
    PLW_NR_TO_WIN(JJ)= ZLW(PESNOW_R(JJ),PEMIS_WIN(JJ),ZF_WIN_NR(JJ),PTS_SR(JJ),PTS_WIN(JJ),PTAU_WR(JJ))
    PLW_NR_TO_S(JJ)  = ZLW(PESNOW_R(JJ),1.,           ZF_S_NR(JJ),  PTS_SR(JJ),ZT_S(JJ),   PTAU_SR(JJ))
!
    IF (PFRAC_HVEG(JJ) .GT. 0.) THEN
      PLW_HV_TO_NR(JJ) = ZLW(PEMIS_HV(JJ), PESNOW_R(JJ),ZF_R_HV(JJ), PTS_HV(JJ), PTS_SR(JJ),1.)
      PLW_NR_TO_HV(JJ) = ZLW(PESNOW_R(JJ),PEMIS_HV(JJ), ZF_HV_R(JJ),  PTS_SR(JJ),PTS_HV(JJ), 1.)
    ELSE
      PLW_HV_TO_NR(JJ) = 0.
      PLW_NR_TO_HV(JJ) = 0.
    ENDIF
!
  ENDIF
!
ENDDO
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('URBAN_LW_COEF',1,ZHOOK_HANDLE)
!
END SUBROUTINE URBAN_LW_COEF

