!   #########
    SUBROUTINE TEB_HYDRO(TVG, TM, HM,                               &
                         HBEM, PTSTEP, PPS, PRR,                    &
                         PLE_ROAD, PDF_ROAD, PDELT_ROAD, PWS_ROAD,  &
                         PRUNOFF_SEW, PDRAIN_BLD, PDRAIN_ROAD,      &
                         PSOILHCAPZ_ROAD, PSOILCONDZ_ROAD,          &
                         PSOILHCAPZ_BLD, PSOILCONDZ_BLD             )
!   ##########################################################################
!
!!****  *TEB_HYDRO*  
!!
!!    PURPOSE
!!    -------
!
!     
!!**  METHOD
!     ------
!
!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!      
!!    REFERENCE
!!    ---------
!!
!!      
!!    AUTHOR
!!    ------
!!
!!	A. Lemonsu          * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!!    Original    02/2013
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
USE MODD_SURFEX_n,  ONLY : TEB_MODEL_t, TEB_HYDRO_MODEL_t
!
USE MODI_BLDSOIL_LAYER_E_BUDGET
USE MODI_URBAN_HYDRO_ROAD
USE MODI_URBAN_HYDRO_SOIL
USE MODI_SOILDIF
USE MODI_SEWER
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    Declarations of arguments
!
TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
TYPE(TEB_MODEL_t),       INTENT(INOUT) :: TM
TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
CHARACTER(LEN=3)    ,    INTENT(IN)    :: HBEM              ! Building Energy model 'DEF' or 'BEM'
REAL                ,    INTENT(IN)    :: PTSTEP            ! Time step
REAL, DIMENSION(:)  ,    INTENT(IN)    :: PPS               ! Surface pressure
REAL, DIMENSION(:)  ,    INTENT(IN)    :: PRR               ! Rain rate
REAL, DIMENSION(:)  ,    INTENT(IN)    :: PLE_ROAD          ! Evaporation at road surface
REAL, DIMENSION(:)  ,    INTENT(IN)    :: PDF_ROAD          ! Road fraction without snow
REAL, DIMENSION(:)  ,    INTENT(IN)    :: PDELT_ROAD        ! Wet fraction of road
REAL, DIMENSION(:)  ,    INTENT(INOUT) :: PWS_ROAD          ! Water content of road surface reservoir
REAL, DIMENSION(:)  ,    INTENT(OUT)   :: PRUNOFF_SEW       ! Sewer runoff from groundwater
REAL, DIMENSION(:),      INTENT(OUT)   :: PDRAIN_BLD        ! Drainage at the model base under buildings (kg/m2/s)
REAL, DIMENSION(:),      INTENT(OUT)   :: PDRAIN_ROAD       ! Drainage at the model base under roads (kg/m2/s)
REAL, DIMENSION(:,:),    INTENT(OUT)   :: PSOILHCAPZ_ROAD   ! Soil heat capacity for roads acounting for hydro
REAL, DIMENSION(:,:),    INTENT(OUT)   :: PSOILCONDZ_ROAD   ! Soil thermal cond for roads acounting for hydro
REAL, DIMENSION(:,:),    INTENT(OUT)   :: PSOILHCAPZ_BLD    ! Soil heat capacity for soil under buildings acounting for hydro
REAL, DIMENSION(:,:),    INTENT(OUT)   :: PSOILCONDZ_BLD    ! Soil thermal cond for soil under buildings acounting for hydro
!
!*      0.2    Declarations of local variables
!
INTEGER                                                             :: JLAYER             ! Loop counter
INTEGER, DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: JWG_LAYER          ! 
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZRUNOFFSOIL_ROAD
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZRUNOFFSOIL_BLD
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZDRAIN_ROAD
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZDRAIN_BLD
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZWSOIL             ! water quantity that infiltrates through the roads (kg/m2)
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZVEG               ! 
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZCV,ZCG,ZCT        ! 
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZFFG,ZFFV          ! 
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZFROZEN1           ! 
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZRUNOFF_INF        ! 
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1),SIZE(TM%T%CUR%XD_BLD,2)) :: ZDZ_ROAD           ! Soil layer thicknesses [m] under roads
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1),SIZE(TM%T%CUR%XD_BLD,2)) :: ZDZ_BLD            ! Soil layer thicknesses [m] under buildings
!REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1),SIZE(TM%T%CUR%XD_BLD,2)) :: ZDG_ROAD           ! Soil depth from surface [m] under roads
!
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZFWTD              ! grid-cell fraction of water table to rise
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZWTD               ! water table depth
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZWR                ! canopy intercepted water
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZPIFLOOD           !
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1),SIZE(TM%T%CUR%XD_BLD,2)) :: ZTOPQS             ! Topmodel subsurface flow by layer (m/s)
REAL   , DIMENSION(SIZE(TM%T%CUR%XD_BLD,1))                         :: ZQSB               ! Lateral subsurface flow [kg/m²/s]
!
REAL   , DIMENSION(SIZE(TM%T%CUR%XT_BLD,1),SIZE(TM%T%CUR%XT_BLD,2)) :: ZT_BLD
!
INTEGER :: JCOMP
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*      1.     Initializations
!              ---------------
!
IF (LHOOK) CALL DR_HOOK('TEB_HYDRO',0,ZHOOK_HANDLE)
!
!*      1.a    New soil properties according to hydrological state
!
! Default values
ZVEG(:) = 0.
ZCV (:) = 2.E-5
ZFFG(:) = 0.
ZFFV(:) = 0.
!
JWG_LAYER(:) = SIZE(TM%T%CUR%XD_BLD,2)
!
!
ZDZ_BLD(:,1) = TM%T%CUR%XD_BLD(:,1)
DO JLAYER=2,SIZE(TM%T%CUR%XD_BLD,2)
 ZDZ_BLD(:,JLAYER) = TM%T%CUR%XD_BLD(:,JLAYER)-TM%T%CUR%XD_BLD(:,JLAYER-1)
ENDDO
!
ZDZ_ROAD(:,1) = TM%T%CUR%XD_ROAD(:,1)
DO JLAYER=2,SIZE(TM%T%CUR%XD_ROAD,2)
 ZDZ_ROAD(:,JLAYER) = TM%T%CUR%XD_ROAD(:,JLAYER)-TM%T%CUR%XD_ROAD(:,JLAYER-1)
ENDDO
!
! ?????????????????
!ZDG_ROAD(:,:) = TM%T%CUR%XD_ROAD(:,:)
!ZDG_ROAD(:,1) = TM%T%CUR%XD_ROAD(:,1)
!DO JLAYER=2,SIZE(TM%T%CUR%XD_ROAD,2)
! ZDG_ROAD(:,JLAYER) = ZDG_ROAD(:,JLAYER-1) + TM%T%CUR%XD_ROAD(:,JLAYER)
!ENDDO
!
! New properties for soil under buildings
!
! Robert: The average over the compartments is calculated
! However, this is only a provisional solution.
! The distinction between the compartments should
! only be made for the floor and not the soil below
! the buildings
! The provisional solution violated energy conservation.
!
ZT_BLD(:,:) = 0.0
DO JCOMP=1,SIZE(TM%T%CUR%XT_BLD,3)
   ZT_BLD(:,:)=ZT_BLD(:,:)+TM%T%CUR%XT_BLD(:,:,JCOMP)
ENDDO
ZT_BLD(:,:)=ZT_BLD(:,:)/REAL(SIZE(TM%T%CUR%XT_BLD,3))
!
CALL SOILDIF (TVG%CSCOND, .FALSE.,                                                   &
              ZVEG, ZCV, ZFFG, ZFFV,                                                 &
              ZCG, ZCT, ZFROZEN1,                                                    &
              TM%T%CUR%XD_BLD, ZDZ_BLD,                                              &
!              TM%T%CUR%XT_BLD, HM%TH%CUR%XWG_BLD, HM%TH%CUR%XWGI_BLD, JWG_LAYER,     &
              ZT_BLD, HM%TH%CUR%XWG_BLD, HM%TH%CUR%XWGI_BLD, JWG_LAYER,     &
              TM%T%CUR%XHCAPSOIL_BLD, TM%T%CUR%XCONDDRY_BLD, TM%T%CUR%XCONDSLD_BLD,  &
              TM%T%CUR%XBCOEF_BLD, TM%T%CUR%XWSAT_BLD, TM%T%CUR%XMPOTSAT_BLD,        &
              PSOILCONDZ_BLD, PSOILHCAPZ_BLD,                                        &
              ZFWTD, ZWTD, ZWR                                                       )
!
! New properties for soil under roads
!
CALL SOILDIF (TVG%CSCOND, .FALSE.,                                                    &
              ZVEG, ZCV, ZFFG, ZFFV,                                                  &
              ZCG, ZCT, ZFROZEN1,                                                     &
              !ZDG_ROAD,  ZDZ_ROAD,                                                    &
              TM%T%CUR%XD_ROAD,  ZDZ_ROAD,                                            &
              TM%T%CUR%XT_ROAD, HM%TH%CUR%XWG_ROAD, HM%TH%CUR%XWGI_ROAD, JWG_LAYER,   &
              TM%T%CUR%XHCAPSOIL_ROAD, TM%T%CUR%XCONDDRY_ROAD, TM%T%CUR%XCONDSLD_ROAD,&
              TM%T%CUR%XBCOEF_ROAD, TM%T%CUR%XWSAT_ROAD, TM%T%CUR%XMPOTSAT_ROAD,      &
              PSOILCONDZ_ROAD, PSOILHCAPZ_ROAD,                                       &
              ZFWTD, ZWTD, ZWR                                                        )
!
!-------------------------------------------------------------------------------
!
!*      2.     Hydrology for buildings subsoil
!              -------------------------------
!
! No water infiltration for buildings
ZWSOIL(:) = 0.
!
!CALL URBAN_HYDRO_SOIL(TVG%CKSAT, TVG%CHORT, TVG%CRUNOFF,                                 &
!                      PTSTEP, PPS, ZWSOIL, HM%TH%CUR%XTG_BLD, TM%T%CUR%XD_BLD,           &
!                      TM%T%CUR%XWSAT_BLD, TM%T%CUR%XWFC_BLD, TM%T%CUR%XWWILT_BLD,        &
!                      TM%T%CUR%XCONDSAT_BLD, TM%T%CUR%XMPOTSAT_BLD, TM%T%CUR%XBCOEF_BLD, &
!                      HM%TH%CUR%XWG_BLD, HM%TH%CUR%XWGI_BLD,                             &
!                      ZRUNOFFSOIL_BLD,  ZDRAIN_BLD,                                      &
!                      ZFWTD, ZWTD, ZTOPQS, ZQSB                                          )
CALL URBAN_HYDRO_SOIL(TVG%CKSAT, TVG%CHORT, TVG%CRUNOFF,                                 &
!                      PTSTEP, PPS, ZWSOIL, TM%T%CUR%XT_BLD, TM%T%CUR%XD_BLD,             &
                      PTSTEP, PPS, ZWSOIL, ZT_BLD, TM%T%CUR%XD_BLD,             &
                      TM%T%CUR%XWSAT_BLD, TM%T%CUR%XWFC_BLD, TM%T%CUR%XWWILT_BLD,        &
                      TM%T%CUR%XCONDSAT_BLD, TM%T%CUR%XMPOTSAT_BLD, TM%T%CUR%XBCOEF_BLD, &
                      HM%TH%CUR%XWG_BLD, HM%TH%CUR%XWGI_BLD,                             &
                      ZRUNOFFSOIL_BLD,  ZDRAIN_BLD,                                      &
                      ZFWTD, ZWTD, ZTOPQS, ZQSB                                          )
!
PDRAIN_BLD(:) = ZDRAIN_BLD(:)
!
!-------------------------------------------------------------------------------
!
!*      3.     Hydrology for roads subsoil
!              ---------------------------
!
!*      3.a    Surface hydrology including water infiltration
!
CALL URBAN_HYDRO_ROAD(HM%THP%XWS_ROAD_MAX, HM%THP%XINFIL_ROAD, &
                      PWS_ROAD, PRR, PTSTEP, PLE_ROAD,         & 
                      ZWSOIL                                   )
!
!*      3.b    Subsoil hydrology based on ISDA-DF
!
!CALL URBAN_HYDRO_SOIL(TVG%CKSAT, TVG%CHORT, TVG%CRUNOFF,                                   &
!                      PTSTEP, PPS, ZWSOIL/PTSTEP,                                          &
!                      HM%TH%CUR%XTG_ROAD, TM%T%CUR%XD_ROAD,                                &
!                      TM%T%CUR%XWSAT_ROAD, TM%T%CUR%XWFC_ROAD, TM%T%CUR%XWWILT_ROAD,       &
!                      TM%T%CUR%XCONDSAT_ROAD, TM%T%CUR%XMPOTSAT_ROAD, TM%T%CUR%XBCOEF_ROAD,&
!                      HM%TH%CUR%XWG_ROAD, HM%TH%CUR%XWGI_ROAD,                             &
!                      ZRUNOFFSOIL_ROAD, ZDRAIN_ROAD,                                       &                    
!                      ZFWTD, ZWTD, ZTOPQS, ZQSB                                            )
CALL URBAN_HYDRO_SOIL(TVG%CKSAT, TVG%CHORT, TVG%CRUNOFF,                                   &
                      PTSTEP, PPS, ZWSOIL/PTSTEP,                                          &
                      TM%T%CUR%XT_ROAD, TM%T%CUR%XD_ROAD,                                  &
                      TM%T%CUR%XWSAT_ROAD, TM%T%CUR%XWFC_ROAD, TM%T%CUR%XWWILT_ROAD,       &
                      TM%T%CUR%XCONDSAT_ROAD, TM%T%CUR%XMPOTSAT_ROAD, TM%T%CUR%XBCOEF_ROAD,&
                      HM%TH%CUR%XWG_ROAD, HM%TH%CUR%XWGI_ROAD,                             &
                      ZRUNOFFSOIL_ROAD, ZDRAIN_ROAD,                                       &                    
                      ZFWTD, ZWTD, ZTOPQS, ZQSB                                            )
!
PDRAIN_ROAD(:) = ZDRAIN_ROAD(:)
!
!*      3.c    Infiltration through sewer
!
CALL SEWER(PTSTEP,                                                           &
           HM%TH%CUR%XWG_ROAD, TM%T%CUR%XD_ROAD,                             &
           TM%T%CUR%XWSAT_ROAD, TM%T%CUR%XWWILT_ROAD, TM%T%CUR%XCONDSAT_ROAD,&
           HM%THP%XDENSITY_SEW, HM%THP%NLAYER_SEWER, HM%THP%XIP_SEWER,       &
           PRUNOFF_SEW                                                       )
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('TEB_HYDRO',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE TEB_HYDRO
