!   ##########################################################################
    SUBROUTINE TEB  (HPROGRAM, HZ0H, HIMPLICIT_WIND, HWALL_OPT, HBEM, TPTIME, PTSUN,   &
                     PT_CANYON, PQ_CANYON, PU_CANYON,                                  &
                     PT_LOWCAN, PQ_LOWCAN, PU_LOWCAN, PZ_LOWCAN, PTI_BLD,              &
                     PT_ROOF, PT_ROAD, PT_WALL_A, PT_WALL_B,                           &
                     PT_BLD, PT_ALLBLD,                                                &
                     PWS_ROOF, PWS_ROAD,                                               &
                     HSNOW_ROOF, PWSNOW_ROOF, PTSNOW_ROOF, PRSNOW_ROOF,                &
                     PASNOW_ROOF, PTSSNOW_ROOF, PESNOW_ROOF,                           &
                     HSNOW_ROAD, PWSNOW_ROAD, PTSNOW_ROAD, PRSNOW_ROAD,                &
                     PASNOW_ROAD, PTSSNOW_ROAD, PESNOW_ROAD,                           &
                     PPEW_A_COEF, PPEW_B_COEF,                                         &
                     PPEW_A_COEF_LOWCAN, PPEW_B_COEF_LOWCAN, PPS, PPSOLD, PPA,         &
                     PEXNS_ROOF, PEXNS_SURF, PEXNA, PTA, PQA, PRHOA, PLW_RAD,          &
                     PRR, PSR, PZREF, PUREF,                                           &
                     PVMOD, PH_TRAFFIC, PLE_TRAFFIC, PH_INDUSTRY, PLE_INDUSTRY,        &
                     PTSTEP, PZ0_TOWN, PBLD, PGARDEN, PROAD, PFRAC_GR,                 &
                     PBLD_HEIGHT, PWALL_O_HOR, PCAN_HW_RATIO, PWALL_O_GRND,            &
                     PCONNEX, OURBHYDRO, PWS_ROOF_MAX, PWS_ROAD_MAX,                   &
                     PDF_ROOF, PDN_ROOF, PDF_ROAD,                                     &
                     PDN_ROAD, PQSAT_ROOF, PQSAT_ROAD, PDELT_ROOF, PDELT_ROAD,         &
                     PEMIS_ROOF, PHC_ROOF, PTC_ROOF, PD_ROOF,                          &
                     PEMIS_ROAD, PHC_ROAD, PTC_ROAD, PD_ROAD,                          &
                     PHC_BLD, PTC_BLD, PD_BLD,                                         &
                     PHC_ALLBLD, PTC_ALLBLD, PD_ALLBLD,                                &
                     PEMIS_WALL,                                                       &
                     PTS_GARDEN, PTS_HVEG,                                             &
                     PHC_WALL, PTC_WALL, PD_WALL, PRN_ROOF, PH_ROOF, PLE_ROOF,         &
                     PLEW_ROOF, PGFLUX_ROOF, PRUNOFF_ROOF,                             &
                     PRN_GREENROOF, PH_GREENROOF, PLE_GREENROOF,                       &
                     PGFLUX_GREENROOF, PUW_GREENROOF,                                  &
                     PRUNOFF_GREENROOF, PDRAIN_GREENROOF,                              &
                     PRN_STRLROOF, PH_STRLROOF, PLE_STRLROOF, PGFLUX_STRLROOF,         &
                     PRUNOFF_STRLROOF, PNOC_ROOF, PNOC_ROAD,                           &
                     PRN_ROAD, PH_ROAD,                                                &
                     PLE_ROAD, PLEW_ROAD, PGFLUX_ROAD, PRUNOFF_ROAD,                   &
                     PRN_WALL_A, PH_WALL_A, PLE_WALL_A, PGFLUX_WALL_A,                 &
                     PRN_WALL_B, PH_WALL_B, PLE_WALL_B, PGFLUX_WALL_B,                 &
                     PRN_BLT, PH_BLT, PLE_BLT, PGFLUX_BLT,                             &
                     PQF_WALL_A, PQF_WALL_B, PQF_ROOF, PQF_ROAD, PQF_BLT,              &
                     PRNSNOW_ROOF, PHSNOW_ROOF, PLESNOW_ROOF, PGSNOW_ROOF,             &
                     PMELT_ROOF,                                                       &
                     PRNSNOW_ROAD, PHSNOW_ROAD, PLESNOW_ROAD, PGSNOW_ROAD,             &
                     PMELT_ROAD,                                                       &
                     PG_GREENROOF_ROOF,                                                &
                     PUW_ROAD, PUW_ROOF, PDUWDU_ROAD, PDUWDU_ROOF,                     &
                     PUSTAR_TOWN, PCD, PCDN, PCH_TOWN, PRI_TOWN,                       &
                     PRESA_TOWN, PDQS_TOWN, PQF_TOWN, PQF_BLD, PFLX_BLD,               &
                     PAC_ROOF, PAC_ROAD, PAC_WALL, PAC_TOP, PAC_GARDEN,                &
                     PAC_ROOF_WAT, PAC_ROAD_WAT, PABS_SW_ROOF, PABS_LW_ROOF,           &
                     PABS_SW_SNOW_ROOF, PABS_LW_SNOW_ROOF, PABS_SW_ROAD,               &
                     PABS_LW_ROAD, PABS_SW_SNOW_ROAD, PABS_LW_SNOW_ROAD,               &
                     PABS_SW_WALL_A,PABS_LW_WALL_A,                                    &
                     PABS_SW_WALL_B,PABS_LW_WALL_B,                                    &
                     PLW_WA_TO_WB,                                                     &
                     PLW_WA_TO_R, PLW_WB_TO_R,                                         &
                     PLW_WA_TO_NR, PLW_WB_TO_NR,                                       &
                     PLW_R_TO_WA, PLW_R_TO_WB,                                         &
                     PLW_G_TO_WA, PLW_G_TO_WB,                                         &
                     PLW_S_TO_WA, PLW_S_TO_WB, PLW_S_TO_R,                             &
                     PLW_S_TO_NR, PLW_NR_TO_WA, PLW_NR_TO_WB,                          &
                     PLW_NR_TO_WIN, PLW_WA_TO_WIN, PLW_WB_TO_WIN, PLW_G_TO_WIN,        &
                     PLW_R_TO_WIN, PLW_S_TO_WIN, PLW_WIN_TO_WA, PLW_WIN_TO_WB,         &
                     PLW_WIN_TO_R, PLW_WIN_TO_NR,                                      &
                     PLW_HV_TO_WA, PLW_HV_TO_WB, PLW_HV_TO_R, PLW_HV_TO_NR,            &
                     PLW_HV_TO_WIN, PAC_AGG_GARDEN, PHU_AGG_GARDEN, PQSAT_GARDEN,      &
                     PFRACOMP, HNATVENT, PVENT_BEHAV_ANYWAY, PVENT_BEHAV_ADAPTI,       &
                     HCOOL_COIL, PF_WATER_COND, HHEAT_COIL, OAUTOSIZE,                 &
                     KDAY, PAUX_MAX, PT_FLOOR, PT_MASS, PH_BLD_COOL,                   &
                     PLE_BLD_COOL, PH_WASTE_CANY, PLE_WASTE_CANY, PCST_H_WASTE_CANY,   &
                     PCST_LE_WASTE_CANY, PCOE_H_WASTE_CANY, PCOE_LE_WASTE_CANY,        &
                     PMUL_H_WASTE_CANY, PMUL_LE_WASTE_CANY, PH_WASTE_ROOF,             &
                     PLE_WASTE_ROOF, PF_WASTE_CAN, PHVAC_COOL, PCOMP_HVAC_COOL, PHVAC_HEAT, PCOMP_HVAC_HEAT, &
                     PQIN, PQIN_FRAD, PQIN_FLAT, PGR, PN50,                            &
                     PTCOOL_TARGET, PTHEAT_TARGET, PHR_TARGET, PT_WIN2,                &
                     PQI_BLD, PCAP_SYS_HEAT, PCAP_SYS_RAT, PT_ADP,                     &
                     PM_SYS_RAT, PCOP_RAT, PCAP_SYS, PM_SYS, PCOP,  PQ_SYS,            &
                     PT_SYS, PTR_SW_WIN, PHC_FLOOR, PTC_FLOOR,                         &
                     PD_FLOOR, PHC_MASS, PTC_MASS, PD_MASS,                            &
                     PT_WIN1, PABS_SW_WIN, PABS_LW_WIN, PUGG_WIN, PEMIT_LW_FAC,        &
                     PEMIT_LW_ROAD, PT_RAD_IND, PTIME, PE_SHADING,                     &
                     PN_FLOOR, PWALL_O_BLD, PGLAZ_O_BLD, PMASS_O_BLD,                  &
                     PF_FLOOR_MASS, PF_FLOOR_WALL,                                     &
                     PF_FLOOR_WIN, PF_FLOOR_ROOF, PF_WALL_FLOOR, PF_WALL_MASS,         &
                     PF_WALL_WIN, PF_WIN_FLOOR, PF_WIN_MASS, PF_WIN_WALL,              &
                     PF_MASS_FLOOR, PF_MASS_WALL, PF_MASS_WIN, OCANOPY,                &
                     HCH_BEM, PROUGH_ROOF, PROUGH_WALL, PF_WIN_WIN,                    &
                     OPAR_RD_IRRIG, PRD_START_MONTH, PRD_END_MONTH,                    &
                     PRD_START_HOUR, PRD_END_HOUR, PRD_24H_IRRIG, PIRRIG_ROAD,         &
                     PTDESV,PISMECH,PMECHRATE, PSHGC_SH,PFOPEN, PINFCALC,              &
                     PCONV_LAT_SEN_ROAD,PCONV_LAT_SEN_ROOF,                            &
                     PHEAT_RR_ROAD,                                            &
                     PHEAT_RR_ROOF,PSEN_SNOW_DIF_ROAD,PSEN_SNOW_DIF_ROOF,      &
                     PSNOW_D_ROOF,PSNOW_HC_ROOF,PSNOW_D_ROAD,PSNOW_HC_ROAD,    &
                     PDQS_SNOW_ROOF,PDQS_SNOW_ROAD,PSEN_MELT_ROAD,             &
                     PSEN_MELT_ROOF,PDIFF_SNOW_WAT_ROAD,PDIFF_SNOW_WAT_ROOF,   &
                     PRHOI,PLW_WALA_TO_ROAD,                                   &
                     PLW_WALB_TO_ROAD,PLW_WIND_TO_ROAD,PLW_ROAD_TO_WIND,       &
                     PLW_WALL_TO_WIND,PLW_SNOW_TO_WIND,PLW_GARD_TO_WIND,       &
                     PLW_ROAD_TO_WALA,PLW_GARD_TO_WALA,PLW_SNOW_TO_WALA,       &
                     PLW_WALB_TO_WALA,PLW_WIND_TO_WALA,PLW_ROAD_TO_WALB,       &
                     PLW_GARD_TO_WALB,PLW_SNOW_TO_WALB,PLW_WALA_TO_WALB,       &
                     PLW_WIND_TO_WALB,PLW_WALA_TO_SNOW,PLW_WALB_TO_SNOW,       &
                     PLW_WIND_TO_SNOW,PU10M,PDIAGVENT,PDIAGVEFL, PDIAG_WATER_COND,     &
                     PAGG_TR_SW_WIN, PFLUXFLOOR, PFLX_BLD_ROOF, PFLX_BLD_WALL_A,       &
                     PFLX_BLD_WALL_B,                                                  &
                     PFRAC_HEAT_ELEC,PFRAC_HEAT_GAS,                                   &
                     PFRAC_HEAT_FUEL,PFRAC_HEAT_OTHER,                                 &
                     PCF_CO2_ELEC,PCF_CO2_GAS,                                         &
                     PCF_CO2_FUEL,PCF_CO2_OTHER,                                       &
                     PEFF_HEAT_ELEC,PEFF_HEAT_GAS,PEFF_HEAT_FUEL,PEFF_HEAT_OTHER,      &
                     PLHV_HHV_ELEC,PLHV_HHV_GAS,PLHV_HHV_FUEL,PLHV_HHV_OTHER,          &
                     PSFCO2,                                                           &
                     PSNOW_HEAT_ROAD, PSNOW_HEAT_ROOF, PF_HW_GAS,  PHOTWAT,            &
                     PHOTWAT_ELEC, PHOTWAT_GAS, HTEST                                  )
!   ##########################################################################
!
!!****  *TEB*  
!!
!!    PURPOSE
!!    -------
!
!     Computes the evoultion of prognostic variables and the fluxes
!     over artificial surfaces as towns, taking into account the canyon like
!     geometry of urbanized areas.
!         
!     
!!**  METHOD
!     ------
!
!     The prognostic variables are:
!       - the surface temperature for roofs, roads, and walls
!       - the water reservoir, whose maximum value is 10mm
!
!
!    1 : Warning about snow
!        ******************
!
!     Except for snow mantel evolution, all other computation with snow
!   variables must be performed with these variables at previous time-step,
!   and NOT new time-step. This insure coherence between snow fractions
!   (computed at the begining) and other snow characteristics (albedo, Ts).
!
!
!    2 : computation of input solar radiation on each surface
!        ****************************************************
!
!      Those are now done in subroutine urban_solar_abs.F90
!
!    3 : drag coefficient for momentum 
!        *****************************
!
!
!    4 : aerodynamical resistance for heat transfers
!        *******************************************
!
!
!    5 : equation for evolution of Ts_roof
!        *********************************
!
!
!       Rn = (dir_Rg + sca_Rg) (1-a) + emis * ( Rat - sigma Ts**4 (t+dt) )
!
!       H  = rho Cp CH V ( Ts (t+dt) - Tas )
!
!       LE = rho Lv CH V ( qs (t+dt) - qas )
!
!      where the as subscript denotes atmospheric values at ground level
!      (and not at first half level)
!
!
!    6 : equations for evolution of Ts_road and Ts_wall simultaneously
!        *************************************************************
!
!
!
!   Rn_w = abs_Rg_w 
!  - sigma * emis_w                                                   * Ts_w**4 (t+dt)
!  +         emis_w                       *      SVF_w                * Rat
!  + sigma * emis_w * emis_r              *      SVF_w                * Ts_r**4 (t+dt)
!  + sigma * emis_w * emis_w              * (1-2*SVF_w)               * Ts_w**4 (t+dt)
!  + sigma * emis_w * emis_w * (1-emis_r) *      SVF_w  * (1-  SVF_r) * Ts_w**4 (t+dt)
!  + sigma * emis_w * emis_w * (1-emis_w) * (1-2*SVF_w) * (1-2*SVF_w) * Ts_w**4 (t+dt)
!  + sigma * emis_w * emis_r * (1-emis_w) *      SVF_w  * (1-2*SVF_w) * Ts_r**4 (t+dt)
!
!   Rn_r = abs_Rg_r
!  - sigma * emis_r                                                   * Ts_r**4 (t+dt)
!  +         emis_r                       *    SVF_r                  * Rat
!  + sigma * emis_r * emis_w              * (1-SVF_r)                 * Ts_w**4 (t+dt)
!  + sigma * emis_r * emis_w * (1-emis_w) * (1-SVF_r)   * (1-2*SVF_w) * Ts_w**4 (t+dt)
!  + sigma * emis_r * emis_r * (1-emis_w) * (1-SVF_r)   *      SVF_w  * Ts_r**4 (t+dt)
!
!  H_w  = rho Cp CH V ( Ts_w (t+dt) - Ta_canyon )
!
!  LE_w = rho Lv CH V ( qs_w (t+dt) - qa_canyon )
!
!  H_r  = rho Cp CH V ( Ts_r (t+dt) - Ta_canyon )
!
!  LE_r = rho Lv CH V ( qs_r (t+dt) - qa_canyon )
!
! with again
!                AC_can * Swall/Sroad * Twall + AC_can * Troad + AC_top * Ta + H_traffic/Cp/rho/Sroad
!   Ta_canyon = -------------------------------------------------------------------------------------
!                AC_can * Swall/Sroad         + AC_can         + AC_top
!
!
!                 AC_can * delt_road * Hu_road * qsat(Troad) + AC_top * qa + LE_traffic/Lv/rho/Sroad
!   qa_canyon = ------------------------------------------------------------------------------------
!                 AC_can * delt_road                        + AC_top
!
!
!
!
!    7 : computation of fluxes for each surface type
!        *******************************************
!
!
!    8 : averaging of the fluxes
!        ***********************
!
!   This is done on the total exchange surface (roof + wall + road),
!  which is bigger than the horizontal surface (roof+road), leading
!  to bigger fluxes.
!
!   The fluxes due to industrial activity are directly added into the 
!  atmosphere
!
!
!    9 : road reservoir evolution
!        ************************
!
!   The roof reservoir runoff goes directly into the road reservoir.
!
!   Runoff occurs for road reservoir (too much water), as well as drainage
!   (evacuation system, typical time scale: 1 day)
!
!    20 : Compute CO2 fluxes link to buildings
!         ************************************
!         Fluxes from heating, cooling, QIN, and hot water
!
!
!------------------------
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    MODD_CST
!!
!!      
!!    REFERENCE
!!    ---------
!!
!!      
!!    AUTHOR
!!    ------
!!
!!      V. Masson           * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    23/01/98 
!!     21 / 10 / 2003   P. Tulet    output aerodynamical resistance
!!     01 / 07 / 2005   P.Le Moigne Exner functions as arguments to urban_fluxes
!!     17 / 10 / 2005   (G. Pigeon) computation of anthropogenic heat from domestic heating
!!          01 / 2012   V. Masson   Separates the 2 walls 
!!     25 / 09 / 2012   B. Decharme new wind implicitation
!!          07 / 2013   V. Masson   Adds road watering
!!          01 / 2016   E.Redon/A.Lemonsu   Add high vegetation
!!          01 / 2016   K.Chancibault/A.Lemonsu   Add urban hydrology
!!          12 / 2016   M. Goret    Add CO2 fluxes
!!          03 / 2017   M. Goret Add Demuzere et al 2017 Surface Interception Distribution approach
!!          04 / 2017   M. Goret Change EFF_HEAT, from dummya arg. to local variable
!!          08 / 2017   M. Goret add anthropogenic flux diagnostics
!!          09 / 2017   M. Goret add diagnostic of heat storage link to snow
!!          09 / 2017   M. Goret add LE waste due to heating
!!          09 / 2017   M. Goret add hot water 
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
USE MODD_TYPE_DATE_SURF,ONLY: DATE_TIME
USE MODD_CSTS,          ONLY: XTT, XSTEFAN, XCPD, XLVTT, XLSTT, XLMTT, XSURF_EPSILON
USE MODD_SURF_PAR,      ONLY: XUNDEF
USE MODD_SNOW_PAR,      ONLY: XEMISSN, XANSMAX_ROOF, XANSMAX_ROAD,XWCRN_ROOF,XWCRN_ROAD
!
USE MODE_THERMOS
USE MODE_SURF_SNOW_FRAC
!
USE MODI_SNOW_COVER_1LAYER
USE MODI_URBAN_DRAG
USE MODI_URBAN_SNOW_EVOL
USE MODI_ROOF_LAYER_E_BUDGET
USE MODI_ROAD_LAYER_E_BUDGET
USE MODI_FACADE_E_BUDGET
USE MODI_URBAN_FLUXES
USE MODI_URBAN_HYDRO
USE MODI_BLD_E_BUDGET
USE MODI_WIND_THRESHOLD
USE MODI_BEM
USE MODI_TEB_IRRIG
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    Declarations of arguments
!
!
CHARACTER(LEN=2), INTENT(IN) :: HTEST         ! must be equal to 'OK'  
CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM      ! program calling surf. schemes
CHARACTER(LEN=6), INTENT(IN) :: HZ0H          ! TEB option for z0h roof & road
!                                             ! 'MASC95' : Mascart et al 1995
!                                             ! 'BRUT82' : Brustaert     1982
!                                             ! 'KAND07' : Kanda         2007
 CHARACTER(LEN=*),     INTENT(IN)  :: HIMPLICIT_WIND   ! wind implicitation option
!                                                     ! 'OLD' = direct
!                                                     ! 'NEW' = Taylor serie, order 1
 CHARACTER(LEN=4), INTENT(IN)      :: HWALL_OPT     ! TEB option for walls
                                                   ! 'UNIF' : uniform walls
                                                   ! 'TWO ' : two different opposite walls
 CHARACTER(LEN=3), INTENT(IN)      :: HBEM          ! Building Energy model 'DEF' or 'BEM'
TYPE(DATE_TIME)     , INTENT(IN)    :: TPTIME             ! current date and time from teb
REAL, DIMENSION(:),   INTENT(IN)    :: PTSUN              ! solar time   (s from midnight)
REAL, DIMENSION(:), INTENT(INOUT) :: PT_CANYON     ! canyon air temperature
REAL, DIMENSION(:), INTENT(INOUT) :: PQ_CANYON     ! canyon air specific humidity
REAL, DIMENSION(:), INTENT(IN)    :: PU_CANYON     ! canyon hor. wind
REAL, DIMENSION(:), INTENT(IN)    :: PU_LOWCAN     ! wind near the road
REAL, DIMENSION(:), INTENT(IN)    :: PT_LOWCAN     ! temp. near the road
REAL, DIMENSION(:), INTENT(IN)    :: PQ_LOWCAN     ! hum. near the road
REAL, DIMENSION(:), INTENT(IN)    :: PZ_LOWCAN     ! height of atm. var. near the road
REAL, DIMENSION(:,:), INTENT(INOUT) :: PTI_BLD       ! inside building temperature
REAL, DIMENSION(:,:), INTENT(INOUT) :: PT_ROOF     ! roof layers temperatures
REAL, DIMENSION(:,:), INTENT(INOUT) :: PT_ROAD     ! road layers temperatures
REAL, DIMENSION(:,:), INTENT(INOUT) :: PT_WALL_A   ! wall A layers temperatures
REAL, DIMENSION(:,:), INTENT(INOUT) :: PT_WALL_B   ! wall B layers temperatures
REAL, DIMENSION(:,:,:), INTENT(INOUT) :: PT_BLD      ! soil layers temperatures under buildings
REAL, DIMENSION(:,:,:), INTENT(INOUT) :: PT_ALLBLD   ! floor/soil layers temperatures under buildings
REAL, DIMENSION(:), INTENT(INOUT) :: PWS_ROOF      ! roof water reservoir
REAL, DIMENSION(:), INTENT(INOUT) :: PWS_ROAD      ! road water reservoir
 CHARACTER(LEN=*),   INTENT(IN)    :: HSNOW_ROOF    ! snow roof scheme
!                                                  ! 'NONE'
!                                                  ! 'D95 '
!                                                  ! '1-L '
 CHARACTER(LEN=*),   INTENT(IN)    :: HSNOW_ROAD    ! snow road scheme
!                                                  ! 'NONE'
!                                                  ! 'D95 '
!                                                  ! '1-L '
REAL, DIMENSION(:,:), INTENT(INOUT) :: PWSNOW_ROOF ! snow layers reservoir
REAL, DIMENSION(:,:), INTENT(INOUT) :: PTSNOW_ROOF ! snow layers temperature
REAL, DIMENSION(:,:), INTENT(INOUT) :: PRSNOW_ROOF ! snow layers density
REAL, DIMENSION(:),   INTENT(INOUT) :: PASNOW_ROOF ! snow albedo
REAL, DIMENSION(:),   INTENT(INOUT) :: PESNOW_ROOF ! snow emissivity
REAL, DIMENSION(:),   INTENT(INOUT) :: PTSSNOW_ROOF! snow surface temperature
REAL, DIMENSION(:,:), INTENT(INOUT) :: PWSNOW_ROAD ! snow layers reservoir
REAL, DIMENSION(:,:), INTENT(INOUT) :: PTSNOW_ROAD ! snow layers temperature
REAL, DIMENSION(:,:), INTENT(INOUT) :: PRSNOW_ROAD ! snow layers density
REAL, DIMENSION(:),   INTENT(INOUT) :: PASNOW_ROAD ! snow albedo
REAL, DIMENSION(:),   INTENT(INOUT) :: PESNOW_ROAD ! snow emissivity
REAL, DIMENSION(:),   INTENT(INOUT) :: PTSSNOW_ROAD! snow surface temperature
REAL, DIMENSION(:), INTENT(IN)    :: PPEW_A_COEF   ! implicit coefficients
REAL, DIMENSION(:), INTENT(IN)    :: PPEW_B_COEF   ! for wind coupling
REAL, DIMENSION(:), INTENT(IN)    :: PPEW_A_COEF_LOWCAN ! implicit coefficients for wind coupling
REAL, DIMENSION(:), INTENT(IN)    :: PPEW_B_COEF_LOWCAN ! between low canyon wind and road
REAL, DIMENSION(:), INTENT(IN)    :: PPS           ! pressure at the surface
REAL, DIMENSION(:), INTENT(IN)    :: PPSOLD        ! pressure at the surface at previous time step
REAL, DIMENSION(:), INTENT(IN)    :: PPA           ! pressure at the first atmospheric level
REAL, DIMENSION(:), INTENT(IN)    :: PEXNS_ROOF    ! Roof level Exner function
REAL, DIMENSION(:), INTENT(IN)    :: PEXNS_SURF    ! Surface level Exner function
REAL, DIMENSION(:), INTENT(IN)    :: PTA           ! temperature at the lowest level
REAL, DIMENSION(:), INTENT(IN)    :: PQA           ! specific humidity
                                                   ! at the lowest level
REAL, DIMENSION(:), INTENT(IN)    :: PVMOD         ! module of the horizontal wind
REAL, DIMENSION(:), INTENT(IN)    :: PEXNA         ! exner function
                                                   ! at the lowest level
REAL, DIMENSION(:), INTENT(IN)    :: PRHOA         ! air density
                                                   ! at the lowest level
REAL, DIMENSION(:), INTENT(IN)    :: PLW_RAD       ! atmospheric infrared radiation
REAL, DIMENSION(:), INTENT(IN)    :: PRR           ! rain rate
REAL, DIMENSION(:), INTENT(IN)    :: PSR           ! snow rate
REAL, DIMENSION(:), INTENT(IN)    :: PH_TRAFFIC    ! anthropogenic sensible
!                                                  ! heat fluxes due to traffic
REAL, DIMENSION(:), INTENT(IN)    :: PLE_TRAFFIC   ! anthropogenic latent
!                                                  ! heat fluxes due to traffic
REAL, DIMENSION(:), INTENT(IN)    :: PH_INDUSTRY   ! anthropogenic sensible
!                                                  ! heat fluxes due to factories
REAL, DIMENSION(:), INTENT(IN)    :: PLE_INDUSTRY  ! anthropogenic latent
!                                                  ! heat fluxes due to factories
REAL, DIMENSION(:), INTENT(IN)    :: PZREF         ! reference height of the first
                                                   ! atmospheric level (temperature)
REAL, DIMENSION(:), INTENT(IN)    :: PUREF         ! reference height of the first
                                                   ! atmospheric level (wind)
REAL,               INTENT(IN)    :: PTSTEP        ! time step
REAL, DIMENSION(:), INTENT(IN)    :: PZ0_TOWN      ! town roughness length
                                                   ! for momentum
REAL, DIMENSION(:), INTENT(IN)    :: PBLD          ! fraction of buildings
REAL, DIMENSION(:), INTENT(IN)    :: PGARDEN       ! fraction of GARDEN areas
REAL, DIMENSION(:), INTENT(IN)    :: PROAD         ! fraction of roads
REAL, DIMENSION(:), INTENT(IN)    :: PFRAC_GR      ! fraction of green roofs
REAL, DIMENSION(:), INTENT(IN)    :: PBLD_HEIGHT   ! buildings h
REAL, DIMENSION(:), INTENT(IN)    :: PWALL_O_HOR   ! wall surf. / hor. surf.
REAL, DIMENSION(:), INTENT(IN)    :: PCAN_HW_RATIO ! canyon    h/W
REAL, DIMENSION(:), INTENT(IN)    :: PWALL_O_GRND  ! wall surf. / (road + gard.  surf.)
REAL, DIMENSION(:), INTENT(IN)    :: PU10M         ! Wind speed in 10 m above ground
REAL, DIMENSION(:), INTENT(IN)    :: PISMECH       ! Presence of mechanical ventilation (architectural characteristic)
REAL, DIMENSION(:), INTENT(IN)    :: PMECHRATE     ! Air exchange rate due to mechanical ventilation [1/h]
REAL, DIMENSION(:), INTENT(IN)    :: PAC_AGG_GARDEN
REAL, DIMENSION(:), INTENT(IN)    :: PHU_AGG_GARDEN
REAL, DIMENSION(:), INTENT(IN)    :: PQSAT_GARDEN
!
REAL,               INTENT(IN)    :: PCONNEX       ! Impervious surfaces connexion rate to the sewer (-)
LOGICAL,            INTENT(IN)    :: OURBHYDRO
REAL,               INTENT(IN)    :: PWS_ROOF_MAX, PWS_ROAD_MAX
!
REAL, DIMENSION(:), INTENT(INOUT) :: PDF_ROOF      ! snow-free    fraction on roofs
REAL, DIMENSION(:), INTENT(INOUT) :: PDN_ROOF      ! snow-covered fraction on roofs
REAL, DIMENSION(:), INTENT(INOUT) :: PDF_ROAD      ! snow-free    fraction on roads
REAL, DIMENSION(:), INTENT(INOUT) :: PDN_ROAD      ! snow-covered fraction on roads
REAL, DIMENSION(:), INTENT(OUT)   :: PQSAT_ROOF    ! hum at saturation over roof
REAL, DIMENSION(:), INTENT(OUT)   :: PQSAT_ROAD    ! hum at saturation over road
REAL, DIMENSION(:), INTENT(OUT)   :: PDELT_ROOF    ! water fraction on roof
REAL, DIMENSION(:), INTENT(OUT)   :: PDELT_ROAD    ! water fraction on road
REAL, DIMENSION(:), INTENT(OUT)   :: PCONV_LAT_SEN_ROAD
REAL, DIMENSION(:), INTENT(OUT)   :: PCONV_LAT_SEN_ROOF
!
REAL, DIMENSION(:), INTENT(IN)    :: PEMIS_ROOF    ! roof emissivity
REAL, DIMENSION(:,:), INTENT(IN)  :: PHC_ROOF      ! heat capacity for roof layers
REAL, DIMENSION(:,:), INTENT(IN)  :: PTC_ROOF      ! thermal conductivity for roof layers
REAL, DIMENSION(:,:), INTENT(IN)  :: PD_ROOF       ! depth of roof layers
REAL, DIMENSION(:), INTENT(IN)    :: PEMIS_ROAD    ! road emissivity
REAL, DIMENSION(:,:), INTENT(IN)  :: PHC_ROAD      ! heat capacity for road layers
REAL, DIMENSION(:,:), INTENT(IN)  :: PTC_ROAD      ! thermal conductivity for road layers
REAL, DIMENSION(:,:), INTENT(IN)  :: PD_ROAD       ! depth of road layers


REAL, DIMENSION(:,:), INTENT(IN)  :: PHC_BLD       ! heat capacity for soil layers under buildings
REAL, DIMENSION(:,:), INTENT(IN)  :: PTC_BLD       ! thermal conductivity for soil layers under buildings
REAL, DIMENSION(:,:), INTENT(IN)  :: PD_BLD        ! depth of soil layers under buildings
REAL, DIMENSION(:,:), INTENT(IN)  :: PHC_ALLBLD    ! heat capacity for floor/soil layers under buildings
REAL, DIMENSION(:,:), INTENT(IN)  :: PTC_ALLBLD    ! thermal conductivity for floor/soil layers under buildings
REAL, DIMENSION(:,:), INTENT(IN)  :: PD_ALLBLD     ! depth of floor/soil layers under buildings
REAL, DIMENSION(:), INTENT(IN)    :: PEMIS_WALL    ! wall emissivity
REAL, DIMENSION(:,:), INTENT(IN)  :: PHC_WALL      ! heat capacity for wall layers
REAL, DIMENSION(:,:), INTENT(IN)  :: PTC_WALL      ! thermal conductivity for wall layers
REAL, DIMENSION(:,:), INTENT(IN)  :: PD_WALL       ! depth of wall layers
REAL, DIMENSION(:), INTENT(IN)    :: PTS_GARDEN    ! GARDEN area surf temp.
REAL, DIMENSION(:), INTENT(IN)    :: PTS_HVEG      ! high veg surf temp.
! greenroof
REAL, DIMENSION(:), INTENT(IN)    :: PG_GREENROOF_ROOF ! Flux at botton of green roof
!
REAL, DIMENSION(:), INTENT(OUT)   :: PRN_ROOF     ! net radiation over roof
REAL, DIMENSION(:), INTENT(OUT)   :: PH_ROOF      ! sensible heat flux over roof
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_ROOF     ! latent heat flux over roof
REAL, DIMENSION(:), INTENT(OUT)   :: PLEW_ROOF    ! latent heat flux over roof (snow)
REAL, DIMENSION(:), INTENT(OUT)   :: PGFLUX_ROOF  ! flux through the roof
REAL, DIMENSION(:), INTENT(OUT)   :: PRUNOFF_STRLROOF ! runoff over the ground
REAL, DIMENSION(:), INTENT(OUT)   :: PRUNOFF_ROOF ! runoff over roofs
REAL, DIMENSION(:), INTENT(OUT)   :: PRN_ROAD     ! net radiation over road
REAL, DIMENSION(:), INTENT(OUT)   :: PH_ROAD      ! sensible heat flux over road
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_ROAD     ! latent heat flux over road
REAL, DIMENSION(:), INTENT(OUT)   :: PLEW_ROAD    ! latent heat flux over road (snow)
REAL, DIMENSION(:), INTENT(OUT)   :: PGFLUX_ROAD  ! flux through the road
REAL, DIMENSION(:), INTENT(OUT)   :: PRUNOFF_ROAD ! runoff over the ground
REAL, DIMENSION(:), INTENT(OUT)   :: PRN_WALL_A   ! net radiation over wall
REAL, DIMENSION(:), INTENT(OUT)   :: PH_WALL_A    ! sensible heat flux over wall
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_WALL_A   ! latent heat flux over wall
REAL, DIMENSION(:), INTENT(OUT)   :: PGFLUX_WALL_A! flux through the wall
REAL, DIMENSION(:), INTENT(OUT)   :: PRN_WALL_B   ! net radiation over wall
REAL, DIMENSION(:), INTENT(OUT)   :: PH_WALL_B    ! sensible heat flux over wall
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_WALL_B   ! latent heat flux over wall
REAL, DIMENSION(:), INTENT(OUT)   :: PGFLUX_WALL_B! flux through the wall
REAL, DIMENSION(:), INTENT(OUT)   :: PRN_BLT       ! net radiation over built surf 
REAL, DIMENSION(:), INTENT(OUT)   :: PH_BLT        ! sensible heat flux over built surf 
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_BLT       ! latent heat flux over built surf 
REAL, DIMENSION(:), INTENT(OUT)   :: PGFLUX_BLT    ! flux through the built surf 
REAL, DIMENSION(:), INTENT(OUT)   :: PINFCALC      ! Infiltration calculated [vol/h]
REAL, DIMENSION(:), INTENT(OUT)   :: PQF_WALL_A  ! wall anthropogenic flux      (W/m2 façade)
REAL, DIMENSION(:), INTENT(OUT)   :: PQF_WALL_B  ! wall anthropogenic flux      (W/m2 façade)
REAL, DIMENSION(:), INTENT(OUT)   :: PQF_ROOF    ! roof anthropogenic flux      (W/m2 roof)
REAL, DIMENSION(:), INTENT(OUT)   :: PQF_ROAD    ! road anthropogenic flux      (W/m2 roof)
REAL, DIMENSION(:), INTENT(OUT)   :: PQF_BLT     ! anthropogenic flux  over built covers   (W/m2 urb)
!
REAL, DIMENSION(:), INTENT(IN)    :: PRN_GREENROOF     ! net radiation over greenroof
REAL, DIMENSION(:), INTENT(IN)    :: PH_GREENROOF      ! sensible heat flux over greenroof
REAL, DIMENSION(:), INTENT(IN)    :: PLE_GREENROOF     ! latent heat flux over greenroof
REAL, DIMENSION(:), INTENT(IN)    :: PGFLUX_GREENROOF  ! flux through the greenroof
REAL, DIMENSION(:), INTENT(IN)    :: PUW_GREENROOF     ! Momentum flux for greenroofs
REAL, DIMENSION(:), INTENT(IN)    :: PRUNOFF_GREENROOF ! runoff over green roofs
REAL, DIMENSION(:), INTENT(IN)    :: PDRAIN_GREENROOF  ! outlet drainage at base of green roofs
!
REAL, DIMENSION(:), INTENT(OUT)   :: PRN_STRLROOF      ! net radiation over structural roof
REAL, DIMENSION(:), INTENT(OUT)   :: PH_STRLROOF       ! sensible heat flux over structural roof
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_STRLROOF      ! latent heat flux over structural roof
REAL, DIMENSION(:), INTENT(OUT)   :: PGFLUX_STRLROOF   ! flux through the structural roof
!
REAL, DIMENSION(:), INTENT(OUT) :: PNOC_ROAD         ! Surface runoff from impervious road
!                                                    ! not connected to sewer
REAL, DIMENSION(:), INTENT(OUT) :: PNOC_ROOF         ! Surface runoff from impervious roof
!                                                    ! not connected to sewer
!
REAL, DIMENSION(:), INTENT(OUT)   :: PRNSNOW_ROOF ! net radiation over snow
REAL, DIMENSION(:), INTENT(OUT)   :: PHSNOW_ROOF  ! sensible heat flux over snow
REAL, DIMENSION(:), INTENT(OUT)   :: PLESNOW_ROOF ! latent heat flux over snow
REAL, DIMENSION(:), INTENT(OUT)   :: PGSNOW_ROOF  ! flux under the snow
REAL, DIMENSION(:), INTENT(OUT)   :: PMELT_ROOF   ! snow melt
REAL, DIMENSION(:), INTENT(OUT)   :: PRNSNOW_ROAD ! net radiation over snow
REAL, DIMENSION(:), INTENT(OUT)   :: PHSNOW_ROAD  ! sensible heat flux over snow
REAL, DIMENSION(:), INTENT(OUT)   :: PLESNOW_ROAD ! latent heat flux over snow
REAL, DIMENSION(:), INTENT(OUT)   :: PGSNOW_ROAD  ! flux under the snow
REAL, DIMENSION(:), INTENT(OUT)   :: PMELT_ROAD   ! snow melt
REAL, DIMENSION(:), INTENT(OUT)   :: PSNOW_D_ROOF
REAL, DIMENSION(:), INTENT(OUT)   :: PSNOW_HC_ROOF
REAL, DIMENSION(:), INTENT(OUT)   :: PSNOW_D_ROAD
REAL, DIMENSION(:), INTENT(OUT)   :: PSNOW_HC_ROAD
!
REAL, DIMENSION(:), INTENT(OUT)   :: PUW_ROAD     ! Momentum flux for roads
REAL, DIMENSION(:), INTENT(OUT)   :: PUW_ROOF     ! Momentum flux for roofs
REAL, DIMENSION(:), INTENT(OUT)   :: PDUWDU_ROAD  !
REAL, DIMENSION(:), INTENT(OUT)   :: PDUWDU_ROOF  !
REAL, DIMENSION(:), INTENT(OUT)   :: PUSTAR_TOWN  ! friciton velocity over town
REAL, DIMENSION(:), INTENT(OUT)   :: PCD          ! town averaged drag coefficient
REAL, DIMENSION(:), INTENT(OUT)   :: PCDN         ! town averaged neutral drag coefficient
REAL, DIMENSION(:), INTENT(OUT)   :: PCH_TOWN     ! town averaged heat transfer
!                                                 ! coefficient
REAL, DIMENSION(:), INTENT(OUT)   :: PRI_TOWN      ! town averaged Richardson number
REAL, DIMENSION(:), INTENT(OUT)   :: PRESA_TOWN    ! town aerodynamical resistance
REAL, DIMENSION(:), INTENT(OUT)   :: PDQS_TOWN     ! heat storage inside town
REAL, DIMENSION(:), INTENT(OUT)   :: PQF_TOWN      ! total anthropogenic heat
REAL, DIMENSION(:), INTENT(OUT)   :: PQF_BLD       ! anthropogenic heat flux of
                                                   ! domestic heating  
REAL, DIMENSION(:), INTENT(OUT)   :: PFLX_BLD      ! heat flx from inside bld through its structure
REAL, DIMENSION(:), INTENT(OUT)   :: PAC_ROOF      ! roof conductance
REAL, DIMENSION(:), INTENT(INOUT) :: PAC_ROAD      ! road conductance
REAL, DIMENSION(:), INTENT(OUT)   :: PAC_WALL      ! wall conductance
REAL, DIMENSION(:), INTENT(OUT)   :: PAC_TOP       ! top conductance
REAL, DIMENSION(:), INTENT(IN)    :: PAC_GARDEN    ! garden conductance
REAL, DIMENSION(:), INTENT(OUT)   :: PAC_ROOF_WAT  ! roof water conductance
REAL, DIMENSION(:), INTENT(OUT)   :: PAC_ROAD_WAT  ! roof water conductance
REAL, DIMENSION(:,:), INTENT(OUT) :: PRHOI         ! indoor air density
!
REAL, DIMENSION(:), INTENT(IN)    :: PABS_SW_ROOF      ! absorbed solar rad by roof
REAL, DIMENSION(:), INTENT(IN)    :: PABS_SW_SNOW_ROOF ! absorbed solar rad by snow on roof
REAL, DIMENSION(:), INTENT(IN)    :: PABS_SW_ROAD      ! absorbed solar rad by road
REAL, DIMENSION(:), INTENT(IN)    :: PABS_SW_SNOW_ROAD ! absorbed solar rad by snow on road
REAL, DIMENSION(:), INTENT(IN)    :: PABS_SW_WALL_A    ! absorbed solar rad by wall
REAL, DIMENSION(:), INTENT(IN)    :: PABS_SW_WALL_B    ! absorbed solar rad by wall
REAL, DIMENSION(:), INTENT(OUT)   :: PABS_LW_ROOF      ! absorbed IR rad by roof
REAL, DIMENSION(:), INTENT(OUT)   :: PABS_LW_SNOW_ROOF ! absorbed IR rad by snow on roof
REAL, DIMENSION(:), INTENT(OUT)   :: PABS_LW_ROAD      ! absorbed IR rad by road
REAL, DIMENSION(:), INTENT(OUT)   :: PABS_LW_SNOW_ROAD ! absorbed IR rad by snow on road
REAL, DIMENSION(:), INTENT(OUT)   :: PABS_LW_WALL_A    ! absorbed IR rad by wall
REAL, DIMENSION(:), INTENT(OUT)   :: PABS_LW_WALL_B    ! absorbed IR rad by wall
REAL, DIMENSION(:,:), INTENT(OUT) :: PDIAGVENT         ! Diagnostic of ventilation status
REAL, DIMENSION(:,:), INTENT(OUT) :: PDIAGVEFL         ! Diagnostic of ventilation exchange rate [1/h]
REAL, DIMENSION(:), INTENT(OUT)   :: PDIAG_WATER_COND  ! Diagnostic for heat flux evacutated via district cooling systems [W m-2(urb)]
!
REAL, DIMENSION(:), INTENT(IN)    :: PLW_WA_TO_WB      ! LW contrib. wall A (orB) -> wall B (or A)
REAL, DIMENSION(:), INTENT(IN)    :: PLW_WA_TO_R         ! LW contrib. wall       -> road
REAL, DIMENSION(:), INTENT(IN)    :: PLW_WB_TO_R         ! LW contrib. wall       -> road
REAL, DIMENSION(:), INTENT(IN)    :: PLW_WA_TO_NR        ! LW contrib. wall       -> road(snow)
REAL, DIMENSION(:), INTENT(IN)    :: PLW_WB_TO_NR        ! LW contrib. wall       -> road(snow)
REAL, DIMENSION(:), INTENT(IN)    :: PLW_R_TO_WA         ! LW contrib. road       -> wall
REAL, DIMENSION(:), INTENT(IN)    :: PLW_R_TO_WB         ! LW contrib. road       -> wall
REAL, DIMENSION(:), INTENT(IN)    :: PLW_G_TO_WA         ! LW contrib. GARDEN     -> wall
REAL, DIMENSION(:), INTENT(IN)    :: PLW_G_TO_WB         ! LW contrib. GARDEN     -> wall
REAL, DIMENSION(:), INTENT(IN)    :: PLW_NR_TO_WA        ! LW contrib. road(snow) -> wall
REAL, DIMENSION(:), INTENT(IN)    :: PLW_NR_TO_WB        ! LW contrib. road(snow) -> wall
REAL, DIMENSION(:), INTENT(IN)    :: PLW_S_TO_WA         ! LW contrib. sky        -> wall
REAL, DIMENSION(:), INTENT(IN)    :: PLW_S_TO_WB         ! LW contrib. sky        -> wall
REAL, DIMENSION(:), INTENT(IN)    :: PLW_S_TO_R          ! LW contrib. sky        -> road
REAL, DIMENSION(:), INTENT(IN)    :: PLW_S_TO_NR         ! LW contrib. sky        -> road(snow)
REAL, DIMENSION(:), INTENT(IN)    :: PLW_HV_TO_WA        ! LW contrib. HIGH VEG   -> wallA
REAL, DIMENSION(:), INTENT(IN)    :: PLW_HV_TO_WB        ! LW contrib. HIGH VEG   -> wallB
REAL, DIMENSION(:), INTENT(IN)    :: PLW_HV_TO_R         ! LW contrib. HIGH VEG   -> road
REAL, DIMENSION(:), INTENT(IN)    :: PLW_HV_TO_NR        ! LW contrib. HIGH VEG   -> road(snow)
REAL, DIMENSION(:), INTENT(IN)    :: PLW_HV_TO_WIN       ! LW contrib. HIGH VEG   -> WIN
!
! new arguments after BEM
!
CHARACTER(LEN=4), DIMENSION(:,:), INTENT(IN) :: HNATVENT
CHARACTER(LEN=6), INTENT(IN)      :: HCOOL_COIL
REAL, DIMENSION(:,:), INTENT(IN)   :: PFRACOMP
REAL, DIMENSION(:), INTENT(IN)     :: PF_WATER_COND!fraction of evaporation for the condensers
REAL, DIMENSION(:,:), INTENT(IN)     :: PVENT_BEHAV_ANYWAY   ! Fraction of windows opened in any case
REAL, DIMENSION(:,:), INTENT(IN)     :: PVENT_BEHAV_ADAPTI   ! Fraction of windows that could be opened
 CHARACTER(LEN=6), INTENT(IN)      :: HHEAT_COIL
LOGICAL,            INTENT(IN)     :: OAUTOSIZE    ! Flag to activate autosize calculations
INTEGER,            INTENT(IN)     :: KDAY         ! Simulation day
REAL, DIMENSION(:), INTENT(INOUT)  :: PAUX_MAX     ! Auxiliar variable for autosize calcs
REAL, DIMENSION(:,:,:), INTENT(INOUT):: PT_FLOOR     ! Floor layers temperatures [K]
REAL, DIMENSION(:,:,:), INTENT(INOUT):: PT_MASS      ! Internal mass layers temperatures [K]
REAL, DIMENSION(:), INTENT(OUT)    :: PH_BLD_COOL  ! Sensible cooling energy demand  
                                                   ! of the building [W m-2(bld)]
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_BLD_COOL  ! Latent cooling energy demand 
                                                   ! of the building [W m-2(bld)]
REAL, DIMENSION(:), INTENT(OUT)   :: PH_WASTE_CANY  ! Sensible waste heat to canyon [W m-2(tot)]
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_WASTE_CANY ! Latent waste heat to canyon [W m-2(tot)]
REAL, DIMENSION(:), INTENT(OUT)   :: PCST_H_WASTE_CANY  ! Sensible waste heat to canyon [W m-2(tot)]
REAL, DIMENSION(:), INTENT(OUT)   :: PCST_LE_WASTE_CANY ! Latent waste heat to canyon [W m-2(tot)]
REAL, DIMENSION(:), INTENT(OUT)   :: PCOE_H_WASTE_CANY
REAL, DIMENSION(:), INTENT(OUT)   :: PCOE_LE_WASTE_CANY
REAL, DIMENSION(:), INTENT(OUT)   :: PMUL_H_WASTE_CANY
REAL, DIMENSION(:), INTENT(OUT)   :: PMUL_LE_WASTE_CANY
REAL, DIMENSION(:), INTENT(OUT)   :: PH_WASTE_ROOF  ! Sensible waste heat to roof [W m-2(tot)]
REAL, DIMENSION(:), INTENT(OUT)   :: PLE_WASTE_ROOF ! Latent waste heat to roof [W m-2(tot)]
REAL, DIMENSION(:), INTENT(IN)    :: PF_WASTE_CAN  ! fraction of waste heat released into the canyon
REAL, DIMENSION(:), INTENT(OUT)   :: PHVAC_COOL      ! Energy consumption of the cooling system [W m-2(bld)]
REAL, DIMENSION(:), INTENT(OUT)   :: PHVAC_HEAT      ! Energy consumption of the heating system [W m-2(bld)]
REAL, DIMENSION(:,:), INTENT(OUT) :: PCOMP_HVAC_COOL ! Energy consumption of the cooling system per compartment [W m-2(bld)]
REAL, DIMENSION(:,:), INTENT(OUT) :: PCOMP_HVAC_HEAT ! Energy consumption of the heating system per compartment [W m-2(bld)]
REAL, DIMENSION(:,:), INTENT(IN)  :: PQIN          ! Internal heat gains [W m-2(floor)]
REAL, DIMENSION(:), INTENT(IN)   :: PQIN_FRAD     ! Radiant fraction of internal heat gains
REAL, DIMENSION(:), INTENT(IN)   :: PQIN_FLAT     ! Latent franction of internal heat gains
REAL, DIMENSION(:), INTENT(IN)   :: PGR           ! Glazing ratio
REAL, DIMENSION(:), INTENT(IN)   :: PN50          ! Airtightness [AC/H at 50 Pa]
REAL, DIMENSION(:,:), INTENT(IN)   :: PTCOOL_TARGET ! Cooling setpoint of HVAC system [K]
REAL, DIMENSION(:,:), INTENT(IN)   :: PTHEAT_TARGET ! Heating setpoint of HVAC system [K]
REAL, DIMENSION(:), INTENT(IN)   :: PHR_TARGET    ! Relative humidity setpoint
REAL, DIMENSION(:), INTENT(INOUT):: PT_WIN2       ! Indoor window temperature [K]
REAL, DIMENSION(:,:), INTENT(INOUT):: PQI_BLD       ! Indoor air specific humidity [kg kg-1]
REAL, DIMENSION(:), INTENT(IN)   :: PCAP_SYS_HEAT ! Capacity of the heating system 
                                                  ! [W m-2(bld)]
REAL, DIMENSION(:), INTENT(INOUT):: PCAP_SYS_RAT  ! Rated capacity of the cooling system
                                                  ! [W m-2(bld)]
REAL, DIMENSION(:), INTENT(IN)   :: PT_ADP        ! Apparatus dewpoint temperature of the
                                                  ! cooling coil [K]
REAL, DIMENSION(:), INTENT(INOUT):: PM_SYS_RAT    ! Rated HVAC mass flow rate 
                                                  ! [kg s-1 m-2(bld)]
REAL, DIMENSION(:), INTENT(IN)   :: PCOP_RAT      ! Rated COP of the cooling system
REAL, DIMENSION(:), INTENT(OUT)  :: PCAP_SYS      ! Actual capacity of the cooling system
                                                  ! [W m-2(bld)] 
REAL, DIMENSION(:), INTENT(OUT)  :: PM_SYS        ! Actual HVAC mass flow rate 
                                                  ! [kg s-1 m-2(bld)]
REAL, DIMENSION(:), INTENT(OUT)  :: PCOP          ! COP of the cooling system
REAL, DIMENSION(:), INTENT(OUT)  :: PQ_SYS        ! Supply air specific humidity [kg kg-1]
REAL, DIMENSION(:), INTENT(OUT)  :: PT_SYS        ! Supply air temperature [K]
REAL, DIMENSION(:,:), INTENT(IN)   :: PTR_SW_WIN    ! Solar radiation transmitted throught
                                                  ! windows [W m-2(bld)]
REAL, DIMENSION(:,:),INTENT(IN)  :: PHC_FLOOR     ! heat capacity for road layers
REAL, DIMENSION(:,:),INTENT(IN)  :: PTC_FLOOR     ! thermal conductivity for 
                                                  ! road layers
REAL, DIMENSION(:,:),INTENT(IN)  :: PD_FLOOR      ! depth of road layers
REAL, DIMENSION(:,:),INTENT(IN)  :: PHC_MASS     ! heat capacity for road layers
REAL, DIMENSION(:,:),INTENT(IN)  :: PTC_MASS     ! thermal conductivity for 
                                                 ! road layers
REAL, DIMENSION(:,:),INTENT(IN)  :: PD_MASS      ! depth of road layers
REAL, DIMENSION(:), INTENT(IN)   :: PLW_WA_TO_WIN ! Radiative heat trasfer coeff wall-window 
                                                  ! [W K-1 m-2] 
REAL, DIMENSION(:), INTENT(IN)   :: PLW_WB_TO_WIN ! Radiative heat trasfer coeff wall-window 
                                                  ! [W K-1 m-2] 
REAL, DIMENSION(:), INTENT(IN)   :: PLW_G_TO_WIN  ! Radiative heat trasfer coeff garden-window 
                                                  ! [W K-1 m-2]
REAL, DIMENSION(:), INTENT(IN)   :: PLW_R_TO_WIN  ! Radiative heat trasfer coeff road-window 
                                                  ! [W K-1 m-2] 
REAL, DIMENSION(:), INTENT(IN)   :: PLW_S_TO_WIN ! Radiative heat trasfer coeff window-sky 
                                                 ! [W K-1 m-2]
REAL, DIMENSION(:), INTENT(IN)   :: PLW_WIN_TO_WA! Radiative heat trasfer coeff window-wall
                                                 ! [W K-1 m-2] 
REAL, DIMENSION(:), INTENT(IN)   :: PLW_WIN_TO_WB! Radiative heat trasfer coeff window-wall
                                                 ! [W K-1 m-2] 
REAL, DIMENSION(:), INTENT(IN)   :: PLW_WIN_TO_R ! Radiative heat trasfer coeff window-road 
                                                 ! [W K-1 m-2]
REAL, DIMENSION(:), INTENT(IN)   :: PLW_NR_TO_WIN! Radiative heat trasfer coeff road(snow)-win 
                                                 ! [W K-1 m-2]
REAL, DIMENSION(:), INTENT(IN)   :: PLW_WIN_TO_NR! Radiative heat trasfer coeff win-road(snow) 
                                                 ! [W K-1 m-2]
REAL, DIMENSION(:), INTENT(INOUT):: PT_WIN1       ! outdoor window temperature [K]
REAL, DIMENSION(:), INTENT(IN)   :: PABS_SW_WIN   ! window absorbed shortwave radiation [W m-2] 
REAL, DIMENSION(:), INTENT(OUT)  :: PABS_LW_WIN   ! absorbed infrared rad. [W m-2]
REAL, DIMENSION(:), INTENT(IN)   :: PUGG_WIN      ! window glass-to-glass U-factro [W m-2 K-1]
REAL, DIMENSION(:), INTENT(IN) :: PTDESV  ! Design temperature for ventilation [K]
REAL, DIMENSION(:), INTENT(IN) :: PFOPEN   ! Switch indicating building occupation
 !new argument for PET calculation
REAL, DIMENSION(:), INTENT(OUT) :: PEMIT_LW_ROAD ! LW fluxes emitted by road (W/m2 surf road)
REAL, DIMENSION(:), INTENT(OUT) :: PEMIT_LW_FAC  ! LW fluxes emitted by wall (W/m2 surf wall)
REAL, DIMENSION(:,:), INTENT(OUT) :: PT_RAD_IND    ! Indoor mean radiant temperature [K]
REAL,                INTENT(IN)  :: PTIME        ! current time since midnight (UTC, s)
REAL, DIMENSION(:), INTENT(IN)  :: PE_SHADING    !energy not ref., nor absorbed, nor
                                                 !trans. by glazing [Wm-2(win)]
!
REAL, DIMENSION(:)  , INTENT(IN)  :: PN_FLOOR        ! Number of floors     
REAL, DIMENSION(:)  , INTENT(IN)  :: PWALL_O_BLD     ! Wall area [m2_wall/m2_bld]
REAL, DIMENSION(:)  , INTENT(IN)  :: PGLAZ_O_BLD     ! Window area [m2_win/m2_bld]
REAL, DIMENSION(:)  , INTENT(IN)  :: PMASS_O_BLD     ! Mass area [m2_mass/m2_bld]
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_FLOOR_MASS   ! View factor floor-mass
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_FLOOR_WALL   ! View factor floor-wall
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_FLOOR_WIN    ! View factor floor-window
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_FLOOR_ROOF   ! View factor floor-roof
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_WALL_FLOOR   ! View factor wall-floor
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_WALL_MASS    ! View factor wall-mass
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_WALL_WIN     ! View factor wall-win
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_WIN_FLOOR    ! View factor win-floor
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_WIN_MASS     ! View factor win-mass
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_WIN_WALL     ! View factor win-wall
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_MASS_FLOOR   ! View factor mass-floor
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_MASS_WALL    ! View factor mass-wall
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_MASS_WIN     ! View factor mass-window
REAL, DIMENSION(:)  , INTENT(IN)  :: PSHGC_SH        ! window + shading solar heat gain coef.
LOGICAL,              INTENT(IN)  :: OCANOPY         ! is canopy active ?
 CHARACTER(LEN=5), INTENT(IN)      :: HCH_BEM         ! TEB option for outside building coef
                                                     ! "DOE-2"
REAL, DIMENSION(:)  , INTENT(IN)  :: PROUGH_ROOF     ! roof roughness coef
REAL, DIMENSION(:)  , INTENT(IN)  :: PROUGH_WALL     ! wall roughness coef
REAL, DIMENSION(:)  , INTENT(IN)  :: PF_WIN_WIN      ! indoor win to win view factor
REAL, DIMENSION(:), INTENT(OUT)   :: PSEN_SNOW_DIF_ROAD ! Sensible heat due to snowfall on road
REAL, DIMENSION(:), INTENT(OUT)   :: PSEN_SNOW_DIF_ROOF ! Sensible heat due to snowfall on roof
!
!* arguments for road watering
!
LOGICAL,              INTENT(IN)  :: OPAR_RD_IRRIG  ! True if there is potentially irrigation
REAL, DIMENSION(:),   INTENT(IN)  :: PRD_START_MONTH! First month of irrigation
REAL, DIMENSION(:),   INTENT(IN)  :: PRD_END_MONTH  ! Last month of irrigation
REAL, DIMENSION(:),   INTENT(IN)  :: PRD_START_HOUR ! First hour of irrigation (included)
REAL, DIMENSION(:),   INTENT(IN)  :: PRD_END_HOUR   ! Last hour of irrigation  (excluded)
REAL, DIMENSION(:),   INTENT(IN)  :: PRD_24H_IRRIG  ! diurnal averaged irrigation flux (kg/m2/s)
REAL, DIMENSION(:),   INTENT(OUT) :: PIRRIG_ROAD    ! man-made watering for road (kg/m2/s)
!
REAL, DIMENSION(:),   INTENT(OUT) :: PHEAT_RR_ROAD  ! Heating/Cooling of rain water on road (W/m²(road))
REAL, DIMENSION(:),   INTENT(OUT) :: PHEAT_RR_ROOF  ! Heating/Cooling of rain water on roof (W/m²(bld))
!
REAL, DIMENSION(:),   INTENT(OUT) :: PDQS_SNOW_ROOF ! heat storage inside roof snowpack
REAL, DIMENSION(:),   INTENT(OUT) :: PDQS_SNOW_ROAD ! heat storage inside road snowpack
!
REAL, DIMENSION(:),   INTENT(OUT) :: PSEN_MELT_ROAD
REAL, DIMENSION(:),   INTENT(OUT) :: PSEN_MELT_ROOF
REAL, DIMENSION(:),   INTENT(OUT) :: PDIFF_SNOW_WAT_ROAD
REAL, DIMENSION(:),   INTENT(OUT) :: PDIFF_SNOW_WAT_ROOF
!
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WALA_TO_ROAD
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WALB_TO_ROAD
REAL, DIMENSION(:), INTENT(OUT) :: PLW_WIND_TO_ROAD
!
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_ROAD_TO_WIND
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_WALL_TO_WIND
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_SNOW_TO_WIND
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_GARD_TO_WIND
!
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_WALA_TO_SNOW
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_WALB_TO_SNOW
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_WIND_TO_SNOW
!
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_ROAD_TO_WALA
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_GARD_TO_WALA
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_SNOW_TO_WALA
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_WALB_TO_WALA
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_WIND_TO_WALA
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_ROAD_TO_WALB
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_GARD_TO_WALB
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_SNOW_TO_WALB
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_WALA_TO_WALB
REAL, DIMENSION(:), INTENT(OUT)   :: PLW_WIND_TO_WALB
!
REAL, DIMENSION(:), INTENT(OUT)   :: PAGG_TR_SW_WIN
REAL, DIMENSION(:), INTENT(OUT)   :: PFLUXFLOOR       ! Heat flux into the floor (W/m²(urb))
REAL, DIMENSION(:), INTENT(OUT)   :: PFLX_BLD_ROOF    ! Heat exchange between indoor air and roof (W/m²(roof))
REAL, DIMENSION(:), INTENT(OUT)   :: PFLX_BLD_WALL_A  ! Heat exchange between indoor air and wall A (W/m²(wall)) 
REAL, DIMENSION(:), INTENT(OUT)   :: PFLX_BLD_WALL_B  ! Heat exchange between indoor air and wall B (W/m²(wall)) 
!
!* arguments for CO2 fluxes
REAL, DIMENSION(:)  , INTENT(IN)   :: PFRAC_HEAT_ELEC   !Fraction of electric heating
REAL, DIMENSION(:)  , INTENT(IN)   :: PFRAC_HEAT_GAS    !Fraction of gas heating
REAL, DIMENSION(:)  , INTENT(IN)   :: PFRAC_HEAT_FUEL   !Fraction of fuel heating
REAL, DIMENSION(:)  , INTENT(IN)   :: PFRAC_HEAT_OTHER  !Fraction of other heating
REAL                , INTENT(IN)   :: PCF_CO2_ELEC      !Conversion factor CO2/electricity (Kg/J)
REAL                , INTENT(IN)   :: PCF_CO2_GAS       !Conversion factor CO2/gas (Kg/J)
REAL                , INTENT(IN)   :: PCF_CO2_FUEL      !Conversion factor CO2/fuel (Kg/J)
REAL                , INTENT(IN)   :: PCF_CO2_OTHER     !Conversion factor CO2/other source(Kg/J) 
REAL                , INTENT(IN)   :: PEFF_HEAT_ELEC    !Efficiency of the electric heating
REAL                , INTENT(IN)   :: PEFF_HEAT_GAS     !Efficiency of the gas heating
REAL                , INTENT(IN)   :: PEFF_HEAT_FUEL    !Efficiency of the fuel heating
REAL                , INTENT(IN)   :: PEFF_HEAT_OTHER   !Efficiency of other heating
REAL                , INTENT(IN)   :: PLHV_HHV_ELEC     !LHV over HHV of the electric heating
REAL                , INTENT(IN)   :: PLHV_HHV_GAS      !LHV over HHV of the gas heating
REAL                , INTENT(IN)   :: PLHV_HHV_FUEL     !LHV over HHV of the fuel heating
REAL                , INTENT(IN)   :: PLHV_HHV_OTHER    !LHV over HHV of other heating
REAL, DIMENSION(:,:), INTENT(IN)   :: PHOTWAT           ! Energy needed for hot water modulated according to building occupation  [W m-2(bld)] 
REAL, DIMENSION(:)  , INTENT(IN)   :: PF_HW_GAS         ! fraction of water heat by gas


REAL, DIMENSION(:), INTENT(OUT)  :: PSFCO2            !CO2 fluxes due to heating, cooling and internal use of electricity (m/s*kg_CO2/kg_air)
REAL, DIMENSION(:), INTENT(OUT)  :: PHOTWAT_ELEC       !elec consumption for hot water (W/m²(bld))
REAL, DIMENSION(:), INTENT(OUT)  :: PHOTWAT_GAS        !gas consumption for hot water (W/m²(bld))
!
!
REAL, DIMENSION(:), INTENT(OUT)   :: PSNOW_HEAT_ROAD  !heat storage link to snow on road (W/m2 (road))
REAL, DIMENSION(:), INTENT(OUT)   :: PSNOW_HEAT_ROOF  !heat storage link to snow on roof (W/m2 (roof))
!
! *      0.2    Declarations of local variables
!
REAL, DIMENSION(SIZE(PTA)) :: ZVMOD          ! wind
REAL, DIMENSION(SIZE(PTA)) :: ZWS_ROOF_MAX   ! maximum deepness of roof
REAL, DIMENSION(SIZE(PTA)) :: ZWS_ROAD_MAX   ! and road water reservoirs
REAL, DIMENSION(SIZE(PTA)) :: ZWFRAC_ROOF_MAX! maximum fraction of roof
REAL, DIMENSION(SIZE(PTA)) :: ZWFRAC_ROAD_MAX! and road water reservoirs
!
REAL, DIMENSION(SIZE(PTA)) :: ZAC_BLD        ! surface conductance inside the building itself in DEF building model
REAL, DIMENSION(SIZE(PTA)) :: ZTA            ! air temperature extrapolated at roof level
REAL, DIMENSION(SIZE(PTA)) :: ZQA            ! air humidity extrapolated at roof level
!
REAL, DIMENSION(SIZE(PTA)) :: ZDQS_ROAD      ! heat storage inside road
REAL, DIMENSION(SIZE(PTA)) :: ZDQS_ROOF      ! heat storage inside roof
REAL, DIMENSION(SIZE(PTA)) :: ZDQS_WALL_A    ! heat storage inside wall
REAL, DIMENSION(SIZE(PTA)) :: ZDQS_WALL_B    ! heat storage inside wall
REAL, DIMENSION(SIZE(PTA)) :: ZFLX_BLD_FLOOR !heat flux from inside through floor
REAL, DIMENSION(SIZE(PTA)) :: ZFLX_BLD_MASS  !heat flux from inside through mass
!
REAL, DIMENSION(SIZE(PTA)) :: ZMELT_BLT      ! Snow melt for built & impervious part
REAL, DIMENSION(SIZE(PTA)) :: ZEFF_HEAT      ! mean heating system efficiency
REAL, DIMENSION(SIZE(PTA)) :: ZFRAC_HEAT_LE  ! LE waste due to heating per heating energy demand 
!
! coefficients for LW computations over snow (from previous time-step)
!
REAL, DIMENSION(SIZE(PTA)) :: ZTSSNOW_ROAD ! road snow temperature
!                                          ! at previous time-step
! new local variables after BEM
!
REAL, DIMENSION(SIZE(PTA)) :: ZTS_ROAD       ! road surface temperature 
!                                            ! at previous time-step
REAL, DIMENSION(SIZE(PTA)) :: ZTS_WALL_A     ! wall A surface temperature 
!                                            ! at previous time-step
REAL, DIMENSION(SIZE(PTA)) :: ZTS_WALL_B     ! wall B surface temperature 
!                                            ! at previous time-step
REAL, DIMENSION(SIZE(PTA)) :: ZTS_WALL       ! averaged wall surface temperature 
!                                            ! at previous time-step
REAL, DIMENSION(SIZE(PTA)) :: ZTS_ROOF       ! roof surface temperature 
!                                            ! at previous time-step
REAL, DIMENSION(SIZE(PTA),SIZE(PT_WALL_A,2)) :: ZT_WALL ! averaged wall surface temperature 
!
INTEGER :: IWALL, IROOF                      ! number of wall, roof layer
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZRADHT_IN     ! Indoor radiant heat transfer coefficient
                                                    ! [W K-1 m-2]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZTS_FLOOR       ! floor surface temperature [K]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZTS_MASS        ! mass surface temperature [K]
REAL, DIMENSION(SIZE(PTA)) :: ZRAD_ROOF_WALL  ! rad. flux from roof to averaged wall [W m-2(roof)]
REAL, DIMENSION(SIZE(PTA)) :: ZRAD_ROOF_WIN   ! rad. flux from roof to window [W m-2(roof)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZRAD_ROOF_FLOOR ! rad. flux from roof to floor [W m-2(roof)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZRAD_ROOF_MASS  ! rad. flux from roof to mass [W m-2(roof)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZCONV_ROOF_BLD  ! rad. flux from roof to bld [W m-2(roof)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZRAD_WALL_FLOOR ! rad. flux from averaged wall to floor [W m-2(wall)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZRAD_WALL_MASS  ! rad. flux from averaged wall to mass [W m-2(wall)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZRAD_WIN_FLOOR  ! rad. flux from averaged wall to floor [W m-2(win)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZRAD_WIN_MASS   ! rad. flux from averaged wall to mass [W m-2(win)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZCONV_WALL_BLD  ! rad. flux from roof to bld [W m-2(wall)]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZCONV_WIN_BLD   ! rad. flux from roof to bld [W m-2(win)]
REAL, DIMENSION(SIZE(PTA)) :: ZAC_WIN         ! window aerodynamic conductance
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZCOMP_T_RAD_IND  ! Indoor mean radiant temperature [K]
!
REAL, DIMENSION(SIZE(PTA)) :: ZLOAD_IN_ROOF   ! indoor load on roof W/m2[roof]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZLOAD_IN_FLOOR   ! indoor load on floor W/m2[floor]
REAL, DIMENSION(SIZE(PTA)) :: ZLOAD_IN_WALL   ! indoor load on wall W/m2[wall]
REAL, DIMENSION(SIZE(PTA)) :: ZLOAD_IN_WIN   ! indoor load on win W/m2[win]
REAL, DIMENSION(SIZE(PTA),SIZE(PTI_BLD,2)) :: ZLOAD_IN_MASS   ! indoor load on mass W/m2[mass]
REAL, DIMENSION(SIZE(PTA)) :: ZSUMDIFIMP      ! Energy imbalance due to implicitation W/m²[urb]
!
REAL, DIMENSION(SIZE(PTA)) :: ZLEFLIM_ROOF
REAL, DIMENSION(SIZE(PTA)) :: ZLEFLIM_ROAD
!
REAL, DIMENSION(SIZE(PTA)) :: ZEMIT_LW_SNOW_ROAD
REAL, DIMENSION(SIZE(PTA)) :: ZEMIT_LW_SNOW_ROOF
REAL, DIMENSION(SIZE(PTA)) :: ZDIAG_TI_ROOF
REAL, DIMENSION(SIZE(PTA)) :: ZAGG_QIN
REAL, DIMENSION(SIZE(PTA)) :: ZAGG_HOTWAT ! energy needed for hot water over all compartiments [W/m2(bld)]
!
REAL, DIMENSION(SIZE(PTA)) :: ZIRRIG_ROOF     ! ! man-made watering for roof (kg/m2/s)
!***KC***
REAL, DIMENSION(SIZE(PTA)) :: ZWS_ROOF, ZWS_ROAD
REAL, DIMENSION(SIZE(PTA)) :: ZRUNOFF_ROAD,ZRUNOFF_ROOF ! water runoff on roofs and roads (kg/m2/s)
!
! New local variables for BEM compartments
!
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_H_BLD_COOL
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_LE_BLD_COOL
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_HVAC_COOL
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_HVAC_HEAT
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_H_WASTE_CANY
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_LE_WASTE_CANY
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_H_WASTE_ROOF
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_LE_WASTE_ROOF
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_T_SYS
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_Q_SYS
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_M_SYS
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_COP
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_CAP_SYS
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_FLX_BLD_FLOOR
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_FLX_BLD_MASS
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_INFCALC
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_DIAG_WATER_COND
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_CST_H_WASTE_CANY
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_CST_LE_WASTE_CANY
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_COEFF_H_WASTE_CANY
REAL, DIMENSION(SIZE(PTA)) :: ZCOMP_COEFF_LE_WASTE_CANY
!
INTEGER :: JJ, JCOMP   ! Loop index
INTEGER              :: ILUOUT     ! Unit number
!
!***!
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE                                             
!-------------------------------------------------------------------------------
!
!*      1.     Initializations
!              ---------------
!
!*      1.1    Water reservoirs
!              ----------------
!
IF (LHOOK) CALL DR_HOOK('TEB',0,ZHOOK_HANDLE)
!
IF (HTEST/='OK') THEN
  CALL ABOR1_SFX('TEB: FATAL ERROR DURING ARGUMENT TRANSFER')
ENDIF
!
CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
ZEMIT_LW_SNOW_ROAD(:)=0.0
ZEMIT_LW_SNOW_ROOF(:)=0.0
!
ZWS_ROOF_MAX =  1.31 ! (1.31mm) maximum deepness of roof water reservoir
ZWS_ROAD_MAX =  1.31 ! (1.31mm) maximum deepness of road water reservoir
ZWFRAC_ROOF_MAX = 0.2 !maximum water reservoir fraction  
ZWFRAC_ROAD_MAX = 0.2 !maximum water reservoir fraction 

!
!*      1.2    radiative snow variables at previous time-step
!              ----------------------------------------------
!
ZTSSNOW_ROAD(:)=PTSSNOW_ROAD(:)
!
!
!*      1.3    indoor aerodynamique conductance for DEF case
!              ----------------------------------------------
!
ZAC_BLD(:) = XUNDEF
IF (HBEM=='DEF') ZAC_BLD=1. / 0.123 / (XCPD * PRHOA(:)) !* (normalized by rho Cp for convenience)
!-------------------------------------------------------------------------------
!
!*      1.3    number of roof/wall layer
!              -------------------------
!
IWALL = SIZE(PT_WALL_A,2)
IROOF = SIZE(PT_ROOF,2)
!
ZTS_WALL_A  (:)=PT_WALL_A   (:,1)
ZTS_WALL_B  (:)=PT_WALL_B   (:,1)
ZTS_WALL    (:)=0.5 * (ZTS_WALL_A(:)+ZTS_WALL_B(:))
ZTS_ROAD    (:)=PT_ROAD     (:,1)
ZTS_ROOF    (:)=PT_ROOF     (:,1)
!
!
!*      1.4    load on indoor walls
!              -------------------------
!
IF (HBEM=='BEM') THEN
  !
  IF (MINVAL(PQIN).LT.0.0) CALL ABOR1_SFX ("TEB: Negative PQIN")
  !
  ! The loads on roof, wall and window are aggregated
  ! over the compartments
  !
  ZLOAD_IN_ROOF(:) = 0.0
  ZLOAD_IN_WALL(:) = 0.0
  ZLOAD_IN_WIN (:) = 0.0
  !
  DO JCOMP=1,SIZE(PFRACOMP,2)
     !
     ZLOAD_IN_FLOOR(:,JCOMP) = PF_FLOOR_WIN(:)*PTR_SW_WIN(:,JCOMP) + &
        PQIN(:,JCOMP)*PN_FLOOR(:)*(1.0-PQIN_FLAT(:))*PQIN_FRAD(:)/(2.0+PWALL_O_BLD(:)+PGLAZ_O_BLD(:)+PMASS_O_BLD(:))
     !
     ZLOAD_IN_MASS(:,JCOMP)  = PF_MASS_WIN(:) *PTR_SW_WIN(:,JCOMP) + &
        PQIN(:,JCOMP)*PN_FLOOR(:)*(1.0-PQIN_FLAT(:))*PQIN_FRAD(:)/(2.0+PWALL_O_BLD(:)+PGLAZ_O_BLD(:)+PMASS_O_BLD(:))
     !
     ZLOAD_IN_ROOF(:) = ZLOAD_IN_ROOF(:) + PFRACOMP(:,JCOMP) * ( &
        PF_FLOOR_WIN(:)*PTR_SW_WIN(:,JCOMP)                +   & 
        PQIN(:,JCOMP)*PN_FLOOR(:)*(1.0-PQIN_FLAT(:))*PQIN_FRAD(:)/(2.0+PWALL_O_BLD(:)+PGLAZ_O_BLD(:)+PMASS_O_BLD(:)))
     !
     ZLOAD_IN_WALL(:) = ZLOAD_IN_WALL(:) + PFRACOMP(:,JCOMP) * ( &
         PF_WALL_WIN(:) *PTR_SW_WIN(:,JCOMP)                +   &
         PQIN(:,JCOMP)*PN_FLOOR(:)*(1.0-PQIN_FLAT(:))*PQIN_FRAD(:)/(2.0+PWALL_O_BLD(:)+PGLAZ_O_BLD(:)+PMASS_O_BLD(:)))
     !
     ZLOAD_IN_WIN (:) = ZLOAD_IN_WIN (:) + PFRACOMP(:,JCOMP) * ( & 
         PF_WIN_WIN(:)  *PTR_SW_WIN(:,JCOMP)                +   &
         PQIN(:,JCOMP)*PN_FLOOR(:)*(1.0-PQIN_FLAT(:))*PQIN_FRAD(:)/(2.0+PWALL_O_BLD(:)+PGLAZ_O_BLD(:)+PMASS_O_BLD(:)))
     !
  ENDDO
  !
ELSE
  ZLOAD_IN_ROOF = 0.
  ZLOAD_IN_FLOOR = 0.
  ZLOAD_IN_MASS = 0.
  ZLOAD_IN_WALL = 0.
  ZLOAD_IN_WIN = 0.
ENDIF
!-------------------------------------------------------------------------------
!
!*      2.     Snow-covered surfaces relative effects
!              --------------------------------------
!
!*      2.1    Effects on water reservoirs
!              ---------------------------
!
!-------------------------------------------------------------------------------
!
!*      3.     Surface drag
!              ------------
!
 CALL URBAN_DRAG(HZ0H, HIMPLICIT_WIND, PTSTEP, PT_CANYON, PQ_CANYON, &
                PU_CANYON, PT_LOWCAN, PQ_LOWCAN, PU_LOWCAN,          &
                PZ_LOWCAN, ZTS_ROOF, ZTS_ROAD, ZTS_WALL,             &
                PTS_GARDEN, PDN_ROOF, PDN_ROAD,                      &
                PEXNS_ROOF, PEXNS_SURF, PEXNA, PTA, PQA, PPS, PRHOA, &
                PZREF, PUREF, PVMOD,                                 &
                PZ0_TOWN,                                            &
                PBLD, PGARDEN, PROAD,                                &
                PBLD_HEIGHT, PCAN_HW_RATIO,                          &
                PWALL_O_GRND,                                        &
                PWS_ROOF, PWS_ROAD,                                  &
                ZWS_ROOF_MAX, ZWS_ROAD_MAX,                          &
                ZWFRAC_ROOF_MAX, ZWFRAC_ROAD_MAX,                    &
                PPEW_A_COEF, PPEW_B_COEF,                            &
                PPEW_A_COEF_LOWCAN, PPEW_B_COEF_LOWCAN,              &
                PQSAT_ROOF, PQSAT_ROAD, PDELT_ROOF, PDELT_ROAD,      &
                PCD, PCDN, PAC_ROOF, PAC_ROOF_WAT,                   &
                PAC_WALL, PAC_ROAD, PAC_ROAD_WAT, PAC_TOP,           &
                PAC_GARDEN, PRI_TOWN,                                &
                PUW_ROAD, PUW_ROOF, PDUWDU_ROAD, PDUWDU_ROOF,        &
                PUSTAR_TOWN, OCANOPY, PT_WIN1,  ZAC_WIN, HCH_BEM,    &
                PROUGH_ROOF, PROUGH_WALL                             )
!
! The adjustment of the water reservoirs has been 
! shifted behind the call of urban_drag in order 
! to avoid wrong values of PDELT
!
IF (OURBHYDRO) THEN
   ZWS_ROOF_MAX(:) = PWS_ROOF_MAX * PDF_ROOF(:)
   ZWS_ROAD_MAX(:) = PWS_ROAD_MAX * PDF_ROAD(:)
ELSE
   ZWS_ROOF_MAX(:) = ZWS_ROOF_MAX(:) * PDF_ROOF(:)
   ZWS_ROAD_MAX(:) = ZWS_ROAD_MAX(:) * PDF_ROAD(:)
ENDIF
!
!* area-averaged heat transfer coefficient
!
ZVMOD(:) = WIND_THRESHOLD(PVMOD(:),PUREF(:))
!
PCH_TOWN(:) = (PBLD(:) * PAC_ROOF(:) + (1.-PBLD(:)) * PAC_TOP (:)) / ZVMOD(:)
!
!* aggregation of momentum fluxes for roofs (=> derivate of flux also recalculated)
!
PUW_ROOF (:) = (1-PFRAC_GR(:)) * PUW_ROOF(:) + PFRAC_GR(:) * PUW_GREENROOF(:)
WHERE (PVMOD(:)/=0.) PDUWDU_ROOF(:) = 2. * PUW_ROOF(:) / PVMOD(:)
!
!-------------------------------------------------------------------------------
!
!*      4.     Extrapolation of atmospheric T and q at roof level (for fluxes computation)
!              --------------------------------------------------
!
ZTA(:) = PTA(:) * PEXNS_ROOF(:) / PEXNA(:)
ZQA(:) = PQA(:) * QSAT(PTA(:),PPS(:)) / QSAT(ZTA(:),PPA(:))
!
!-------------------------------------------------------------------------------
!
!*      5.     Snow mantel model
!              -----------------
!
 CALL URBAN_SNOW_EVOL(HPROGRAM,PT_LOWCAN, PQ_LOWCAN, PU_LOWCAN,                         &
                     ZTS_ROOF,ZTS_ROAD,ZTS_WALL_A, ZTS_WALL_B,                &
                     PT_ROOF, PD_ROOF, PTC_ROOF, PHC_ROOF,                    &
                     HSNOW_ROOF,                                              &
                     PWSNOW_ROOF, PTSNOW_ROOF, PRSNOW_ROOF, PASNOW_ROOF,      &
                     PTSSNOW_ROOF, PESNOW_ROOF,                               &
                     HSNOW_ROAD,                                              &
                     PWSNOW_ROAD, PTSNOW_ROAD, PRSNOW_ROAD, PASNOW_ROAD,      &
                     PTSSNOW_ROAD, PESNOW_ROAD,                               &
                     PPS, ZTA, ZQA, PRHOA,                                    &
                     PLW_RAD,                                                 &
                     PSR, PZREF, PUREF, PVMOD,                                &
                     PTSTEP,                                                  &
                     PZ_LOWCAN,                                               &
                     PDN_ROOF, PABS_SW_SNOW_ROOF, PABS_LW_SNOW_ROOF,          &
                     PDN_ROAD, PABS_SW_SNOW_ROAD, PABS_LW_SNOW_ROAD,          &
                     PRNSNOW_ROOF, PHSNOW_ROOF, PLESNOW_ROOF, PGSNOW_ROOF,    &
                     PMELT_ROOF,                                              &
                     PRNSNOW_ROAD, PHSNOW_ROAD, PLESNOW_ROAD, PGSNOW_ROAD,    &
                     PMELT_ROAD,                                              &
                     PLW_WA_TO_NR, PLW_WB_TO_NR, PLW_S_TO_NR, PLW_WIN_TO_NR,  &
                     PDQS_SNOW_ROOF, PDQS_SNOW_ROAD, PT_WIN1,                 &
                     PSEN_SNOW_DIF_ROAD, PSEN_SNOW_DIF_ROOF, PSNOW_D_ROOF,    &
                     PSNOW_HC_ROOF, PSNOW_D_ROAD, PSNOW_HC_ROAD, PROAD,       &
                     PLW_WALA_TO_SNOW, PLW_WALB_TO_SNOW, PLW_WIND_TO_SNOW,    &
                     ZEMIT_LW_SNOW_ROAD, ZEMIT_LW_SNOW_ROOF,                  &
                     PSNOW_HEAT_ROAD, PSNOW_HEAT_ROOF                         )
!
! Recalculation of snow-free fractions
!
PDF_ROAD(:)=1.-PDN_ROAD(:)
PDF_ROOF(:)=1.-PDN_ROOF(:)
!
! Robert: sensible heat taken up for melting (W/m²(urb))
! Note: These terms should have been taken into account in the
!       snow layer energy budget. They are only calculated
!       for checking.
!
PSEN_MELT_ROAD(:)=PROAD(:)*XLMTT*PDN_ROAD(:)*PMELT_ROAD(:)
PSEN_MELT_ROOF(:)=(1.0-PFRAC_GR(:))*PBLD(:)*XLMTT*PDN_ROOF(:)*PMELT_ROOF(:)
!
!-------------------------------------------------------------------------------
!
!*      6.    LW properties
!              -------------
!
!PDF_ROAD (:) = 1. - PDN_ROAD (:) have just been done few lignes above !!!
!
!-------------------------------------------------------------------------------
!
!*      7.    Indoor radiative temperature
!              ---------------------------
!
! uses the averaged temperature of both walls for the building energy balance
ZT_WALL   (:,:)=0.5 * (PT_WALL_A(:,:)+PT_WALL_B(:,:))
!
SELECT CASE(HBEM)
   !
   CASE("DEF")
      !
      ZTS_FLOOR(:,1) = 19. + XTT
      ZTS_MASS (:,1) = XUNDEF
      !
      PT_RAD_IND(:,1) = (PWALL_O_HOR(:) / PBLD(:) * ZT_WALL(:,IWALL) + &
                    PT_ROOF(:,IROOF) + ZTS_FLOOR(:,1)) &
                   / (PWALL_O_HOR(:) / PBLD(:) + 1. + 1.) 
      !
      ZRADHT_IN(:,1) = XUNDEF
      !
   CASE("BEM")
      !
      DO JCOMP=1,SIZE(PFRACOMP,2)
         ZTS_FLOOR(:,JCOMP) = PT_FLOOR(:,1,JCOMP)
         ZTS_MASS (:,JCOMP) = PT_MASS (:,1,JCOMP)
      ENDDO
      !
      PT_RAD_IND(:,:) = 0.0
      !
      DO JCOMP=1,SIZE(PFRACOMP,2)
         !
         ZCOMP_T_RAD_IND(:,JCOMP)  = (ZTS_MASS(:,JCOMP)*PMASS_O_BLD(:) + ZT_WALL(:,IWALL)*PWALL_O_BLD(:)     &
            + ZTS_FLOOR(:,JCOMP) + PT_ROOF(:,IROOF) + PT_WIN2(:) * PGLAZ_O_BLD(:)) &
            / (PMASS_O_BLD(:) + PWALL_O_BLD(:) + 1. + 1. + PGLAZ_O_BLD(:))
         !
         PT_RAD_IND(:,JCOMP) = ZCOMP_T_RAD_IND(:,JCOMP)
         !
      ENDDO
      !
      ! Assuming indoor surface emissivities of 0.9
      !
      DO JCOMP=1,SIZE(PFRACOMP,2)
         ZRADHT_IN(:,JCOMP) = 0.9 * 0.9 * 4 * XSTEFAN * ZCOMP_T_RAD_IND(:,JCOMP)**3
      ENDDO
      ! 
END SELECT
!
!
!*      7.    Roof Ts computation
!              -------------------
!
!* ts_roof and qsat_roof are updated
!
 CALL ROOF_LAYER_E_BUDGET(HPROGRAM, PFRACOMP, PT_ROOF, PQSAT_ROOF, PTI_BLD, ZAC_BLD, PTSTEP, &
                         HBEM, PHC_ROOF, PTC_ROOF, PD_ROOF, PDN_ROOF,   &
                         PRHOA, PAC_ROOF, PAC_ROOF_WAT, PLW_RAD, PPS,   &
                         PDELT_ROOF, ZTA, ZQA, PEXNA, PEXNS_ROOF,       &
                         PABS_SW_ROOF, PGSNOW_ROOF, PEMIS_ROOF,         &
                         PFLX_BLD_ROOF, ZDQS_ROOF, PABS_LW_ROOF,        &
                         PH_ROOF, PLEW_ROOF,                            &
                         PFRAC_GR, PG_GREENROOF_ROOF,                   &
                         PF_FLOOR_MASS, PF_FLOOR_WALL, PF_FLOOR_WIN,    &
                         PF_FLOOR_ROOF, ZRADHT_IN,                      &
                         ZTS_MASS, PT_WIN2, ZTS_FLOOR,            &
                         ZT_WALL(:,IWALL), ZRAD_ROOF_WALL,              &
                         ZRAD_ROOF_WIN, ZRAD_ROOF_FLOOR, ZRAD_ROOF_MASS,&
                         ZCONV_ROOF_BLD, PRR, ZLOAD_IN_ROOF, PHEAT_RR_ROOF, &
                         PWS_ROOF, ZLEFLIM_ROOF, ZDIAG_TI_ROOF  )
!
!-------------------------------------------------------------------------------
!
!*      8.    Road Ts computations
!              -----------------------------
!
!* Road watering

 CALL TEB_IRRIG(OPAR_RD_IRRIG, PTSTEP, TPTIME%TDATE%MONTH, PTSUN, &
               PRD_START_MONTH, PRD_END_MONTH, PRD_START_HOUR,   &
               PRD_END_HOUR, PRD_24H_IRRIG, PIRRIG_ROAD          )

!* ts_road, ts_wall, qsat_road, t_canyon and q_canyon are updated
!
! By adding PIRRIG_ROAD to PRR, it is assumed that the temperature
! of the water used for road irrigation is equal to the temperature of
! the canyon air (similar to rain water). This is not necessarily realistic.
!
 CALL ROAD_LAYER_E_BUDGET(HPROGRAM, PT_ROAD, PTSTEP, PHC_ROAD, PTC_ROAD, PD_ROAD, &
                         PDN_ROAD, PRHOA, PAC_ROAD, PAC_ROAD_WAT,                 &
                         PLW_RAD, PPS, PQSAT_ROAD, PDELT_ROAD, PEXNS_SURF,        &
                         PABS_SW_ROAD, PGSNOW_ROAD, PQ_LOWCAN, PT_LOWCAN,         &
                         ZTS_WALL_A, ZTS_WALL_B, ZTSSNOW_ROAD,                    &
                         PTS_GARDEN, PTS_HVEG, PT_WIN1,                           &
                         PLW_WA_TO_R, PLW_WB_TO_R, PLW_S_TO_R, PLW_WIN_TO_R,      &
                         PLW_HV_TO_R,                                             &
                         PEMIS_ROAD, PEMIT_LW_ROAD, ZDQS_ROAD, PABS_LW_ROAD,      &
                         PH_ROAD, PLEW_ROAD, PRR+PIRRIG_ROAD, PHEAT_RR_ROAD,      &
                         PWS_ROAD, ZLEFLIM_ROAD, PROAD, PLW_WALA_TO_ROAD,         &
                         PLW_WALB_TO_ROAD, PLW_WIND_TO_ROAD )
!
! Calculation of the weighted average of the longwave emission
! on snow-free and snow-covered road
!
PEMIT_LW_ROAD(:)=PDF_ROAD(:)*PEMIT_LW_ROAD(:)+PDN_ROAD(:)*ZEMIT_LW_SNOW_ROAD(:)
!
! Conversion between latent and sensible heat on roads and roofs
!
PCONV_LAT_SEN_ROAD(:)=-PDN_ROAD(:)*PLESNOW_ROAD(:)-PDF_ROAD(:)*PLEW_ROAD(:)
PCONV_LAT_SEN_ROOF(:)=(1.0-PFRAC_GR(:))*(-PDN_ROOF(:)*PLESNOW_ROOF(:)-PDF_ROOF(:)*PLEW_ROOF(:))
!
!-------------------------------------------------------------------------------
!
!*      8.     Wall Ts computations
!              -----------------------------
!
 CALL FACADE_E_BUDGET(HPROGRAM, PFRACOMP, HWALL_OPT, HBEM, PWALL_O_BLD, PWALL_O_HOR, PGLAZ_O_BLD,  &
                     PT_WALL_A, PT_WALL_B, PTSTEP,                       &
                     PHC_WALL, PTC_WALL, PD_WALL,                        &
                     PDN_ROAD, PRHOA, PAC_WALL,                          &
                     ZAC_BLD, PTI_BLD, ZDIAG_TI_ROOF, PLW_RAD, PPS, PEXNS_ROOF, &
                     PABS_SW_WALL_A, PABS_SW_WALL_B, PT_CANYON,          &
                     ZTS_ROAD, ZTSSNOW_ROAD,                             &
                     PTS_GARDEN, PTS_HVEG,                               &
                     PUGG_WIN, PGR,                                      &
                     PABS_SW_WIN, PF_WIN_MASS, PF_WIN_WALL,              &
                     PF_WIN_FLOOR, ZTS_MASS, ZTS_FLOOR,                  &
                     PEMIS_WALL,                                         &
                     PLW_WA_TO_WB,                                       &
                     PLW_R_TO_WA, PLW_R_TO_WB, PLW_G_TO_WA, PLW_G_TO_WB, &
                     PLW_S_TO_WA, PLW_S_TO_WB, PLW_NR_TO_WA,PLW_NR_TO_WB,&
                     PLW_WIN_TO_WA, PLW_WIN_TO_WB,                       &
                     PLW_S_TO_WIN, PLW_WA_TO_WIN, PLW_WB_TO_WIN,         &
                     PLW_R_TO_WIN, PLW_G_TO_WIN, PLW_NR_TO_WIN,          &
                     PLW_HV_TO_WIN, PLW_HV_TO_WA, PLW_HV_TO_WB,          &
                     PT_WIN1,                                            &
                     PFLX_BLD_WALL_A, ZDQS_WALL_A,                       &
                     PFLX_BLD_WALL_B, ZDQS_WALL_B,                       &
                     PT_WIN2, PEMIT_LW_FAC,                              &
                     PABS_LW_WALL_A, PABS_LW_WALL_B, PABS_LW_WIN,        &
                     PH_WALL_A, PH_WALL_B,                               &
                     PF_WALL_MASS, PF_WALL_FLOOR,                        &
                     PF_WALL_WIN, ZRADHT_IN, ZRAD_ROOF_WALL,             &
                     ZRAD_ROOF_WIN, ZRAD_WALL_FLOOR, ZRAD_WALL_MASS,     &
                     ZRAD_WIN_FLOOR, ZRAD_WIN_MASS, ZCONV_WALL_BLD,      &
                     ZCONV_WIN_BLD, ZAC_WIN,                             &
                     ZLOAD_IN_WALL, ZLOAD_IN_WIN ,PBLD,PF_FLOOR_WALL,    &
                     ZSUMDIFIMP, PLW_ROAD_TO_WIND, PLW_WALL_TO_WIND,     &
                     PLW_SNOW_TO_WIND, PLW_GARD_TO_WIND, PLW_ROAD_TO_WALA, &
                     PLW_GARD_TO_WALA, PLW_SNOW_TO_WALA, PLW_WALB_TO_WALA, &
                     PLW_WIND_TO_WALA, PLW_ROAD_TO_WALB, PLW_GARD_TO_WALB, &
                     PLW_SNOW_TO_WALB, PLW_WALA_TO_WALB, PLW_WIND_TO_WALB  )
!
!-------------------------------------------------------------------------------
!
!*      9.     Evolution of interior building air temperature
!              and temperature of soil column below
!              ----------------------------------------------
!
! uses the averaged temperature of both walls for the building energy balance
ZT_WALL   (:,:)=0.5 * (PT_WALL_A(:,:)+PT_WALL_B(:,:))
!
SELECT CASE(HBEM)
CASE("DEF")
!
   CALL BLD_E_BUDGET(HPROGRAM, .TRUE., PTSTEP, PBLD, PWALL_O_HOR,&
                     PRHOA, PT_ROOF, ZT_WALL, PTI_BLD(:,1),      &
                     ZTS_FLOOR(:,1),                             &
                     PT_ALLBLD(:,:,1), PHC_ALLBLD, PTC_ALLBLD, PD_ALLBLD, PFLUXFLOOR)
!
   !variables that needs to be computed apart
   PQI_BLD(:,1) = 0.5 * QSAT(PTI_BLD(:,1), PPS)
   !variables that need to be set 0 for calculation
   PH_WASTE_CANY (:) = 0.
   PLE_WASTE_CANY(:) = 0.
   PDIAG_WATER_COND(:) = 0.
   PH_WASTE_ROOF (:) = 0.
   PLE_WASTE_ROOF(:) = 0.
   PCST_H_WASTE_CANY  (:) = 0.
   PCST_LE_WASTE_CANY (:) = 0.
   PCOE_H_WASTE_CANY  (:) = 0.
   PCOE_LE_WASTE_CANY (:) = 0.
   PMUL_H_WASTE_CANY  (:) = 0.
   PMUL_LE_WASTE_CANY (:) = 0.
   ZFLX_BLD_FLOOR(:) = 0.
   ZFLX_BLD_MASS (:) = 0.
   !other variables
   PH_BLD_COOL(:) = XUNDEF
   PLE_BLD_COOL(:)= XUNDEF
   PHVAC_COOL(:)  = XUNDEF
   PHVAC_HEAT(:)  = XUNDEF
   PCOMP_HVAC_COOL(:,:) = XUNDEF
   PCOMP_HVAC_HEAT(:,:) = XUNDEF
   PCAP_SYS(:)    = XUNDEF
   PT_SYS(:)      = XUNDEF
   PM_SYS(:)      = XUNDEF
   PCOP(:)        = XUNDEF
   PQ_SYS(:)      = XUNDEF
   !
   PT_BLD(:,:,:) = PT_ALLBLD(:,2:,:)
   !
CASE("BEM")
   !
   ! Loop over all compartments
   ! At the moment the maximum number of compartments is considered
   ! for all grid points. However, bem could be changed to an 1d
   ! version in order to reduce the number of total calls. 
   !
   ! #######################################################################
   ! Initialisation of the variables to be aggregated
   ! #######################################################################
   !
   PH_BLD_COOL(:)    = 0.0
   PLE_BLD_COOL(:)   = 0.0 
   PHVAC_COOL(:)     = 0.0 
   PHVAC_HEAT(:)     = 0.0 
   PH_WASTE_CANY(:)  = 0.0 
   PLE_WASTE_CANY(:) = 0.0 
   PDIAG_WATER_COND(:) = 0.0
   PCST_H_WASTE_CANY(:) = 0.0 
   PCST_LE_WASTE_CANY(:)= 0.0 
   PCOE_H_WASTE_CANY  (:) = 0.
   PCOE_LE_WASTE_CANY (:) = 0.
   PMUL_H_WASTE_CANY  (:) = 0.
   PMUL_LE_WASTE_CANY (:) = 0.
   PH_WASTE_ROOF(:)  = 0.0 
   PLE_WASTE_ROOF(:) = 0.0 
   PT_SYS(:)         = 0.0
   PQ_SYS(:)         = 0.0 
   PM_SYS(:)         = 0.0 
   PCOP(:)           = 0.0 
   PCAP_SYS(:)       = 0.0 
   ZFLX_BLD_FLOOR(:) = 0.0 
   ZFLX_BLD_MASS(:)  = 0.0
   PINFCALC(:)       = 0.0
   !
   ZEFF_HEAT=1./(PFRAC_HEAT_ELEC/PEFF_HEAT_ELEC + PFRAC_HEAT_GAS/PEFF_HEAT_GAS + &
                 PFRAC_HEAT_FUEL/PEFF_HEAT_FUEL + PFRAC_HEAT_OTHER/PEFF_HEAT_OTHER )
   !
   ZFRAC_HEAT_LE=  PFRAC_HEAT_ELEC * (1.-PLHV_HHV_ELEC )/PEFF_HEAT_ELEC  &
                 + PFRAC_HEAT_GAS  * (1.-PLHV_HHV_GAS  )/PEFF_HEAT_GAS   &
                 + PFRAC_HEAT_FUEL * (1.-PLHV_HHV_FUEL )/PEFF_HEAT_FUEL  &
                 + PFRAC_HEAT_OTHER* (1.-PLHV_HHV_OTHER)/PEFF_HEAT_OTHER
   !
   IF ((MINVAL(ZEFF_HEAT).LT.0.0).OR.(MAXVAL(ZEFF_HEAT).GT.1.0)) THEN
      CALL ABOR1_SFX ("TEB: Wrong value for ZEFF_HEAT")
   ENDIF
   !
   IF ((MINVAL(ZFRAC_HEAT_LE).LT.0.0).OR.(MAXVAL(ZFRAC_HEAT_LE).GT.1.0)) THEN
      CALL ABOR1_SFX ("TEB: Wrong value for ZFRAC_HEAT_LE")
   ENDIF     
   !
   ! ######################################################
   ! Loop over the compartments
   ! ######################################################
   !
   DO JCOMP=1,SIZE(PFRACOMP,2)
      !
      CALL BEM (HPROGRAM, PTSTEP, KDAY, OAUTOSIZE,                                   &
             PBLD, PBLD_HEIGHT, PN_FLOOR, PGR, PN50, ZEFF_HEAT, PHC_FLOOR, PTC_FLOOR,&
             PD_FLOOR, PHC_MASS, PTC_MASS, PD_MASS, PHC_ALLBLD, PTC_ALLBLD,          &
             PD_ALLBLD, PF_FLOOR_MASS, PF_FLOOR_WALL,                                &
             PF_FLOOR_WIN, PF_FLOOR_ROOF,PF_MASS_FLOOR, PF_MASS_WALL, PF_MASS_WIN,   &
             ZRADHT_IN(:,JCOMP), PWALL_O_BLD, PGLAZ_O_BLD, PMASS_O_BLD, HCOOL_COIL,  &
             HHEAT_COIL, PPS, PPSOLD, PRHOA, PT_CANYON, PQ_CANYON, PU_CANYON,        &
             PT_ROOF, PT_WALL_A, PT_WALL_B, PT_WIN2, ZLOAD_IN_FLOOR(:,JCOMP),        &
             ZLOAD_IN_MASS(:,JCOMP), ZCONV_ROOF_BLD(:,JCOMP),                        &
             ZCONV_WALL_BLD(:,JCOMP), ZCONV_WIN_BLD(:,JCOMP),                        &
             ZRAD_ROOF_MASS(:,JCOMP), ZRAD_ROOF_FLOOR(:,JCOMP),                      &
             ZRAD_WALL_MASS(:,JCOMP), ZRAD_WALL_FLOOR(:,JCOMP),                      &
             ZRAD_WIN_MASS(:,JCOMP), ZRAD_WIN_FLOOR(:,JCOMP),                        &
             HNATVENT(:,JCOMP), PVENT_BEHAV_ANYWAY(:,JCOMP),                         &
             PVENT_BEHAV_ADAPTI(:,JCOMP), PTCOOL_TARGET(:,JCOMP),                    &
             PTHEAT_TARGET(:,JCOMP),PHR_TARGET, PQIN(:,JCOMP), PQIN_FRAD, PQIN_FLAT, &
             PF_WASTE_CAN, PTDESV, PISMECH, PMECHRATE, PSHGC_SH, PFOPEN,             &
             PF_WATER_COND, PCAP_SYS_HEAT,PT_ADP,PCOP_RAT,                           &
             PT_FLOOR(:,:,JCOMP), PT_MASS(:,:,JCOMP), PT_ALLBLD(:,:,JCOMP),          &
             PTI_BLD(:,JCOMP), PQI_BLD(:,JCOMP), PCAP_SYS_RAT,PM_SYS_RAT,            &
             PAUX_MAX, ZCOMP_H_BLD_COOL, ZCOMP_LE_BLD_COOL, ZCOMP_HVAC_COOL,         &
             ZCOMP_HVAC_HEAT, ZCOMP_T_SYS, ZCOMP_Q_SYS, ZCOMP_M_SYS, ZCOMP_H_WASTE_CANY, &
             ZCOMP_LE_WASTE_CANY, ZCOMP_H_WASTE_ROOF, ZCOMP_LE_WASTE_ROOF,           &
             ZCOMP_COP, ZCOMP_CAP_SYS, ZCOMP_FLX_BLD_FLOOR,ZCOMP_FLX_BLD_MASS,       &
             ZCOMP_INFCALC, PRHOI(:,JCOMP),PDIAGVENT(:,JCOMP),PDIAGVEFL(:,JCOMP), ZCOMP_DIAG_WATER_COND, &
             ZCOMP_CST_H_WASTE_CANY,ZCOMP_CST_LE_WASTE_CANY,ZCOMP_COEFF_H_WASTE_CANY,&
             ZCOMP_COEFF_LE_WASTE_CANY,ZFRAC_HEAT_LE, "OK")
      !
      ! Save heating and cooling energy demand for each compartment
      !
      PCOMP_HVAC_COOL(:,JCOMP) = ZCOMP_HVAC_COOL(:)
      PCOMP_HVAC_HEAT(:,JCOMP) = ZCOMP_HVAC_HEAT(:)
      !
      ! ####################################################################
      ! Aggregation of output variables
      ! ####################################################################
      !
      PH_BLD_COOL(:)        = PH_BLD_COOL(:)        + PFRACOMP(:,JCOMP) * ZCOMP_H_BLD_COOL(:)
      PLE_BLD_COOL(:)       = PLE_BLD_COOL(:)       + PFRACOMP(:,JCOMP) * ZCOMP_LE_BLD_COOL(:)
      PHVAC_COOL(:)         = PHVAC_COOL(:)         + PFRACOMP(:,JCOMP) * ZCOMP_HVAC_COOL(:)
      PHVAC_HEAT(:)         = PHVAC_HEAT(:)         + PFRACOMP(:,JCOMP) * ZCOMP_HVAC_HEAT(:)
      PH_WASTE_CANY(:)      = PH_WASTE_CANY(:)      + PFRACOMP(:,JCOMP) * ZCOMP_H_WASTE_CANY(:)
      PLE_WASTE_CANY(:)     = PLE_WASTE_CANY(:)     + PFRACOMP(:,JCOMP) * ZCOMP_LE_WASTE_CANY(:)
      PDIAG_WATER_COND(:)   = PDIAG_WATER_COND(:)   + PFRACOMP(:,JCOMP) * ZCOMP_DIAG_WATER_COND(:)
      PCST_H_WASTE_CANY(:)  = PCST_H_WASTE_CANY(:)  + PFRACOMP(:,JCOMP) * ZCOMP_CST_H_WASTE_CANY(:)
      PCST_LE_WASTE_CANY(:) = PCST_LE_WASTE_CANY(:) + PFRACOMP(:,JCOMP) * ZCOMP_CST_LE_WASTE_CANY(:)
      PCOE_H_WASTE_CANY (:) = PCOE_H_WASTE_CANY (:) + PFRACOMP(:,JCOMP) * ZCOMP_COEFF_H_WASTE_CANY (:)
      PCOE_LE_WASTE_CANY(:) = PCOE_LE_WASTE_CANY(:) + PFRACOMP(:,JCOMP) * ZCOMP_COEFF_LE_WASTE_CANY(:)
      PMUL_H_WASTE_CANY (:) = PMUL_H_WASTE_CANY (:) + PFRACOMP(:,JCOMP) * ZCOMP_COEFF_H_WASTE_CANY (:) * PTI_BLD(:,JCOMP)
      PMUL_LE_WASTE_CANY(:) = PMUL_LE_WASTE_CANY(:) + PFRACOMP(:,JCOMP) * ZCOMP_COEFF_LE_WASTE_CANY(:) * PQI_BLD(:,JCOMP)
      PH_WASTE_ROOF(:)      = PH_WASTE_ROOF(:)      + PFRACOMP(:,JCOMP) * ZCOMP_H_WASTE_ROOF(:)
      PLE_WASTE_ROOF(:)     = PLE_WASTE_ROOF(:)     + PFRACOMP(:,JCOMP) * ZCOMP_LE_WASTE_ROOF(:)
      PT_SYS(:)             = PT_SYS(:)             + PFRACOMP(:,JCOMP) * ZCOMP_T_SYS(:)
      PQ_SYS(:)             = PQ_SYS(:)             + PFRACOMP(:,JCOMP) * ZCOMP_Q_SYS(:)
      PM_SYS(:)             = PM_SYS(:)             + PFRACOMP(:,JCOMP) * ZCOMP_M_SYS(:)
      PCOP(:)               = PCOP(:)               + PFRACOMP(:,JCOMP) * ZCOMP_COP(:)
      PCAP_SYS(:)           = PCAP_SYS(:)           + PFRACOMP(:,JCOMP) * ZCOMP_CAP_SYS(:)
      ZFLX_BLD_FLOOR(:)     = ZFLX_BLD_FLOOR(:)     + PFRACOMP(:,JCOMP) * ZCOMP_FLX_BLD_FLOOR(:)
      ZFLX_BLD_MASS(:)      = ZFLX_BLD_MASS(:)      + PFRACOMP(:,JCOMP) * ZCOMP_FLX_BLD_MASS(:)
      PINFCALC(:)           = PINFCALC(:)           + PFRACOMP(:,JCOMP) * ZCOMP_INFCALC(:)
      !
   ENDDO
   !
   PT_BLD(:,:,:) = PT_ALLBLD(:,SIZE(PD_FLOOR,2)+1:,:)
   !
END SELECT
!
! Robert: The energy imbalance due to the implicitation
!         is added to the waste heat flux at roof level
!
PH_WASTE_ROOF(:)=PH_WASTE_ROOF(:)+ZSUMDIFIMP(:)
!
! Robert: The error in the latent heat flux made due to the
!         limitation of the available water reservoir is
!         added to the latent heat waste flux at roof level
!
PLE_WASTE_ROOF(:)=PLE_WASTE_ROOF(:)                        + &
     (1.0-PFRAC_GR(:))*PBLD(:)*PDF_ROOF(:)*ZLEFLIM_ROOF(:) + &
     PROAD(:)*PDF_ROAD(:)*ZLEFLIM_ROAD(:)
!
!-------------------------------------------------------------------------------
!
!*      10.    Fluxes over built surfaces
!              --------------------------
!
PAGG_TR_SW_WIN(:) = 0.0
ZAGG_QIN      (:) = 0.0
ZAGG_HOTWAT   (:) = 0.0
!
IF (HBEM.EQ."BEM") THEN
   DO JCOMP=1,SIZE(PFRACOMP,2)
      PAGG_TR_SW_WIN(:) = PAGG_TR_SW_WIN(:) + PFRACOMP(:,JCOMP) * PTR_SW_WIN(:,JCOMP)
      ZAGG_QIN      (:) = ZAGG_QIN(:)       + PFRACOMP(:,JCOMP) * PQIN(:,JCOMP)
      ZAGG_HOTWAT   (:) = ZAGG_HOTWAT   (:) + PFRACOMP(:,JCOMP) * PHOTWAT(:,JCOMP)
   ENDDO
ELSE
   ZAGG_QIN    (:) = XUNDEF
   ZAGG_HOTWAT (:) = XUNDEF
ENDIF
!
IF (MINVAL(ZAGG_QIN)   .LT.-XSURF_EPSILON) CALL ABOR1_SFX("TEB: Negative ZAGG_QIN")
IF (MINVAL(ZAGG_HOTWAT).LT.-XSURF_EPSILON) CALL ABOR1_SFX("TEB: Negative ZAGG_HOTWAT")
!
 CALL URBAN_FLUXES   (HIMPLICIT_WIND, OCANOPY, PT_CANYON,                     &
                     PPEW_A_COEF, PPEW_B_COEF, PRHOA, PVMOD,                  &
                     PH_TRAFFIC, PLE_TRAFFIC, PH_INDUSTRY, PLE_INDUSTRY,      &
                     PBLD, PROAD, PWALL_O_HOR, PFRAC_GR,                      &
                     PABS_SW_ROOF, PABS_LW_ROOF,                              &
                     PABS_SW_WALL_A, PABS_LW_WALL_A,                          &
                     PABS_SW_WALL_B, PABS_LW_WALL_B,                          &
                     PABS_SW_ROAD, PABS_LW_ROAD, PAGG_TR_SW_WIN,              &
                     ZAC_WIN, PCD,                                            &
                     PDF_ROOF, PDN_ROOF, PDF_ROAD, PDN_ROAD,                  &
                     PRNSNOW_ROOF, PHSNOW_ROOF, PLESNOW_ROOF, PGSNOW_ROOF,    &
                     PRNSNOW_ROAD, PHSNOW_ROAD, PLESNOW_ROAD, PGSNOW_ROAD,    &
                     PMELT_ROOF, ZDQS_ROOF,                                   &
                     PMELT_ROAD, ZDQS_ROAD,                                   &
                     ZDQS_WALL_A, ZDQS_WALL_B,                                &
                     PFLX_BLD_ROOF, PFLX_BLD_WALL_A, PFLX_BLD_WALL_B,         &
                     ZFLX_BLD_FLOOR,                                          &
                     ZFLX_BLD_MASS, PE_SHADING, HBEM, PGR, PT_WIN1, PH_WASTE_CANY, &
                     PLE_WASTE_CANY, PH_WASTE_ROOF, PLE_WASTE_ROOF, PABS_SW_WIN, PABS_LW_WIN, ZAGG_QIN, &
                     PN_FLOOR, PLEW_ROOF, PLEW_ROAD,                          &
                     PRN_GREENROOF, PH_GREENROOF, PLE_GREENROOF,              &
                     PGFLUX_GREENROOF,                                        &
                     PH_ROOF, PH_ROAD, PH_WALL_A, PH_WALL_B,                  &
                     PRN_ROOF,PLE_ROOF,                                       &
                     PGFLUX_ROOF, PRN_ROAD, PLE_ROAD, PGFLUX_ROAD,            &
                     PRN_WALL_A, PLE_WALL_A, PGFLUX_WALL_A,                   &
                     PRN_WALL_B, PLE_WALL_B, PGFLUX_WALL_B,                   &
                     PRN_STRLROOF, PH_STRLROOF, PLE_STRLROOF,                 & 
                     PGFLUX_STRLROOF,                                         &
                     PRN_BLT, PH_BLT, PLE_BLT,                                &
                     PGFLUX_BLT, ZMELT_BLT, PQF_BLD, PFLX_BLD, PDQS_TOWN,     &
                     PQF_TOWN, PUSTAR_TOWN, PHVAC_COOL, PHVAC_HEAT,           &
                     PQF_WALL_A, PQF_WALL_B, PQF_ROOF, PQF_ROAD, PQF_BLT      )
!
! Water transfer from snow reservoir to water reservoir in case of snow melt
!
!***KC
! Calculation of runoff due to snow melting
!
! Robert: This needs to be calculated also in the case where HYDRO is deactivated
!
PDIFF_SNOW_WAT_ROOF(:)=0.0
PDIFF_SNOW_WAT_ROAD(:)=0.0
!
DO JJ=1,SIZE(ZRUNOFF_ROOF)
   !
   ZRUNOFF_ROOF(JJ)=MAX(0.0,(PWS_ROOF(JJ)+PDN_ROOF(JJ)*PMELT_ROOF(JJ)*PTSTEP)-ZWS_ROOF_MAX(JJ))/PTSTEP
   ZRUNOFF_ROAD(JJ)=MAX(0.0,(PWS_ROAD(JJ)+PDN_ROAD(JJ)*PMELT_ROAD(JJ)*PTSTEP)-ZWS_ROAD_MAX(JJ))/PTSTEP
   !
   IF (PMELT_ROOF(JJ).GT.0.0) PDIFF_SNOW_WAT_ROOF(JJ)=(1.0-PFRAC_GR(JJ))*PBLD(JJ) *XLMTT*PDN_ROOF(JJ)*PMELT_ROOF(JJ)
   IF (PMELT_ROAD(JJ).GT.0.0) PDIFF_SNOW_WAT_ROAD(JJ)=PROAD(JJ)*XLMTT*PDN_ROAD(JJ)*PMELT_ROAD(JJ)
   !
   PWS_ROOF(JJ)=MIN(ZWS_ROOF_MAX(JJ),PWS_ROOF(JJ)+PDN_ROOF(JJ)*PMELT_ROOF(JJ)*PTSTEP)
   PWS_ROAD(JJ)=MIN(ZWS_ROAD_MAX(JJ),PWS_ROAD(JJ)+PDN_ROAD(JJ)*PMELT_ROAD(JJ)*PTSTEP)
   !
ENDDO
!
!-------------------------------------------------------------------------------
!
!*      11.    Roof and road reservoirs evolution
!              ----------------------------------
!
PNOC_ROOF(:) = 0.
PNOC_ROAD(:) = 0.
!
!              Hydro for roofs
!              ---------------
!
! Robert: Bugfix: Here the variables PLE_ROOF and PLE_ROAD
!         have been transmitted to the routine.
!         However, they also contain the latent heat
!         flux over snow.
!         Therefore, only the part of the latent heat
!         flux over the water surface is transmitted
!         The latent heat fluxes over water further need
!         to be multiplied by the fraction of snow-free
!         roof and road respectively.
!
! In case of roof, irrigation is prescribed to 0.
 ZIRRIG_ROOF(:) = 0.
!
 CALL URBAN_HYDRO(ZWS_ROOF_MAX, PWS_ROOF, PRR, ZIRRIG_ROOF, PTSTEP, PCONNEX, &
                  PDF_ROOF*PLEW_ROOF, PRUNOFF_STRLROOF, PNOC_ROOF          )
!
!              Hydro for roads
!              ---------------
!
 CALL URBAN_HYDRO(ZWS_ROAD_MAX, PWS_ROAD, PRR, PIRRIG_ROAD, PTSTEP, PCONNEX, &
                  PDF_ROAD*PLEW_ROAD, PRUNOFF_ROAD, PNOC_ROAD              )
!
IF (OURBHYDRO) THEN
!
PRUNOFF_ROOF(:) = PDF_ROOF(:) * (( 1. - PFRAC_GR(:)) * PRUNOFF_STRLROOF(:)    &
                + PFRAC_GR(:) * (PRUNOFF_GREENROOF(:) + PDRAIN_GREENROOF(:))) &
                + PDN_ROOF(:) * ZRUNOFF_ROOF(:)

PRUNOFF_ROAD(:) = PDF_ROAD(:) * PRUNOFF_ROAD(:) + PDN_ROAD(:) * ZRUNOFF_ROAD(:)
!
ELSE
!
PRUNOFF_STRLROOF(:)=PRUNOFF_STRLROOF(:)+ZRUNOFF_ROOF(:)
PRUNOFF_ROAD    (:)=PRUNOFF_ROAD    (:)+ZRUNOFF_ROAD(:)
!
PRUNOFF_ROOF(:) =   ( 1. - PFRAC_GR(:) ) *   PRUNOFF_STRLROOF(:)                        &
                  +        PFRAC_GR(:)   * ( PRUNOFF_GREENROOF(:) + PDRAIN_GREENROOF(:) )
!
PNOC_ROOF(:) = (1.0-PFRAC_GR(:)) * PNOC_ROOF(:)
!
ENDIF                                                           
!
!-------------------------------------------------------------------------------
!
!*      19.    Compute aerodynamical resistance 
!              --------------------------------
!
PRESA_TOWN(:) = 1. / ( PBLD(:) * PAC_ROOF(:)  + ( 1. - PBLD(:)) * PAC_TOP (:))
!
!-------------------------------------------------------------------------------
!       20.     Compute CO2 fluxes link to buildings
!-------------------------------------------------------------------------------
!
SELECT CASE(HBEM)
CASE("DEF")
   PSFCO2(:)=0.
CASE("BEM")
   !
   PHOTWAT_GAS(:) = ZAGG_HOTWAT * (PF_HW_GAS   )/PEFF_HEAT_GAS
   PHOTWAT_ELEC(:)= ZAGG_HOTWAT * (1.-PF_HW_GAS)/PEFF_HEAT_ELEC
   !
   IF (MINVAL(ZAGG_QIN)    .LT.-XSURF_EPSILON) CALL ABOR1_SFX("TEB: Negative value for internal heat release")
   IF (MINVAL(PHOTWAT_GAS) .LT.-XSURF_EPSILON) CALL ABOR1_SFX("TEB: Negative value for warm water heating by gas")
   IF (MINVAL(PHOTWAT_ELEC).LT.-XSURF_EPSILON) CALL ABOR1_SFX("TEB: Negative value for warm water heating by electricity")
   IF (MINVAL(PHVAC_COOL)  .LT.-XSURF_EPSILON) CALL ABOR1_SFX("TEB: Negative value for cooling energy release")
   IF (MINVAL(PHVAC_HEAT)  .LT.-XSURF_EPSILON) CALL ABOR1_SFX("TEB: Negative value for heating energy release")
   !
   PSFCO2(:) = (                                                          &
      ZAGG_QIN(:) * PN_FLOOR(:) * PCF_CO2_ELEC/PEFF_HEAT_ELEC           + &
      PHOTWAT_GAS * PCF_CO2_GAS                                         + &
      PHOTWAT_ELEC * PCF_CO2_ELEC                                       + &
      PHVAC_COOL(:) * PCF_CO2_ELEC/PEFF_HEAT_ELEC                       + &
      PHVAC_HEAT(:) * ZEFF_HEAT(:)                           * ( &
        PFRAC_HEAT_ELEC(:)  * PCF_CO2_ELEC  /PEFF_HEAT_ELEC  + &
        PFRAC_HEAT_GAS(:)   * PCF_CO2_GAS   /PEFF_HEAT_GAS   + &
        PFRAC_HEAT_FUEL(:)  * PCF_CO2_FUEL  /PEFF_HEAT_FUEL  + &
        PFRAC_HEAT_OTHER(:) * PCF_CO2_OTHER /PEFF_HEAT_OTHER   ) &
                )/PRHOA(:)
   !
   IF (MINVAL(PSFCO2).LT.-XSURF_EPSILON) CALL ABOR1_SFX("TEB: Negative value for CO2 release due to building energy consumption")
   !
CASE DEFAULT
   CALL  ABOR1_SFX('TEB : unknown value for CBEM : '//HBEM)
ENDSELECT
!
!
IF (LHOOK) CALL DR_HOOK('TEB',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------
!
END SUBROUTINE TEB
