!     #########
    SUBROUTINE ROOF_LAYER_E_BUDGET(HPROGRAM, PFRACOMP, PT_ROOF, PQSAT_ROOF, PTI_BLD, PAC_BLD, PTSTEP, &
                                   HBLD, PHC_ROOF, PTC_ROOF, PD_ROOF, PDN_ROOF,   &
                                   PRHOA, PAC_ROOF, PAC_ROOF_WAT, PLW_RAD, PPS,   &
                                   PDELT_ROOF, PTA, PQA, PEXNA, PEXNS,            &
                                   PABS_SW_ROOF, PGSNOW_ROOF, PEMIS_ROOF,         &
                                   PFLX_BLD_ROOF, PDQS_ROOF, PABS_LW_ROOF,        &
                                   PHFREE_ROOF, PLEFREE_ROOF,                     &
                                   PFRAC_GR, PG_GREENROOF_ROOF,                   &
                                   PF_FLOOR_MASS, PF_FLOOR_WALL, PF_FLOOR_WIN,    &
                                   PF_FLOOR_ROOF, PRADHT_IN,                      &
                                   PTS_MASS, PT_WIN2, PTS_FLOOR, PTI_WALL,        &
                                   PRAD_ROOF_WALL, PRAD_ROOF_WIN, PRAD_ROOF_FLOOR,&
                                   PRAD_ROOF_MASS, PCONV_ROOF_BLD, PRR,           &
                                   PLOAD_IN_ROOF, PHEAT_RR_ROOF, PWS_ROOF,        &
                                   PLEFLIM_ROOF, PDIAG_TI_ROOF                    )
!   ##########################################################################
!
!!****  *ROOF_LAYER_E_BUDGET*  
!!
!!    PURPOSE
!!    -------
!
!     Computes the evoultion of surface temperature of roofs
!         
!     
!!**  METHOD
!     ------
!
!
!
!
!    5 : equation for evolution of Ts_roof
!        *********************************
!
!     dTt_1(t) / dt = 1/(dt_1*Ct_1) * (  Rn - H - LE
!                                      - 2*Kt_1*(Tt_1-Tt_2)/(dt_1 +dt_2)       )
!
!     dTt_k(t) / dt = 1/(dt_k*Ct_k) * (- 2*Kt_k-1*(Tt_k-Tt_k-1)/(dt_k-1 +dt_k) 
!                                      - 2*Kt_k  *(Tt_k-Tt_k+1)/(dt_k+1 +dt_k) )
!
!       with
!
!       K*_k  = (d*_k+ d*_k+1)/(d*_k/k*_k+ d*_k+1/k*_k+1)
!
!       Rn = (dir_Rg + sca_Rg) (1-a) + emis * ( Rat - sigma Ts**4 (t+dt) )
!
!       H  = rho Cp CH V ( Ts (t+dt) - Tas )
!
!       LE = rho Lv CH V ( qs (t+dt) - qas )
!
!      where the as subscript denotes atmospheric values at ground level
!      (and not at first half level)
!
!      The tridiagonal systel is linearized with
!
!       using      Ts**4 (t+dt) = Ts**4 (t) + 4*Ts**3 (t) * ( Ts(t+dt) - Ts(t) )
!
!       and  qs (t+dt) = Hu(t) * qsat(t) + Hu(t) dqsat/dT * ( Ts(t+dt) - Ts(t) )
!
!
!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    MODD_CST
!!
!!      
!!    REFERENCE
!!    ---------
!!
!!      
!!    AUTHOR
!!    ------
!!
!!      V. Masson           * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    23/01/98 
!!                  17/10/05 (G. Pigeon) computation of storage inside the roofs
!!                  26/04/12 (G. Pigeon) add term of heating of rain (new arg PRR+XCL)
!!                     09/12 (G. Pigeon) modif of indoor conv. coef and implicit calculation
!!                     10/12 (G. Pigeon) add indoor solar heat load
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
USE MODD_SURF_PAR,  ONLY : XUNDEF
USE MODD_CSTS,ONLY : XCPD, XLVTT, XSTEFAN, XCL
!
USE MODE_THERMOS
!
USE MODI_LAYER_E_BUDGET
USE MODI_LAYER_E_BUDGET_GET_COEF
USE MODE_CONV_DOE
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
CHARACTER(LEN=6), INTENT(IN)        :: HPROGRAM     ! program calling surf. schemes
REAL, DIMENSION(:,:), INTENT(IN)    :: PFRACOMP     ! Fractions of bem compartments
REAL, DIMENSION(:,:), INTENT(INOUT) :: PT_ROOF      ! roof layers temperatures
REAL, DIMENSION(:), INTENT(INOUT)   :: PQSAT_ROOF   ! q_sat(Ts)
REAL, DIMENSION(:,:), INTENT(IN)    :: PTI_BLD      ! inside building temp.
REAL, DIMENSION(:), INTENT(IN)      :: PAC_BLD      ! aerodynamical resistance
                                                    ! inside building itself
REAL,               INTENT(IN)    :: PTSTEP         ! time step
 CHARACTER(LEN=3), INTENT(IN)      :: HBLD          ! Building Energy model 'DEF' or 'BEM'  
REAL, DIMENSION(:,:), INTENT(IN)  :: PHC_ROOF       ! heat capacity for roof layers
REAL, DIMENSION(:,:), INTENT(IN)  :: PTC_ROOF       ! thermal conductivity for roof layers
REAL, DIMENSION(:,:), INTENT(IN)  :: PD_ROOF        ! depth of roof layers
REAL, DIMENSION(:), INTENT(IN)    :: PDN_ROOF       ! roof snow fraction
REAL, DIMENSION(:), INTENT(IN)    :: PRHOA          ! air density
REAL, DIMENSION(:), INTENT(IN)    :: PAC_ROOF       ! aerodynamical conductance
REAL, DIMENSION(:), INTENT(IN)    :: PAC_ROOF_WAT   ! aerodynamical conductance (for water)
REAL, DIMENSION(:), INTENT(IN)    :: PLW_RAD        ! atmospheric infrared radiation
REAL, DIMENSION(:), INTENT(IN)    :: PPS            ! pressure at the surface
REAL, DIMENSION(:), INTENT(IN)    :: PDELT_ROOF     ! fraction of water
REAL, DIMENSION(:), INTENT(IN)    :: PTA            ! air temperature at roof level
REAL, DIMENSION(:), INTENT(IN)    :: PQA            ! air specific humidity
                                                    ! at roof level
REAL, DIMENSION(:), INTENT(IN)    :: PEXNA          ! exner function
REAL, DIMENSION(:), INTENT(IN)    :: PEXNS          ! surface exner function
REAL, DIMENSION(:), INTENT(IN)    :: PABS_SW_ROOF   ! absorbed solar radiation
REAL, DIMENSION(:), INTENT(IN)    :: PGSNOW_ROOF    ! roof snow conduction
!                                                   ! heat fluxes at mantel
!                                                   ! base
REAL, DIMENSION(:), INTENT(IN)    :: PEMIS_ROOF     ! roof emissivity
REAL, DIMENSION(:), INTENT(IN)    :: PFRAC_GR       ! fraction of green roofs
REAL, DIMENSION(:), INTENT(IN)    :: PG_GREENROOF_ROOF ! heat conduction flux
!                                                        between greenroof and
!                                                        structural roof
REAL, DIMENSION(:), INTENT(OUT)   :: PFLX_BLD_ROOF  ! flux from bld to roof
REAL, DIMENSION(:), INTENT(OUT)   :: PDQS_ROOF      ! heat storage inside the roofs
REAL, DIMENSION(:), INTENT(OUT)   :: PABS_LW_ROOF   ! absorbed infra-red rad.
REAL, DIMENSION(:), INTENT(OUT)   :: PHFREE_ROOF    ! sensible heat flux of the
                                                    ! snow free part of the roof
REAL, DIMENSION(:), INTENT(OUT)   :: PLEFREE_ROOF   ! latent heat flux of the
                                                    ! snow free part of the roof
REAL, DIMENSION(:), INTENT(IN)    :: PF_FLOOR_MASS  ! View factor floor-mass
REAL, DIMENSION(:), INTENT(IN)    :: PF_FLOOR_WALL  ! View factor floor-wall
REAL, DIMENSION(:), INTENT(IN)    :: PF_FLOOR_WIN   ! View factor floor-window
REAL, DIMENSION(:), INTENT(IN)    :: PF_FLOOR_ROOF  ! View factor floor-roof
REAL, DIMENSION(:,:), INTENT(IN)  :: PRADHT_IN      ! Indoor radiant heat transfer coefficient
                                                    ! [W K-1 m-2]
REAL, DIMENSION(:,:), INTENT(IN)    :: PTS_MASS       ! surf. mass temp. (contact with bld air)
REAL, DIMENSION(:), INTENT(IN)    :: PT_WIN2        ! indoor wind. temp.
REAL, DIMENSION(:,:), INTENT(IN)    :: PTS_FLOOR      ! surf. floor temp. (contact with bld air)
REAL, DIMENSION(:), INTENT(IN)    :: PTI_WALL       ! indoor wall temp.
REAL, DIMENSION(:), INTENT(OUT)   :: PRAD_ROOF_WALL ! rad. fluxes from roof to wall [W m-2(roof)]
REAL, DIMENSION(:), INTENT(OUT)   :: PRAD_ROOF_WIN  ! rad. fluxes from roof to win [W m-2(roof)]
REAL, DIMENSION(:,:), INTENT(OUT)   :: PRAD_ROOF_FLOOR! rad. fluxes from roof to floor [W m-2(roof)]
REAL, DIMENSION(:,:), INTENT(OUT)   :: PRAD_ROOF_MASS ! rad. fluxes from roof to mass [W m-2(roof)]
REAL, DIMENSION(:,:), INTENT(OUT)   :: PCONV_ROOF_BLD ! conv. fluxes from roof to bld [W m-2(roof)]
REAL, DIMENSION(:), INTENT(IN)    :: PRR ! rain rate [kg m-2 s-1]
REAL, DIMENSION(:), INTENT(IN)    :: PLOAD_IN_ROOF ! solar + int heat gain on roof W/m2 [roof]
REAL, DIMENSION(:), INTENT(OUT)   :: PHEAT_RR_ROOF  ! heat used too cool/heat the rain from the roof [W m-2(roof)]
REAL, DIMENSION(:), INTENT(OUT)   :: PLEFLIM_ROOF   ! Excess latent heat flux put into the waste heat flux [W m-2(roof)]
REAL, DIMENSION(:), INTENT(IN)    :: PWS_ROOF       ! Water on roof
REAL, DIMENSION(:), INTENT(OUT)   :: PDIAG_TI_ROOF
!
!*      0.2    declarations of local variables
!
REAL :: ZIMPL = 1.0        ! implicit coefficient
REAL :: ZEXPL = 0.0        ! explicit coefficient
!
REAL, DIMENSION(SIZE(PTA)) :: ZDF_ROOF ! snow-free fraction
REAL, DIMENSION(SIZE(PTA),SIZE(PT_ROOF,2)) :: ZA,& ! lower diag.
                                              ZB,& ! main  diag.
                                              ZC,& ! upper diag.
                                              ZY   ! r.h.s.
!
REAL, DIMENSION(SIZE(PTA)) :: ZDQSAT_ROOF      ! dq_sat/dTs
REAL, DIMENSION(SIZE(PTA)) :: ZRHO_ACF_ROOF    ! conductance * rho
REAL, DIMENSION(SIZE(PTA)) :: ZRHO_ACF_ROOF_WAT! conductance * rho (for water)
REAL, DIMENSION(SIZE(PTA)) :: ZMTC_O_D_ROOF_IN ! thermal capacity times layer depth
REAL, DIMENSION(SIZE(PTA)) :: ZTS_ROOF         ! roof surface temperature at previous time step
REAL, DIMENSION(SIZE(PTA)) :: ZTRAD_ROOF       ! roof radiative surface temperature at intermediate time step
REAL, DIMENSION(SIZE(PTA)) :: ZTAER_ROOF       ! roof aerodyn. surface temperature at intermediate time step
REAL, DIMENSION(SIZE(PTA)) :: ZTI_ROOF         ! temperature of internal roof layer used for radiative exchanges
REAL, DIMENSION(SIZE(PTA)) :: ZTI_ROOF_CONV    ! temperature of internal roof layer used for convective exchanges
REAL, DIMENSION(SIZE(PTA),SIZE(PRADHT_IN,2)) :: ZCHTC_IN_ROOF      ! Indoor roof convec heat transfer coefficient
                                               ! [W K-1 m-2(bld)]
!
REAL, DIMENSION(SIZE(PTA)) :: ZCHTC_IN_ROOF_EFF
REAL, DIMENSION(SIZE(PTA)) :: ZCH_MULT_TI_BLD
REAL, DIMENSION(SIZE(PTA)) :: ZRADHT_EFF
REAL, DIMENSION(SIZE(PTA)) :: ZRAD_MULT_TFLOOR
REAL, DIMENSION(SIZE(PTA)) :: ZRAD_MULT_TMASS
REAL, DIMENSION(SIZE(PTA)) :: ZRAD_ROOF_FLOOR
REAL, DIMENSION(SIZE(PTA)) :: ZRAD_ROOF_MASS
REAL, DIMENSION(SIZE(PTA)) :: ZCONV_ROOF_BLD
REAL, DIMENSION(SIZE(PPS),SIZE(PRADHT_IN,2)) :: ZCOMP_RAD_ROOF_WIN 
REAL, DIMENSION(SIZE(PPS),SIZE(PRADHT_IN,2)) :: ZCOMP_RAD_ROOF_WALL 
REAL, DIMENSION(SIZE(PTA)) :: ZWATROOFMAX       ! Maximum available roof water [W m-2 (bld)]
REAL, DIMENSION(SIZE(PTA)) :: ZIMB_ROOF         ! residual energy imbalance of the roof for
INTEGER :: JJ
INTEGER :: IROOF_LAYER           ! number of roof layers
INTEGER :: JLAYER                ! loop counter
INTEGER :: JCOMP                 ! loop counter
INTEGER :: ILUOUT                ! logical unit of output file
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('ROOF_LAYER_E_BUDGET',0,ZHOOK_HANDLE)
!
! Calculate maximum water on roof available for evaporation (unit W/m²).
! The latent heat flux must not exceed this value.
!
ZWATROOFMAX(:)=XLVTT*(PWS_ROOF(:)/PTSTEP+PRR(:))
!
PRAD_ROOF_WALL(:) = XUNDEF
PRAD_ROOF_WIN(:)  = XUNDEF
PRAD_ROOF_FLOOR(:,:)= XUNDEF
PRAD_ROOF_MASS(:,:) = XUNDEF
PCONV_ROOF_BLD(:,:) = XUNDEF
!
! *Convection heat transfer coefficients [W m-2 K-1] from EP Engineering Reference
!
IROOF_LAYER = SIZE(PT_ROOF,2)
!
DO JCOMP=1,SIZE(PFRACOMP,2)
   ZCHTC_IN_ROOF(:,JCOMP) = CHTC_DOWN_DOE(PT_ROOF(:,IROOF_LAYER), PTI_BLD(:,JCOMP))
   DO JJ=1,SIZE(PFRACOMP,1)
      ZCHTC_IN_ROOF(JJ,JCOMP) = MAX(1.,ZCHTC_IN_ROOF(JJ,JCOMP))
   ENDDO
ENDDO
!
! Calculation of effective coefficients in order to simplify the
! structure of the equation in the multi-compartment case
!
ZCHTC_IN_ROOF_EFF(:) = 0.0
ZRADHT_EFF(:)        = 0.0
ZCH_MULT_TI_BLD(:)   = 0.0
ZRAD_MULT_TFLOOR(:)  = 0.0
ZRAD_MULT_TMASS(:)   = 0.0
!
DO JCOMP=1,SIZE(PFRACOMP,2)
   ZCHTC_IN_ROOF_EFF(:) = ZCHTC_IN_ROOF_EFF(:) + PFRACOMP(:,JCOMP) * ZCHTC_IN_ROOF(:,JCOMP)
   ZRADHT_EFF(:)        = ZRADHT_EFF(:)        + PFRACOMP(:,JCOMP) * PRADHT_IN(:,JCOMP)
   ZCH_MULT_TI_BLD(:)  = ZCH_MULT_TI_BLD(:)  + PFRACOMP(:,JCOMP) * ZCHTC_IN_ROOF(:,JCOMP) * PTI_BLD(:,JCOMP)
   ZRAD_MULT_TFLOOR(:) = ZRAD_MULT_TFLOOR(:) + PFRACOMP(:,JCOMP) * PRADHT_IN(:,JCOMP) * PTS_FLOOR(:,JCOMP)
   ZRAD_MULT_TMASS(:)  = ZRAD_MULT_TMASS(:)  + PFRACOMP(:,JCOMP) * PRADHT_IN(:,JCOMP) * PTS_MASS (:,JCOMP)
ENDDO
!
 CALL LAYER_E_BUDGET_GET_COEF( PT_ROOF, PTSTEP, ZIMPL, PHC_ROOF, PTC_ROOF, PD_ROOF, &
                              ZA, ZB, ZC, ZY )
!
!
DO JJ=1,SIZE(PDN_ROOF)
  !
  ZDF_ROOF(JJ) = 1. - PDN_ROOF(JJ)
  !
  ZTS_ROOF(JJ) = PT_ROOF(JJ,1)
  ZTI_ROOF(JJ) = PT_ROOF(JJ,IROOF_LAYER)
  !
  !*      2.     Roof Ts coefficients
  !              --------------------
  !
  ZRHO_ACF_ROOF    (JJ) = PRHOA(JJ) * PAC_ROOF    (JJ)
  ZRHO_ACF_ROOF_WAT(JJ) = PRHOA(JJ) * PAC_ROOF_WAT(JJ)
  !
  IF (HBLD .EQ. 'DEF') THEN
    ZMTC_O_D_ROOF_IN(JJ) = 2. * PTC_ROOF(JJ,IROOF_LAYER) / PD_ROOF (JJ,IROOF_LAYER)
    ZMTC_O_D_ROOF_IN(JJ) = 1./(  1./ZMTC_O_D_ROOF_IN(JJ) + 1./(XCPD*PRHOA(JJ)*PAC_BLD(JJ)) ) 
  ENDIF
  !
ENDDO
!
!*      2.1    dqsat/dTs, and humidity for roofs
!              ---------------------------------
!
ZDQSAT_ROOF(:) = DQSAT(ZTS_ROOF(:),PPS(:),PQSAT_ROOF(:))
!
!*      2.2    coefficients
!              ------------
! 
DO JJ=1,SIZE(PT_ROOF,1)
  !
  ZB(JJ,1) = ZB(JJ,1) + ZDF_ROOF(JJ) * (1.-PFRAC_GR(JJ)) * (                                       &
                        ZIMPL * ( XCPD/PEXNS(JJ) * ZRHO_ACF_ROOF(JJ)                               &
                                + XLVTT * ZRHO_ACF_ROOF_WAT(JJ) * PDELT_ROOF(JJ) * ZDQSAT_ROOF(JJ) &
                                + XSTEFAN * PEMIS_ROOF(JJ) * 4.*ZTS_ROOF(JJ)**3 ))                 &
                                + ZIMPL * PRR(JJ) * XCL !! heating/cooling of rain 
  !
  ZY(JJ,1) = ZY(JJ,1) + (1.-PFRAC_GR(JJ))                                                                 &
                      * (PDN_ROOF(JJ)*PGSNOW_ROOF(JJ) + ZDF_ROOF(JJ) * ( PABS_SW_ROOF(JJ)                 &
                         + XCPD * ZRHO_ACF_ROOF(JJ) * ( PTA(JJ)/PEXNA(JJ) - ZEXPL*ZTS_ROOF(JJ)/PEXNS(JJ)) &
                         + PEMIS_ROOF(JJ)*PLW_RAD(JJ)                                                     &                 
                         + XLVTT * ZRHO_ACF_ROOF_WAT(JJ) * PDELT_ROOF(JJ)                                 &
                           * ( PQA(JJ) - PQSAT_ROOF(JJ) + ZIMPL * ZDQSAT_ROOF(JJ) * ZTS_ROOF(JJ) )        &
                         + XSTEFAN * PEMIS_ROOF(JJ) * ZTS_ROOF(JJ)**4 * ( 3.*ZIMPL-ZEXPL ) ))  &
                         + PRR(JJ) * XCL * (PTA(JJ) - ZEXPL * ZTS_ROOF(JJ)) & !! heating/cooling of rain
                         + PFRAC_GR(JJ)*PG_GREENROOF_ROOF(JJ)
  !
  IF (HBLD=="DEF") THEN
    !
    ZB(JJ,IROOF_LAYER) = ZB(JJ,IROOF_LAYER) + ZIMPL * ZMTC_O_D_ROOF_IN(JJ)
    !
    ZY(JJ,IROOF_LAYER) = ZY(JJ,IROOF_LAYER) &
                         + ZMTC_O_D_ROOF_IN(JJ) * PTI_BLD(JJ,1) &
                         - ZEXPL * ZMTC_O_D_ROOF_IN(JJ) * PT_ROOF(JJ,IROOF_LAYER)
    !
  ELSEIF (HBLD=="BEM") THEN
    !
    ZB(JJ, IROOF_LAYER) = ZB(JJ,IROOF_LAYER) + ZIMPL * &
                       (ZCHTC_IN_ROOF_EFF(JJ) * 4./3. + ZRADHT_EFF(JJ) * &
                        (PF_FLOOR_MASS(JJ) + PF_FLOOR_WIN(JJ) + &
                         PF_FLOOR_WALL(JJ) + PF_FLOOR_ROOF(JJ) ))
    !
    ZY(JJ,IROOF_LAYER) = ZY(JJ,IROOF_LAYER) + &
       ZCH_MULT_TI_BLD(JJ)                - &
       1./3. * ZCHTC_IN_ROOF_EFF(JJ) * PT_ROOF(JJ,IROOF_LAYER)*(4*ZEXPL - 1.) + &
       ZRADHT_EFF(JJ) * (                                                    &
       PF_FLOOR_WIN (JJ) * (PT_WIN2 (JJ) - ZEXPL * PT_ROOF(JJ,IROOF_LAYER)) +   &
       PF_FLOOR_WALL(JJ) * (PTI_WALL(JJ) - ZEXPL * PT_ROOF(JJ,IROOF_LAYER)) +   &
       PF_FLOOR_MASS(JJ) * (- ZEXPL * PT_ROOF(JJ,IROOF_LAYER))              +   &
       PF_FLOOR_ROOF(JJ) * (- ZEXPL * PT_ROOF(JJ,IROOF_LAYER)) )            +   &
       PF_FLOOR_MASS(JJ) * ZRAD_MULT_TMASS (JJ)                             +   &
       PF_FLOOR_ROOF(JJ) * ZRAD_MULT_TFLOOR(JJ)                             +   &
       PLOAD_IN_ROOF(JJ)
    !
  ENDIF
  !
ENDDO
!
!
 CALL LAYER_E_BUDGET( PT_ROOF, PTSTEP, ZIMPL, PHC_ROOF, PTC_ROOF, PD_ROOF, &
                     ZA, ZB, ZC, ZY, PDQS_ROOF )
!
!-------------------------------------------------------------------------------
!
!*     diagnostic: computation of flux between bld and internal roof layer
DO JJ=1,SIZE(PT_ROOF,1)
  !
  ZTI_ROOF_CONV(JJ) = 4./3. * ZIMPL * PT_ROOF(JJ, IROOF_LAYER) + 1./3. * ZTI_ROOF(JJ) * (4*ZEXPL -1.)
  ZTI_ROOF(JJ) = ZEXPL * ZTI_ROOF(JJ) + ZIMPL * PT_ROOF(JJ, IROOF_LAYER) 
  SELECT CASE(HBLD)
  CASE("DEF")
     PFLX_BLD_ROOF(JJ) = ZMTC_O_D_ROOF_IN(JJ) * (PTI_BLD(JJ,1) - ZTI_ROOF(JJ))
  CASE("BEM")
     !
     ! Robert:
     ! The fluxes are diagnosed separately for the different compartments
     !
     PDIAG_TI_ROOF(:) = ZTI_ROOF(:)
     !
     PRAD_ROOF_WALL(JJ)  = 0.0
     PRAD_ROOF_WIN(JJ)   = 0.0
     ZRAD_ROOF_FLOOR(JJ) = 0.0
     ZRAD_ROOF_MASS(JJ)  = 0.0
     ZCONV_ROOF_BLD(JJ)  = 0.0
     !
     DO JCOMP=1,SIZE(PFRACOMP,2)
        !
        ZCOMP_RAD_ROOF_WALL(JJ,JCOMP)  = PRADHT_IN(JJ,JCOMP)     * ( ZTI_ROOF(JJ)      - PTI_WALL (JJ) )
        ZCOMP_RAD_ROOF_WIN(JJ,JCOMP)   = PRADHT_IN(JJ,JCOMP)     * ( ZTI_ROOF(JJ)      - PT_WIN2  (JJ) )
        PRAD_ROOF_FLOOR(JJ,JCOMP) = PRADHT_IN(JJ,JCOMP)     * ( ZTI_ROOF(JJ)      - PTS_FLOOR(JJ,JCOMP) )
        PRAD_ROOF_MASS(JJ,JCOMP)  = PRADHT_IN(JJ,JCOMP)     * ( ZTI_ROOF(JJ)      - PTS_MASS (JJ,JCOMP) )
        PCONV_ROOF_BLD(JJ,JCOMP)  = ZCHTC_IN_ROOF(JJ,JCOMP) * ( ZTI_ROOF_CONV(JJ) - PTI_BLD  (JJ,JCOMP) )
        !
        ZRAD_ROOF_FLOOR(JJ) = ZRAD_ROOF_FLOOR(JJ) + PFRACOMP(JJ,JCOMP) * PRAD_ROOF_FLOOR(JJ,JCOMP)
        ZRAD_ROOF_MASS(JJ)  = ZRAD_ROOF_MASS(JJ)  + PFRACOMP(JJ,JCOMP) * PRAD_ROOF_MASS(JJ,JCOMP)
        PRAD_ROOF_WALL(JJ)  = PRAD_ROOF_WALL(JJ)  + PFRACOMP(JJ,JCOMP) * ZCOMP_RAD_ROOF_WALL(JJ,JCOMP)
        PRAD_ROOF_WIN(JJ)   = PRAD_ROOF_WIN(JJ)   + PFRACOMP(JJ,JCOMP) * ZCOMP_RAD_ROOF_WIN(JJ,JCOMP)
        ZCONV_ROOF_BLD(JJ)  = ZCONV_ROOF_BLD(JJ)  + PFRACOMP(JJ,JCOMP) * PCONV_ROOF_BLD(JJ,JCOMP)
        !
     ENDDO
     !
     ! Robert: The radiative fluxes need to be multiplied 
     !         with the respective view factors
     !
     PFLX_BLD_ROOF(JJ)  =                         - &
        PF_FLOOR_WALL(JJ) * PRAD_ROOF_WALL(JJ)  - &
        PF_FLOOR_WIN (JJ) * PRAD_ROOF_WIN(JJ)   - &
        PF_FLOOR_ROOF(JJ) * ZRAD_ROOF_FLOOR(JJ) - &
        PF_FLOOR_MASS(JJ) * ZRAD_ROOF_MASS(JJ)  - &
        ZCONV_ROOF_BLD(JJ)                      + &
        PLOAD_IN_ROOF(JJ) 
     !
  ENDSELECT
  !
  !*      8.     Infra-red radiation absorbed by roofs
  !              -------------------------------------
  !
  !* radiative surface temperature at intermediate time step
  ZTRAD_ROOF(JJ) = ( ZTS_ROOF(JJ)**4 + &
                   4.*ZIMPL*ZTS_ROOF(JJ)**3 * (PT_ROOF(JJ,1) - ZTS_ROOF(JJ)) )**0.25
  !
  !* absorbed LW
  PABS_LW_ROOF(JJ) = PEMIS_ROOF(JJ) * (PLW_RAD(JJ) - XSTEFAN * ZTRAD_ROOF(JJ)** 4)
  !
  !*      9.     Sensible heat flux between snow free roof and air
  !              -------------------------------------------------
  !
  !* aerodynamic surface temperature at the intermediate time step
  ZTAER_ROOF(JJ) = ZEXPL * ZTS_ROOF(JJ) + ZIMPL * PT_ROOF(JJ,1)
  PHFREE_ROOF(JJ) = ZRHO_ACF_ROOF(JJ) * XCPD * &
                   ( ZTAER_ROOF(JJ)/PEXNS(JJ) - PTA(JJ)/PEXNA(JJ) )
  !
  PHEAT_RR_ROOF(JJ) = PRR(JJ) * XCL * (ZTAER_ROOF(JJ) - PTA(JJ))
  !
  !*      10.     Latent heat flux between snow free roof and air
  !              -------------------------------------------------
  !
  PLEFREE_ROOF(JJ) = ZRHO_ACF_ROOF_WAT(JJ) * XLVTT * PDELT_ROOF(JJ) * &
                     ( PQSAT_ROOF(JJ) - PQA(JJ) +                     &
                       ZIMPL * ZDQSAT_ROOF(JJ) * (PT_ROOF(JJ,1) - ZTS_ROOF(JJ)) ) 
  !
  ! Limitation of PLEFREE_ROOF(JJ) to the maximum 
  ! available water on the snow-free roof
  ! The excess latent heat flux is added to the waste heat flux
  !
  IF (PLEFREE_ROOF(JJ).GT.ZWATROOFMAX(JJ)) THEN
     PLEFLIM_ROOF(JJ)=PLEFREE_ROOF(JJ)-ZWATROOFMAX(JJ)
     PLEFREE_ROOF(JJ)=ZWATROOFMAX(JJ)
  ELSE
     PLEFLIM_ROOF(JJ)=0.0
  ENDIF
  !
  !      13.     Energy imbalance for verification
  !              ---------------------------------
  !
  ZIMB_ROOF(JJ) = (1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PABS_SW_ROOF(JJ) + &
       (1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PABS_LW_ROOF(JJ)            - &
        PDQS_ROOF(JJ)                                                  - &
       (1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PHFREE_ROOF(JJ)             - &
       (1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PLEFLIM_ROOF(JJ)            - &
       (1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PLEFREE_ROOF(JJ)            + &
       (1.-PFRAC_GR(JJ)) * PDN_ROOF (JJ) * PGSNOW_ROOF(JJ)             + &
        PFLX_BLD_ROOF(JJ)                                              - &
        PHEAT_RR_ROOF(JJ)                                              + &
        PFRAC_GR(JJ)      * PG_GREENROOF_ROOF(JJ)
   !
   IF (ISNAN(ZIMB_ROOF(JJ))) CALL ABOR1_SFX("NAN detected in roof_layer_e_budget")
   !
   IF (ABS(ZIMB_ROOF(JJ)).GT.1.0E-3) THEN
      !
      CALL GET_LUOUT(HPROGRAM,ILUOUT)
      !
      WRITE(ILUOUT,*) "                                       "
      WRITE(ILUOUT,*) "In roof_layer_e_budget :               "
      WRITE(ILUOUT,*) "JJ                     : ",JJ
      WRITE(ILUOUT,*) "ABS_SW (W/m²(roof))    : ",(1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PABS_SW_ROOF(JJ)
      WRITE(ILUOUT,*) "ABS_LW (W/m²(roof))    : ",(1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PABS_LW_ROOF(JJ)
      WRITE(ILUOUT,*) "DQS    (W/m²(roof))    : ",PDQS_ROOF(JJ)
      WRITE(ILUOUT,*) "HFREE  (W/m²(roof))    : ",(1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PHFREE_ROOF(JJ)
      WRITE(ILUOUT,*) "LEFREE (W/m²(roof))    : ",(1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PLEFREE_ROOF(JJ) 
      WRITE(ILUOUT,*) "LELIM  (W/m²(roof))    : ",(1.-PFRAC_GR(JJ)) * ZDF_ROOF (JJ) * PLEFLIM_ROOF(JJ)
      WRITE(ILUOUT,*) "GSNOW  (W/m²(roof))    : ",(1.-PFRAC_GR(JJ)) * PDN_ROOF (JJ) * PGSNOW_ROOF(JJ)
      WRITE(ILUOUT,*) "FLXBLD (W/m²(roof))    : ",PFLX_BLD_ROOF(JJ)
      WRITE(ILUOUT,*) "HEATRR (W/m²(roof))    : ",PHEAT_RR_ROOF(JJ)
      WRITE(ILUOUT,*) "FLXGRE (W/m²(roof))    : ",PFRAC_GR(JJ)*PG_GREENROOF_ROOF(JJ)
      WRITE(ILUOUT,*) "---------------------------------------------"
      WRITE(ILUOUT,*) "ZIMB (W/m²(roof))      : ",ZIMB_ROOF(JJ)
      CALL FLUSH(ILUOUT)
      !
      CALL ABOR1_SFX('Too large energy budget imbalance of roof')
      !
  ENDIF
  !
ENDDO
!
!*      11.     New saturated specified humidity near the roof surface
!              ------------------------------------------------------
!
PQSAT_ROOF(:) =  QSAT(PT_ROOF(:,1),PPS(:))
!
!-------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('ROOF_LAYER_E_BUDGET',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------
!
END SUBROUTINE ROOF_LAYER_E_BUDGET
