!     #########
      SUBROUTINE READ_PGD_TEB_n (DTCO, U, TM, GCP, &
                                 HPROGRAM)
!     #########################################
!
!!****  *READ_PGD_TEB_n* - reads TEB physiographic fields
!!                       
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!!      M. Moge     02/2015 READ_SURF // + MPPDB_CHECK
!!      E. Redon & A. Lemonsu 03/2014 add URBTREE : key to use urban trees and green walls
!!					  SHAPE_HVEG : key for shape of crown of urban trees
!!      M. Moge     02/2015 READ_SURF
!!      M. Goret     02/2017 :add CO2 conversion factors
!!      M. Goret     04/2017 :add NTIME_CHANGE
!!      M. Goret     05/2017 :add traffic cycle
!-----------------------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_TEB_GRID_n, ONLY : TEB_GRID_t
USE MODD_SURFEX_n, ONLY : TEB_MODEL_t
USE MODD_GRID_CONF_PROJ, ONLY : GRID_CONF_PROJ_t
!
USE MODD_TYPE_DATE_SURF
!
USE MODD_DATA_COVER_PAR, ONLY : JPCOVER
!
!
USE MODE_READ_SURF_COV, ONLY : READ_SURF_COV
!
USE MODI_READ_SURF
USE MODI_READ_GRID
USE MODI_READ_LCOVER
USE MODI_READ_PGD_TEB_PAR_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_GET_TYPE_DIM_n
!
USE MODI_READ_LECOCLIMAP
!
#ifdef MNH_PARALLEL
USE MODI_GET_LUOUT
USE MODE_MPPDB
!
#endif
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(TEB_MODEL_t), INTENT(INOUT) :: TM
TYPE(GRID_CONF_PROJ_t),INTENT(INOUT) :: GCP
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! calling program
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! Error code after redding
#ifdef MNH_PARALLEL
INTEGER :: ILUOUT  ! output listing logical unit
#endif
!
 CHARACTER(LEN=LEN_HREC) :: YRECFM         ! Name of the article to be read
INTEGER           :: IVERSION
INTEGER           :: IBUGFIX
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!* 1D physical dimension
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_N',0,ZHOOK_HANDLE)
!
#ifdef MNH_PARALLEL
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
#endif
!
YRECFM='SIZE_TOWN'
 CALL GET_TYPE_DIM_n(DTCO, U, &
                     'TOWN  ',TM%TG%NDIM)
!
!*       2.     Other dimension initializations:
!               --------------------------------
!
 CALL READ_SURF(&
                HPROGRAM,'VERSION',IVERSION,IRESP)
 CALL READ_SURF(&
                HPROGRAM,'BUG',IBUGFIX,IRESP)
!
!* number of TEB patches
!
IF (IVERSION<7 .OR. IVERSION==7 .AND. IBUGFIX<=2) THEN
  TM%TOP%NTEB_PATCH=1
ELSE
  YRECFM='TEB_PATCH'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%NTEB_PATCH,IRESP)
END IF
!
!* number of road and roof layers
!
YRECFM='ROAD_LAYER'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%NROAD_LAYER,IRESP)

YRECFM='ROOF_LAYER'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%NROOF_LAYER,IRESP)

YRECFM='WALL_LAYER'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%NWALL_LAYER,IRESP)
!
! New option of soil vertical discretization
!
YRECFM='ROAD_GRID'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%CROAD_GRID,IRESP)
!
!* number of change of the legal time
!
YRECFM='NTIME_CHANGE'
CALL READ_SURF(HPROGRAM,YRECFM,TM%TOP%NTIME_CHANGE,IRESP)
!
YRECFM='TRAF_MONTHLY'
CALL READ_SURF(HPROGRAM,YRECFM,TM%TOP%XTRAF_MONTHLY,IRESP,YRECFM,'-')
!
YRECFM='TRAF_DAILY'
CALL READ_SURF(HPROGRAM,YRECFM,TM%TOP%XTRAF_DAILY,IRESP,YRECFM,'-')
!
YRECFM='TRAF_HOURLY'
CALL READ_SURF(HPROGRAM,YRECFM,TM%TOP%XTRAF_HOURLY,IRESP,YRECFM,'-')
!
!* type of averaging for Buildings (to allow ascendant compatibility)
!* type of Building Energy Model
!
IF (IVERSION<7 .OR.( IVERSION==7 .AND. IBUGFIX<=2)) THEN
  TM%TOP%CBLD_ATYPE='ARI'
  TM%TOP%CBEM = 'DEF'
ELSE
  YRECFM='BLD_ATYPE'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%CBLD_ATYPE,IRESP)
  YRECFM='BEM'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%CBEM,IRESP)
END IF
!
IF (TM%TOP%CBEM=="BEM") THEN
  !
  YRECFM='FLOOR_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%BOP%NFLOOR_LAYER,IRESP)
  YRECFM='MASS_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%BOP%NMASS_LAYER,IRESP)
  YRECFM='BEMCOMP'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%BOP%NBEMCOMP,IRESP)
  YRECFM='COOL_COIL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%BOP%CCOOL_COIL,IRESP)
  YRECFM='HEAT_COIL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%BOP%CHEAT_COIL,IRESP)
  YRECFM='AUTOSIZE'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%BOP%LAUTOSIZE,IRESP)
  !
  ! CO2 conversion factors
  !
  YRECFM='CF_ELEC'
  CALL READ_SURF(&
                 HPROGRAM,YRECFM,TM%BOP%XCF_CO2_ELEC,IRESP)
  YRECFM='CF_GAS'
  CALL READ_SURF(&
                 HPROGRAM,YRECFM,TM%BOP%XCF_CO2_GAS,IRESP)
  YRECFM='CF_FUEL'
  CALL READ_SURF(&
                 HPROGRAM,YRECFM,TM%BOP%XCF_CO2_FUEL,IRESP)
  YRECFM='CF_OTHER'
  CALL READ_SURF(&
                 HPROGRAM,YRECFM,TM%BOP%XCF_CO2_OTHER,IRESP)
ELSE
  TM%BOP%NBEMCOMP=1
ENDIF
!
!* Cases of urban green roofs & street trees & hydrology
!
IF (TM%TOP%LGARDEN) THEN
        !* Case of green roofs
  IF (IVERSION<7 .OR.( IVERSION==7 .AND. IBUGFIX<=2)) THEN
    TM%TOP%LGREENROOF = .FALSE.
  ELSE
    YRECFM='LGREENROOF'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%LGREENROOF,IRESP)
  END IF
  !* Case of street trees
  IF (IVERSION<8) THEN
    TM%TOP%CURBTREE = 'NONE'
  ELSE
    YRECFM='URBTREE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%CURBTREE,IRESP)
  END IF
  !* Case of urban hydrology
  IF (IVERSION<7 .OR.( IVERSION==7 .AND. IBUGFIX<=3)) THEN
    TM%TOP%LURBHYDRO = .FALSE.
  ELSE
    YRECFM='LURBHYDRO'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%LURBHYDRO,IRESP)
  END IF
ENDIF
!
!* Solar panels
!
IF (IVERSION<7 .OR.( IVERSION==7 .AND. IBUGFIX<=3)) THEN
  TM%TOP%LSOLAR_PANEL = .FALSE.
ELSE
  YRECFM='SOLAR_PANEL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%LSOLAR_PANEL,IRESP)
END IF
!
!
!
!*       3.     Physiographic data fields:
!               -------------------------
!
!* cover classes
!
ALLOCATE(TM%TOP%LCOVER(JPCOVER))
 CALL READ_LCOVER(&
                  HPROGRAM,TM%TOP%LCOVER)
!
ALLOCATE(TM%TOP%XCOVER(TM%TG%NDIM,COUNT(TM%TOP%LCOVER)))
#ifdef MNH_PARALLEL
 CALL READ_SURF_COV(&
                    HPROGRAM,'COVER',TM%TOP%XCOVER(:,:),TM%TOP%LCOVER,IRESP,HDIR='H')
 CALL MPPDB_CHECK_SURFEX3D(TM%TOP%XCOVER,"READ_PGD_TEB_n after READ_SURF:XCOVER",PRECISION,ILUOUT, 'TOWN  ',SIZE(TM%TOP%XCOVER,2))
#else
 CALL READ_SURF_COV(&
                    HPROGRAM,'COVER',TM%TOP%XCOVER(:,:),TM%TOP%LCOVER,IRESP)
#endif
!
!* orography
!
ALLOCATE(TM%TOP%XZS(TM%TG%NDIM))
!
YRECFM='ZS'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,TM%TOP%XZS(:),IRESP)
!
!
!* latitude, longitude 
!
ALLOCATE(TM%TG%XLAT      (TM%TG%NDIM))
ALLOCATE(TM%TG%XLON      (TM%TG%NDIM))
ALLOCATE(TM%TG%XMESH_SIZE(TM%TG%NDIM))
 CALL READ_GRID(&
                HPROGRAM,TM%TG%CGRID,TM%TG%XGRID_PAR,&
                TM%TG%XLAT,TM%TG%XLON,TM%TG%XMESH_SIZE,IRESP)
!
!
!-------------------------------------------------------------------------------
!
!*       4.     Physiographic data fields not to be computed by ecoclimap
!               ---------------------------------------------------------
!
 CALL READ_LECOCLIMAP(&
                      HPROGRAM,TM%TOP%LECOCLIMAP)
!
 CALL READ_PGD_TEB_PAR_n(DTCO, U, GCP, &
                         TM%BDD, TM%DTB, TM%DTT, TM%TG, TM%TOP, TM%BOP, &
                         HPROGRAM,TM%TG%NDIM,'-')
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_N',1,ZHOOK_HANDLE)
!
!
!------------------------------------------------------------------------------
!
END SUBROUTINE READ_PGD_TEB_n
