!     #########
      SUBROUTINE READ_PGD_TEB_PAR_n (DTCO, U,GCP, &
                                      BDD, DTB, DTT, TG, TOP, BOP, &
                                     HPROGRAM,KNI,HDIRIN)
!     ################################################
!
!!****  *READ_PGD_TEB_PAR_n* - reads ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    05/2005
!!        V. Masson 08/2013 adds solar panels
!!        M. Goret  02/2017 adds CO2 flux
!!        M. Goret  04/2017 suppress EFF_HEAT
!!        M. Goret  10/2017 add hot water
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!

!
!
!
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_TEB_GRID_n, ONLY : TEB_GRID_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
USE MODD_BEM_OPTION_n, ONLY : BEM_OPTIONS_t
USE MODD_GRID_CONF_PROJ, ONLY : GRID_CONF_PROJ_t
!
USE MODI_READ_SURF
USE MODI_READ_BLD_DESCRIPTION_n
USE MODI_GET_LUOUT
USE MODI_BLDCODE
USE MODI_ABOR1_SFX
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(TEB_GRID_t), INTENT(INOUT) :: TG
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
TYPE(BEM_OPTIONS_t), INTENT(INOUT) :: BOP
TYPE(GRID_CONF_PROJ_t),INTENT(INOUT) :: GCP
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
INTEGER,           INTENT(IN)  :: KNI      ! size of the new domain
 CHARACTER(LEN=1),  INTENT(IN)  :: HDIRIN
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: ILUOUT         ! output listing logical unit
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=LEN_HREC) :: YRECFM   ! Name of the article to be read
INTEGER           :: JJ             ! loop index
INTEGER           :: JLAYER         ! loop index
INTEGER           :: JCOMP          ! loop index
INTEGER           :: JSCHED         ! loop index
!
INTEGER           :: IVERSION       ! surface version
INTEGER           :: IBUGFIX        ! surface bugfix version
REAL, DIMENSION(TG%NDIM) :: ZWORK      ! work array
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N',0,ZHOOK_HANDLE)
!
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
YRECFM='VERSION'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,IVERSION,IRESP)
YRECFM='BUG'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,IBUGFIX,IRESP)
!
IF (IVERSION<7 .AND. .NOT.TOP%LECOCLIMAP) THEN
  !
  DTT%LDATA_BLDTYPE     = .FALSE.
  DTT%LDATA_IND_BLD_AGE = .FALSE.
  DTT%LDATA_COL_BLD_AGE = .FALSE.
  DTT%LDATA_USETYPE     = .FALSE.
  DTT%LDATA_P1TERRITORY = .FALSE.
  DTT%LDATA_PXTERRITORY = .FALSE.
  DTT%LDATA_FRACIHS     = .FALSE.
  DTT%LDATA_FRACCHS     = .FALSE.
  DTT%LDATA_FRACCOM     = .FALSE.
  DTT%LDATA_FRACTER     = .FALSE.
  DTT%LDATA_FRACIND     = .FALSE.
  DTT%LDATA_FRACNHE     = .FALSE.  
  DTT%LDATA_FRACPAV     = .FALSE.
  DTT%LDATA_FRACMRI     = .FALSE.
  DTT%LDATA_FRACHRI     = .FALSE.
  DTT%LDATA_FRACATB     = .FALSE.
  DTT%LDATA_FOEQI_MAIS     = .FALSE.
  DTT%LDATA_FOEQI_APPT     = .FALSE.
  DTT%LDATA_FAEQI_MAIS     = .FALSE.
  DTT%LDATA_FAEQI_APPT     = .FALSE.
  DTT%LDATA_CRE_MAIS    = .FALSE.
  DTT%LDATA_CRE_APPT    = .FALSE.
  DTT%LDATA_Z0_TOWN     = .TRUE.
  DTT%LDATA_BLD         = .TRUE.
  DTT%LDATA_GARDEN      = .TRUE.
  DTT%LDATA_GREENROOF   = .TRUE.
  DTT%LDATA_ROAD_DIR    = .FALSE.
  DTT%LDATA_ALB_ROOF    = .TRUE.
  DTT%LDATA_EMIS_ROOF   = .TRUE.
  DTT%LDATA_HC_ROOF     = .TRUE.
  DTT%LDATA_TC_ROOF     = .TRUE.
  DTT%LDATA_D_ROOF      = .TRUE.
  DTT%LDATA_ALB_ROAD    = .TRUE.
  DTT%LDATA_EMIS_ROAD   = .TRUE.
  DTT%LDATA_HC_ROAD     = .TRUE.
  DTT%LDATA_TC_ROAD     = .TRUE.
  DTT%LDATA_D_ROAD      = .TRUE.
  DTT%LDATA_ALB_WALL    = .TRUE.
  DTT%LDATA_EMIS_WALL   = .TRUE.
  DTT%LDATA_HC_WALL     = .TRUE.
  DTT%LDATA_TC_WALL     = .TRUE.
  DTT%LDATA_D_WALL      = .TRUE.
  DTT%LDATA_BLD_HEIGHT  = .TRUE.
  DTT%LDATA_WALL_O_HOR  = .TRUE.
  DTT%LDATA_H_TRAFFIC   = .TRUE.
  DTT%LDATA_LE_TRAFFIC  = .TRUE.
  DTT%LDATA_H_INDUSTRY  = .TRUE.
  DTT%LDATA_LE_INDUSTRY = .TRUE.
  DTT%LDATA_ROUGH_ROOF  = .FALSE.
  DTT%LDATA_ROUGH_WALL  = .FALSE.
  !
ELSEIF (IVERSION>=7) THEN
  !
  IF (IVERSION>7 .OR. IBUGFIX>=3) THEN
    YRECFM='L_BLDTYPE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_BLDTYPE,IRESP)
    YRECFM='L_IBLDAGE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_IND_BLD_AGE,IRESP)
    YRECFM='L_CBLDAGE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_COL_BLD_AGE,IRESP)
    YRECFM='L_USETYPE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_USETYPE,IRESP)
    YRECFM='L_P1TERR'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_P1TERRITORY,IRESP)
    YRECFM='L_PXTERR'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_PXTERRITORY,IRESP)
    YRECFM='L_FRACIHS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACIHS,IRESP)
    YRECFM='L_FRACCHS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACCHS,IRESP)
    YRECFM='L_FRACCOM'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACCOM,IRESP)
    YRECFM='L_FRACTER'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACTER,IRESP)
    YRECFM='L_FRACIND'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACIND,IRESP)
    YRECFM='L_FRACNHE'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACNHE,IRESP)    
    YRECFM='L_FRACPAV'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACPAV,IRESP)
    YRECFM='L_FRACMRI'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACMRI,IRESP)
    YRECFM='L_FRACHRI'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACHRI,IRESP)
    YRECFM='L_FRACATB'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRACATB,IRESP)
    YRECFM='L_FOEQI_MAIS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FOEQI_MAIS,IRESP)
    YRECFM='L_FOEQI_APPT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FOEQI_APPT,IRESP)
    YRECFM='L_FAEQI_MAIS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FAEQI_MAIS,IRESP)
    YRECFM='L_FAEQI_APPT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FAEQI_APPT,IRESP)
    YRECFM='L_CRE_MAIS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_CRE_MAIS,IRESP)
    YRECFM='L_CRE_APPT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_CRE_APPT,IRESP)
    !
    IF (DTT%LDATA_BLDTYPE.OR.DTT%LDATA_IND_BLD_AGE.OR.DTT%LDATA_COL_BLD_AGE.OR.&
        DTT%LDATA_USETYPE.OR.DTT%LDATA_P1TERRITORY.OR.DTT%LDATA_PXTERRITORY) THEN
        CALL READ_BLD_DESCRIPTION_n(BDD, HPROGRAM)
    ENDIF
    !
  ENDIF
  YRECFM='L_Z0_TOWN'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_Z0_TOWN,IRESP)
  YRECFM='L_BLD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_BLD,IRESP)
  IF (IVERSION>=6) THEN
    YRECFM='L_GARDEN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_GARDEN,IRESP)
  ENDIF
  IF (IVERSION==7 .AND. IBUGFIX<=2) THEN
    DTT%LDATA_ROAD_DIR = .FALSE.
    DTT%LDATA_GREENROOF= .FALSE.
  ELSE
    YRECFM='L_ROAD_DIR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ROAD_DIR,IRESP)
    YRECFM='L_GREENROOF'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_GREENROOF,IRESP)
  END IF
  IF (IVERSION==7 .AND. IBUGFIX<=3) THEN
    DTT%LDATA_EMIS_PANEL = .FALSE.
    DTT%LDATA_ALB_PANEL  = .FALSE.
    DTT%LDATA_EFF_PANEL  = .FALSE.
    DTT%LDATA_FRAC_PANEL = .FALSE.
  ELSE
    YRECFM='L_EMIS_PANEL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EMIS_PANEL,IRESP)
    YRECFM='L_ALB_PANEL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ALB_PANEL,IRESP)
    YRECFM='L_EFF_PANEL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EFF_PANEL,IRESP)
    YRECFM='L_FRAC_PANEL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_FRAC_PANEL,IRESP)
  END IF
  YRECFM='L_ALB_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ALB_ROOF,IRESP)
  YRECFM='L_EMIS_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EMIS_ROOF,IRESP)
  YRECFM='L_HC_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_HC_ROOF,IRESP)
  YRECFM='L_TC_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_TC_ROOF,IRESP)
  YRECFM='L_D_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_D_ROOF,IRESP)
  YRECFM='L_ALB_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ALB_ROAD,IRESP)
  YRECFM='L_EMIS_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EMIS_ROAD,IRESP)
  YRECFM='L_HC_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_HC_ROAD,IRESP)
  YRECFM='L_TC_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_TC_ROAD,IRESP)
  YRECFM='L_D_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_D_ROAD,IRESP)
  YRECFM='L_ALB_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ALB_WALL,IRESP)
  YRECFM='L_EMIS_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EMIS_WALL,IRESP)
  YRECFM='L_HC_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_HC_WALL,IRESP)
  YRECFM='L_TC_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_TC_WALL,IRESP)
  YRECFM='L_D_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_D_WALL,IRESP)
  YRECFM='L_BLD_HEIGHT'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_BLD_HEIGHT,IRESP)
  YRECFM='L_WALL_O_HOR'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_WALL_O_HOR,IRESP)
  YRECFM='L_H_TRAF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_H_TRAFFIC,IRESP)
  YRECFM='L_LE_TRAF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_LE_TRAFFIC,IRESP)
  YRECFM='L_H_IND'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_H_INDUSTRY,IRESP)
  YRECFM='L_LE_IND'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_LE_INDUSTRY,IRESP)
  YRECFM='L_NB_POP'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_NB_POP,IRESP)
  YRECFM='L_SFCO2_RD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_SFCO2_RD,IRESP)
  YRECFM='L_DELTA_LEGAL_TIME'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_DELTA_LEGAL_TIME,IRESP)
  YRECFM='L_TIME_OF_CHANGE'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_TIME_OF_CHANGE,IRESP)

  IF (IVERSION>7 .OR. IBUGFIX>=3) THEN
    YRECFM='L_ROUGH_ROOF'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ROUGH_ROOF,IRESP)
    YRECFM='L_ROUGH_WALL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ROUGH_WALL,IRESP)
  ENDIF
  !
  IF (TOP%CBEM=='BEM') THEN
    YRECFM='L_RESIDENTIAL'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_RESIDENTIAL,IRESP)     
    YRECFM='L_FRACOMP'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FRACOMP,IRESP)
    YRECFM='L_HC_FLOOR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_HC_FLOOR,IRESP)
    YRECFM='L_TC_FLOOR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_TC_FLOOR,IRESP)
    YRECFM='L_D_FLOOR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_D_FLOOR,IRESP)            
    YRECFM='L_HC_MASS'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_HC_MASS,IRESP)
    YRECFM='L_TC_MASS'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_TC_MASS,IRESP)
    YRECFM='L_D_MASS'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_D_MASS,IRESP)  
    YRECFM='L_F_WAST_CAN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_F_WASTE_CAN,IRESP)
    YRECFM='L_QIN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_QIN,IRESP)
    YRECFM='L_QIN_FRAD'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_QIN_FRAD,IRESP)
    YRECFM='L_SHGC'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_SHGC,IRESP)
    YRECFM='L_U_WIN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_U_WIN,IRESP)
    YRECFM='L_GR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_GR,IRESP)
    YRECFM='L_SHGC_SH'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_SHGC_SH,IRESP)    
    YRECFM='L_FLOOR_HEIG'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_FLOOR_HEIGHT,IRESP)
    YRECFM='L_N50'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_N50,IRESP)
    YRECFM='L_FWAT_COND'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_F_WATER_COND,IRESP)
    YRECFM='L_ISMECH'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_ISMECH,IRESP) 
    YRECFM='L_MECHRATE'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_MECHRATE,IRESP)
    YRECFM='L_SHADEARCHI'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_SHADEARCHI,IRESP)
    YRECFM='L_NATVENT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_NATVENT,IRESP) 
    YRECFM='L_FSNIG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FSNIG,IRESP)
    YRECFM='L_FVNIG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FVNIG,IRESP)
    YRECFM='L_MODQ_VCD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_MODQIN_VCD,IRESP)
    YRECFM='L_MODQ_VLD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_MODQIN_VLD,IRESP)
    YRECFM='L_MODQ_NIG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_MODQIN_NIG,IRESP)
    YRECFM='L_TDESV'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_TDESV,IRESP)
    YRECFM='L_TC_OCCD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_TCOOL_OCCD,IRESP)
    YRECFM='L_TC_OCCN'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_TCOOL_OCCN,IRESP)
    YRECFM='L_TC_VCDD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_TCOOL_VCDD,IRESP)
    YRECFM='L_TC_VCDN'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_TCOOL_VCDN,IRESP)
    YRECFM='L_TC_VCLD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_TCOOL_VCLD,IRESP)
    YRECFM='L_TH_OCCD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_THEAT_OCCD,IRESP)
    YRECFM='L_TH_OCCN'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_THEAT_OCCN,IRESP)
    YRECFM='L_TH_VCDD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_THEAT_VCDD,IRESP)
    YRECFM='L_TH_VCDN'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_THEAT_VCDN,IRESP)
    YRECFM='L_TH_VCLD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_THEAT_VCLD,IRESP)   
    YRECFM='L_QIN_FLAT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_QIN_FLAT,IRESP)
    YRECFM='L_HR_TARGET'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_HR_TARGET,IRESP)
    YRECFM='L_CAP_SYS_HE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_CAP_SYS_HEAT,IRESP)
    YRECFM='L_CAP_SYS_RA'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_CAP_SYS_RAT,IRESP)
    YRECFM='L_T_ADP'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_T_ADP,IRESP)
    YRECFM='L_M_SYS_RAT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_M_SYS_RAT,IRESP)
    YRECFM='L_COP_RAT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_COP_RAT,IRESP)
    YRECFM='L_T_SIZE_MAX'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_T_SIZE_MAX,IRESP)
    YRECFM='L_T_SIZE_MIN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_T_SIZE_MIN,IRESP)
    YRECFM='L_WIN_SW_MAX'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_WIN_SW_MAX,IRESP)
    YRECFM='L_FOPEN'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FOPEN,IRESP)
    YRECFM='L_FVSUM'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FVSUM,IRESP)
    YRECFM='L_FVVAC'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FVVAC,IRESP)
    YRECFM='L_FSSUM'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FSSUM,IRESP)
    YRECFM='L_FSVAC'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FSVAC,IRESP)
    YRECFM='L_DAYBEGS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_DAYWBEG_SCHED,IRESP)
    YRECFM='L_HOUBEGS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_HOURBEG_SCHED,IRESP)
    YRECFM='L_PROBOCC'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_PROBOCC,IRESP)
    YRECFM='L_BEG_HOLIDAY'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_BEG_HOLIDAY,IRESP)
    YRECFM='L_END_HOLIDAY'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_END_HOLIDAY,IRESP)
    YRECFM='L_MOD_HOLIDAY'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_MOD_HOLIDAY,IRESP)
    YRECFM='L_FRAC_HELEC'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT_ELEC,IRESP)
    YRECFM='L_FRAC_HGAS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT_GAS,IRESP)
    YRECFM='L_FRAC_HFUEL'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT_FUEL,IRESP)
    YRECFM='L_FRAC_HOTHR'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT_OTHER,IRESP)
    YRECFM='L_FRAC_HEAT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_FRAC_HEAT,IRESP)
    YRECFM='L_F_HW_GAS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_F_HW_GAS,IRESP)
    YRECFM='L_HOTWAT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTB%LDATA_HOTWAT,IRESP)
    !
  ENDIF
  !  
  IF (IVERSION>7 .OR. IBUGFIX>=3) THEN
    YRECFM='L_FRAC_HVEG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRAC_HVEG,IRESP)
    YRECFM='L_FRAC_LVEG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRAC_LVEG,IRESP)
    YRECFM='L_FRAC_NVEG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTT%LDATA_FRAC_NVEG,IRESP)
  ENDIF
  !
ENDIF
!
!* read number of layers if thermal properties are specified
!
IF (DTT%LDATA_HC_ROOF) THEN
  YRECFM='PAR_RF_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='ROOF_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%NPAR_ROOF_LAYER,IRESP)
END IF
!
IF (DTT%LDATA_HC_ROAD) THEN
  YRECFM='PAR_RD_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='ROAD_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%NPAR_ROAD_LAYER,IRESP)
END IF
!
IF (DTT%LDATA_HC_WALL) THEN
  YRECFM='PAR_WL_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='WALL_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%NPAR_WALL_LAYER,IRESP)
END IF
!
IF (DTB%LDATA_HC_FLOOR) THEN
  YRECFM='PAR_FL_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='FLOOR_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%NPAR_FLOOR_LAYER,IRESP)
END IF
!
IF (DTB%LDATA_HC_MASS) THEN
  YRECFM='PAR_MA_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='FLOOR_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%NPAR_MASS_LAYER,IRESP)
END IF
!
!* read specified fields
!
IF (DTT%LDATA_BLDTYPE .AND. .NOT. DTT%LDATA_IND_BLD_AGE) THEN
  CALL ABOR1_SFX('FATAL ERROR: Building type is prescribed but not the building age')
END IF
!
IF (DTT%LDATA_BLDTYPE) THEN
  ALLOCATE(DTT%NPAR_BLDTYPE     (TG%NDIM))    
  YRECFM='D_BLDTYPE'
  CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
  DTT%NPAR_BLDTYPE(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_IND_BLD_AGE) THEN
  ALLOCATE(DTT%NPAR_IND_BLD_AGE     (TG%NDIM))    
  YRECFM='D_IBLDAGE'
  CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
  DTT%NPAR_IND_BLD_AGE(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_COL_BLD_AGE) THEN
  ALLOCATE(DTT%NPAR_COL_BLD_AGE     (TG%NDIM))    
  YRECFM='D_CBLDAGE'
  CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
  DTT%NPAR_COL_BLD_AGE(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_USETYPE) THEN
  ALLOCATE(DTT%NPAR_USETYPE     (TG%NDIM))    
  YRECFM='D_USETYPE'
  CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
  DTT%NPAR_USETYPE(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_P1TERRITORY) THEN
   ALLOCATE(DTT%NPAR_P1TERRITORY(TG%NDIM))
   YRECFM='D_P1TERR'
   CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
   DTT%NPAR_P1TERRITORY(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_PXTERRITORY) THEN
   ALLOCATE(DTT%NPAR_PXTERRITORY(TG%NDIM))
   YRECFM='D_PXTERR'
   CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
   DTT%NPAR_PXTERRITORY(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_BLDTYPE.AND.DTT%LDATA_BLDTYPE.AND.DTT%LDATA_USETYPE.AND. &
    DTT%LDATA_P1TERRITORY.AND.DTT%LDATA_PXTERRITORY) THEN
   !
   ALLOCATE(DTT%NPAR_BLDCODE(TG%NDIM))
   !
   ! Robert: A switch is made between the historical construction material territory
   !         and the recent building construction material territory.
   !
   DO JJ=1,TG%NDIM
      !
      IF ( (DTT%NPAR_BLDTYPE(JJ).NE.BDD%NDESC_POS_TYP_PD)  .AND. &
           (DTT%NPAR_BLDTYPE(JJ).NE.BDD%NDESC_POS_TYP_PSC) .AND. &
           (DTT%NPAR_BLDTYPE(JJ).NE.BDD%NDESC_POS_TYP_PCIO).AND. &
           (DTT%NPAR_BLDTYPE(JJ).NE.BDD%NDESC_POS_TYP_PCIF) ) THEN
         IF (DTT%NPAR_COL_BLD_AGE(JJ).EQ.BDD%NDESC_POS_AGE_P1) THEN
            CALL BLDCODE(DTT%NPAR_BLDTYPE(JJ),DTT%NPAR_COL_BLD_AGE(JJ),DTT%NPAR_USETYPE(JJ), &
                         DTT%NPAR_P1TERRITORY(JJ),DTT%NPAR_BLDCODE(JJ))
         ELSE
            CALL BLDCODE(DTT%NPAR_BLDTYPE(JJ),DTT%NPAR_COL_BLD_AGE(JJ),DTT%NPAR_USETYPE(JJ), &
                         DTT%NPAR_PXTERRITORY(JJ),DTT%NPAR_BLDCODE(JJ))
         ENDIF
      ELSE
         IF (DTT%NPAR_IND_BLD_AGE(JJ).EQ.BDD%NDESC_POS_AGE_P1) THEN
            CALL BLDCODE(DTT%NPAR_BLDTYPE(JJ),DTT%NPAR_IND_BLD_AGE(JJ),DTT%NPAR_USETYPE(JJ), &
                         DTT%NPAR_P1TERRITORY(JJ),DTT%NPAR_BLDCODE(JJ))
         ELSE
            CALL BLDCODE(DTT%NPAR_BLDTYPE(JJ),DTT%NPAR_IND_BLD_AGE(JJ),DTT%NPAR_USETYPE(JJ), &
                         DTT%NPAR_PXTERRITORY(JJ),DTT%NPAR_BLDCODE(JJ))
         ENDIF
      ENDIF
      !
   ENDDO
   !
END IF
!
IF (DTT%LDATA_FRACIHS) THEN
   ALLOCATE(DTT%XPAR_FRACIHS(TG%NDIM))
   YRECFM='D_FRACIHS'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACIHS,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACCHS) THEN
   ALLOCATE(DTT%XPAR_FRACCHS(TG%NDIM))
   YRECFM='D_FRACCHS'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACCHS,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACCOM) THEN
   ALLOCATE(DTT%XPAR_FRACCOM(TG%NDIM))
   YRECFM='D_FRACCOM'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACCOM,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACTER) THEN
   ALLOCATE(DTT%XPAR_FRACTER(TG%NDIM))
   YRECFM='D_FRACTER'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACTER,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACIND) THEN
   ALLOCATE(DTT%XPAR_FRACIND(TG%NDIM))
   YRECFM='D_FRACIND'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACIND,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACNHE) THEN
   ALLOCATE(DTT%XPAR_FRACNHE(TG%NDIM))
   YRECFM='D_FRACNHE'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACNHE,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACPAV) THEN
   ALLOCATE(DTT%XPAR_FRACPAV(TG%NDIM))
   YRECFM='D_FRACPAV'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACPAV,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACMRI) THEN
   ALLOCATE(DTT%XPAR_FRACMRI(TG%NDIM))
   YRECFM='D_FRACMRI'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACMRI,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACHRI) THEN
   ALLOCATE(DTT%XPAR_FRACHRI(TG%NDIM))
   YRECFM='D_FRACHRI'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACHRI,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRACATB) THEN
   ALLOCATE(DTT%XPAR_FRACATB(TG%NDIM))
   YRECFM='D_FRACATB'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FRACATB,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FOEQI_MAIS) THEN
   ALLOCATE(DTT%XPAR_FOEQI_MAIS(TG%NDIM))
   YRECFM='D_FOEQI_MAIS'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FOEQI_MAIS,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FOEQI_APPT) THEN
   ALLOCATE(DTT%XPAR_FOEQI_APPT(TG%NDIM))
   YRECFM='D_FOEQI_APPT'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FOEQI_APPT,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FAEQI_MAIS) THEN
   ALLOCATE(DTT%XPAR_FAEQI_MAIS(TG%NDIM))
   YRECFM='D_FAEQI_MAIS'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FAEQI_MAIS,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FAEQI_APPT) THEN
   ALLOCATE(DTT%XPAR_FAEQI_APPT(TG%NDIM))
   YRECFM='D_FAEQI_APPT'
   CALL READ_FIELD(YRECFM,DTT%XPAR_FAEQI_APPT,HDIRIN)
ENDIF
!
IF (DTT%LDATA_CRE_MAIS) THEN
   ALLOCATE(DTT%XPAR_CRE_MAIS(TG%NDIM))
   YRECFM='D_CRE_MAIS'
   CALL READ_FIELD(YRECFM,DTT%XPAR_CRE_MAIS,HDIRIN)
ENDIF
!
IF (DTT%LDATA_CRE_APPT) THEN
   ALLOCATE(DTT%XPAR_CRE_APPT(TG%NDIM))
   YRECFM='D_CRE_APPT'
   CALL READ_FIELD(YRECFM,DTT%XPAR_CRE_APPT,HDIRIN)
ENDIF
!
IF (DTT%LDATA_Z0_TOWN) THEN
  ALLOCATE(DTT%XPAR_Z0_TOWN     (TG%NDIM))
  YRECFM='D_Z0_TOWN'
  CALL READ_FIELD(YRECFM,DTT%XPAR_Z0_TOWN,HDIRIN)
ENDIF
!
IF (DTT%LDATA_BLD) THEN
  ALLOCATE(DTT%XPAR_BLD         (TG%NDIM))
  YRECFM='D_BLDFRA'
  CALL READ_FIELD(YRECFM,DTT%XPAR_BLD,HDIRIN)
ENDIF
!
IF (IVERSION>=6) THEN
  IF (DTT%LDATA_GARDEN) THEN
    ALLOCATE(DTT%XPAR_GARDEN      (TG%NDIM))
    YRECFM='D_GARDEN'
    CALL READ_FIELD(YRECFM,DTT%XPAR_GARDEN,HDIRIN)
  ENDIF
!
ENDIF
!
IF (DTT%LDATA_FRAC_HVEG) THEN
  ALLOCATE(DTT%XPAR_FRAC_HVEG    (TG%NDIM))
  YRECFM='D_FRAC_HVEG'
  CALL READ_FIELD(YRECFM,DTT%XPAR_FRAC_HVEG,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRAC_LVEG) THEN
  ALLOCATE(DTT%XPAR_FRAC_LVEG    (TG%NDIM))
  YRECFM='D_FRAC_LVEG'
  CALL READ_FIELD(YRECFM,DTT%XPAR_FRAC_LVEG,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRAC_NVEG) THEN
  ALLOCATE(DTT%XPAR_FRAC_NVEG    (TG%NDIM))
  YRECFM='D_FRAC_NVEG'
  CALL READ_FIELD(YRECFM,DTT%XPAR_FRAC_NVEG,HDIRIN)
ENDIF
!
! Recompute the fractions according to the Big Leaf approach
IF (TOP%LGARDEN) THEN
  ! Cas no URBTREE
  IF (TOP%CURBTREE=='NONE') THEN
    DO JJ=1,SIZE(DTT%XPAR_FRAC_HVEG)
      IF ((DTT%XPAR_FRAC_HVEG(JJ)+DTT%XPAR_FRAC_LVEG(JJ)+DTT%XPAR_FRAC_NVEG(JJ)).GT.0.) THEN
        DTT%XPAR_FRAC_HVEG(JJ) = DTT%XPAR_FRAC_HVEG(JJ) / &
                (DTT%XPAR_FRAC_HVEG(JJ)+DTT%XPAR_FRAC_LVEG(JJ)+DTT%XPAR_FRAC_NVEG(JJ))
        DTT%XPAR_FRAC_LVEG(JJ) = DTT%XPAR_FRAC_LVEG(JJ) / &
                (DTT%XPAR_FRAC_HVEG(JJ)+DTT%XPAR_FRAC_LVEG(JJ)+DTT%XPAR_FRAC_NVEG(JJ))
        DTT%XPAR_FRAC_NVEG(JJ) = DTT%XPAR_FRAC_NVEG(JJ) / &
                (DTT%XPAR_FRAC_HVEG(JJ)+DTT%XPAR_FRAC_LVEG(JJ)+DTT%XPAR_FRAC_NVEG(JJ))
      ELSE
        DTT%XPAR_FRAC_HVEG(JJ) = 0.
        DTT%XPAR_FRAC_LVEG(JJ) = 0.
        DTT%XPAR_FRAC_NVEG(JJ) = 0.
      ENDIF
    ENDDO
  ELSE IF (TOP%CURBTREE=='TREE') THEN
  ! Cas URBTREE
    DO JJ=1,SIZE(DTT%XPAR_FRAC_HVEG)
      IF ((1.-DTT%XPAR_BLD(JJ)).GT.0.) THEN
        DTT%XPAR_FRAC_HVEG(JJ) = DTT%XPAR_FRAC_HVEG(JJ) / (1. - DTT%XPAR_BLD(JJ))
      ELSE
        DTT%XPAR_FRAC_HVEG(JJ) = 0.
      ENDIF
      IF (DTT%XPAR_GARDEN(JJ).GT.0.) THEN
        DTT%XPAR_FRAC_LVEG(JJ) = DTT%XPAR_FRAC_LVEG(JJ) / DTT%XPAR_GARDEN(JJ)
        DTT%XPAR_FRAC_NVEG(JJ) = DTT%XPAR_FRAC_NVEG(JJ) / DTT%XPAR_GARDEN(JJ)
      ELSE
        DTT%XPAR_FRAC_LVEG(JJ) = 0.
        DTT%XPAR_FRAC_NVEG(JJ) = 0.
      ENDIF
    ENDDO
  ENDIF
ENDIF
!
IF (DTT%LDATA_GREENROOF) THEN
  ALLOCATE(DTT%XPAR_GREENROOF    (TG%NDIM))
  YRECFM='D_GREENROOF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_GREENROOF,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ROAD_DIR) THEN
  ALLOCATE(DTT%XPAR_ROAD_DIR    (TG%NDIM))
  YRECFM='D_ROAD_DIR'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ROAD_DIR,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ALB_ROOF) THEN
  ALLOCATE(DTT%XPAR_ALB_ROOF    (TG%NDIM))        
  YRECFM='D_ALB_ROOF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ALB_ROOF,HDIRIN)
ENDIF
!
IF (DTT%LDATA_EMIS_ROOF) THEN
  ALLOCATE(DTT%XPAR_EMIS_ROOF   (TG%NDIM))        
  YRECFM='D_EMI_ROOF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EMIS_ROOF,HDIRIN)
ENDIF
!
IF (DTT%LDATA_HC_ROOF) THEN
  ALLOCATE(DTT%XPAR_HC_ROOF     (TG%NDIM,DTT%NPAR_ROOF_LAYER))
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_ROOF',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_HC_ROOF(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_TC_ROOF) THEN
  ALLOCATE(DTT%XPAR_TC_ROOF     (TG%NDIM,DTT%NPAR_ROOF_LAYER))
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_ROOF',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_TC_ROOF(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_D_ROOF) THEN
  ALLOCATE(DTT%XPAR_D_ROOF      (TG%NDIM,DTT%NPAR_ROOF_LAYER))
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_ROOF',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_D_ROOF(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_ALB_ROAD) THEN
  ALLOCATE(DTT%XPAR_ALB_ROAD    (TG%NDIM))
  YRECFM='D_ALB_ROAD'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ALB_ROAD,HDIRIN)
ENDIF
!
IF (DTT%LDATA_EMIS_ROAD) THEN
  ALLOCATE(DTT%XPAR_EMIS_ROAD   (TG%NDIM))
  YRECFM='D_EMI_ROAD'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EMIS_ROAD,HDIRIN)
ENDIF
!
IF (DTT%LDATA_HC_ROAD) THEN
  ALLOCATE(DTT%XPAR_HC_ROAD     (TG%NDIM,DTT%NPAR_ROAD_LAYER))
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_ROAD',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_HC_ROAD(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_TC_ROAD) THEN
  ALLOCATE(DTT%XPAR_TC_ROAD     (TG%NDIM,DTT%NPAR_ROAD_LAYER))
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_ROAD',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_TC_ROAD(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_D_ROAD) THEN
  ALLOCATE(DTT%XPAR_D_ROAD      (TG%NDIM,DTT%NPAR_ROAD_LAYER))
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_ROAD',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_D_ROAD(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_ALB_WALL) THEN
  ALLOCATE(DTT%XPAR_ALB_WALL    (TG%NDIM))
  YRECFM='D_ALB_WALL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ALB_WALL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_EMIS_WALL) THEN
  ALLOCATE(DTT%XPAR_EMIS_WALL   (TG%NDIM))
  YRECFM='D_EMI_WALL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EMIS_WALL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_HC_WALL) THEN
  ALLOCATE(DTT%XPAR_HC_WALL     (TG%NDIM,DTT%NPAR_WALL_LAYER))
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_WALL',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_HC_WALL(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_TC_WALL) THEN
  ALLOCATE(DTT%XPAR_TC_WALL     (TG%NDIM,DTT%NPAR_WALL_LAYER))
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_WALL',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_TC_WALL(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_D_WALL) THEN
  ALLOCATE(DTT%XPAR_D_WALL      (TG%NDIM,DTT%NPAR_WALL_LAYER))
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_WALL',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_D_WALL(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_BLD_HEIGHT) THEN
  ALLOCATE(DTT%XPAR_BLD_HEIGHT  (TG%NDIM))
  YRECFM='D_BLD_HEIG'
  CALL READ_FIELD(YRECFM,DTT%XPAR_BLD_HEIGHT,HDIRIN)
ENDIF
!
IF (DTT%LDATA_WALL_O_HOR) THEN
  ALLOCATE(DTT%XPAR_WALL_O_HOR  (TG%NDIM))
  YRECFM='D_WALL_O_H'
  CALL READ_FIELD(YRECFM,DTT%XPAR_WALL_O_HOR,HDIRIN)
ENDIF
!
IF (DTT%LDATA_H_TRAFFIC) THEN
  ALLOCATE(DTT%XPAR_H_TRAFFIC   (TG%NDIM))
  YRECFM='D_H_TRAF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_H_TRAFFIC,HDIRIN)
ENDIF
!
IF (DTT%LDATA_LE_TRAFFIC) THEN
  ALLOCATE(DTT%XPAR_LE_TRAFFIC  (TG%NDIM))
  YRECFM='D_LE_TRAF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_LE_TRAFFIC,HDIRIN)
ENDIF
!
IF (DTT%LDATA_H_INDUSTRY) THEN
  ALLOCATE(DTT%XPAR_H_INDUSTRY  (TG%NDIM))
  YRECFM='D_H_IND'
  CALL READ_FIELD(YRECFM,DTT%XPAR_H_INDUSTRY,HDIRIN)
ENDIF
!
IF (DTT%LDATA_LE_INDUSTRY) THEN
  ALLOCATE(DTT%XPAR_LE_INDUSTRY (TG%NDIM))
  YRECFM='D_LE_IND'
  CALL READ_FIELD(YRECFM,DTT%XPAR_LE_INDUSTRY,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ROUGH_ROOF) THEN
  ALLOCATE(DTT%XPAR_ROUGH_ROOF (TG%NDIM))
  YRECFM='D_ROUGH_ROOF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ROUGH_ROOF,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ROUGH_WALL) THEN
  ALLOCATE(DTT%XPAR_ROUGH_WALL (TG%NDIM))
  YRECFM='D_ROUGH_WALL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ROUGH_WALL,HDIRIN)
ENDIF
!
! solar panels
!
IF (DTT%LDATA_EMIS_PANEL) THEN
  ALLOCATE(DTT%XPAR_EMIS_PANEL (TG%NDIM))
  YRECFM='D_EMIS_PANEL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EMIS_PANEL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ALB_PANEL) THEN
  ALLOCATE(DTT%XPAR_ALB_PANEL (TG%NDIM))
  YRECFM='D_ALB_PANEL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ALB_PANEL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_EFF_PANEL) THEN
  ALLOCATE(DTT%XPAR_EFF_PANEL (TG%NDIM))
  YRECFM='D_EFF_PANEL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EFF_PANEL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRAC_PANEL) THEN
  ALLOCATE(DTT%XPAR_FRAC_PANEL (TG%NDIM))
  YRECFM='D_FRAC_PANEL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_FRAC_PANEL,HDIRIN)
ENDIF
!
  IF (DTT%LDATA_NB_POP) THEN
     ALLOCATE(DTT%XPAR_NB_POP (TG%NDIM))
     YRECFM='D_NB_POP'
     CALL READ_FIELD(YRECFM,DTT%XPAR_NB_POP,HDIRIN)
  ENDIF
  !
  IF (DTT%LDATA_SFCO2_RD) THEN
     ALLOCATE(DTT%XPAR_SFCO2_RD (TG%NDIM))
     YRECFM='D_SFCO2_RD'
     CALL READ_FIELD(YRECFM,DTT%XPAR_SFCO2_RD,HDIRIN)
  ENDIF
  !
  IF (DTT%LDATA_DELTA_LEGAL_TIME) THEN
     ALLOCATE(DTT%XPAR_DELTA_LEGAL_TIME (TG%NDIM,TOP%NTIME_CHANGE+1))
     YRECFM='D_DELTA_LEGAL_TIME'
     CALL READ_FIELD_2D(YRECFM,DTT%XPAR_DELTA_LEGAL_TIME,HDIRIN)
  ENDIF
  !
  IF (DTT%LDATA_TIME_OF_CHANGE) THEN
     ALLOCATE(DTT%XPAR_TIME_OF_CHANGE (TOP%NTIME_CHANGE))
     YRECFM='D_TIME_OF_CHANGE'
     CALL READ_SURF(&
                 HPROGRAM,YRECFM,DTT%XPAR_TIME_OF_CHANGE,IRESP)
  ENDIF
!
!* Building Energy Model
!
IF (TOP%CBEM=='BEM') THEN
  !
  IF (DTB%LDATA_HC_FLOOR) THEN
    ALLOCATE(DTB%XPAR_HC_FLOOR    (TG%NDIM,DTB%NPAR_FLOOR_LAYER))
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A10,I1.1)') 'D_HC_FLOOR',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_HC_FLOOR(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_TC_FLOOR) THEN
    ALLOCATE(DTB%XPAR_TC_FLOOR    (TG%NDIM,DTB%NPAR_FLOOR_LAYER))
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A10,I1.1)') 'D_TC_FLOOR',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_TC_FLOOR(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_D_FLOOR) THEN
    ALLOCATE(DTB%XPAR_D_FLOOR     (TG%NDIM,DTB%NPAR_FLOOR_LAYER))
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A9,I1.1)') 'D_D_FLOOR',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_D_FLOOR(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_HC_MASS) THEN
    ALLOCATE(DTB%XPAR_HC_MASS    (TG%NDIM,DTB%NPAR_MASS_LAYER))
    DO JLAYER=1,DTB%NPAR_MASS_LAYER
      WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_MASS ',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_HC_MASS(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_TC_MASS) THEN
    ALLOCATE(DTB%XPAR_TC_MASS    (TG%NDIM,DTB%NPAR_MASS_LAYER))
    DO JLAYER=1,DTB%NPAR_MASS_LAYER
      WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_MASS ',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_TC_MASS(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_D_MASS) THEN
    ALLOCATE(DTB%XPAR_D_MASS     (TG%NDIM,DTB%NPAR_MASS_LAYER))
    DO JLAYER=1,DTB%NPAR_MASS_LAYER
      WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_MASS ',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_D_MASS(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_F_WASTE_CAN) THEN
    ALLOCATE(DTB%XPAR_F_WASTE_CAN   (TG%NDIM))
    YRECFM='D_F_WAST_CAN'
    CALL READ_FIELD(YRECFM,DTB%XPAR_F_WASTE_CAN,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_QIN) THEN
    ALLOCATE(DTB%XPAR_QIN(TG%NDIM,BOP%NBEMCOMP))
    DO JCOMP=1,BOP%NBEMCOMP
       WRITE(YRECFM,FMT='(A5,I1.1)') 'D_QIN',JCOMP
       CALL READ_FIELD(YRECFM,DTB%XPAR_QIN(:,JCOMP),HDIRIN)
    ENDDO
  ENDIF
  !
  IF (DTB%LDATA_QIN_FRAD) THEN
    ALLOCATE(DTB%XPAR_QIN_FRAD(TG%NDIM))
    YRECFM='D_QIN_FRAD'
    CALL READ_FIELD(YRECFM,DTB%XPAR_QIN_FRAD,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_SHGC) THEN
    ALLOCATE(DTB%XPAR_SHGC          (TG%NDIM))
    YRECFM='D_SHGC'
    CALL READ_FIELD(YRECFM,DTB%XPAR_SHGC,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_U_WIN) THEN
    ALLOCATE(DTB%XPAR_U_WIN         (TG%NDIM))
    YRECFM='D_U_WIN'
    CALL READ_FIELD(YRECFM,DTB%XPAR_U_WIN,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_GR) THEN
    ALLOCATE(DTB%XPAR_GR            (TG%NDIM))
    YRECFM='D_GR'
    CALL READ_FIELD(YRECFM,DTB%XPAR_GR,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_SHGC_SH) THEN
    ALLOCATE(DTB%XPAR_SHGC_SH       (TG%NDIM))
    YRECFM='D_SHGC_SH'
    CALL READ_FIELD(YRECFM,DTB%XPAR_SHGC_SH,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_FLOOR_HEIGHT) THEN
    ALLOCATE(DTB%XPAR_FLOOR_HEIGHT  (TG%NDIM))
    YRECFM='D_FLOOR_HEIG'
    CALL READ_FIELD(YRECFM,DTB%XPAR_FLOOR_HEIGHT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_N50) THEN
    ALLOCATE(DTB%XPAR_N50           (TG%NDIM))
    YRECFM='D_N50'
    CALL READ_FIELD(YRECFM,DTB%XPAR_N50,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_F_WATER_COND) THEN
     ALLOCATE(DTB%XPAR_F_WATER_COND (TG%NDIM))
    YRECFM='D_FWAT_COND'
    CALL READ_FIELD(YRECFM,DTB%XPAR_F_WATER_COND,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_ISMECH) THEN
     ALLOCATE(DTB%XPAR_ISMECH(TG%NDIM))
     YRECFM='D_ISMECH'
     CALL READ_FIELD(YRECFM,DTB%XPAR_ISMECH,HDIRIN)
     DTB%XPAR_ISMECH=FLOAT(NINT(DTB%XPAR_ISMECH))
  ENDIF
  !
  IF (DTB%LDATA_MECHRATE) THEN
     ALLOCATE(DTB%XPAR_MECHRATE(TG%NDIM))
     YRECFM='D_MECHRATE'
     CALL READ_FIELD(YRECFM,DTB%XPAR_MECHRATE,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_SHADEARCHI) THEN
     ALLOCATE(DTB%XPAR_SHADEARCHI(TG%NDIM))
     YRECFM='D_SHADEARCHI'
     CALL READ_FIELD(YRECFM,DTB%XPAR_SHADEARCHI,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_NATVENT) THEN
    ALLOCATE(DTB%XPAR_NATVENT(TG%NDIM,BOP%NBEMCOMP))
    DO JCOMP=1,BOP%NBEMCOMP
       WRITE(YRECFM,FMT='(A9,I1.1)') 'D_NATVENT',JCOMP
       CALL READ_FIELD(YRECFM,DTB%XPAR_NATVENT(:,JCOMP),HDIRIN)
       DTB%XPAR_NATVENT(:,JCOMP)=FLOAT(NINT(DTB%XPAR_NATVENT(:,JCOMP)))
    ENDDO
  ENDIF
  !
  IF (DTB%LDATA_QIN_FLAT) THEN
    ALLOCATE(DTB%XPAR_QIN_FLAT(TG%NDIM))
    YRECFM='D_QIN_FLAT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_QIN_FLAT,HDIRIN)
  ENDIF
  !  
  IF (DTB%LDATA_TCOOL_OCCD) THEN
     ALLOCATE(DTB%XPAR_TCOOL_OCCD (TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_OCCD',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_TCOOL_OCCD(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !  
  IF (DTB%LDATA_TCOOL_OCCN) THEN
     ALLOCATE(DTB%XPAR_TCOOL_OCCN(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_OCCN',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_TCOOL_OCCN(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_TCOOL_VCDD) THEN
     ALLOCATE(DTB%XPAR_TCOOL_VCDD(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_VCDD',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_TCOOL_VCDD(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !  
  IF (DTB%LDATA_TCOOL_VCDN) THEN
     ALLOCATE(DTB%XPAR_TCOOL_VCDN     (TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_VCDN',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_TCOOL_VCDN(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !  
  IF (DTB%LDATA_TCOOL_VCLD) THEN
     ALLOCATE(DTB%XPAR_TCOOL_VCLD (TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_VCLD',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_TCOOL_VCLD(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_THEAT_OCCD) THEN
     ALLOCATE(DTB%XPAR_THEAT_OCCD (TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_OCCD',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_THEAT_OCCD(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_THEAT_OCCN) THEN
     ALLOCATE(DTB%XPAR_THEAT_OCCN (TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
     WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_OCCN',JCOMP
     CALL READ_FIELD(YRECFM,DTB%XPAR_THEAT_OCCN(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !  
  IF (DTB%LDATA_THEAT_VCDD) THEN
     ALLOCATE(DTB%XPAR_THEAT_VCDD (TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_VCDD',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_THEAT_VCDD(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_THEAT_VCDN) THEN
     ALLOCATE(DTB%XPAR_THEAT_VCDN (TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_VCDN',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_THEAT_VCDN(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !  
  IF (DTB%LDATA_THEAT_VCLD) THEN
     ALLOCATE(DTB%XPAR_THEAT_VCLD (TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TH_VCLD',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_THEAT_VCLD(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_HR_TARGET) THEN
    ALLOCATE(DTB%XPAR_HR_TARGET    (TG%NDIM))
    YRECFM='D_HR_TARGET'
    CALL READ_FIELD(YRECFM,DTB%XPAR_HR_TARGET,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_CAP_SYS_HEAT) THEN
    ALLOCATE(DTB%XPAR_CAP_SYS_HEAT (TG%NDIM))
    YRECFM='D_CAP_SYS_HE'
    CALL READ_FIELD(YRECFM,DTB%XPAR_CAP_SYS_HEAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_CAP_SYS_RAT) THEN
    ALLOCATE(DTB%XPAR_CAP_SYS_RAT  (TG%NDIM))
    YRECFM='D_CAP_SYS_RA'
    CALL READ_FIELD(YRECFM,DTB%XPAR_CAP_SYS_RAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_T_ADP) THEN
    ALLOCATE(DTB%XPAR_T_ADP        (TG%NDIM))
    YRECFM='D_T_ADP'
    CALL READ_FIELD(YRECFM,DTB%XPAR_T_ADP,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_M_SYS_RAT) THEN
    ALLOCATE(DTB%XPAR_M_SYS_RAT    (TG%NDIM))
    YRECFM='D_M_SYS_RAT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_M_SYS_RAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_COP_RAT) THEN
    ALLOCATE(DTB%XPAR_COP_RAT      (TG%NDIM))
    YRECFM='D_COP_RAT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_COP_RAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_T_SIZE_MAX) THEN
    ALLOCATE(DTB%XPAR_T_SIZE_MAX   (TG%NDIM))
    YRECFM='D_T_SIZE_MAX'
    CALL READ_FIELD(YRECFM,DTB%XPAR_T_SIZE_MAX,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_T_SIZE_MIN) THEN
    ALLOCATE(DTB%XPAR_T_SIZE_MIN   (TG%NDIM))
    YRECFM='D_T_SIZE_MIN'
    CALL READ_FIELD(YRECFM,DTB%XPAR_T_SIZE_MIN,HDIRIN)
  ENDIF
  !
  YRECFM='PAR_DAY_SCHED'
  CALL READ_SURF(HPROGRAM,YRECFM,DTB%NPAR_DAY_SCHED,IRESP)
  !
  YRECFM='PAR_CRE_SCHED'
  CALL READ_SURF(HPROGRAM,YRECFM,DTB%NPAR_CRE_SCHED,IRESP)
  !
  YRECFM='PAR_NHOLIDAY'
  CALL READ_SURF(HPROGRAM,YRECFM,DTB%NPAR_HOLIDAY,IRESP)
  !
  IF (DTB%LDATA_RESIDENTIAL) THEN
     ALLOCATE(DTB%XPAR_RESIDENTIAL(TG%NDIM))
     YRECFM='D_RESIDENTIAL'
     CALL READ_FIELD(YRECFM,DTB%XPAR_RESIDENTIAL(:),HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_FRACOMP) THEN
     ALLOCATE(DTB%XPAR_FRACOMP(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I1.1)') 'D_FRACOMP',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_FRACOMP(:,JCOMP),HDIRIN)
     END DO
  ENDIF
  !
  IF (DTB%LDATA_PROBOCC) THEN
     ALLOCATE(DTB%XPAR_PROBOCC(TG%NDIM,DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED,BOP%NBEMCOMP))
     DO JSCHED=1,(DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED)
        DO JCOMP=1,BOP%NBEMCOMP
         WRITE(YRECFM,FMT='(A9,I2.2,I1.1)') 'D_PROBOCC',JSCHED,JCOMP
         CALL READ_FIELD(YRECFM,DTB%XPAR_PROBOCC(:,JSCHED,JCOMP),HDIRIN)
        ENDDO
     END DO
  ENDIF
  !
  IF (DTB%LDATA_DAYWBEG_SCHED) THEN
     ALLOCATE(DTB%XPAR_DAYWBEG_SCHED(TG%NDIM,DTB%NPAR_DAY_SCHED,BOP%NBEMCOMP))
     DO JSCHED=1,DTB%NPAR_DAY_SCHED
        DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A9,I2.2,I1.1)') 'D_DAYBEGS',JSCHED,JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_DAYWBEG_SCHED(:,JSCHED,JCOMP),HDIRIN)
        ENDDO
     END DO
  ENDIF
  !
  IF (DTB%LDATA_HOURBEG_SCHED) THEN
     ALLOCATE(DTB%XPAR_HOURBEG_SCHED(TG%NDIM,DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED,BOP%NBEMCOMP))
     DO JSCHED=1,(DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED)
        DO JCOMP=1,BOP%NBEMCOMP
           WRITE(YRECFM,FMT='(A9,I2.2,I1.1)') 'D_HOUBEGS',JSCHED,JCOMP
           CALL READ_FIELD(YRECFM,DTB%XPAR_HOURBEG_SCHED(:,JSCHED,JCOMP),HDIRIN)
        ENDDO
     END DO
  ENDIF
  !
  IF (DTB%LDATA_BEG_HOLIDAY) THEN
     ALLOCATE(DTB%XPAR_BEG_HOLIDAY(TG%NDIM,DTB%NPAR_HOLIDAY,BOP%NBEMCOMP))
     DO JSCHED=1,DTB%NPAR_HOLIDAY
        DO JCOMP=1,BOP%NBEMCOMP
           WRITE(YRECFM,FMT='(A8,I1.1,I1.1)') 'D_BEGHOL',JSCHED,JCOMP
           CALL READ_FIELD(YRECFM,DTB%XPAR_BEG_HOLIDAY(:,JSCHED,JCOMP),HDIRIN)
        ENDDO
     END DO
  ENDIF
  !
  IF (DTB%LDATA_END_HOLIDAY) THEN
     ALLOCATE(DTB%XPAR_END_HOLIDAY(TG%NDIM,DTB%NPAR_HOLIDAY,BOP%NBEMCOMP))
     DO JSCHED=1,DTB%NPAR_HOLIDAY
        DO JCOMP=1,BOP%NBEMCOMP
           WRITE(YRECFM,FMT='(A8,I1.1,I1.1)') 'D_ENDHOL',JSCHED,JCOMP
           CALL READ_FIELD(YRECFM,DTB%XPAR_END_HOLIDAY(:,JSCHED,JCOMP),HDIRIN)
        ENDDO
     END DO
  ENDIF
  !
  IF (DTB%LDATA_MOD_HOLIDAY) THEN
     ALLOCATE(DTB%XPAR_MOD_HOLIDAY(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A8,I1.1)') 'D_MODHOL',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_MOD_HOLIDAY(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_FSNIG) THEN
     ALLOCATE(DTB%XPAR_FSNIG(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FSNIG',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_FSNIG(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_FVNIG) THEN
     ALLOCATE(DTB%XPAR_FVNIG(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FVNIG',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_FVNIG(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_MODQIN_VCD) THEN
     ALLOCATE(DTB%XPAR_MODQIN_VCD(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
     WRITE(YRECFM,FMT='(A10,I1.1)') 'D_MODQ_VCD',JCOMP
     CALL READ_FIELD(YRECFM,DTB%XPAR_MODQIN_VCD(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_MODQIN_VLD) THEN
     ALLOCATE(DTB%XPAR_MODQIN_VLD(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A10,I1.1)') 'D_MODQ_VLD',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_MODQIN_VLD(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_MODQIN_NIG) THEN
     ALLOCATE(DTB%XPAR_MODQIN_NIG(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A10,I1.1)') 'D_MODQ_NIG',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_MODQIN_NIG(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_TDESV) THEN
     ALLOCATE(DTB%XPAR_TDESV(TG%NDIM))
     YRECFM='D_TDESV'
     CALL READ_FIELD(YRECFM,DTB%XPAR_TDESV,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_WIN_SW_MAX) THEN
     ALLOCATE(DTB%XPAR_WIN_SW_MAX(TG%NDIM))
     YRECFM='D_WIN_SW_MAX'
     CALL READ_FIELD(YRECFM,DTB%XPAR_WIN_SW_MAX,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_FOPEN) THEN
     ALLOCATE(DTB%XPAR_FOPEN(TG%NDIM))
     YRECFM='D_FOPEN'
     CALL READ_FIELD(YRECFM,DTB%XPAR_FOPEN,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_FVSUM) THEN
     ALLOCATE(DTB%XPAR_FVSUM(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FVSUM',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_FVSUM(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_FVVAC) THEN
     ALLOCATE(DTB%XPAR_FVVAC(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FVVAC',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_FVVAC(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_FSSUM) THEN
     ALLOCATE(DTB%XPAR_FSSUM(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FSSUM',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_FSSUM(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_FSVAC) THEN
     ALLOCATE(DTB%XPAR_FSVAC(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A7,I1.1)') 'D_FSVAC',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_FSVAC(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
  IF (DTB%LDATA_FRAC_HEAT_ELEC) THEN
     ALLOCATE(DTB%XPAR_FRAC_HEAT_ELEC (TG%NDIM))
     YRECFM='D_FRAC_HELEC'
     CALL READ_FIELD(YRECFM,DTB%XPAR_FRAC_HEAT_ELEC,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_FRAC_HEAT_GAS) THEN
     ALLOCATE(DTB%XPAR_FRAC_HEAT_GAS (TG%NDIM))
     YRECFM='D_FRAC_HGAS'
     CALL READ_FIELD(YRECFM,DTB%XPAR_FRAC_HEAT_GAS,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_FRAC_HEAT_FUEL) THEN
     ALLOCATE(DTB%XPAR_FRAC_HEAT_FUEL (TG%NDIM))
     YRECFM='D_FRAC_HFUEL'
     CALL READ_FIELD(YRECFM,DTB%XPAR_FRAC_HEAT_FUEL,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_FRAC_HEAT_OTHER) THEN
     ALLOCATE(DTB%XPAR_FRAC_HEAT_OTHER (TG%NDIM))
     YRECFM='D_FRAC_HOTHR'
     CALL READ_FIELD(YRECFM,DTB%XPAR_FRAC_HEAT_OTHER,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_F_HW_GAS) THEN
     ALLOCATE(DTB%XPAR_F_HW_GAS (TG%NDIM))
     YRECFM='D_F_HW_GAS'
     CALL READ_FIELD(YRECFM,DTB%XPAR_F_HW_GAS,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_HOTWAT) THEN
     ALLOCATE(DTB%XPAR_HOTWAT(TG%NDIM,BOP%NBEMCOMP))
     DO JCOMP=1,BOP%NBEMCOMP
        WRITE(YRECFM,FMT='(A8,I1.1)') 'D_HOTWAT',JCOMP
        CALL READ_FIELD(YRECFM,DTB%XPAR_HOTWAT(:,JCOMP),HDIRIN)
     ENDDO
  ENDIF
  !
ELSE
  !
  BOP%NBEMCOMP=1
  !
  ALLOCATE(DTB%XPAR_FRACOMP(TG%NDIM,BOP%NBEMCOMP))
  DTB%XPAR_FRACOMP(:,1) = 1.0
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
CONTAINS
!-------------------------------------------------------------------------------
!
SUBROUTINE READ_FIELD(HRECFM,PFIELD,YDIR)
!
USE MODI_HOR_INTERPOL
!
IMPLICIT NONE
!
 CHARACTER(LEN=*),     INTENT(IN)  :: HRECFM ! name of record in the file
REAL, DIMENSION(TG%NDIM), INTENT(OUT) :: PFIELD
 CHARACTER(LEN=1),     INTENT(IN)  :: YDIR
!
REAL, DIMENSION(KNI)              :: ZF
REAL, DIMENSION(:,:), POINTER     :: ZIN
REAL, DIMENSION(TG%NDIM,1)           :: ZOUT
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N:READ_FIELD',0,ZHOOK_HANDLE)
!
IF (YDIR=='A') THEN
  !
  CALL READ_SURF(&
                HPROGRAM,HRECFM,ZF,IRESP,HDIR='A')
  ALLOCATE(ZIN(KNI,1))
  ZIN(:,1) = ZF(:)
  CALL HOR_INTERPOL(DTCO, U,GCP, &
                    ILUOUT,ZIN,ZOUT)
  DEALLOCATE(ZIN)
  PFIELD(:) = ZOUT(:,1)
  !
ELSE
  CALL READ_SURF(&
                HPROGRAM,HRECFM,PFIELD,IRESP)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N:READ_FIELD',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_FIELD
!
!_______________________________
SUBROUTINE READ_FIELD_2D(HRECFM,PFIELD,YDIR)
!
IMPLICIT NONE
!
CHARACTER(LEN=*),           INTENT(IN)  :: HRECFM ! name of record in the file
REAL, DIMENSION(:,:), INTENT(OUT) :: PFIELD
CHARACTER(LEN=1),           INTENT(IN)  :: YDIR


REAL, DIMENSION(KNI, SIZE(PFIELD,2))              :: ZF
REAL, DIMENSION(:,:), POINTER     :: ZIN
REAL, DIMENSION(TG%NDIM,SIZE(PFIELD,2))           :: ZOUT
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N:READ_FIELD_2D',0,ZHOOK_HANDLE)
!
IF (YDIR=='A') THEN
  !
  CALL READ_SURF(&
                HPROGRAM,HRECFM,ZF,IRESP,HDIR='A')
  ALLOCATE(ZIN(KNI,SIZE(PFIELD,2)))
  ZIN(:,:) = ZF(:,:)
  CALL HOR_INTERPOL(DTCO, U, GCP, &
                    ILUOUT,ZIN,ZOUT)
  DEALLOCATE(ZIN)
  PFIELD(:,:) = ZOUT(:,:)
  !
ELSE
  CALL READ_SURF(&
                HPROGRAM,HRECFM,PFIELD,IRESP)
ENDIF


IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N:READ_FIELD_2D',1,ZHOOK_HANDLE)
END SUBROUTINE READ_FIELD_2D
!_______________________________
!
END SUBROUTINE READ_PGD_TEB_PAR_n
