!     #########
SUBROUTINE READ_NAMELISTS_ISBA_n (IM, &
                                  HPROGRAM, HINIT)
!     #######################################################
!
!---------------------------    
!
!
USE MODD_SURFEX_n, ONLY : ISBA_MODEL_t
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODN_ISBA_n                      
!    
USE MODN_SOILTEMP_ARP
!
USE MODI_GET_LUOUT
USE MODI_OPEN_NAMELIST
USE MODI_CLOSE_NAMELIST
USE MODE_POS_SURF
!
USE MODI_DEFAULT_ISBA
USE MODI_DEFAULT_CH_DEP
USE MODI_DEFAULT_CH_BIO_FLUX
USE MODI_DEFAULT_DIAG_ISBA
USE MODI_DEFAULT_CROCUS
!
USE MODI_READ_DEFAULT_ISBA_n
USE MODI_READ_ISBA_CONF_n
!
USE MODI_READ_NAM_PREP_ISBA_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!
TYPE(ISBA_MODEL_t), INTENT(INOUT) :: IM
!
 CHARACTER(LEN=6),   INTENT(IN)  :: HPROGRAM  ! program calling surf. schemes
 CHARACTER(LEN=3),   INTENT(IN)  :: HINIT     ! choice of fields to initialize
!
INTEGER :: ILUNAM         ! logical unit of namelist file
INTEGER :: ILUOUT
LOGICAL :: GFOUND         ! Return code when searching namelist
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!------------------------------------
!
IF (LHOOK) CALL DR_HOOK('READ_NAMELISTS_ISBA_N',0,ZHOOK_HANDLE)
 CALL DEFAULT_ISBA(XTSTEP, XOUT_TSTEP,                            &
                     CROUGH,CRUNOFF,CALBEDO,CSCOND,              &
                     CC1DRY, CSOILFRZ, CDIFSFCOND, CSNOWRES,     &
                     CCPSURF, XCGMAX, XCDRAG, CKSAT, LSOC,       &
                     CRAIN, CHORT, LGLACIER, LCANOPY_DRAG,       &
                     LVEGUPD, LSPINUPCARBS, LSPINUPCARBW,        &
                     XSPINMAXS, XSPINMAXW, XCO2_START, XCO2_END, &
                     NNBYEARSPINS, NNBYEARSPINW, LNITRO_DILU     )
!
 CALL DEFAULT_CH_DEP(CCH_DRY_DEP)
 CALL DEFAULT_CH_BIO_FLUX(LCH_BIO_FLUX) 
!           
 CALL DEFAULT_DIAG_ISBA(N2M,LSURF_BUDGET,L2M_MIN_ZS,LRAD_BUDGET,   &
                       LCOEF,LSURF_VARS,LSURF_EVAP_BUDGET,         &
                       LSURF_MISC_BUDGET,LSURF_DIAG_ALBEDO,        &
                       LSURF_BUDGETC,LSURF_MISC_DIF,LPATCH_BUDGET, &
                       LUTCI,LPGD,LRESET_BUDGETC,LWATER_BUDGET,    &
                       XDIAG_TSTEP                                 )     
!      
 CALL DEFAULT_CROCUS(LSNOWDRIFT,LSNOWDRIFT_SUBLIM,LSNOW_ABS_ZENITH,&
                     CSNOWMETAMO,CSNOWRAD)
!
 CALL READ_DEFAULT_ISBA_n(IM%CHI, IM%DGEI, IM%DGI, IM%DGUI, IM%DGMI, IM%I, &
                          HPROGRAM)
!
 CALL READ_ISBA_CONF_n(IM%CHI, IM%DGEI, IM%DGI, IM%DGUI, IM%DGMI, IM%I, &
                       HPROGRAM)
!
!
SODELX(:)      = XUNDEF
LTEMP_ARP      = .FALSE.
NTEMPLAYER_ARP = 4
!
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
 CALL OPEN_NAMELIST(HPROGRAM,ILUNAM)
 CALL POSNAM(ILUNAM,'NAM_SOILTEMP_ARP',GFOUND,ILUOUT)
IF (GFOUND) READ(UNIT=ILUNAM,NML=NAM_SOILTEMP_ARP)
 CALL CLOSE_NAMELIST(HPROGRAM,ILUNAM)
!
IF (HINIT=='PRE') CALL READ_NAM_PREP_ISBA_n(HPROGRAM)      
IF (LHOOK) CALL DR_HOOK('READ_NAMELISTS_ISBA_N',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE READ_NAMELISTS_ISBA_n
