!     #########
SUBROUTINE PREP_TEB_HYDRO (GDM, HM)
!     #################################################################################
!
!!****  *PREP_TEB_HYDRO* - Prepares ISBA fields for urban hydrology (based on GARDEN fields)
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     A. Lemonsu
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2013
!!------------------------------------------------------------------
!
USE MODD_SURFEX_n, ONLY : TEB_GARDEN_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_HYDRO_MODEL_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
TYPE(TEB_HYDRO_MODEL_t),  INTENT(INOUT) :: HM
!
!*      0.2    declarations of local variables
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('PREP_TEB_HYDRO',0,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------------
!
! *     1.     Allocations
!
ALLOCATE(HM%TH%CUR%XWG_ROAD        (SIZE(GDM%TGD%CUR%XTG,1),SIZE(GDM%TGD%CUR%XTG,2)))
ALLOCATE(HM%TH%CUR%XWGI_ROAD       (SIZE(GDM%TGD%CUR%XTG,1),SIZE(GDM%TGD%CUR%XTG,2)))
ALLOCATE(HM%TH%CUR%XWG_BLD         (SIZE(GDM%TGD%CUR%XTG,1),SIZE(GDM%TGD%CUR%XTG,2)))
ALLOCATE(HM%TH%CUR%XWGI_BLD        (SIZE(GDM%TGD%CUR%XTG,1),SIZE(GDM%TGD%CUR%XTG,2)))
!
!ALLOCATE(HM%TH%CUR%XRUNOFFSOIL_ROAD(SIZE(GDM%TGD%CUR%XTG,1)))
!ALLOCATE(HM%TH%CUR%XDRAIN_ROAD     (SIZE(GDM%TGD%CUR%XTG,1)))
!ALLOCATE(HM%TH%CUR%XRUNOFFSOIL_BLD (SIZE(GDM%TGD%CUR%XTG,1)))
!ALLOCATE(HM%TH%CUR%XDRAIN_BLD      (SIZE(GDM%TGD%CUR%XTG,1)))
!
!
! *     3.     Initialisation of prognostic variables
!
! Soil column under roads
HM%TH%CUR%XWG_ROAD (:,:) = GDM%TGD%CUR%XWG (:,:)
HM%TH%CUR%XWGI_ROAD(:,:) = GDM%TGD%CUR%XWGI(:,:)
!
! Soil column under buildings
HM%TH%CUR%XWG_BLD  (:,:) = GDM%TGD%CUR%XWG (:,:)
HM%TH%CUR%XWGI_BLD (:,:) = GDM%TGD%CUR%XWGI(:,:)
!
! Runoff/Drainage
!HM%TH%CUR%XRUNOFFSOIL_ROAD(:) = 0.
!HM%TH%CUR%XDRAIN_ROAD     (:) = 0.
!HM%TH%CUR%XRUNOFFSOIL_BLD (:) = 0.
!HM%TH%CUR%XDRAIN_BLD      (:) = 0.
!
!-------------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('PREP_TEB_HYDRO',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------------
!
END SUBROUTINE PREP_TEB_HYDRO
