!     #########
      SUBROUTINE PGD_TEB_GARDEN_PAR (DTCO, UG, U, USS, TOP, TG, GDM, HM, DTT, &
                                     HPROGRAM)
!     ##############################################################
!
!!**** *PGD_TEB_GARDEN_PAR* monitor for averaging and interpolations of cover fractions
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    A. Lemonsu       Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    09/2009
!!    E.Redon/A.Lemonsu       01/2016 Parameters related to street trees
!!    K.Chancibault/A.Lemonsu 01/2016 Parameters related to urban hydrology
!!    M. Goret                03/2017 add coherence check of vegetation fraction
!!    M. Goret                03/2017 suppress GDM%DTGD%NTIME = 12 as it is already
!!                                    initialize in pgd_teb_veg
!!    M. Goret                08/2017 add RE25 in the namelist
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
!
USE MODD_DATA_COVER_n,      ONLY : DATA_COVER_t
USE MODD_SURF_ATM_GRID_n,   ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n,        ONLY : SURF_ATM_t
USE MODD_SURF_ATM_SSO_n,    ONLY : SURF_ATM_SSO_t
USE MODD_TEB_OPTION_n,      ONLY : TEB_OPTIONS_t
USE MODD_TEB_GRID_n,        ONLY : TEB_GRID_t
USE MODD_SURFEX_n,          ONLY : TEB_GARDEN_MODEL_t
USE MODD_SURFEX_n,          ONLY : TEB_HYDRO_MODEL_t
USE MODD_SURFEX_n,          ONLY : DATA_TEB_t
USE MODD_COHERENCE_FRAC
!
USE MODD_DATA_COVER_PAR,    ONLY : NVEGTYPE
USE MODD_SURF_PAR,          ONLY : XUNDEF
!
USE MODD_PGDWORK,           ONLY : CATYPE
!
USE MODI_GET_LUOUT
USE MODI_OPEN_NAMELIST
USE MODI_CLOSE_NAMELIST
USE MODI_PGD_FIELD
USE MODI_ABOR1_SFX
!
USE MODE_POS_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t),       INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_GRID_t),    INTENT(INOUT) :: UG
TYPE(SURF_ATM_t),         INTENT(INOUT) :: U
TYPE(SURF_ATM_SSO_t),     INTENT(INOUT) :: USS
TYPE(TEB_OPTIONS_t),      INTENT(INOUT) :: TOP
TYPE(TEB_GRID_t),         INTENT(INOUT) :: TG
TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
TYPE(TEB_HYDRO_MODEL_t),  INTENT(INOUT) :: HM
TYPE(DATA_TEB_t),         INTENT(INOUT) :: DTT
!
 CHARACTER(LEN=6),        INTENT(IN)    :: HPROGRAM     ! Type of program
!
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
INTEGER               :: ILUOUT    ! output listing logical unit
INTEGER               :: ILUNAM    ! namelist file  logical unit
LOGICAL               :: GFOUND    ! true if namelist is found
LOGICAL               :: GNO_PAR_GARDEN ! true no fraction is prescribed
INTEGER               :: JTIME     ! loop counter on time
INTEGER               :: JI        ! loop counter on grid
!
!*    0.3    Declaration of namelists
!            ------------------------
!
INTEGER                                :: NTIME_GD
INTEGER, PARAMETER                     :: NGROUND_MAX  = 20
INTEGER, PARAMETER                     :: NVEGTYPE_MAX = 19
INTEGER, PARAMETER                     :: NTIME_MAX    = 12
!
INTEGER, PARAMETER                     :: NFNAM  = 28      ! max file name length
INTEGER, PARAMETER                     :: NFTYP  = 6       ! max file type length
!
! type of vegetation
!
 CHARACTER(LEN=4)                       :: CTYP_GARDEN_HVEG   ! type of high vegetation
 CHARACTER(LEN=4)                       :: CTYP_GARDEN_LVEG   ! type of low  vegetation
 CHARACTER(LEN=4)                       :: CTYP_GARDEN_NVEG   ! type of bare soil
 CHARACTER(LEN=3)                       :: CSHAPE_GARDEN_HVEG ! shape of crown for urban trees
                                                              ! (only used for CURBTREE = 'TREE' or 'GRWL')
!
! uniform value
!
REAL,DIMENSION(NTIME_MAX)              :: XUNIF_LAI_HVEG       ! LAI       of high vegetation
REAL,DIMENSION(NTIME_MAX)              :: XUNIF_LAI_LVEG       ! LAI       of low  vegetation
REAL                                   :: XUNIF_H_HVEG         ! height of trees
! Additional parameters for high vegetation (option CURBTREE)
REAL                                   :: XUNIF_HTRUNK_HVEG    ! height of TRUNK of trees
REAL                                   :: XUNIF_WCROWN_HVEG    ! width of crown of trees
! Additional parameters for urban hydrology (option LURBHYDRO)
REAL                                   :: XUNIF_LSEWER         ! waste water sewer length
REAL                                   :: XUNIF_LSTORM         ! storm water sewer length
REAL                                   :: XUNIF_DSEWER         ! waste water sewer depth
REAL                                   :: XUNIF_RE25           ! Ecosystem Respiration parameter (kg.m-2.s-1)
REAL                                   :: XWS_ROOF_MAX         ! Max. capacity of surface roof water storage 
REAL                                   :: XWS_ROAD_MAX         ! Max. capacity of surface road water storage
REAL                                   :: XIP_SEWER            ! Parameter for parasite infiltrations into sewer
REAL                                   :: XCONNEX              ! Impervious surfaces connexion rate to the sewer
REAL                                   :: XINFIL_ROAD          ! Water infiltration through the roads
!
! name of files containing data
!
 CHARACTER(LEN=NFNAM),DIMENSION(NTIME_MAX) :: CFNAM_LAI_HVEG      ! LAI       of high vegetation
 CHARACTER(LEN=NFNAM),DIMENSION(NTIME_MAX) :: CFNAM_LAI_LVEG      ! LAI       of low  vegetation
 CHARACTER(LEN=NFNAM)                      :: CFNAM_H_HVEG        ! height of trees
! Additional parameters for high vegetation (option CURBTREE)
 CHARACTER(LEN=NFNAM)                      :: CFNAM_HTRUNK_HVEG   ! height of TRUNK of trees
 CHARACTER(LEN=NFNAM)                      :: CFNAM_WCROWN_HVEG   ! width of crown of trees
 CHARACTER(LEN=NFNAM)                      :: CFNAM_LSEWER        ! waste water sewer length
 CHARACTER(LEN=NFNAM)                      :: CFNAM_LSTORM        ! storm water sewer length
 CHARACTER(LEN=NFNAM)                      :: CFNAM_DSEWER        ! waste water sewer depth
 CHARACTER(LEN=NFNAM)                      :: CFNAM_RE25          ! Ecosystem Respiration parameter (kg.m-2.s-1)
!
! type of files containing data
!
 CHARACTER(LEN=NFTYP),DIMENSION(NTIME_MAX) :: CFTYP_LAI_HVEG      ! LAI       of high vegetation
 CHARACTER(LEN=NFTYP),DIMENSION(NTIME_MAX) :: CFTYP_LAI_LVEG      ! LAI       of low  vegetation
 CHARACTER(LEN=NFTYP)                      :: CFTYP_H_HVEG        ! height of trees
! Additional parameters for high vegetation (option CURBTREE)
 CHARACTER(LEN=NFTYP)                      :: CFTYP_HTRUNK_HVEG   ! height of TRUNK of trees
 CHARACTER(LEN=NFTYP)                      :: CFTYP_WCROWN_HVEG   ! width of crown of trees
 CHARACTER(LEN=NFTYP)                      :: CFTYP_LSEWER        ! waste water sewer length
 CHARACTER(LEN=NFTYP)                      :: CFTYP_LSTORM        ! storm water sewer length
 CHARACTER(LEN=NFTYP)                      :: CFTYP_DSEWER        ! waste water sewer depth
 CHARACTER(LEN=NFTYP)                      :: CFTYP_RE25          ! Ecosystem Respiration parameter (kg.m-2.s-1)
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
NAMELIST/NAM_DATA_TEB_GARDEN/   NTIME_GD,                                          &
                                CTYP_GARDEN_HVEG, CTYP_GARDEN_LVEG,                &
                                CTYP_GARDEN_NVEG,                                  &
                                CSHAPE_GARDEN_HVEG,                                &
                                XUNIF_LAI_HVEG , XUNIF_LAI_LVEG ,                  &
                                XUNIF_H_HVEG   ,                                   &
                                XUNIF_HTRUNK_HVEG, XUNIF_WCROWN_HVEG,              &
                                XUNIF_LSEWER, XUNIF_LSTORM, XUNIF_DSEWER,          &
                                XUNIF_RE25,                                        &
                                XWS_ROOF_MAX, XWS_ROAD_MAX,                        &
                                XIP_SEWER, XCONNEX, XINFIL_ROAD,                   &
                                CFNAM_LAI_HVEG , CFNAM_LAI_LVEG ,                  &
                                CFNAM_H_HVEG   ,                                   &
                                CFNAM_HTRUNK_HVEG, CFNAM_WCROWN_HVEG,              &
                                CFNAM_LSEWER, CFNAM_LSTORM, CFNAM_DSEWER,          &
                                CFNAM_RE25,                                        &
                                CFTYP_LAI_HVEG , CFTYP_LAI_LVEG ,                  &
                                CFTYP_H_HVEG,                                      &
                                CFTYP_HTRUNK_HVEG, CFTYP_WCROWN_HVEG,              &
                                CFTYP_LSEWER, CFTYP_LSTORM, CFTYP_DSEWER,          &
                                CFTYP_RE25

!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('PGD_TEB_GARDEN_PAR',0,ZHOOK_HANDLE)

NTIME_GD = 12
!
CTYP_GARDEN_HVEG   = 'TEBD'           ! Temperate broadleaf trees (forest)
CTYP_GARDEN_LVEG   = 'PARK'           ! Grassland
CTYP_GARDEN_NVEG   = 'NO  '           ! No vegetation
CSHAPE_GARDEN_HVEG = 'CYL'            ! cylindric shape of crown (urban trees)
!
XUNIF_LAI_HVEG     = XUNDEF
XUNIF_LAI_LVEG     = XUNDEF
XUNIF_H_HVEG       = XUNDEF
XUNIF_HTRUNK_HVEG  = XUNDEF
XUNIF_WCROWN_HVEG  = XUNDEF
XUNIF_LSEWER       = XUNDEF
XUNIF_LSTORM       = XUNDEF
XUNIF_DSEWER       = XUNDEF
XUNIF_RE25         = XUNDEF
XWS_ROOF_MAX       = 1.
XWS_ROAD_MAX       = 1.
XIP_SEWER          = 0.
XCONNEX            = 1.
XINFIL_ROAD        = 0.
!
CFNAM_LAI_HVEG     = '                            '
CFNAM_LAI_LVEG     = '                            '
CFNAM_H_HVEG       = '                            '
CFNAM_HTRUNK_HVEG  = '                            '
CFNAM_WCROWN_HVEG  = '                            '
CFNAM_LSEWER       = '                            '
CFNAM_LSTORM       = '                            '
CFNAM_DSEWER       = '                            '
CFNAM_RE25         = '                            '
!
CFTYP_LAI_HVEG     = '      '
CFTYP_LAI_LVEG     = '      '
CFTYP_H_HVEG       = '      '
CFTYP_HTRUNK_HVEG  = '      '
CFTYP_WCROWN_HVEG  = '      '
CFTYP_LSEWER       = '      '
CFTYP_LSTORM       = '      '
CFTYP_DSEWER       = '      '
CFTYP_RE25         = '      '
!
!-------------------------------------------------------------------------------
!
!*    2.      Input file for cover types
!             --------------------------
!
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
 CALL OPEN_NAMELIST(HPROGRAM,ILUNAM)
!
 CALL POSNAM(ILUNAM,'NAM_DATA_TEB_GARDEN',GFOUND,ILUOUT)
IF (GFOUND) READ(UNIT=ILUNAM,NML=NAM_DATA_TEB_GARDEN)
!
 CALL CLOSE_NAMELIST(HPROGRAM,ILUNAM)
!
IF (NTIME_GD==1) THEN
  XUNIF_LAI_HVEG(2:) = XUNIF_LAI_HVEG(1)
  XUNIF_LAI_LVEG(2:) = XUNIF_LAI_LVEG(1)
ELSE IF (NTIME_GD/=12) THEN
  CALL ABOR1_SFX( 'Namelist NAM_DATA_TEB_GARDEN: NTIME_GD must be equal to 1 or 12')
END IF

!-------------------------------------------------------------------------------
!
GDM%DTGD%NTIME = NTIME_GD
!
ALLOCATE(GDM%DTGD%XPAR_LAI_HVEG    (TG%NDIM,GDM%DTGD%NTIME))
ALLOCATE(GDM%DTGD%XPAR_LAI_LVEG    (TG%NDIM,GDM%DTGD%NTIME))
ALLOCATE(GDM%DTGD%XPAR_H_HVEG      (TG%NDIM               ))
ALLOCATE(GDM%DTGD%XPAR_HTRUNK_HVEG (TG%NDIM               ))
ALLOCATE(GDM%DTGD%XPAR_WCROWN_HVEG (TG%NDIM               ))
ALLOCATE(GDM%DTGD%XPAR_RE25        (TG%NDIM               ))
ALLOCATE(HM%DTH%XPAR_LSEWER        (TG%NDIM               ))
ALLOCATE(HM%DTH%XPAR_LSTORM        (TG%NDIM               ))
ALLOCATE(HM%DTH%XPAR_DSEWER        (TG%NDIM               ))
!
GDM%TGDP%CTYPE_HVEG  = CTYP_GARDEN_HVEG
GDM%TGDP%CTYPE_LVEG  = CTYP_GARDEN_LVEG
GDM%TGDP%CTYPE_NVEG  = CTYP_GARDEN_NVEG
GDM%TGDP%CSHAPE_HVEG = CSHAPE_GARDEN_HVEG
!
!-------------------------------------------------------------------------------
!
!*    3.      Uniform fields are prescribed
!             -----------------------------
!
CATYPE = 'ARI'
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'Ecosystem Respiration parameter (kg.m-2.s-1) ' ,'TWN',CFNAM_RE25,   &
                 CFTYP_RE25,XUNIF_RE25,GDM%DTGD%XPAR_RE25(:), GDM%DTGD%LDATA_RE25)    
!
!-------------------------------------------------------------------------
!
!
DO JTIME=1,GDM%DTGD%NTIME
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'LAI_HVEG: LAI of high vegetation','TWN',CFNAM_LAI_HVEG(JTIME),  &
                  CFTYP_LAI_HVEG(JTIME),XUNIF_LAI_HVEG(JTIME),GDM%DTGD%XPAR_LAI_HVEG(:,JTIME))  
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'LAI_LVEG: LAI of low  vegetation','TWN',CFNAM_LAI_LVEG(JTIME),  &
                  CFTYP_LAI_LVEG(JTIME),XUNIF_LAI_LVEG(JTIME),GDM%DTGD%XPAR_LAI_LVEG(:,JTIME))  
!
!
ENDDO
!
! Additional fields for high vegetation (CURBTREE)
IF (TOP%CURBTREE=='TREE'.OR.TOP%CURBTREE=='GRWL') THEN
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'H_HVEG: height of trees','TWN',CFNAM_H_HVEG,                     &
                 CFTYP_H_HVEG,XUNIF_H_HVEG,GDM%DTGD%XPAR_H_HVEG(:))  
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'HTRUNK_HVEG: height of trunk of trees','TWN',CFNAM_HTRUNK_HVEG,  &
                 CFTYP_HTRUNK_HVEG,XUNIF_HTRUNK_HVEG,GDM%DTGD%XPAR_HTRUNK_HVEG(:))  
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'WCROWN_HVEG: width of crown of trees','TWN',CFNAM_WCROWN_HVEG,   &
                 CFTYP_WCROWN_HVEG,XUNIF_WCROWN_HVEG,GDM%DTGD%XPAR_WCROWN_HVEG(:))  
!
! Robert: The fields also need to be initialised in else case
!
ELSE
!
GDM%DTGD%XPAR_H_HVEG      (:) = XUNDEF
GDM%DTGD%XPAR_HTRUNK_HVEG (:) = XUNDEF
GDM%DTGD%XPAR_WCROWN_HVEG (:) = XUNDEF
!
ENDIF
!
! Additional fields for urban hydrology (LURBHYDRO)
IF (TOP%LURBHYDRO) THEN
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'LSEWER: length of waste water sewer','TWN',CFNAM_LSEWER,       &
                 CFTYP_LSEWER,XUNIF_LSEWER,HM%DTH%XPAR_LSEWER(:))  
!
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'LSTORM: length of storm water sewer','TWN',CFNAM_LSTORM,       &
                 CFTYP_LSTORM,XUNIF_LSTORM,HM%DTH%XPAR_LSTORM(:))  
! 
 CALL PGD_FIELD(DTCO, UG, U, USS, &
                HPROGRAM,'DSEWER: depth of waste water sewer','TWN',CFNAM_DSEWER,        &
                 CFTYP_DSEWER,XUNIF_DSEWER,HM%DTH%XPAR_DSEWER(:))  
!
 HM%DTH%XPAR_WS_ROOF_MAX = XWS_ROOF_MAX
 HM%DTH%XPAR_WS_ROAD_MAX = XWS_ROAD_MAX
 HM%DTH%XPAR_IP_SEWER    = XIP_SEWER
 HM%DTH%XPAR_CONNEX      = XCONNEX
 HM%DTH%XPAR_INFIL_ROAD  = XINFIL_ROAD
!
ENDIF
! 
!*    4.      Coherence check (depending on urbtree version)
!             ----------------------------------------------



!
! When high veg is explicitly treated, the high veg fraction is independant from garden fraction 
! on the ground, so that the sum of HVEG, LVEG, NVEG fractions can be greater than 1.
! When high veg is not explicitly treated, sum of HVEG, LVEG, NVEG fractions must be exactly equal to 1.
!
! Robert: Reformulation of the coherence check order to be more robust
!
   CALL COHERENCE_FRAC_VEG(HPROGRAM, GDM%DTGD, DTT, TG%NDIM, GDM%TGDO%LPAR_GARDEN, TOP%CURBTREE) !coherence check
!
IF (LHOOK) CALL DR_HOOK('PGD_TEB_GARDEN_PAR',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE PGD_TEB_GARDEN_PAR
