!##################
MODULE MODN_ISBA_n
!##################
!
!!****  *MODN_ISBA_n* - declaration of namelist NAM_ISBA_n
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_ISBA_n
!     which concern the surface configuration of one nested  model.
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!       
!!    AUTHOR
!!    ------
!!      V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004                    
!!      Modified    08/2009 by B. Decharme : LSURF_BUDGETC for all tiles
!!      Modified by A.L. Gibelin, 04/2009: add carbon spinup
!!
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
CHARACTER(LEN=4)  :: CC1DRY
CHARACTER(LEN=4)  :: CSCOND
CHARACTER(LEN=3)  :: CSOILFRZ
CHARACTER(LEN=4)  :: CDIFSFCOND
CHARACTER(LEN=3)  :: CSNOWRES
CHARACTER(LEN=4)  :: CALBEDO
CHARACTER(LEN=4)  :: CROUGH
CHARACTER(LEN=3)  :: CCPSURF
CHARACTER(LEN=4)  :: CRUNOFF
CHARACTER(LEN=3)  :: CKSAT
LOGICAL           :: LSOC
CHARACTER(LEN=3)  :: CRAIN
CHARACTER(LEN=3)  :: CHORT         
REAL  :: XTSTEP
REAL  :: XOUT_TSTEP
REAL  :: XCGMAX
REAL  :: XCDRAG
REAL  :: XSPINMAXS
REAL  :: XSPINMAXW
REAL  :: XCO2_START
REAL  :: XCO2_END
INTEGER  :: NNBYEARSPINS
INTEGER  :: NNBYEARSPINW
LOGICAL  :: LPGD
LOGICAL  :: LSURF_EVAP_BUDGET
LOGICAL  :: LSURF_BUDGET
LOGICAL  :: LRAD_BUDGET
LOGICAL  :: LSURF_BUDGETC
LOGICAL  :: LRESET_BUDGETC
LOGICAL  :: LPATCH_BUDGET
LOGICAL  :: LSURF_MISC_BUDGET
LOGICAL  :: LSURF_DIAG_ALBEDO
LOGICAL  :: LUTCI
LOGICAL  :: LSURF_MISC_DIF
LOGICAL  :: LWATER_BUDGET
REAL     :: XDIAG_TSTEP
REAL     :: XALBICE1, XALBICE2,XALBICE3
REAL     :: XRHOTHRESHOLD_ICE
REAL     :: XZ0ICEZ0SNOW
REAL     :: XVAGING_NOGLACIER,XVAGING_GLACIER
REAL     :: XPERCENTAGEPORE
INTEGER  :: N2M
LOGICAL  :: L2M_MIN_ZS
LOGICAL  :: LCOEF
LOGICAL  :: LSURF_VARS
LOGICAL  :: LCH_BIO_FLUX
LOGICAL  :: LCH_NO_FLUX
LOGICAL  :: LGLACIER
LOGICAL  :: LVEGUPD
LOGICAL  :: LNITRO_DILU
LOGICAL  :: LSPINUPCARBS
LOGICAL  :: LSPINUPCARBW
LOGICAL  :: LCANOPY_DRAG
LOGICAL  :: LPERTSURF
LOGICAL  :: LSNOWDRIFT
LOGICAL  :: LSNOWDRIFT_SUBLIM
LOGICAL  :: LSNOW_ABS_ZENITH
 CHARACTER(3) :: CSNOWMETAMO
 CHARACTER(3) :: CSNOWRAD
 CHARACTER(LEN=6)  :: CCH_DRY_DEP
 CHARACTER(LEN=28) :: CCHEM_SURF_FILE
!
NAMELIST/NAM_ISBAn/CC1DRY,CSCOND,CSOILFRZ,CDIFSFCOND,CSNOWRES,CALBEDO,CROUGH,CCPSURF, &
                     XTSTEP,XCGMAX,XCDRAG,LGLACIER,LCANOPY_DRAG,LVEGUPD,LPERTSURF
NAMELIST/NAM_ISBA_AGSn/LNITRO_DILU
NAMELIST/NAM_SGH_ISBAn/CRUNOFF,CKSAT,LSOC,CRAIN,CHORT
NAMELIST/NAM_DIAG_ISBAn/LPGD,LSURF_EVAP_BUDGET,LSURF_MISC_BUDGET,LSURF_DIAG_ALBEDO,LPATCH_BUDGET, &
                        LSURF_MISC_DIF, LWATER_BUDGET,LUTCI
NAMELIST/NAM_DIAG_SURFn/N2M,L2M_MIN_ZS,LSURF_BUDGET,LRAD_BUDGET, &
                        LSURF_BUDGETC,LRESET_BUDGETC,LCOEF,LSURF_VARS
NAMELIST/NAM_CH_CONTROLn/CCHEM_SURF_FILE
NAMELIST/NAM_CH_ISBAn/LCH_BIO_FLUX,CCH_DRY_DEP,LCH_NO_FLUX
NAMELIST/NAM_SPINUP_CARBn/LSPINUPCARBS,LSPINUPCARBW,XSPINMAXS,XSPINMAXW,NNBYEARSPINS,&
        NNBYEARSPINW, XCO2_START, XCO2_END
NAMELIST/NAM_ISBA_SNOWn/LSNOWDRIFT,LSNOWDRIFT_SUBLIM, LSNOW_ABS_ZENITH, CSNOWMETAMO, CSNOWRAD
!
CONTAINS
!
SUBROUTINE INIT_NAM_ISBAn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBAN',0,ZHOOK_HANDLE)
  CC1DRY = I%CC1DRY
  CSCOND = I%CSCOND
  CSOILFRZ = I%CSOILFRZ
  CDIFSFCOND = I%CDIFSFCOND
  CSNOWRES = I%CSNOWRES
  CALBEDO = I%CALBEDO
  CROUGH = I%CROUGH
  CCPSURF = I%CCPSURF
  XTSTEP = I%XTSTEP
  XOUT_TSTEP = I%XOUT_TSTEP
  XCGMAX = I%XCGMAX
  XCDRAG = I%XCDRAG
  LGLACIER = I%LGLACIER
  LVEGUPD = I%LVEGUPD  
  LCANOPY_DRAG = I%LCANOPY_DRAG
  LPERTSURF = I%LPERTSURF
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_ISBAn

SUBROUTINE INIT_NAM_ISBA_AGSn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_AGSN',0,ZHOOK_HANDLE)
  LNITRO_DILU = I%LNITRO_DILU
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_AGSN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_ISBA_AGSn

SUBROUTINE INIT_NAM_SGH_ISBAn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_SGH_ISBAN',0,ZHOOK_HANDLE)
  CRUNOFF = I%CRUNOFF
  CKSAT=I%CKSAT
  LSOC=I%LSOC
  CRAIN=I%CRAIN
  CHORT=I%CHORT
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_SGH_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SGH_ISBAn

SUBROUTINE UPDATE_NAM_ISBAn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_ISBAN',0,ZHOOK_HANDLE)
  I%CC1DRY = CC1DRY
  I%CSCOND = CSCOND
  I%CSOILFRZ = CSOILFRZ
  I%CDIFSFCOND = CDIFSFCOND
  I%CSNOWRES = CSNOWRES
  I%CALBEDO = CALBEDO
  I%CROUGH = CROUGH
  I%CCPSURF = CCPSURF
  I%XTSTEP = XTSTEP
  I%XOUT_TSTEP = XOUT_TSTEP
  I%XCGMAX = XCGMAX
  I%XCDRAG = XCDRAG
  I%LGLACIER = LGLACIER
  I%LVEGUPD = LVEGUPD  
  I%LCANOPY_DRAG = LCANOPY_DRAG
  I%LPERTSURF = LPERTSURF
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_ISBAn

SUBROUTINE UPDATE_NAM_ISBA_AGSn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_ISBA_AGSN',0,ZHOOK_HANDLE)
  I%LNITRO_DILU = LNITRO_DILU
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_ISBA_AGSN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_ISBA_AGSn

SUBROUTINE UPDATE_NAM_SGH_ISBAn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_SGH_ISBAN',0,ZHOOK_HANDLE)
  I%CRUNOFF=CRUNOFF
  I%CKSAT=CKSAT
  I%LSOC=LSOC
  I%CRAIN=CRAIN
  I%CHORT=CHORT
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_SGH_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SGH_ISBAn

SUBROUTINE INIT_NAM_DIAG_ISBAn (DGEI, DGI, DGUI, DGMI)
!
  USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
  USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
  USE MODD_DIAG_UTCI_ISBA_n, ONLY : DIAG_UTCI_ISBA_t
  USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
  TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
  TYPE(DIAG_UTCI_ISBA_t), INTENT(INOUT) :: DGUI
  TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DGMI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_DIAG_ISBAN',0,ZHOOK_HANDLE)
  LPGD = DGI%LPGD
  LSURF_EVAP_BUDGET = DGEI%LSURF_EVAP_BUDGET
  LWATER_BUDGET = DGEI%LWATER_BUDGET
  LSURF_MISC_BUDGET = DGMI%LSURF_MISC_BUDGET
  LSURF_DIAG_ALBEDO = DGMI%LSURF_DIAG_ALBEDO
  LSURF_MISC_DIF = DGMI%LSURF_MISC_DIF
  LPATCH_BUDGET = DGI%LPATCH_BUDGET
  LUTCI = DGUI%LUTCI
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_DIAG_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_ISBAn

SUBROUTINE UPDATE_NAM_DIAG_ISBAn (DGEI, DGI, DGUI, DGMI)
!
  USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
  USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
  USE MODD_DIAG_UTCI_ISBA_n, ONLY : DIAG_UTCI_ISBA_t
  USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
  TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
  TYPE(DIAG_UTCI_ISBA_t), INTENT(INOUT) :: DGUI
  TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DGMI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_DIAG_ISBAN',0,ZHOOK_HANDLE)
  DGI%LPGD = LPGD
  DGEI%LSURF_EVAP_BUDGET = LSURF_EVAP_BUDGET
  DGEI%LWATER_BUDGET = LWATER_BUDGET
  DGMI%LSURF_MISC_BUDGET = LSURF_MISC_BUDGET
  DGMI%LSURF_DIAG_ALBEDO = LSURF_DIAG_ALBEDO
  DGMI%LSURF_MISC_DIF = LSURF_MISC_DIF
  DGI%LPATCH_BUDGET = LPATCH_BUDGET
  DGUI%LUTCI = LUTCI
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_DIAG_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_ISBAn

SUBROUTINE INIT_NAM_DIAG_SURFn (DGEI, DGI)
!
  USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
  USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
  TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  XDIAG_TSTEP = DGI%XDIAG_TSTEP  
  N2M = DGI%N2M
  L2M_MIN_ZS = DGI%L2M_MIN_ZS
  LSURF_BUDGET = DGI%LSURF_BUDGET
  LRAD_BUDGET = DGI%LRAD_BUDGET
  LSURF_BUDGETC = DGEI%LSURF_BUDGETC
  LRESET_BUDGETC = DGEI%LRESET_BUDGETC  
  LCOEF = DGI%LCOEF
  LSURF_VARS = DGI%LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_SURFn

SUBROUTINE UPDATE_NAM_DIAG_SURFn (DGEI, DGI)
!
  USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
  USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
  TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  DGI%XDIAG_TSTEP = XDIAG_TSTEP  
  DGI%N2M = N2M
  DGI%L2M_MIN_ZS = L2M_MIN_ZS
  DGI%LSURF_BUDGET = LSURF_BUDGET
  DGI%LRAD_BUDGET = LRAD_BUDGET 
  DGEI%LSURF_BUDGETC = LSURF_BUDGETC
  DGEI%LRESET_BUDGETC = LRESET_BUDGETC  
  DGI%LCOEF = LCOEF
  DGI%LSURF_VARS = LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_SURFn

SUBROUTINE INIT_NAM_CH_CONTROLn (CHI)
!
  USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_CH_CONTROLN',0,ZHOOK_HANDLE)
  CCHEM_SURF_FILE = CHI%CCHEM_SURF_FILE
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_CH_CONTROLN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_CONTROLn

SUBROUTINE UPDATE_NAM_CH_CONTROLn (CHI)
!
  USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_CH_CONTROLN',0,ZHOOK_HANDLE)
  CHI%CCHEM_SURF_FILE = CCHEM_SURF_FILE
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_CH_CONTROLN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_CONTROLn

SUBROUTINE INIT_NAM_CH_ISBAn (CHI)
!
  USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_CH_ISBAN',0,ZHOOK_HANDLE)
  LCH_BIO_FLUX = CHI%LCH_BIO_FLUX
  LCH_NO_FLUX = CHI%LCH_NO_FLUX
  CCH_DRY_DEP = CHI%CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_CH_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_ISBAn

SUBROUTINE UPDATE_NAM_CH_ISBAn (CHI)
!
  USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
!
  IMPLICIT NONE

!
  TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_CH_ISBAN',0,ZHOOK_HANDLE)
  CHI%LCH_BIO_FLUX = LCH_BIO_FLUX
  CHI%LCH_NO_FLUX = LCH_NO_FLUX
  CHI%CCH_DRY_DEP = CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_CH_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_ISBAn

SUBROUTINE INIT_NAM_SPINUP_CARB_ISBAn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_SPINUP_CARB_ISBAN',0,ZHOOK_HANDLE)
  LSPINUPCARBS = I%LSPINUPCARBS
  LSPINUPCARBW = I%LSPINUPCARBW  
  XSPINMAXS   = I%XSPINMAXS
  XSPINMAXW   = I%XSPINMAXW  
  NNBYEARSPINS = I%NNBYEARSPINS
  NNBYEARSPINW = I%NNBYEARSPINW
  XCO2_START = I%XCO2_START
  XCO2_END = I%XCO2_END
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_SPINUP_CARB_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SPINUP_CARB_ISBAn

SUBROUTINE UPDATE_NAM_SPINUP_CARB_ISBAn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_SPINUP_CARB_ISBAN',0,ZHOOK_HANDLE)
  I%LSPINUPCARBS = LSPINUPCARBS
  I%LSPINUPCARBW = LSPINUPCARBW  
  I%XSPINMAXS   = XSPINMAXS
  I%XSPINMAXW   = XSPINMAXW  
  I%NNBYEARSPINS = NNBYEARSPINS
  I%NNBYEARSPINW = NNBYEARSPINW
  I%XCO2_START = XCO2_START
  I%XCO2_END = XCO2_END
IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:UPDATE_NAM_SPINUP_CARB_ISBAN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SPINUP_CARB_ISBAn

SUBROUTINE INIT_NAM_ISBA_SNOWn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_SNOWn',0,ZHOOK_HANDLE)
  LSNOWDRIFT = I%LSNOWDRIFT
  LSNOWDRIFT_SUBLIM =  I%LSNOWDRIFT_SUBLIM
  LSNOW_ABS_ZENITH = I%LSNOW_ABS_ZENITH
  CSNOWMETAMO = I%CSNOWMETAMO
  CSNOWRAD = I%CSNOWRAD  
  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_SNOWn',1,ZHOOK_HANDLE)

END SUBROUTINE INIT_NAM_ISBA_SNOWn

SUBROUTINE UPDATE_NAM_ISBA_SNOWn (I)
!
  USE MODD_ISBA_n, ONLY : ISBA_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_t), INTENT(INOUT) :: I
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_SNOWn',0,ZHOOK_HANDLE)
  I%LSNOWDRIFT = LSNOWDRIFT
  I%LSNOWDRIFT_SUBLIM = LSNOWDRIFT_SUBLIM
  I%LSNOW_ABS_ZENITH = LSNOW_ABS_ZENITH
  I%CSNOWMETAMO = CSNOWMETAMO
  I%CSNOWRAD=CSNOWRAD  
  IF (LHOOK) CALL DR_HOOK('MODN_ISBA_N:INIT_NAM_ISBA_SNOWn',1,ZHOOK_HANDLE)

END SUBROUTINE UPDATE_NAM_ISBA_SNOWn

END MODULE MODN_ISBA_n
