!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ######spl
        MODULE MODE_COUPLING_CANOPY
!     ####################
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
 CONTAINS
!
!     ###############################################################################
SUBROUTINE INIT_FORC( PFORC_U, PDFORC_UDU, PFORC_E, PDFORC_EDE, &
                      PFORC_T, PDFORC_TDT, PFORC_Q, PDFORC_QDQ )
!
IMPLICIT NONE
!
REAL, DIMENSION(:,:), INTENT(OUT) :: PFORC_U
REAL, DIMENSION(:,:), INTENT(OUT) :: PDFORC_UDU
REAL, DIMENSION(:,:), INTENT(OUT) :: PFORC_E
REAL, DIMENSION(:,:), INTENT(OUT) :: PDFORC_EDE
REAL, DIMENSION(:,:), INTENT(OUT) :: PFORC_T
REAL, DIMENSION(:,:), INTENT(OUT) :: PDFORC_TDT
REAL, DIMENSION(:,:), INTENT(OUT) :: PFORC_Q
REAL, DIMENSION(:,:), INTENT(OUT) :: PDFORC_QDQ
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_FORC',0,ZHOOK_HANDLE)
!
PFORC_U    = 0.
PDFORC_UDU = 0.
!
PFORC_E(:,:) = 0.
PDFORC_EDE(:,:) = 0.
!
PFORC_T(:,:) = 0.
PDFORC_TDT(:,:) = 0.
!
PFORC_Q(:,:) = 0.
PDFORC_QDQ(:,:) = 0.
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_FORC',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_FORC
!     ###############################################################################
!
!     ###############################################################################
SUBROUTINE INIT_COUPLING_CANOPY( PP, PPA, PT, PQ, PU, PV, PZ, PXU, &
                                 PRHOA, PALFAU, PBETAU, PALFATH,   &
                                 PBETATH, PALFAQ, PBETAQ,          &
                                 PPPA, PTTA, PQQA, PUU, PVV,       &
                                 PUUREF, PZZREF,  PEXNA,           &
                                 PPEW_AA_COEF, PPEW_BB_COEF,       &
                                 PPET_AA_COEF, PPET_BB_COEF,       &
                                 PPEQ_AA_COEF, PPEQ_BB_COEF        )
!
USE MODD_SURF_PAR,         ONLY : XUNDEF
USE MODD_CSTS,             ONLY : XCPD, XRD, XP00
USE MODD_SURF_ATM,         ONLY : XWINDMIN
!
IMPLICIT NONE
!
REAL, DIMENSION(:), INTENT(IN) :: PP
REAL, DIMENSION(:), INTENT(IN) :: PPA
REAL, DIMENSION(:), INTENT(IN) :: PT
REAL, DIMENSION(:), INTENT(IN) :: PQ
REAL, DIMENSION(:), INTENT(IN) :: PU
REAL, DIMENSION(:), INTENT(IN) :: PV
REAL, DIMENSION(:), INTENT(IN) :: PZ
REAL, DIMENSION(:), INTENT(IN) :: PXU
REAL, DIMENSION(:), INTENT(IN) :: PRHOA
REAL, DIMENSION(:), INTENT(IN) :: PALFAU
REAL, DIMENSION(:), INTENT(IN) :: PBETAU
REAL, DIMENSION(:), INTENT(IN) :: PALFATH
REAL, DIMENSION(:), INTENT(IN) :: PBETATH
REAL, DIMENSION(:), INTENT(IN) :: PALFAQ
REAL, DIMENSION(:), INTENT(IN) :: PBETAQ
REAL, DIMENSION(:), INTENT(OUT) :: PPPA
REAL, DIMENSION(:), INTENT(OUT) :: PTTA
REAL, DIMENSION(:), INTENT(OUT) :: PQQA
REAL, DIMENSION(:), INTENT(OUT) :: PUU
REAL, DIMENSION(:), INTENT(OUT) :: PVV
REAL, DIMENSION(:), INTENT(OUT) :: PUUREF
REAL, DIMENSION(:), INTENT(OUT) :: PZZREF
REAL, DIMENSION(:), INTENT(OUT) :: PEXNA
REAL, DIMENSION(:), INTENT(OUT) :: PPEW_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEW_BB_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPET_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPET_BB_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEQ_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEQ_BB_COEF
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_COUPLING_CANOPY',0,ZHOOK_HANDLE)
!
PPPA = PP(:)
PTTA = PT(:)
PQQA = PQ(:)
PUU  = PU / MAX(SQRT(PU**2+PV**2),XWINDMIN) * PXU(:)
PVV  = PV / MAX(SQRT(PU**2+PV**2),XWINDMIN) * PXU(:)
PUUREF = PZ(:)
PZZREF = PZ(:)
!
PEXNA(:)   = (PP(:)/XP00)**(XRD/XCPD)
WHERE (PP(:)==XUNDEF) !* security at first time-step
  PEXNA = (PPA/XP00)**(XRD/XCPD)
  PPPA  = PPA
END WHERE
!
!* ALMA conventions for implicit coefficients:
! U+  = - rho A u'w'  + B
! Th+ = - rho A w'th' + B
! q+  = - rho A w'q'  + B
!
PPEW_AA_COEF = - PALFAU / PRHOA
PPEW_BB_COEF = PBETAU
PPET_AA_COEF = - PALFATH / PRHOA
PPET_BB_COEF = PBETATH
PPEQ_AA_COEF = - PALFAQ / PRHOA
PPEQ_BB_COEF = PBETAQ
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_COUPLING_CANOPY',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_COUPLING_CANOPY
!     ###############################################################################
!
!     ###############################################################################
SUBROUTINE INIT_COUPLING( HCOUPLING,                  &
                          PPS, PPA, PTA, PQA, PU, PV, &
                          PUREF, PZREF,               &
                          PPEW_A_COEF, PPEW_B_COEF,   &
                          PPET_A_COEF, PPET_B_COEF,   &
                          PPEQ_A_COEF, PPEQ_B_COEF,   &
                          PPPA, PTTA, PQQA, PUU, PVV, &
                          PUUREF, PZZREF,             &
                          PPEW_AA_COEF, PPEW_BB_COEF, &
                          PPET_AA_COEF, PPET_BB_COEF, &
                          PPEQ_AA_COEF, PPEQ_BB_COEF  ) 
!
USE MODD_CSTS,             ONLY : XCPD, XRD, XP00
!
IMPLICIT NONE
!
 CHARACTER(LEN=1),   INTENT(IN) :: HCOUPLING
REAL, DIMENSION(:), INTENT(IN) :: PPS
REAL, DIMENSION(:), INTENT(IN) :: PPA
REAL, DIMENSION(:), INTENT(IN) :: PTA
REAL, DIMENSION(:), INTENT(IN) :: PQA
REAL, DIMENSION(:), INTENT(IN) :: PU
REAL, DIMENSION(:), INTENT(IN) :: PV
REAL, DIMENSION(:), INTENT(IN) :: PUREF
REAL, DIMENSION(:), INTENT(IN) :: PZREF
REAL, DIMENSION(:), INTENT(IN) :: PPEW_A_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPEW_B_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPET_A_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPET_B_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPEQ_A_COEF
REAL, DIMENSION(:), INTENT(IN) :: PPEQ_B_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPPA
REAL, DIMENSION(:), INTENT(OUT) :: PTTA
REAL, DIMENSION(:), INTENT(OUT) :: PQQA
REAL, DIMENSION(:), INTENT(OUT) :: PUU
REAL, DIMENSION(:), INTENT(OUT) :: PVV
REAL, DIMENSION(:), INTENT(OUT) :: PUUREF
REAL, DIMENSION(:), INTENT(OUT) :: PZZREF
REAL, DIMENSION(:), INTENT(OUT) :: PPEW_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEW_BB_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPET_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPET_BB_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEQ_AA_COEF
REAL, DIMENSION(:), INTENT(OUT) :: PPEQ_BB_COEF
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_COUPLING',0,ZHOOK_HANDLE)
!
PPPA = PPA
PTTA = PTA
PQQA = PQA
PUU  = PU 
PVV  = PV 
PUUREF = PUREF
PZZREF = PZREF
!
PPEW_AA_COEF = PPEW_A_COEF
PPEW_BB_COEF = PPEW_B_COEF
!
IF (HCOUPLING=='I') THEN
  PPET_AA_COEF = PPET_A_COEF
  PPEQ_AA_COEF = PPEQ_A_COEF
  PPET_BB_COEF = PPET_B_COEF
  PPEQ_BB_COEF = PPEQ_B_COEF
ELSE
  PPET_AA_COEF =  0.
  PPET_BB_COEF =  PTA / (PPA/XP00)**(XRD/XCPD)
  PPEQ_AA_COEF =  0.
  PPEQ_BB_COEF =  PQA
ENDIF
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_COUPLING',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_COUPLING
!     ###############################################################################
!
!     ###############################################################################
SUBROUTINE INIT_2M_10M( PP_SBL, PT_SBL, PQ_SBL, PXU, PXZ, PU, PV, PWIND, PRHOA,   &
                        PT2M, PQ2M, PHU2M, PZON10M, PMER10M,          &
                        PWIND10M,  PWIND10M_MAX, PT2M_MIN, PT2M_MAX,  &
                        PHU2M_MIN, PHU2M_MAX                          )
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODE_THERMOS,  ONLY : QSAT
!
USE MODI_INTERPOL_SBL
!
IMPLICIT NONE
!
REAL, DIMENSION(:,:), INTENT(IN) :: PP_SBL
REAL, DIMENSION(:,:), INTENT(IN) :: PT_SBL
REAL, DIMENSION(:,:), INTENT(IN) :: PQ_SBL
REAL, DIMENSION(:,:), INTENT(IN) :: PXU
REAL, DIMENSION(:,:), INTENT(IN) :: PXZ
REAL, DIMENSION(:), INTENT(IN) :: PU
REAL, DIMENSION(:), INTENT(IN) :: PV
REAL, DIMENSION(:), INTENT(IN) :: PWIND
REAL, DIMENSION(:), INTENT(IN) :: PRHOA
REAL, DIMENSION(:), INTENT(OUT) :: PT2M 
REAL, DIMENSION(:), INTENT(OUT) :: PQ2M
REAL, DIMENSION(:), INTENT(OUT) :: PHU2M
REAL, DIMENSION(:), INTENT(OUT) :: PZON10M
REAL, DIMENSION(:), INTENT(OUT) :: PMER10M
REAL, DIMENSION(:), INTENT(OUT) :: PWIND10M
REAL, DIMENSION(:), INTENT(INOUT) :: PWIND10M_MAX
REAL, DIMENSION(:), INTENT(INOUT) :: PT2M_MIN
REAL, DIMENSION(:), INTENT(INOUT) :: PT2M_MAX
REAL, DIMENSION(:), INTENT(INOUT) :: PHU2M_MIN
REAL, DIMENSION(:), INTENT(INOUT) :: PHU2M_MAX
!
REAL, DIMENSION(SIZE(PT_SBL,1)) :: ZP_2M
REAL, DIMENSION(SIZE(PT_SBL,1)) :: ZT_2M
REAL, DIMENSION(SIZE(PT_SBL,1)) :: ZQ_2M
REAL, DIMENSION(SIZE(PT_SBL,1)) :: ZU10
!
INTEGER :: JJ
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_2M_10M',0,ZHOOK_HANDLE)
!
! Interpolate to 2M
!
CALL INTERPOL_SBL(PXZ(:,:),PT_SBL(:,:),2.,ZT_2M(:))
CALL INTERPOL_SBL(PXZ(:,:),PQ_SBL(:,:),2.,ZQ_2M(:))
CALL INTERPOL_SBL(PXZ(:,:),PP_SBL(:,:),2.,ZP_2M(:))
!
PT2M(:) = ZT_2M(:)
PT2M_MIN(:) = MIN(PT2M(:),PT2M_MIN(:))
PT2M_MAX(:) = MAX(PT2M(:),PT2M_MAX(:))
PQ2M(:) = ZQ_2M(:) / PRHOA(:)
PHU2M(:)= MIN( PQ2M(:) / QSAT(PT2M(:),ZP_2M(:)) , 1.)
PHU2M_MIN(:) = MIN(PHU2M(:),PHU2M_MIN(:))
PHU2M_MAX(:) = MAX(PHU2M(:),PHU2M_MAX(:))
CALL INTERPOL_SBL(PXZ(:,:),PXU(:,:),10.,ZU10(:))
!
DO JJ=1,SIZE(PT_SBL,1)
  IF (ZU10(JJ)/=XUNDEF) THEN
    IF (PWIND(JJ)>0.) THEN
      PZON10M(JJ) = ZU10(JJ) * PU(JJ)/PWIND(JJ)
      PMER10M(JJ) = ZU10(JJ) * PV(JJ)/PWIND(JJ)
    ELSE
      PZON10M(JJ) = 0.
      PMER10M(JJ) = 0.
    END IF
     PWIND10M(JJ) = SQRT(PZON10M(JJ)**2+PMER10M(JJ)**2)
     PWIND10M_MAX(JJ) = MAX(PWIND10M(JJ),PWIND10M_MAX(JJ))
  ELSE
    PZON10M(JJ) = XUNDEF
    PMER10M(JJ) = XUNDEF
    PWIND10M(JJ) = XUNDEF
    PWIND10M_MAX(JJ) = XUNDEF
  END IF
END DO
!
IF (LHOOK) CALL DR_HOOK('MODE_COUPLING_CANOPY:INIT_2M_10M',1,ZHOOK_HANDLE)
!
END SUBROUTINE
!
END MODULE MODE_COUPLING_CANOPY
