!     ################
      MODULE MODD_TEB_n
!     ################
!
!!****  *MODD_TEB_n - declaration of surface parameters for urban surface
!!
!!    PURPOSE
!!    -------
!     Declaration of surface parameters
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       01/2004
!!      A. Lemonsu      07/2012         Key for urban hydrology
!!      V. Masson       06/2013         splits module in two
!!      K.Chancibault/A.Lemonsu 01/2016 vertical discretization of soil
!!      M. Goret        04/2017         add variables for CO2 flux calculus
!
!*       0.   DECLARATIONS
!             ------------
!
USE MODD_TYPE_SNOW
USE MODD_TYPE_DATE_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!--------------------------------------------------------------------------

TYPE TEB_1P_t
! TEB scheme option
!
! Number of layers and vertical discretization
  INTEGER                       :: NTEB_ROAD          ! number of layers in structural roads only
  INTEGER                       :: NTEB_SOIL          ! total number of layers in roads (structural road + soil)

  REAL, POINTER, DIMENSION(:)   :: XTEB_SOILGRID      ! vertical grid for roads
!
! Geometric Parameters:
!
  REAL, POINTER, DIMENSION(:)   :: XROAD_DIR     ! Road direction (deg from North, clockwise)
  REAL, POINTER, DIMENSION(:)   :: XGARDEN       ! fraction of veg in the streets   (-)
  REAL, POINTER, DIMENSION(:)   :: XGREENROOF    ! fraction of greenroofs on roofs  (-)
  REAL, POINTER, DIMENSION(:)   :: XFRAC_HVEG    ! fraction of high vegetation      (-)
  REAL, POINTER, DIMENSION(:)   :: XFRAC_LVEG    ! fraction of high vegetation      (-)
  REAL, POINTER, DIMENSION(:)   :: XFRAC_NVEG    ! fraction of high vegetation      (-)
  REAL, POINTER, DIMENSION(:)   :: XBLD          ! fraction of buildings            (-)
  REAL, POINTER, DIMENSION(:)   :: XROAD         ! fraction of roads                (-)
  REAL, POINTER, DIMENSION(:)   :: XCAN_HW_RATIO ! canyon    h/W                    (-)
  REAL, POINTER, DIMENSION(:)   :: XBLD_HEIGHT   ! buildings height 'h'             (m)
  REAL, POINTER, DIMENSION(:)   :: XWALL_O_HOR   ! wall surf. / hor. surf.          (-)
  REAL, POINTER, DIMENSION(:)   :: XROAD_O_GRND  ! road surf. / (road + garden surf.) (-)
  REAL, POINTER, DIMENSION(:)   :: XGARDEN_O_GRND! gard. surf. / (road + garden surf.)(-)
  REAL, POINTER, DIMENSION(:)   :: XWALL_O_GRND  ! wall surf. / (road + garden surf.) (-)
  REAL, POINTER, DIMENSION(:)   :: XWALL_O_BLD   ! wall surf. / bld surf. (-)
  REAL, POINTER, DIMENSION(:)   :: XZ0_TOWN      ! roughness length for momentum    (m)
  REAL, POINTER, DIMENSION(:)   :: XSVF_RS     ! road sky view factor             (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_WS     ! wall sky view factor             (-)
  ! Sview view factors for street trees
  REAL, POINTER, DIMENSION(:)   :: XSVF_RW     ! view factor of wall from road                           (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_RT     ! view factor of high veg from road                       (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_WR     ! view factor of road from wall                           (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_WW     ! view factor of wall from wall                           (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_WT     ! view factor of hv from wall                             (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_TS     ! sky-view factor of high veg                             (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_TR     ! view factor of road by high veg                         (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_TW     ! view factor of wall by high veg                         (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_ST     ! view factor of high veg from sky                        (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_SR     ! view factor of road from sky                            (-)
  REAL, POINTER, DIMENSION(:)   :: XSVF_SW     ! view factor of wall from sky                            (-)
     
          
!
! Roof parameters
!
  REAL, POINTER, DIMENSION(:)   :: XALB_ROOF     ! roof albedo                      (-)
  REAL, POINTER, DIMENSION(:)   :: XEMIS_ROOF    ! roof emissivity                  (-)
  REAL, POINTER, DIMENSION(:,:) :: XHC_ROOF      ! roof layers heat capacity        (J/K/m3)
  REAL, POINTER, DIMENSION(:,:) :: XTC_ROOF      ! roof layers thermal conductivity (W/K/m)
  REAL, POINTER, DIMENSION(:,:) :: XD_ROOF       ! thickness of roof layers         (m)
  REAL, POINTER, DIMENSION(:)   :: XROUGH_ROOF   ! roof roughness coef
!
! Road parameters
!
  REAL, POINTER, DIMENSION(:)   :: XALB_ROAD     ! road albedo                      (-)
  REAL, POINTER, DIMENSION(:)   :: XEMIS_ROAD    ! road emissivity                  (-)
  REAL, POINTER, DIMENSION(:,:) :: XHC_ROAD      ! road layers heat capacity        (J/K/m3)
  REAL, POINTER, DIMENSION(:,:) :: XTC_ROAD      ! road layers thermal conductivity (W/K/m)
  REAL, POINTER, DIMENSION(:,:) :: XD_ROAD       ! thickness of road layers         (m)
  REAL, POINTER, DIMENSION(:,:) :: XDG_ROAD      ! depth     of road layers         (m)
!
! Wall parameters
!
  REAL, POINTER, DIMENSION(:)   :: XALB_WALL     ! wall albedo                      (-)
  REAL, POINTER, DIMENSION(:)   :: XEMIS_WALL    ! wall emissivity                  (-)
  REAL, POINTER, DIMENSION(:,:) :: XHC_WALL      ! wall layers heat capacity        (J/K/m3)
  REAL, POINTER, DIMENSION(:,:) :: XTC_WALL      ! wall layers thermal conductivity (W/K/m)
  REAL, POINTER, DIMENSION(:,:) :: XD_WALL       ! thickness of wall layers         (m)
  REAL, POINTER, DIMENSION(:)   :: XROUGH_WALL   ! wall roughness coef
!
! Soil parameters under buildings
!
  REAL, POINTER, DIMENSION(:,:) :: XHC_BLD       ! soil layers heat capacity        (J/K/m3)
  REAL, POINTER, DIMENSION(:,:) :: XTC_BLD       ! soil layers thermal conductivity (W/K/m)
  REAL, POINTER, DIMENSION(:,:) :: XD_BLD        ! thickness of soil layers         (m)
  REAL, POINTER, DIMENSION(:,:) :: XDG_BLD       ! depth     of soil layers         (m)
  REAL, POINTER, DIMENSION(:,:) :: XHC_ALLBLD    ! soil layers heat capacity        (J/K/m3)
  REAL, POINTER, DIMENSION(:,:) :: XTC_ALLBLD    ! soil layers thermal conductivity (W/K/m)
  REAL, POINTER, DIMENSION(:,:) :: XD_ALLBLD     ! thickness of soil layers         (m)
!
! New soil parameters for road and building soil columns
!
  REAL, POINTER, DIMENSION(:,:) :: XSAND_ROAD    ! sand fraction                                   (-)
  REAL, POINTER, DIMENSION(:,:) :: XCLAY_ROAD    ! clay fraction                                   (-)
  REAL, POINTER, DIMENSION(:,:) :: XWFC_ROAD     ! field capacity volumetric water content profile (m3/m3)
  REAL, POINTER, DIMENSION(:,:) :: XWWILT_ROAD   ! wilting point volumetric water content profile  (m3/m3)        
  REAL, POINTER, DIMENSION(:,:) :: XWSAT_ROAD    ! porosity profile                                (m3/m3) 
  REAL, POINTER, DIMENSION(:,:) :: XBCOEF_ROAD   ! soil water CH78 b-parameter                     (-)
  REAL, POINTER, DIMENSION(:,:) :: XCONDSAT_ROAD ! hydraulic conductivity at saturation            (m/s)
  REAL, POINTER, DIMENSION(:,:) :: XMPOTSAT_ROAD ! matric potential at saturation                  (m)
  REAL, POINTER, DIMENSION(:,:) :: XCONDDRY_ROAD ! Thermal conductivity for dry soil               (W/m/s)
  REAL, POINTER, DIMENSION(:,:) :: XCONDSLD_ROAD ! Thermal conductivity for soil solids            (W/m/s)
  REAL, POINTER, DIMENSION(:,:) :: XHCAPSOIL_ROAD! Heat capacity                                   (J/m3/K)
!
  REAL, POINTER, DIMENSION(:,:) :: XSAND_BLD     ! sand fraction                                   (-)
  REAL, POINTER, DIMENSION(:,:) :: XCLAY_BLD     ! clay fraction                                   (-)
  REAL, POINTER, DIMENSION(:,:) :: XWFC_BLD      ! field capacity volumetric water content profile (m3/m3)
  REAL, POINTER, DIMENSION(:,:) :: XWWILT_BLD    ! wilting point volumetric water content profile  (m3/m3)        
  REAL, POINTER, DIMENSION(:,:) :: XWSAT_BLD     ! porosity profile                                (m3/m3) 
  REAL, POINTER, DIMENSION(:,:) :: XBCOEF_BLD    ! soil water CH78 b-parameter                     (-)
  REAL, POINTER, DIMENSION(:,:) :: XCONDSAT_BLD  ! hydraulic conductivity at saturation            (m/s)
  REAL, POINTER, DIMENSION(:,:) :: XMPOTSAT_BLD  ! matric potential at saturation                  (m)
  REAL, POINTER, DIMENSION(:,:) :: XCONDDRY_BLD  ! Thermal conductivity for dry soil               (W/m/s)
  REAL, POINTER, DIMENSION(:,:) :: XCONDSLD_BLD  ! Thermal conductivity for soil solids            (W/m/s)
  REAL, POINTER, DIMENSION(:,:) :: XHCAPSOIL_BLD ! Heat capacity                                   (J/m3/K)
!
! anthropogenic fluxes
!
  REAL, POINTER, DIMENSION(:)   :: XH_TRAFFIC    ! anthropogenic sensible
!                                                  ! heat fluxes due to traffic       (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_TRAFFIC   ! anthropogenic latent
!                                                  ! heat fluxes due to traffic       (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_INDUSTRY   ! anthropogenic sensible                   
!                                                  ! heat fluxes due to factories     (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_INDUSTRY  ! anthropogenic latent
!                                                  ! heat fluxes due to factories     (W/m2)
!
! temperatures for boundary conditions
!
  REAL, POINTER, DIMENSION(:)   :: XTI_ROAD      ! road interior temperature        (K)
!
! Prognostic variables:
!
  REAL, POINTER, DIMENSION(:)   :: XWS_ROOF      ! roof water reservoir             (kg/m2)
  REAL, POINTER, DIMENSION(:)   :: XWS_ROAD      ! road water reservoir             (kg/m2)
  REAL, POINTER, DIMENSION(:,:) :: XT_ROOF       ! roof layer temperatures          (K)
  REAL, POINTER, DIMENSION(:,:) :: XT_ROAD       ! road layer temperatures          (K)
  REAL, POINTER, DIMENSION(:,:) :: XT_WALL_A     ! wall layer temperatures          (K)
  REAL, POINTER, DIMENSION(:,:) :: XT_WALL_B     ! wall layer temperatures          (K)
  REAL, POINTER, DIMENSION(:,:,:) :: XT_BLD      ! soil layer temperatures under buildings(K)
  REAL, POINTER, DIMENSION(:,:,:) :: XT_ALLBLD   ! floor+soil layer temperatures for buildings(K)
!
  REAL, POINTER, DIMENSION(:)   :: XAC_ROOF      ! roof aerodynamic conductance     ()
  REAL, POINTER, DIMENSION(:)   :: XAC_ROAD      ! road aerodynamic conductance     ()
  REAL, POINTER, DIMENSION(:)   :: XAC_WALL      ! wall aerodynamic conductance     ()
  REAL, POINTER, DIMENSION(:)   :: XAC_TOP       ! top  aerodynamic conductance     ()
  REAL, POINTER, DIMENSION(:)   :: XAC_ROOF_WAT  ! water aerodynamic conductance    ()
  REAL, POINTER, DIMENSION(:)   :: XAC_ROAD_WAT  ! water aerodynamic conductance    ()
!
  REAL, POINTER, DIMENSION(:)   :: XQSAT_ROOF    ! humidity of saturation for roofs (kg/kg)
  REAL, POINTER, DIMENSION(:)   :: XQSAT_ROAD    ! humidity of saturation for roads (kg/kg)
!
  REAL, POINTER, DIMENSION(:)   :: XDELT_ROOF    ! humidity of saturation for roofs (-)
  REAL, POINTER, DIMENSION(:)   :: XDELT_ROAD    ! humidity of saturation for roads (-)
!
! Semi-prognostic variables:
!
  REAL, POINTER, DIMENSION(:)   :: XT_CANYON     ! canyon air temperature           (K)
  REAL, POINTER, DIMENSION(:)   :: XQ_CANYON     ! canyon air specific humidity     (kg/kg)
!
! Variables related with energy and moisture storage
!
  REAL, POINTER, DIMENSION(:) :: XTHEWALL
  REAL, POINTER, DIMENSION(:) :: XTHEROOF
  REAL, POINTER, DIMENSION(:) :: XTHEFLOOR
  REAL, POINTER, DIMENSION(:) :: XTHEMASS
  REAL, POINTER, DIMENSION(:) :: XTHEROAD
  REAL, POINTER, DIMENSION(:) :: XTHEAIRIN
  REAL, POINTER, DIMENSION(:) :: XTHETOTAL
  REAL, POINTER, DIMENSION(:) :: XLATWATROOF
  REAL, POINTER, DIMENSION(:) :: XLATWATROAD
  REAL, POINTER, DIMENSION(:) :: XLATICEROOF
  REAL, POINTER, DIMENSION(:) :: XLATICEROAD
  REAL, POINTER, DIMENSION(:) :: XLATAIRIN
  REAL, POINTER, DIMENSION(:) :: XLATTOTAL
  REAL, POINTER, DIMENSION(:) :: XENETOTAL         
!
! Prognostic snow:
!
  TYPE(SURF_SNOW)                 :: TSNOW_ROOF      ! snow state on roofs: 
!                                                  ! scheme type/option               (-)
!                                                  ! number of layers                 (-)
!                                                  ! snow (& liq. water) content      (kg/m2)
!                                                  ! heat content                     (J/m2)
!                                                  ! temperature                      (K)
!                                                  ! density                          (kg m-3)
  TYPE(SURF_SNOW)                 :: TSNOW_ROAD      ! snow state on roads: 
!                                                  ! scheme type/option               (-)
!                                                  ! number of layers                 (-)
!                                                  ! snow (& liq. water) content      (kg/m2)
!                                                  ! heat content                     (J/m2)
!                                                  ! temperature                      (K)
!                                                  ! density                          (kg m-3)
!                                                  ! density                          (kg m-3)
  TYPE(SURF_SNOW)                 :: TSNOW_GARDEN    ! snow state on green areas:
!                                                  ! scheme type/option               (-)
!                                                  ! number of layers                 (-)
!                                                  ! snow (& liq. water) content      (kg/m2)
!                                                  ! heat content                     (J/m2)
!                                                  ! temperature                      (K)
!                                                  ! density                          (kg m-3)
!
!
! Variables for CO2 flux calculus
  REAL, POINTER, DIMENSION(:) :: XNB_POP           ! Number of people per square kilometer
  REAL, POINTER, DIMENSION(:) :: XSFCO2_RD         ! CO2 flux link to traffic (roads) (kg/m2 of town/s)
  REAL, POINTER, DIMENSION(:,:) :: XDELTA_LEGAL_TIME ! difference between UTC and legal time (in hour)
  TYPE(DATE_TIME), POINTER, DIMENSION(:) :: XTIME_OF_CHANGE   ! time of time change of the legal hour
  INTEGER :: NDELTA_LEGAL_TIME            ! current indice of legal time array

END TYPE TEB_1P_t

TYPE TEB_t
  !
  TYPE(TEB_1P_t), POINTER :: ALP(:) => NULL()
  TYPE(TEB_1P_t), POINTER :: CUR => NULL()
  !
END TYPE TEB_t
!


CONTAINS
!----------------------------------------------------------------------------
!
!


!
!
SUBROUTINE TEB_GOTO_PATCH(YTEB,KTO_PATCH)
TYPE(TEB_t), INTENT(INOUT) :: YTEB
INTEGER, INTENT(IN) :: KTO_PATCH
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
! Current patch is set to patch KTO_PATCH
IF (LHOOK) CALL DR_HOOK('MODD_TEB_N:TEB_GOTO_PATCH',0,ZHOOK_HANDLE)

YTEB%CUR => YTEB%ALP(KTO_PATCH)

IF (LHOOK) CALL DR_HOOK('MODD_TEB_N:TEB_GOTO_PATCH',1,ZHOOK_HANDLE)
!
END SUBROUTINE TEB_GOTO_PATCH
!
SUBROUTINE TEB_INIT(YTEB,KPATCH)
TYPE(TEB_t), INTENT(INOUT) :: YTEB
INTEGER, INTENT(IN) :: KPATCH
INTEGER :: JP
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_TEB_N:TEB_INIT",0,ZHOOK_HANDLE)
 ALLOCATE(YTEB%ALP(KPATCH))
 YTEB%CUR => YTEB%ALP(1)
DO JP=1,KPATCH
  NULLIFY(YTEB%ALP(JP)%XTEB_SOILGRID)
  NULLIFY(YTEB%ALP(JP)%XROAD_DIR)
  NULLIFY(YTEB%ALP(JP)%XGARDEN)
  NULLIFY(YTEB%ALP(JP)%XGREENROOF)
  NULLIFY(YTEB%ALP(JP)%XFRAC_HVEG)
  NULLIFY(YTEB%ALP(JP)%XFRAC_LVEG)
  NULLIFY(YTEB%ALP(JP)%XFRAC_NVEG)
  NULLIFY(YTEB%ALP(JP)%XBLD)
  NULLIFY(YTEB%ALP(JP)%XROAD)
  NULLIFY(YTEB%ALP(JP)%XCAN_HW_RATIO)
  NULLIFY(YTEB%ALP(JP)%XBLD_HEIGHT)
  NULLIFY(YTEB%ALP(JP)%XWALL_O_HOR)
  NULLIFY(YTEB%ALP(JP)%XROAD_O_GRND)
  NULLIFY(YTEB%ALP(JP)%XGARDEN_O_GRND)
  NULLIFY(YTEB%ALP(JP)%XWALL_O_GRND)
  NULLIFY(YTEB%ALP(JP)%XWALL_O_BLD)
  NULLIFY(YTEB%ALP(JP)%XZ0_TOWN)
  NULLIFY(YTEB%ALP(JP)%XSVF_RS)
  NULLIFY(YTEB%ALP(JP)%XSVF_WS)
  NULLIFY(YTEB%ALP(JP)%XSVF_RW)
  NULLIFY(YTEB%ALP(JP)%XSVF_RT)
  NULLIFY(YTEB%ALP(JP)%XSVF_WR)
  NULLIFY(YTEB%ALP(JP)%XSVF_WW)
  NULLIFY(YTEB%ALP(JP)%XSVF_WT)
  NULLIFY(YTEB%ALP(JP)%XSVF_TS)
  NULLIFY(YTEB%ALP(JP)%XSVF_TR)
  NULLIFY(YTEB%ALP(JP)%XSVF_TW)
  NULLIFY(YTEB%ALP(JP)%XSVF_ST)
  NULLIFY(YTEB%ALP(JP)%XSVF_SR)
  NULLIFY(YTEB%ALP(JP)%XSVF_SW)
  NULLIFY(YTEB%ALP(JP)%XALB_ROOF)
  NULLIFY(YTEB%ALP(JP)%XEMIS_ROOF)
  NULLIFY(YTEB%ALP(JP)%XHC_ROOF)
  NULLIFY(YTEB%ALP(JP)%XTC_ROOF)
  NULLIFY(YTEB%ALP(JP)%XD_ROOF)
  NULLIFY(YTEB%ALP(JP)%XALB_ROAD)
  NULLIFY(YTEB%ALP(JP)%XEMIS_ROAD)
  NULLIFY(YTEB%ALP(JP)%XHC_ROAD)
  NULLIFY(YTEB%ALP(JP)%XTC_ROAD)
  NULLIFY(YTEB%ALP(JP)%XD_ROAD)
  NULLIFY(YTEB%ALP(JP)%XDG_ROAD)
  NULLIFY(YTEB%ALP(JP)%XALB_WALL)
  NULLIFY(YTEB%ALP(JP)%XEMIS_WALL)
  NULLIFY(YTEB%ALP(JP)%XHC_WALL)
  NULLIFY(YTEB%ALP(JP)%XTC_WALL)
  NULLIFY(YTEB%ALP(JP)%XD_WALL)
  NULLIFY(YTEB%ALP(JP)%XH_TRAFFIC)
  NULLIFY(YTEB%ALP(JP)%XLE_TRAFFIC)
  NULLIFY(YTEB%ALP(JP)%XH_INDUSTRY)
  NULLIFY(YTEB%ALP(JP)%XLE_INDUSTRY)
  NULLIFY(YTEB%ALP(JP)%XTI_ROAD)
  NULLIFY(YTEB%ALP(JP)%XWS_ROOF)
  NULLIFY(YTEB%ALP(JP)%XWS_ROAD)
  NULLIFY(YTEB%ALP(JP)%XT_ROOF)
  NULLIFY(YTEB%ALP(JP)%XT_ROAD)
  NULLIFY(YTEB%ALP(JP)%XT_WALL_A)
  NULLIFY(YTEB%ALP(JP)%XT_WALL_B)
  NULLIFY(YTEB%ALP(JP)%XT_BLD)
  NULLIFY(YTEB%ALP(JP)%XT_ALLBLD)
  NULLIFY(YTEB%ALP(JP)%XAC_ROOF)
  NULLIFY(YTEB%ALP(JP)%XAC_ROAD)
  NULLIFY(YTEB%ALP(JP)%XAC_WALL)
  NULLIFY(YTEB%ALP(JP)%XAC_TOP)
  NULLIFY(YTEB%ALP(JP)%XAC_ROOF_WAT)
  NULLIFY(YTEB%ALP(JP)%XAC_ROAD_WAT)
  NULLIFY(YTEB%ALP(JP)%XQSAT_ROOF)
  NULLIFY(YTEB%ALP(JP)%XQSAT_ROAD)
  NULLIFY(YTEB%ALP(JP)%XDELT_ROOF)
  NULLIFY(YTEB%ALP(JP)%XDELT_ROAD)
  NULLIFY(YTEB%ALP(JP)%XT_CANYON)
  NULLIFY(YTEB%ALP(JP)%XQ_CANYON)
  NULLIFY(YTEB%ALP(JP)%XROUGH_ROOF)
  NULLIFY(YTEB%ALP(JP)%XROUGH_WALL)
  !
  NULLIFY(YTEB%ALP(JP)%XSAND_ROAD)
  NULLIFY(YTEB%ALP(JP)%XCLAY_ROAD)
  NULLIFY(YTEB%ALP(JP)%XWFC_ROAD)
  NULLIFY(YTEB%ALP(JP)%XWWILT_ROAD)
  NULLIFY(YTEB%ALP(JP)%XWSAT_ROAD)
  NULLIFY(YTEB%ALP(JP)%XBCOEF_ROAD)
  NULLIFY(YTEB%ALP(JP)%XCONDSAT_ROAD)
  NULLIFY(YTEB%ALP(JP)%XMPOTSAT_ROAD)
  NULLIFY(YTEB%ALP(JP)%XCONDDRY_ROAD)
  NULLIFY(YTEB%ALP(JP)%XCONDSLD_ROAD)
  NULLIFY(YTEB%ALP(JP)%XHCAPSOIL_ROAD)
  !
  NULLIFY(YTEB%ALP(JP)%XHC_BLD)
  NULLIFY(YTEB%ALP(JP)%XTC_BLD)
  NULLIFY(YTEB%ALP(JP)%XD_BLD)
  NULLIFY(YTEB%ALP(JP)%XDG_BLD)
  NULLIFY(YTEB%ALP(JP)%XSAND_BLD)
  NULLIFY(YTEB%ALP(JP)%XCLAY_BLD)
  NULLIFY(YTEB%ALP(JP)%XWFC_BLD)
  NULLIFY(YTEB%ALP(JP)%XWWILT_BLD)
  NULLIFY(YTEB%ALP(JP)%XWSAT_BLD)
  NULLIFY(YTEB%ALP(JP)%XBCOEF_BLD)
  NULLIFY(YTEB%ALP(JP)%XCONDSAT_BLD)
  NULLIFY(YTEB%ALP(JP)%XMPOTSAT_BLD)
  NULLIFY(YTEB%ALP(JP)%XCONDDRY_BLD)
  NULLIFY(YTEB%ALP(JP)%XCONDSLD_BLD)
  NULLIFY(YTEB%ALP(JP)%XHCAPSOIL_BLD)
  NULLIFY(YTEB%ALP(JP)%XHC_ALLBLD)
  NULLIFY(YTEB%ALP(JP)%XTC_ALLBLD)
  NULLIFY(YTEB%ALP(JP)%XD_ALLBLD)
  NULLIFY(YTEB%ALP(JP)%XTHEWALL)
  NULLIFY(YTEB%ALP(JP)%XTHEROOF)
  NULLIFY(YTEB%ALP(JP)%XTHEFLOOR)
  NULLIFY(YTEB%ALP(JP)%XTHEMASS)
  NULLIFY(YTEB%ALP(JP)%XTHEROAD)
  NULLIFY(YTEB%ALP(JP)%XTHEAIRIN)
  NULLIFY(YTEB%ALP(JP)%XTHETOTAL)
  NULLIFY(YTEB%ALP(JP)%XLATWATROOF)
  NULLIFY(YTEB%ALP(JP)%XLATWATROAD)
  NULLIFY(YTEB%ALP(JP)%XLATICEROOF)
  NULLIFY(YTEB%ALP(JP)%XLATICEROAD)
  NULLIFY(YTEB%ALP(JP)%XLATAIRIN)
  NULLIFY(YTEB%ALP(JP)%XLATTOTAL)
  NULLIFY(YTEB%ALP(JP)%XENETOTAL)
  !
  NULLIFY(YTEB%ALP(JP)%XNB_POP)
  NULLIFY(YTEB%ALP(JP)%XSFCO2_RD)
  NULLIFY(YTEB%ALP(JP)%XDELTA_LEGAL_TIME)
  NULLIFY(YTEB%ALP(JP)%XTIME_OF_CHANGE)
ENDDO 
!
YTEB%ALP(:)%NTEB_ROAD=0.
YTEB%ALP(:)%NTEB_SOIL=0.
YTEB%ALP(:)%NDELTA_LEGAL_TIME=1.
!
IF (LHOOK) CALL DR_HOOK("MODD_TEB_N:TEB_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE TEB_INIT


END MODULE MODD_TEB_n
