!##################
MODULE MODD_TEB_HYDRO_n
!##################
!
!!****  *MODD_TEB_HYDRO - declaration of ISBA scheme packed surface parameters for urban hydrology
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      A. Lemonsu *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       09/2009
!!      V. Masson       06/2013  splits module in 4
!!
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

TYPE TEB_HYDRO_1P_t
!-------------------------------------------------------------------------------
!
! Prognostic variables:
!
! - Soil heat and water:
!
  REAL, POINTER, DIMENSION(:,:)  :: XWG_ROAD          ! soil volumetric water content profile                       (m3/m3)
  REAL, POINTER, DIMENSION(:,:)  :: XWGI_ROAD         ! soil liquid water equivalent volumetric ice content profile (m3/m3)
  REAL, POINTER, DIMENSION(:,:)  :: XWG_BLD           ! soil volumetric water content profile                       (m3/m3)
  REAL, POINTER, DIMENSION(:,:)  :: XWGI_BLD          ! soil liquid water equivalent volumetric ice content profile (m3/m3)
!  REAL, POINTER, DIMENSION(:)    :: XRUNOFFSOIL_ROAD  ! runoff for road 
!  REAL, POINTER, DIMENSION(:)    :: XDRAIN_ROAD       ! drainage for road 
!  REAL, POINTER, DIMENSION(:)    :: XRUNOFFSOIL_BLD   ! runoff for bld
!  REAL, POINTER, DIMENSION(:)    :: XDRAIN_BLD        ! drainage for bld
  REAL, POINTER, DIMENSION(:)    :: XKSAT_ICE         ! hydraulic conductivity at saturation over frozen area (m s-1)                                     
  REAL, POINTER, DIMENSION(:)    :: XNOC              ! impervious surface runoff not connected to sewer (kg/m2/s)
!-------------------------------------------------------------------------------
!
END TYPE TEB_HYDRO_1P_t
!
TYPE TEB_HYDRO_t
  !
  TYPE(TEB_HYDRO_1P_t), POINTER :: ALP(:) => NULL()
  TYPE(TEB_HYDRO_1P_t), POINTER :: CUR => NULL()
  !
END TYPE TEB_HYDRO_t
!
CONTAINS
!
!
SUBROUTINE TEB_HYDRO_GOTO_PATCH(YTEB_HYDRO,KTO_PATCH)
        TYPE(TEB_HYDRO_t), INTENT(INOUT) :: YTEB_HYDRO
INTEGER, INTENT(IN) :: KTO_PATCH
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
! Current patch is set to patch KTO_PATCH
IF (LHOOK) CALL DR_HOOK('MODD_TEB_HYDRO_N:TEB_HYDRO_GOTO_PATCH',0,ZHOOK_HANDLE)

YTEB_HYDRO%CUR => YTEB_HYDRO%ALP(KTO_PATCH)

IF (LHOOK) CALL DR_HOOK('MODD_TEB_HYDRO_N:TEB_HYDRO_GOTO_PATCH',1,ZHOOK_HANDLE)
!
END SUBROUTINE TEB_HYDRO_GOTO_PATCH
!
SUBROUTINE TEB_HYDRO_INIT(YTEB_HYDRO,KPATCH)
TYPE(TEB_HYDRO_t), INTENT(INOUT) :: YTEB_HYDRO
INTEGER, INTENT(IN) :: KPATCH
INTEGER :: JP
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_TEB_HYDRO_N:TEB_HYDRO_INIT",0,ZHOOK_HANDLE)
 ALLOCATE(YTEB_HYDRO%ALP(KPATCH))
 YTEB_HYDRO%CUR => YTEB_HYDRO%ALP(1)
DO JP=1,KPATCH
  NULLIFY(YTEB_HYDRO%ALP(JP)%XWG_ROAD)
  NULLIFY(YTEB_HYDRO%ALP(JP)%XWGI_ROAD)
  NULLIFY(YTEB_HYDRO%ALP(JP)%XWG_BLD)
  NULLIFY(YTEB_HYDRO%ALP(JP)%XWGI_BLD)
!  NULLIFY(YTEB_HYDRO%ALP(JP)%XRUNOFFSOIL_ROAD)
!  NULLIFY(YTEB_HYDRO%ALP(JP)%XDRAIN_ROAD)
!  NULLIFY(YTEB_HYDRO%ALP(JP)%XRUNOFFSOIL_BLD)
!  NULLIFY(YTEB_HYDRO%ALP(JP)%XDRAIN_BLD)
  NULLIFY(YTEB_HYDRO%ALP(JP)%XKSAT_ICE)
  NULLIFY(YTEB_HYDRO%ALP(JP)%XNOC)
ENDDO 
IF (LHOOK) CALL DR_HOOK("MODD_TEB_HYDRO_N:TEB_HYDRO_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE TEB_HYDRO_INIT


END MODULE MODD_TEB_HYDRO_n
