!     ###########################
      MODULE MODD_DIAG_UTCI_ISBA_n
!     ############################
!
!!****  *MODD_DIAG_UTCI_ISBA - declaration of confort from ISBA scheme
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      R. Schoetter   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       29/03/2017
!
!
!*       0.   DECLARATIONS
!             ------------
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
TYPE DIAG_UTCI_ISBA_t
!------------------------------------------------------------------------------
!
  LOGICAL :: LUTCI                               ! flag to compute UTCI quantities
  INTEGER :: NCOUNT_UTCI_STEP                    ! Counter for UTCI
  REAL, POINTER, DIMENSION(:,:) :: XUTCI_IN      ! UTCI for person indoor
  REAL, POINTER, DIMENSION(:)   :: XUTCI_OUTSUN  ! UTCI for person outdoor at sun
  REAL, POINTER, DIMENSION(:)   :: XUTCI_OUTSHADE! UTCI for person outdoor at shade
  REAL, POINTER, DIMENSION(:)   :: XUTCI_OUTSUN_MEAN   ! Mean UTCI for person outdoor at sun
  REAL, POINTER, DIMENSION(:)   :: XUTCI_OUTSHADE_MEAN ! Mean UTCI for person outdoor at shade
  REAL, POINTER, DIMENSION(:)   :: XTRAD_SUN! Mean radiant temperature seen by person at sun (K)
  REAL, POINTER, DIMENSION(:)   :: XTRAD_SHADE! Mean radiant temperature seen by person in shade (K)
  REAL, POINTER, DIMENSION(:)   :: XTRAD_SUN_MEAN   ! Mean Mean radiant temperature seen by person at sun (K)
  REAL, POINTER, DIMENSION(:)   :: XTRAD_SHADE_MEAN ! Mean Mean radiant temperature seen by person in shade (K)
  REAL, POINTER, DIMENSION(:,:,:) :: XUTCIC_IN      ! Cumulated UTCI stress for person indoor
  REAL, POINTER, DIMENSION(:,:)   :: XUTCIC_OUTSUN  ! Cumulated UTCI stress for person outdoor at sun
  REAL, POINTER, DIMENSION(:,:)   :: XUTCIC_OUTSHADE! Cumulated UTCI stress for person outdoor at shade
!
END TYPE DIAG_UTCI_ISBA_t
!
CONTAINS
!
SUBROUTINE DIAG_UTCI_ISBA_INIT(YDIAG_UTCI_ISBA)
TYPE(DIAG_UTCI_ISBA_t), INTENT(INOUT) :: YDIAG_UTCI_ISBA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_UTCI_ISBA_N:DIAG_UTCI_ISBA_INIT",0,ZHOOK_HANDLE)
YDIAG_UTCI_ISBA%LUTCI=.FALSE.
YDIAG_UTCI_ISBA%NCOUNT_UTCI_STEP=0
  NULLIFY(YDIAG_UTCI_ISBA%XUTCI_IN)
  NULLIFY(YDIAG_UTCI_ISBA%XUTCI_OUTSUN)
  NULLIFY(YDIAG_UTCI_ISBA%XUTCI_OUTSHADE)
  NULLIFY(YDIAG_UTCI_ISBA%XUTCI_OUTSUN_MEAN)
  NULLIFY(YDIAG_UTCI_ISBA%XUTCI_OUTSHADE_MEAN)
  NULLIFY(YDIAG_UTCI_ISBA%XTRAD_SUN)
  NULLIFY(YDIAG_UTCI_ISBA%XTRAD_SHADE)
  NULLIFY(YDIAG_UTCI_ISBA%XTRAD_SUN_MEAN)
  NULLIFY(YDIAG_UTCI_ISBA%XTRAD_SHADE_MEAN)
  NULLIFY(YDIAG_UTCI_ISBA%XUTCIC_IN)
  NULLIFY(YDIAG_UTCI_ISBA%XUTCIC_OUTSUN)
  NULLIFY(YDIAG_UTCI_ISBA%XUTCIC_OUTSHADE)
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_UTCI_ISBA_N:DIAG_UTCI_ISBA_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE DIAG_UTCI_ISBA_INIT
!
END MODULE MODD_DIAG_UTCI_ISBA_n
