!     ############################
      MODULE MODD_DIAG_MISC_TEB_n
!     ############################
!
!!****  *MODD_DIAG_MISC_TEB - declaration of packed surface parameters for TEB scheme
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      P. Le Moigne   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       07/10/04
!!      C de Munck     02/13  adding runoff contributions for teb garden  
!!      V. Masson      06/2013  splits module in two
!!      E. Redon, A. Lemonsu      12/2015 Short and longwave rad absorbed by urbtrees
!!      K. Chancibault/A. Lemonsu 01/2016 Urban hydrology
!!      M. Goret       07/2017 add new diagnostics for CO2 fluxes
!!      M. Goret       08/2017 add anthropogenic flux diagnostics
!!      M. Goret       09/2017 add diagnostic of heat storage link to snow
!!      M. Goret       10/2017 add diagnostic for hot water
!
!
!*       0.   DECLARATIONS
!             ------------
!
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
TYPE DIAG_MISC_TEB_1P_t
!
!* miscellaneous variables
!
  REAL, POINTER, DIMENSION(:)   :: XZ0_TOWN  ! town roughness length
  REAL, POINTER, DIMENSION(:)   :: XQF_BLD   ! domestic heating
  REAL, POINTER, DIMENSION(:)   :: XFLX_BLD ! heat flux from bld
  REAL, POINTER, DIMENSION(:)   :: XQF_TOWN  ! total anthropogenic heat
  REAL, POINTER, DIMENSION(:)   :: XDQS_TOWN ! storage inside building
!
  REAL, POINTER, DIMENSION(:)   :: XH_WALL_A   ! wall sensible heat flux          (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_WALL_B   ! wall sensible heat flux          (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_ROOF     ! roof sensible heat flux          (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_ROAD     ! road sensible heat flux          (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_GARDEN   ! green area sensible heat flux    (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_HVEG     ! high vegetation sensible heat flux (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_GREENROOF! green roof sensible heat flux    (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_STRLROOF ! structural roof sens. heat flux  (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_BLT      ! built surf sensible heat flux    (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_WALL_A  ! net radiation at wall            (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_WALL_B  ! net radiation at wall            (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_ROOF    ! net radiation at roof            (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_ROAD    ! net radiation at road            (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_GARDEN  ! net radiation at green areas     (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_GREENROOF!net radiation at green roofs     (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_STRLROOF !net radiation at structural roofs(W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_BLT     ! net radiation at built surf      (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_WALL_A !net wall conduction flux        (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_WALL_B !net wall conduction flux        (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_ROOF ! net roof conduction flux         (W/m2)                                         
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_ROAD ! net road conduction flux         (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_GARDEN!net green area conduction flux   (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_GREENROOF!net green roof conduction flux(W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_STRLROOF !net structural roof cond flux (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_BLT  ! net built surf conduction flux   (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_WALL_A  ! wall latent heat flux            (W/m2 façade)
  REAL, POINTER, DIMENSION(:)   :: XLE_WALL_B  ! wall latent heat flux            (W/m2 façade)
  REAL, POINTER, DIMENSION(:)   :: XLE_ROOF    ! roof latent heat flux            (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_ROAD    ! road latent heat flux            (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_GARDEN  ! green area latent heat flux      (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_HVEG    ! high vegetation latent heat flux (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_GREENROOF!green roof latent heat flux      (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_STRLROOF !structural roof latent heat flux (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE_BLT     ! built surf latent heat flux      (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XQF_WALL_A  ! wall anthropogenic flux      (W/m2 façade)
  REAL, POINTER, DIMENSION(:)   :: XQF_WALL_B  ! wall anthropogenic flux      (W/m2 façade)
  REAL, POINTER, DIMENSION(:)   :: XQF_ROAD    ! road anthropogenic flux      (W/m2 road)
  REAL, POINTER, DIMENSION(:)   :: XQF_ROOF    ! roof anthropogenic flux      (W/m2 roof)
  REAL, POINTER, DIMENSION(:)   :: XQF_BLT     ! mean anthropogenic flux due to build surfaces (W/m2 urb.)
  REAL, POINTER, DIMENSION(:)   :: XSNOW_HEAT_ROAD   !heat storage link to snow on road (W/m2 (road))
  REAL, POINTER, DIMENSION(:)   :: XSNOW_HEAT_ROOF   !heat storage link to snow on roof (W/m2 (roof))
!
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_TOWN      ! aggregated water runoff for town      (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_GARDEN    ! water runoff for green areas          (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XDRAIN_GARDEN     ! water vertical drainage for gardens   (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XIRRIG_GARDEN     ! summer ground irrigation rate         (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_ROAD      ! water runoff for roads                (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XIRRIG_ROAD       ! road man-made watering rate           (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_ROOF      ! aggregated water runoff for roofs     (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_STRLROOF  ! water runoff for structural roofs     (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_GREENROOF ! water runoff for greenroof            (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XDRAIN_GREENROOF  ! water vertical drainage for greenroof (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XIRRIG_GREENROOF  ! summer ground irrigation rate         (kg/m2/s)
!
! Urban hydrology
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_SEWER     ! groundwater runoff in all the sewers (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XDRAIN_ROAD       ! drainage from ground under road (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XDRAIN_BLD        ! drainage from ground under bld (kg/m2/s)
!  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_TOWNC     ! cumulated aggregated water runoff for town (kg/m2)
!  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_ROADC     ! cumulated water runoff over roads (kg/m2)
!  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_ROOFC     ! cumulated water runoff over roofs (kg/m2)
!  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_STRLROOFC ! cumulated water runoff for structural roofs (kg/m2)
!  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_GARDENC   ! cumulated water runoff for green areas      (kg/m2)
!  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_SEWERC    ! cumulated groundwater runoff into sewers (kg/m2)
  REAL, POINTER, DIMENSION(:)   :: XDIS_TOWN         ! Total town discharge (m3/s) on urban surfaces (XTOWN not taken into account)
  REAL, POINTER, DIMENSION(:)   :: XDIS_ROOF         ! Roof discharge (m3/s) on urban surfaces (XTOWN not taken into account)
  REAL, POINTER, DIMENSION(:)   :: XDIS_ROAD         ! Road discharge (m3/s) on urban surfaces (XTOWN not taken into account)
  REAL, POINTER, DIMENSION(:)   :: XDIS_GARDEN       ! Garden surface discharge (m3/s) on urban surfaces (XTOWN not taken into account)
  REAL, POINTER, DIMENSION(:)   :: XDIS_SEWER        ! soil infiltration dicharge into sewers (m3/s) on urban surfaces (XTOWN not taken into account)
!  REAL, POINTER, DIMENSION(:)   :: XDRAIN            ! soil draingae from garden (kg/m2/s)
! budget
  REAL, POINTER, DIMENSION(:)   :: XRAINB            !
  REAL, POINTER, DIMENSION(:)   :: XSNOWB            !
  REAL, POINTER, DIMENSION(:)   :: XLE_GARDENB       !
  REAL, POINTER, DIMENSION(:)   :: XLE_ROADB         !
  REAL, POINTER, DIMENSION(:)   :: XLE_STRLROOFB     !
  REAL, POINTER, DIMENSION(:)   :: XLE_GREENROOFB    !
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_TOWNB     !
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_GARDENB   !
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_ROADB     !
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_ROOFB     !
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_STRLROOFB !
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_GREENROOFB! cumulated water runoff for greenroofs (kg/m2)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFF_SEWERB    !
  REAL, POINTER, DIMENSION(:)   :: XDRAIN_ROADB      !
  REAL, POINTER, DIMENSION(:)   :: XDRAIN_BLDB       !
  REAL, POINTER, DIMENSION(:)   :: XDRAIN_GARDENB    !
  REAL, POINTER, DIMENSION(:,:) :: XWG_ROAD_INI
  REAL, POINTER, DIMENSION(:,:) :: XWG_BLD_INI
  REAL, POINTER, DIMENSION(:,:) :: XWG_GARDEN_INI
!
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_SKY       ! absorbed shortwave radiation by sky = reflected by the canyon
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_SKY       ! absorbed shortwave radiation by sky = reflected by the canyon
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_ROOF      ! absorbed shortwave radiation over roofs
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_SNOW_ROOF ! absorbed shortgwave radiation over roofs
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_ROOF      ! absorbed longwave radiation over roofs
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_SNOW_ROOF ! absorbed longwave radiation over roofs
  REAL, POINTER, DIMENSION(:)   :: XDIR_SW_ROAD      ! received direct shortwave radiation over roads
  REAL, POINTER, DIMENSION(:)   :: XSCA_SW_ROAD      ! received scattered shortwave radiation over roads
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_ROAD      ! absorbed shortwave radiation over roads
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_SNOW_ROAD ! absorbed longwave radiation over roads
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_ROAD      ! absorbed longwave radiation over roads
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_SNOW_ROAD ! absorbed longwave radiation over roads
  REAL, POINTER, DIMENSION(:)   :: XDIR_SW_WALL      ! received direct shortwave radiation over walls
  REAL, POINTER, DIMENSION(:)   :: XDIR_SW_WALL_A    ! received direct shortwave radiation over wall A
  REAL, POINTER, DIMENSION(:)   :: XDIR_SW_WALL_B    ! received direct shortwave radiation over wall B
  REAL, POINTER, DIMENSION(:)   :: XSCA_SW_WALL      ! received scattered shortwave radiation over walls
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_WALL_A    ! absorbed shortwave radiation over walls
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_WALL_B    ! absorbed shortwave radiation over walls
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_WALL_A    ! absorbed longwave radiation over walls
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_WALL_B    ! absorbed longwave radiation over walls
  REAL, POINTER, DIMENSION(:)   :: XDIR_SW_GARDEN    ! received direct shortwave radiation over roads
  REAL, POINTER, DIMENSION(:)   :: XSCA_SW_GARDEN    ! received scattered shortwave radiation over roads
  REAL, POINTER, DIMENSION(:)   :: XREC_SW_GARDEN    ! received shortwave radiation over green areas
  REAL, POINTER, DIMENSION(:)   :: XREC_LW_GARDEN    ! received longwave radiation over green areas
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_GARDEN    ! absorbed shortwave radiation over green areas
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_GARDEN    ! absorbed longwave radiation over green areas
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_GREENROOF ! absorbed shortwave radiation over green roofs
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_GREENROOF ! absorbed shortwave radiation over green roofs
  REAL, POINTER, DIMENSION(:)   :: XG_GREENROOF_ROOF ! Heat flux between green roof and structural roof
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_PANEL     ! absorbed shortwave radiation over solar panels
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_PANEL     ! absorbed longwave  radiation over solar panels
  REAL, POINTER, DIMENSION(:)   :: XDIR_SW_HVEG      ! received direct shortwave radiation over high vegetation
  REAL, POINTER, DIMENSION(:)   :: XNTR_DIR_SW_HVEG  ! received direct shortwave radiation over hveg corrected from transmission
  REAL, POINTER, DIMENSION(:)   :: XSCA_SW_HVEG      ! received scattered Downward shortwave radiation over high vegetation
  REAL, POINTER, DIMENSION(:)   :: XREC_SW_HVEG      ! received shortwave radiation by high vegetation
  REAL, POINTER, DIMENSION(:)   :: XREC_LW_HVEG      ! received longwave radiation by high vegetation
  REAL, POINTER, DIMENSION(:)   :: XABS_SW_HVEG      ! absorbed shortwave radiation by high vegetation
  REAL, POINTER, DIMENSION(:)   :: XABS_LW_HVEG      ! absorbed longwave radiation by high vegetation
  REAL, POINTER, DIMENSION(:)   :: XNET_LW_HVEG      ! IR rad absorbed by high vegetation
  REAL, POINTER, DIMENSION(:)   :: XREC_SW_VEG       ! received shortwave radiation by urban vegetation (garden + high veg)
  REAL, POINTER, DIMENSION(:)   :: XREC_LW_VEG       ! received longwave radiation by urban vegetation (garden + high veg)
  REAL, POINTER, DIMENSION(:)   :: XSW_UP_ROOF       ! reflected shortwave radiation by roof
  REAL, POINTER, DIMENSION(:)   :: XSW_UP_CAN        ! reflected longwave radiation by the canyon
  REAL, POINTER, DIMENSION(:)   :: XLW_UP_ROOF       ! emitted shortwave radiation by roof
  REAL, POINTER, DIMENSION(:)   :: XLW_UP_CAN        ! emitted longwave radiation by the canyon
!
  REAL, POINTER, DIMENSION(:)   :: XTS_HVEG          ! Foliar surface temperature of urban high vegetation (K)
!
  REAL, POINTER, DIMENSION(:)   :: XRN_PANEL         ! net radiation           over solar panels (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_PANEL          ! sensible heat flux      over solar panels (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XTHER_PROD_PANEL  ! thermal      production of   solar panels (W/m2 thermal panel)
  REAL, POINTER, DIMENSION(:)   :: XPHOT_PROD_PANEL  ! photovoltaic production of   solar panels (W/m2 photovoltaic panel)
  REAL, POINTER, DIMENSION(:)   :: XPROD_PANEL       !              production of   solar panels (W/m2 panel)
  REAL, POINTER, DIMENSION(:)   :: XTHER_PROD_BLD    ! thermal      production of   solar panels (W/m2 bld)
  REAL, POINTER, DIMENSION(:)   :: XPHOT_PROD_BLD    ! photovoltaic production of   solar panels (W/m2 bld)

  REAL, POINTER, DIMENSION(:)   :: XH_BLD_COOL       ! Sensible cooling energy demand  
                                                     ! of the building [W m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XLE_BLD_COOL      ! Latent cooling energy demand 
                                                     ! of the building [W m-2(bld)]
  REAL, POINTER, DIMENSION(:) :: XH_WASTE_CANY     ! Sensible waste heat released to canyon [W m-2(tot)]
  REAL, POINTER, DIMENSION(:) :: XLE_WASTE_CANY    ! Latent waste heat  released to canyon [W m-2(tot)]
  REAL, POINTER, DIMENSION(:) :: XH_WASTE_ROOF     ! Sensible waste heat released at roof level [W m-2(tot)]
  REAL, POINTER, DIMENSION(:) :: XLE_WASTE_ROOF    ! Latent waste heat  released at roof level [W m-2(tot)]
  REAL, POINTER, DIMENSION(:) :: XHVAC_COOL        ! Energy consumption of the cooling system [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XHVAC_HEAT        ! Energy consumption of the heating system [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XQINOUT           ! Internal energy release [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XHVAC_HEAT_ELEC   ! ELEC  Energy consumption of the heating system [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XHVAC_HEAT_GAS    ! GAS   Energy consumption of the heating system [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XHVAC_HEAT_FUEL   ! FUEL  Energy consumption of the heating system [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XHVAC_HEAT_OTHER  ! OTHER Energy consumption of the heating system [W m-2(urb)]
  REAL, POINTER, DIMENSION(:,:) :: XCOMP_HVAC_COOL   ! Energy consumption of the cooling system per compartment [W m-2(urb)]
  REAL, POINTER, DIMENSION(:,:) :: XCOMP_HVAC_HEAT   ! Energy consumption of the heating system per compartment [W m-2(urb)]
  REAL, POINTER, DIMENSION(:,:) :: XCOMP_QINOUT      ! Internal energy release per compartment  [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XH_TRAFFIC_OUT    ! Actual traffic sensible heat release [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XLE_TRAFFIC_OUT   ! Actual traffic latent   heat release [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XH_INDUSTRY_OUT   ! Actual industry sensible heat release [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XLE_INDUSTRY_OUT  ! Actual industry latent   heat release [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XSENFABSTOR       ! Sensible heat stored in urban fabric [W/m²(urb)]
  REAL, POINTER, DIMENSION(:) :: XLATFABSTOR       ! Latent heat stored on urban fabric [W/m²(urb)]
  REAL, POINTER, DIMENSION(:) :: XROOFTK           ! Total roof thickness [m]
  REAL, POINTER, DIMENSION(:) :: XWALLTK           ! Total wall thickness [m]
  REAL, POINTER, DIMENSION(:) :: XMASSTK           ! Total mass thickness [m]
  REAL, POINTER, DIMENSION(:) :: XU_LOWCAN         ! Wind speed at lowest level of canyon [m/s]
  REAL, POINTER, DIMENSION(:) :: XROAD_SHADE       ! Fraction of road shaded [1]
  REAL, POINTER, DIMENSION(:) :: XQIN_KWH          ! Internal heat release [kWh/m²(floor)]
  REAL, POINTER, DIMENSION(:) :: XHVAC_HT_KWH      ! Heating energy demand [kWh/m²(floor)]
  REAL, POINTER, DIMENSION(:) :: XHVAC_CL_KWH      ! Cooling energy demand [kWh/m²(floor)]
  REAL, POINTER, DIMENSION(:) :: XINFCALC          ! Calculated infiltration rate
  REAL, POINTER, DIMENSION(:,:) :: XDIAGSHAD         ! Diagnostic of shading usage
  REAL, POINTER, DIMENSION(:,:) :: XDIAGVENT         ! Diagnostic of ventilation status
  REAL, POINTER, DIMENSION(:,:) :: XDIAGVEFL         ! Diagnostic of ventilation exchange rate [1/h]
  REAL, POINTER, DIMENSION(:,:) :: XBLDOCC           ! Building occupation fraction [W m-2(bld)]
  REAL, POINTER, DIMENSION(:) :: XCAP_SYS          ! Actual capacity of the cooling system [W m-2(bld)] 
  REAL, POINTER, DIMENSION(:) :: XM_SYS            ! Actual HVAC mass flow rate [kg s-1 m-2(bld)]
  REAL, POINTER, DIMENSION(:) :: XCOP              ! COP of the cooling system
  REAL, POINTER, DIMENSION(:) :: XQ_SYS            ! Supply air specific humidity [kg kg-1]
  REAL, POINTER, DIMENSION(:) :: XT_SYS            ! Supply air temperature [K]
  REAL, POINTER, DIMENSION(:) :: XTR_SW_WIN        ! Solar radiation transmitted throught windows [W m-2(bld)]
  REAL, POINTER, DIMENSION(:) :: XABS_SW_WIN       ! window absorbed shortwave radiation [W m-2] 
  REAL, POINTER, DIMENSION(:) :: XABS_LW_WIN       ! absorbed infrared rad. [W m-2]
  REAL, POINTER, DIMENSION(:) :: XEMIT_LW_FAC      ! LW flux emitted by the facade (W/m2 facade)
  REAL, POINTER, DIMENSION(:) :: XEMIT_LW_GRND     ! LW flux emitted by the ground (W/m2 ground = road + garden)
  REAL, POINTER, DIMENSION(:) :: XT_RAD_IND        ! Indoor mean radiant temperature [K]
  REAL, POINTER, DIMENSION(:) :: XREF_SW_GRND      ! total solar rad reflected by ground
  REAL, POINTER, DIMENSION(:) :: XREF_SW_FAC       ! total solar rad reflected by facade
!
  REAL, POINTER, DIMENSION(:) :: XSFCO2_T          ! total CO2 flux over town         (kg/m2/s)
  REAL, POINTER, DIMENSION(:) :: XSFCO2_T_VEG      ! CO2 flux over town link to vegetation (kg/m2/s)
  REAL, POINTER, DIMENSION(:) :: XSFCO2_T_BLD      ! CO2 flux over town link to buildings  (kg/m2/s)
  REAL, POINTER, DIMENSION(:) :: XSFCO2_T_RD       ! CO2 flux over town link to roads      (kg/m2/s)
  REAL, POINTER, DIMENSION(:) :: XSFCO2_T_POP      ! CO2 flux over town link to people     (kg/m2/s)
!
  REAL, POINTER, DIMENSION(:) :: XHOTWAT           ! energy consumption for hot water [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XHOTWAT_GAS       ! gas consumption for hot water [W m-2(urb)]
  REAL, POINTER, DIMENSION(:) :: XHOTWAT_ELEC      ! elec consumption for hot water [W m-2(urb)]
  REAL, POINTER, DIMENSION(:,:) :: XCOMP_HOTWAT    ! Energy consumption for hot water per compartment [W m-2(urb)]
!------------------------------------------------------------------------------
!

END TYPE DIAG_MISC_TEB_1P_t

TYPE DIAG_MISC_TEB_t
  !
  TYPE(DIAG_MISC_TEB_1P_t), POINTER :: ALP(:) => NULL()
  TYPE(DIAG_MISC_TEB_1P_t), POINTER :: CUR => NULL()
  !
END TYPE DIAG_MISC_TEB_t
!
!
!
CONTAINS


!




SUBROUTINE DIAG_MISC_TEB_GOTO_PATCH(YDIAG_MISC_TEB,KTO_PATCH)
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: YDIAG_MISC_TEB
INTEGER, INTENT(IN) :: KTO_PATCH
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODD_DIAG_MISC_TEB_N:DIAG_MISC_TEB_GOTO_PATCH',0,ZHOOK_HANDLE)

YDIAG_MISC_TEB%CUR => YDIAG_MISC_TEB%ALP(KTO_PATCH)

IF (LHOOK) CALL DR_HOOK('MODD_DIAG_MISC_TEB_N:DIAG_MISC_TEB_GOTO_PATCH',1,ZHOOK_HANDLE)

END SUBROUTINE DIAG_MISC_TEB_GOTO_PATCH


SUBROUTINE DIAG_MISC_TEB_INIT(YDIAG_MISC_TEB,KPATCH)
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: YDIAG_MISC_TEB
INTEGER, INTENT(IN) :: KPATCH
INTEGER :: JP
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_MISC_TEB_N:DIAG_MISC_TEB_INIT",0,ZHOOK_HANDLE)
 ALLOCATE(YDIAG_MISC_TEB%ALP(KPATCH))
 YDIAG_MISC_TEB%CUR => YDIAG_MISC_TEB%ALP(1)
DO JP=1,KPATCH
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XZ0_TOWN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQF_BLD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XFLX_BLD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQF_TOWN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDQS_TOWN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_WALL_A)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_WALL_B)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_WALL_A)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_WALL_B)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_STRLROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_BLT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_WALL_A)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_WALL_B)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_STRLROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_BLT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XGFLUX_WALL_A)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XGFLUX_WALL_B)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XGFLUX_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XGFLUX_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XGFLUX_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XGFLUX_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XGFLUX_STRLROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XGFLUX_BLT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_STRLROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_BLT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQF_WALL_A)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQF_WALL_B)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQF_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQF_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQF_BLT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSNOW_HEAT_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSNOW_HEAT_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_TOWN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDRAIN_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XIRRIG_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XIRRIG_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_STRLROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDRAIN_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XIRRIG_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_SEWER)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDRAIN_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDRAIN_BLD)
!  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_TOWNC)
!  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_ROADC)
!  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_ROOFC)
!  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_STRLROOFC)
!  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_GARDENC)
!  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_SEWERC)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIS_TOWN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIS_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIS_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIS_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIS_SEWER)
!  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDRAIN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRAINB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSNOWB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_GARDENB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_ROADB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_STRLROOFB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_GREENROOFB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_TOWNB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_GARDENB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_ROADB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_ROOFB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_STRLROOFB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_GREENROOFB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRUNOFF_SEWERB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDRAIN_ROADB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDRAIN_BLDB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDRAIN_GARDENB)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XWG_ROAD_INI)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XWG_BLD_INI)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XWG_GARDEN_INI)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_SKY)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_SKY)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_SNOW_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_SNOW_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIR_SW_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSCA_SW_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_SNOW_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_SNOW_ROAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIR_SW_WALL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIR_SW_WALL_A)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIR_SW_WALL_B)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSCA_SW_WALL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_WALL_A)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_WALL_B)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_WALL_A)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_WALL_B)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XREC_SW_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XREC_LW_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_GARDEN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_GREENROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XG_GREENROOF_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_PANEL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_PANEL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIR_SW_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XNTR_DIR_SW_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSCA_SW_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XREC_SW_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XREC_LW_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XNET_LW_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XTS_HVEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XREC_SW_VEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XREC_LW_VEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSW_UP_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSW_UP_CAN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLW_UP_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLW_UP_CAN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XRN_PANEL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_PANEL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XTHER_PROD_PANEL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XPHOT_PROD_PANEL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XPROD_PANEL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XTHER_PROD_BLD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XPHOT_PROD_BLD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_BLD_COOL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_BLD_COOL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHVAC_COOL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHVAC_HEAT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHVAC_HEAT_ELEC)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHVAC_HEAT_GAS)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHVAC_HEAT_FUEL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHVAC_HEAT_OTHER)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XCOMP_HVAC_COOL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XCOMP_HVAC_HEAT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_WASTE_CANY)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_WASTE_CANY)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_WASTE_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_WASTE_ROOF)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQINOUT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XCOMP_QINOUT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_TRAFFIC_OUT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_TRAFFIC_OUT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XH_INDUSTRY_OUT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLE_INDUSTRY_OUT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSENFABSTOR)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XLATFABSTOR)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XROOFTK)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XWALLTK)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XMASSTK)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XU_LOWCAN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XROAD_SHADE)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQIN_KWH)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHVAC_HT_KWH)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHVAC_CL_KWH)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XINFCALC)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIAGSHAD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIAGVENT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XDIAGVEFL)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XBLDOCC)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XCAP_SYS)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XM_SYS)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XCOP)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XQ_SYS)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XT_SYS)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XTR_SW_WIN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_SW_WIN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XABS_LW_WIN)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XEMIT_LW_GRND)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XEMIT_LW_FAC)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XT_RAD_IND)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XREF_SW_GRND)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XREF_SW_FAC)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSFCO2_T)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSFCO2_T_VEG)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSFCO2_T_BLD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSFCO2_T_RD)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XSFCO2_T_POP)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHOTWAT)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHOTWAT_GAS)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XHOTWAT_ELEC)
  NULLIFY(YDIAG_MISC_TEB%ALP(JP)%XCOMP_HOTWAT)
ENDDO 
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_MISC_TEB_N:DIAG_MISC_TEB_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE DIAG_MISC_TEB_INIT



END MODULE MODD_DIAG_MISC_TEB_n
